﻿<%@ Page Title="Commit Backup Storage" Language="C#" MasterPageFile="~/WebAppPanel.Master"
    AutoEventWireup="true" CodeBehind="CommitEnableCloudBackup.aspx.cs" Inherits="GladinetPayFlow.CommitEnableCloudBackup" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
    </style>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocFaiToVer" meta:resourcekey="str_faiToVer" Visible="false" runat="server">Failed to verify</asp:Localize>
<asp:Localize ID="LocUnk" meta:resourcekey="str_unk" Visible="false" runat="server">Unknown</asp:Localize>
<asp:Localize ID="LocFaiToAssStoSpa" meta:resourcekey="str_faiToAssStoSpa" Visible="false" runat="server">Failed to assign storage space</asp:Localize>
<asp:Localize ID="LocFaiToCreBacTen" meta:resourcekey="str_faiToCreBacTen" Visible="false" runat="server">Failed to create backup tenant</asp:Localize>
<asp:Localize runat="server" ID="LocCskCldStg" meta:resourcekey="str_cskCldStg" Visible="false">CentreStack Cloud Storage</asp:Localize>
<asp:Localize runat="server" ID="LocBadCfg" meta:resourcekey="str_badCfg" Visible="false">Bad configuration</asp:Localize>
<asp:Localize runat="server" ID="LocLclDskFilShr" meta:resourcekey="str_lclDskFilShr" Visible="false">Local Disk/File Share:</asp:Localize>
<asp:Localize runat="server" ID="LocBadStgCfg" meta:resourcekey="str_badStgCfg" Visible="false">Bad storage configuration</asp:Localize>
<asp:Localize runat="server" ID="LocDreEblPwdMsg" meta:resourcekey="str_dreEblPwdMsg" Visible="false">Data-at-Rest Encryption is enabled but the password is missing</asp:Localize>
<asp:Localize runat="server" ID="LocDreEblPwdNoMtc" meta:resourcekey="str_dreEblPwdNoMtc" Visible="false">Data-at-Rest Encryption is enabled but passwords do not match</asp:Localize>
    <table width="100%">
        <tr>
            <td align="center" style="padding-top: 100px;">
                <asp:Panel ID="FailedPanel" runat="server" Visible="false">
                    <span style="font-size: 24px; color: #404040; font-weight: 100;">
                        <asp:Localize meta:resourcekey="str_failedcreate" runat="server">Failed to create tenant</asp:Localize></span><br />
                    <br />
                    <asp:Label ID="ErrorMsg" runat="server" CssClass="ErrorMessage"
                        meta:resourcekey="ErrorMsgResource1"></asp:Label><br />
                    <br />
                    <asp:Label ID="InfoMsg" runat="server" CssClass="InfoMessage"></asp:Label>

                </asp:Panel>

                <asp:Panel ID="SummaryPanel" runat="server">
                    <table style="width:100%; max-width:800px;" >
                        <tr>
                            <td colspan="2"></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="font-size: 24px; font-weight: 100; padding-bottom:20px; color: padding: 10px; border-bottom: 0px solid #cccccc;"   align="left">
                               <asp:Localize runat="server" meta:resourcekey="str_cldBkpStg">Cloud Backup Storage</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" align="center" style="padding:30px; padding-top:60px; font-size:18px; color:#565656; font-weight:100;" >
                                <asp:Label ID="StorageDesc" runat="server" Text="Label"></asp:Label>
                                <div style="height:60px">&nbsp;</div>
                                
                                <asp:Panel ID="DarePanel" runat="server" Visible="false">
                                     <table style="width:100%; max-width:800px;" >
                    <tr>
                        <td style="padding: 5px">
                            <asp:CheckBox ID="EnableDARE" runat="server" Text="Enable data-at-rest encryption" AutoPostBack="true" OnCheckedChanged="OnDareClickChanged_Click"
                                ForeColor="#009000" meta:resourcekey="EnableDAREResource1" />
                        </td>
                    </tr>
                    <%if (EnableDARE.Checked)
                        { %>
                    <tr>
                        <td style="padding: 5px;padding-top: 10px;font-size: 18px; color: #565656; font-weight: 100;">
                            <asp:Localize runat="server" meta:resourcekey="str_pwd">Password</asp:Localize>:<br />
                            <asp:TextBox ID="DAREPwd" runat="server" Width="90%" TextMode="Password" 
                                meta:resourcekey="DAREPwdResource1" CssClass="form-control"></asp:TextBox>
                            <br />
                            <br />
                            <asp:Localize runat="server" meta:resourcekey="str_reEtr">Re-enter</asp:Localize>:<br />
                            <asp:TextBox ID="DAREPwd1" runat="server" Width="90%" TextMode="Password" 
                                meta:resourcekey="DAREPwd1Resource1" CssClass="form-control"></asp:TextBox>
                        </td>
                    </tr>
                                         <%} %>
                                                             <tr>
                        <td style="padding: 5px; font-size: 12px; color: #565656; font-weight: 100;">
                            <asp:Localize meta:resourcekey="asp_string2" runat="server">If "Data-at-Rest Encryption" is checked your data will be stored in encrypted form using a key derived from the password specified below. Enabling this option may reduce the performance of uploads and downloads. Please specify the encryption password below and save it in a safe place in case you need to recover encrypted files.</asp:Localize>
                        </td>
                    </tr>
                </table>
                                </asp:Panel>
                                <asp:Panel ID="WarningPanel" runat="server" Visible="false">
                                <div class="alert alert-warning" role="alert">
                                  <b><asp:Localize runat="server" meta:resourcekey="str_wrn">Warning!</asp:Localize></b> <asp:Localize runat="server" meta:resourcekey="str_allExtBkpTgt">All existing backup targets will be restarted!</asp:Localize> 
                                </div>
                                    </asp:Panel>
                            </td>
                        </tr>            
                        <tr>
                            <td style="padding-top:40px;" align="right">
                                <asp:LinkButton ID="CommitBtn" runat="server" CssClass="btn btn-primary gladbtn" OnClientClick="Wait('...'); return true;" OnClick="ButtonCreate_Click" meta:resourcekey="str_cmt">Commit</asp:LinkButton>
                                <asp:LinkButton ID="Backbtn" runat="server" CssClass="btn btn-default gladbtn" OnClick="ButtonBack_Click"  OnClientClick="Wait('...'); return true;" meta:resourcekey="str_bak">Back</asp:LinkButton>
                                <asp:LinkButton ID="CancelBtn" runat="server" CssClass="btn btn-default gladbtn" OnClick="ButtonCancel_Click"  OnClientClick="Wait('...'); return true;" meta:resourcekey="str_cnl">Cancel</asp:LinkButton>
                            </td>
                        </tr>            
                    </table>
                </asp:Panel>
            </td>
        </tr>

    </table>

</asp:Content>
