﻿<%@ Page Title="Backup Team Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupTeamFolders.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupTeamFolders"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>

    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }


        .infofont{
            font-size: 10px!important; font-weight: 100!important;
        }

        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        .style1 {
            width: 153px;
        }

        .newusericon {
            background-image: url(images/upgradeuser.png);
        }

        .active {
            background-color: #565656;
        }

        li {
            background-color: transparent;
        }
    </style>
    <script type="text/javascript">
        var eleClassName = "gridobject col-2";

        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");
            
            
            Wait("...");
            e.click();

        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFldEblBkp" meta:resourcekey="str_fldEblBkp" Visible="false">Failed to enable backup</asp:Localize>
<asp:Localize runat="server" ID="LocFldStpBkp" meta:resourcekey="str_fldStpBkp" Visible="false">Failed to stop backup</asp:Localize>
<asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
<asp:Localize ID="LocDts" runat="server" meta:resourcekey="str_dts" Visible="false">View Details</asp:Localize>
<asp:Localize ID="LocDsbBkp" runat="server" meta:resourcekey="str_dsbBkp" Visible="false">Disable Backup</asp:Localize>





    <div class="meubardrop"  style="width:100%;<% if (IsChildUi){ %>box-shadow: 0px 0px white!important; border-bottom:0px solid #f0f0f0!important;<% } %>"  id="defaultcontent">
    <div style="width:100%;padding:20px;">
         <div style="display:inline-block; padding-right:18px; cursor:pointer;" onclick="AddTeamFolder();return false;" class="toolnavbtn">
          <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;" title="Refresh" >&#x173;</i>
            <span style="font-weight:100; font-size:16px; color:#404040;"><asp:Localize ID="LocAddTemFldBkp" runat="server" meta:resourcekey="str_addTemFldBkp" >Add Team Folder to Backup</asp:Localize></span>
            
        </div>
        <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="OnRefresh();return false;" class="toolnavbtn">
            <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;" title="Refresh" >µ</i>
            <span style="font-weight:100; font-size:16px; color:#404040;"><%=RefreshBtn.Text %></span>
                
        </div>
    </div>

</div>



<div class="c-body" style="clear:both;">
<main class="c-main">
<div class="container-fluid">
<div class="fade-in">
    
<div class="card">

<%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
<div id="container errmsgdiv">
    <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
</div>
<%} %>
</div>




    <%if (TargetsRepeater.Items.Count <= 0){ %>
<div class="card" style="margin-bottom:10px; box-shadow:none!important;">  	
<div class="card-body">
<div class="justify-content-between">

    <div class="container errMsg text-center">
    <h2 class="bkpHClr bkpNoDtaMsg"><asp:Localize runat="server" meta:resourcekey="str_noTemFldCfg">No Team Folders are configured for backup</asp:Localize></h2>
    <button class="btn newBtn" style="font-size:16px!important" onclick="AddTeamFolder(); return false;"><asp:Localize runat="server" meta:resourcekey="str_addTemFldBkp">Add Team Folder to Backup</asp:Localize></button>
    </div>

</div>
</div>
</div>
    <%} else { %>     
                  
        <asp:Repeater ID="TargetsRepeater" runat="server" enableviewstate="false" >
            <ItemTemplate>            

<div class="card filerow" style="margin-bottom:10px;box-shadow:none!important; border-top:1px solid #f0f0f0;">   
<div class="card-body">
<div class="justify-content-between">  


                <div class="content" style="width:100%;">
                    
                    <div class="row" style="padding-left:10px;padding-bottom:10px;">
                        <div class="toolnavbtn" style="display:inline-block" onclick='onDetail("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");'>
                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" title="<%# DataBinder.Eval(Container.DataItem, "DipslayStatus")%>" >&#x139;</i>
                                                                    <span class="bkpNobrk" style="padding-left:10px; font-size:18px!important;  color: #202020;"><%#DataBinder.Eval(Container.DataItem, "TargetName")%></span>
                            </div>
                    </div>
                    <div class="row" style="margin-top:5px;margin-bottom:5px;">
                        <div class="col-12 bkpNobrk " style="overflow-x:hidden;">
                            <span class="infofont"><%=str_tnt.Text %></spa>: <span class="infofont"><%# DataBinder.Eval(Container.DataItem,"TargetTenant") %></span>
                        </div>
                    </div>
                    <div class="row" style="padding-top:2px;">
                        <div class="col-12 col-md-3 col-lg-3">
                            <span class="bkpNobrk infofont" style="padding-right:5px;"><%=str_strTme.Text %>:</span> <span class="bkpNobrk"><%# DataBinder.Eval(Container.DataItem,"StartTimeDisplay") %></span>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3">
                            <span class="bkpNobrk" style="padding-right:5px;"><%=str_drn.Text %>:</span> <span class="bkpNobrk"><%# DataBinder.Eval(Container.DataItem,"Duration") %></span>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3">
                            <span class="bkpNobrk" style="padding-right:5px;"><%=str_lstShtFil.Text %>:</span> <span class="bkpNobrk"><%# DataBinder.Eval(Container.DataItem,"FileCount") %></span>
                        </div>
                        <div class="col-12 col-md-3 col-lg-3">
                            <span class="bkpNobrk" style="padding-right:5px;"><%=str_lstShtBts.Text %>:</span> <span class="bkpNobrk"><%# DataBinder.Eval(Container.DataItem,"DisplayBackupSize") %></span>
                        </div>
                        
                    </div>
                    <div class="row" style="margin-top:20px; padding-left:10px;">
                        <div style="display:inline-block; cursor:pointer;" class="toolnavbtn"  onclick='onDetail("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");'>
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:-3px; font-size:14px" >&#x00db;</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; " ><%=LocDts.Text %></span>
                                                                </div>
                        <div style="display:inline-block;width:15px">&nbsp;</div>
                        <div style="display:inline-block; cursor:pointer;" class="toolnavbtn"  onclick='BrowseSnapshotFiles("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");return false;'>
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:-3px; font-size:14px" >&#x00ab;</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; " ><%=str_browse.Text %></span>
                                                                </div>
                                                                <div style="display:inline-block;width:15px">&nbsp;</div>
                                                                <div style="display:inline-block;cursor:pointer;" class="toolnavbtn" onclick='onStop("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");'>
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:0px; font-size:14px" >n</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; "><%=LocDsbBkp.Text %></span>
                                                                </div>
                       
                        
                    </div>
                </div>       
    
</div>
</div> 
</div>    
                                            
            </ItemTemplate>         
        </asp:Repeater>

    
    <%}%>  



</div>
</div>
</main>
</div>

    <div style="display: none;">
        <asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize>
        <asp:Localize runat="server" meta:resourcekey="str_tnt" ID="str_tnt">Tenant</asp:Localize>
        <asp:Localize runat="server" meta:resourcekey="str_strTme" ID="str_strTme">Start Time</asp:Localize>
        <asp:Localize runat="server" meta:resourcekey="str_drn" ID="str_drn">Duration</asp:Localize>
        <asp:Localize runat="server" meta:resourcekey="str_lstShtFil" ID="str_lstShtFil">Last Snapshot Files</asp:Localize>
        <asp:Localize runat="server" meta:resourcekey="str_lstShtBts" ID="str_lstShtBts">Last Snapshot Bytes</asp:Localize>
        <asp:Button ID="StopBackup" runat="server" Text="StopBackup" OnClick="StopBackup_Click" />
        <asp:HiddenField ID="TargetId" runat="server" />
        <span id="sectextcolor" class="sectextcolor"></span>
        <span id="lighttextcolor" class="lighttextcolor"></span>
    </div>
    
    <div id="ShortWindowModal" class="modal fade" role="dialog" >
            <div class="modal-dialog " style="max-width:850px!important; width: 850px!important; padding:0px!important;">

                <!-- Modal content-->
                <div class="modal-content" style="padding:0px!important;">
                    <div class="modal-header" >
                        
                        <button type="button" class="close" onclick="CloseQuickWindow();">&times;</button>
                        <h4 class="bkpHClr modal-title" style="color: #808080; " id="ShortTitle"></h4>
                    </div>
                    <div class="modal-body" style="height: 600px;padding-top:0px;padding:0px!important;" id="ShortBody">
                         <iframe id='ShortWindow' style="height:600px;" src="/portal/WaitWin.htm" class="bkpIfrm"></iframe>
                    </div>
                </div>

            </div>
        </div>
    <div id="childwnd" style=" padding:0px;  width:100%; display:none;">
   
   <div style="width:100%;"" id="childin" class="meubardrop">
   <table width="100%" style="border-collapse:collapse;" cellpadding="0" cellspacing="0" >
            <tr style="border-top:1px solid #dddddd;">
                

                 
                <td style="padding-bottom:3px;">
                    <table >
                        <tr>
                
                                
                <td style="padding:5px; font-size:18px; cursor:pointer;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();"><asp:Localize runat="server" meta:resourcekey="str_temFldBkp">Team Folder Backups</asp:Localize></td>
                <td  style="padding:5px; font-size:18px;" class="sectextcolor ">></td>
                                <td align="left" style="padding:5px;border-bottom: 0px solid #cccccc;padding-left:10px; height:48px; font-size:18px;font-weight:100;color:#404040;" id="child_title" >
                </td>

                        </tr>
                    </table>
                </td>
                    
               <td style="border-bottom: 0px solid #cccccc;padding-right:10px;" align="right">
                    <div style="padding-left:10px; float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                </td>
                </tr>
            </table>
       </div>
    <iframe src="/portal/WaitWin.htm" style="margin-top:20px;" id="child_body" class="bkpIfrm"></iframe>
        
        </div>
    <div style="display:none">
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="Refresh_Click" Text="Refresh">
            </asp:LinkButton>
    </div>
    <asp:Localize ID="LocFilUpd" runat="server" meta:resourcekey="str_filUpd" Visible="false">Files Uploaded</asp:Localize>
    <asp:Localize ID="LocTme" runat="server" meta:resourcekey="str_tme" Visible="false">Time</asp:Localize>
    <asp:Localize ID="LocFil" runat="server" meta:resourcekey="str_fil" Visible="false">Files</asp:Localize>
    <asp:Localize meta:resourcekey="str_browse" ID="str_browse" Visible="False" runat="server">Files</asp:Localize>
    <script type="text/javascript">

        function OpenQuickWindow(u, t) {
            var e = document.getElementById("ShortTitle");
            e.innerHTML = "&nbsp;&nbsp;";
            e = document.getElementById("ShortBody");
            e.style.height = "80vh"
            e = document.getElementById("ShortWindow");
            e.src = u;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }
        function CloseQuickWindow(u, t) {
            try {
                var e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

            } catch (ee) {

            }
            try {
                $('#ShortWindowModal').modal('hide');

            } catch (e) {

            }

        }
        function CloseChildWnd()
        {
            var f = document.getElementById('defaultcontent');
            f.style.display = "";
        

            f = document.getElementById('child_body');
            f.src = "/portal/WaitWin.htm";        

            f = document.getElementById('childwnd');        
            f.style.display = "none";

        }
        function OpenChildWnd(t, s) {
        
            var f = document.getElementById('defaultcontent');
            f.style.display = "none";


            f = document.getElementById('child_body');
            f.src = s;

            f = document.getElementById('childwnd');
            f.style.display = "";

            f = document.getElementById('child_title');
            f.innerHTML = t;

        }
        function closeCancelActiveWin()
        {
            CloseQuickWindow();
        }

        function closeActiveWin() {
            CloseQuickWindow();
            window.location = window.location;
        }


        function AddTeamFolder() {
            OpenQuickWindow("ClusterBackupAddTeamFolder.aspx", "<asp:Localize runat="server" meta:resourcekey="str_addTemFldBkp">Add Team Folder to Backup</asp:Localize>");
        }
        function onDetail(n, id)
        {
            parent.OpenNextMenu("+",n, "/management/BackupMgr/UI/BackupTeamFolder.aspx?child=1&vdid=<%=SessionDomainId%>&tid=" + id);
        }

        function BrowseSnapshotFiles(n, id)
        {
            parent.OpenNextMenu("&#x139;",n + " files", "/management/BackupMgr/UI/BackupSnapshotBrowser.aspx?tid="+id+"<% if (IsChildUi) { %>&child=1<%}%>")
        }

        function onStop(n, id)
        {
            
            gConfirm("<asp:Localize runat="server" meta:resourcekey="str_cfmDblBkp">Please confirm to disable backups of the team folder</asp:Localize>:" + n, "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_StopBackup");
                    var t = document.getElementById("ctl00_MainContent_TargetId");
                    t.value = id;
                    Wait("...");
                    e.click();
                }
            });
        }
        
        function adjust() {
            //for backwards compatibility with WebAppPanel.master
        }
        document.addEventListener("DOMContentLoaded", function () {
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });

    </script>
</asp:Content>
