﻿<%@ Page Title="Add Backup Set" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AddDeviceRestoreTask.aspx.cs" Inherits="GladinetPayFlow.AddDeviceRestoreTask"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" EnableViewState="True" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
       
           
    </style>
    <script type="text/javascript">
        function ReturnLast() {
            
            parent.closeCancelActiveWin();
        }

        function onRootCheckChanged(id) {
            var ec = document.getElementById("sel_"+id);
            var cd = document.getElementById("ctd_" + id);
            if (cd && ec) {
                changeChildSelect(cd, ec.checked);
            }
            
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

<asp:Localize ID="LocFaiToLoaFol" meta:resourcekey="str_faiToLoaFol" Visible="false" runat="server">Failed to load folder</asp:Localize>
<asp:Localize ID="LocFaiToAddNewResTas" meta:resourcekey="str_faiToAddNewResTas" Visible="false" runat="server">Failed to add new restore task</asp:Localize>
<asp:Localize ID="LocTheIsNoFolSelToRes" meta:resourcekey="str_theIsNoFolSelToRes" Visible="false" runat="server">There are no folders/files selected to restore</asp:Localize>
<asp:Localize ID="LocFaiToLoaSna" meta:resourcekey="str_faiToLoaSna" Visible="false" runat="server">Failed to load snapshots</asp:Localize>
<asp:Localize ID="LocBacSetNotFou" meta:resourcekey="str_bacSetNotFou" Visible="false" runat="server">Backup set not found</asp:Localize>
<asp:Localize ID="LocPleSelABacSet" meta:resourcekey="str_pleSelABacSet" Visible="false" runat="server">Please select a backup set</asp:Localize>
<asp:Localize ID="LocMisPar" meta:resourcekey="str_misPar" runat="server" Visible="False">Missing parameter</asp:Localize>
    <div id="defaultcontent" style="background-color: white; width: 100%; margin-top: 10px; font-size: 18px; align-content: center;border-top:1px solid #eeeeee;">
        <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
        <asp:Panel ID="Step1Panel" runat="server">

            <table style="width: 100%; align-self: center; align-content: center; ">
                <tr>
                    <td align="center" style="padding:40px;" valign="middle" id="step1td">
                        <table style="width: 100%; ">
                            <tr>
                                <td style="font-size: 18px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_selABacSetToResFro" runat="server">Select a backup set to restore from:</asp:Localize></td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <asp:DropDownList ID="BackupSetList" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="right" valign="middle" style="padding-right:10px;">
                        <asp:LinkButton ID="Step1ContinueBtn" runat="server" CssClass="btn btn-primary gladbtn" OnClick="Step1Contine_Click" OnClientClick="Wait('...'); return true;">Continue</asp:LinkButton>
                        <asp:LinkButton ID="CancelBtn1" CssClass="btn btn-default gladbtn" OnClientClick="ReturnLast();return false;" runat="server">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>

        </asp:Panel>
        <asp:Panel ID="Step2Panel" runat="server" Visible="false">

            <table style="width: 100%">
                <tr>
                    <td align="center" style="padding:40px;" valign="middle" id="step2td">
                         <table style="width: 100%; ">
                            <tr>
                                <td style="font-size: 18px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_selABacSnaToResFro" runat="server">Select a backup snapshot to restore from:</asp:Localize></td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <asp:DropDownList ID="SnapshotList" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td style="height:30px;">&nbsp;</td>
                            </tr>
                             <tr>
                                <td style="font-size: 18px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_resFilTo" runat="server">Restore files to:</asp:Localize></td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <asp:DropDownList ID="LocationList" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                </td>
                            </tr>
                             <tr>
                                <td style="font-size: 18px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_actWheFilExiInDes" runat="server">Action when file exists in destination:</asp:Localize></td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <asp:DropDownList ID="DupActionList" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                </td>
                            </tr>


                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="right" valign="middle" style="padding-right:10px;">
                        <asp:LinkButton ID="Step2Back" runat="server" CssClass="btn btn-default gladbtn" OnClick="Step2Back_Click" OnClientClick="Wait('...'); return true;">Back</asp:LinkButton>
                        <asp:LinkButton ID="Step2ContinueBtn" runat="server" CssClass="btn btn-primary gladbtn" OnClick="Step2Contine_Click" OnClientClick="Wait('...'); return true;">Continue</asp:LinkButton>
                        <asp:LinkButton ID="CancelBtn2" CssClass="btn btn-default gladbtn" OnClientClick="ReturnLast();return false;" runat="server">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>

        </asp:Panel>

        <asp:Panel ID="Step3Panel" runat="server" Visible="false">

            <table style="width: 100%">
                <tr>
                    <td align="center" style="padding: 10px; padding-top: 5px;" valign="top">
                        <div style="width:100%; overflow:auto;" id="step3td">
                        <table width="100%" align="center" cellpadding="0" cellspacing="0"
                            style="background-color: WHITE;">


                            <asp:Repeater ID="FolderList" runat="server">
                                <ItemTemplate>
                                    <tr>
                                        <td style="padding-bottom: 5px;">
                                            <table width="100%">
                                                <tr style="padding: 3px; cursor: pointer; user-select: none;">
                                                    <td width="20px" valign="middle">
                                                        <i onclick='onopenfolder("<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>",  "<%# DataBinder.Eval(Container.DataItem, "OrigKey").ToString().Replace("'","|") %>")' class="gladinet-icons md-dark hand center toolbtn" style="display: inline-block; font-size: 12px;" id="oi_<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>">&#xb1;</i>
                                                        <i onclick='onclosefolder("<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>")' class="gladinet-icons md-dark hand center toolbtn" style="display: none; font-size: 12px;" id="oc_<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>">&#xe4;</i>
                                                    </td>
                                                    <td width="20px" valign="middle">
                                                        <input type="checkbox" id="sel_<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>" onclick='onRootCheckChanged("<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>");'/>
                                                    </td>
                                                    <td style="padding-left: 0px; font-size: 14px; color: #404040; font-weight: 100;" id="key_<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>" class="disable-select" valign="middle"><%#DataBinder.Eval(Container.DataItem, "Key")%></td>
                                                </tr>
                                                <tr id="ctr_<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>" style="display: none;">
                                                    <td></td>
                                                    <td colspan="2" id="ctd_<%# DataBinder.Eval(Container.DataItem, "EDTTag")%>" class="topitem">...</td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>



                                </ItemTemplate>
                            </asp:Repeater>

                        </table>
                            </div>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="padding:10px;" valign="middle">
                        <asp:LinkButton ID="Step3Back" runat="server" CssClass="btn btn-default gladbtn" OnClick="Step3Back_Click" OnClientClick="Wait('...'); return true;">Back</asp:LinkButton>
                        <asp:LinkButton ID="Step3Continue" runat="server" CssClass="btn btn-primary gladbtn" OnClick="Step3Contine_Click" OnClientClick="GetTargetFolders();return true;">Add</asp:LinkButton>
                        <asp:LinkButton ID="CancelBtn3" CssClass="btn btn-default gladbtn" OnClientClick="ReturnLast();return false;" runat="server">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>

        </asp:Panel>
    </div>

    <div style="display: none">
        <asp:HiddenField ID="DeviceId" runat="server" />
        <asp:Panel ID="ConinuePanel" runat="server"></asp:Panel>

        <asp:HiddenField ID="TargetFolders" runat="server" />
    </div>
    <script type="text/javascript">

        function RecurGetTF(tfs, tf, container, sel) {
            var psel = sel;

            
            for (var i = 0; i < container.childNodes.length; i++) {
                var e = container.childNodes[i];

                if (e.className != "filetbl")
                    continue;
                
                var ctd = document.getElementById("ctd_" + e.id);
                var cb = document.getElementById("sel_" + e.id);

                if (!ctd || !cb)
                    continue;

                if (cb.checked) {
                    if (sel) {
                        RecurGetTF(tfs, tf, ctd, sel);
                    } else {
                        var newtf = [];
                        newtf.push(cb.ok);
                        tfs.push(newtf);
                        RecurGetTF(tfs, newtf, ctd, true);
                    }
                }
                else
                {
                    if (sel) {
                        tf.push(cb.ok);
                        RecurGetTF(tfs, tf, ctd, false);
                    } else {
                        RecurGetTF(tfs, tf, ctd, sel);
                    }
                }

                
            }




        }
        function GetTargetFolders() {
            var tis = document.getElementsByClassName("topitem");
            var tfs = [];

            for (i = 0; i < tis.length; ++i) {
                var e = tis[i];                
                if (e.id == null)
                    continue;
                if (!stringStartsWith(e.id, "ctd_"))
                    continue;
                var sel = document.getElementById("sel_"+e.id.substring(4));
                var k = document.getElementById("key_"+e.id.substring(4))
                if(sel && sel.checked && k){
                    var newtf = [];
                    newtf.push(k.innerHTML);
                    tfs.push(newtf);
                    RecurGetTF(tfs, newtf, e, true);
                }else{
                    RecurGetTF(tfs, null, e, false);
                }
            }

            
            var fs = "";
            for (i = 0; i < tfs.length; i++) {
                var s = "";
                var tf = tfs[i];

                for(var j=0; j<tf.length;++j){
                    s += tf[j]+"|";
                }
                fs += s;
            fs += "\n";

            }
            var tfsh = document.getElementById("ctl00_MainContent_TargetFolders");
            tfsh.value = fs;
            
            Wait('...');
        }


        function onopenfolder(id, f) {
            var oi = document.getElementById("oi_" + id);
            var oc = document.getElementById("oc_" + id);
            var ctr = document.getElementById("ctr_" + id);
            var ctd = document.getElementById("ctd_" + id);
            oi.style.display = "none";
            oc.style.display = "inline-block";
            ctr.style.display = "";

            if (ctd.innerHTML == "...")
                LoadChild(id, f);
        }

        function onclosefolder(id) {
            var oi = document.getElementById("oi_" + id);
            var oc = document.getElementById("oc_" + id);
            var ctr = document.getElementById("ctr_" + id);
            oi.style.display = "inline-block";
            oc.style.display = "none";
            ctr.style.display = "none";

        }

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        function changeChildSelect(p, sel) {
            for (var i = 0; i < p.childNodes.length; i++) {
                if (p.childNodes[i].className == "folder_selected") {
                    p.childNodes[i].checked = sel;
                } else {
                    changeChildSelect(p.childNodes[i], sel);
                }
            }
        }

        function LoadFolderContent(id, fo, content) {
            var pchecked = false;

            if (stringStartsWith(content, "^^")) {
                alert(content.substring(2));
                return;
            }

            var psel = document.getElementById("sel_" + id);
            if (psel) {
                pchecked = psel.checked;
            }
            var ctd = document.getElementById("ctd_" + id);
            ctd.innerHTML = "";
            var res = content.split("\n");
            for (var i = 0; i < res.length; ++i) {
                var fres = res[i].split("|");
                if (fres.length != 3)
                    continue;

                var tbl = document.createElement("table");
                tbl.style.width = "100%";
                tbl.id = fres[1];
                tbl.className = "filetbl";

                var tbody = document.createElement("tbody");
                tbl.appendChild(tbody);

                var tr = document.createElement("tr");
                tr.style.padding = "3px";
                tr.style.cursor = "pointer";

                tr.style.userSelect = "none";
                tbody.appendChild(tr);

                var toggeltd = document.createElement("td");
                tr.appendChild(toggeltd);
                toggeltd.valign = "middle";
                toggeltd.style.width = "20px";

                var openi = document.createElement("span");

                openi.className = "gladinet-icons md-dark hand center toolbtn";
                
                if (fres[2].indexOf("False") != -1) {
                    
                    openi.style.display = "none";
                } else {                    
                    openi.style.display = "inline-block";
                }
                openi.style.fontSize = "14px";
                openi.id = "oi_" + fres[1];
                toggeltd.appendChild(openi);
                openi.innerHTML = "&#xb1;";
                openi.et = fres[1];
                openi.ok = fres[0];
                openi.onclick = function () {
                    onopenfolder(this.et, this.ok);
                }
                
                

                var closei = document.createElement("span");
                closei.className = "gladinet-icons md-dark hand center toolbtn";
                closei.style.display = "none";
                closei.style.fontSize = "14px";
                closei.id = "oc_" + fres[1];
                toggeltd.appendChild(closei);
                closei.innerHTML = "&#xe4;";
                closei.et = fres[1];
                closei.onclick = function () {
                    onclosefolder(this.et);
                }


                var checktd = document.createElement("td");
                tr.appendChild(checktd);
                checktd.vAlign = "middle";
                checktd.style.width = "20px";

                var cb = document.createElement("input");
                checktd.appendChild(cb);
                cb.id = "sel_" + fres[1];
                cb.type = "checkbox";
                cb.checked = pchecked;
                cb.className = "folder_selected";
                cb.ok = fres[0];
                cb.onclick = function () {
                    var cd = document.getElementById("ctd_" + this.id.substring(4));
                    if (cd) {
                        changeChildSelect(cd, this.checked);
                    }
                }

                var foldernametd = document.createElement("td");
                tr.appendChild(foldernametd);
                foldernametd.style.paddingLeft = "0px";
                foldernametd.style.fontSize = "14px";
                foldernametd.style.color = "#404040";
                foldernametd.style.fontWeight = "100";
                foldernametd.className = "disable-select";
                foldernametd.vAlign = "middle";
                var index = fres[0].lastIndexOf("/");
                if (index == -1)
                    foldernametd.innerHTML = fres[0];
                else
                    foldernametd.innerHTML = fres[0].substring(index + 1);


                tr = document.createElement("tr");
                tr.id = "ctr_" + fres[1];
                tr.style.display = "none";

                var dummytd = document.createElement("td");
                tr.appendChild(dummytd);

                var childtd = document.createElement("td");
                childtd.id = "ctd_" + fres[1];
                childtd.colSpan = 2;
                childtd.innerHTML = "...";
                tr.appendChild(childtd);

                tbody.appendChild(tr);

                ctd.appendChild(tbl);
            }


        }

        function LoadChild(id, fo) {
            Ext.Ajax.defaultHeaders = {
                'Content-Type': "application/xml; charset=utf-8"
            };

            var received = function (response) {

                LoadFolderContent(id, fo, response.responseText);

            }
            var altpath = encodeURIComponent(fo);
            Ext.Ajax.request({
                url: 'AddDeviceRestoreTask.aspx?c=l',
                success: received,
                scope: this,
                failure: function () {

                    alert("Failed to send request");


                },
                method: 'GET',
                headers: {
                    'x-glad-altpath': altpath,
                    'x-glad-hostid': '<%=DeviceId.Value%>',
                    'x-glad-bsid': '<%=BackupSetList.SelectedValue%>',
                    'x-glad-sid': '<%=SnapshotList.SelectedValue%>'

                 }
             });
        }

        function adjust() {
            var e = document.getElementById("step1td");

            if (e)
                e.style.height = (window.innerHeight - 90) + "px";
         
            e = document.getElementById("step2td");
            if (e)
                e.style.height = (window.innerHeight - 90) + "px";

            e = document.getElementById("step3td");
            if (e)
                e.style.height = (window.innerHeight - 90) + "px";
        }

        adjust();
    </script>
</asp:Content>
