﻿<%@ Page Title="Back Up Team Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantBackupTeamFolders.aspx.cs" Inherits="GladinetPayFlow.TenantBackupTeamFolders"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style type="text/css">       
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }




        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        .style1 {
            width: 153px;
        }

        .newusericon {
            background-image: url(images/upgradeuser.png);
        }

        .active {
            background-color: #565656;
        }

        li {
            background-color: transparent;
        }
    </style>
    <script type="text/javascript">
        
        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("id=") == -1)
                window.location.href = window.location.href + "?id=" + (new Date()).toString();
            else 
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToDisBac" meta:resourcekey="str_faiToDisBac" Visible="false">Failed to disable backup</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToEnaBac" meta:resourcekey="str_faiToEnaBac" Visible="false">Failed to enable backup</asp:Localize>
<asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
<asp:Localize ID="LocFilUpd" runat="server" meta:resourcekey="str_filUpd" Visible="false">Files Uploaded</asp:Localize>
<asp:Localize ID="LocTme" runat="server" meta:resourcekey="str_tme" Visible="false">Time</asp:Localize>
<asp:Localize ID="LocFil" runat="server" meta:resourcekey="str_fil" Visible="false">Files</asp:Localize>
<asp:Localize runat="server" ID="LocAddTemFldBkp" meta:resourcekey="str_addTemFldBkp" Visible="false">Add team folder to backup</asp:Localize>
<asp:Localize runat="server" ID="LocRfh" meta:resourcekey="str_rfh" Visible="false">Refresh</asp:Localize>
<asp:Localize ID="LocDts" runat="server" meta:resourcekey="str_dts" Visible="false">View Details</asp:Localize>
<asp:Localize ID="LocDsbBkp" runat="server" meta:resourcekey="str_dsbBkp" Visible="false">Disable Backup</asp:Localize>


<div class="c-subheader" style="margin-top:20px;">

    <div class="meubardrop"  style="width:100%;<% if (IsChildUi){ %>box-shadow: 0px 0px white!important; border-bottom:1px solid #f0f0f0!important;<% } %>">
    <table width="100%">
        <tr>
            <td style="padding:20px; ">
                   <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="OnRefresh();return false;" class="toolnavbtn">
                             <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;" title="Refresh" >&#xB5;</i>
                             <span style="font-weight:100; font-size:16px; color:#404040;"><%=LocRfh.Text %></span>
                         </div> 
                 <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="parent.AddTeamFolder();return false;" class="toolnavbtn">
                             <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;"  >&#x173;</i>
                             <span style="font-weight:100; font-size:16px; color:#404040;"><%=LocAddTemFldBkp.Text %></span>
                         </div> 
               
            </td>
            <td>
                <div id="errmsgdiv" >
                <b>
                    <asp:Label ID="Label1" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
            </td>
           
            <td  style="padding:10px; width:62px; display:none;" align="right">
                 <div  class="btn btn-primary gladbtn " style="margin-right: 8px;display:table;" title="<%=LinkButton2.Text %>">
                <i class="gladinet-icons md-32 md-dark hand" onclick="OnRefresh();return false;" style="display:table-cell;">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px; display:none;"><asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" meta:resourcekey="str_rfh" OnClientClick="OnRefresh();return false;"  ForeColor="#565656"></asp:LinkButton></div>
            </div>
            </td>
        </tr>
    </table>
        </div>
    <div style="width:100%;display:none;">
        <div class="bkpActLnk" style="float: left; width: 200px; height: 40px; margin-left: 15px;">
            <a class="" href="javascript:;" onclick="parent.AddTeamFolder();return false;" title="<%=LocAddTemFldBkp.Text %>"><i class="gladinet-icons hand">&#x173;</i></a>
            
        </div>
        <div class="bkpActLnk text-right" style="float: right; width: 200px; height: 40px; margin-right: 15px;">
            
            <a class="" href="javascript:;" onclick="OnRefresh();return false;" title="<%=LocRfh.Text %>"><i class="gladinet-icons hand" style="font-size: 28px;">µ</i></a>
            
        </div>
    </div>

</div>


<div class="c-body" style="clear:both;">
<main class="c-main">
<div class="container-fluid">
<div class="fade-in">

<div class="card">

<%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
<div id="container errmsgdiv">
    <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
</div>
<%} %>

</div>

    



<%if (TargetsRepeater.Items.Count == 0) { %>
<div class="card" style="margin-bottom: 10px;">
    <div class="card-body">
        <div class="justify-content-between">

            <div class="container errMsg text-center">
                <h2 class="bkpHClr">
                    <asp:Localize runat="server" meta:resourcekey="str_noTemFldCfgBkp">No Team Folders are configured for backup</asp:Localize></h2>
                <button class="btn newBtn" style="font-size: 16px!important" onclick="parent.AddTeamFolder(); return false;">
                    <asp:Localize runat="server" meta:resourcekey="str_addTemFldBkp">Add team folder to backup</asp:Localize></button>
            </div>

        </div>
    </div>
</div>
<% } else { %>

<asp:Repeater ID="TargetsRepeater" runat="server">
    <ItemTemplate>

         <div style="border-bottom:1px solid #f0f0f0; font-weight: 100; padding: 10px;padding-top:10px;" class="filerow">
            <table width="100%">
                                                        
                    <tr>
                    <td colspan="2">
                        <div class="toolnavbtn"  onclick='onDetail("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");'  style="display:inline-block;">
                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" >&#x139;</i>
                            <span style="padding-left:10px; font-size: 16px; color: #202020;"><%#DataBinder.Eval(Container.DataItem, "TargetName")%></span>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="padding: 10px; padding-bottom: 3px; color: #808080; font-size: 10px; font-weight: 100;">
                        <span><%=str_strTme.Text %></span>
                        <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"StartTimeDisplay") %></span>
                        <span style="width: 15px">&nbsp;</span>
                                                                
                        <span style="width: 10px">&nbsp;</span>
                        <span><%=str_drn.Text %></span>
                        <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"Duration") %></span>
                        <span style="width: 10px">&nbsp;</span>
                        <span><%=str_lstShtFil.Text %></span>
                        <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"FileCount") %></span>
                        <span style="width: 10px">&nbsp;</span>
                        <span><%=str_lstShtBts.Text %></span>
                        <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"DisplayBackupSize") %></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="padding: 10px; padding-bottom: 3px; color: #808080; font-size: 10px; font-weight: 100;">
                        <div style="display:inline-block; cursor:pointer;" class="toolnavbtn"  onclick='onDetail("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");'>
                                <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:-3px; font-size:12px" >&#xDB;</i>
                                <span   style="font-size:10px; font-weight:100; color:#202020; " ><%=LocDts.Text %></span>
                        </div>
                        <div style="display:inline-block;width:15px">&nbsp;</div>
                        <div style="display:inline-block;cursor:pointer;" class="toolnavbtn" onclick='onStop("<%# DataBinder.Eval(Container.DataItem, "TargetName")%>","<%# DataBinder.Eval(Container.DataItem, "TargetId")%>");'>
                                <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:0px; font-size:10px" >&#xFB;</i>
                                <span   style="font-size:10px; font-weight:100; color:#202020; "><%=LocDsbBkp.Text %></span>
                        </div>
                    </td>
                </tr>
            </table>

        </div>
        

    </ItemTemplate>
</asp:Repeater>
    
<% } %>



      
<div style="display: none;">
    <table width="100%">
        <tr style="border-bottom: 2px solid #f8f8f8;">
            <td></td>
            <td style="padding: 5px;">
                <asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize></td>
            <td style="padding: 5px;">
                <asp:Localize runat="server" meta:resourcekey="str_tnt" ID="str_tnt">Tenant</asp:Localize></td>
            <td style="padding: 5px;">
                <asp:Localize runat="server" meta:resourcekey="str_strTme" ID="str_strTme">Start Time</asp:Localize></td>
            <td style="padding: 5px;">
                <asp:Localize runat="server" meta:resourcekey="str_drn" ID="str_drn">Duration</asp:Localize></td>
            <td style="padding: 5px;">
                <asp:Localize runat="server" meta:resourcekey="str_lstShtFil" ID="str_lstShtFil">Last Snapshot Files</asp:Localize></td>
            <td style="padding: 5px;">
                <asp:Localize runat="server" meta:resourcekey="str_lstShtBts" ID="str_lstShtBts">Last Snapshot Bytes</asp:Localize></td>
        </tr>
        <tr>
            <td height="3px">&nbsp;</td>
        </tr>
    </table>
    <asp:Button ID="StopBackup" runat="server" Text="StopBackup" OnClick="StopBackup_Click" />
    <asp:HiddenField ID="TargetId" runat="server" />

    <span id="sectextcolor" class="sectextcolor"></span>
    <span id="lighttextcolor" class="lighttextcolor"></span>
</div>






   <div id="childwnd" style=" padding:0px;  width:100%; display:none;">
   
       <div style="width:100%;"" id="childin" class="meubardrop">
           <table width="100%" style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
               <tr style="border-top: 1px solid #dddddd;">



                   <td style="padding-bottom: 3px;">
                       <table>
                           <tr>


                               <td style="padding: 5px; font-size: 18px; cursor: pointer;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();">
                                   <asp:Localize runat="server" meta:resourcekey="str_temFldBkp">Team Folder Backups</asp:Localize></td>
                               <td style="padding: 5px; font-size: 18px;" class="sectextcolor ">></td>
                               <td align="left" style="padding: 5px; border-bottom: 0px solid #cccccc; padding-left: 10px; height: 48px; font-size: 18px; font-weight: 100; color: #404040;" id="child_title"></td>

                           </tr>
                       </table>
                   </td>

                   <td style="border-bottom: 0px solid #cccccc; padding-right: 10px;" align="right">
                       <div style="padding-left: 10px; float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                   </td>
               </tr>
           </table>
       </div>

       <iframe src="/portal/WaitWin.htm" style="margin-top:20px;" id="child_body" class="bkpIfrm"></iframe>
        
   </div>
    





     
</div>
</div>
</main>
</div>






    <script type="text/javascript">

        function CloseChildWnd()
        {
            window.location = window.location;
            return;
            var f = document.getElementById('defaultcontent');
            f.style.display = "";
        

            f = document.getElementById('child_body');
            f.src = "/portal/WaitWin.htm";        

            f = document.getElementById('childwnd');        
            f.style.display = "none";

            

        }
        function OpenChildWnd(t, s) {
        
            var f = document.getElementById('defaultcontent');
            f.style.display = "none";


            f = document.getElementById('child_body');
            f.src = s;

            f = document.getElementById('childwnd');
            f.style.display = "";

            f = document.getElementById('child_title');
            f.innerHTML = t;

        }

        function closeActiveWin() {
            CloseChildWnd();
            var e = document.getElementById("main_body");
            e.src = e.src;
        }

        function closeCancelActiveWin() {
            CloseChildWnd();
        }

        function onDetail(n, id)
        {
           
            parent.OpenNextMenu("+",n, "/management/BackupMgr/UI/BackupTeamFolder.aspx?child=1&vdid=<%=SessionDomainId%>&tid=" + id);
        }

        function onStop(n, id)
        {
            
            gConfirm("Are you sure you want to disable backups of the Team Folder: " + n + "?", "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_StopBackup");
                    var t = document.getElementById("ctl00_MainContent_TargetId");
                    t.value = id;
                    Wait("...");
                    e.click();
                }
            });
        }

        function AdjustGrodObj()
        {
           

        }



        function adjust() {
             
        }


    </script>
</asp:Content>
