﻿<%@ Page Title="Add Device to Backup" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantBackupAddDevice.aspx.cs" Inherits="GladinetPayFlow.TenantBackupAddDevice"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style type="text/css">   
    </style>
    <script type="text/javascript">
    
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaPro" meta:resourcekey="str_faiToLoaPro" Visible="false">failed to load profile</asp:Localize>    
<asp:Localize runat="server" ID="LocFldSrtDvcBkp" meta:resourcekey="str_fldSrtDvcBkp" Visible="false">Failed to start the device backup</asp:Localize>
<asp:Localize runat="server" ID="LocNotFnd" meta:resourcekey="str_notFnd" Visible="false">not found</asp:Localize>


<div class="c-body" style="margin-top:20px;">
<main class="c-main">
<div class="container-fluid">
<div class="fade-in">

<div id="pageContainerCard" 
<% if (IsChildUi) {
//If the page is loaded in the main frame body, add a shaded border to the page. If loaded within a modal popup, skip the border
%>
 class="card"
<% } %>
  style="box-shadow:none!important; "
>

<%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
<div id="container errmsgdiv">
    <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
</div>
<% } %>

<div class="card-body">
<div class="justify-content-between">




    <table width="100%">
        <tr>
            <td align="center" style="padding-top:30px;">
            <%if (TenantPanel.Visible){ %>
                <asp:Panel ID="SearchPanel" runat="server" DefaultButton="ShowTeamfolders">
                <table style="width:100%; max-width:1000px;">
                    <tr>
                        <td style="padding:10px;padding-bottom:20px;">
                            <asp:Localize runat="server" meta:resourcekey="str_srcDvcToBkp">Search for a device you want to backup</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td align="center">
                            <table width="100%">
                                <tr>
                                    <td style="padding: 10px;" width="80px" nowrap>
                                        <asp:Localize runat="server" meta:resourcekey="str_srhBy">Search By:</asp:Localize>

                                    </td>
                                    <td style="padding:10px; ">
                                        <asp:DropDownList ID="Field" runat="server" AutoPostBack="True" OnSelectedIndexChanged="Field_SelectedIndexChanged" CssClass="form-control newDrpDwn"
                                            meta:resourcekey="FieldResource1">
                                        </asp:DropDownList>
                                    </td>
                                    </tr>
                                    <tr>
                                        <td style="padding:10px;" width="80px" nowrap><asp:Localize runat="server" meta:resourcekey="str_srhFor">Search For:</asp:Localize></td>
                                    <td style="padding:10px; ">
                                        <asp:TextBox ID="FileName" runat="server" CssClass="form-control newTxtBx"></asp:TextBox>
                                        <asp:DropDownList ID="ActionName" runat="server" CssClass="form-control newDrpDwn">
                                        </asp:DropDownList>
                                        
                                        <asp:DropDownList ID="StatusList" runat="server" CssClass="form-control newDrpDwn">
                                        </asp:DropDownList>
                                    </td>
                                    
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                    </asp:Panel>
            <%}else { %>
                <asp:Panel ID="DevicePanel" runat="server" DefaultButton="CommitAdd">
                <div style="height:400px; overflow:auto; ">
                <table style="width:100%; " class="table-striped">
            <tr>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;" width="32px"></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;"><asp:Localize runat="server" meta:resourcekey="str_own">Owner</asp:Localize></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;"><asp:Localize runat="server" meta:resourcekey="str_hstNme">Host Name</asp:Localize></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;"><asp:Localize runat="server" meta:resourcekey="str_os">OS</asp:Localize></td>
            </tr>
            <asp:Repeater ID="DevicesRepeater" runat="server" enableviewstate="true" >
                                            <ItemTemplate>         
                                                <tr style="border-bottom:1px solid #e0e0e0;">
                                                    <td style="padding:5px;">
                                                        <input type='checkbox' style="<%# DataBinder.Eval(Container.DataItem,"TokenRemoveDisplay") %>" name='uu_<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>' value='1' />
                                                    </td>
                                                    <td style="padding:5px;"><%# DataBinder.Eval(Container.DataItem,"UserEmail") %></td>
                                                    <td style="padding:5px;"><%# DataBinder.Eval(Container.DataItem,"HostName") %></td>
                                                    <td style="padding:5px;"><%# DataBinder.Eval(Container.DataItem,"OsVer") %></td>
                                                </tr>
                                            </ItemTemplate>         
                                             </asp:Repeater>
                                                                            

        </table>
                    </div>
                    </asp:Panel>
            <%} %>
                
            <table style="width:100%; max-width:1000px;">
                    <tr>
                        <td>
                            <%if (!TenantPanel.Visible){ %>
                            <%=DeviceProfileList.SelectedItem.Text %>
                                        <button type="button" class="btn newBtn" data-toggle="modal" data-target="#profileModal"> <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; " >/</i></button>

                            <%} %>
                        </td>
                        <td style="padding-top:20px;text-align:right;">
                             <%if (TenantPanel.Visible){ %>
                            <asp:LinkButton ID="ShowTeamfolders" runat="server" CssClass="btn newBtn" OnClick="SearchDevice_Click"><asp:Localize runat="server" meta:resourcekey="str_srh">Search</asp:Localize></asp:LinkButton>
                            <%}else { %>
                            <button class="btn newSecBtn" onclick="OnBack();return false;"><asp:Localize runat="server" meta:resourcekey="str_bck">Back</asp:Localize></button>
                            <asp:LinkButton ID="CommitAdd" runat="server" CssClass="btn btn-primary gladbtn" OnClick="CommitAdd_Click" style="margin-left:10px;"><asp:Localize runat="server" meta:resourcekey="str_bkpSel">Backup Selected</asp:Localize></asp:LinkButton>
                            <%} %>
                            <button class="btn newSecBtn" onclick="OnCancel();return false;" style="margin-left:10px;"><asp:Localize runat="server" meta:resourcekey="str_cnl">Cancel</asp:Localize></button>
                        </td>
                    </tr>
                </table>
            <div class="modal fade" id="profileModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel"><asp:Localize runat="server" meta:resourcekey="str_BacPro">Backup Profiles</asp:Localize></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table width="100%">
            <tr>
                <td>
                     <asp:DropDownList ID="DeviceProfileList" Width="300px" CssClass="form-control newDrpDwn" runat="server" OnSelectedIndexChanged="onProfileChanged" AutoPostBack="true"></asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td>
                    <table style="width: 100%;">
                           
                            <tr>
                                <td height="30px">&nbsp;</td>
                            </tr>
                            <tr style="padding-top: 20px;">
                                <td>
                                    <asp:CheckBox Enabled="false" ID="BackupDocument" runat="server" Text="Documents Folder" meta:resourcekey="str_dcsFld" />
                                </td>
                                <td>
                                    <asp:CheckBox Enabled="false" ID="BackupPicture" runat="server" Text="Pictures Folder" meta:resourcekey="str_picFld"/>
                                </td>

                            </tr>
                            <tr>
                                <td>
                                    <asp:CheckBox Enabled="false" ID="BackupDesktop" runat="server" Text="Desktop Folder" meta:resourcekey="str_dskFld"/>
                                </td>
                                <td>
                                    <asp:CheckBox Enabled="false" ID="BackupVideo" runat="server" Text="Video Folder" meta:resourcekey="str_vdoFld"/>
                                </td>

                            </tr>
                                                        <tr>
                                <td>
                                    <asp:CheckBox Enabled="false" ID="BackupFav" runat="server" Text="Favorites Folder" meta:resourcekey="str_favFld"/>
                                </td>
                                <td>
                                    <asp:CheckBox Enabled="false" ID="BackupMusic" runat="server" Text="Music Folder" meta:resourcekey="str_mscFld"/>
                                </td>

                            </tr>

                            <tr>
                                <td colspan="2" style="padding-top: 20px; border-top: 1px solid #f0f0f0;">
                                    <div style="width: 100%; height: 150px; overflow: auto">
                                        <table width="100%">
                                            
                                            <tr>
                                                            <td colspan="2">
                                                                <table width="100%">
                                                                    <tbody id="bfolders">
                                                                        <asp:Repeater ID="BackupFoldersRepeater" runat="server" EnableViewState="false">
                                                                            <ItemTemplate>
                                                                                <tr style="border-bottom: 1px solid #f0f0f0;">
                                                                                  
                                                                                    <td>
                                                                                        <%# DataBinder.Eval(Container.DataItem,"Name") %>
                                                                                    </td>
                                                                                </tr>
                                                                            </ItemTemplate>
                                                                        </asp:Repeater>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>

                                        </table>
                                    </div>
                                </td>
                            </tr>

                           
                        </table>
                </td>
            </tr>
        </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn newBtn" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_Ok">Ok</asp:Localize></button>
        
      </div>
    </div>
  </div>
</div>
            </td>
        </tr>
    </table>



</div>
</div>
</div>



</div>
</div>
</main>
</div>


    <div style="display:none">
        <asp:Panel ID="TenantPanel" runat="server"></asp:Panel>
        <asp:Localize meta:resourcekey="str_ddl_usrEml" ID="LocUsrEml" Visible="false" runat="server">User Email</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_dvcTpe" ID="LocDvcTpe" Visible="false" runat="server">Device Type</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_hstNme" ID="LocHstNme" Visible="false" runat="server">Host Name</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_oprStm" ID="LocOprStm" Visible="false" runat="server">Operating System</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_cntSfw" ID="LocCntSfw" Visible="false" runat="server">Client Software Version</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_sts" ID="LocSts" Visible="false" runat="server">Status</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_sncSts" ID="LocSncSts" Visible="false" runat="server">Sync Status</asp:Localize>

        <asp:Localize meta:resourcekey="str_ddl_acd" ID="LocAcd" Visible="false" runat="server">Accepted</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_rjd" ID="LocRjd" Visible="false" runat="server">Rejected</asp:Localize>

        <asp:Localize meta:resourcekey="str_ddl_snc" ID="LocSnc" Visible="false" runat="server">Syncing</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_fld" ID="LocFld" Visible="false" runat="server">Failed</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_sncCpd" ID="LocSncCpd" Visible="false" runat="server">Sync Completed</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_fldRtvSts" ID="LocFldRtvSts" Visible="false" runat="server">Failed to Retrieve Sync Status</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_sncTskPnd" ID="LocSncTskPnd" Visible="false" runat="server">Sync Task Pending</asp:Localize>
        <asp:Localize meta:resourcekey="str_ddl_sncTskPsd" ID="LocSncTskPsd" Visible="false" runat="server">Sync Task Paused</asp:Localize>

        <asp:Localize meta:resourcekey="str_dvcFnd" ID="LocDvcFnd" Visible="false" runat="server">Device(s) found</asp:Localize>

    </div>
    

    <script type="text/javascript">

        function OnCancel()
        {
            <% if (IsChildUi) {
            //If the page is loaded in the main frame body
            %>
            parent.OpenDeviceBackMgr();
            <% } else { 
            //If the page is loaded within a modal popup         
            %>
            parent.closeCancelActiveWin();
            <% } %>
        }
    
        function OnBack() {

            window.location = "ClusterBackupAddDevice.aspx";

        }


        function adjust() { }

        document.addEventListener("DOMContentLoaded", function () {

            <%if(mShowProfileList){%>
            $('#profileModal').modal({ backdrop: 'static', keyboard: false });
            <%}%>

        });

    </script>


</asp:Content>
