﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="WizardAppPanel.master"
    AutoEventWireup="true" CodeBehind="QueryLDAP.aspx.cs" Inherits="GladinetPayFlow.QueryLDAP"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td
        {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        .badgefont
        {
            font-size: 15px;
            
        }
    </style>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .smallbtn {
            padding: 1px !important;
        }
        html, body
        {
            height: 100%;
        }
        
        
        .wrapper
        {
            
            width: 100%;
            
            
            padding: 0px;
            background-color: white;
            
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        
         .btnsmall {
            padding-left: 3px !important;
            padding-right: 3px !important;
        }


        #gridcolumn-1015-triggerEl, #menucheckitem-1018, #menucheckitem-1021 {display:none !important;}
        #menucheckitem-1017-textEl:before {content: "#";}

    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);


        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }
        function Wait1(title) {
            var myMask = new Ext.LoadMask(Ext.getBody(), { msg: "<asp:Localize meta:resourcekey="js_string4" runat="server">Please wait...</asp:Localize>" });
            myMask.show();

        }

        function SetSearchLocation() {
            activewin = new Ext.Window({
                id: 'On_Set_Location',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Select Search Location</asp:Localize>",
                x: 100,
                y: 50,
                width: 480,
                height: 450,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='/portal/LDAPLocation.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

        function SetLocation(loc) {
            var e = document.getElementById("MainContent_OU");
            e.value = loc;
            activewin.close();
        }

        function DrillDownConatiner(ou) {
            var e = document.getElementById("ctl00_MainContent_SelectedOU");
            var b = document.getElementById("ctl00_MainContent_BrowseContainer");

            e.value = ou;
            b.click();
            
        }

        
        function DrillDownOU(ou) {

            var e = document.getElementById("ctl00_MainContent_SelectedOU");
            var b = document.getElementById("ctl00_MainContent_BrowseOU");

            e.value = ou;
            b.click();

        }

        function OnPubClicked() {
            var o = document.getElementById("MainContent_LDAPHomeDrive");
            var o1 = document.getElementById("MainContent_VisibleHomeDir");
            var o2 = document.getElementById("MainContent_CreateDefaultDir");
            var o11 = document.getElementById("o1");
            var o22 = document.getElementById("o2");

            if (o.checked) {
                o1.checked = false;
                o2.checked = false;
                o11.style.display = 'none';
                o22.style.display = 'none';
            } else {
                o11.style.display = '';
                o22.style.display = '';

            }
        }

        function QueryUser() {
            var o = document.getElementById("ctl00_MainContent_Button1");
            o.click();
        }

        function BrowseUser() {
            
            var o = document.getElementById("ctl00_MainContent_Button2");           
            var e = document.getElementById("ctl00_MainContent_OU");
            e.value = "";
            o.click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">                                       
<asp:Localize ID="LocErrToLoaUse" meta:resourcekey="str_errToLoaUse" Visible="false" runat="server">Error to load users</asp:Localize>                              
<asp:Localize ID="LocErrLoaUse" meta:resourcekey="str_errLoaUse" Visible="false" runat="server">Error loading users</asp:Localize>                       
<asp:Localize ID="LocLoaUseFai" meta:resourcekey="str_loaUseFai" Visible="false" runat="server">Load user failed</asp:Localize>
<asp:Localize ID="LocFaiToQueAD" meta:resourcekey="str_faiToQueAD" Visible="false" runat="server">Failed to query AD</asp:Localize>
<asp:Localize runat="server" ID="LocNoUseFou" meta:resourcekey="str_noUseFou" Visible="false">No User Found</asp:Localize>
<asp:Localize runat="server" ID="LocMisSeaTex" meta:resourcekey="str_misSeaTex" Visible="false">Missing search text</asp:Localize>
<asp:Localize runat="server" ID="LocNoUseSel" meta:resourcekey="str_noUseSel" Visible="false">No user selected</asp:Localize>
    
       
        <div style="height:62px; width:100%; border-bottom:1px solid #cccccc">
         
            <table style="width:100%; height:60px;">
                <tr>
                    <td valign="middle">
                        <div class="navbar-left" style="padding-top: 12px; padding-right: 30px;">
                 <%if (OU.Text != "" && OU.Text != "/"){ %>
                 <span style="font-size: 18px; color: #565656; font-weight: 100;"><%=OU.Text %></span> 
                <%}else{%>
                 <%if (!LinkButton2.Visible){ %>
                 <span style="font-size: 18px; color: #565656; font-weight: 100;"><%=WizardUserParameter.ToUpper() %></span> 
                 <%}}%>
                  <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
          { %>
        <div id="errmsgdiv">
            <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
        <%} %>
              </div>
                    </td>
                    <td align="right" valign="middle">
                        <div style=" padding-right: 10px;">
                 <table>
                     <tr>
                         <td>
                              <asp:Panel ID="LocationPanel" runat="server" meta:resourcekey="LocationPanelResource1">
                                                    <table width="100%">
                                                        <tr>
                                                            <td width="18px">
                                                                
                                                                <asp:LinkButton ID="LinkButton2" OnClick="BrowseOUUP_Click" ToolTip="Up one level"  CssClass="btn btn-primary gladbtn btnsmall gladbtn"
                                                                    runat="server" ><span class="fa fa-level-up sectextcolor" style="font-size: 18px!important; "></span></asp:LinkButton>
                                                            </td>
                                                            <td style="padding-left: 5px; display: none;">
                                                                <b>
                                                                    <asp:Localize ID="Localize4" meta:resourcekey="asp_string10" runat="server" Visible="False"
                                                                    Text="Current Location:"></asp:Localize></b>
                                                                <asp:Label ID="CurrentOu" runat="server" Text="/" meta:resourcekey="CurrentOuResource1"></asp:Label>
                                                            </td>
                                                           
                                                        </tr>
                                                    </table>
                                        </asp:Panel>
                         </td>
                                            
                                            <td>
                                                <a  data-toggle="modal" data-target="#searchModel" title="<%=Button1.Text %>" class="btn btn-primary gladbtn btnsmall gladbtn">
                                                     <span class="fa fa-search sectextcolor" style="font-size: 18px;"></span> 
                                                </a>
                                                <a onclick="BrowseUser();return false;" title="<%=Button2.Text %>" class="btn btn-primary gladbtn btnsmall gladbtn">
                                                     <span class="fa fa-book sectextcolor" style="font-size: 18px;"></span> 
                                                </a>
                                                                        
                                            </td>
                                        </tr>
                 </table>
              </div>
                    </td>
                </tr>
            </table>
             
             
         
        </div>
             <div class="wrapper" id="mainw" style="background-color: white">
        <table id="localcontent1" cellspacing="0" width="100%" align="center" style="margin-top: 20px;">
            <tr>
                <td style="padding: 10px;  vertical-align: top; overflow: hidden;">
                    <asp:Panel ID="ResultPanel" runat="server" Visible="False" meta:resourcekey="ResultPanelResource1">
                                    <table width="100%" align="center">
                                        
                                        <tr>
                                            <td>
                                                <div id="grid-example"></div>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                                <asp:Panel ID="ConfigPanel" runat="server" Visible="False" meta:resourcekey="ConfigPanelResource1">
                                    <div class='idea_flex' style="height: 100px;">
                                        <asp:Localize ID="Localize6" meta:resourcekey="asp_string7" runat="server" 
                                            Text="No Active Directory (LDAP) is configured?"></asp:Localize><br />
                                        <asp:Localize ID="Localize7" meta:resourcekey="asp_string8" runat="server" 
                                            Text="click here to configure now"></asp:Localize>
                                        (
                                        <asp:LinkButton ID="LinkButton3" runat="server" OnClick="LinkButton3_Click" 
                                            meta:resourcekey="LinkButton3Resource1" Text="here"></asp:LinkButton>)
                                        <br />
                                    </div>
                                </asp:Panel>
                </td>
            </tr>
           
        </table>
        <div style="display: none;">
                                                <asp:Button ID="Button1" OnClick="Refresh_Click" runat="server" CssClass="btn btn-primary gladbtn btnsmall gladbtn"
                                                    OnClientClick="Wait1('Loading Users');" Text="Query Users"
                                              meta:resourcekey="Button1Resource2" />
                                              <asp:Button ID="Button2" OnClick="Browse_Click" runat="server" Text="Browse Users" OnClientClick="Wait1('Loading Users');"
                                                     meta:resourcekey="BrowseUserResource1" CssClass="btn btn-primary gladbtn btnsmall gladbtn" />            
            <asp:HiddenField ID="SelectedOU" runat="server" />
            <br />
            <asp:Button ID="BrowseOU" runat="server" Text="Button" OnClick="BrowseOU_Click" meta:resourcekey="BrowseOUResource1" />
            <asp:Button ID="BrowseContainer" runat="server" Text="Button" OnClick="BrowseContaineriner_Click" meta:resourcekey="BrowseOUResource1" />
             <asp:Panel ID="QueryPanel" runat="server" meta:resourcekey="QueryPanelResource1">
                                    <table width="100%" style="border-bottom: 1px solid #d0d0d0;">
                                        <tr style="display: none;">
                                            <td>
                                                <span style="font-size: 14px; vertical-align: top">
                                                    <asp:Localize ID="Localize5" meta:resourcekey="asp_string1" runat="server" 
                                                    Text="Location:"></asp:Localize></span>
                                            </td>
                                            <td>
                                                <asp:TextBox ID="OU" runat="server" Width="250px" CssClass="x-form-field x-form-text"
                                                    meta:resourcekey="OUResource1"></asp:TextBox>&nbsp;&nbsp;&nbsp;
                                            </td>
                                            <td style="text-align: left;">
                                                <span style="color: #606060;"><asp:Localize runat="server" meta:resourcekey="str_IeOuo">(i.e. /ou/ou1/...)</asp:Localize></span>
                                                <asp:LinkButton ID="LinkButton4" runat="server" Font-Size="8pt" ForeColor="#009000"
                                                    OnClientClick="SetSearchLocation();return false" Font-Underline="True" 
                                                    meta:resourcekey="LinkButton4Resource1" Text="Browse"></asp:LinkButton>
                                            </td>
                                        </tr>
                                        
                                    </table>
                                </asp:Panel>
        </div>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; 
        border-bottom: 0; vertical-align: middle; margin: 0;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;position:absolute;bottom:0;"
            align="right">
            <tr>
                <td>
                    <table >
                                                    <tr>
                                                        <td style="display: none;">
                                                            <a href="javascript:;" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                                                color: #008000">
                                                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string4" runat="server" 
                                                                Text="Select All"></asp:Localize></a>
                                                        </td>
                                                        <td  style="display: none;">
                                                            <a href="javascript:;" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string5" runat="server" 
                                                                Text="Deselect All"></asp:Localize></a>
                                                        </td>
                                                        <td  style="display: none;">
                                                            <a href="javascript:;" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string6" runat="server" 
                                                                Text="Undo Selection"></asp:Localize></a>
                                                        </td>
                                                        <td style="padding-left: 180px;">
                                                            <asp:LinkButton ID="LinkButton5" runat="server" onclick="LinkButton5_Click" 
                                                                ForeColor="Green" meta:resourcekey="LinkButton5Resource1">Queue Selected Users</asp:LinkButton>
                                                        </td>
                                                        <% if (!string.IsNullOrEmpty(WizardUsersQueued))
                                                           { %>
                                                        <td style="padding-left: 10px;">
                                                            <asp:LinkButton ID="LinkButton6" runat="server" onclick="LinkButton6_Click" 
                                                                ForeColor="Green" meta:resourcekey="LinkButton6Resource1">Clear Queued Users</asp:LinkButton>
                                                        </td>
                                                        <% } %>
                                                    </tr>
                                                </table>
                </td>
                <td align="right" style="padding-right: 20px">
                    
                        <asp:Button ID="LinkButton1" runat="server" 
                            OnClientClick="Wait1('Back')" CssClass="btn btn-default" OnClick="LinkButton1_Click" Width="128px"
                            meta:resourcekey="LinkButton1Resource1" Text="Back"></asp:Button>
                    
                    
                        <asp:Button ID="ContinueBth" runat="server" Width="128px"   
                            OnClientClick="Wait1('Applying Settings')" CssClass="btn btn-primary gladbtn gladbtn" OnClick="ContinueBth_Click"
                            meta:resourcekey="ContinueBthResource1" Text="Continue"></asp:Button>
                    
                    
                        <asp:Button ID="LinkButtonCancel" runat="server" Width="128px"
                            OnClientClick="Wait1('Closing...')" CssClass="btn btn-default" OnClick="LinkButtonCancel_Click"
                            meta:resourcekey="LinkButtonCancelResource1" Text="Cancel"></asp:Button>
                    
                </td>
            </tr>
        </table>
        
        <div id="searchModel" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><%=Button1.Text %></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <table width="100%">
            <tr>
                <td>
                                                <span style="vertical-align: top">
                                                    <asp:DropDownList ID="DomainList" runat="server" CssClass="browser-default custom-select secsubbordercolor"
                                                    meta:resourcekey="DomainListResource1">
                                                    </asp:DropDownList>
                                                </span>
                                            </td>
                </tr><tr>
                                            <td>
                                                <span style=" vertical-align: top">
                                                    <asp:DropDownList ID="SearchType" runat="server" CssClass="browser-default custom-select secsubbordercolor"
                                                     meta:resourcekey="SearchTypeResource1">
                                                    </asp:DropDownList>
                                                </span>
                                            </td>
                    </tr><tr>
                                            <td style="padding-right: 10px; padding-top:20px;">
                                                <asp:TextBox ID="Contains" runat="server"  CssClass="form-control"
                                                    meta:resourcekey="ContainsResource1"></asp:TextBox>
                                            </td>
            </tr>
        </table>
      </div>
      <div class="modal-footer">
          <button type="button" class="btn btn-primary gladbtn gladbtn" onclick="QueryUser();return false;"><asp:Localize meta:resourcekey="str_query" runat="server">Search</asp:Localize></button>
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
</div>
    </div>
    
    
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FullName").ToString().Replace("'","%27").Replace("\n"," "))%>', 
       '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27").Replace("\n"," ")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"KeyValue").ToString().Replace("'","%27").Replace("\n"," ")) %>', 
        '<%#DataBinder.Eval(Container.DataItem,"Added").ToString().Replace("'","%27").Replace("\n"," ") %>',
         '<%#DataBinder.Eval(Container.DataItem,"UserId").ToString().Replace("'","%27").Replace("\n"," ") %>'
       ]
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">
        var grid;
        function onchecked(e) {
            var c = document.getElementById("overallcheck");
            if (c.checked) {
                SelectAll();
            } else {
                DeSelectAll();
            }
        }
        var menu = null;
        function oncheckmenu(o) {
            var rect = o.getBoundingClientRect();
            
            var SelAllAct = new Ext.Action({
                text: "<%=Localize1.Text%>",
                handler: function () {
                    SelectAll();
                },
                scope: this
            });

            var DeSelAllAct = new Ext.Action({
                text: "<%=Localize2.Text%>",
                handler: function () {
                    DeSelectAll();
                },
                scope: this
            });

            var ReSelAllAct = new Ext.Action({
                text: "<%=Localize3.Text%>",
                handler: function () {
                    ReSelectAll();
                },
                scope: this
            });
            if (menu != null) {
              menu.close();
              menu = null;
          }
          
          
          menu = new Ext.menu.Menu({
                                id: 'grid-ctx',
                                items: [SelAllAct,DeSelAllAct,'-',ReSelAllAct]
                            });


          menu.showAt({ x: rect.left+4, y: rect.top+18 });
        }
    function AdjustBg() {

            
            try {
                var e = document.getElementById("mainw");
                var h1 = 168;
                 <%if(EditingTenant){ %>
                h1 = h1 + 50;
                <%} %>
                e.style.height = (document.documentElement.clientHeight - h1) + "px";
            } catch (err) {
                
            }
        }

    AdjustBg();
        function AdjustGridTable() {

            var h = 400;

            try{
                
                document.getElementById("ctl00_MainContent_Contains")
                .addEventListener("keyup", function(event) {
                    event.preventDefault();
                    if (event.keyCode == 13) {
                        QueryUser();
                    }
                });
            }catch(ee){

            }
            try {


                h = document.body.offsetHeight - 155;

              


            } catch (err) {
            }

            AdjustBg();
            grid.setWidth(document.documentElement.clientWidth - 35);
            
            grid.setHeight(h);
            grid.doComponentLayout();
            

        }
        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'fullname', sortType: 'asUCString' },
                    { name: 'email' },
                    { name: 'keyvalue' },
                    { name: 'added' },
                    { name: 'uid' }
                ],
                data: myData,
                sortOnLoad: true,
                sorters: [{ direction: "ASC", property: "fullname"}]

            });

            var ctl = '<input type="checkbox" id="overallcheck"  onclick="onchecked();"/> <button class="btn btn-default dropdown-toggle smallbtn" type="button" onclick="oncheckmenu(this);" style="margin-top:-2px;"><span class="caret" ></span></button>';

            grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                columnLines: false,
                border: false,
                scroll: true,
                layout: 'fit',
                
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hdide';
                        }
                    },
                     {
                         text: '',
                         width: 50,
                         sortable: false,
                         dataIndex: 'uid',
                         hidden: true,
                         renderer: function (value, metaData, record, rowIndex) {
                             return "<img style='border-radius: 50%;' src='/storage/avarta.dn?u="+unescape(value)+ "&w=32&h=32&d=<%=SessionDomainId%>'/>"  ;
                         }
                     },
                    {
                        text: "<asp:Localize meta:resourcekey="js_string1" runat="server">Full Name</asp:Localize>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'fullname',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100'>" + unescape(value) + "</span>";
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_dtl" runat="server">Details</asp:Localize>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'email',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100'>"+unescape( value )+"<span style='color:#404040; font-weight:100'>";
                        }
                    },
            {
                text: ctl,
                width: 80,
                sortable: false,
                dataIndex: 'keyvalue',
                renderer: function (value, metaData, record, rowIndex) {
                    var d = record.data;
                    if (value == "Organizational-Unit") {

                        return "<a href='#' onclick='DrillDownOU(\"" + d.fullname + "\");return false;' style='font-weight:100;'><asp:Localize meta:resourcekey="str_Browse" runat="server">Browse</asp:Localize></a>";
                    }
                    if (value == "CONTAINER") {

                        return "<a href='#' onclick='DrillDownConatiner(\"" + d.fullname + "\");return false;' style='font-weight:100;'><asp:Localize meta:resourcekey="str_Browse" runat="server">Browse</asp:Localize></a>";
                    }
                    
                    if (d.added.toLowerCase() == 'true')
                        return "<b><asp:Localize runat="server" meta:resourcekey="str_Add">Added</asp:Localize></b>";

                    if(d.email == "GROUP")
                        return "<input type='checkbox'  name='uu^user^" + d.email+"^"+d.uid + "' value='" + value + "' />";
                    return "<input type='checkbox'  name='uu^user^" + d.email + "' value='" + value + "' />";
                }
            }
        ],
                renderTo: 'grid-example'
            });

           AdjustGridTable();
                //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           Ext.EventManager.onWindowResize(AdjustGridTable);



        });

    </script>
</asp:Content>
