﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="WizardAppPanel.master"
    AutoEventWireup="true" CodeBehind="MigrateTaskList.aspx.cs" Inherits="GladinetPayFlow.MigrateTaskList"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td
        {
            font-size: 12px;
            
            font-weight: 100;
        }
        
        b
        {
            font-weight: 400;
        }
        
        .badgefont
        {
            font-size: 15px;
            
        }
    </style>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .roundbar .x-progress-bar
        {
            border-radius: 8px 8px 8px 8px;
        }
        
      
        
        .wrapper
        {
            width: 100%;
            height: auto !important;
      
            padding: 0px;
            background-color: white;
            margin: 0 auto -71px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }

        
    </style>
    <script type="text/javascript">

        function OnSyncSucc(){
            var e = document.getElementById("ctl00_MainContent_OnSyncComplete");
            e.click();
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].name.indexOf("uu_") == -1)
                    continue;
                if (Users[i].style.display == 'none') {
                    continue;
                }
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].name.indexOf("uu_") == -1)
                    continue;
                if (Users[i].style.display == 'none')
                    continue;

                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    if (Users[i].name.indexOf("uu_") == -1)
                        continue;
                    if (Users[i].style.display == 'none')
                        continue;
                    Users[i].checked = !Users[i].checked;
                }
            }
        }
        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        function onRetry()
        {
            window.location = window.location();
        }
        function OnPollRes(m) {
            try {

                
                
                
                if (stringStartsWith(m, "bad^")) {
                    var e = document.getElementById("PollRes");
                    e.innerHTML = m.substring(4);
                    e = document.getElementById("retrybtn");
                    e.style.display = "";
                    return;
                }
                if(m == "succeed"){
                    OnSyncSucc();
                    return;
                }
                if(m != "syncing"){
                    var e = document.getElementById("PollRes");
                    e.innerHTML = m;
                }
                
            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }

          function Poll() {

            try {
                Ext.Ajax.request({
                    url: '/management/AddUserWizard/MigrateTaskList.aspx?vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {                        
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToAddUseExcLicQuo" meta:resourcekey="str_faiToAddUseExcLicQuo" Visible="false">Failed to add user, exceed license quota</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaSynRes" meta:resourcekey="str_faiToLoaSynRes" Visible="false">Fail to load sync result</asp:Localize>
    <div class="wrapper">
        <table width="100%">
            <tr>
                <td align="center" style="padding-top:20px;">
                    <table cellspacing="0" width="100%" align="center" style="max-width:800px;">
                        <tr>
                            <td style="height: 68px; color: #565656; border-bottom: 0px solid #f0f0f0; border-top: 0; border-left: 0; border-right: 0; padding-left: 16px; vertical-align: middle; text-align: left; font-size: 16px;">
                                <table width="100%">
                                    <tr>
                                        <td style="font-size: 16px;">
                                            <h2 class="sectextcolor" style="font-weight: 100;">
                                                <asp:Localize meta:resourcekey="str_mtitle" runat="server">Migrate Share Content, Folder Permissions and User(s)  </asp:Localize>
                                            </h2>
                                        </td>
                                        <td align="right" style="padding-right: 20px;">
                                            <button type="button" class="btn btn-default " data-toggle="modal" data-target="#myModal" title="<%=AdvancedSettings.Text %>">
                                                <span class="fa fa-cog" aria-hidden="true" style="font-size: 14px; display: none;"></span>
                                                <asp:Localize meta:resourcekey="str_advanced" ID="AdvancedSettings"
                                                    runat="server" Visible="False" Text="Advanced Settings"></asp:Localize>
</button>
                                        </td>
                                    </tr>

                                </table>

                            </td>
                        </tr>
                        <tr>
<td style="padding: 0px; vertical-align: top; padding-top: 5px; overflow: hidden; padding-left: 20px;" id="maincontnt"><asp:Panel ID="SyncPanel" runat="server">
  <div style="padding:20px; border:1px solid #cccccc; border-radius:3px; ">
    <table cellspacing="0" cellpadding="0" width="100%" style="background-color: White; overflow: hidden;">
      <tr>
        <td style="height:200px" align="center" valign="middle"><img src="/webui/images/loading-home.gif" /> </td>
      </tr>
      <tr>
        <td style="font-size:18px; color:#565656; font-weight:100" align="center" id="PollRes"><asp:Localize ID="Localize8" meta:resourcekey="Syncing" runat="server"
                                                        Text="Syncing permission from server agent"></asp:Localize>
        </td>
      </tr>
    </table>
  </div>
</asp:Panel>
  <asp:Panel ID="SettingPanel" runat="server" meta:resourcekey="SettingPanelResource1" Visible="false">
    <table cellspacing="0" cellpadding="0" width="100%" style="background-color: White; overflow: hidden;">
      <tr style="display: none;">
        <td><h4>
            <asp:Localize ID="Localize1_1" meta:resourcekey="asp_string4" runat="server"
                                                        Text="Click 'Finish' to start processing migration tasks"></asp:Localize>
        </h4></td>
      </tr>
      <tr>
        <td align="center"><%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                                                    { %>
            <div id="errmsgdiv">
              <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
            </div>
          <%} %>
        </td>
      </tr>
      <tr>
        <td style="padding-top: 20px;"><asp:CheckBox ID="MigrateUser" runat="server" Text="Migrate User/Folder Permission"
                                                    Checked="True" meta:resourcekey="MigrateUserResource1" />  
        </td>
      </tr>
      <tr>
        <td style="padding-bottom: 20px; color: #565656; font-size: 14px; font-weight: 100;"><asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server"
                                                    Text="The user(s) selected from the list will be migrated to your cloud account when &quot;Migrate Share and Folder Permissions&quot; is checked."></asp:Localize>
            <asp:Localize ID="Localize5" meta:resourcekey="asp_string2" runat="server"
                                                    Text="Note: The migrated user(s) will be included in your account user quota."></asp:Localize>
          (<a href="#" data-toggle="modal" data-target="#myModal" class="sectextcolor">
            <asp:Localize meta:resourcekey="str_userlis" ID="str_userlis" runat="server">User List</asp:Localize>
          </a>) </td>
      </tr>
      <tr style="display: none;">
        <td colspan="2" style="padding-top: 10px;"><asp:CheckBox ID="VisibleHomeDir" runat="server" Text="Make user's home directory visible to administrator"
                                                    meta:resourcekey="VisibleHomeDirResource1" />  
        </td>
      </tr>
      <tr>
        <td colspan="2" style="padding-top: 10px;"><asp:CheckBox ID="ProxyOnly" runat="server" Text="Proxy Mode: don't migrate data to cloud"
                                                    meta:resourcekey="ProxyOnlyResource1" />  
        </td>
      </tr>
      <tr>
        <td colspan="2" style="padding-top: 10px;"><asp:CheckBox ID="AutoPermSync" ToolTip="When checked, the permissions from the source folders will be synchronized to the cloud automatically."
                                                    runat="server" Text="Synchronize folder permission automatically" Checked="True"
                                                    meta:resourcekey="AutoPermSyncResource1" />  
            
            <p class="text-muted" style="font-size: 14px; font-weight: 100;">
            <asp:Localize ID="Localize6" meta:resourcekey="str_synchint" runat="server">When checked, local permission changes will sync to the cloud automatically. The setting will not take effect until a restart of the client that owns the source folder. The source folder permissions will overwrite the current Team Folder permissions.</asp:Localize>
          </p>
            <br />
          &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
          <asp:CheckBox ID="ImportAllowedUser"
                                                    runat="server" Text="Only import user who has access to team folder (Only applies to permission auto-sync)" ToolTip="When checked, only the user who has access to the team folder will be created if the user doesn't exist" onclick="ShowSavePanel();" meta:resourcekey="str_olyIptUsrWhoHasAcs" />
          </td>
      </tr>
      <tr>
        <td colspan="2" style="padding-right: 40px; display: none;"><asp:Label ID="Pricing" runat="server" Font-Italic="True" Font-Size="14px" Font-Underline="True"
                                                    ForeColor="#009000" meta:resourcekey="PricingResource1"></asp:Label>
            <span style="color: #808080; display: none;">
            <asp:Localize ID="Localize7" meta:resourcekey="asp_string3" runat="server"
                                                        Text="administrator will see the users' home directory under administrator's &quot;Users&quot; directory."></asp:Localize>
              </span><br />
        </td>
      </tr>
    </table>
  </asp:Panel>
  <asp:Panel ID="SuccPanel" runat="server" Visible="False" meta:resourcekey="SuccPanelResource1">
    <table cellspacing="0" cellpadding="0" width="100%" style="background-color: White; overflow: hidden;">
      <tr>
        <td><h1>
            <asp:Localize meta:resourcekey="asp_string5" runat="server"
                                                        Text="Share has migrated"></asp:Localize>
        </h1></td>
      </tr>
      <tr>
        <td style="padding-top: 20px"><asp:Localize meta:resourcekey="asp_string6" runat="server"
                                                    Text="succeed, it is a two way synchronization to start. Later you can either keep the sync as it is or migrate to the cloud completely by phasing out the file server."></asp:Localize>
        </td>
      </tr>
    </table>
  </asp:Panel></td>
                        </tr>
                        <tr>
                <td align="right" style="padding-top:20px;">
                    <%if (NormalBtn.Visible){ %>
                    <asp:Button ID="LinkButton1" runat="server" Text="Back" OnClientClick="Wait('Back')" Width="128px"
                        CssClass="btn btn-default" OnClick="LinkButton1_Click" meta:resourcekey="LinkButton1Resource1"></asp:Button>
                    
                        <%if (SettingPanel.Visible){ %>
                        <asp:Button ID="ContinueBth" runat="server" Text="Migrate" OnClientClick="Wait('Applying Settings')" 
                            CssClass="btn btn-primary gladbtn gladbtn" OnClick="ContinueBth_Click" meta:resourcekey="ContinueBthResource1"></asp:Button>
                        <%} %>
                        <%if (SyncPanel.Visible){ %>
                        <button class="btn btn-primary gladbtn" style="display:none;" id="retrybtn" onclick="onRetry();return false;"><asp:Localize runat="server" meta:resourcekey="str_Ret">Retry</asp:Localize></button>
                        <%} %>
                        <asp:Button ID="LinkButtonCancel" runat="server" Text="Cancel" OnClientClick="Wait('Closing...')" 
                        CssClass="btn btn-default" OnClick="LinkButtonCancel_Click" meta:resourcekey="LinkButtonCancelResource1"></asp:Button>
                        <%} %>
                        <% if (ClosePanel.Visible)
                        { %>
                        <asp:Button ID="LinkButton2" runat="server" Text="Close" OnClientClick="Wait('Closing...')" 
                        CssClass="btn btn-default" OnClick="LinkButtonCancel_Click" meta:resourcekey="LinkButton2Resource1"></asp:Button>
                        <% } %>
                </td>
            </tr>
</table>

                </td>
                    
                
      </tr>
</table>
        
         
    </div>
    <div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog" style="width: 600px; min-width:600px;">

    <!-- Modal content-->
    <div class="modal-content" style="width:100%;">
      <div class="modal-header" style="background-color: #e0e0e0">
          <h4 class="modal-title"><%=str_userlis.Text %></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <table width="100%" style="padding: 8px;">
                                    <tr>
                               
                                <td  style="vertical-align: top; background-color: white;
                                    border-left: 0;">
                                    <table width="100%">
                                        <tr>
                                            <td style="overflow: auto; vertical-align: top;" id="grid-example">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" style="padding-top: 10px; display: <%=(SessionHasStorage )? "" :"none"%>;">
                                                <asp:CheckBox ID="DisablShareHomeDir" runat="server" Text="Disable sharing home directory content with external party"
                                                    meta:resourcekey="DisablShareHomeDirResource1" />
</td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" style="padding-top: 10px;">
                                                <asp:CheckBox ID="CreateDefaultDir" Checked="True" runat="server" Text="Create default folder(Documents, Pictures)"
                                                    meta:resourcekey="CreateDefaultDirResource1" />
                                            </td>
                                        </tr>
                                        <tr style="display: none;">
                                            <td style="height:16px; border-top: 1px solid #f8f8f8;">
                                                 <table width="100%">
                                                    <tr>
                                                        <td>
                                                            <a href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                                                color: #008000">
                                                                <asp:Localize ID="Localize2" meta:resourcekey="str_selall" runat="server">Select All</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                                <asp:Localize ID="Localize3" meta:resourcekey="str_desel" runat="server">Deselect All</asp:Localize>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                                <asp:Localize ID="Localize4" meta:resourcekey="str_undosel" runat="server">Undo Selection</asp:Localize>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
</table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
    </div>
    <asp:Panel ID="NormalBtn" runat="server" meta:resourcekey="NormalBtnResource1"> </asp:Panel>
    <asp:Panel ID="ClosePanel" runat="server" Visible="False" meta:resourcekey="ClosePanelResource1"> </asp:Panel>
    <div style="display:none">
    <asp:LinkButton ID="OnSyncComplete" runat="server" OnClick="OnSyncSucc_Click">LinkButton</asp:LinkButton>
</div>
    <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="DeviceRepeater" runat="server" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"Name") %>',
           '<%#DataBinder.Eval(Container.DataItem,"Value") %>',
           '<%#DataBinder.Eval(Container.DataItem,"Id") %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">


      var grid;
       function AdjustGridTable () {
           
        var h = 400;
          
        try {

            
           
            h = document.body.offsetHeight-150;

            var e = document.getElementById("maincontnt");
            e.style.height = h + "px";

        } catch (err) {
        }

        h=600;
              grid.setWidth(560);
              grid.setHeight(h-200);
              grid.doComponentLayout();


      }


        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'name' },
                    { name: 'sid' },
                    { name: 'created' }
                ],
                data: myData
            });



            grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                columnLines: false,
                border: false,
                frame: false,
                columns: [
           
                    {
                        text: "<asp:Localize meta:resourcekey="js_string1" runat="server">User Name</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'name',
            renderer: function (value, metaData, record, rowIndex) {
                    var d = record.data;
                    return "<span style='font-size:14px; font-weight:100; color:#404040;'>" + unescape(value) + " (" +d.sid+ ")</span>";
                }

            }, {
                text: '',
                width: '50px',
                sortable: true,
                dataIndex: 'sid',
                renderer: function (value, metaData, record, rowIndex) {
                    var d = record.data;
                    if (d.created == "1")
                        return '<input type="checkbox" style="display:none;" checked name="uu_'+value+'" value="'+value+'" >'+"<img width='24px' style='display:none;' src='/portal/images/checkmark.png'/>";
                    if(d.name.indexOf("[Proxied Group]") != -1)
                        return '<input type="checkbox" checked name="uu_'+value+'" value="'+value+'"  style="display:none">';
                    return '<input type="checkbox" checked name="uu_'+value+'" value="'+value+'" >';
                }

            }
        ],
                renderTo: 'grid-example'
            });

            <%if(SyncPanel.Visible){%>
        setTimeout("Poll()", 2000);
        <%}%>
             AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);

            ModelDisplayError('ctl00_MainContent_ErrorMsg');
        });


    </script>
</asp:Content>
