﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AddLocalStorage.aspx.cs" Inherits="GladinetPayFlow.AddLocalStorage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        
        .wrapper
        {
           
           
         
            padding: 0px;
            background-color: white;
            padding-bottom: 68px;

        }
        
       
    </style>

    <script type="text/javascript">
        function OnDelete() {
            
            gConfirm("<asp:Localize meta:resourcekey="str_cfmDel" runat="server">Confirm deletion. This will remove the storage/team folder, but the data will not be purged.</asp:Localize>", "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_DeleteBtn");
                    Wait("<asp:Localize meta:resourcekey="str_apyChg" runat="server">Apply Change</asp:Localize>");
                    e.click();
                }
            });
        }
    </script>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
          { %>        
    <div class="alert alert-warning alert-dismissible fade show" role="alert">
  <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                                </b>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
        
                                        
        <%} %>
    
    
        <table width="100%" border="0">            <tr> <td align="center" style="padding-top:30px;" 
            >
                    <table width="100%" align="center" style=" background-color: white; padding-top: 0px; padding-bottom: 0px; max-width:800px;"  
            cellspacing="0">
<tr><td>
        <asp:Panel ID="NamePanel" runat="server" meta:resourcekey="NamePanelResource1">
            <table width="100%"  align="center" style="padding: 0px; margin:0px;" cellspacing="0" cellpadding="0">
                <tr>
                     <td  style="border-top: 0; border-left: 0; border-right: 0; padding-left: 16px; vertical-align: top;
                    text-align: left; font-size: 16px;">
                        <table width="100%" style="padding-left:8px;padding-right:8px;">
                            <tr>
                                <td style="white-space:nowrap; color:#565656;padding-top: 20px;">
                                    
                                        <h2><asp:Localize meta:resourcekey="asp_string1" runat="server" 
                                        Text="Root Folder Name"></asp:Localize>
                                        </h2>
                                        <p class="text-muted">
                                            <asp:Localize ID="Localize2" meta:resourcekey="asp_string2" runat="server" 
                                        Text="This is the name of the top level folder in your cloud."></asp:Localize>
                                        </p>
                                    
                                </td>
                                </tr>
                                <tr>
                                <td  style="padding-left:0px;padding-right: 20px;padding-top: 0px;">
                                    <asp:TextBox ID="StorageName" runat="server"  meta:resourcekey="StorageNameResource1"
                                        CssClass="form-control"></asp:TextBox><asp:RequiredFieldValidator ControlToValidate="StorageName"
                                            ID="RequiredFieldValidator4" runat="server" ErrorMessage="Required" ForeColor="Red" ValidationGroup="CIFSSetting"
                                            Display="Dynamic" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator4Resource1"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            
                        </table>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <table width="100%" align="center" style="padding: 0px; background-color: white;
            margin: 0px; border:0px;" cellspacing="0">
            <tr>
                <td valign="top" colspan="4" style="border: 0px; padding: 3px;padding-left:16px; "
                    >
                    <table width="100%">
                        <tr>
                            <td>
                                <asp:Panel ID="CIFSPanel" runat="server" meta:resourcekey="CIFSPanelResource1">
                                    <table width="98%" align="center" style="padding: 3px; padding-top: 0px; padding-bottom: 0px;"
                                        cellspacing="0">
                                        <tr>
                                            <td style="border: 0px solid #d0d0d0; padding: 5px; border-top: 0px solid #C0C0C0;"
                                                class="tabpanel">
                                                <table width="100%">
                                                    <tr>
                                                        <td style="white-space:nowrap; color:#565656;padding-top: 20px;">
                                                            
                                                          <h2 style="font-weight:100;">  <asp:Localize meta:resourcekey="asp_string3" runat="server" 
                                                                Text="Local Storage Location (C:\myfolder or \\myfileserver\myshare):"></asp:Localize></h2>
                                                            
                                                                <asp:RequiredFieldValidator
                                                                ControlToValidate="StorageLocation" ID="RequiredFieldValidator1" runat="server"
                                                                ErrorMessage="Required" ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="CIFSSetting"
                                                                meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StorageLocation" runat="server" Width="100%" meta:resourcekey="StorageLocationResource1" CssClass="form-control"
                                                                ></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="white-space:nowrap; color:#565656;padding-top: 20px;">
                                                            <h2  style="font-weight:100;"><asp:Localize meta:resourcekey="asp_string4" runat="server" 
                                                                Text="User Name (for local storage access):"></asp:Localize></h2><asp:RequiredFieldValidator
                                                                ControlToValidate="StorageUser" ID="RequiredFieldValidator2" runat="server" ErrorMessage="Required"
                                                                ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="CIFSSetting"
                                                                meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StorageUser" runat="server" Width="100%" meta:resourcekey="StorageUserResource1" CssClass="form-control"
                                                                ></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="white-space:nowrap; color:#565656;padding-top: 20px;">
                                                            <h2  style="font-weight:100;"><asp:Localize meta:resourcekey="asp_string5" runat="server" 
                                                                Text="Password (for local storage access):"></asp:Localize></h2><asp:RequiredFieldValidator
                                                                ControlToValidate="StoragePassword" ID="RequiredFieldValidator3" runat="server"
                                                                ErrorMessage="Required" ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="CIFSSetting"
                                                                meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StoragePassword" runat="server" Width="100%" TextMode="Password" CssClass="form-control"
                                                                meta:resourcekey="StoragePasswordResource1" ></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <asp:Panel ID="FolderPanel" runat="server" Visible="False" 
                                                        meta:resourcekey="FolderPanelResource1">
                                                    
                                                    <tr>
                                                        <td style="padding-top: 5px">
                                                            <asp:Localize meta:resourcekey="asp_string7" runat="server" Text="Folder"></asp:Localize>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="Folder" runat="server" Width="90%" 
                                                                 CssClass="x-form-field x-form-text" meta:resourcekey="FolderResource1"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    </asp:Panel>
                                                    <tr>
                                                        <td>
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td  >
                                                            <asp:CheckBox ID="Impersonation" runat="server" Text="Always access the storage using this user identity" 
                                                                meta:resourcekey="ImpersonationResource1" /><br/>
                                                                <p class="text-muted" style="font-size: small">
                                                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string6" runat="server" 
                                                                Text="The specified user will be used to verify and access the storage for the admin account. When the above checkbox is selected, the storage will always be accessed using the team-user's Active Directory identity when the storage is published as a team folder. Non-Active Directory users will access the storage using the specified user account."></asp:Localize>
                        </p>
                                                            <br/>
                                                            <asp:CheckBox ID="SambaShare" runat="server"  Text="The share is from a Linux/Unix/ZFS Server" 
                                                                meta:resourcekey="SambaShareResource1" />
                                                            <br/>
                                                             <asp:CheckBox ID="DFSShare" runat="server" 
                                                        Text="The share is a DFS share" meta:resourcekey="DFSShareResource1" 
                                                        /> 
                                                        <br/>
                                                        <asp:CheckBox ID="EnableVersioning" runat="server" Visible="False"
                                                        Text="Enable Versioning" meta:resourcekey="EnableVersioningResource1" 
                                                        /> 
                                                       <asp:CheckBox ID="EnableInplaceVersion" runat="server" 
                                                        Text="Enable In-Place Versioning" meta:resourcekey="EnableInplaceVersionResource1" 
                                                        /> 

                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="middle" style="padding-left: 10px;">
                    <asp:Panel ID="WarnPanel" runat="server" Visible="False">
                    
                    <div class="alert alert-warning" style="padding: 5px!important;">
  <strong><asp:Localize meta:resourcekey="str_warn" runat="server">Warning!</asp:Localize></strong> <asp:Localize meta:resourcekey="str_warnbrand" runat="server">Branding materials, such as images and installer packages, are stored in the tenant's default storage. If the branding was configured before changing the storage location, it will need to be reset and re-configured.</asp:Localize>
</div>
                </asp:Panel>
                </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td align="right">
                      <% if(SessionStartFromServer){ %> 
                    <asp:Button ID="Button1" runat="server" TabIndex="7" CssClass="btn btn-default" Text="Back" CausesValidation="False" OnClick="ServerList_Click" meta:resourcekey="asp_bak"></asp:Button>
                      <%
                         Button1.OnClientClick = String.Format("Wait('{0}');return true;", LocPlsWat.Text);
                    } %>
                  <asp:LinkButton ID="LinkButton3" runat="server" OnClick="OnContinueClick" CssClass="btn btn-primary gladbtn gladbtn" CausesValidation="False" meta:resourcekey="LinkButton3Resource1" Text="Create"></asp:LinkButton>
                    <%
                       LinkButton3.OnClientClick = String.Format("Wait('{0}');", LocApyChg.Text);
                    %>
                                                    &nbsp;&nbsp;
                                                <asp:LinkButton ID="ButtonBack" runat="server" 
                                                    OnClientClick="showLoader(this.parentNode)" TabIndex="7" CssClass="btn"
                                                    CausesValidation="False" OnClick="ButtonBack_Click" 
                                                    meta:resourcekey="ButtonBackResource1" Text="Cancel"></asp:LinkButton>
                    <%
                        if (!NamePanel.Visible && !StorageName.Text.ToUpper().Contains("41ED6C26-D5F8-424F-A311-BB4FF88140E5"))
                        { %>&nbsp;&nbsp;
                    <asp:LinkButton ID="LinkButton1" runat="server" 
                                                     OnClientClick="OnDelete(); return false;" CssClass="btn btn-warning" CausesValidation="False"
                                                     Text="Delete"></asp:LinkButton>
                                                    &nbsp;&nbsp;
                    <% } %>
                </td>
            </tr>
        </table>
    </td></tr>
                        </td></tr></table>
    
    
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; display:none;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px;">
            <tr>
                
                
                
                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>

                <td colspan="3" align="right">
                    <asp:CheckBox ID="FromPub" runat="server" />
                    

                </td>
                <td style="display: none;">
                    <asp:LinkButton ID="DeleteBtn" runat="server" 
                                                     CssClass="btn"
                                                    CausesValidation="False" OnClick="DeleteBtn_Click" 
                                                    meta:resourcekey="ButtonBackResource1" Text="Cancel"></asp:LinkButton>
                </td>
            </tr>
        </table>
    </div>

    <asp:HiddenField ID="ImpersonationMode" runat="server" />
    <asp:HiddenField ID="StorageDomainId" runat="server" />
 
<script type="text/javascript">
    var e = document.getElementById("main_body_div");
    
    e.style.backgroundColor = "white";
</script>
</asp:Content>
