﻿<%@ Page Title="Add Data Seeding Task" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AddDataSeedingTask.aspx.cs" Inherits="GladinetPayFlow.AddDataSeedingTask" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .main {
            position: relative;
             min-height: 100%;
             height: auto !important;
        }     
        .wrapper
        {
           
           
         
            padding: 0px;
            background-color: white;
            padding-bottom: 68px;

        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        
        .footer {
            position: absolute;
            width: 100%;
            bottom: 0;
            left: 0;    
        }
        
        

        
        html , #Form1, .main, #aspnetForm
        {
          
            overflow: hidden;
        } 
        
    </style>


</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocFaiToAddTas" meta:resourcekey="str_faiToAddTas" Visible="false" runat="server">Failed to add task</asp:Localize>
<asp:Localize ID="LocFaiToVerSouLoc" meta:resourcekey="str_faiToVerSouLoc" Visible="false" runat="server">Failed to verify source location</asp:Localize>
<asp:Localize runat="server" ID="LocMisTasDes" meta:resourcekey="str_misTasDes" Visible="false">Missing task description</asp:Localize>
    
        
    
    <div class="wrapper" style="background-color: white;">
        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
          { %>        
         <div class="alert alert-warning fade in" id='errmsgdiv'>
           <a href="javascript:;" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                            <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                                </b>
                                        </div>
                                        
        <%} %>
        <table width="100%" align="center" style="padding: 0px; background-color: white; margin: 0px;"
            cellspacing="0" border="0">
            <tr>
                <td colspan="3" style="padding: 10px;color: #404040; border-bottom: 1px solid #f0f0f0">
                    <table width="100%">
                        <tr>
                            <td width="100px" style="font-size: 14px; font-weight: 100;"><h2><asp:Localize meta:resourcekey="str_dsc" runat="server">Description</asp:Localize></h2></td>
                            <td>
                                <asp:TextBox ID="TaskDesc" runat="server" cssclass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td style="color: #404040; padding: 10px; border-bottom: 1px solid #f0f0f0" width="46%">
                    <h2><asp:Localize meta:resourcekey="str_srcFrm" runat="server">Source (From)</asp:Localize></h2>
                </td>
                <td>&nbsp;</td>
                <td style="color: #404040; padding: 10px; padding-top: 20px; border-bottom: 1px solid #f0f0f0" width="46%">
                    <h2><asp:Localize meta:resourcekey="str_tgtTo" runat="server">Target (To)</asp:Localize></h2>
                </td>
            </tr>
            <tr>
                <td valign="top"  style="border: 0px; padding: 3px; padding-left: 16px;">

                    <table width="100%">
                        <tr>
                            <td>
                                <asp:Panel ID="CIFSPanel" runat="server" meta:resourcekey="CIFSPanelResource1">
                                    <table width="98%" align="center" style="padding: 3px; padding-top: 0px; padding-bottom: 0px;"
                                        cellspacing="0">
                                        <tr>
                                            <td style="border: 0px solid #d0d0d0; padding: 5px; border-top: 0px solid #C0C0C0;"
                                                class="tabpanel">
                                                <table width="100%">
                                                    <tr>
                                                        <td style="white-space: nowrap; color: #565656; padding-top: 20px;">

                                                            <h3>
                                                                <asp:Localize meta:resourcekey="asp_string3" runat="server"
                                                                    Text="Local Storage Location (C:\myfolder or \\myfileserver\myshare):"></asp:Localize></h3>

                                                            <asp:RequiredFieldValidator
                                                                ControlToValidate="StorageLocation" ID="RequiredFieldValidator1" runat="server"
                                                                ErrorMessage="Required" ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="CIFSSetting"
                                                                meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StorageLocation" runat="server" Width="100%" meta:resourcekey="StorageLocationResource1" CssClass="form-control"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="white-space: nowrap; color: #565656; padding-top: 20px;">
                                                            <h3>
                                                                <asp:Localize meta:resourcekey="asp_string4" runat="server"
                                                                    Text="User Name (for local storage access):"></asp:Localize></h3>
                                                            <asp:RequiredFieldValidator
                                                                ControlToValidate="StorageUser" ID="RequiredFieldValidator2" runat="server" ErrorMessage="Required"
                                                                ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="CIFSSetting"
                                                                meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StorageUser" runat="server" Width="100%" meta:resourcekey="StorageUserResource1" CssClass="form-control"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="white-space: nowrap; color: #565656; padding-top: 20px;">
                                                            <h3>
                                                                <asp:Localize meta:resourcekey="asp_string5" runat="server"
                                                                    Text="Password (for local storage access):"></asp:Localize></h3>
                                                            <asp:RequiredFieldValidator
                                                                ControlToValidate="StoragePassword" ID="RequiredFieldValidator3" runat="server"
                                                                ErrorMessage="Required" ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="CIFSSetting"
                                                                meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <asp:TextBox ID="StoragePassword" runat="server" Width="100%" TextMode="Password" CssClass="form-control"
                                                                meta:resourcekey="StoragePasswordResource1"></asp:TextBox>
                                                        </td>
                                                    </tr>
                                                    <asp:Panel ID="FolderPanel" runat="server" Visible="False"
                                                        meta:resourcekey="FolderPanelResource1">

                                                        <tr>
                                                            <td style="padding-top: 5px">
                                                                <asp:Localize meta:resourcekey="asp_string7" runat="server" Text="Folder"></asp:Localize>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:TextBox ID="Folder" runat="server" Width="90%"
                                                                    CssClass="x-form-field x-form-text" meta:resourcekey="FolderResource1"></asp:TextBox>
                                                            </td>
                                                        </tr>
                                                    </asp:Panel>
                                                    <tr>
                                                        <td>&nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>

                                                            <asp:CheckBox ID="SambaShare" runat="server" Text="The share is from a Linux/Unix/ZFS Server"
                                                                meta:resourcekey="SambaShareResource1" />
                                                            <br />
                                                            <asp:CheckBox ID="DFSShare" runat="server"
                                                                Text="The share is a DFS share" meta:resourcekey="DFSShareResource1" />


                                                        </td>
                                                    </tr>

                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                    </table>
                </td>
                <td  valign="middle" align="center">
                    <span class="fa fa-arrow-right" style="font-size: 48px; color: #008000;"></span>
                </td>
                <td valign="middle" style="padding: 10px;">
                    <table width="100%">
                        <tr>
                            <td>
                                <asp:DropDownList ID="TargetFolder" runat="server" CssClass="browser-default custom-select secsubbordercolor" OnSelectedIndexChanged="TargetFolder_SelectedIndexChanged" AutoPostBack="True"></asp:DropDownList>            
                            </td>
                        </tr>
                        <% if (TargetFolder.SelectedValue == "new"){ %>
                        <tr>
                            <td style="color: #404040; font-weight: 100; font-size: 16px; padding-top: 20px;"><asp:Localize meta:resourcekey="str_atdFldNme" runat="server">Attached Folder Name</asp:Localize></td>
                        </tr>
                        <tr>
                            <td style="color: #404040; font-weight: 100;">
                                <asp:TextBox ID="FolderName" runat="server" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                        <tr>
                            <td style="color: #404040; font-weight: 100; font-size: 16px; padding-top: 20px;"><asp:Localize meta:resourcekey="str_dvcToAtc" runat="server">Device to attach</asp:Localize></td>
                        </tr>
                         <tr>
                            <td style="color: #404040; font-weight: 100;">
                                <asp:DropDownList ID="DeviceList" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList>      
                            </td>
                        </tr>
                        

                        <% } %>
                    </table>
                    
                </td>

            </tr>



        </table>
    </div>
    
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px;">
            <tr>
                
                <td>
                    <div class="alert alert-info" style="height: 48px;">
  <asp:Localize meta:resourcekey="str_dtaSdgMayNotStr" runat="server">Data seeding may not start immediately.</asp:Localize>
</div>
                </td>
                
                <td colspan="3" align="right">
                     
                  <asp:LinkButton ID="LinkButton3" runat="server" 
                                                    OnClick="OnContinueClick" OnClientClick="Wait('Applying');" CssClass="btn btn-primary gladbtn gladbtn" CausesValidation="False"
                                                    meta:resourcekey="LinkButton3Resource1" Text="Create"></asp:LinkButton>
                                                    &nbsp;&nbsp;
                                                <asp:LinkButton ID="ButtonBack" runat="server" 
                                                    OnClientClick="showLoader(this.parentNode)" TabIndex="7" CssClass="btn"
                                                    CausesValidation="False" OnClick="ButtonBack_Click" 
                                                    meta:resourcekey="ButtonBackResource1" Text="Cancel"></asp:LinkButton>

                </td>
            </tr>
        </table>
    </div>

    <asp:HiddenField ID="ImpersonationMode" runat="server" />
    <asp:HiddenField ID="StorageDomainId" runat="server" />
 
<script type="text/javascript">
    var e = document.getElementById("main_body_div");
    
    e.style.backgroundColor = "white";
</script>
</asp:Content>
