﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="../WebAppPanel.master" ValidateRequest="false"
    AutoEventWireup="true" CodeBehind="AddAccessPolicy.aspx.cs" Inherits="GladinetPayFlow.AddAccessPolicy"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">


    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }
    </style>
    <script type="text/javascript">

        function ReturnLast() {
           window.location= "/management/AccessPolicy/AccessPolicyMgrPage.aspx?child=1&pdid=<%=PolicyDomainId.Value%>"
        }
        function ipMaskIsValid(str) {   
            var pat = /^\d+\.\d+\.\d+\.\d+$/;
            var part = str.trim();  
            if (part.indexOf("/") > -1) {
                var partsInner = part.split("/");
                if (partsInner.length == 2)
                {
                    if (pat.test(partsInner[0]) && pat.test(partsInner[1]))
                    { 
                        return true;
                    }
                }
            }
            return false;
        }
        function ValidateGoNext() {  
            var failed = true;
            if ($("#<%=NetworkList.ClientID %>")[0].selectedIndex >= 2) {
                var customIp = $("#<%=CustomIP.ClientID %>").val().trim();  
                customIp = customIp.replace(/\s+/g, '');
                customIp = customIp.replace(/^;*/, '');
                customIp = customIp.replace(/;*$/, '');
                $("#<%=CustomIP.ClientID %>").val(customIp);
                if (customIp.indexOf(";") > -1) {
                    var parts = customIp.split(";");
                    for (var i = 0; i < parts.length; i++) {
                        failed = !ipMaskIsValid(parts[i]);
                    }
                } else {
                    failed = !ipMaskIsValid(customIp);
                }
            } else {
                failed = false;
            }
            if (failed) {
                $("#ShortBody").html("<%=LocIvdIPMsk.Text%>"); //Invalid IP/Mask
                $('#modalAlert').modal({ backdrop: 'static', keyboard: false });
            } else {
                $("#<%=Step2ContinueBtn.ClientID %>")[0].click();
            }            
        } 

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocIPMIsEmp" meta:resourcekey="str_iPMIsEmp" runat="server" Visible="False">IP/Mask is empty</asp:Localize>
<asp:Localize ID="LocPolNamIsEmp" meta:resourcekey="str_polNamIsEmp" runat="server" Visible="False">Policy name is empty</asp:Localize>    
<asp:Localize ID="LocIvdIPMsk" meta:resourcekey="str_ivdIPMsk" runat="server" Visible="False">Invalid IP/Mask</asp:Localize>
    <asp:Localize ID="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>

    <%if (!IsChildUi)
        { %>
    <div style="width: 100%; padding: 5px;" class="meubardrop">
        <table style="width: 100%">
            <tr>
                <td>
                    <button class="btn btn-primary gladbtn" style="font-weight: 400!important; font-size: 20px!important;">
                        Add New Access Policy
                    </button>
                </td>
                <td style="font-weight: 100; font-size: 18px; color: red;">
                    <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
                </td>
                <td style="padding-right: 10px;">
                    <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                </td>
            </tr>
        </table>
    </div>
    <%} %>
    <div class="wrapper" style="background-color: white; width: 100%; margin-top: 30px; font-size: 18px; align-content: center; <%if (IsChildUi){ %>padding: 20px; <%} %>">
        <asp:Panel ID="Step1Panel" runat="server">
            <table width="100%" style="max-width: 800px;" align="center">
                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #404040; font-weight: 400; padding-top: 60px;"><asp:Localize meta:resourcekey="str_pleentpolnambel" runat="server">Please enter policy name  below:</asp:Localize></td>
                </tr>
                <tr>
                    <td style="padding: 15px;">
                        <asp:TextBox ID="PolicyName"  runat="server" CssClass="form-control"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton ID="Step1Contine" runat="server" CssClass="btn btn-primary gladbtn" OnClick="Step1Contine_Click">Next</asp:LinkButton>
                        <asp:LinkButton ID="CancelBtn" CssClass="btn btn-default gladbtn" OnClientClick="ReturnLast();return false;" runat="server">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="Step2Panel" runat="server" Visible="false">
            <table width="100%" style="max-width: 800px;" align="center">

                <tr>
                    <td style="padding: 15px; font-size: 18px; color: #404040; font-weight: 400; padding-top: 60px;"><asp:Localize meta:resourcekey="str_pleentacccon" runat="server">Please enter access condition:</asp:Localize></td>
                </tr>
                <tr>
                    
                    <td style="padding: 15px;">
                        <asp:DropDownList ID="NetworkList" runat="server" CssClass="browser-default custom-select secsubbordercolor" AutoPostBack="true" OnSelectedIndexChanged="Network_changed"></asp:DropDownList>  

                    </td>
                </tr>
                <tr>                    
                    <td style="padding: 15px;">
                        <asp:Panel ID="IPPanel" runat="server" Visible="false">
                            (IP/Mask;IP/Mask, i.e. 254.234.234.128/255.255.255.0; 192.234.234.128/255.255.255.0)
                            <asp:TextBox   ID="CustomIP"  runat="server"    CssClass="form-control"></asp:TextBox>
                        </asp:Panel>
                    </td>
                </tr>

                                  

                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton ID="Step2Back" runat="server" CssClass="btn btn-default gladbtn" OnClick="Step2Back_Click">Back</asp:LinkButton>
                        <a class="btn btn-primary gladbtn" href="javascript:;" onclick="ValidateGoNext();">Next<div class="ripple-container"></div></a>
                        <div style="display:none;">
                        <asp:LinkButton ID="Step2ContinueBtn" runat="server" CssClass="btn btn-primary gladbtn" OnClick="Step2Contine_Click">Next</asp:LinkButton>
                        </div>
                        <asp:LinkButton ID="LinkButton2" CssClass="btn btn-default gladbtn" OnClientClick="ReturnLast();return false;" runat="server">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="Step3Panel" runat="server" Visible="false">
            <table  style="max-width: 800px;" align="center">

                <tr>
                    
                    <td style="padding: 15px;">
                        <asp:DropDownList ID="DenyAllowList" runat="server" CssClass="browser-default custom-select secsubbordercolor" ></asp:DropDownList>  

                    </td>
                </tr>
                <tr>
                    
                    <td style="padding: 15px;">
                        <table width="100%">
                            <tr class="filerow">
                                <td style="width:40px;padding:5px" align="center">
                                    <asp:CheckBox ID="DisableWebClient" runat="server" CssClass="form-check"/>
                                </td>
                                <td style="padding:5px; font-size:14px; color:#565656; font-weight:100;"><asp:Localize meta:resourcekey="str_webcli" runat="server">Web Client</asp:Localize></td>

                            </tr>
                             <tr class="filerow">
                                <td style="width:40px;padding:5px" align="center">
                                    <asp:CheckBox ID="DisableMMC" runat="server" CssClass="form-check"/>
                                </td>
                                <td style="padding:5px; font-size:14px; color:#565656; font-weight:100;"><asp:Localize meta:resourcekey="str_webman" runat="server">Web Management </asp:Localize></td>

                            </tr>
                            <tr class="filerow">
                                <td style="width:40px;padding:5px" align="center">
                                    <asp:CheckBox ID="DisableWinClient" runat="server" CssClass="form-check"/>
                                </td>
                                <td style="padding:5px; font-size:14px; color:#565656; font-weight:100;"><asp:Localize meta:resourcekey="str_wincli" runat="server">Windows Client</asp:Localize></td>

                            </tr>
                            <tr class="filerow">
                                <td style="width:40px;padding:5px" align="center">
                                    <asp:CheckBox ID="DisableMacClient" runat="server" CssClass="form-check"/>
                                </td>
                                <td style="padding:5px; font-size:14px; color:#565656; font-weight:100;"><asp:Localize meta:resourcekey="str_maccli" runat="server">Mac Client</asp:Localize></td>

                            </tr>
                            <tr class="filerow">
                                <td style="width:40px;padding:5px" align="center">
                                    <asp:CheckBox ID="DisableMobileClient" runat="server" CssClass="form-check"/>
                                </td>
                                <td style="padding:5px; font-size:14px; color:#565656; font-weight:100;"><asp:Localize meta:resourcekey="str_mobcli" runat="server">Mobile Client</asp:Localize></td>

                            </tr>


                        </table>

                    </td>
                </tr>
                



                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton ID="LinkButton1" runat="server" CssClass="btn btn-default gladbtn" OnClick="Step3Back_Click">Back</asp:LinkButton>
                        <asp:LinkButton ID="LinkButton3" runat="server" CssClass="btn btn-primary gladbtn" OnClick="Step3Contine_Click">Commit</asp:LinkButton>
                        <asp:LinkButton ID="LinkButton4" CssClass="btn btn-default gladbtn" OnClientClick="ReturnLast();return false;" runat="server">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </asp:Panel>


    </div>

    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>
        <asp:HiddenField ID="SavedInfo" runat="server" />
        <asp:HiddenField ID="PolicyId" runat="server" />
        <asp:HiddenField ID="PolicyDomainId" runat="server" /> 
    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>

    <script type="text/javascript">
     
    </script>
    
    <div id="modalAlert" class="modal fade" role="dialog">
        <div class="modal-dialog " style="width:350px; max-width:350px;">
            <div class="modal-content">
                <div class="modal-body" style="height:10px;padding-top:50px;text-align:center;" id="ShortBody">
                </div> 
                <div class="modal-footer" style="border-top: 0px solid #d0d0d0;">
                    <table width="100%">
                        <tr style="border-top: 0px solid #d0d0d0;">
                            <td  height="3px">&nbsp;</td>
                        </tr>
                        <tr>
                            <td style="border-right: 0px solid #d0d0d0; padding-right:10px;" align="right">
                                <button type="button" id="confirmOkBtn" class="btn btn-link" data-dismiss="modal" style="width:100px;font-weight: 400; font-size:16px;"><asp:Localize runat="server" meta:resourcekey="str_Ok">Ok</asp:Localize></button>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

        </div>
    </div>
</asp:Content>
