/*
 * Decompiled with CFR 0.152.
 */
package com.gladinet;

import com.gladinet.GladTask;
import com.gladinet.WcfClientLibStorage;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import netscape.javascript.JSObject;

public class Uploader
extends JApplet
implements DropTargetListener,
Runnable {
    public String mRootPath = "";
    public String mUrl = "";
    public String mToken = "";
    public String mRootCloud = "";
    private Container _container;
    private GridBagLayout _gridBagLayout;
    private GridBagConstraints _gridBagContainer;
    private JLabel _dropZone;
    public ArrayList mTaskQ;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JProgressBar jProgressBar1;
    private JProgressBar jProgressBar2;

    @Override
    public void init() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Uploader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Uploader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Uploader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Uploader.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Uploader.this.setBackground(Color.WHITE);
                    Uploader.this.LoadDropTarget();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Object[] args = new Object[]{"pp", "pp"};
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("OnAppletReady", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Uploader.this.ProcessTaskQ();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void LoadDropTarget() {
        this.setLayout(new BorderLayout());
        this._container = new Container();
        this.add((Component)this._container, "Center");
        this._gridBagLayout = new GridBagLayout();
        this._container.setLayout(this._gridBagLayout);
        GridBagConstraints _gridBagContainer = new GridBagConstraints();
        _gridBagContainer.anchor = 18;
        _gridBagContainer.fill = 1;
        _gridBagContainer.weighty = 0.6;
        _gridBagContainer.weightx = 1.0E-5;
        _gridBagContainer.gridy = 0;
        _gridBagContainer.gridx = 0;
        _gridBagContainer.gridheight = 1;
        _gridBagContainer.gridwidth = 1;
        _gridBagContainer.insets = new Insets(1, 0, 1, 1);
        BufferedImage img = null;
        try {
            URL url = new URL(this.getCodeBase(), "images/upload.png");
            img = ImageIO.read(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._dropZone = img == null ? new JLabel("Drag and Drop Files Here") : new JLabel(new ImageIcon(img));
        this._dropZone.setVerticalAlignment(0);
        this._dropZone.setHorizontalAlignment(0);
        this._dropZone.setBackground(Color.white);
        this._container.add(this._dropZone);
        this._container.setBackground(Color.white);
        this._gridBagLayout.setConstraints(this._dropZone, _gridBagContainer);
        new DropTarget(this._dropZone, this);
    }

    public void StartProcessTask(String Token, String RootCloudFolder, String Uri) {
        this.mToken = Token;
        this.mUrl = Uri;
        this.mRootCloud = RootCloudFolder;
        this.jProgressBar1.setIndeterminate(false);
        this.jProgressBar1.setMaximum(100);
        this.jProgressBar1.setValue(0);
    }

    public void LoadProgressWindow() {
        this.getContentPane().remove(this._container);
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jProgressBar2 = new JProgressBar();
        this.jLabel1.setText("Overall Progress :");
        this.jLabel2.setText("File Progress :");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(64, 64, 64).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jProgressBar1, -1, 402, Short.MAX_VALUE).addComponent(this.jProgressBar2, -1, -1, Short.MAX_VALUE)).addContainerGap(79, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jProgressBar1, -2, 20, -2).addGap(29, 29, 29).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jProgressBar2, -2, 20, -2).addContainerGap(116, Short.MAX_VALUE)));
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void ProcessFolder(File dir, ArrayList Taskq, String RootPath) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        GladTask t1 = new GladTask();
        t1.TaskName = "MKCOL";
        t1.TaskPara1 = RootPath;
        t1.TaskPara2 = RootPath;
        t1.TaskSize = 0L;
        Taskq.add(t1);
        for (int i = 0; i < files.length; ++i) {
            String CloudName = "";
            CloudName = RootPath.isEmpty() ? files[i].getName() : RootPath + "/" + files[i].getName();
            if (files[i].isDirectory()) {
                this.ProcessFolder(files[i], Taskq, CloudName);
                continue;
            }
            GladTask t = new GladTask();
            t.TaskName = "PUT";
            t.TaskPara1 = files[i].getAbsolutePath();
            t.TaskPara2 = CloudName;
            t.TaskSize = files[i].length();
            t.file = files[i];
            Taskq.add(t);
        }
    }

    public void SetOverAllProgress(int Progress, String Text) {
        try {
            Object[] args = new Object[]{Progress, Text};
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("SetProgress", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void SetCurrentProgress(int Progress, String Text) {
        try {
            Object[] args = new Object[]{Progress, Text};
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("CurrentProgress", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void SetErrorMessage(String Text) {
        try {
            Object[] args = new Object[]{Text};
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("SetErrorMsg", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ProcessTaskQ() {
        JSObject win = null;
        try {
            win = JSObject.getWindow((Applet)this);
            win.call("OnTaskReadyToProcess", null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; i < this.mTaskQ.size(); ++i) {
            GladTask t = (GladTask)this.mTaskQ.get(i);
            int Progress = (i + 1) * 100 / this.mTaskQ.size();
            String Pt = "Overall Progress: " + i + " of " + this.mTaskQ.size() + " Tasks Processed";
            this.SetOverAllProgress(i * 100 / this.mTaskQ.size(), Pt);
            String CloudPath = this.mRootCloud.isEmpty() ? t.TaskPara2 : this.mRootCloud + "/" + t.TaskPara2;
            if (t.TaskName.compareToIgnoreCase("PUT") == 0) {
                int code = 0;
                for (int ii = 0; ii < 3 && (code = this.UploadFile(t.file, CloudPath)) >= 300; ++ii) {
                }
                if (code > 300) {
                    if (code == 403) {
                        this.SetErrorMessage("Sorry, unabled to upload file (Access Denied):" + CloudPath);
                    } else {
                        this.SetErrorMessage("Sorry, unable to upload file:" + CloudPath);
                    }
                    return;
                }
            } else if (t.TaskName.compareToIgnoreCase("MKCOL") == 0) {
                this.SetCurrentProgress(0, "Create Directory:" + CloudPath);
                boolean ret = false;
                WcfClientLibStorage client = new WcfClientLibStorage();
                client.x_glad_token = this.mToken;
                client.updateUserEndPoint(this.mUrl.replace("/storage/proxiedupload.up", "/namespace/n.svc/"));
                for (int ii = 0; ii < 3 && !(ret = client.JsonMkDir(CloudPath)); ++ii) {
                }
                if (!ret) {
                    this.SetErrorMessage("Failed to create folder:" + CloudPath);
                    return;
                }
            }
            Pt = "Overall Progress: " + (i + 1) + " of " + this.mTaskQ.size() + " Tasks Processed";
            this.SetOverAllProgress((i + 1) * 100 / this.mTaskQ.size(), Pt);
            System.out.println("Porcessed:" + t.TaskName + "," + t.TaskPara1 + "," + t.TaskPara2 + "," + t.TaskSize + "," + CloudPath);
            this.jProgressBar1.setValue(Progress);
        }
        try {
            Object[] args = new Object[]{"haa"};
            win = JSObject.getWindow((Applet)this);
            win.call("OnTaskCompleted", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ProcessFiles(File[] files) {
        ArrayList<GladTask> Taskq = new ArrayList<GladTask>();
        for (int i = 0; i < files.length; ++i) {
            String CloudName = this.mRootPath.isEmpty() ? files[i].getName() : this.mRootPath + "/" + files[i].getName();
            if (files[i].isDirectory()) {
                this.ProcessFolder(files[i], Taskq, CloudName);
                continue;
            }
            GladTask t = new GladTask();
            t.TaskName = "PUT";
            t.TaskPara1 = files[i].getAbsolutePath();
            t.TaskSize = files[i].length();
            t.TaskPara2 = CloudName;
            t.file = files[i];
            Taskq.add(t);
        }
        this.mTaskQ = Taskq;
        this.LoadProgressWindow();
        new Thread(this).start();
    }

    public void SelectFilesToUpload() {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setMultiSelectionEnabled(true);
                    fileChooser.setFileSelectionMode(2);
                    int returnVal = fileChooser.showOpenDialog(null);
                    if (returnVal == 0) {
                        File[] files = fileChooser.getSelectedFiles();
                        Uploader.this.ProcessFiles(files);
                    } else {
                        System.out.println("Open command cancelled by user.");
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jProgressBar2 = new JProgressBar();
        this.jLabel1.setText("Overall Progress :");
        this.jLabel2.setText("File Progress :");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(64, 64, 64).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jProgressBar1, -1, 402, Short.MAX_VALUE).addComponent(this.jProgressBar2, -1, -1, Short.MAX_VALUE)).addContainerGap(79, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(33, 33, 33).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jProgressBar1, -2, 20, -2).addGap(29, 29, 29).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jProgressBar2, -2, 20, -2).addContainerGap(116, Short.MAX_VALUE)));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        try {
            Object[] args = new Object[]{"haa"};
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("OnDragEnter", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        try {
            Object[] args = new Object[]{"haa"};
            JSObject win = JSObject.getWindow((Applet)this);
            win.call("OnDragLeave", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        int action = dtde.getDropAction();
        dtde.acceptDrop(action);
        this.fromTransferable(dtde.getTransferable());
        dtde.dropComplete(true);
    }

    private void fromTransferable(Transferable t) {
        if (t == null) {
            return;
        }
        try {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                File[] files = new File[fileList.size()];
                for (int i = 0; i < fileList.size(); ++i) {
                    File f;
                    files[i] = f = (File)fileList.get(i);
                }
                this.ProcessFiles(files);
            } else {
                DataFlavor df = DataFlavor.selectBestTextFlavor(flavors);
                JOptionPane.showMessageDialog(this, "df: " + df);
                JOptionPane.showMessageDialog(this, "t.getTransferData(df): " + t.getTransferData(df));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1024 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int UploadFile(File file, String CloudPath) {
        long len;
        block9: {
            this.jProgressBar2.setIndeterminate(false);
            this.jProgressBar2.setMaximum(100);
            this.jProgressBar2.setValue(0);
            len = file.length();
            if (len <= 1572864000L) break block9;
            JOptionPane.showMessageDialog(this, "File is too big: " + file.getName() + ", please upload file larger than 1500M using a native client");
            int n = 200;
            return n;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int bufferLength = 4096;
            byte[] bytes = new byte[bufferLength];
            long index = 0L;
            String pt = "Current Progress: " + file.getName() + " (" + Uploader.humanReadableByteCount(index, true) + " of " + Uploader.humanReadableByteCount(len, true) + " bytes uploaded)";
            int Progress = 0;
            this.SetCurrentProgress(Progress, pt);
            URL url = new URL(this.mUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.addRequestProperty("x-glad-token", this.mToken);
            connection.addRequestProperty("x-glad-altpath", URLEncoder.encode(CloudPath, "UTF-8"));
            connection.addRequestProperty("x-glad-lastdate", "" + file.lastModified());
            connection.setFixedLengthStreamingMode(len);
            OutputStream outputStream = connection.getOutputStream();
            int progress = 0;
            while (index < len) {
                long readSize = len - index;
                if (readSize > (long)bufferLength) {
                    readSize = bufferLength;
                }
                fileInputStream.read(bytes, 0, (int)readSize);
                outputStream.write(bytes, 0, (int)readSize);
                progress = (int)((float)(index += readSize) / (float)len * 99.0f);
                pt = "Current Progress: " + file.getName() + " (" + Uploader.humanReadableByteCount(index, true) + " of " + Uploader.humanReadableByteCount(len, true) + " bytes uploaded)";
                this.SetCurrentProgress(progress, pt);
            }
            fileInputStream.close();
            pt = "Current Progress: " + file.getName() + " (finalize)";
            this.SetCurrentProgress(99, pt);
            outputStream.flush();
            outputStream.close();
            int code = connection.getResponseCode();
            if (code < 300) {
                pt = "Current Progress: " + file.getName() + " (Uploaded)";
                this.SetCurrentProgress(100, pt);
            } else {
                pt = code == 403 ? "Current Progress: " + file.getName() + " (failed to upload, access denied)" : "Current Progress: " + file.getName() + " (failed to upload)";
                this.SetCurrentProgress(100, pt);
            }
            int n = code;
            return n;
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "Failed to upload file: " + file.getName() + ", exception:" + e1.getMessage());
        }
        return 500;
    }
}

