﻿<%@ Page Title="Aviary Image Processor" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="Aviary.aspx.cs" Inherits="GladinetPayFlow.Aviary" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
            padding-left: 5px;
        }
        
        input
        {
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
        }
    </style>
    <script type="text/javascript">
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d !== null && d !== undefined) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //document.body.style.backgroundColor = "White";

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        

    </script>
    <script type="text/javascript" src="https://dme0ih8comzn4.cloudfront.net/js/feather.js"></script>
    <script type="text/javascript">

        var featherEditor = new Aviary.Feather({
            apiKey: 'w12wl9ya5by27gfu',
            apiVersion: 3,
            theme: 'dark', // Check out our new 'light' and 'dark' themes!
            tools: 'all',
            appendTo: 'test',
            noCloseButton: 'true',
            minimumStyling: 'true',
            postUrl: '<%=PostUrl.Value %>',
            onSave: function (imageID, newURL) {
                var img = document.getElementById(imageID);
                img.src = newURL;
            },
            onError: function (errorObj) {
                alert(errorObj.message);
            },
            onLoad: function () {
                launchEditor('editableimage1', '<%=FileLink.Value %>');
            }
        });
        function launchEditor(id, src) {
            featherEditor.launch({
                image: id,
                url: src
            });
            return false;
        }

</script>   
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

<div id="test' style="width:2000px; position:absolute; left:0px;"></div>
    <img id="editableimage1" style="display:none" src="<%=FileLink.Value %>"   />
    <asp:HiddenField ID="FileLink" runat="server" />
    <asp:HiddenField ID="PostUrl" runat="server" />
</asp:Content>
