// run.js // Performs a post-build fixup of an msi

if (WScript.Arguments.Length != 2)
{
       WScript.StdErr.WriteLine(WScript.ScriptName + " file.msi banner.bmp");
       WScript.Quit(1);
}

var filespec = WScript.Arguments(0);
var installer = WScript.CreateObject("WindowsInstaller.Installer");
var database = installer.OpenDatabase(filespec, 1/*msiOpenDatabaseModeTransact*/);

var bannerBmpFile = WScript.Arguments(1);

var sql
var view
var record

try {

    WScript.Echo("UPDATE default banner image");
    sql = "UPDATE `Binary` SET `Data` = ? WHERE `Name` ='DefBannerBitmap'";
    view = database.OpenView(sql)
    record = installer.CreateRecord(1);
    record.SetStream(1, bannerBmpFile );
    view.Execute(record);
    view.Close();
	
	sql = "UPDATE `Control` SET `Text` = 'DefBannerBitmap' WHERE `Control`= 'BannerBmp' and `Type` ='Bitmap'";
    view = database.OpenView(sql)

    view.Execute();
    view.Close();
    
	//WScript.Echo("ADD splash image");
    //sql = "INSERT INTO `Binary` (`Name`, `Data`) VALUES ('DefSplashBitmap', ?)";
    //view = database.OpenView(sql)
    //record = installer.CreateRecord(1);
    //record.SetStream(1, "C:\\Installer_splash_img.jpg");
    //view.Execute(record);
    //view.Close();

    //WScript.Echo("Update splash control");
    //sql = "UPDATE `Control` SET `Text`='DefSplashBitmap' WHERE `Dialog_`='SplashForm' AND `Control`='SplashBmp'";
    //view = database.OpenView(sql)
    //view.Execute();
    //view.Close();
    
	database.Commit();
}
catch (e) {
    WScript.StdErr.Write("|||ERROR||| ");
    WScript.StdErr.WriteLine(e.Message);
    WScript.Quit(1);
}