﻿//This file extends the FileUpload.js capabilities by adding a TaskManager for multiple drag-and-drop uploads
//The progress bar does not use Ext
var UploadingFiles;
var CanFolderWrite = true;
var ViewOnly = false;
var CanFileWrite = true;
var LastUploadFile = null;
var StopProcessing = false;
var SupportWebChunk = false;
var gTaskPanel = null;
var gProgressBar = null;
var gProcessedIndex = 0;
var gProcessedBytes = 0;
var gCurrentProcessedBytes = 0;
var gInProcessing = false;
var gTaskContainer = null;
var str = [];
var pending = 0;
var files = [];


function CheckRemainingTasks() {
    if (gFailedTaskQueue.length == 0 && gTaskQueue.length == 0 && !gInProcessing) {
        CloseTask();
    }
}

function CancelProcessing() {
    gConfirm(ExplorerDetail_1709_1_Confirm_Stop, ExplorerDetail_1709_2_uploading_task, function (btn, text) {
        if (btn == 'ok' || btn == 'yes') {
            StopProcessing = true;
            try {
                OutstandingReq.abort();

            } catch (e) {
            }
            CloseTask();
            return;
        }
    }, this);     // this is the scope for the call back function
}
function ShowTaskManPanel() {
    if (gTaskContainer == null) return;
    var e = document.getElementById("titeltr");
    e.style.display = '';
    e = document.getElementById("ctltr");
    e.style.display = '';

    e = document.getElementById("ctltd");
    e.innerHTML = "<span onclick='CancelProcessing(); return false;' class='gladinet-icons secpaneltextcolor' style='font-size:28px;'></span>&nbsp; &nbsp;<span onclick='HideTaskPanel(); return false;' class='gladinet-icons secpaneltextcolor' style='font-size:28px;'>&#x136;</span>"
    e.style.paddingBottom = "5px";

    e = document.getElementById("restortd");
    e.style.display = "none";

    e = document.getElementById("subtaskpanel");
    e.style.display = '';

    e = document.getElementById("GProgressError");
    e.style.display = "none";

    gTaskContainer.style.height = (document.body.offsetHeight - 80) + "px";
    gTaskContainer.style.top = "70px";

}
function NoExtProgBar() {
    this.id = "";
    this.label = "";//example: Uploading...
    this.height = "15px";
    this.percentage = 0;
    this.renderTo = "";
    this.getHTML = function () {
        var progBarCode = new Array();
        progBarCode[0] = "<div class=\"x-progress-text x-progress-text-back\" id=\"ext-gen" + this.id + "\">" + this.label + "</div>";
        progBarCode[1] = "<div id=\"progressbar-" + this.id + "-bar\" class=\"x-progress-bar x-progress-bar-default\" style=\"width:100%; background-color: rgb(62, 198, 198);\">";
        progBarCode[2] = "     <div class=\"x-progress-text\" id=\"ext-gen" + this.id + "\">";
        progBarCode[3] = "          <div>" + this.label + "</div>";
        progBarCode[4] = "     </div>";
        progBarCode[5] = "</div>";
        return progBarCode.join("");
    };
    this.getPerWidth = function () {
        return (Math.round(parseFloat(this.percentage) * 100) + "%");
    }
    this.render = function () {
        var obj = document.getElementById("progressbar-" + this.id);
        if (obj) {
            //progbar exists, just update the width 
            obj.style.width = this.getPerWidth();
        } else {
            var par = document.getElementById(this.renderTo);
            if (par) {
                var newDiv = document.createElement("div");
                newDiv.className = "x-progress roundbar x-progress-default x-border-box";
                newDiv.style = "border-width:0;width:" + this.getPerWidth() + ";height:" + this.height + ";"
                newDiv.id = "progressbar-" + this.id;
                newDiv.innerHTML = this.getHTML();
                par.appendChild(newDiv);
            }
        }
    };
    this.updateProgress = function (per, txt) {
        this.percentage = per;
        if (txt) {
            if (txt != "") this.label = txt;
        }
        this.render();
    };
}
function CreateTaskPanel() {
    if (gTaskContainer != null) return;

    var e = document.getElementById("right_panel");

    var taskpanelcontainer = document.createElement("div");
    taskpanelcontainer.style.position = "absolute";
    taskpanelcontainer.style.height = (document.body.offsetHeight - 80) + "px";
    taskpanelcontainer.style.border = "1px solid #f0f0f0";
    taskpanelcontainer.style.padding = "3px";
    taskpanelcontainer.className = "viewcard secsubbordercolor";
    taskpanelcontainer.id = "taskcontainer";

    document.body.appendChild(taskpanelcontainer);
    gTaskContainer = taskpanelcontainer;
    try {
        if (parent.gMobileView == "true") {
            taskpanelcontainer.style.top = "0px";
            taskpanelcontainer.style.left = "0px";
            taskpanelcontainer.style.width = "100%";
        } else {
            taskpanelcontainer.style.top = "70px";
            taskpanelcontainer.style.right = "10px";
            taskpanelcontainer.style.width = "400px";
        }
    } catch (p) { }

    var taskpanel = document.createElement("div");
    taskpanelcontainer.appendChild(taskpanel);
    taskpanel.id = "taskpanel";
    taskpanel.style = "width:100%;padding:5px;height:120px; overflow:visible; background-color:white";

    var subtaskpanel = document.createElement("div");
    taskpanelcontainer.appendChild(subtaskpanel);
    subtaskpanel.id = "subtaskpanel";
    subtaskpanel.style = 'width:100%;padding:5px;padding-top:15px;height:' + (document.body.offsetHeight - 220) + 'px; overflow:auto; background-color:white;';

    var pa = taskpanel;
    var taskdiv = document.createElement("div");

    taskdiv.style.borderBottom = "0px solid #f0f0f0";
    taskdiv.style.padding = '5px';

    var tb = document.createElement("table");
    tb.style.width = "100%";

    taskdiv.appendChild(tb);

    var tr = document.createElement("tr");
    tb.appendChild(tr);
    var td = document.createElement("td");
    tr.appendChild(td);

    td.colSpan = "2";
    td.innerHTML = "<span onclick='HideTaskPanel(); return false;' class='gladinet-icons secpaneltextcolor' style='font-size:28px;'>&#xE4;</span>";
    td.align = "right";
    td.style.paddingBottom = "5px";
    td.valign = "top";
    td.id = "ctltd";
    tr.id = "ctltr";

    tr = document.createElement("tr");
    tr.id = "titeltr";
    tb.appendChild(tr);
    td = document.createElement("td");
    tr.appendChild(td);

    td.style.paddingTop = "10px";
    td.style.paddingBottom = "10px";
    td.style.fontSize = "16px";

    td.colSpan = "2";
    td.innerHTML = WEBUI_TASKMAN_Progress;
    td.style.fontWeight = "100";
    td.style.color = "#868686";

    tr = document.createElement("tr");
    tb.appendChild(tr);
    td = document.createElement("td");
    tr.appendChild(td);
    td.innerHTML = "";
    td.style.fontSize = "12px";

    td.id = "GProgressText";

    td = document.createElement("td");
    tr.appendChild(td);
    td.innerHTML = "<span id='restortd' onclick='ShowTaskManPanel(); return false;' class='gladinet-icons secpaneltextcolor' style='font-size:28px;display:none; margin-top:-10px;'>&#xBA;</span>";
    td.style.width = "2px";
    td.align = "right";
    td.style.paddingBottom = "15px";

    tr = document.createElement("tr");
    tb.appendChild(tr);
    td = document.createElement("td");
    tr.appendChild(td);
    td.colSpan = 2;
    td.id = "GProgressBar"

    tr = document.createElement("tr");
    tb.appendChild(tr);
    td = document.createElement("td");
    tr.appendChild(td);
    td.colSpan = 2;
    td.style.fontSize = "10px";
    td.id = "GProgressBytesText";
    td.innerHTML = "";

    tr = document.createElement("tr");
    tb.appendChild(tr);
    td = document.createElement("td");
    tr.appendChild(td);
    td.colSpan = 2;
    td.style.fontSize = "10px";
    td.id = "GProgressError";
    td.style.paddingTop = "10px";
    td.style.paddingBottom = "10px";
    td.innerHTML = "";

    pa.appendChild(taskdiv);

    var pbar = new NoExtProgBar();
    pbar.id = "taskitem_0";
    //pbar.label = ExplorerDetail3_688_Uploading;
    pbar.height = "15px";
    pbar.percentage = 0;
    pbar.renderTo = "GProgressBar";

    gProgressBar = pbar;

    HideTaskPanel();
}

function HideTaskPanel() {

    var e = document.getElementById("titeltr");
    e.style.display = 'none';

    e = document.getElementById("ctltr");
    e.style.display = '';

    e = document.getElementById("subtaskpanel");
    e.style.display = 'none';

    e = document.getElementById("ctltd");
    e.innerHTML = "<span onclick='CancelProcessing(); return false;' class='gladinet-icons secpaneltextcolor' style='font-size:28px;'>&#x136;</span>&nbsp; &nbsp;<span onclick='ShowTaskManPanel(); return false;' class='gladinet-icons secpaneltextcolor' style='font-size:28px;'>&#xBA;</span>"
    e.style.paddingBottom = "20px";

    gTaskContainer.style.height = "150px";
    gTaskContainer.style.top = (document.body.offsetHeight - 170) + "px";

    e = document.getElementById("restortd");
    e.style.display = "none";

    e = document.getElementById("GProgressError");
    e.style.display = "";

}

function AlertErr(msg) {
    //DisplayError is defined in filedashboard.js
    //it populates the myConfirmModel1 div on the filedashboard.aspx
    DisplayError(msg);
}


function RetryTask(tid) {
    var temp = [];
    var task = null;
    var ee = document.getElementById("GProgressError");
    ee.innerHTML = "";
    if (gFailedTaskQueue == null || gFailedTaskQueue.length == 0)
        return;
    try {
        while (true) {
            var t = gFailedTaskQueue.shift();
            if (t == null || t === undefined) {
                break;
            }
            if (t[1] == tid) {
                task = t;
                var ee = document.getElementById(t[1] + "_progtext");
                ee.innerHTML = "";
                continue;
            }
            temp.push(t);
        }
        gFailedTaskQueue = temp;
    } catch (ex) { }
    if (task != null) {
        --gProcessedIndex;
        gTaskQueue.push(task);
        OnProcessTaskQueue();
    }
}
function OnProcessTaskQueue() {
    if (!gInProcessing) {
        SetTaskRun("1");
        gInProcessing = true;
        _refreshTokenNeeded = true;
        OnContinueProcessTaskQueue();
    }
}

function SetTaskRun(value) {
    try {
        var domains = GetAllDomain();

        var protocol = window.location.protocol;

        var bSecure = (protocol.indexOf("https") >= 0);

        for (i = 0; i < domains.length; i++) {
            Ext.util.Cookies.set("y-glad-taskrun", value, null, "/", domains[i], bSecure);

        }
    } catch (e) {

    }
}
function GetAllDomain() {

    var currentDomain = window.location.host;
    var returnArray = [null];
    var parts = currentDomain.split(".");

    // data.its.gladinet.com will have 4 parts

    var size = parts.length;

    for (i = 1; i <= size - 2; i++) {
        var subDomain = "";
        // construct current domain
        for (j = i; j < size; j++) {

            if (j != i) subDomain += ".";
            subDomain += parts[j];
        }
        returnArray[i] = subDomain;
    }

    return returnArray;
}
function RefreshOverallStatus() {
    try {
        var e = document.getElementById("GProgressText");
        if (gProcessedIndex > gTotalTaskCount)
            gProcessedIndex = gTotalTaskCount;
        e.innerHTML = WEBUI_TASKMAN_UING + gProcessedIndex + "/" + gTotalTaskCount + WEBUI_TASKMAN_ITEMS;
        if (gTotalBytes != 0) {
            gProgressBar.updateProgress((gProcessedBytes + gCurrentProcessedBytes) * 1.0 / gTotalBytes);
        }
        e = document.getElementById("GProgressBytesText");
        e.innerHTML = FormatFileSize(gProcessedBytes + gCurrentProcessedBytes) + "/" + FormatFileSize(gTotalBytes);
    } catch (eeee) { }
}