﻿

var UploadingIndex;
var CompleteBytes;
var TotalBytes;
var StopUploading;
var UploadingCount;
var gNextTaskId = 1;
var gTotalTaskCount = 0;
var gTaskQueue = [];
var gTotalBytes = 0;
var gCurrentTaskItem = null;
var OutstandingReq = null;
var gFailedTaskQueue = null;

function RemoveTaskItemFromQ(tid) {
    var temp = [];
    try {
        while (true) {
            var t = gTaskQueue.shift();
            if (t == null || t === undefined) {
                break;
            }
            if (t[1] == tid) {
                AlertErr("removed");
                continue;
            }

            temp.push(t);
        }

        gTaskQueue = temp;
    } catch (ex) {

    }
}

function RemoveTaskItemFromFailedQ(tid) {
    var temp = [];
    var task = null;

            
    if (gFailedTaskQueue == null || gFailedTaskQueue.length == 0)
        return;
            
    try {
        while (true) {
            var t = gFailedTaskQueue.shift();
            if (t == null || t === undefined) {
                break;
            }
            if (t[1] == tid) {
                continue;
            }

            temp.push(t);
        }

        gFailedTaskQueue = temp;
    } catch (ex) {

    }
}
function GetShortString(src, MaxLen) {
    if (src.length <= MaxLen)
        return src;
    var len = (MaxLen - 3) / 2;
    var p1 = src.substring(0, len);
    var p2 = src.substring(src.length - len);
    return p1 + "..." + p2;

}
function DeleteFailedTaskItem(tid) {
    var temp = [];
    var task = null;


    if (gFailedTaskQueue == null || gFailedTaskQueue.length == 0)
        return;
    try {
        while (true) {
            var t = gFailedTaskQueue.shift();
            if (t == null || t === undefined) {
                break;
            }
            if (t[1] == tid) {
                task = t;
                var pa = document.getElementById("subtaskpanel");
                var ee = document.getElementById(t[1]);
                pa.removeChild(ee);
                if (t[2] == "PUT")
                    gTotalBytes -= t[4].size;
                --gTotalTaskCount;
                        

                continue;
            }

            temp.push(t);
        }

        gFailedTaskQueue = temp;
    } catch (ex) {

    }

    if (task == null)
        return false;

    CheckRemainingTasks();

    return true;
}
function DeleteTaskItem(tid) {
    var temp = [];
    var task = null;

    try {

                
        if (gCurrentTaskItem != null && gCurrentTaskItem[1] == tid) {
            var t = gCurrentTaskItem;
            try {
                if (t[8] == OutstandingReq) {
                    OutstandingReq.abort();
                }
            } catch (eee) {

            }
            if (t[2] == "PUT")
                gTotalBytes -= t[4].size;
            var pa = document.getElementById("subtaskpanel");
            var ee = document.getElementById(t[1]);
            pa.removeChild(ee);
            --gTotalTaskCount;
            RemoveTaskItemFromQ(tid);
            RemoveTaskItemFromFailedQ(tid);
                    

            RemoveTaskItemFromQ(tid);
            RemoveTaskItemFromFailedQ(tid);
            RefreshOverallStatus();

            CheckRemainingTasks();
                    

            return;
        }
    } catch (ex1) {

    }
            
    if (DeleteFailedTaskItem(tid))
        return;
            
    if (gTaskQueue == null || gTaskQueue.length == 0) {
        CheckRemainingTasks();
        return;
    }
    try {
        while (true) {
            var t = gTaskQueue.shift();
            if (t == null || t === undefined) {
                break;
            }
            if (t[1] == tid) {
                task = t;
                try {
                    if (t[8] == OutstandingReq) {
                        OutstandingReq.abort();
                    }
                } catch (eee) {

                }
                if (t[2] == "PUT")
                    gTotalBytes -= t[4].size;

                var pa = document.getElementById("subtaskpanel");
                var ee = document.getElementById(t[1]);
                pa.removeChild(ee);
                --gTotalTaskCount;
                RefreshOverallStatus();
                continue;
            }

            temp.push(t);
        }

        gTaskQueue = temp;
    } catch (ex) {

    }

    CheckRemainingTasks();

}

function GetNextTaskId() {
    return "taskitem_" + (gNextTaskId++);
}

function getVectorIconCode2(fileExt) {
    var iconcode = "&#x133;"; //unknown file icon
    switch (fileExt) {
        case "config":
        case "ini":
        case "asax":
        case "ds_store":
            iconcode = "&#x124";
            break;
        case "fla":
        case "swf":
        case "aep":
        case "aepx":
        case "prproj":
        case "ppj":
        case "psq":
            iconcode = "&#x120;";
            break;
        case "ai":
            iconcode = "&#x128;";
            break;
        case "idd":
            iconcode = "&#x12A;";
            break;
        case "java":
        case "cs":
        case "js":
        case "cpp":
            iconcode = "&#x122";
            break;
        case "qb":
            iconcode = "&#x131;";
            break;
        case "eml":
        case "msg":
        case "pst":
            iconcode = "&#x126";
            break;
        case "dwg":
        case "dxf":
        case "3ds":
        case "prj":
        case "skp":
        case "lwo":
            iconcode = "&#x121;";
            break;
        case "dll":
        case "exe":
            iconcode = "&#x134;";
            break;
        case "doc":
        case "docx":
        case "rtf":
            iconcode = "&#x135;";
            break;
        case "txt":
        case "text":
        case "log":
        case "info":
        case "odt":
            iconcode = "&#x132;";
            break;
        case "htm":
        case "html":
        case "aspx":
        case "php":
        case "jsp":
        case "xml":
        case "xhtml":
        case "xst":
            iconcode = "&#x12C;";
            break;
        case "pic":
        case "png":
        case "gif":
        case "tif":
        case "tiff":
        case "jpg":
        case "jpeg":
        case "tgm":
        case "raw":
            iconcode = "&#x129;";
            break;
        case "avi":
        case "mpg":
        case "wmv":
        case "mp4":
        case "mov":
        case "3gp":
        case "vob":
            iconcode = "&#x12D;";
            break;
        case "wav":
        case "mp3":
        case "aac":
        case "wma":
        case "w4a":
        case "aiff":
        case "mpa":
            iconcode = "&#x138";
            break;
        case "pdf":
            iconcode = "&#x12E;";
            break;
        case "ppt":
        case "pptx":
        case "pub":
        case "pubx":
            iconcode = "&#x130;";
            break;
        case "xls":
        case "xlt":
        case "xlsx":
        case "csv":
            iconcode = "&#x123;";
            break;
        case "zip":
        case "rar":
        case "iso":
        case "tar":
        case "7z":
        case "s7z":
            iconcode = "&#x123;";
            break;
        case "msi":
        case "exe":
        case "dll":
        case "cab":
            iconcode = "&#x134;";
            break;
        case "db":
        case "mdb":
        case "sql":
        case "bak":
            iconcode = "&#x125;";
            break;
    }
    //console.log("vector icon: "+fileExt + "===" + iconcode)
    return iconcode;
}
function AddTaskItem(TaskItem) {
    CreateTaskPanel();

    var pa = document.getElementById("subtaskpanel");
    var taskdiv = document.createElement("div");
    taskdiv.style.borderBottom = "1px solid #f0f0f0";
    taskdiv.style.padding = '5px';
    taskdiv.style.paddingTop = '15px';
    taskdiv.id = TaskItem[1];

    var tb = document.createElement("table");
    tb.style.width = "100%";
    var tr = document.createElement("tr");
    var td = document.createElement("td");
    //icon
    td.style.width = "32px";
    td.style.height = "32px";
    td.valign = "center";

    var suffix = 'fileunknown';
    if (TaskItem[2] == "PUT") {
        var lasti = TaskItem[5].lastIndexOf('.');
        if (lasti > 0) {
            var str = TaskItem[5].substr(lasti);
            if (G_SuffixMap.containsKey(str.toLowerCase())) {
                suffix = G_SuffixMap.get(str.toLowerCase());
            }
        }
    } else {
        suffix = "filefolder";
    }
    suffix = suffix.replace(/^file/, "");
    //td.innerHTML = "<img class='" + suffix + "' src='/portal/s.gif' width='64px' height='48px' />";
    td.innerHTML = '<div class="gladinet-icons secpaneltextcolor" style="font-size:28px;">' + getVectorIconCode2(suffix) + "</div>";
    tr.appendChild(td);

    //task content
    td = document.createElement("td");

    var ctb = document.createElement("table");
    ctb.style.width = "100%";

    var ctr = document.createElement("tr");
    ctb.appendChild(ctr);

    //task name
    var ctd = document.createElement("td");
    ctd.style.fontSize = "10px";
    if (TaskItem[2] == "PUT")
        ctd.innerHTML = "Upload";
    else if (TaskItem[2] == "MKCOL")
        ctd.innerHTML = "Create Folder";
    ctr.appendChild(ctd);

    //file name
    ctr = document.createElement("tr");
    ctb.appendChild(ctr);
    ctd = document.createElement("td");
    ctr.appendChild(ctd);
    if (TaskItem[2] == "PUT")
        ctd.innerHTML = GetShortString(TaskItem[5], 30);
    else
        ctd.innerHTML = GetShortString(TaskItem[3], 30);

    //progressbar
    ctr = document.createElement("tr");
    ctb.appendChild(ctr);
    ctd = document.createElement("td");
    ctr.appendChild(ctd);
    ctd.id = TaskItem[1] + "_prog";

    td.appendChild(ctb);
    tr.appendChild(td);

    //action btn
    td = document.createElement("td");
    td.style.width = "32px";
    td.valign = "center";
    td.innerHTML = "<span class='gladinet-icons secpaneltextcolor' style='font-size:28px;' onclick='DeleteTaskItem(\"" + TaskItem[1] + "\")'>n</span>";
    td.id = TaskItem[1] + "_action";
    tr.appendChild(td);

    tb.appendChild(tr);

    ctr = document.createElement("tr");
    ctb.appendChild(ctr);
    ctd = document.createElement("td");
    ctr.appendChild(ctd);
    ctd.style.fontSize = "10px";
    ctd.id = TaskItem[1] + "_progtext";

    taskdiv.appendChild(tb);



    pa.appendChild(taskdiv);

    var pbar = new NoExtProgBar();
    pbar.id = TaskItem[1];
    //pbar.label = ExplorerDetail3_688_Uploading;
    pbar.percentage = 0;
    pbar.height = "3px";
    pbar.renderTo = TaskItem[1] + "_prog";
    TaskItem[0] = pbar;
    

    if (TaskItem[2] == "PUT")
        gTotalBytes += TaskItem[4].size;
            
    ++gTotalTaskCount;
            
    gTaskQueue.push(TaskItem);

    RefreshOverallStatus();
            
}

function getNewFileName(n) {
    var fullPath = n;
    var fileName = n;
    if (fullPath.indexOf("/") > -1) {
        var pathParts = fullPath.split("/");
        fileName = pathParts[pathParts.length - 1];
    }
    if (fileName.indexOf(".") == 0) {
        console.log("[IGNORED]" + fullPath + "====" + fileName);
        //do not upload files that start with a period
        return null;
    }
    return fullPath;
}

function AddFilesToTaskQ(Files) {
            
    UploadingIndex   = 0;
    CompleteBytes = 0;
    TotalBytes = 0;
    StopUploading = false;
    gFailedTaskQueue = [];

    UploadingCount = Files.length;
    if (UploadingCount == 0) {
        return;
    }
    var abortAfterName = "";
    var lastPromptedFolder = "";
    for (var i = 0; i < Files.length; ++i) {
        var file = Files[i];
        var newFileName;
        if (file.fname != undefined && file.fname != null) {
            newFileName = getNewFileName(file.fname);
        } else if (file.webkitRelativePath != undefined && file.webkitRelativePath != null && file.webkitRelativePath != "") {
            newFileName = getNewFileName(file.webkitRelativePath);
        } else {
            newFileName = getNewFileName(file.name);
        }
        if (newFileName == null || newFileName == undefined) continue;

		newFileName = newFileName.toLowerCase().replace(/^[//\\]+/,""); //remove leading forward or backslash
        if (abortAfterName!="") return;
		var failed = false;
		if(newFileName.indexOf("/")>-1){
			//compare this file's parent folder against all other folder names in the current folder to prevent conflict
				var parentFolderName = newFileName.toLowerCase().split("/")[0];
				if(lastPromptedFolder != parentFolderName){
					lastPromptedFolder = parentFolderName;
					//this new file being uploaded is inside of a folder
					$(".isFolder").each(function () {
						var key = $(this)[0].Key;
						if(!key) key = "";
						key = key.toLowerCase();
						key = key.replace(/^[//\\]+/,""); //remove leading forward or backslash
						key = key.replace(/[//\\]+$/,""); //remove trailing forward or backslash	
						if (key == parentFolderName) {	
							var confirmed = confirm(ExplorerDetail_folder + " " + parentFolderName + " " + ExplorerDetail_folder_already_exists_n_upload);
							if (!confirmed) {
								abortAfterName = newFileName;
								failed = true;
							}
							return false;
						}
					});
				}
		}else{
			//compare this file against all other file names in the current folder to prevent conflict
			$(".isFile").each(function () {
				var alias = $(this)[0].AliasLocation;
				if(!alias) alias = "";
				alias = alias.toLowerCase().replace(/^[//\\]+/,""); //remove leading forward or backslash	
				if (alias == newFileName) {	
					var confirmed = confirm(ExplorerDetail_1755_1_File + newFileName + " " + ExplorerDetail_1755_2_already_exists_n_nUpload);
					if (!confirmed) {
						abortAfterName = newFileName;
						failed = true;
						return false;
					}
				}
			});
		}
		if(failed) return;
    }
    var listOfZeroByteNames = "";
    var addedZeroByteNames = 0;
    for (var i = 0; i < Files.length; ++i) {
        var newFileName;
        var file = Files[i];

        if (file.fname != undefined && file.fname != null) {
            newFileName = getNewFileName(file.fname);

        } else if (file.webkitRelativePath != undefined && file.webkitRelativePath != null && file.webkitRelativePath != "") {
            newFileName = getNewFileName(file.webkitRelativePath);

        } else {
            newFileName = getNewFileName(file.name);
        }
        if (newFileName == null || newFileName == undefined)
            continue;

        if (newFileName.length >= 255 && file.size == 0) {
            //long paths get ignored by Firefox and are simply ommited by the Files array. Chrome, does include the long path files, but they report zero byte size and cause the tasks to get stuck.
            //The following path exceeds the maximum allowed length and will be ignored
            alert(Explorer_maxPathLengthUploadError + ":\n" + newFileName);
            continue;
        }
        if (abortAfterName != "" && newFileName == abortAfterName) return;
                               
        TotalBytes += file.size;      

        var oldSize = 0;
        var cdir = gCurrentFolder+"/" + newFileName;   
        
        var TaskItem = [];
        TaskItem[0] = ""; //status
        TaskItem[1] = GetNextTaskId();
        TaskItem[2] = "PUT";
        TaskItem[3] = cdir;
        TaskItem[4] = file;
        TaskItem[5] = newFileName;
        TaskItem[6] = oldSize;
        TaskItem[7] = "/";
        if (file.size == 0) {
            if (!_m_allowEmptyFile) {
                addedZeroByteNames++;
                if (addedZeroByteNames <= 10) {
                    listOfZeroByteNames += "<li>";
                    listOfZeroByteNames += file.name;
                    if (addedZeroByteNames == 10) {
                        listOfZeroByteNames += "...";
                    }
                }
            } else {
                AddTaskItem(TaskItem);
            }
        } else {
            AddTaskItem(TaskItem);
        }              
        /*if (file.size > 5000 * 1024 * 1024) {
            alert("File is larger than 5GB: " + file.name);
            continue;
        }*/

    }
    if (ShowZeroByteMsgs() && listOfZeroByteNames.length > 0) {
        if ($('#ConfirmZeroByteModal').length == 1) {
            $('#ConfirmZeroByteModalBody').html(Explorer_zeroByteUploadError + "<ul class=\"zeroByteList\">" + listOfZeroByteNames + "</ul>");  //The following file has zero bytes and will be ignored:
            $('#ConfirmZeroByteModal').modal({ backdrop: 'static', keyboard: false });
        } else {
            alert(Explorer_zeroByteUploadError + "\n" + newFileName);
        }
    }

}
function ConfirmZeroByte(suppress) {
    $('#ConfirmZeroByteModal').modal('hide');
    if (suppress===true) {
        try {
            if (sessionStorageTest()) {
                sessionStorage.setItem('gladConfirmZeroByte', "false");
            } else {
                top._m_gladConfirmZeroByte = "false";
            }
        } catch (ex) {
            console.log("Cannot set gladConfirmZeroByte: " + ex);
        }
    }
}
function ShowZeroByteMsgs() {
    var prevVal = null;
    try {
        if (sessionStorageTest()) {
            prevVal = sessionStorage.getItem('gladConfirmZeroByte');
        } else {
            prevVal = top._m_gladConfirmZeroByte;
        }
    } catch (ex) {
        console.log("Cannot retrieve gladConfirmZeroByte: " + ex);
    }
    if (prevVal == null) {
        return true;
    } else {
        return isTrue(prevVal);
    }
}
function detectBrowser() {
    var N = navigator.appName, ua = navigator.userAgent, tem;
    var M = ua.match(/(opera|chrome|safari|firefox|msie)\/?\s*(\.?\d+(\.\d+)*)/i);
    if (M && (tem = ua.match(/version\/([\.\d]+)/i)) != null) M[2] = tem[1];
    M = M ? [M[1], M[2]] : [N, navigator.appVersion, '-?'];
    return M;
}

function CloseTask() {
    setTimeout(function () {
        try {
            var e = document.getElementById("subtaskpanel");
            e.style.display = "none";
        }catch(ex){}
        //jquery slim does not include animate, so we can achieve the same effect with a sequence of setTimeouts that move the object in increments
        /*$("#taskcontainer").animate({ right: '-1000px' }, 500, function () {
            //make the task queue disappear to the right-side of the screen
            document.body.removeChild(gTaskContainer);
            gTaskContainer = null;
            gInProcessing = false;
            //now that it is gone from view, reset its position so the next time it is opened, it will be in the original place where it was created.
            $("#taskcontainer").css({ right: '10px' });
        });*/
        var curRgt = parseInt($("#taskcontainer").css("right"));
        var i = 0;
        for (i = 0; i < 5; i++) {
            setTimeout(function () {
                curRgt -= 200;
                $("#taskcontainer").css("right", curRgt + "px");
            }, (i * 200));
        }
        //this setTimeout block emulates the callback function of the animate
        setTimeout(function () {
            //make the task queue disappear to the right-side of the screen
            try {
                document.body.removeChild(gTaskContainer);
            } catch (ex) { }
            gTaskContainer = null;
            gInProcessing = false;
            //now that it is gone from view, reset its position so the next time it is opened, it will be in the original place where it was created.
            $("#taskcontainer").css("right", "10px");
        }, (i * 200));

        gProgressBar = null;
        gTotalBytes = 0;
        gTotalTaskCount = 0;
        gProcessedIndex = 0;
        gProcessedBytes = 0;
        gCurrentProcessedBytes = 0;
        gTaskQueue = [];
        gFailedTaskQueue = [];
        StopProcessing = false;
        gCurrentTaskItem = null;
        SetTaskRun("0");

        OnCloseTask();
    }, 500);
}


function Restart() {
    var e = document.getElementById("btn1");
    e.style.display = "";

    e = document.getElementById("btn2");
    e.style.display = "none";

    e = document.getElementById("btn3");
    e.style.display = "none";

    UploadingIndex = 0;
    CompleteBytes = 0;
    TotalBytes = 0;
    StopUploading = 0;
    UploadingCount =0;
    gNextTaskId = 1;
            
    gTotalTaskCount = 0;
    gTaskQueue = [];
    gTotalBytes = 0;
    gCurrentTaskItem = null;
    OutstandingReq = null;
    gFailedTaskQueue = [];

    var pa = document.getElementById("subtaskpanel");
    pa.innerHTML = "";
}

function FormatFileSize(size) {
    if (size < 1024) { //pow(2,10)
		if(Explorer_bts){
        	return size + " " + Explorer_bts;
		}else{
       		return size + " bytes";
		}
    } else if (size < 1048576) { //pow(2,20)
        return (Math.round(((size * 10) / 1024)) / 10) + " KB";
    } else if (size < 1073741824) { //pow(2,30)
        return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
    } else if (size < 1099511627776) { //pow(2,40)
        return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
    } else if (size < 1125899906842624) { //pow(2,50)
        return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
    } else { //pow(2,60)
        return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
    }
}

function OnTaskStatusChange(TaskItem, Completed, Total) {
    try {
        if (Total != 0) {
            var perc = (Completed * 1.0 / Total);
            TaskItem[0].updateProgress(perc);
            gCurrentProcessedBytes = Completed;
            RefreshOverallStatus();

            var ee = document.getElementById(TaskItem[1] + "_progtext");
            ee.innerHTML = FormatFileSize(Completed) + "/" + FormatFileSize(Total);
        }
    } catch (e) {

    }

}

function OnTaskAborted(TaskItem) {
    if (TaskItem && TaskItem.length > 1) {
        var ee = document.getElementById(TaskItem[1] + "_progtext");
        ee.style.fontSize = "10px";
        ee.style.color = "#008000";
        ee.innerHTML = "<span>Upload aborted</span> &nbsp;&nbsp;<a href='#' style='display:none;' onclick='RetryTask(\"" + TaskItem[1] + "\");return false;'>" + "Retry" + "</a>";
    }
    ++gProcessedIndex;
    gCurrentProcessedBytes = 0;
    RefreshOverallStatus();
}

function callGetShortString2(str, MaxLen) {
    //GetShortString has a bug that prepends 3 dots even if the file does not get trimmed
    var origStr = "..." + str;
    var shorterName = GetShortString(str, MaxLen);//from fileupload.js
    if (origStr == shorterName) return str;
    else return shorterName;
}
function OnTaskFailed(TaskItem, reason, morede) {
    var ee = document.getElementById(TaskItem[1] + "_progtext");
    
    ee.style.fontSize = "10px";
    ee.style.color = "#008000";
    if (morede)
        ee.innerHTML = "<span title=\"" + reason.replace(/[\"]/g, "&quot;") + "\" style='display:inline-block;overflow-x:hidden;white-space:nowrap;max-width:320px;'>" + callGetShortString2(reason, 55) + "</span> &nbsp;&nbsp;<a href='#' onclick='RetryTask(\"" + TaskItem[1] + "\");return false;'>" + WEBUI_TASKMAN_RETRY + "</a><br/><span style='color:#e00000;'>"+morede+"</span>";
    else
        ee.innerHTML = "<span title=\"" + reason.replace(/[\"]/g, "&quot;") + "\" style='display:inline-block;overflow-x:hidden;white-space:nowrap;max-width:320px;'>" + callGetShortString2(reason, 55) + "</span> &nbsp;&nbsp;<a href='#' onclick='RetryTask(\"" + TaskItem[1] + "\");return false;'>" + WEBUI_TASKMAN_RETRY + "</a>";
    
    ee = document.getElementById("GProgressError");
    ee.style.fontSize = "10px";
    ee.style.color = "#008000";
    ee.innerHTML = "<span title=\"" + reason.replace(/[\"]/g, "&quot;") + "\">" + callGetShortString2(reason,65) + "</span> &nbsp;&nbsp;<a href='#' onclick='RetryTask(\"" + TaskItem[1] + "\");return false;'>" + WEBUI_TASKMAN_RETRY + "</a>";
    if(morede)
        ee.title = morede;
    ++gProcessedIndex;
    gCurrentProcessedBytes = 0;
    RefreshOverallStatus();
    gFailedTaskQueue.push(TaskItem);
    //OnContinueProcessTaskQueue();
}

function utf8Encode(s) {
    var f = s;
    try {
        s = s.replace(/\r\n/g, "\n");

        var utftext = "";
        for (var n = 0; n < s.length; n++) {
            var c = s.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
    } catch (e) {
        utftext = f;

    }
    return utftext;
}
var gchunksize = 8 *1024*1024;
function SessionUploadFileParts(TaskItem, x, offset) {
    var file = TaskItem[4];
    var Total = file.size;;
    var Length = Total - offset;
    var ChunkSize = gchunksize;                
    if (x.ChunkSize) {
        ChunkSize = x.ChunkSize;        
    }
    if (Length > ChunkSize) Length = ChunkSize;
    var xhr = new XMLHttpRequest();
    OutstandingReq = xhr;
    TaskItem[8] = xhr;

    xhr.onloadend = function (e) {
        if (xhr.status > 300) {
            var Reason;
            if (xhr.status == 403)
                Reason = "Access Denied:" + file.name;
            else if (xhr.status == 422)
                Reason = file.name + "," + "Virus detected";
            else
                Reason = "Failed to upload:" + file.name;
            if (TaskItem[9] < 3) {
                TaskItem[9] = TaskItem[9] + 1;
                SessionUploadFileParts(TaskItem, x, offset);
            } else {
                OnTaskFailed(TaskItem, Reason);
            }
            return;
        }
        TaskItem[9] = 0;
        offset = offset + Length;
        x.SessionContext = xhr.responseText;
        if (offset == Total) {
            CompleteSessionUpload(TaskItem, x);
        } else {
            SessionUploadFileParts(TaskItem, x, offset);
        }
        
    };
    try {
        xhr.upload.onprogress = function (oEvent) {
            try {
                var total = oEvent.totalSize || oEvent.total;
                var done = oEvent.position || oEvent.loaded;
                if (oEvent !== undefined && oEvent !== null && total > 0) {
                    OnTaskStatusChange(TaskItem, done + offset, Total);
                }
            } catch (eeee) {}
        };
        xhr.onerror = function (e) {
            if (TaskItem[9] < 3) {
                TaskItem[9] = TaskItem[9] + 1;
                SessionUploadFileParts(TaskItem, x, offset);
            } else {
                OnTaskFailed(TaskItem, "Failed to upload");
            }
            return;

        };
        xhr.onabort = function (e) {
            OnTaskAborted(TaskItem);
            return;
        };
        xhr.onload = function (e) {
            return;
        };
    } catch (e) { }
    try {
        xhr.open('PUT', "/storage/part.up", true);
    } catch (e) { }
    //xhr.setRequestHeader("Content-Length", "" + Length); XMLHttpRequest isn't allowed to set this headers, they are being set automatically by the browser.
    xhr.setRequestHeader("x-glad-offset", "" + offset);
    xhr.setRequestHeader("x-glad-sessionid", x.SessionId);
    if (x.SessionContext) xhr.setRequestHeader("x-glad-sctx", x.SessionContext);
    xhr.setRequestHeader("Content-Type", "application/octet-stream");
    xhr.overrideMimeType("text/html");
    var blob = file.slice(offset, offset + Length);
    try {
        xhr.send(blob);
    } catch (e) {}
}
function CompleteSessionUpload(TaskItem, x) {
    var file = TaskItem[4];
    var Total = file.size;;

    var newFileName = TaskItem[5];
    var oldSize = TaskItem[6];
    var altpath = TaskItem[3];

    TaskItem[8] = null;
    TaskItem[9] = 0;

    $.ajax({
        type: "POST",
        async: false,
        dataType: "text/xml",
        data: "<?xml version='1.0' encoding='utf-8' ?><EndUploadSession  xmlns=\"http://tempuri.org/\"><SessionId>"+x.SessionId+"</SessionId></EndUploadSession>",
        headers: {
            'x-glad-token': getLoginSessionToken(),
            'x-glad-origin': 'WebUploader',
            "x-glad-sctx": x.SessionContext
        },
        url: "/storage/u.svc/enduploadsession",
        success: function (data, status, request) {
            if (data === null || data === undefined) {
                OnTaskFailed(TaskItem, "Failed to commit");
                return;
            }
            if (data.Success) {
                OnTaskCompleted(TaskItem);
                return;
            } else {
                OnTaskFailed(TaskItem, data.Reason);
                return;
            }
        },
        error: function (xhr, status, error) {
            OnTaskFailed(TaskItem, "Failed to commit");
        }
    });
}
function SessionUploadFile(TaskItem)
{
    var file = TaskItem[4];
    var Total = file.size;;

    var newFileName = TaskItem[5];
    var oldSize = TaskItem[6];
    var altpath = TaskItem[3];

    TaskItem[8] = null;
    TaskItem[9] = 0;

    //new FileReader(); use file reader later
    OnTaskStatusChange(TaskItem, 0, file.size);
    
    var lu = "";
    if (file.lastModifiedDate != null && file.lastModifiedDate != undefined) {
        lu = file.lastModifiedDate.toUTCString();
    }
    else if (file.lastModified != null && file.lastModified != undefined) {
        try {
            var dt = new Date(file.lastModified);
            lu = dt.toUTCString();
        } catch (ee) {
            alert(ee);
        }
    }
    $.ajax({
        type: "POST",
        async: false,
        dataType: "text/xml",
        data: "<?xml version='1.0' encoding='utf-8' ?><BeginUploadSession  xmlns=\"http://tempuri.org/\"><Path>" + escapeXml(altpath) + "</Path><Size>" + Total + "</Size><OrigSize>" + oldSize + "</OrigSize><LastModified>" + lu + "</LastModified></BeginUploadSession>",
        headers: {
            'x-glad-token': getLoginSessionToken(),
            'x-glad-origin': 'WebUploader'
        },
        url: "/storage/u.svc/beginuploadsession",
        success: function (data, status, request) {
            if (data === null || data === undefined) {
                HandlePutFile(TaskItem);
                return;
            }
            if (data.Success) {
                SessionUploadFileParts(TaskItem, data, 0);
                return;
            } else {
                HandlePutFile(TaskItem);
                return;
            }
        },
        error: function (xhr, status, error) {
            HandlePutFile(TaskItem);
        }
    });
}
function UploadFileInSinglePart(TaskItem) {
    var fileReader;
    var file = TaskItem[4];
    var Total = file.size;;
    
    var newFileName = TaskItem[5];
    var oldSize = TaskItem[6];
    var altpath = TaskItem[3];

    if (file.size > 1500 * 1024 * 1024) {
        OnTaskFailed(TaskItem, "File is larger than 1.5GB");
        return;
    }
    //new FileReader(); use file reader later
    OnTaskStatusChange(TaskItem, 0, file.size);

    var xhr = new XMLHttpRequest();
    OutstandingReq = xhr;
    TaskItem[8] = xhr;

    xhr.onloadend = function (e) {
        var moreer = null;
        if (xhr.status > 300) {
            var Reason;

            if (xhr.status == 403) {
                Reason = "Error: No permission to upload " + file.name;
            }
            else if (xhr.status == 422) {
                Reason = "Error: " + file.name + " has a virus";
            }
            else if (xhr.status == 400) {
                Reason = "HTTP 400 Error: " + file.name + " might be too large";
            }
            else if (xhr.status == 428) {
                Reason = "Server Side Error: " + file.name;
                moreer = xhr.responseText;
            }
            else {
                Reason = "Unable to upload:" + file.name;
            }
            OnTaskFailed(TaskItem, Reason, moreer);
            return;
        }

        OnTaskCompleted(TaskItem);

    };

    try {
        xhr.upload.onprogress = function (oEvent) {
            try {
                var total = oEvent.totalSize || oEvent.total;
                var done = oEvent.position || oEvent.loaded;
                if (oEvent !== undefined && oEvent !== null && total > 0) {
                    OnTaskStatusChange(TaskItem, done, total);
                }
            } catch (eeee) {

            }


        };

        xhr.onerror = function (e) {
            OnTaskFailed(TaskItem, "Failed");
            return;

        };
        xhr.onabort = function (e) {
            OnTaskAborted(TaskItem);
            return;
        };
        xhr.onload = function (e) {
            return;
        };


    } catch (e) {

    }

    xhr.open('PUT', "/storage/proxiedupload.up", true);
    //xhr.setRequestHeader("Content-Length", "" + Total);

    while (altpath.indexOf("+") != -1)
        altpath = altpath.replace('+', '|');

    xhr.setRequestHeader("Content-Type", "application/octet-stream");
    xhr.setRequestHeader("y-glad-token", getLoginSessionToken());
    try {
        xhr.setRequestHeader("x-glad-altpath", altpath);
    } catch (e) {
        altpath = utf8Encode(altpath);
        xhr.setRequestHeader("x-glad-altpath", altpath);
    }

    if (file.lastModifiedDate != null && file.lastModifiedDate != undefined) {
        xhr.setRequestHeader("x-glad-lastdate", file.lastModifiedDate.toUTCString());
    }
    else if (file.lastModified != null && file.lastModified != undefined) {
        try {
            var dt = new Date(file.lastModified);
            xhr.setRequestHeader("x-glad-lastdate", dt.toUTCString());
        } catch (ee) {
            alert(ee);
        }
    }

    if (oldSize != Total) {
        xhr.setRequestHeader("x-glad-size", Total + "");
        xhr.setRequestHeader("x-glad-original-size", oldSize + "");
    }
    //xhr.setRequestHeader("x-glad-requser", "");
    xhr.setRequestHeader("x-glad-vendor", msGetItemVendorData(altpath, true));

    xhr.send(file);
    return;
}
function removeLeadingDoubleSlash(str) {
    if (str == null) return "";
    if (str.indexOf("//") == 0) {
        //remove one forward slash if two are present
        str = str.substring(1);
    }
    if (str.indexOf("%2F%2F") == 0) {
        //remove one forward slash if two are present encoded
        str = str.substring(3);
    }
    return str;
}
function HandlePutFile(TaskItem) {
    var fileReader;
    var file = TaskItem[4];
    var Total = file.size;
    var newFileName = TaskItem[5];
    var oldSize = TaskItem[6];
    var altpath = TaskItem[3];           
    //new FileReader(); use file reader later
    OnTaskStatusChange(TaskItem, 0, file.size);

    var xhr = new XMLHttpRequest();
    //XMLHttpRequest responseType defaults to xml, but blob uploads don't return anything, so we need to specify the type to text to prevent generating an error in the background
    try {
        xhr.responseType = "text";
    } catch (ex) {
        //IE 11 fails here
    }

    OutstandingReq = xhr;
    TaskItem[8] = xhr;

    xhr.onloadend = function (e) {
        if (xhr.response == "EXCEED_TEAMFOLDE_QUOTA") {
            OnTaskFailed(TaskItem, "Error: Upload quota exceeded: " + file.name, "EXCEED_TEAMFOLDE_QUOTA");
            return;
        }
        if (xhr.status > 300) {
            var Reason;
            var moreer;
            if (xhr.status == 403){
                Reason = "Error: No permission to upload " + file.name;
            }
            else if (xhr.status == 422) {
                Reason = "Error: " + file.name + " has a virus";
            }
            else if (xhr.status == 400) {
                Reason = "HTTP 400 Error: " + file.name + " might be too large";
            }
            else if (xhr.status == 428) {
                
                Reason = "Server Side Error: " + file.name;
                moreer = xhr.responseText;
            }
            else {
                Reason = "Unable to upload:" + file.name ;
            }
            OnTaskFailed(TaskItem, Reason, moreer);
            return;
        }
        
        OnTaskCompleted(TaskItem);

    };

    try {
        xhr.upload.onprogress = function (oEvent) {
            try {
                var total = oEvent.totalSize || oEvent.total;
                var done = oEvent.position || oEvent.loaded;
                if (oEvent !== undefined && oEvent !== null && total > 0) {
                    OnTaskStatusChange(TaskItem, done, total);
                }
            } catch (eeee) {

            }


        };

        xhr.onerror = function (e) {
            OnTaskFailed(TaskItem, "Failed");
            return;

        };
        xhr.onabort = function (e) {
            OnTaskAborted(TaskItem);
            return;
        };
        xhr.onload = function (e) {
            return;
        };


    } catch (e) {

    }

    xhr.open('PUT', "/storage/proxiedupload.up", true);
    //xhr.setRequestHeader("Content-Length", "" + Total);

    while (altpath.indexOf("+") != -1)
        altpath = altpath.replace('+', '|');

    altpath = removeLeadingDoubleSlash(altpath);

    xhr.setRequestHeader("Content-Type", "application/octet-stream");
    xhr.setRequestHeader("y-glad-token", getLoginSessionToken());
    try {
        xhr.setRequestHeader("x-glad-altpath", altpath);
    } catch (e) {
        altpath = utf8Encode(altpath);
        xhr.setRequestHeader("x-glad-altpath", altpath);
    }
    if (file.lastModifiedDate != null && file.lastModifiedDate != undefined) {
        xhr.setRequestHeader("x-glad-lastdate", file.lastModifiedDate.toUTCString());
    }

    else if (file.lastModified != null && file.lastModified != undefined) {
        try{
            var dt = new Date(file.lastModified);
            xhr.setRequestHeader("x-glad-lastdate", dt.toUTCString());
        } catch (ee) {
            alert(ee);
        }
    }

    
    if (oldSize != Total) {
        xhr.setRequestHeader("x-glad-size", Total + "");
        xhr.setRequestHeader("x-glad-original-size", oldSize + "");
    }
    try {
        xhr.send(file);
    } catch (e) {
        console.log("HandlePutFile: " +e);
    }            
    return;
}
    function OnContinueProcessTaskQueue() {
        SetTaskRun("1");
        try {
            if (StopProcessing) {
                gInProcessing = false;
                CloseTask();
                return;
            }
        } catch (e) { }
            

        var t = gTaskQueue.shift();
        if (t == null || t === undefined) {                
            CloseTask();                
            return;
        }

        gCurrentTaskItem = t;
        if (t[2] == "PUT") {
            var twentyMegabytes = 20971520;
            //console.log(t)
            if (t[4].size >= twentyMegabytes) {
                //console.log(t[3] + " is larger than 20MB, uploading in parts");
                SessionUploadFile(t);
            } else {
                //console.log(t[3] + " is smaller than 20MB, uploading single file");
                HandlePutFile(t);
            }
        } else if (t[2] == "MKCOL") {
            HandleCreateDir(t);
        }

    }
    function escapeXml(unsafe) {
        return unsafe.replace(/[<>&'"]/g, function (c) {
            switch (c) {
                case '<': return '&lt;';
                case '>': return '&gt;';
                case '&': return '&amp;';
                case '\'': return '&apos;';
                case '"': return '&quot;';
            }
        });
    }
    function OnTaskCompleted(TaskItem) {
        try {

            if (TaskItem[2] == "PUT") {
                gProcessedBytes += TaskItem[4].size;
            }
            ++gProcessedIndex;

            var ee = document.getElementById(TaskItem[1] + "_prog");
            ee.style.fontSize = "10px";
            ee.style.color = "#008000";
            ee.style.display = "none";
            ee = document.getElementById(TaskItem[1] + "_progtext");
            ee.innerHTML = WEBUI_TASKMAN_DONE;
                
            ee = document.getElementById(TaskItem[1] + "_action");
            ee.innerHTML = "";
        } catch (e) {

        }
        OnContinueProcessTaskQueue();
    }
    function onFolderSelected(inpObj) {
        str = [];
        pending = 0;
        files = [];
        try {
            var rootFolder = "/";
            if (inpObj.files.length > 0) {  
                var alreadyQueuedFolders = [];
                for (var y = 0; y < inpObj.files.length; y++) {
                    var path = inpObj.files[y].webkitRelativePath;
                    path = path.replace("^[/]+", "");
                    if (path.indexOf("/") > -1) {
                        var subfolders = path.split("/");
                        var parentFolders = gCurrentFolder;
                        for (var i = 0; i < subfolders.length-1; i++) {
                            folder = subfolders[i];
                            var folderPath = parentFolders + "/" + folder;
                            if (alreadyQueuedFolders.indexOf(folderPath) == -1) {
                                console.log("Create folder: " + folderPath);
                                AddMkColTask(folderPath);
                                alreadyQueuedFolders.push(folderPath); 
                            }
                            parentFolders += "/" + folder;
                        }
                    }
                }
            }
        } catch (ex) {
            console.log("onFolderSelected:" + ex);
        }

        AddFilesToTaskQ(inpObj.files);
        OnContinueProcessTaskQueue();
    }
    function onFileSelected() {
        gTotalTaskCount = 0;
        AddFilesToTaskQ(FileSelector.files);
            
        //var e = document.getElementById("subtaskpanel");
        //e.style.display = "";

        if (gTotalTaskCount > 0) {
            OnContinueProcessTaskQueue();
        }
    }

    function OnClose() {
        window.location = "/portal/loginpage.aspx";
    }
    function SelectFiles() {
        FileSelector = document.createElement('input');
        FileSelector.setAttribute('type', 'file');
        FileSelector.setAttribute('multiple', 'multiple');
        FileSelector.onchange = onFileSelected;

        try {
            var bs = detectBrowser();
            if (bs.indexOf("Chrome") == -1 && bs.indexOf("Firefox") == -1) {
                document.body.appendChild(FileSelector);
            } else {
            }
        } catch (e) {
            alert(e);
        }

        FileSelector.click();
    }


    var str = [];
    var pending = 0;
    var files = [];

    function ConvertFileObject() {
        var fobj = str.pop();
        if (fobj == null) {

            AddFilesToTaskQ(files);
            OnContinueProcessTaskQueue();
            return;
        }
        fobj.file(function (f) {
            files.push(f);
            f.fname = fobj.fname;
            ConvertFileObject();
        }, function () {
            //could not access the file, probably because of long paths or access issue
            //Firefox will simply skip long paths file objects. Chrome will have the file objects for long paths, but the files will be inaccessible
            alert(Explorer_errorFailedUpload + "\n" + fobj.fname);
            ConvertFileObject();
        });
    }
    function HandleCreateDir(TaskItem) {
        var dst = removeLeadingDoubleSlash(TaskItem[3]);
        OnTaskStatusChange(TaskItem, 10, 100);
        var altpath = encodeURIComponent(dst);

        var fetchNotSupported = (typeof window.fetch === "undefined");
        if (!fetchNotSupported) {
            var hdrs = {
                'x-glad-altpath': altpath,
                'x-glad-token': getLoginSessionToken(),
                'x-glad-vendor': msGetItemVendorData(dst, true)
            }
            fetch("/namespace/n.svc/jsondir/?_rnd=" + getRandomStr(), {
                method: 'PUT',
                headers: hdrs
            }).then(
                function (response) {
                    if (response.status !== 200) {
                        alert("Failed to send request. Error " + response.status);
                        return;
                    }
                    response.json().then(function (x) {
                        if (x.Success) {
                            OnTaskCompleted(TaskItem);
                            return;
                        } else {
                            if (x.Reason == "DIR_ALREADY_EXIST" || x.Reason == "SAME_NAME_FILE_EXIST") {
                                OnTaskCompleted(TaskItem);
                            } else {
                                OnTaskFailed(TaskItem, data.Reason);
                            }
                            return;
                        }
                    });
                }
            ).catch(function (err) {
                OnTaskFailed(TaskItem, "failed to send request");
            });
        } else {
            $.ajax({
                type: "PUT",
                async: false,
                dataType: "application/json",
                headers: {
                    'x-glad-altpath': altpath,
                    'x-glad-token': getLoginSessionToken(),
                    'x-glad-vendor': msGetItemVendorData(dst, true)
                },
                url: "/namespace/n.svc/jsondir/?_rnd=" + getRandomStr(),
                success: function (data, status, request) {
                    if (data === null || data === undefined) {
                        OnTaskFailed(TaskItem, ExplorerDetail_293_error_createFolder);
                        return;
                    }
                    if (data.Success) {
                        OnTaskCompleted(TaskItem);
                        return;
                    } else {
                        if (data.Reason == "DIR_ALREADY_EXIST" || data.Reason == "SAME_NAME_FILE_EXIST") {
                            OnTaskCompleted(TaskItem);
                        } else {
                            OnTaskFailed(TaskItem, data.Reason);
                        }
                        return;
                    }
                },
                error: function (xhr, status, error) {
                    OnTaskFailed(TaskItem, "failed to send request");
                }
            });
        }

    }
    function AddMkColTask(target) {
        var TaskItem = [];
        TaskItem[0] = ""; //status
        TaskItem[1] = GetNextTaskId();
        TaskItem[2] = "MKCOL";
        TaskItem[3] = target;
        TaskItem[4] = gCurrentFolder;
        AddTaskItem(TaskItem);
}

function uploadFolder(f, path) {

    if (path == null)
        path = f.name;
    else
        path = path + "/" + f.name;
    ++pending;
    var dirReader = f.createReader();
    var cdir = gCurrentFolder;
    var fullpath = path;
    if (cdir != "" && cdir != "/") {
        fullpath = cdir + "/" + path;
    }

    var hasFileOrSubfile = false;

    var processEntries = function (entries, resolve) {
        if (!entries.length) {
            if (!hasFileOrSubfile) {
                --pending;
                resolve(false);
            } else if (pending == 0) {
                ConvertFileObject();
            }
            return;
        }

        var childPromises = [];
        entries.forEach(function (entry) {
            if (entry.isDirectory) {
                childPromises.push(
                    new Promise(function (childResolve) {
                        uploadFolder(entry, path).then(function (hasSubfile) {
                            if (hasSubfile) {
                                hasFileOrSubfile = true;
                            }
                            childResolve(hasSubfile);
                        });
                    })
                );
            } else if (entry.isFile) {
                hasFileOrSubfile = true;
                entry.fname = path + "/" + entry.name;
                str.push(entry);
            }
        });

        Promise.all(childPromises).then(function () {
            resolve(hasFileOrSubfile); 
        });
    };

    return new Promise(function (resolve) {
        dirReader.readEntries(function (entries) {
            processEntries(entries, resolve);
        });
    }).then(function (hasFileOrSubfile) {
        if (hasFileOrSubfile) {
            // Add folder only if it contains files or subfolders with files
            try {
                AddMkColTask(fullpath);
            } catch (e) {
                alert(e.message);
            }
        }

        --pending;
        if (pending === 0) {
            ConvertFileObject();
        }
    });
}




    function AvdHTML5Handler(dt) {


        try {
            var items = dt.items;
        
            if (items == null || items == undefined)
                return false;
            str = [];
            pending = 0;
            files = [];

        

            for (var i = 0; i < items.length; i++) {


                var item = items[i].webkitGetAsEntry();
                if (item) {

                    if (item.isDirectory) {
                        uploadFolder(item, null);
                    }
                    else if (item.isFile) {

                        str.push(item);

                    }

                }
            }

            if (pending == 0) {
                ConvertFileObject();
            }
        } catch (e) {
            alert(e.message);
            return false;
        }
    
        return true;
    }


function OnDragDropped(dt) {

        if (AvdHTML5Handler(dt))
            return;

        AddFilesToTaskQ(dt.files);
        if (gTotalTaskCount > 0) {
            OnContinueProcessTaskQueue();
        }
    }



