﻿<%@ Page Title="Gladinet Cloud - Update OpenStack Storage Account" Language="C#" MasterPageFile="UpdateStorageConfig.master"
    AutoEventWireup="true" CodeBehind="OpenStack_Update.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.OpenStackUpdate" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            color: #339966;
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocUse" meta:resourcekey="str_use" runat="server" Visible="False">Username</asp:Localize>
<asp:Localize ID="LocAccKey" meta:resourcekey="str_accKey" runat="server" Visible="False">Access Key</asp:Localize>
<asp:Localize ID="LocAPIKey" meta:resourcekey="str_aPIKey" runat="server" Visible="False">API Key</asp:Localize>
<asp:Localize ID="LocAccID" meta:resourcekey="str_accID" runat="server" Visible="False">Account ID</asp:Localize>
<asp:Localize runat="server" ID="LocSesExpPleRefPagOrLogAga" meta:resourcekey="str_sesExpPleRefPagOrLogAga" Visible="false">Session expired, please refresh the page or log in again</asp:Localize>
<asp:Label ID="LabelStorage" runat="server" Text="Label Storage" Visible=false></asp:Label>
    <table width="904" align="center" style="background: WHITE; padding: 15px;" cellspacing="0">
        <tr>
            <td width="504" style="padding: 10px; vertical-align: top;">
                <b><asp:Localize meta:resourcekey="str_updThe" runat="server">Update the</asp:Localize> 
                    <asp:Label ID="LabelStorage1" runat="server" Text="Label Storage 1"></asp:Label>
                    &nbsp; <asp:Localize meta:resourcekey="str_accInf" runat="server">account information.</asp:Localize>&nbsp; </b>
                &nbsp;<br />
                
                <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                  { %><b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                    CssClass="errmsg"></asp:Label></b>
                    <%} %>
                <br />
                <asp:Panel ID="PanelEndPoint" runat="server">
                    <table width="100%" align="center" style="display: block;">
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="str_OpeApiEnd">OpenStack API End-Point:</asp:Localize></td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TextBoxEndPoint" runat="server" Width="461px"></asp:TextBox><br />
                                <asp:Localize meta:resourcekey="str_example" runat="server">Example:</asp:Localize> https://auth.yourdomain.com/v1.0
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <table width="100%" align="center" style="display: block;">
                    <tr>
                        <td height="15px">
                            <asp:Label ID="LabelAccessKey" runat="server" Text="Access Key ID"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="393px"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Label ID="LabelSecret" runat="server" Text="Secret Access Key"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="395px"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Button ID="BtnTestConnection" runat="server" meta:resourcekey="str_tesCon" Text="Test Connection" OnClick="BtnTestConnection_Click" />
                            <asp:HiddenField ID="HiddenFieldGoodConnection" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Panel ID="PanelPickBucket" runat="server">
                                <table width="100%" border="0">
                                    <tr>
                                        <td class="style1">
                                            <p class='green'><asp:Localize ID="LocConTesSuc" meta:resourcekey="str_conTesSuc" runat="server">Connection test successful!</asp:Localize></p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize meta:resourcekey="str_selACon" runat="server">Select a Container</asp:Localize> (<asp:Localize meta:resourcekey="str_wasUsi" runat="server">was using</asp:Localize>&nbsp;
                                            <b><asp:Label ID="LabelOldBucket" runat="server" Text="Label"></asp:Label></b>
                                            )</td>
                                    </tr>
                                    <tr>
                                        <td height="32">
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged">
                                                <asp:ListItem>{Test Connection First}</asp:ListItem>
                                            </asp:DropDownList>
                                            &nbsp;
                                            <br />
                                            <asp:Panel ID="PanelCreateBucket" runat="server">
                                                <asp:Localize meta:resourcekey="str_newConNam" runat="server">New Container Name:</asp:Localize>&nbsp;
                                                <asp:TextBox ID="TxtNewBucket" runat="server" Width="252px"></asp:TextBox>
                                                <br />
                                                <asp:Button ID="BtnCreateBucket" runat="server" meta:resourcekey="str_creCon" Text="Create Container" OnClick="BtnCreateBucket_Click" />
                                            </asp:Panel>
                                            <br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelPickFolder" runat="server">
                                                <asp:Panel ID="PanelFolderDropDown" runat="server" Visible="False">
                                                    <table width="100%" border="0">
                                                        <tr>
                                                            <td height="32"><asp:Localize runat="server" meta:resourcekey="str_SelAFolLeaItBlaForTheRooFolInTheBuc">Select a Folder (Leave it blank for the root folder in the bucket)</asp:Localize></td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:DropDownList ID="DropDownListFolder" runat="server">
                                                                </asp:DropDownList>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                                <table width="100%">
                                                    <tr>
                                                        <td style="text-align: center">
                                                            <asp:Button ID="ButtonFinish" runat="server" meta:resourcekey="str_don" Text="Done!" Width="128px" OnClick="ButtonFinish_Click"
                                                                OnClientClick="showLoader(this);this.style.display='none'" />
                                                            <div style="display: none" id='blueloader'>
                                                                <img alt='loading ...' src="../images/blueloader.gif" width="160" height="20" /></div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                    </tr>
                </table>
            </td>
            <td width="10">&nbsp;</td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;">
                <asp:Image ID="ImageStorage" runat="server" ImageUrl="~/StorageConfig/images/openstack.jpg" />
                &nbsp;<div style="margin: 6px;">
                    <asp:Localize ID="LocPleProAnAccKeyAndASec" meta:resourcekey="str_pleProAnAccKeyAndASec" runat="server">Please provide an access key and a secret key.</asp:Localize>
                    <br />
                    <asp:Localize ID="LocTheTesConButWilTesYouClo" meta:resourcekey="str_theTesConButWilTesYouClo" runat="server">The test connection button will test your Cloud Storage connection.</asp:Localize>                  
                    <asp:Localize ID="LocYouMayTheSelABucAsYou" meta:resourcekey="str_youMayTheSelABucAsYou" runat="server">You may then select a bucket as your root folder.</asp:Localize><br />
                    &nbsp;</div>
            </td>
        </tr>
        <tr>
            <td colspan="2"></td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;">&nbsp;</td>
        </tr>
    </table>
    
</asp:Content>
