﻿<%@ Page Title="Gladinet Cloud - Update Google Storage Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="Google_Update.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.GoogleUpdate" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            color: #339966;
        }
    </style>
</asp:Content>
<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="StepIndicator">
    <asp:Localize meta:resourcekey="str_updGooCloStoAccInf" runat="server">Update Google Cloud Storage Account Information</asp:Localize> 
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocSesExpPleRefPagOrLogAga" meta:resourcekey="str_sesExpPleRefPagOrLogAga" Visible="false">Session expired, please refresh the page or log in again</asp:Localize>
    <table width="904" align="center" style="background: WHITE; padding: 15px;" cellspacing="0">
        <tr>
            <td width="504" style="padding: 10px; vertical-align: top;">
                <b><asp:Localize meta:resourcekey="str_youCanUseThiPagToUpdYouGoo" runat="server">You can use this page to update your Google Cloud Storage account information.</asp:Localize><br />
                    <br /></b>&nbsp;<br />
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                    CssClass="errmsg"></asp:Label></b>
                <table width="100%" align="center" style="display: block;">
                    <tr>
                        <td height="15px"><asp:Localize runat="server" meta:resourcekey="str_NbsAccKeyId">&nbsp; Access Key ID</asp:Localize></td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="393px"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td><asp:Localize runat="server" meta:resourcekey="str_SecAccKey">Secret Access Key</asp:Localize></td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="395px"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Button ID="BtnTestConnection" runat="server" Text="Test Connection" OnClick="BtnTestConnection_Click" />
                            <asp:HiddenField ID="HiddenFieldGoodConnection" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Panel ID="PanelPickBucket" runat="server">
                                <table width="100%" border="0">
                                    <tr>
                                        <td class="style1">
                                           <p class='green'><asp:Localize ID="LocConTesSuc" meta:resourcekey="str_conTesSuc" runat="server">Connection test successful!</asp:Localize></p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Localize meta:resourcekey="str_selABuc" runat="server">Select a Bucket</asp:Localize>&nbsp; (<asp:Localize meta:resourcekey="str_wasUsi" runat="server">was using</asp:Localize> <b><asp:Label ID="LabelOldBucket" runat="server" 
                                                Text="Label"></asp:Label></b>
                                            &nbsp;)</td>
                                    </tr>
                                    <tr>
                                        <td height="32">
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged">
                                                <asp:ListItem>{Test Connection First}</asp:ListItem>
                                            </asp:DropDownList>
                                            &nbsp;
                                            <br />
                                            <asp:Panel ID="PanelCreateBucket" runat="server">
                                                <asp:Localize ID="LocNewBucNam" meta:resourcekey="str_newBucNam" runat="server">New Bucket Name:</asp:Localize>&nbsp;
                                                <asp:TextBox ID="TxtNewBucket" runat="server" Width="252px"></asp:TextBox>
                                                <br />
                                                <asp:Button ID="BtnCreateBucket" runat="server" Text="Create Bucket" OnClick="BtnCreateBucket_Click" />
                                            </asp:Panel>
                                            <br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelPickFolder" runat="server">
                                                <asp:Panel ID="PanelFolderDropDown" runat="server" Visible="False">
                                                    <table width="100%" border="0">
                                                        <tr>
                                                            <td height="32"><asp:Localize runat="server" meta:resourcekey="str_SelAFolLeaItBlaForTheRooFolInTheBuc">Select a Folder (Leave it blank for the root folder in the bucket)</asp:Localize></td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:DropDownList ID="DropDownListFolder" runat="server">
                                                                </asp:DropDownList>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                                <table width="100%">
                                                    <tr>
                                                        <td style="text-align: center">
                                                            <asp:Button ID="ButtonFinish" runat="server" Text="Done !" Width="128px" OnClick="ButtonFinish_Click"
                                                                OnClientClick="showLoader(this);this.style.display='none'" />
                                                            <div style="display: none" id='blueloader'>
                                                                <img alt='loading ...' src="../images/blueloader.gif" width="160" height="20" /></div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                    </tr>
                </table>
            </td>
            <td width="10">&nbsp;</td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;">
                <img width="400px" src="images/google.png" />
                <div style="margin: 6px;">
                    <asp:Localize ID="LocPleProAnAccKeyAndASec" meta:resourcekey="str_pleProAnAccKeyAndASec" runat="server">Please provide an access key and a secret key.</asp:Localize>
                    <br />
                    <asp:Localize ID="LocTheTesConButWilTesYouGoo" meta:resourcekey="str_theTesConButWilTesYouGoo" runat="server">The test connection button will test your Google Cloud Storage connection.</asp:Localize>                   
                    <asp:Localize ID="LocYouMayTheSelABucAsYou" meta:resourcekey="str_youMayTheSelABucAsYou" runat="server">You may then select a bucket as your root folder.</asp:Localize><br />
                 
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="2"></td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;">&nbsp;</td>
        </tr>
    </table>
    <table width="100%" align="center">
        <tr>
            <td height="5px" colspan="2">&nbsp;</td>
        </tr>
        <tr>
            <td height="10px" colspan="2" style="border-top: 1px solid #D0D0D0;">&nbsp;</td>
        </tr>
        <tr>
            <td colspan="2" align="right" style="padding-right: 15px;">&nbsp;&nbsp;&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>
                <asp:Localize ID="LocBySigUpForGlaCloYouAgr" meta:resourcekey="str_bySigUpForGlaCloYouAgr" runat="server">By signing up for Gladinet Cloud you agree to our</asp:Localize> <a href="../p/terms.htm"><asp:Localize ID="LocTer" meta:resourcekey="str_ter" runat="server">terms</asp:Localize></a>and <a href="../p/privacy.htm"><asp:Localize ID="LocPriPol" meta:resourcekey="str_priPol" runat="server">privacy policy</asp:Localize></a>. <asp:Localize ID="LocTheAreNoOblOrComAndWe" meta:resourcekey="str_theAreNoOblOrComAndWe" runat="server">There are no obligations or commitments, and we will never sell your information to a third party.</asp:Localize>
            </td>
        </tr>
    </table>
</asp:Content>
