﻿<%@ Page Title="Gladinet Cloud - Setup Azure Blob Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="Azure.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.AzureBlob" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            color: #339966;
        }
        .x-form-text
        {
        }
    </style>
</asp:Content>
<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="StepIndicator">
    <asp:Localize meta:resourcekey="str_setAzuBloAccInf" runat="server">Setup Azure Blob Account Information</asp:Localize>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="904" align="center" style="background: WHITE; padding: 15px;" cellspacing="0" id="input_panel">
        <tr>
            <td width="504" style="padding: 10px; vertical-align: top;">
<%if (!SessionAttaching)
  { %>

                <b><asp:Localize meta:resourcekey="str_youHavChoToPluInYouAzuBlo" runat="server">You have chosen to plug in your Azure Blob Storage account.</asp:Localize><br />
                    <br /><asp:Localize runat="server" meta:resourcekey="str_TheAzuBloConYouSelWilBecTheRooFolOfYouGlaCloAcc">The Azure Blob container you select will become the root folder of your Gladinet Cloud account.&nbsp;</asp:Localize></b>&nbsp;<br />

<%}
  else
  { %>
  <b><asp:Localize runat="server" meta:resourcekey="str_PleEntYouAccInf">Please enter your account information.</asp:Localize></b><br />
                    <asp:Localize meta:resourcekey="str_youWilProBloUrlAndThePriSec" runat="server">You will provide blob url and the primary secret key from your Azure Blob account area.</asp:Localize>
                    <br />
                    <asp:Localize meta:resourcekey="str_cliTheTesConButAndThePicA" runat="server">Click the test connection button and then pick a container as your root folder.</asp:Localize><br />

<%} %>
                <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                   { %>
                <asp:Label ID="ErrorMsg" runat="server" Style="" CssClass="errmsg"></asp:Label>
                <%} %>
                <table width="100%" align="center" style="display: block;">
                    <tr>
                        <td height="15px"><asp:Localize runat="server" meta:resourcekey="str_NbsBloUrl">&nbsp; Blob URL</asp:Localize></td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="393px"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td><asp:Localize runat="server" meta:resourcekey="str_PriAccKey">Primary Access Key</asp:Localize></td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="395px"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Button ID="BtnTestConnection" runat="server" Text="Test Connection" OnClick="BtnTestConnection_Click" />
                            <asp:HiddenField ID="HiddenFieldGoodConnection" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Panel ID="PanelPickBucket" runat="server">
                                <table width="100%" border="0">
                                    <tr>
                                        <td class="style1">
                                            <p class='green'><asp:Localize meta:resourcekey="str_conTesSuc" runat="server">Connection tested successfully!</asp:Localize></p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><asp:Localize runat="server" meta:resourcekey="str_SelACon">Select a Container :</asp:Localize></td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged">
                                                <asp:ListItem>{Test Connection First}</asp:ListItem>
                                            </asp:DropDownList>
                                            &nbsp;
                                            <br />
                                            <asp:Panel ID="PanelCreateBucket" runat="server">
                                                <div class='idea' style="width:408px;">
                                                    <asp:Localize meta:resourcekey="str_forSslYouConNamShoConNoPer" runat="server">For SSL, your container name should contain no periods. Also the container name 
                                                    needs to be all lower case (not $root either).</asp:Localize><br /></div>
                                                <asp:Panel ID="Panel1" runat="server" GroupingText="Create Container">
                                                    <asp:Localize meta:resourcekey="str_newConNamAllLowCas" runat="server">New Container Name (all lower case):</asp:Localize>&nbsp;
                                                    <asp:TextBox ID="TxtNewBucket" runat="server" Width="341px" CssClass="x-form-field x-form-text"></asp:TextBox>
                                                    <br />
                                                    <table width='100%'>
                                                        <tr>
                                                            <td width="50%">&nbsp;</td>
                                                            <td width="50%">&nbsp;</td>
                                                        </tr>
                                           
                                             
                                                    </table>
                                                </asp:Panel>
                                                <asp:Button ID="BtnCreateBucket" runat="server" Text="Create Container" OnClick="BtnCreateBucket_Click" />
                                            </asp:Panel>
                                            <br />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:Panel ID="PanelPickFolder" runat="server">
                                                <asp:Panel ID="PanelFolderDropDown" runat="server" Visible="False">
                                                    <table width="100%" border="0">
                                                        <tr>
                                                            <td height="32"><asp:Localize runat="server" meta:resourcekey="str_SelAFolLeaItBlaToSelTheRooFolInTheBuc">Select a Folder (Leave it blank to select the root folder in the bucket)</asp:Localize></td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <asp:DropDownList ID="DropDownListFolder" runat="server">
                                                                </asp:DropDownList>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                                <table width="100%">
                                                    <tr>
                                                        <td style="text-align: center">
                                                            <div class="linkbutton">
                                                                <asp:LinkButton ID="LinkButtonNext" runat="server" Font-Bold="true" Font-Size="16px"
                                                                    OnClick="ButtonFinish_Click" OnClientClick="showLoader(this.parentNode)" CssClass="linkbuttona">Next</asp:LinkButton>
                                                            </div>
                                                            <div style="display: none" id='blueloader'>
                                                                <img alt='loading ...' src="../images/blueloader.gif" width="160" height="20" /></div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                    </tr>
                </table>
            </td>
<%if (!SessionAttaching)
  { %>

            <td width="10">&nbsp;</td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px; vertical-align: top;">
                <img width="350" src="images/azure.png" />
                <div style="margin: 6px;">
                    <asp:Localize meta:resourcekey="str_youWilProBloUrlAndThePriSec" runat="server">You will provide blob url and the primary secret key from your Azure Blob account area.</asp:Localize>
                    <br />
                    <asp:Localize meta:resourcekey="str_cliTheTesConButAndThePicA" runat="server">Click the test connection button and then pick a container as your root folder.</asp:Localize><br />
                &nbsp;
            </td>

        </tr>
        <tr>
            <td colspan="2"></td>
            <td style="border-left: 1px solid #D0D0D0; padding-left: 10px;">&nbsp;</td>
        </tr>
<%} %>
    </table>

<%if (!SessionAttaching)
  { %>

    <table width="100%" align="center">
        <tr>
            <td height="5px" colspan="2">&nbsp;</td>
        </tr>
        <tr>
            <td height="10px" colspan="2" style="border-top: 1px solid #D0D0D0;">&nbsp;</td>
        </tr>
        <tr>
            <td colspan="2" align="right" style="padding-right: 15px;">&nbsp;&nbsp;&nbsp;&nbsp;</td>
        </tr>
        <tr>
            <td>
                <asp:Localize ID="LocBySigUpForGlaCloYouAgr" meta:resourcekey="str_bySigUpForGlaCloYouAgr" runat="server">By signing up for Gladinet Cloud you agree to our</asp:Localize> <a href="../p/terms.htm"><asp:Localize ID="LocTer" meta:resourcekey="str_ter" runat="server">terms</asp:Localize></a>and <a href="../p/privacy.htm"><asp:Localize ID="LocPriPol" meta:resourcekey="str_priPol" runat="server">privacy policy</asp:Localize></a>. <asp:Localize ID="LocTheAreNoOblOrComAndWe" meta:resourcekey="str_theAreNoOblOrComAndWe" runat="server">There are no obligations or commitments, and we will never sell your information to a third party.</asp:Localize>
            </td>
        </tr>
    </table>

         <script type="text/javascript">
         function EnableCompactMode() {
             var d = document.getElementById("input_panel");
             if (d)
                 d.height="550";

//             d = document.getElementById("spliter");
//             if (d)
//                 d.style.display = 'none';
             ShowRowPage();

         }

<%} %>

    <% if (string.Compare(DisplayMode,"compact",true)==0)
        { %>
            EnableCompactMode();
        <%} %>

         
        
    </script>

</asp:Content>
