﻿<%@ Page Title="Gladinet Cloud - Select Plan" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="SelectProvider.aspx.cs" Inherits="GladinetPayFlow.SelectProvider" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <script type="text/javascript">
        showLoader();

        function showHelpText(helptext) {
            var hctl = document.getElementById("HelpCtrl");
            var htext = document.getElementById("HelpText");

            if (helptext == "byoc") {
                htext.innerHTML = "As the default, Gladinet provides cloud storage for you to use. However, if you already have Amazon S3, Google Cloud Storage, or Open Stack-based Cloud Storage, you can bring your own storage account credentials and use your cloud storage account instead.";
            } else {
                htext.innerHTML = helptext;
            }

            hctl.style.display = 'block';
            hctl.style.left = (document.body.offsetWidth - 600) / 2 + "px";
            hctl.style.top = "200px";

            hctl.style.left = (event.clientX - 300) + "px";
            hctl.style.top = (event.clientY - 150) + "px";

        }

        function closeHelpText() {
            var hctl = document.getElementById("HelpCtrl");

            hctl.style.display = 'none';
        }
    </script>
    <div id="HelpCtrl" style="top: 0px; left: 0px; position: absolute; display: none;
        height: auto;" class="idea">
        <table width="400" align="center" border="0" cellspacing="0" cellpadding="0" style="padding-top: 6px;
            padding-bottom: 6px;">
            <tr>
                <td height="100px" valign="top">
                    <div id="HelpText" style="height: auto">
                    </div>
                </td>
            </tr>
            <tr>
                <td align="center" style="padding-top: 6px;">
                    <asp:Button ID="Button1" runat="server" Text="OK" OnClientClick="closeHelpText();return false;"
                        Width="108px" meta:resourcekey="Button1Resource1" />
                </td>
            </tr>
        </table>
    </div>
    <table width="100%" align="center" style="background: WHITE; padding: 15px; margin:0px;" cellspacing="0" >
        <tr>
            <td style="font-size: 16">
                <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                  { %>
                <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" 
                    meta:resourcekey="ErrorMsgResource1"></asp:Label>
                <%} %>
            </td>
        </tr>
        <tr>
        <td colspan=2 align=center style="padding:20px; background-color: #DFE8F6;">
                <h2>
                    <asp:Localize meta:resourcekey="string1" runat="server">Attach Third Party Cloud Storage Account</asp:Localize>
                </h2>

        </td>
        </tr>
        <tr>
            <td width="100%" style="padding: 10px; vertical-align: top;border-top:1px solid #d0d0d0;padding:10px;  margin:8px;">
                <table width="100%" >
                    <tr>
                        <td>
                            <b><asp:Localize meta:resourcekey="string2" runat="server">Name Your Storage Account:</asp:Localize></b>
                            <br /><asp:Localize meta:resourcekey="string3" runat="server">this will be the name of folder that is associated with your storage account.</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td align=left>
                            <asp:TextBox ID="AccountName" runat="server" Width="95%" 
                                CssClass="x-form-field x-form-text" 
                                meta:resourcekey="AccountNameResource1"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-top:15px;">
                        <b><asp:Localize meta:resourcekey="string4" runat="server">Select Storage Provider:</asp:Localize></b>
                        </td>
                    </tr>
                    <tr>
                        <td align=left>
                            <asp:DropDownList ID="StorageType" runat="server" Width="95%" 
                                meta:resourcekey="StorageTypeResource1">
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <table width="100%" align="center" style="margin:0px;">
        <tr>
            <td height="10px" colspan="2" >
                &nbsp;
            </td>
        </tr>
        <tr>
            <td colspan="2" align="center" style="padding-right: 15px;border-top: 1px solid #D0D0D0;padding-top:10px;">
                <table>
                    <tr>
                        <td>
                            <div style="display: none" id='blueloader'>
                                <img alt='loading ...' src="images/blueloader.gif" width="160" height="20" /></div>
                        </td>
                        <td width="50px">
                            &nbsp;
                        </td>
                        <td>
                            <div class="linkbutton">
                                <asp:LinkButton ID="LinkButton1" runat="server" Font-Bold="True" Font-Size="16px"
                                    OnClick="LinkButton1_Click" OnClientClick="showLoader(this.parentNode)" 
                                    CssClass="linkbuttona" meta:resourcekey="LinkButton1Resource1">Next</asp:LinkButton>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding:16px;">
            <br />
            <br />
            <%if (!SessionIsInstalledApp)
              { %>
                <asp:Localize meta:resourcekey="string5" runat="server">*Please note that when a Gladinet client performs a snapshot backup or sync operation, 
                    it interacts with the default storage provider for Gladinet Cloud Drive. 
                    If you want to backup and sync to a third party provider, you need to create an account which uses that provider's storage as the default storage for the Gladinet Cloud Drive.</asp:Localize>
          <%} %>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
         function EnableCompactMode() {
             var d = document.getElementById("input_panel");
             if (d)
                 d.height="550";

             ShowRowPage();

         }
    <% if (string.Compare(DisplayMode,"compact",true)==0)
        { %>
            EnableCompactMode();
        <%} %>

         
        
    </script>
</asp:Content>
