﻿<%@ Page Title="Gladinet Cloud - Client Device Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="SearchDevicesPage.aspx.cs" Inherits="GladinetPayFlow.SearchDevicesPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .dark {
            color: #565656 !important;
        }
        #headercontainer-1010-targetEl{border-top: 1px solid #cecece;}
        
        .actiontbl{
        display: table;
        }
        .actioncol{
        display: table-cell;margin-top:0px;
        }
        .actioncol .gladinet-icons {
        padding-top:2px;
        padding-left:10px;
        }
		.tooltip{
            margin:17px 0px 0px 0px !important;  /*tooltip positioning*/ 
		}
        .tooltip > .arrow {
            margin-left: 15px;
        }

        .nopadding{
            padding-left:0px!important;
        }
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function OpenFile(file) {
            var f = document.getElementById('rightpanel');
            f.src = "File.aspx?f=" + gEncodeUri(unescape(file));

        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("MainContent_DeviceId");
            var btn = document.getElementById("MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_wipe" runat="server">Do you really want to wipe the device (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_wiping" runat="server">Wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("MainContent_DeviceId");
            var btn = document.getElementById("MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">Wiping...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        
    function OnAgentAttachedFolders(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceAttachedFolders.aspx?f=c&id=" + id + "&name=" + name;
    }

    function OnAgentTasks(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false">not found</asp:Localize>

<asp:Localize meta:resourcekey="str_ddl_usrEml" ID="LocUsrEml"  Visible="false" runat="server">User Email</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_dvcTpe" ID="LocDvcTpe"  Visible="false" runat="server">Device Type</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_hstNme" ID="LocHstNme"  Visible="false" runat="server">Host Name</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_oprStm" ID="LocOprStm"  Visible="false" runat="server">Operating System</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_cntSfw" ID="LocCntSfw"  Visible="false" runat="server">Client Software Version</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sts" ID="LocSts"  Visible="false" runat="server">Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncSts" ID="LocSncSts"  Visible="false" runat="server">Sync Status</asp:Localize>

<asp:Localize meta:resourcekey="str_ddl_acd" ID="LocAcd"  Visible="false" runat="server">Accepted</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_rjd" ID="LocRjd"  Visible="false" runat="server">Rejected</asp:Localize>
                
<asp:Localize meta:resourcekey="str_ddl_snc" ID="LocSnc"  Visible="false" runat="server">Syncing</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fld" ID="LocFld"  Visible="false" runat="server">Failed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncCpd" ID="LocSncCpd"  Visible="false" runat="server">Sync Completed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fldRtvSts" ID="LocFldRtvSts"  Visible="false" runat="server">Failed to Retrieve Sync Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPnd" ID="LocSncTskPnd"  Visible="false" runat="server">Sync Task Pending</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPsd" ID="LocSncTskPsd"  Visible="false" runat="server">Sync Task Paused</asp:Localize>
                                                                                                                            
<asp:Localize meta:resourcekey="str_dvcFnd" ID="LocDvcFnd"  Visible="false" runat="server">Device(s) found</asp:Localize>
<asp:Localize meta:resourcekey="str_allTen" ID="LocAllTenants"  Visible="false" runat="server">All Tenants</asp:Localize>

   
      <div style="width: 100%; padding: 5px; border-bottom: 1px solid #cccccc ;" class="meubardrop1">
          <table width="100%">
              <tr>
                  <td style="width:180px">
                            <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize meta:resourcekey="str_devices" runat="server">Devices</asp:Localize></span>
                        </td>
                  <td>
                      <table>
                          <tr>
                              <td>
                                  <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="badge"></asp:Label>
                              </td>
                              <td style="padding-left:20px;">
           <asp:LinkButton ID="exportcsv" runat="server" style="font-size:16px; font-weight:100;" Visible="False" OnClick="exportcsv_Click"
                                ><asp:Localize ID="Localize1" meta:resourcekey="str_csv" runat="server">Download as a CSV file</asp:Localize></asp:LinkButton>

                              </td>
                          </tr>
                      </table>
                      
                  </td>
                  <td>
                      <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                  </td>
                  <%if (IsServo){ %>
                  <td align="right" width="40px">
                       <i class="gladinet-icons md-24 md-dark hand center" onclick="DownloadClient();" title="Download Client Software">)</i>
                  </td>
                  <%} %>
                  <td align="right" width="40px">
                <% if (string.IsNullOrEmpty(UserEmail) || SessionIsAdmin || FromMMC){ %>
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#SearchModal" title="Search">
                    <i class="gladinet-icons md-24 md-dark hand center">&#xA7;</i>
</button>

<!-- Modal -->
<div class="modal fade" id="SearchModal" tabindex="-1" role="dialog" aria-labelledby="SearchModal" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="SearchModalLabel"><asp:Localize meta:resourcekey="str_search" runat="server">Search</asp:Localize></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table style="width:100%;">
                                <% if (ShowDdlTenants) { %>
                                <tr>
                                    <td>
                                        <asp:DropDownList ID="DdlTenants" runat="server" AutoPostBack="False" CssClass="browser-default custom-select secsubbordercolor nopadding">
                                        </asp:DropDownList>
                                    </td>
                                </tr>
                                <% } %>
                                <tr>
                                    <td>
                                        <asp:DropDownList ID="Field" runat="server" AutoPostBack="True" OnSelectedIndexChanged="Field_SelectedIndexChanged" CssClass="browser-default custom-select secsubbordercolor nopadding"
                                            meta:resourcekey="FieldResource1">
                                        </asp:DropDownList>
                                    </td>
                                    </tr>
            <tr>
                                    <td style="padding-left: 3px; padding-right: 3px">
                                        <asp:TextBox ID="FileName" style="height:43px;" runat="server" meta:resourcekey="FileNameResource1"
                                            CssClass="form-control dark"></asp:TextBox>
                                        <asp:DropDownList ID="ActionName" runat="server" meta:resourcekey="ActionNameResource1" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                        
                                        <asp:DropDownList ID="StatusList" runat="server" meta:resourcekey="ActionNameResource1" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                    </td>
                                    
                                </tr>
                            </table>
                
      </div>
      <div class="modal-footer">
        
        <asp:Button ID="Button1" runat="server" Text="Search" OnClick="Button1_Click" meta:resourcekey="Button1Resource1" CssClass="btn btn-primary nbtn gladbtn"/>
          <button type="button" class="btn btn-default gladbtn" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
                            
                            <% } %>              

                  </td>
                  <% if (string.IsNullOrEmpty(UserEmail) || SessionIsAdmin){ %>
                  <td width="40px" align="right" valign="center">
                                        <div class="sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer; margin-top:-8px;" onclick="parent.ReturnLast();">&times;</div>
                                    </td>
                  <% } %>              
              </tr>
          </table>
         
          
      </div>
   
    <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: 30px" cellspacing="0" id="grid-table"
                    cellpadding="0">
                   
                    
                    <tr>
                        <td colspan="3" style="vertical-align: top;" id="result_div"></td>
                    </tr>
                     <%if (PubsRepeater.Items.Count == 0){ %>
                        <tr>
                        <td colspan="3" style="vertical-align: top; padding-top:60px;" align="center" >
                            <table style="width:100%; max-width:800px">
                                <tr>
                                    <td style="font-size:20px; font-weight:400; color:#404040;" align="center"><asp:Localize meta:resourcekey="str_noDevWerFou" runat="server">No devices were found.</asp:Localize></td>
                                </tr>
                                <%if (IsServo){ %>
                                <tr>
                                    <td style="font-size:14px; font-weight:100; color:#404040;padding:10px;" align="center"><asp:Localize meta:resourcekey="str_dowCliToAccFilShaRemWitNat" runat="server">Download clients to access file shares remotely with natively mapped drives on Windows and Mac clients. Replicate the same experience on mobile devices and web browsers.</asp:Localize></td>
                                </tr>
                                <%} %>
                                <tr>
                                    <td style="padding-top:40px;" align="center">
                                        <%if (IsServo){ %>
                                                                                <button type="button" class="btn btn-primary gladbtn"  title="Download Clients" onclick="parent.DownloadClient();">
                   Download Client
</button>
                                        <%} %>

                                        <button type="button" class="btn btn-primary gladbtn" data-toggle="modal" data-target="#SearchModal" title="Search">
                   Search Again
</button>

                                    </td>
                                </tr>
                            </table>
                        </td>

                        </tr>
                    <%} %>
                   
                </table>
    
    <div style="display: none;">
                        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Text=" Days ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Text=" Hours ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Text=" Minutes ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Text="Less than 1 minute ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_never" ID="StrNever" runat="server"
            Text="Never"></asp:Localize>

        <asp:Button ID="AllowBtn" runat="server" Text="Button" OnClick="AllowBtn_Click" meta:resourcekey="AllowBtnResource1" />
        <asp:Button ID="DenyBtn" runat="server" Text="Button" OnClick="DenyBtn_Click" meta:resourcekey="DenyBtnResource1" />
        <asp:HiddenField ID="InstanceId" runat="server" />
    </div>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" />
        <asp:Button ID="DeleteDevice" runat="server" OnClick="DeleteDevice_Click" />
    </div>
    <script type="text/javascript">    
var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" enableviewstate="true" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
        '<%#DataBinder.Eval(Container.DataItem, "UserId")%>', 
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"UserEmail").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"DeviceType").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"HostName").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"OsVer").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"ClientVer").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"InstanceId").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Status").ToString().Replace("'","%27")) %>',
        '<%#DataBinder.Eval(Container.DataItem,"LastLogin").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"LastReport").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"SyncStatus").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"LiveDevice").ToString().Replace("'","%27") %>'
         ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

      function OnChange(id) {
          
          var idc = document.getElementById("MainContent_InstanceId");
          var db = document.getElementById("MainContent_DenyBtn");
          var ab = document.getElementById("MainContent_AllowBtn");
          idc.value = id;

          var e = document.getElementById(id);
          if (e.checked) {
              
              ab.click();
          } else {
          
              db.click();
          }

      }

    var grid;
      
       function AdjustGridTable () {
           
           <%if(PubsRepeater.Items.Count == 0) { %>
           var a = document.getElementById("result_div");
           a.style.display = "none";
       <%}%>
            var h = 400;

            try {

                var myTable = Ext.get('grid-table');

                var tableY = myTable.getY();

                h = document.body.offsetHeight-tableY-60;

                var ee = document.getElementById('tinfo');
                ee.style.height = h + "px";

            } catch (err) {
            }
            grid.setWidth(document.documentElement.clientWidth - 2);
            grid.setHeight(h);
            grid.doComponentLayout();

            var e = document.getElementById("result_div");
            e.style.height = h + "px";

        }

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
      ]);
      Ext.onReady(function () {

            Ext.QuickTips.init();


          <%if (!Page.IsPostBack && PubsRepeater.Items.Count == 0){ %>
          //if the page is loading without postback and there are no devices, the initial state should be the search UI
            $('#SearchModal').modal({ backdrop: 'static', keyboard: false });
          <%} %>


            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                  { name: 'userid' },
                  { name: 'email' },
                  { name: 'type' },
                  { name: 'name' },
                  { name: 'os' },
                  { name: 'clientver' },
                  { name: 'id' },
                  { name: 'status' },
                  { name: 'lastlogin' },
                  { name: 'lastreport' },
                  { name: 'syncstatus' },
                  { name: 'livedevice' }
              ],
              data: myData
            });
          
            grid = Ext.create('Ext.grid.Panel', {
                store: store,
              stripeRows: true,
              border: false,
              columnLines: false,
              minHeight: 208,              
              minButtonWidth: 28,
              viewConfig: {
                  emptyText: "<asp:Localize meta:resourcekey="str_empty" runat="server">Please specify a search pattern for the search results</asp:Localize>",
                  deferEmptyText: false,
                  listeners: {
                      viewready: function(view){
                          //tooltip initializer resides in webapppanel.master, however
                          //due to a timing issue, it has to be forced here for this page
                          try{
                              $('[data-toggle="tooltip"]').tooltip({ "html": true });
                          }catch(ex){
                              console.log("tooltips could not be initialized", ex);
                          }
                      }
                  }
              },
          
              columns: [
                   {
                    text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                        return 'x-col-hide';
                    }
                   },
                   {
                       text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_name1" runat="server">Name</asp:Localize></span>",
                       width: 225,
          sortable: true,
          dataIndex: 'name',
          renderer: function (value, metaData, record, rowIndex) {
              var d = record.data;
              return "<span style='color:#565656; font-weight:100'>" +unescape(value)+ "</span><br/>"+"<span style='color:#565656; font-size:10px;font-weight:100'>" +unescape(d.os)+ "</span>";
          }
      }, 
                   {
                       text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_type" runat="server">Type</asp:Localize></span>",
                       flex: 1,
          minWidth:268,
          sortable: true,
          dataIndex: 'type',
          renderer: function (value, metaData, record, rowIndex) {
              var d = record.data;
              return "<span style='color:#565656; font-weight:100'>" +unescape(value)+ "</span><br/>"+"<span style='color:#565656; font-size:10px;font-weight:100'>" +unescape(d.clientver)+ "</span>";
          }

      },
                <% if (string.IsNullOrEmpty(UserEmail)){ %>

                  {
                      text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_email" runat="server">Email</asp:Localize></span>",
                      sortable: true,
                      minWidth: 108,
                      flex:9,
                      dataIndex: 'email',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#565656; font-weight:100'>" + unescape(value) + "</span>";
                      }

                  },
                  <% } %>
                  
                  
           
                    {
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_lastlogin" runat="server">Last Login</asp:Localize></span>",
                      minWidth: 175,
                      width:175,
                      sortable: true,
                      dataIndex: 'lastlogin',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#565656; font-weight:100'>" +unescape(value)+ "</span>";
                      }
                  }, {
                      text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_lastr" runat="server">Last Report</asp:Localize></span>",
                      minWidth: 175,
                      width:175,
                      sortable: true,
                      dataIndex: 'lastreport',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#565656; font-weight:100'>" +unescape(value)+ "</span>";
                      }
                  }, {
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_sts" runat="server">Status</asp:Localize></span>",
                      minWidth: 64,
                      width:100,
                      align: 'center',
                      sortable: true,
                      dataIndex: 'syncstatus',
                      renderer: function(value, metaData, record, rowIndex) {
                          if (value == "0")
                              return '<span class="gladinet-icons" title="<asp:Localize meta:resourcekey="str_ukn" runat="server">unknown</asp:Localize>" style="color:#008000">?</span>';
                        if (value == "6")
                            return '<span class="gladinet-icons " style="color:#808000" title="<asp:Localize meta:resourcekey="str_snkTskPsd" runat="server">Sync task paused</asp:Localize>">&#x10E;</span>';

                        if (value == "5")
                            return '<span class="gladinet-icons  " style="color:#008080" title="<asp:Localize meta:resourcekey="str_snkTskPnd" runat="server">Sync task pending</asp:Localize>">&#xc4;</span>';

                        if (value == "4")
                            return '<span class="gladinet-icons " style="color:#800000" title="<asp:Localize meta:resourcekey="str_fldToRtvSncSts" runat="server">Failed to retrieve sync status</asp:Localize>">?</span>';

                        if (value == "2")
                            return '<span class="gladinet-icons " style="color:#800000" title="<asp:Localize meta:resourcekey="str_sncFld" runat="server">Sync Failed</asp:Localize>">&#x10f;</span>';

                        if (value == "1")
                            return '<span class="gladinet-icons " style="color:#004080" title="<asp:Localize meta:resourcekey="str_snc" runat="server">Syncing</asp:Localize>">&#xd6;</span>';
                          if (value == "3")
                              return '<span class="gladinet-icons" style="color:#008000" title="<asp:Localize meta:resourcekey="str_snd" runat="server">Synced</asp:Localize>">&#xf9;</span>';

                      }
                  }, {
                      text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_allowed" runat="server">Allowed</asp:Localize></span>",
                      minWidth: 64,
                      width: 100,
                      align: 'center',
                      sortable: true,
                      dataIndex: 'status',
                      renderer: function (value, metaData, record, rowIndex) {
                          var d = record.data;
                          <% if (m_CanEdit)
                             { %>
                          if (value == "accepted")
                              return '<input id="' + d.id + '" type="checkbox" checked onclick=OnChange("' + d.id + '") name="uu_read_' + d.id + '"  value="1">'
                          return '<input id="' + d.id + '" type="checkbox"   onclick=OnChange("' + d.id + '") name="uu_read_' + d.id + '"  value="1">'
                          <% }else{ %>
                          if (value == "accepted")
                              return '<input disabled id="' + d.id + '" type="checkbox" checked onclick=OnChange("' + d.id + '") name="uu_read_' + d.id + '"  value="1">'
                          return '<input disabled id="' + d.id + '" type="checkbox"   onclick=OnChange("' + d.id + '") name="uu_read_' + d.id + '"  value="1">'

                          <%} %>

                      }
                  }, 






          {
          sortable: false,
          width:120,
          renderer: function (value, metaData, record, rowIndex) {
              var d = record.data;
              var ndeNme = d.nodename; 
              var wipDvcTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_wpeDvc" runat="server">Wipe Device</asp:Localize>\""; 
              var mngTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_managedev" runat="server">Manage</asp:Localize>\"";
              var tskMgrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_taskman" runat="server">Task Manager</asp:Localize>\"";
              var dltTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_dlt" runat="server">Delete</asp:Localize>\""; 
              //==================================================================
              var wipDvcBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnWipeDevice(&quot;"+d.id+"&quot;,&quot;"+d.name+"&quot;)\" "+wipDvcTTip+" style=\"font-size:25px;\">.</i></div>";
              <%if(!m_CanEdit){ %>
              wipDvcBtn = "";
              <%} %>
              //==================================================================
              var mngBtn = "";
              try {
                  if (d.type == "Windows Client" || d.type == "Mac Client" || d.type == "Server Agent") {
                      mngBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"window.location.href='/management/DeviceDashboard.aspx?child=1&id=" + d.id + "';\" "+mngTTip+">/</i></div>";
                  }
              } catch (ex) {}
              //==================================================================
              var dltBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnDeleteDevice(&quot;"+d.id+"&quot;,&quot;"+d.name+"&quot;)\" "+dltTTip+" style=\"margin-left:-3px;\">&#x136;</i></div>";
              <%if(!m_CanEdit){ %>
              dltBtn = "";
              <%} %>
              //==================================================================
              return "<div class=\"actiontbl\">"+wipDvcBtn+mngBtn+dltBtn+"</div>";
              }
            }







                  ],
              renderTo: 'result_div'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
        <%if (m_InSearch) { %>
        $('#SearchModal').modal({ backdrop: 'static', keyboard: false });
        <%}%>
            Ext.EventManager.onWindowResize(AdjustGridTable);
        });

             function DownloadClient()
        {
            window.location = "/management/servo/ServoClients.aspx?vdid=<%=SessionDomainId%>";
             }
    </script>
</asp:Content>
