﻿<%@ Page Title="Restore Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="RestoreFolder.aspx.cs" Inherits="GladinetPayFlow.RestoreFolder" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <link rel="stylesheet" href="/management/bootstrap4/css/tempusdominus-bootstrap-4.min.css" />
    <style type="text/css">
        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        .RestoreBtn {
            font-size: 16px;
        }
    </style>
    <script type="text/javascript">
        var DateCtl;
        var TimeCtl;
        var SelectedTime = null;

        function closeCancelActiveWin() {

            $('#browsemodal').modal('hide');
        }

        function closeActiveWin() {
            $('#browsemodal').modal('hide');
        }

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function SetSelectedFolder(s) {

            var inde;
            $('#browsemodal').modal('hide');

            var r = "<%=NormalizedFolderPath%>";
            inde = s.indexOf("<%=NormalizedFolderPath%>");
            if (inde != 0)
                return;
            s = s.substring(r.length + 1);

            var e = document.getElementById("MainContent_ExistFolderPath");
            e.innerHTML = s;
            e = document.getElementById("MainContent_SubFolder");

            e.value = s;
        }

        function Browse() {
            $('#browsemodal').modal({ backdrop: 'static', keyboard: false });
            var e = document.getElementById("btree");
            e.src = "/portal/BrowseTreePage.aspx?path=<%=NormalizedFolderPath%>&vdid=<%=SessionDomainId%>";
        }


        function OnRestoreClient() {

            if (SelectedTime == null) {
                alert("please select a time");
                return false;
            }

            var d = DateCtl.getValue();
            d.setHours(SelectedTime.getHours());
            d.setMinutes(SelectedTime.getMinutes());



            var ee = document.getElementById("MainContent_SelTime");
            ee.value = d.toUTCString();

            Wait("Restoring...");
            return true;


        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocMisFolPat" meta:resourcekey="str_misFolPat" Visible="false">Missing folder path</asp:Localize>
    <table width="100%">
        <tr>
            <td align="center">
                <div style="max-width: 820px; padding: 10px;">
                    <%if (string.IsNullOrEmpty(RestoreSessionId.Value))
                        { %>


                    <table style="background-color: white; max-width: 800px" width="100%">
                        <tr>
                            <td style="background-color: white; padding-left: 10px; font-weight: 100; padding-top: 20px;" class="gcardtitle">
                                <asp:Localize runat="server" meta:resourcekey="str_ChoTheDatYouWanToResTheFolTo">Chose the date-time you want to restore the folder to</asp:Localize></td>
                        </tr>
                        <tr>
                            <td align="center">
                                <table>
                                    <tr>
                                        <td id="datectrl" style="padding-right: 10px;"></td>
                                        <td id="timectrl"></td>

                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td align="center" style="padding: 10px; padding-top: 10px; font-size: 14px;">
                                <table border="0">
                                    <tr>
                                        <td style="padding: 3px;" class="glabeltext2">
                                            <asp:Localize runat="server" meta:resourcekey="str_Sub">Subfolder</asp:Localize></td>
                                        <td style="padding: 0px;" align="center">
                                            <asp:Label ID="ExistFolderPath" runat="server" Text="" CssClass="form-control" Width="300px"></asp:Label>
                                        </td>
                                        <td style="padding: 3px;" align="left">
                                            <button type="button" class="btn btn-primary gladbtn" onclick="Browse();return false;" style="font-size: 12px!important; padding: 3px!important">
                                                <asp:Localize runat="server" meta:resourcekey="str_Bro">Browse</asp:Localize></button>
                                            <div class="modal fade" id="browsemodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">

                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <iframe src="/portal/BrowseTreePage.aspx" style="width: 100%; height: 500px;" frameborder="0" id="btree"
                                                                border="0"></iframe>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td colspan="2">
                                            <label>
                                                <asp:Localize runat="server" meta:resourcekey="str_purFilWhoNamConTexPat">Purge files whose name contains text pattern:</asp:Localize></label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <asp:TextBox ID="NameFilter" runat="server" CssClass="form-control" Width="400px"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td valign="top" colspan="2" style="padding-left: 10px; padding-top: 20px;" align="left">
                                            <asp:CheckBox ID="Recursive" runat="server" meta:resourcekey="str_resSubRec" Text="Restore subfolder recursively" />


                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>



                        <tr>
                            <td colspan="2" height="10px">&nbsp;
                    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                        { %>
                                <div id="errmsgdiv" style="padding: 5px;">

                                    <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg"
                                        meta:resourcekey="ErrorMsgResource1"></asp:Label>

                                </div>
                                <%} %>                    

                            </td>
                        </tr>

                        <tr>
                            <td style="padding-top: 10px;" align="right" valign="top">

                                <button type="button" class="btn btn-info btn-lg gladbtn" data-toggle="modal" data-target="#myModal">
                                    <asp:Localize runat="server" meta:resourcekey="str_ResNow">Restore Now</asp:Localize></button>
                                <button type="button" class="btn btn-default btn-lg" onclick="parent.CloseChildWnd();return false;" style="font-weight: 100;">
                                    <asp:Localize runat="server" meta:resourcekey="str_Can">Cancel</asp:Localize></button>
                            </td>

                        </tr>

                    </table>
                    <div id="myModal" class="modal fade" role="dialog">
                        <div class="modal-dialog" style="width: 750px; min-width: 750px;">

                            <!-- Modal content-->
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">
                                        <asp:Localize runat="server" meta:resourcekey="str_ReaCarBefCon">Read Carefully Before Continue</asp:Localize></h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                                </div>
                                <div class="modal-body">
                                    <p>
                                        <asp:Localize runat="server" meta:resourcekey="str_ResTheFilInTheFolBacToTheVerBefTheDatChoTheSysWilScaTheFolAndFinAPreVerForEacFilWheThePreVerWasInsIntTheVerSysRigBefTheChoDatOncItIsFouACopWilBeMadToBecTheHeaVerAndThuBecTheCurVerOfTheFil">Restore the files in the folder back to the version before the date chosen. The system will scan the folder and find a previous version 
              for each file when the previous version was inserted into the version system right before the chosen date. Once it is found, a copy will be made to become the head version, and thus become the current version of the file.</asp:Localize>
                                    </p>
                                    <p>
                                        <asp:Localize runat="server" meta:resourcekey="str_Not">Notes:</asp:Localize></p>
                                    <ul style="font-size: 12px!important;">
                                        <li style="font-size: 12px!important;">
                                            <asp:Localize runat="server" meta:resourcekey="str_SinANewVerWilBeInsAtTheHeaVerTheRetPolMayKicInToRemTheOldVerPleCheYouRetPolFirToMakSurItAllACopOfTheOldVerToBeInsAsNewVer">Since a new version will be inserted at the head version, the retention policy may kick in to remove the oldest version. Please check your retention 
                  policy first to make sure it allows a copy of the old version to be inserted as new version.</asp:Localize></li>
                                        <li style="font-size: 12px!important;">
                                            <asp:Localize runat="server" meta:resourcekey="str_IfNoVerOfTheFilCanBeFouBefTheChoDatNoActWilBeTakForTheFil">If no version of the file can be found before the chosen date, no action will be taken for the file.</asp:Localize></li>
                                        <li style="font-size: 12px!important;">
                                            <asp:Localize runat="server" meta:resourcekey="str_IfYouHadManRevIndFilInTheFolBefTheVerTimOfThoFilMayHavBeeTouToMovItToAMorRecDatWheTheRevHapThoFilNeeToBeManCheAga">If you had manually reverted individual files in the folder before, the version timestamp of those files may have been touched to move it to a more recent date when the revert happened. Those files
                  need to be manually checked again.</asp:Localize></li>
                                    </ul>
                                    <div class="alert alert-danger">
                                        <asp:Localize runat="server" meta:resourcekey="str_PurFilWilNotBeRec">Purged file will not be recoverable</asp:Localize></div>
                                </div>
                                <div class="modal-footer">
                                    <asp:Button ID="RestoreNow" runat="server" CssClass="btn btn-primary gladbtn"
                                        OnClientClick="return OnRestoreClient();" meta:resourcekey="str_resNow" Text="Restore Now"
                                        OnClick="RestoreNow_Click" />

                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                        <asp:Localize runat="server" meta:resourcekey="str_Can">Cancel</asp:Localize></button>
                                </div>
                            </div>

                        </div>
                    </div>
                    <%}
                    else
                    { %>
                    <table style="max-width: 800px" class="table">

                        <tr>
                            <td style="padding-top: 60px; border-top: 0px!important;" class="glabel1">
                                <asp:Localize runat="server" meta:resourcekey="str_TasSta">Task Status</asp:Localize></td>
                            <td id="taskstatus" style="text-transform:capitalize;padding-top: 60px; border-top: 0px!important;" class="glabel1_h"></td>
                        </tr>
                        <tr>
                            <td class="glabel1">
                                <asp:Localize runat="server" meta:resourcekey="str_Not">Notes</asp:Localize></td>
                            <td id="currstatus" class="glabel1_h"></td>
                        </tr>
                        <tr>
                            <td class="glabel1">
                                <asp:Localize runat="server" meta:resourcekey="str_TotProFol">Total Processed Folders</asp:Localize></td>
                            <td id="foldercount" class="glabel1_h">0</td>
                        </tr>
                        <tr>
                            <td class="glabel1">
                                <asp:Localize runat="server" meta:resourcekey="str_TotProFil">Total Processed Files</asp:Localize></td>
                            <td id="filecount" class="glabel1_h">0</td>
                        </tr>

                        <tr>
                            <td colspan="2" style="padding-top: 30px" align="right">
                                <span class="btn btn-primary gladbtn" data-toggle="modal" data-target="#ctmodal" id="cabutton">
                                    <asp:Localize runat="server" meta:resourcekey="str_Can">Cancel</asp:Localize></span>
                                <span class="btn btn-primary gladbtn" id="cobutton" onclick="CloseWin();" style="display: none;">
                                    <asp:Localize runat="server" meta:resourcekey="str_Clo">Close</asp:Localize></span>
                                <!-- The modal -->
                                <div class="modal fade" id="ctmodal" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">

                                            <div class="modal-header">
                                                <h4 class="modal-title" id="modalLabelSmall">
                                                    <asp:Localize runat="server" meta:resourcekey="str_CanTas">Cancel Task</asp:Localize></h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>

                                            <div class="modal-body"><asp:Localize meta:resourcekey="str_doYouReaWanToCanTheTas" runat="server">Do you really want to cancel the task?</asp:Localize></div>
                                            <div class="modal-footer">
                                                <asp:LinkButton ID="CancelTask" runat="server" CssClass="btn btn-primary gladbtn" OnClick="CancelTask_Click">Yes</asp:LinkButton>
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    <asp:Localize runat="server" meta:resourcekey="str_No">No</asp:Localize></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </table>
                    <%} %>
                </div>
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="SelTime" runat="server" />
    <asp:HiddenField ID="RestoreSessionId" runat="server" />
    <asp:HiddenField ID="SubFolder" runat="server" />

    <script type="text/javascript">
        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        function OnPollRes(m) {

            var ts = document.getElementById("taskstatus");
            var note = document.getElementById("currstatus");
            var dc = document.getElementById("foldercount");
            var fc = document.getElementById("filecount");


            if (stringStartsWith(m, "{bad}")) {
                ts.innerHTML = "Failed";
                note.innerHTML = m.substring(5);
                document.getElementById("cabutton").style.display = "none";
                document.getElementById("cobutton").style.display = "";
                return;
            }

            var parts = m.split('|');
            ts.innerHTML = parts[0];
            note.innerHTML = parts[1];
            dc.innerHTML = parts[2];
            fc.innerHTML = parts[3];

            if (parts[0] == "done") {
                document.getElementById("cabutton").style.display = "none";
                document.getElementById("cobutton").style.display = "";

            } else {
                setTimeout("Poll()", 2000);
            }
        }

        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/portal/RestoreFolder.aspx?sid=<%=RestoreSessionId.Value %>&m=p',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('{bad}failed to poll status');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        function CloseWin() {
            window.location = "/portal/CloseWinCancel.htm";
        }

        Ext.onReady(function () {
            Ext.QuickTips.init();
            Ext.tip.QuickTipManager.init();

             <%if (!string.IsNullOrEmpty(RestoreSessionId.Value))
        { %>
            setTimeout("Poll()", 500);
        <%}
        else
        { %>
            DateCtl = new Ext.picker.Date({

                width: 560,
                height: 310,
                bodyPadding: 10,
                renderTo: 'datectrl'
            });

            TimeCtl = new Ext.picker.Time({
                width: 120,
                height: 310,
                renderTo: 'timectrl',
                listeners: {
                    selectionchange: function (e, s) {
                        SelectedTime = s[0].data.date;
                    }
                }
            });

            <%} %>
        });

    </script>
</asp:Content>
