/*
 * (c) Copyright Ascensio System SIA 2010-2015
 *
 * This program is a free software product. You can redistribute it and/or 
 * modify it under the terms of the GNU Affero General Public License (AGPL) 
 * version 3 as published by the Free Software Foundation. In accordance with 
 * Section 7(a) of the GNU AGPL its Section 15 shall be amended to the effect 
 * that Ascensio System SIA expressly excludes the warranty of non-infringement
 * of any third-party rights.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  PURPOSE. For 
 * details, see the GNU AGPL at: http://www.gnu.org/licenses/agpl-3.0.html
 *
 * You can contact Ascensio System SIA at Lubanas st. 125a-25, Riga, Latvia,
 * EU, LV-1021.
 *
 * The  interactive user interfaces in modified source and object code versions
 * of the Program must display Appropriate Legal Notices, as required under 
 * Section 5 of the GNU AGPL version 3.
 *
 * Pursuant to Section 7(b) of the License you must retain the original Product
 * logo when distributing the program. Pursuant to Section 7(e) we decline to
 * grant you any rights under trademark law for use of our trademarks.
 *
 * All the Product's GUI elements, including illustrations and icon sets, as
 * well as technical writing content are licensed under the terms of the
 * Creative Commons Attribution-ShareAlike 4.0 International. See the License
 * terms at http://creativecommons.org/licenses/by-sa/4.0/legalcode
 *
 * Version: 1.0 (build:28)
 */
Ext.define("Common.plugin.GridScrollPane",{extend:"Common.plugin.ScrollPane",alias:"plugin.gridscrollpane",areaSelector:".x-grid-view",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001},init:function(e){var t=this,n;t.callParent(arguments),n=t.cmp.getStore(),n&&n.on("datachanged",t.updateScrollPane,t,{buffer:10}),t.cmp.on("viewready",t.onViewReady,t,{single:!0})},onKeyDown:function(e,t){var n=this,r=n.cmp.getStore(),i=function(e){var t=n.cmp.getView().getNode(r.getAt(e)),i=Ext.create("Ext.Element",t);if(t){var s=Ext.getDom(n.cmp.getTargetEl())||Ext.getBody().dom,o=i.getOffsetsTo(s),u=o[1]+s.scrollTop,a=u+t.offsetHeight,f=s.clientHeight,l=parseInt(s.scrollTop,10),c=l+f;t.offsetHeight>f||u<l?n.jspApi&&n.jspApi.scrollByY(u,!1):a>c&&n.jspApi&&n.jspApi.scrollByY(a-f,!1)}};switch(e.getKey()){case e.UP:case e.DOWN:var s=n.cmp.getSelectionModel().getLastSelected(),o=s?r.indexOf(s):-1;i(o);break;case e.PAGE_UP:case e.PAGE_DOWN:break;case e.HOME:i(0);break;case e.END:i(r.count()-1)}},onViewReady:function(){var e=this;e.cmp.getView().getEl().on("keydown",e.onKeyDown,e,{stopEvent:!0})}}),Ext.define("Common.component.util.RGBColor",{alternateClassName:"Common.util.RGBColor",constructor:function(e){this.ok=!1,e.charAt(0)=="#"&&(e=e.substr(1,6)),e=e.replace(/ /g,""),e=e.toLowerCase();var t=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){return[parseInt(e[1]),parseInt(e[2]),parseInt(e[3])]}},{re:/^hsb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t={},n=Math.round(e[1]),r=Math.round(e[2]*255/100),i=Math.round(e[3]*255/100);if(r==0)t.r=t.g=t.b=i;else{var s=i,o=(255-r)*i/255,u=(s-o)*(n%60)/60;n==360&&(n=0),n<60?(t.r=s,t.b=o,t.g=o+u):n<120?(t.g=s,t.b=o,t.r=s-u):n<180?(t.g=s,t.r=o,t.b=o+u):n<240?(t.b=s,t.r=o,t.g=s-u):n<300?(t.b=s,t.g=o,t.r=o+u):n<360?(t.r=s,t.g=o,t.b=s-u):(t.r=0,t.g=0,t.b=0)}return[Math.round(t.r),Math.round(t.g),Math.round(t.b)]}},{re:/^(\w{2})(\w{2})(\w{2})$/,process:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,process:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}}];for(var n=0;n<t.length;n++){var r=t[n].re,i=t[n].process,s=r.exec(e);if(s){var o=i(s);this.r=o[0],this.g=o[1],this.b=o[2],this.ok=!0}}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.isEqual=function(e){return this.r==e.r&&this.g==e.g&&this.b==e.b},this.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"},this.toRGBA=function(e){return e===undefined&&(e=1),"rgba("+this.r+", "+this.g+", "+this.b+", "+e+")"},this.toHex=function(){var e=this.r.toString(16),t=this.g.toString(16),n=this.b.toString(16);return e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),"#"+e+t+n},this.toHSB=function(){var e={h:0,s:0,b:0},t=Math.min(this.r,this.g,this.b),n=Math.max(this.r,this.g,this.b),r=n-t;return e.b=n,e.s=n!=0?255*r/n:0,e.s!=0?this.r==n?e.h=0+(this.g-this.b)/r:this.g==n?e.h=2+(this.b-this.r)/r:e.h=4+(this.r-this.g)/r:e.h=0,e.h*=60,e.h<0&&(e.h+=360),e.s*=100/255,e.b*=100/255,e.h=parseInt(e.h),e.s=parseInt(e.s),e.b=parseInt(e.b),e}}}),Ext.define("Common.component.HSBColorPicker",{extend:"Ext.Component",alias:"widget.hsbcolorpicker",requires:["Common.component.util.RGBColor","Ext.XTemplate"],baseCls:"cmp-hsb-colorpicker",allowEmptyColor:!1,changeSaturation:!0,showCurrentColor:!0,config:{color:"#ff0000"},renderTpl:['<div class="{baseCls}-root">','<tpl if="showCurrentColor">','<div class="{baseCls}-top-panel">','<span class="{baseCls}-color-value">','<span class="transparent-color"></span>',"</span>",'<div class="{baseCls}-color-text"></div>',"</div>","</tpl>","<div>",'<div class="{baseCls}-cnt-hb">','<div class="{baseCls}-cnt-hb-arrow"></div>',"</div>",'<tpl if="changeSaturation">','<div class="{baseCls}-cnt-root">','<div class="{baseCls}-cnt-sat">','<div class="{baseCls}-cnt-sat-arrow"></div>',"</div>","</div>","</tpl>","</div>",'<tpl if="allowEmptyColor">','<div class="{baseCls}-empty-color">{textNoColor}</div>',"</tpl>","</div>"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t,n,r,i,s,o,u,a,f=0,l=100,c=100,h=function(t,n){var r=new Common.util.RGBColor(Ext.String.format("hsb({0}, {1}, {2})",t.h,t.s,t.b)),i=r.toHex();e.color=n?"transparent":i,p(),e.fireEvent("changecolor",e,e.color)},p=function(){s&&o&&(e.color=="transparent"?o.show():(s.setStyle("background-color",e.color),o.hide())),r&&r.setStyle("background-color",(new Common.util.RGBColor(Ext.String.format("hsb({0}, 100, 100)",f))).toHex()),u&&(u.dom.innerHTML=e.color=="transparent"?e.textNoColor:e.color.toUpperCase()),t&&n&&(t.setLeft(l+"%"),t.setTop(100-c+"%"),n.setTop(parseInt(f*100/360)+"%"))},d=function(e,n,i){if(t&&r){var s=[Math.max(0,Math.min(100,parseInt((e.getX()-r.getX())/r.getWidth()*100))),Math.max(0,Math.min(100,parseInt((e.getY()-r.getY())/r.getHeight()*100)))];t.setLeft(s[0]+"%"),t.setTop(s[1]+"%"),l=s[0],c=100-s[1],h({h:f,s:l,b:c})}},v=function(e,t,r){if(n&&i){var s=Math.max(0,Math.min(100,parseInt((e.getY()-i.getY())/i.getHeight()*100)));n.setTop(s+"%"),f=parseInt(360*s/100),h({h:f,s:l,b:c})}},m=function(e,t,n){Ext.getDoc().on("mouseup",g),Ext.getDoc().on("mousemove",d)},g=function(e,t,n){Ext.getDoc().un("mouseup",g),Ext.getDoc().un("mousemove",d),d(e,t,n)},y=function(e,t,n){Ext.getDoc().on("mouseup",b),Ext.getDoc().on("mousemove",v),v(e,t,n)},b=function(e,t,n){Ext.getDoc().un("mouseup",b),Ext.getDoc().un("mousemove",v)},w=function(t){var n=(new Common.util.RGBColor(e.color)).toHSB();h(n,!0)},E=function(h){var d=e.getEl(),v;d&&(t=d.down("."+e.baseCls+"-cnt-hb-arrow"),n=d.down("."+e.baseCls+"-cnt-sat-arrow"),r=d.down("."+e.baseCls+"-cnt-hb"),i=d.down("."+e.baseCls+"-cnt-sat"),s=d.down("."+e.baseCls+"-color-value"),u=d.down("."+e.baseCls+"-color-text"),a=d.down("."+e.baseCls+"-empty-color"),s&&(o=s.child(".transparent-color")),r&&(r.un("mousedown"),r.on("mousedown",m,e)),i&&(i.un("mousedown"),i.on("mousedown",y,e)),a&&(a.un("click"),a.on("click",w,e)),e.color=="transparent"?v={h:0,s:100,b:100}:v=(new Common.util.RGBColor(e.color)).toHSB(),f=v.h,l=v.s,c=v.b,f==l&&f==c&&f==0&&(l=100),p())};e.setColor=function(t){if(e.color==t)return;var n;t=="transparent"?n={h:0,s:100,b:100}:n=(new Common.util.RGBColor(t)).toHSB(),f=n.h,l=n.s,c=n.b,f==l&&f==c&&f==0&&(l=100),e.color=t,p()},e.on("afterrender",E,this),e.callParent(arguments),this.addEvents("changecolor")},onRender:function(e,t){var n=this;Ext.applyIf(n.renderData,n.getTemplateArgs()),n.callParent(arguments)},getTemplateArgs:function(){var e=this;return{allowEmptyColor:e.allowEmptyColor,changeSaturation:e.changeSaturation,textNoColor:e.textNoColor,showCurrentColor:e.showCurrentColor}},textNoColor:"No Color"}),Ext.define("Common.view.ExtendedColorDialog",{extend:"Ext.window.Window",alias:"widget.commonextendedcolordialog",cls:"common-extendedcolordialog",requires:["Ext.window.Window","Common.component.HSBColorPicker"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,closeAction:"destroy",plain:!0,height:276,width:326,minWidth:188,padding:"16px",layout:{type:"vbox",align:"stretch"},listeners:{beforehide:function(){this._modalresult===undefined&&this.fireEvent("onmodalresult",0)},show:function(){this.textColor.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){function r(e){if(!n.stopevents){var t=(n.spinR.getValue()==null?0:n.spinR.getValue()).toString(16),r=(n.spinG.getValue()==null?0:n.spinG.getValue()).toString(16),i=(n.spinB.getValue()==null?0:n.spinB.getValue()).toString(16),s=(t.length==1?"0"+t:t)+(r.length==1?"0"+r:r)+(i.length==1?"0"+i:i);n.colorsPicker.setColor("#"+s),e!="hex"&&n.textColor.setValue(s.toUpperCase()),n.colorNew.getEl().setStyle("background-color","#"+s)}}var e=Ext.create("Ext.Button",{text:this.addButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),n=this;n.hexRe=/\s*#?([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)\s*/,this.colorsPicker=Ext.widget("hsbcolorpicker",{height:198,color:"#000000",width:220,changeSaturation:!0,showCurrentColor:!1,style:"margin-top:2px;margin-right:6px;",listeners:{render:function(e){$("."+this.baseCls+"-cnt-root").css("margin-right","0")},changecolor:function(e,t){n.colorNew.getEl().setStyle("background-color",t),n.stopevents=!0;var r=t.match(n.hexRe);n.spinR.setValue(parseInt(r[1],16)),n.spinG.setValue(parseInt(r[2],16)),n.spinB.setValue(parseInt(r[3],16)),n.textColor.setValue((r[1]+r[2]+r[3]).toUpperCase()),n.stopevents=!1}}}),this.spinR=Ext.widget("numberfield",{fieldLabel:"R",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:4px;",listeners:{change:r}}),this.spinG=Ext.widget("numberfield",{fieldLabel:"G",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:4px;",listeners:{change:r}}),this.spinB=Ext.widget("numberfield",{fieldLabel:"B",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:16px;",listeners:{change:r}}),this.colorSaved=Ext.widget("box",{id:"field-start-color",height:20}),this.colorNew=Ext.widget("box",{height:20}),this.textColor=Ext.widget("textfield",{fieldLabel:"#",labelWidth:10,maskRe:/[a-fA-F0-9]/,maxLength:6,enforceMaxLength:!0,validator:function(e){if(!/^[a-fA-F0-9]{0,6}$/.test(e))return"Incorrect color value";e="000000"+e;var t=e.match(/([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$/i);return n.stopevents=!0,n.spinR.setValue(parseInt(t[1],16)),n.spinG.setValue(parseInt(t[2],16)),n.spinB.setValue(parseInt(t[3],16)),n.stopevents=!1,this.rendered&&r("hex"),!0},listeners:{afterrender:function(e){e.inputEl.setStyle("text-align","right")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"container",height:202,layout:{type:"hbox",align:"stretch"},items:[this.colorsPicker,{xtype:"container",width:68,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",text:this.textNew,style:"text-align:center;width:100%;margin-bottom:2px;"},this.colorNew,this.colorSaved,{xtype:"label",text:this.textCurrent,style:"text-align:center;width:100%;margin-top:2px;margin-bottom:14px;"},this.spinR,this.spinG,this.spinB,this.textColor]}]},{xtype:"tbspacer",height:14},{xtype:"container",layout:{type:"hbox",align:"middle",pack:"center"},items:[e,{xtype:"tbspacer",width:10},t]}],this.callParent(arguments)},getColor:function(){var e=/#?([a-fA-F0-9]{6})/.exec(this.colorsPicker.getColor());return e?e[1]:null},setColor:function(e){function r(){e=="transparent"?t.colorSaved.addCls("color-transparent"):(t.colorSaved.removeCls("color-transparent"),t.colorSaved.getEl().setStyle("background-color","#"+e)),t.colorNew.getEl().setStyle("background-color","#"+n)}var t=this,n=/#?([a-fA-F0-9]{6})/.test(e)?e:"ff0000";t.colorsPicker.setColor("#"+n),t.colorSaved.rendered?r():t.colorSaved.on("afterrender",r,{single:!0}),t.stopevents=!0;var i=t.hexRe.exec(n);t.spinR.setValue(parseInt(i[1],16)),t.spinG.setValue(parseInt(i[2],16)),t.spinB.setValue(parseInt(i[3],16)),t.textColor.setValue((i[1]+i[2]+i[3]).toUpperCase()),t.stopevents=!1},cancelButtonText:"Cancel",addButtonText:"Add",textNew:"New",textCurrent:"Current"}),Ext.define("Common.component.DataViewPicker",{extend:"Ext.container.Container",requires:["Ext.data.Store","Ext.data.Model","Ext.view.View","Ext.XTemplate","Ext.container.Container","Common.plugin.DataViewScrollPane"],uses:["Common.component.GroupedDataView"],alias:"widget.cmddataviewpicker",layout:{type:"fit"},constructor:function(e){if(!e||!e.viewData)throw Error("Common.component.DataViewPicker creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);e.selectedRec=null,Ext.define("DataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]}),e.store=Ext.isDefined(t.store)?t.store:Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"DataModel",data:t.viewData});var n=Ext.isDefined(t.dataTpl)?t.dataTpl:Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">',e.itemWidth!==undefined&&e.itemHeight!==undefined?'<img src="{imageUrl}" width="'+e.itemWidth+'" height="'+e.itemHeight+'"/>':'<img src="{imageUrl}" />','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>");if(e.isGroupedDataView)var r=Ext.create("Common.component.GroupedDataView",{store:e.store,listeners:{itemclick:function(t,n,r,i,s,o){e.selectedRec=n,e.fireEvent("select",e,n,r,i)},beforecontainerclick:function(e,t,n){return!1},selectionchange:function(t,n,i){var s=r.getPlugin("scrollpane"),o=r.getNode(n[0]);s&&o&&s.scrollToElement(o),e.fireEvent("selectionchange",e,t,n)},itemkeydown:function(e,t,n,r,i,s){i.getKey()==i.ENTER&&e.fireEvent("itemclick",e,t,n,r,i,s)}},plugins:[{ptype:"dataviewscrollpane",areaSelector:".grouped-data-view",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001,contentWidth:e.contentWidth}}]});else var r=Ext.create("Ext.view.View",{store:e.store,tpl:n,singleSelect:!0,trackOver:!0,autoScroll:!0,overItemCls:"x-item-over",itemSelector:"div.thumb-wrap",emptyText:"",cls:"storage-data-view",listeners:{itemclick:function(t,n,r,i,s,o){e.selectedRec=n,e.fireEvent("select",e,n,r,i)},beforecontainerclick:function(e,t,n){return!1},selectionchange:function(t,n,r){e.fireEvent("selectionchange",e,t,n)},itemkeydown:function(e,t,n,r,i,s){i.getKey()==i.ENTER&&e.fireEvent("itemclick",e,t,n,r,i,s)},itemmouseenter:function(t,n,r,i,s,o){e.fireEvent("itemmouseenter",e,n,r,i,s,o)},itemmouseleave:function(t,n,r,i,s,o){e.fireEvent("itemmouseleave",e,n,r,i,s,o)}},plugins:[{ptype:"dataviewscrollpane",areaSelector:".storage-data-view",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001,contentWidth:e.contentWidth}}]});e.addEvents("select","itemmouseenter","itemmouseleave"),e.handler&&e.on("select",e.handler,e.scope,e),e.getSelectedRec=function(){return e.isGroupedDataView?r.getSelected():r.getSelectionModel().getSelection()[0]},e.selectByIndex=function(t,n){if(r.rendered)if(t<0)r.getSelectionModel().deselectAll(!1),e.selectedRec=null;else{var i=Ext.isDefined(n)?n:!0;e.selectedRec=e.store.getAt(t),r.getSelectionModel().select(e.store.getAt(t),!1,i)}else r.on("afterrender",Ext.bind(function(t){e.selectByIndex(t)},this,[t]),{single:!0})},e.selectGroupItem=function(t,n){return!e.isGroupedDataView||!r?null:(e.selectedRec=r.selectGroupItem(t,n),e.selectedRec)},e.updateScrollPane=function(){var t=r.getPlugin("scrollpane");t&&r.getEl()&&r.getEl().getWidth()>0&&(t.settings&&(t.settings.contentWidth=e.contentWidth),t.updateScrollPane(r.getEl().dom),e.checkScrolls(),e.arrangeItems&&e.arrangeItems.call(e))},e.checkScrolls=function(){var t=r.getPlugin("scrollpane");if(t&&r.getEl()){var n=e.getEl().down(".jspPane");if(n.getHeight()>0&&e.getEl().getHeight()>0)var i=0,s=setInterval(function(){n.getHeight()>e.getEl().getHeight()&&(e.getEl().down(".jspVerticalBar")?clearInterval(s):(t.updateScrollPane(r.getEl().dom),clearInterval(s))),i++>3&&clearInterval(s)},100)}},e.showUpdated=function(){e.updateScrollPane(),r&&r.getEl()&&(r.getEl().focus(50),e.selectedRec?r.getSelectionModel().select(e.selectedRec,!1,!1):r.getSelectionModel().deselectAll(!1))},r.getStore().on("datachanged",e.updateScrollPane,e,{buffer:10}),r.on("viewready",e.updateScrollPane,e),e.on("resize",e.updateScrollPane,e),e.on("afterlayout",e.updateScrollPane,e),e.items=[r],this.callParent(arguments)}}),Ext.define("Common.component.MenuDataViewPicker",{extend:"Ext.menu.Menu",alias:"widget.cmdmenudataviewpicker",requires:["Common.component.DataViewPicker"],hideOnClick:!0,hideMode:"display",constructor:function(e){if(!e||!e.viewData)throw Error("Common.component.MenuDataViewPicker creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);delete t.listeners,Ext.apply(e,{plain:!0,showSeparator:!1,items:Ext.applyIf({xtype:"cmddataviewpicker",padding:Ext.isDefined(t.pickerpadding)?t.pickerpadding:"2px 4px 1px 2px",store:t.store},t)}),e.callParent(arguments),e.picker=e.down("cmddataviewpicker"),e.relayEvents(e.picker,["select","itemmouseenter","itemmouseleave"]),e.hideOnClick&&e.on("select",e.hidePickerOnSelect,e),e.on("resize",function(t,n,r,i){e.applyContentWidth&&n>=20&&(e.picker.contentWidth=n-20),e.picker.setSize(n,r)},this),e.on("show",function(t){e.picker.showUpdated()},this)},hidePickerOnSelect:function(e,t,n){Ext.menu.Manager.hideAll()}}),Ext.define("Common.component.ThemeColorPalette",{extend:"Ext.ColorPalette",alias:"widget.cmpthemecolorpalette",allowReselect:!0,dyncolorscount:12,width:193,maxWidth:200,baseCls:"cmp-theme-colorpalette",requires:["Common.view.ExtendedColorDialog"],renderTpl:['<div style="padding: 12px;">','<tpl for="colors">','<tpl if="this.isBlankSeparator(values)"><div class="palette-color-spacer" style="width:100%;height:8px;float:left;"></div></tpl>','<tpl if="this.isSeparator(values)"></div><div class="palette-color-separator" style="width:100%;height:1px;float:left;border-bottom: 1px solid #E0E0E0"></div><div style="padding: 12px;"></tpl>','<tpl if="this.isColor(values)">','<a href="#" class="palette-color color-{.}" style="background:#{.} "hidefocus="on">','<em><span style="background:#{.}; border: 1px solid rgba(0, 0, 0, 0.2);" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isTransparent(values)">','<a href="#" class="color-{.}" hidefocus="on">','<em><span unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isCustom(values)">','<a href="#" id="{id}" class="palette-color-custom {cls}" hidefocus="on">','<em><span style="background:#FFFFFF;background-image:url({image});" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isEffect(values)">','<a href="#" effectid="{effectId}" effectvalue="{effectValue}" class="palette-color-effect color-{color}" style="background:#{color}" hidefocus="on">','<em><span style="background:#{color}; border: 1px solid rgba(0, 0, 0, 0.2);" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isCaption(values)"><div class="palette-color-caption" style="width:100%;float:left;font-size: 11px;">{.}</div></tpl>',"</tpl>","</div>",{isBlankSeparator:function(e){return typeof e=="string"&&e=="-"},isSeparator:function(e){return typeof e=="string"&&e=="--"},isColor:function(e){return typeof e=="string"&&/[0-9A-F]{6}/.test(e)},isTransparent:function(e){return typeof e=="string"&&e=="transparent"},isCaption:function(e){return typeof e=="string"&&e!="-"&&e!="--"&&!/[0-9A-F]{6}|transparent/.test(e)},isEffect:function(e){return typeof e=="object"&&e.effectId!==undefined},isCustom:function(e){return typeof e=="object"&&e.effectId===undefined}}],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.callParent(arguments)},onRender:function(e){this.callParent(arguments);if(this.dynamiccolors){var t=e.down(".x-color-picker");if(t){var n=-1,r='<div class="palette-color-spacer" style="width:100%;height:8px;float:left;"></div><div style="padding: 12px;">';while(++n<this.dyncolorscount)r+=Ext.String.format('<a href="#" class="color-dynamic-{0} dynamic-empty-color" style="background:#ffffff" color="" hidefocus="on"><em><span unselectable="on">&#160;</span></em></a>',n);r+="</div>",Ext.DomHelper.insertHtml("beforeEnd",t.dom,r)}}var i=this.el.up(".x-menu");i&&Ext.menu.Manager.menus[i.id].addListener("beforeshow",this.updateCustomColors,this),this.updateCustomColors()},afterRender:function(e){this.callParent(arguments),this.updateColorsArr&&this.updateColors(this.updateColorsArr[0],this.updateColorsArr[1]),this.lastvalue&&this.select(this.lastvalue,!0)},setCustomColor:function(e){e=/#?([a-fA-F0-9]{6})/.exec(e);if(e){var t=this.getEl();if(t){this._saveCustomColor(e[1]),$("#"+t.id+" a."+this.selectedCls).removeClass(this.selectedCls);var n=t.down(".dynamic-empty-color");n||(this.updateCustomColors(),n=t.down(".color-dynamic-"+(this.dyncolorscount-1))),n.removeCls("dynamic-empty-color").addCls(this.selectedCls).dom.setAttribute("color",e[1]),n.down("span").setStyle("background-color","#"+e[1]).setStyle("border","none")}}},select:function(e,t){if(!this.rendered){this.lastvalue=e;return}var n=this.getEl();n&&$("#"+n.id+" a."+this.selectedCls).removeClass(this.selectedCls);if(typeof e=="object"){var r;e.effectId!==undefined?(r=n.down('a[effectid="'+e.effectId+'"]'),r?(r.addCls(this.selectedCls),this.value=r.dom.className.match(this.colorRe)[1].toUpperCase()):this.value=!1):e.effectValue!==undefined&&(r=n.down('a[effectvalue="'+e.effectValue+'"].color-'+e.color.toUpperCase()),r?(r.addCls(this.selectedCls),this.value=r.dom.className.match(this.colorRe)[1].toUpperCase()):this.value=!1)}else{/#?[a-fA-F0-9]{6}/.test(e)&&(e=/#?([a-fA-F0-9]{6})/.exec(e)[1].toUpperCase(),this.value=e);if(/^[a-fA-F0-9]{6}|transparent$/.test(e)&&Ext.Array.contains(this.colors,e)){Ext.Array.contains(this.colors,this.value)||(this.value=!1);if(e!=this.value||this.allowReselect)this.value&&(this.value=="transparent"?n.down("a.color-transparent").removeCls(this.selectedCls):n.down("a.palette-color.color-"+this.value).removeCls(this.selectedCls)),e=="transparent"?n.down("a.color-transparent").addCls(this.selectedCls):n.down("a.palette-color.color-"+e).addCls(this.selectedCls),this.value=e,t!==!0&&this.fireEvent("select",this,e)}else if(n){var i=n.down("#"+e)||n.down('a[color="'+e+'"]');i?(i.addCls(this.selectedCls),this.value=e.toUpperCase()):n.down("a."+this.selectedCls)?this.value=!1:this.dynamiccolors}else this.lastvalue=e}},handleClick:function(e,t){var n=this,r,i;if(t.className.search("palette-color-custom")<0)if(t.className.search("color-transparent")<0)if(t.className.search("color-dynamic")<0){i=Ext.get(t.parentNode).down("a.palette-color-custom"),i&&i.removeCls(n.selectedCls);if(!/^[a-fA-F0-9]{6}$/.test(this.value)||!Ext.Array.contains(this.colors,this.value))this.value=!1;if(t.className.search("palette-color-effect")<0)this.callParent(arguments);else{r=t.className.match(n.colorRe)[1];var s=t.getAttribute("effectid");r&&(n.fireEvent("select",n,{color:r,effectId:s}),this.value=r.toUpperCase()),$("#"+this.getEl().id+" a."+n.selectedCls).removeClass(n.selectedCls),Ext.get(t).addCls(n.selectedCls)}}else/dynamic-empty-color/.test(t.className)?setTimeout(function(){n.addNewColor(),Ext.menu.Manager.hideAll()},10):(r=t.getAttribute("color"),r&&n.fireEvent("select",n,r),this.value=r.toUpperCase(),$("#"+this.getEl().id+" a."+n.selectedCls).removeClass(n.selectedCls),Ext.get(t).addCls(n.selectedCls));else{e.stopEvent(),i=Ext.get(t.parentNode).down("a."+n.selectedCls);if(!i||i.id!=t.id)i&&i.removeCls(n.selectedCls),Ext.get(t).addCls(n.selectedCls),n.value="transparent";n.fireEvent("select",n,"transparent")}else e.stopEvent(),i=Ext.get(t.parentNode).down("a."+n.selectedCls),!i||i.id!=t.id?(i&&i.removeCls(n.selectedCls),Ext.get(t.id).addCls(n.selectedCls),n.value=!1,n.fireEvent("select",n,t.id)):n.fireEvent("select",n,i.id)},addNewColor:function(){var e=this,t=Ext.create("Common.view.ExtendedColorDialog",{});t.addListener("onmodalresult",function(n){e._isdlgopen=!1,n==1&&(e.setCustomColor(t.getColor()),e.fireEvent("select",e,t.getColor()))},!1),e._isdlgopen=!0,t.setColor(e.value),t.show()},isDialogOpen:function(){return this._isdlgopen==1},updateColors:function(e,t){if(!this.rendered){this.updateColorsArr=[e,t.length==0&&this.updateColorsArr?this.updateColorsArr[1]:t];return}var n=this,r=this.getEl();n.aColorElements===undefined&&(n.aColorElements=r.query("a.palette-color")),n.aEffectElements===undefined&&(n.aEffectElements=r.query("a.palette-color-effect"));var i,s=0,o=0;for(var u=0;u<n.colors.length;u++)if(typeof n.colors[u]=="string"&&/[0-9A-F]{6}/.test(n.colors[u])){if(s>=t.length)continue;i=Ext.get(n.aColorElements[s]),i.removeCls("color-"+n.colors[u]),n.colors[u]=t[s].toUpperCase(),i.addCls("color-"+n.colors[u]),i.applyStyles({background:"#"+n.colors[u]}),i.down("span").applyStyles({background:"#"+n.colors[u]}),s++}else if(typeof n.colors[u]=="object"&&n.colors[u].effectId!==undefined){if(o>=e.length)continue;i=Ext.get(n.aEffectElements[o]),e[o].color=e[o].color.toUpperCase(),n.colors[u].color!==e[o].color&&(i.removeCls("color-"+n.colors[u].color),i.addCls("color-"+e[o].color),i.applyStyles({background:"#"+e[o].color}),i.down("span").applyStyles({background:"#"+e[o].color})),n.colors[u].effectId!==e[o].effectId&&i.set({effectid:e[o].effectId}),n.colors[u].effectValue!==e[o].effectValue&&i.set({effectvalue:e[o].effectValue}),n.colors[u]=e[o],o++}this.updateColorsArr=undefined},updateCustomColors:function(){var e=this.getEl();if(e){var t=localStorage["asc."+window.storagename+".colors.custom"];t=t?t.split(","):[];var n=-1,r,i=t.length<this.dyncolorscount?t.length:this.dyncolorscount;while(++n<i)r=e.down(".color-dynamic-"+n),r.removeCls("dynamic-empty-color").dom.setAttribute("color",t[n]),r.down("span").setStyle("background-color","#"+t[n]).setStyle("border","none")}},_saveCustomColor:function(e){var t=localStorage["asc."+window.storagename+".colors.custom"];t=t?t.split(","):[],t.push(e)>this.dyncolorscount&&t.shift(),localStorage["asc."+window.storagename+".colors.custom"]=t.join().toUpperCase()},_menuBeforeShow:function(){this.updateCustomColors()}}),Ext.define("Common.component.SplitColorButton",{extend:"Ext.button.Split",alias:"widget.cmdsplitcolorbutton",color:"FF0000",colorHeight:4,verticalOffset:0,horizontalOffset:0,initComponent:function(){this.addEvents("changecolor"),this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this.on({disable:function(e,t){if(this.getEl()){var n=this.getEl().down(".x-btn-color");n&&n.applyStyles({"background-color":"#9c9c9c"})}},enable:function(e,t){var n=this.getEl().down(".x-btn-color");n&&n.applyStyles({"background-color":this.color=="transparent"?this.color:"#"+this.color})}},this);var e=this.getEl().down("button");if(e){Ext.DomHelper.append(e,{tag:"span",cls:"x-btn-color"});var t=e.child(".x-btn-color");t.applyStyles({position:"absolute",left:this.verticalOffset+"px",top:e.getHeight()-this.colorHeight-this.horizontalOffset+"px","background-color":"#"+this.color}),this.isDisabled()&&t.applyStyles({"background-color":"#9c9c9c"}),t.setSize(e.getWidth()-2*this.verticalOffset,this.colorHeight)}},setColor:function(e,t){this.color=e;var n=this.getEl().down(".x-btn-color");n&&(this.isDisabled()?n.applyStyles({"background-color":"#9c9c9c"}):n.applyStyles({"background-color":this.color=="transparent"?this.color:"#"+this.color})),t!==!1&&this.fireEvent("changecolor",this,e)},getColor:function(){return this.color||null}}),Ext.define("Common.component.SynchronizeTip",{extend:"Ext.container.Container",alias:"widget.commonsynchronizetip",cls:"asc-synchronizetip",requires:["Ext.button.Button","Ext.form.Label"],layout:{type:"vbox",align:"stretch"},width:240,height:95,hideMode:"visibility",constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this;e.addEvents("dontshowclick"),e.addEvents("closeclick");var t=Ext.widget("button",{cls:"btn-close-tip",iconCls:"icon-close-tip",listeners:{click:function(){e.fireEvent("closeclick",e)}}});e.items=[{xtype:"container",html:'<div class="tip-arrow"></div>'},{xtype:"container",flex:1,style:"padding-left: 15px;",layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",flex:1,style:"margin-top: 15px;line-height: 1.2;",html:"<div>"+e.textSynchronize+"</div>"},t]},{xtype:"container",cls:"show-link",items:[{xtype:"label",text:e.textDontShow,listeners:{afterrender:function(t){t.getEl().on("click",function(t,n){e.fireEvent("dontshowclick",e)})},scope:this}}]}],e.callParent(arguments)},textDontShow:"Don't show this message again",textSynchronize:"The document has changed. <br/>Refresh the document to see the updates."}),Ext.define("Common.component.ComboDataView",{extend:"Ext.container.Container",requires:["Ext.data.Model","Ext.data.Store","Ext.view.View","Ext.XTemplate"],alias:"widget.commoncombodataview",padding:4,itemWidth:80,itemHeight:40,menuHeight:100,menuMaxHeight:500,minWidth:150,emptyComboText:"No styles",handleGlobalResize:!1,constructor:function(e){if(!e||!e.viewData||!e.itemWidth||!e.itemHeight)throw Error("ComboDataView creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig),n=0,r=0,i=0,s=0,o=0,u=0,a=!0,f=Ext.util.CSS.getRule(".storage-combodataview");f&&(n=parseInt(f.style.borderWidth),isNaN(n)&&(n=0)),Ext.define("DataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]});var l=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:Ext.isDefined(t.store)?t.store.model:"DataModel",data:t.viewData}),c=Ext.isDefined(t.dataTpl)?t.dataTpl:Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="{imageUrl}" width="'+e.itemWidth+'" height="'+e.itemHeight+'"/>','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>");this.dataMenu=Ext.widget("cmdmenudataviewpicker",{width:e.width,height:e.menuHeight,cls:"x-dataview-combo-menu",viewData:t.viewData,dataTpl:t.dataTpl,store:t.store,itemWidth:e.itemWidth,itemHeight:e.itemHeight,constrain:!1,pickerpadding:e.padding-1,listeners:{hide:function(t,n){e.fireEvent("menuhide",e,t)}}});var h=Ext.widget("dataview",{store:l,tpl:c,singleSelect:!0,trackOver:!0,style:"overflow:auto",overItemCls:"x-item-over",itemSelector:"div.thumb-wrap",emptyText:'<div class="emptyText">'+e.emptyComboText+"</div>",deferEmptyText:!1,cls:"x-view-context",listeners:{itemclick:function(n,r,i,s,o,u){t.repeatedselect&&n.getSelectionModel().getLastSelected()!==null&&n.getSelectionModel().getLastSelected().id==r.id&&e.fireEvent("select",e,r)},afterrender:Ext.bind(function(e,t){l.getCount()>0&&(e.select(l.getAt(0)),this.dataMenu.picker.selectByIndex(0))},this),beforecontainerclick:function(e,t,n){return!1},itemdblclick:function(t,n,r,i,s,o){e.fireEvent("releasecapture",e)}}}),p=Ext.widget("container",{flex:1,height:e.height-2*(e.padding+n),items:[h]}),d=Ext.widget("button",{cls:"x-btn-combodataview",height:e.height-2*(e.padding+n),handler:Ext.bind(function(t,r){a&&e.getDataViewCSSRules();var i=Math.floor(e.getEl().getWidth()/(e.itemWidth+s+o)),f=e.dataMenu.picker.store.getCount(),l=Math.ceil(f/i);if(l>1){var c=l*(e.itemHeight+2*u+s+o)+6,h=Math.min(e.menuMaxHeight,Ext.Element.getViewportHeight()-this.getPosition()[1]-6);c>h&&(c=h),e.dataMenu.show(),e.dataMenu.setSize(e.getEl().getWidth(),c),e.dataMenu.showBy(p,"tl-tl",[-e.padding+n,-e.padding+n])}},this)});this.fillComboView=function(t,n,r){if(Ext.isDefined(t)){var i=e.dataMenu.picker.store;if(i){if(r||l.find("uid",t.data.uid)<0){a&&e.getDataViewCSSRules(),l.removeAll();var u=i.indexOf(t),f=i.getCount(),c=Math.floor(p.getWidth()/(e.itemWidth+s+o)),d=[];p.getHeight()/e.itemHeight>2&&(c*=Math.floor(p.getHeight()/e.itemHeight));if(u<0)return;u=Math.floor(u/c)*c;for(var v=u,m=0;v<f&&m<c;v++,m++){var g=i.getAt(v),y={};for(var b=0;b<g.fields.length;b++)y[g.fields.items[b].name]=g.data[g.fields.items[b].name];d.push(y)}l.add(d)}if(n){var w=l.find("uid",t.data.uid);w>-1&&h.select(l.getAt(w),!1,!0)}}}},this.selectByIndex=function(t){t<0&&h.getSelectionModel().deselectAll(!1),e.dataMenu.picker.selectByIndex(t,!1)};var v=function(t,n){e.fillComboView(n,!0),n&&e.fireEvent("select",e,n)},m=function(t,n,r){var i=n[0];i&&(e.dataMenu.picker.selectByIndex(e.dataMenu.picker.store.findExact("uid",i.get("uid")),!1),e.fireEvent("select",e,i))},g=function(t,n,r){e.fillComboView(r[0],!0)},y=function(t,n){if(e.dataMenu){e.dataMenu.setWidth(t),e.dataMenu.hide();var r=e.dataMenu.picker;if(r){var i=r.getSelectedRec();e.fillComboView(i||r.store.getAt(0),!!i,!0)}}};e.handleGlobalResize?(e.on("afterrender",function(e){var t=e.getEl().down(".x-box-inner");t&&t.addCls("combodataview-auto-width")},this),Ext.EventManager.onWindowResize(function(){var t=e.getEl();t&&(e.doLayout(),y(t.getWidth()))},this)):e.on("resize",function(e,t,n){y(t,n)},this),this.dataMenu.addListener("select",v,e),this.dataMenu.picker.addListener("selectionchange",g,e),h.addListener("selectionchange",m,e),e.addEvents("select","menuhide","releasecapture"),e.addListener("afterrender",function(){Ext.util.CSS.refreshCache();var t=Ext.util.CSS.getRule(".x-dataview-combo-menu .storage-data-view .thumb-wrap");t&&(s=parseInt(t.style.paddingLeft),isNaN(s)&&(s=0),o=parseInt(t.style.paddingRight),isNaN(o)&&(o=0),u=parseInt(t.style.marginRight),isNaN(u)&&(u=0),a=!1),Ext.defer(function(){e.dataMenu.showAt([-1e4,-1e4]),e.fireEvent("releasecapture",e)},100)},this),e.getDataViewCSSRules=function(){if(e.dataMenu.picker.getEl()){var t=e.dataMenu.picker.getEl().down(".thumb-wrap");t&&(s=parseInt(t.getStyle("paddingLeft")),isNaN(s)&&(s=0),o=parseInt(t.getStyle("paddingRight")),isNaN(o)&&(o=0),u=parseInt(t.getStyle("marginRight")),isNaN(u)&&(u=0),a=!1)}},Ext.apply(e,{layout:{type:"hbox",align:"stretch"},cls:"storage-combodataview",items:[p,d]},t),this.callParent(arguments)}}),Ext.define("Common.component.MultiSliderGradient",{extend:"Ext.slider.Multi",requires:[],uses:[],alias:"widget.cmdmultislidergradient",cls:"asc-multi-slider-gradient",values:[0,100],increment:1,minValue:0,maxValue:100,clickRange:[1,20],colorValues:["#000000","#ffffff"],currentThumb:0,initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);if(e.initialConfig.listeners&&e.initialConfig.listeners.change){var n=e.initialConfig.listeners.change;e.initialConfig.listeners.change=function(t,r,i){e.changeGradientStyle(),n.call(e,t,r,i)}}this.styleStr="",Ext.isChrome&&Ext.chromeVersion<10||Ext.isSafari&&Ext.safariVersion<5.1?this.styleStr="-webkit-gradient(linear, left top, right top, color-stop({1}%,{0}), color-stop({3}%,{2})); /* Chrome,Safari4+ */":Ext.isChrome||Ext.isSafari?this.styleStr="-webkit-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isGecko?this.styleStr="-moz-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isOpera&&Ext.operaVersion>11?this.styleStr="-o-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isIE&&(this.styleStr="-ms-linear-gradient(left, {0} {1}%, {2} {3}%)"),this.callParent(arguments),this.addEvents("thumbclick"),this.addEvents("thumbdblclick")},listeners:{afterrender:function(e){var t=this,n="";if(t.thumbs){for(var r=0;r<t.thumbs.length;r++)t.thumbs[r]&&t.thumbs[r].tracker&&(t.thumbs[r].tracker.addListener("mousedown",Ext.bind(t.setActiveThumb,t,[r,!0]),t),t.thumbs[r].tracker.el.addListener("dblclick",function(){t.fireEvent("thumbdblclick",t)},t));t.setActiveThumb(0),t.innerEl&&(Ext.isEmpty(t.styleStr)||(n=Ext.String.format(t.styleStr,t.colorValues[0],0,t.colorValues[1],100),t.innerEl.setStyle("background",n)),Ext.isIE&&(n=Ext.String.format("progid:DXImageTransform.Microsoft.gradient( startColorstr={0}, endColorstr={1},GradientType=1 )",t.colorValues[0],t.colorValues[1]),t.innerEl.setStyle("filter",n)),n=Ext.String.format("linear-gradient(to right, {0} {1}%, {2} {3}%)",t.colorValues[0],0,t.colorValues[1],100),t.innerEl.setStyle("background",n))}}},setActiveThumb:function(e,t){this.currentThumb=e,this.thumbs[e].el.addCls("active-thumb");for(var n=0;n<this.thumbs.length;n++){if(e==n)continue;this.thumbs[n].el.removeCls("active-thumb")}t&&this.fireEvent("thumbclick",this,e)},setColorValue:function(e,t){var n=t!==undefined?t:this.currentThumb;this.colorValues[n]=e,this.changeGradientStyle()},getColorValue:function(e){var t=e!==undefined?e:this.currentThumb;return this.colorValues[t]},changeGradientStyle:function(){if(this.innerEl){var e;Ext.isEmpty(this.styleStr)||(e=Ext.String.format(this.styleStr,this.colorValues[0],this.getValue(0),this.colorValues[1],this.getValue(1)),this.innerEl.setStyle("background",e)),Ext.isIE&&(e=Ext.String.format("progid:DXImageTransform.Microsoft.gradient( startColorstr={0}, endColorstr={1},GradientType=1 )",this.colorValues[0],this.colorValues[1]),this.innerEl.setStyle("filter",e)),e=Ext.String.format("linear-gradient(to right, {0} {1}%, {2} {3}%)",this.colorValues[0],this.getValue(0),this.colorValues[1],this.getValue(1)),this.innerEl.setStyle("background",e)}},getNearest:function(e,t){var n=this,r=t=="top"?n.innerEl.getHeight()-e[t]:e[t],i=n.reverseValue(r),s=n.maxValue-n.minValue+5,o=0,u=null,a=n.thumbs,f=0,l=a.length,c,h,p;for(;f<l;f++){c=n.thumbs[f],h=c.value,p=Math.abs(h-i);if(Math.abs(p<=s)){if(n.constrainThumbs){var d=n.thumbs[f+1],v=n.thumbs[f-1];if(v!==undefined&&i<v.value)continue;if(d!==undefined&&i>d.value)continue}u=c,o=f,s=p}}return u}}),Ext.define("Common.view.CopyWarning",{extend:"Ext.window.Window",alias:"widget.commoncopywarning",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,constrain:!0,plain:!0,width:410,height:270,layout:{type:"border"},onEsc:function(){this.close()},initComponent:function(){this.items=[{xtype:"container",region:"center",layout:{type:"vbox",align:"center"},items:[{xtype:"box",padding:"15px 0 0 0",html:'<p style="font-size: 14pt; text-align: center;font-family: Arial;">'+this.textTitle+"</p><br>"+'<p style="height:52px; text-align: center; font-size: 8pt; font-family: Arial; color: #636363;padding: 10px 30px 0 30px;">'+this.textMsg+"</p>"},{xtype:"container",width:300,height:70,padding:"15px 0 0 0",layout:{type:"hbox",align:"stretch"},defaults:{xtype:"container",width:"50%"},items:[{layout:{type:"vbox",align:"center"},items:[{xtype:"box",html:'<p style="text-align: center; font-size: 18pt;font-family: Arial;">Ctrl+C</p><p style="text-align: center;font-family: Arial;">'+this.textToCopy+"</p>"}]},{style:"left: 50%;",layout:{type:"vbox",align:"center"},items:[{xtype:"box",html:'<p style="text-align: center; font-size: 18pt;font-family: Arial;">Ctrl+V</p><p style="text-align: center;font-family: Arial;">'+this.textToPaste+"</p>"}]}]}]},{xtype:"container",region:"south",height:58,style:"border-top: 1px solid #E5E5E5",padding:"16px 0 0 0",layout:{type:"vbox",align:"center"},items:[{xtype:"button",cls:"asc-blue-button",width:85,text:Ext.Msg.buttonText.ok,handler:Ext.bind(function(e){this.close()},this)}]}],this.callParent(arguments)},textTitle:"ONLYOFFICE Docs Copy & Paste Functions",textMsg:"For the security reasons the right-click menu copy and paste functions are disabled. You can still do the same using your keyboard:",textToCopy:"to copy",textToPaste:"to paste"}),Ext.define("Common.view.ImageFromUrlDialog",{extend:"Ext.window.Window",alias:"widget.commonimagefromurldialog",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,plain:!0,height:114,width:350,padding:"20px",layout:"vbox",layoutConfig:{align:"stretch"},listeners:{show:function(){this.txtUrl.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=Ext.create("Ext.Button",{id:"imgdialog-button-ok",text:this.okButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){if(!this.txtUrl.isValid())return;this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{id:"imgdialog-button-cancel",text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}});this.txtUrl=Ext.create("Ext.form.Text",{id:"imgdialog-text-url",width:310,msgTarget:"side",validateOnBlur:!1,allowBlank:!1,value:"",blankText:this.txtEmpty,regex:/(((^https?)|(^ftp)):\/\/([\-\wа-яё]+\.)+[\wа-яё]{2,3}(\/[%\-\wа-яё]+(\.[\wа-яё]{2,})?)*(([\wа-яё\-\.\?\\\/+@&#;`~=%!]*)(\.[\wа-яё]{2,})?)*\/?)/i,regexText:this.txtNotUrl,listeners:{specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.textUrl,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.txtUrl,{xtype:"tbspacer",height:3},{xtype:"container",width:310,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},e,{xtype:"tbspacer",width:5},t]}],this.callParent(arguments)},textUrl:"Paste an image URL:",cancelButtonText:"Cancel",okButtonText:"Ok",txtEmpty:"This field is required",txtNotUrl:'This field should be a URL in the format "http://www.example.com"'}),Ext.define("Common.view.ComboFonts",{extend:"Ext.form.field.ComboBox",alias:"widget.commoncombofonts",queryMode:"local",matchFieldWidth:!1,displayField:"name",showlastused:!1,constructor:function(e){var t=this,n=302,r=FONT_THUMBNAIL_HEIGHT;this.addEvents("createpicker");var i=document.createElement("canvas");i.height=r,i.width=n;var s=i.getContext("2d"),o=Ext.create("Ext.XTemplate",'<tpl for=".">','<a class="font-item" style="display: block;">','<img id="{[Ext.id()]}" src="{[this.getImageUri(values)]}" width="{[this.getImageWidth()]}" height="{[this.getImageHeight()]}" style="vertical-align: middle;margin: 0 0 0 -10px;">',"</a>","</tpl>",{getImageUri:function(e){return e.cloneid?t.picker.listEl.down("#"+e.cloneid).dom.src:(s.clearRect(0,0,n,r),s.drawImage(t.spriteThumbs,0,-FONT_THUMBNAIL_HEIGHT*e.imgidx),i.toDataURL())},getImageWidth:function(){return n},getImageHeight:function(){return r}});return Ext.apply(e,{listConfig:{id:"combo-fonts-list",emptyText:"no fonts found",mode:"local",width:326,maxHeight:468,height:468,minHeight:150,itemTpl:o,blockRefresh:!0,listeners:{viewready:function(e){t.spriteThumbs=undefined}}}}),this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.addListener("beforequery",this._beforeQuery,this),this.callParent(arguments)},onRender:function(e){this.callParent(arguments),this.el.set({"data-qtip":this.tooltip}),this.validate()},createPicker:function(){return this.callParent(arguments),this.showlastused&&this.fireEvent("createpicker",this,this.picker),this.picker},fillFonts:function(e,t){this._loadSprite(),this.getStore().loadData(e);if(t&&this.getStore().getCount()){var n=this.getStore().findRecord("name","Arial");n?this.select(n):this.select(this.getStore().getAt(0))}},_loadSprite:function(){var e=this;e.spriteThumbs=new Image,e.spriteThumbs.src=window.g_standart_fonts_thumbnail},_beforeQuery:function(e){e.forceAll=!0,e.cancel=!0;if(e.combo){e.combo.expand();var t=e.combo.getPicker(),n=e.combo.store.find("name",e.query);if(n<0)$("#"+t.id+" ."+t.overItemCls).removeClass(t.overItemCls);else{var r=t.getNode(e.combo.store.getAt(n));if(r){t.highlightItem(r);var i=t.listEl.getHeight()/2-30,s=t.listEl.getTop(),o=Ext.get(r).getY()-s-i;if(Math.abs(o)>i){var u=$("#"+t.listEl.id).data("jsp");u&&u.scrollByY(o,!0)}}}}}}),Ext.define("Common.view.AbstractSettingsPanel",{extend:"Ext.panel.Panel",alias:"widget.commonabstractsettingspanel",bodyPadding:"0 0 0 15px",preventHeader:!0,constructor:function(e){return this.controls=[],this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=this;this.initialHeight=this.height,e.callParent(arguments)},SuspendEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].suspendEvents(!1)},ResumeEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].resumeEvents()}}),Ext.define("Common.model.Font",{extend:"Ext.data.Model",fields:["id","name","cloneid",{type:"int",name:"imgidx"},{type:"int",name:"type"}]}),Ext.define("Common.store.Fonts",{extend:"Ext.data.Store",model:"Common.model.Font"});var FONT_TYPE_USERUSED=4;Ext.define("Common.controller.Fonts",{extend:"Ext.app.Controller",views:["ComboFonts"],refs:[{ref:"combo",selector:"commoncombofonts"}],stores:["Common.store.Fonts"],init:function(){this.control({commoncombofonts:{expand:function(e){var t=this.getCombo(),n=t.getPlugin("scrollpane");if(n)var r=new Ext.util.DelayedTask(function(){var e=t.picker.getNode(t.lastSelection[0]);e&&n.scrollToElement(e,!1,!1)});r.delay(10)},select:this._selectitem}})},setApi:function(e){this.api=e,this.api.asc_registerCallback("asc_onInitEditorFonts",Ext.bind(this._onloadfonts,this)),this.api.asc_registerCallback("asc_onFontFamily",Ext.bind(this._onfontchange,this))},_isfontsaved:function(e,t){var n=t.get("type")==FONT_TYPE_USERUSED,r=-1,i=e.getCount(),s,o=t.get("name");while(!n&&++r<i){s=e.getAt(r);if(s.get("type")!=FONT_TYPE_USERUSED)break;n=s.get("name")==o}return n},_selectitem:function(e,t,n){if(e.showlastused&&!this._isfontsaved(e.getStore(),t[0])){var r=e.picker.getNode(t[0]),i=t[0].data,s={id:i.id,name:i.name,imgidx:i.imgidx,cloneid:r.querySelector("img").id,type:FONT_TYPE_USERUSED};e.getStore().insert(0,[s]);var o=e.picker.getEl().down(".used-fonts-separator");o||(o=document.createElement("div"),o.setAttribute("class","x-menu-item-separator used-fonts-separator"),o.setAttribute("style","padding:0 10px;margin-left: 10px;"),r=e.picker.getNode(e.getStore().getAt(1)),r.parentNode.insertBefore(o,r)),s=e.getStore().getAt(5);if(s.data.type==FONT_TYPE_USERUSED)e.getStore().remove(s);else{var u=e.getPlugin("scrollpane");u&&u.updateScrollPane()}}},_onfontchange:function(e){var t=this.getCombo(),n=e.get_Name(),r=t.store.findRecord("name",n,0,!1,!1,!0);t.clearValue(),r?t.select(r):t.setRawValue(n)},_onloadfonts:function(e,t){var n=[];Ext.each(e,function(e){n.push({id:e.asc_getFontId(),name:e.asc_getFontName(),imgidx:e.asc_getFontThumbnail(),type:e.asc_getFontType()})});var r=this.getCombo();r?r.fillFonts(n,t):this.fontscash=n,window.required_downloads--},loadFonts:function(e){if(this.api){var t=this.api.get_PropertyEditorFonts();t&&this._onloadfonts(t,e)}},fillFonts:function(e){var t=this.getCombo();t&&t.rendered&&this.fontscash&&(t.fillFonts(this.fontscash,e),delete this.fontscash)}}),Ext.define("Common.model.Group",{extend:"Ext.data.Model",fields:["group","groupname"],proxy:{type:"memory"},hasMany:{model:"Common.model.GroupItem",name:"getGroupItems"}}),Ext.define("Common.model.GroupItem",{extend:"Ext.data.Model",fields:["group","groupitem","iconcls"],proxy:{type:"memory"},belongsTo:{model:"Common.model.Group",name:"group"}}),Ext.define("Common.component.GroupedDataView",{extend:"Ext.DataView",alias:"widget.cmdgroupeddataview",requires:["Common.model.GroupItem","Common.model.Group","Ext.XTemplate"],selModel:{enableKeyNav:!1},tpl:new Ext.XTemplate('<tpl for=".">','<div class="asc-grouped-data">','<div class="group-description">','<span class="description-text">{[values[this.fieldGroupName]]}</span>',"</div>",'<div class="group-items-container">','<tpl for="getGroupItems">','<div class="group-item">','<span class="{iconcls}"></span>',"</div>","</tpl>","</div>","</div>",'<div class="asc-grouped-data-selector"></div>',"</tpl>",{compiled:!0,fieldGroupName:"groupname"}),itemSelector:"div.group-item",trackOver:!0,overItemCls:"group-item-over",cls:"grouped-data-view",listeners:{beforecontainerclick:function(e,t,n){return!1},viewready:function(){this.delayedSelection&&(this.getSelectionModel().doSingleSelect(this.delayedSelection),this.delayedSelection=undefined)}},constructor:function(e){return e.selModel&&(e.selModel.enableKeyNav=!1),this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.callParent(arguments)},updateIndexes:function(e,t){var n=this.all.elements,r=[],i;this.store.each(function(e,t,n){Ext.Array.insert(r,r.length,e.getGroupItems().getRange())}),e=e||0,t=t||(t===0?0:n.length-1);for(i=e;i<=t;i++)n[i].viewIndex=i,n[i].viewRecordId=r[i].internalId,n[i].boundView||(n[i].boundView=this.id)},getRecord:function(e){var t,n,r=-1,i=this.store.getCount();while(!t&&++r<i)n=this.store.getAt(r),n&&(t=n.getGroupItems().data.getByKey(Ext.getDom(e).viewRecordId));return t},onRender:function(e){this.callParent(arguments);var t=this;t.el.set({tabIndex:-1}),t.keyNav=Ext.create("Ext.util.KeyNav",t.el,{down:Ext.pass(t.onNavKey,[1,1],t),right:Ext.pass(t.onNavKey,[1,null],t),left:Ext.pass(t.onNavKey,[-1,null],t),up:Ext.pass(t.onNavKey,[-1,-1],t),scope:t})},onNavKey:function(e,t){e=e||1;var n=this.getSelectionModel().getSelection()[0],r=this.all.elements.length,i;if(n){if(t){var s=this.getIndexInStore(n);e=this.getShiftedStep(s,t)}i=this.indexOf(this.getNode(n))+e}else i=0;i<0?i=r-1:i>=r&&(i=0);var o=this.getRecord(this.all.elements[i]);this.getSelectionModel().doSingleSelect(o)},getIndexInStore:function(e){var t=[],n,r,i=-1,s=this.store.getCount();while(++i<s){n=this.store.getAt(i),r=n.getGroupItems().indexOf(e);if(!(r<0)){t=[i,r,n.getGroupItems().getCount()];break}}return t},getShiftedStep:function(e,t){var n=e[0]+t;n<0?n=this.store.getCount()-1:n<this.store.getCount()||(n=0);var r=this.store.getAt(n);if(t>0){var i=e[1]<r.getGroupItems().getCount()?e[1]:r.getGroupItems().getCount()-1;i+=e[2]-e[1]}else i=e[1]<r.getGroupItems().getCount()?e[1]-r.getGroupItems().getCount():-1,i-=e[1];return i},refresh:function(){this.callParent(arguments)},selectGroupItem:function(e,t){var n=this.store.findRecord("group",e);return n&&(n=n.getGroupItems().findRecord("groupitem",t),this.rendered?n&&this.getSelectionModel().doSingleSelect(n):this.delayedSelection=n),n},getSelected:function(){return this.delayedSelection||this.getSelectionModel().getSelection()[0]}}),Ext.define("SSE.model.Formula",{extend:"Ext.data.Model",fields:[{name:"group"},{name:"func"},{name:"args"}]}),Ext.define("SSE.model.TableTemplate",{extend:"Ext.data.Model",fields:["type","name","imageUrl"]}),Ext.define("SSE.model.ShapeModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"data"}]}),Ext.define("SSE.model.ShapeGroup",{extend:"Ext.data.Model",fields:[{name:"groupName"},{name:"groupId"},{name:"groupStore"}]}),Ext.define("SSE.store.Formulas",{extend:"Ext.data.Store",model:"SSE.model.Formula",sorters:["func"]}),Ext.define("SSE.store.FormulaGroups",{extend:"Ext.data.ArrayStore",storeId:"groupStore",idIndex:0,fields:["groupname","groupid"]}),Ext.define("SSE.store.TableTemplates",{extend:"Ext.data.Store",model:"SSE.model.TableTemplate"}),Ext.define("SSE.store.ShapeGroups",{extend:"Ext.data.Store",model:"SSE.model.ShapeGroup"}),Ext.define("SSE.view.FormulaDialog",{extend:"Ext.window.Window",alias:"widget.sseformuladialog",requires:["Ext.window.Window","Common.plugin.GridScrollPane"],modal:!0,closable:!0,resizable:!1,height:490,width:300,constrain:!0,padding:"10px 20px 0 20px",layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=Ext.create("SSE.store.FormulaGroups");this.cmbGroup=Ext.create("Ext.form.field.ComboBox",{id:"formulas-group-combo",store:e,displayField:"groupname",queryMode:"local",queryDelay:1e3,typeAhead:!1,editable:!1,listeners:{select:function(e,t,n){},specialkey:function(e,t){!e.isExpanded&&t.getKey()==Ext.EventObject.ESC&&(this.fireEvent("onmodalresult",this,0),this.hide())},scope:this}}),Ext.create("SSE.store.Formulas",{storeId:"appFormulasStore"});var t=Ext.create("Ext.grid.Panel",{activeItem:0,id:"formulas-list",store:Ext.data.StoreManager.lookup("appFormulasStore"),stateful:!0,stateId:"stateGrid",scroll:!1,columns:[{flex:1,sortable:!1,dataIndex:"func"}],height:250,hideHeaders:!0,viewConfig:{stripeRows:!1},plugins:[{pluginId:"scrollpane",ptype:"gridscrollpane"}],listeners:{itemdblclick:function(e,t,n,r,i,s){this.btnOk.fireEvent("click",this.btnOk)},select:function(e,t,r,i){n.setText("Syntax: "+t.data.func+t.data.args)},viewready:function(e){e.getView().on("cellkeydown",function(e,t,n,r,i,s,o){if(o.getKey()==Ext.EventObject.ESC)return this.fireEvent("onmodalresult",this,0),this.hide(),!1},this)},scope:this}}),n=Ext.widget("label",{});this.items=[{xtype:"container",layout:{type:"vbox",align:"stretch"},height:57,width:260,items:[{xtype:"label",text:this.textGroupDescription,style:"font-weight: bold;margin:0 0 4px 0;"},this.cmbGroup]},{xtype:"container",layout:{type:"vbox",align:"stretch"},height:277,width:260,items:[{xtype:"label",text:this.textListDescription,style:"font-weight:bold;margin:0 0 4px 0;"},t]},{xtype:"container",layout:{type:"vbox",align:"stretch"},height:56,items:[n]},{xtype:"tbspacer",height:8,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{id:"formulas-button-ok",cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,t.getSelectionModel().selected.items[0].data.func)},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.hide()},scope:this}})]}]}],this.listeners={show:function(){}},this.callParent(arguments),this.setTitle(this.txtTitle)},setGroups:function(e){var t={Cube:this.sCategoryCube,Database:this.sCategoryDatabase,DateAndTime:this.sCategoryDateTime,Engineering:this.sCategoryEngineering,Financial:this.sCategoryFinancial,Information:this.sCategoryInformation,Logical:this.sCategoryLogical,LookupAndReference:this.sCategoryLookupAndReference,Mathematic:this.sCategoryMathematics,Statistical:this.sCategoryStatistical,TextAndData:this.sCategoryTextData},n=[[this.sCategoryAll,"all"]];Ext.each(e,function(e){n.push([t[e],e])}),this.cmbGroup.getStore().removeAll(!0),this.cmbGroup.getStore().loadData(n),this.cmbGroup.select(this.cmbGroup.getStore().getAt(0))},cancelButtonText:"Cancel",okButtonText:"Ok",sCategoryAll:"All",sCategoryLogical:"Logical",sCategoryCube:"Cube",sCategoryDatabase:"Database",sCategoryDateTime:"Date and time",sCategoryEngineering:"Engineering",sCategoryFinancial:"Financial",sCategoryInformation:"Information",sCategoryLookupAndReference:"LookupAndReference",sCategoryMathematics:"Math and trigonometry",sCategoryStatistical:"Statistical",sCategoryTextData:"Text and data",textGroupDescription:"Select Function Group",textListDescription:"Select Function",sDescription:"Description",txtTitle:"Insert Function"}),Ext.define("SSE.view.SetValueDialog",{extend:"Ext.window.Window",alias:"widget.setvaluedialog",requires:["Ext.window.Window","Ext.window.MessageBox"],modal:!0,resizable:!1,plain:!0,height:138,width:222,padding:"20px",layout:{type:"vbox",align:"stretch"},listeners:{show:function(){this.udRetValue.focus(!1,500)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.items=[{xtype:"container",height:42,layout:{type:"hbox",align:"stretch"},items:[this.udRetValue=Ext.widget("numberfield",{minValue:0,maxValue:e.maxvalue,value:e.startvalue,step:1,flex:1,allowDecimals:!0,validateOnBlur:!1,msgTarget:"side",minText:this.txtMinText,maxText:this.txtMaxText,listeners:{specialkey:function(t,n){n.getKey()==n.ENTER?e.btnOk.fireEvent("click"):n.getKey()==n.ESC&&e.btnCancel.fireEvent("click")}}})]},{xtype:"container",height:30,layout:{type:"vbox",align:"center"},items:[{xtype:"container",width:182,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(t){e.udRetValue.isValid()&&(e.fireEvent("onmodalresult",e,1,e.udRetValue.value),e.close())}}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(t){e.fireEvent("onmodalresult",this,0),e.close()}}})]}]}],this.callParent(arguments)},cancelButtonText:"Cancel",okButtonText:"Ok",txtMinText:"The minimum value for this field is {0}",txtMaxText:"The maximum value for this field is {0}"}),Ext.define("SSE.view.SheetCopyDialog",{extend:"Ext.window.Window",alias:"widget.ssesheetcopydialog",requires:["Ext.window.Window","Common.plugin.GridScrollPane"],modal:!0,closable:!0,resizable:!1,plain:!0,height:300,width:280,padding:"20px",layout:"vbox",constrain:!0,layoutConfig:{align:"stretch"},listeners:{show:function(){this.sheetList.getSelectionModel().select(0)}},initComponent:function(){var e=this,t=Ext.create("Ext.Button",{id:"wscopydialog-button-ok",text:Ext.Msg.buttonText.ok,width:80,cls:"asc-blue-button",listeners:{click:function(){e._modalresult=1,e.fireEvent("onmodalresult",e,e._modalresult,e.sheetList.getSelectionModel().selected.items[0].data.sheetindex),e.close()}}}),n=Ext.create("Ext.Button",{id:"wscopydialog-button-cancel",text:e.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){e._modalresult=0,e.fireEvent("onmodalresult",this,this._modalresult),e.close()}}});Ext.define("worksheet",{extend:"Ext.data.Model",fields:[{type:"int",name:"sheetindex"},{type:"string",name:"name"}]}),this.sheetList=Ext.create("Ext.grid.Panel",{activeItem:0,id:"wscopydialog-sheetlist-list",scroll:!1,store:{model:"worksheet",data:this.names},columns:[{flex:1,sortable:!1,dataIndex:"name"}],plugins:[{ptype:"gridscrollpane"}],height:160,width:240,hideHeaders:!0,listeners:{itemdblclick:function(e,n,r,i,s,o){t.fireEvent("click",t)}}}),this.items=[{xtype:"label",text:this.listtitle||this.labelList,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:10},this.sheetList,{xtype:"tbspacer",height:14},{xtype:"container",width:240,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},t,{xtype:"tbspacer",width:5},n]}],this.callParent(arguments)},labelList:"Copy before sheet",cancelButtonText:"Cancel"}),Ext.define("SSE.view.SheetRenameDialog",{extend:"Ext.window.Window",alias:"widget.ssesheetrenamedialog",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,plain:!0,height:116,width:280,padding:"20px",layout:"vbox",constrain:!0,layoutConfig:{align:"stretch"},listeners:{show:function(){this.txtName.focus(!0,100)}},initComponent:function(){this.addEvents("onmodalresult");var e=this,t=function(t){var n=e.names.length;while(!(--n<0))if(e.names[n]==t)return n==e.renameindex?-255:!0;return!1},n=Ext.create("Ext.Button",{id:"wsrenamedialog-button-ok",text:Ext.Msg.buttonText.ok,width:80,cls:"asc-blue-button",listeners:{click:function(){if(!!e.txtName.isValid()){var n=t(e.txtName.getValue());n===!0?Ext.Msg.show({title:e.errTitle,msg:e.errNameExists,icon:Ext.Msg.ERROR,buttons:Ext.Msg.OK,fn:function(){e.txtName.focus(!0,500)}}):(e._modalresult=n==-255?0:1,e.fireEvent("onmodalresult",e,e._modalresult,e.txtName.getValue()),e.close())}}}}),r=Ext.create("Ext.Button",{id:"wsrenamedialog-button-cancel",text:e.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){e._modalresult=0,e.fireEvent("onmodalresult",e,e._modalresult),e.close()}}});this.txtName=Ext.create("Ext.form.Text",{id:"wsrenamedialog-text-wsname",width:240,msgTarget:"side",validateOnBlur:!1,allowBlank:!1,value:this.names[this.renameindex],enforceMaxLength:!0,maxLength:31,validator:function(t){return t.length>2&&t[0]=='"'&&t[t.length-1]=='"'?!0:/[:\\\/\*\?\[\]\']/.test(t)?e.errNameWrongChar:!0},listeners:{specialkey:function(e,t){t.getKey()==t.ENTER?n.fireEvent("click"):t.getKey()==t.ESC&&r.fireEvent("click")}}}),this.items=[{xtype:"label",text:this.labelSheetName,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:4},this.txtName,{xtype:"tbspacer",height:4},{xtype:"container",width:240,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},n,{xtype:"tbspacer",width:5},r]}],this.callParent(arguments)},labelSheetName:"Sheet Name",errTitle:"Error",errNameExists:"Worksheet with such name already exist.",errNameWrongChar:"A sheet name cannot contain characters: \\/*?[]:",cancelButtonText:"Cancel"}),Ext.define("SSE.view.PrintSettings",{extend:"Ext.window.Window",alias:"widget.sseprintsettings",requires:["Ext.window.Window","Ext.form.field.ComboBox","Ext.form.RadioGroup","Ext.Array","Common.component.MetricSpinner","Common.component.IndeterminateCheckBox"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:588,width:466,layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.cmbPaperSize=Ext.widget("combo",{store:Ext.create("Ext.data.Store",{fields:["description","size"],data:[{size:"215.9|279.4",description:"US Letter (21,59cm x 27,94cm)"},{size:"215.9|355.6",description:"US Legal (21,59cm x 35,56cm)"},{size:"210|297",description:"A4 (21cm x 29,7cm)"},{size:"148.1|209.9",description:"A5 (14,81cm x 20,99cm)"},{size:"176|250.1",description:"B5 (17,6cm x 25,01cm)"},{size:"104.8|241.3",description:"Envelope #10 (10,48cm x 24,13cm)"},{size:"110.1|220.1",description:"Envelope DL (11,01cm x 22,01cm)"},{size:"279.4|431.7",description:"Tabloid (27,94cm x 43,17cm)"},{size:"297|420.1",description:"A3 (29,7cm x 42,01cm)"},{size:"304.8|457.1",description:"Tabloid Oversize (30,48cm x 45,71cm)"},{size:"196.8|273",description:"ROC 16K (19,68cm x 27,3cm)"},{size:"119.9|234.9",description:"Envelope Choukei 3 (11,99cm x 23,49cm)"},{size:"330.2|482.5",description:"Super B/A3 (33,02cm x 48,25cm)"}]}),displayField:"description",valueField:"size",queryMode:"local",editable:!1,flex:1}),this.cmbPaperOrientation=Ext.widget("combo",{store:Ext.create("Ext.data.Store",{fields:["description","orient"],data:[{description:e.strPortrait,orient:c_oAscPageOrientation.PagePortrait},{description:e.strLandscape,orient:c_oAscPageOrientation.PageLandscape}]}),displayField:"description",valueField:"orient",queryMode:"local",editable:!1,width:115}),this.chPrintGrid=Ext.widget("cmdindeterminatecheckbox",{boxLabel:this.textPrintGrid}),this.chPrintRows=Ext.widget("cmdindeterminatecheckbox",{boxLabel:this.textPrintHeadings}),this.spnMarginLeft=Ext.create("Common.component.MetricSpinner",{readOnly:!1,maxValue:48.25,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",listeners:{change:Ext.bind(function(e,t,n,r){},this)}}),this.spnMarginRight=Ext.create("Common.component.MetricSpinner",{readOnly:!1,maxValue:48.25,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",listeners:{change:function(e,t,n,r){}}}),this.spnMarginTop=Ext.create("Common.component.MetricSpinner",{readOnly:!1,maxValue:48.25,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",listeners:{change:function(e,t,n,r){}}}),this.spnMarginBottom=Ext.create("Common.component.MetricSpinner",{readOnly:!1,maxValue:48.25,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",listeners:{change:function(e,t,n,r){}}}),this.items=[this.topCnt=Ext.widget("container",{height:490,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"18 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",padding:"0 10 0 0",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:80,padding:"0 10px 10px 0",items:[{xtype:"label",text:e.textPrintRange,style:"font-weight: bold;"}]},{height:62,items:[{xtype:"label",text:e.textPageSize,style:"font-weight: bold;"}]},{height:58,items:[{xtype:"label",text:e.textPageOrientation,style:"font-weight: bold;"}]},{height:124,items:[{xtype:"label",text:this.strMargins,style:"font-weight: bold;"}]},{height:68,items:[{xtype:"label",text:e.textLayout,style:"font-weight: bold;"}]},{height:70,items:[{xtype:"label",text:e.strPrint,style:"font-weight: bold;"}]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},{xtype:"container",padding:"18 0 0 10",width:280,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",height:70,padding:"0 10",layout:{type:"hbox",align:"middle"},items:[this.groupRange=Ext.widget("radiogroup",{id:"dialog-printoptions-grouprange",columns:1,width:280,vertical:!0,items:[{boxLabel:this.textCurrentSheet,name:"printrange",inputValue:c_oAscPrintType.ActiveSheets,checked:!0},{boxLabel:this.textAllSheets,name:"printrange",inputValue:c_oAscPrintType.EntireWorkbook},{boxLabel:this.textSelection,name:"printrange",inputValue:c_oAscPrintType.Selection}]})]},this._spacer.cloneConfig({style:"margin: 15px 0 10px 0;",height:6}),{xtype:"container",height:25,padding:"0 10",layout:{type:"hbox",align:"middle"},items:[this.cmbPaperSize]},this._spacer.cloneConfig({style:"margin: 17px 0 10px 0;",height:6}),{xtype:"container",height:25,padding:"0 10",layout:{type:"hbox",align:"middle"},items:[this.cmbPaperOrientation]},this._spacer.cloneConfig({style:"margin: 16px 0 4px 0;",height:6}),this.cntMargins=Ext.widget("container",{height:100,padding:"0 10",layout:{type:"hbox"},defaults:{xtype:"container",layout:{type:"vbox",align:"stretch"},height:100},items:[{flex:1,items:[{xtype:"label",width:"100%",text:e.strTop},{xtype:"tbspacer",height:3},this.spnMarginTop,{xtype:"tbspacer",height:12},{xtype:"label",width:"100%",text:e.strLeft},{xtype:"tbspacer",height:3},this.spnMarginLeft]},{xtype:"tbspacer",width:20},{flex:1,items:[{xtype:"label",text:e.strBottom,width:"100%"},{xtype:"tbspacer",height:3},this.spnMarginBottom,{xtype:"tbspacer",height:12},{xtype:"label",text:e.strRight,width:"100%"},{xtype:"tbspacer",height:3},this.spnMarginRight]}]}),this._spacer.cloneConfig({style:"margin: 14px 0 6px 0;",height:6}),this.cntLayout=Ext.widget("container",{height:45,padding:"0 10",layout:{type:"vbox",align:"stretch"},items:[this.groupLayout=Ext.widget("radiogroup",{columns:1,width:280,vertical:!0,items:[{boxLabel:this.textActualSize,name:"printlayout",inputValue:c_oAscLayoutPageType.ActualSize},{boxLabel:this.textFit,name:"printlayout",inputValue:c_oAscLayoutPageType.FitToWidth,checked:!0}]})]}),this._spacer.cloneConfig({style:"margin: 14px 0 8px 0;",height:6}),this.cntAdditional=Ext.widget("container",{height:65,padding:"0 10",layout:{type:"vbox",align:"stretch"},items:[this.chPrintGrid,this.chPrintRows]})]}]}),this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:466,height:24,style:"padding: 0 30px;",layout:{type:"hbox",align:"stretch"},items:[{xtype:"button",width:100,height:22,text:this.textHideDetails,listeners:{scope:this,click:this.handlerShowDetails}},this.btnOk=Ext.widget("button",{id:"dialog-print-options-ok",cls:"asc-blue-button",width:150,height:22,style:"margin:0 10px 0 60px;",text:this.btnPrint,listeners:{}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments),this.setTitle(this.textTitle)},afterRender:function(){this.callParent(arguments)},checkMargins:function(){if(this.cmbPaperOrientation.getValue()==c_oAscPageOrientation.PagePortrait)var e=/^\d{3}\.?\d*/.exec(this.cmbPaperSize.getValue()),t=/\d{3}\.?\d*$/.exec(this.cmbPaperSize.getValue());else t=/^\d{3}\.?\d*/.exec(this.cmbPaperSize.getValue()),e=/\d{3}\.?\d*$/.exec(this.cmbPaperSize.getValue());var n=Common.MetricSettings.fnRecalcToMM(this.spnMarginLeft.getNumberValue()),r=Common.MetricSettings.fnRecalcToMM(this.spnMarginRight.getNumberValue()),i=Common.MetricSettings.fnRecalcToMM(this.spnMarginTop.getNumberValue()),s=Common.MetricSettings.fnRecalcToMM(this.spnMarginBottom.getNumberValue());return n>e?"left":r>e-n?"right":i>t?"top":s>t-i?"bottom":null},handlerShowDetails:function(e){this.extended?(this.extended=!1,this.cntMargins.setDisabled(!1),this.cntLayout.setDisabled(!1),this.cntAdditional.setDisabled(!1),this.topCnt.setHeight(490),this.setHeight(588),e.setText(this.textHideDetails)):(this.extended=!0,this.cntMargins.setDisabled(!0),this.cntLayout.setDisabled(!0),this.cntAdditional.setDisabled(!0),this.topCnt.setHeight(218),this.setHeight(316),e.setText(this.textShowDetails))},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textTitle:"Print Settings",strLeft:"Left",strRight:"Right",strTop:"Top",strBottom:"Bottom",strPortrait:"Portrait",strLandscape:"Landscape",textPrintGrid:"Print Gridlines",textPrintHeadings:"Print Rows and Columns Headings",textPageSize:"Page Size",textPageOrientation:"Page Orientation",strMargins:"Margins",strPrint:"Print",btnPrint:"Save & Print",textPrintRange:"Print Range",textLayout:"Layout",textCurrentSheet:"Current Sheet",textAllSheets:"All Sheets",textSelection:"Selection",textActualSize:"Actual Size",textFit:"Fit to width",textShowDetails:"Show Details",cancelButtonText:"Cancel",textHideDetails:"Hide Details"}),Ext.define("SSE.view.HyperlinkSettings",{extend:"Ext.window.Window",alias:"widget.ssehyperlinksettings",requires:["Ext.window.Window","Ext.form.field.ComboBox","Ext.form.field.Text","Ext.Array"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:348,width:366,layout:{type:"vbox",align:"stretch"},listeners:{show:function(){this.contExtLink.isVisible()?this.txtLink.focus(!1,500):this.txtLinkText.focus(!1,500)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.cmbLinkType=Ext.widget("combo",{store:Ext.create("Ext.data.Store",{fields:["description","type"],data:[{type:c_oAscHyperlinkType.RangeLink,description:e.textInternalLink},{type:c_oAscHyperlinkType.WebLink,description:e.textExternalLink}]}),displayField:"description",valueField:"type",queryMode:"local",editable:!1,listeners:{change:function(t,n,r){var i=n==c_oAscHyperlinkType.RangeLink;e.contIntLink.setVisible(i),e.contExtLink.setVisible(!i)}}}),this.cmbSheets=Ext.widget("combo",{store:Ext.create("Ext.data.ArrayStore",{fields:["name"],data:this.sheets}),displayField:"name",queryMode:"local",editable:!1}),this.txtDataRange=Ext.widget("textfield",{allowBlank:!1,check:!1,blankText:e.txtEmpty,msgTarget:"side",validator:function(t){if(!this.check)return!0;var n=/^[A-Z]+[1-9]\d*:[A-Z]+[1-9]\d*$/.test(t);return!n&&(n=/^[A-Z]+[1-9]\d*$/.test(t)),n?($("#"+this.id+" input").css("color","black"),!0):($("#"+this.id+" input").css("color","red"),e.textInvalidRange)},listeners:{blur:function(e){this.check=!0,this.check=!this.validate()}}}),this.txtLink=Ext.widget("textfield",{allowBlank:!1,blankText:e.txtEmpty,emptyText:e.textEmptyLink,validateOnChange:!1,msgTarget:"side",regex:/(([\-\wа-яё]+\.)+[\wа-яё]{2,3}(\/[%\-\wа-яё]+(\.[\wа-яё]{2,})?)*(([\wа-яё\-\.\?\\\/+@&#;`~=%!]*)(\.[\wа-яё]{2,})?)*\/?)/i,regexText:e.txtNotUrl}),this.txtLinkText=Ext.widget("textfield",{allowBlank:!1,blankText:e.txtEmpty,msgTarget:"side",emptyText:e.textEmptyDesc}),this.txtLinkTip=Ext.widget("textfield",{emptyText:e.textEmptyTooltip}),this.label=Ext.widget("label",{width:"100%",margin:"0 0 3 0"}),this.contExtLink=Ext.widget("container",{height:44,layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.strLinkTo}),this.txtLink]}),this.contIntLink=Ext.widget("container",{height:44,hidden:!0,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.strSheet}),this.cmbSheets]},{xtype:"tbspacer",width:18},{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.strRange}),this.txtDataRange]}]}),this.items=[{xtype:"container",height:254,padding:"18",layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.textLinkType}),this.cmbLinkType,{xtype:"tbspacer",height:10},this.contExtLink,this.contIntLink,{xtype:"tbspacer",height:10},this.labelDisplay=this.label.cloneConfig({text:e.strDisplay}),this.txtLinkText,{xtype:"tbspacer",height:10},this.label.cloneConfig({text:e.textTipText}),this.txtLinkTip]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:Ext.Msg.buttonText.ok,listeners:{click:function(t){if(e.cmbLinkType.getValue()==c_oAscHyperlinkType.RangeLink){e.txtDataRange.check=!0;if(!e.txtDataRange.validate()){e.txtDataRange.focus(!0,500);return}}else if(!e.txtLink.isValid()){e.txtLink.focus(!0,500);return}if(!e.txtLinkText.isValid()){e.txtLinkText.focus(!0,500);return}this.fireEvent("onmodalresult",this,1),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:e.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments),this.setTitle(this.textTitle)},afterRender:function(){this.callParent(arguments)},setSettings:function(e,t,n){if(!e)this.cmbLinkType.select(this.cmbLinkType.getStore().getAt(1)),this.txtLinkText.setValue(t);else{var r=this.cmbLinkType.getStore().find("type",e.asc_getType());this.cmbLinkType.select(this.cmbLinkType.getStore().getAt(r)),e.asc_getType()==c_oAscHyperlinkType.RangeLink?(r=this.cmbSheets.getStore().find("name",e.asc_getSheet()),r<0||this.cmbSheets.select(this.cmbSheets.getStore().getAt(r)),this.txtDataRange.setValue(e.asc_getRange())):this.txtLink.setValue(e.asc_getHyperlinkUrl()),this.txtLinkText.setValue(e.asc_getText()),this.txtLinkTip.setValue(e.asc_getTooltip())}this.txtLinkText.setDisabled(n),this.labelDisplay.setDisabled(n)},getSettings:function(){var e=new Asc.asc_CHyperlink;e.asc_setType(this.cmbLinkType.getValue());if(this.cmbLinkType.getValue()==c_oAscHyperlinkType.RangeLink)e.asc_setSheet(this.cmbSheets.getValue()),e.asc_setRange(this.txtDataRange.getValue());else{var t=this.txtLink.getValue().replace(/^\s+|\s+$/g,"");/(((^https?)|(^ftp)):\/\/)/i.test(t)||(t="http://"+t),e.asc_setHyperlinkUrl(t)}return e.asc_setText(this.txtLinkText.isDisabled()?null:this.txtLinkText.getValue()),e.asc_setTooltip(this.txtLinkTip.getValue()),e},textTitle:"Hyperlink Settings",textInternalLink:"Internal Data Range",textExternalLink:"Web Link",textEmptyLink:"Enter link here",textEmptyDesc:"Enter caption here",textEmptyTooltip:"Enter tooltip here",strSheet:"Sheet",strRange:"Range",textLinkType:"Link Type",strDisplay:"Display",textTipText:"Screen Tip Text",strLinkTo:"Link To",txtEmpty:"This field is required",textInvalidRange:"ERROR! Invalid cells range",txtNotUrl:'This field should be a URL in the format "http://www.example.com"',cancelButtonText:"Cancel"}),Ext.define("SSE.view.Toolbar",{extend:"Ext.toolbar.Toolbar",alias:"widget.ssetoolbar",cls:"sse-toolbar",layout:{type:"hbox",align:"top"},height:70,minWidth:1175,requires:["Ext.data.Store","Common.plugin.ComboBoxScrollPane","Common.component.SplitColorButton","Common.component.ThemeColorPalette","Common.component.ComboDataView","Ext.window.MessageBox","Ext.Array","Ext.Button","Ext.XTemplate","Common.plugin.MenuExpand"],uses:["SSE.view.FormulaDialog","Common.component.SynchronizeTip","Common.component.MenuDataViewPicker"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.addEvents("editcomplete");var e=this;this.synchTooltip=undefined;var t=window.localStorage.getItem("sse-hide-synch");this.showSynchTip=!t||parseInt(t)!=1,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this.SchemeNames=[this.txtScheme1,this.txtScheme2,this.txtScheme3,this.txtScheme4,this.txtScheme5,this.txtScheme6,this.txtScheme7,this.txtScheme8,this.txtScheme9,this.txtScheme10,this.txtScheme11,this.txtScheme12,this.txtScheme13,this.txtScheme14,this.txtScheme15,this.txtScheme16,this.txtScheme17,this.txtScheme18,this.txtScheme19,this.txtScheme20,this.txtScheme21],this.ascFormatOptions={General:"General",Number:"0.00",Currency:"$#,##0.00",Accounting:'_($* #,##0.00_);_($* (#,##0.00);_($* "-"??_);_(@_)',DateShort:"m/d/yyyy",DateLong:"[$-F800]dddd, mmmm dd, yyyy",Time:"[$-F400]h:mm:ss AM/PM",Percentage:"0%",Fraction:"# ?/?",Scientific:"0.00E+00",Text:"@"},this.numFormatTypes={},this.numFormatTypes[c_oAscNumFormatType.General]=this.txtGeneral,this.numFormatTypes[c_oAscNumFormatType.Custom]="Custom",this.numFormatTypes[c_oAscNumFormatType.Text]=this.txtText,this.numFormatTypes[c_oAscNumFormatType.Number]=this.txtNumber,this.numFormatTypes[c_oAscNumFormatType.Integer]=this.txtInteger,this.numFormatTypes[c_oAscNumFormatType.Scientific]=this.txtScientific,this.numFormatTypes[c_oAscNumFormatType.Currency]=this.txtCurrency,this.numFormatTypes[c_oAscNumFormatType.Date]=this.txtDate,this.numFormatTypes[c_oAscNumFormatType.Time]=this.txtTime,this.numFormatTypes[c_oAscNumFormatType.Percent]=this.txtPercentage,this.numFormatTypes[c_oAscNumFormatType.Fraction]="Fraction",this.cmbFont=Ext.create("Common.view.ComboFonts",{id:"toolbar-combo-fonts",width:128,editable:!0,tooltip:this.tipFontName,enableKeyEvents:!0,showlastused:!0,plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]}),Ext.define("SSE.view.FontSize",{extend:"Ext.data.Model",fields:[{type:"int",name:"sizevalue"},{type:"string",name:"sizestring"}]});var n=Ext.create("Ext.data.Store",{model:"SSE.view.FontSize",data:[]});this.cmbFontSize=Ext.create("Ext.form.field.ComboBox",{id:"toolbar-combo-font-size",store:n,displayField:"sizestring",queryMode:"local",typeAhead:!1,selectOnFocus:!0,width:50,listConfig:{maxHeight:400}}),this.btnBold=Ext.create("Ext.Button",{tooltip:this.textBold+" (Ctrl+B)",iconCls:"asc-toolbar-btn btn-bold",enableToggle:!0,group:"simple-toggle",action:"Bold"}),this.btnItalic=Ext.create("Ext.Button",{tooltip:this.textItalic+" (Ctrl+I)",iconCls:"asc-toolbar-btn btn-italic",enableToggle:!0,group:"simple-toggle",action:"Italic"}),this.btnUnderline=Ext.create("Ext.Button",{tooltip:this.textUnderline+" (Ctrl+U)",iconCls:"asc-toolbar-btn btn-underline",enableToggle:!0,group:"simple-toggle",action:"Underline"}),this.btnPrint=Ext.create("Ext.button.Split",{tooltip:this.tipPrint+" (Ctrl+P)",iconCls:"asc-toolbar-btn btn-print",action:"Print",group:"simple-click"}),this.btnSave=Ext.create("Ext.Button",{tooltip:this.tipSave+" (Ctrl+S)",iconCls:"asc-toolbar-btn btn-save",group:"simple-click",action:"Save"}),this.btnCopy=Ext.create("Ext.Button",{tooltip:this.tipCopy,iconCls:"asc-toolbar-btn btn-copy",group:"copy-paste",action:"copy"}),this.btnPaste=Ext.create("Ext.Button",{tooltip:this.tipPaste,iconCls:"asc-toolbar-btn btn-paste",group:"copy-paste",action:"paste"}),this.btnUndo=Ext.create("Ext.Button",{tooltip:this.tipUndo+" (Ctrl+Z)",iconCls:"asc-toolbar-btn btn-undo",disabled:!0,group:"simple-click",action:"Undo"}),this.btnRedo=Ext.create("Ext.Button",{tooltip:this.tipRedo+" (Ctrl+Y)",iconCls:"asc-toolbar-btn btn-redo",disabled:!0,group:"simple-click",action:"Redo"}),this.btnFontColor=Ext.widget("cmdsplitcolorbutton",{id:"toolbar-button-font-color",iconCls:"asc-toolbar-btn btn-fontcolor",tooltip:this.tipFontColor,color:"ff0000",horizontalOffset:3,verticalOffset:2,listeners:{click:function(t){e.colorsText.fireEvent("select",e.colorsText,e.colorsText.currentColor)}}}),this.btnHorizontalAlign=Ext.create("Ext.button.Button",{id:"toolbar-button-halign",tooltip:this.tipHAligh,iconCls:"asc-toolbar-btn btn-halign",cls:"halign-left",icls:"halign-left",split:!0}),this.btnVerticalAlign=Ext.create("Ext.button.Button",{id:"toolbar-button-valign",tooltip:this.tipVAligh,iconCls:"asc-toolbar-btn btn-vertalign",cls:"valign-bottom",icls:"valign-bottom",split:!0}),this.btnWrap=Ext.create("Ext.Button",{tooltip:this.tipWrap,iconCls:"asc-toolbar-btn btn-wrap",enableToggle:!0,group:"simple-toggle",action:"Wrap"}),this.btnParagraphColor=Ext.widget("cmdsplitcolorbutton",{id:"toolbar-button-paragraph-color",iconCls:"asc-toolbar-btn btn-fillparag",tooltip:this.tipPrColor,horizontalOffset:3,verticalOffset:2,color:"ffff00",listeners:{changecolor:function(t,n){e.fireEvent("editcomplete",e)},click:function(t){e.colorsBack.fireEvent("select",e.colorsBack,e.colorsBack.currentColor)}}}),this.btnClearStyle=Ext.create("Ext.button.Button",{id:"toolbar-button-clear",tooltip:this.tipClearStyle,iconCls:"asc-toolbar-btn btn-clearstyle",split:!0}),this.btnMerge=Ext.create("Ext.button.Split",{id:"toolbar-button-merge",tooltip:this.tipMerge,iconCls:"asc-toolbar-btn btn-merge",enableToggle:!0,handler:function(e){e.menu.fireEvent("click",e.menu,e.menu.items.items[0])}}),this.btnInsertFormula=Ext.create("Ext.button.Split",{id:"toolbar-button-insertformula",tooltip:this.txtFormula,iconCls:"asc-toolbar-btn btn-formula"}),this.btnDecDecimal=Ext.create("Ext.button.Button",{tooltip:this.tipDecDecimal,iconCls:"asc-toolbar-btn btn-decdecimal",group:"simple-click",action:"Decrement"}),this.btnIncDecimal=Ext.create("Ext.button.Button",{tooltip:this.tipIncDecimal,iconCls:"asc-toolbar-btn btn-incdecimal",group:"simple-click",action:"Increment"}),this.btnNumberFormat=Ext.create("Ext.button.Button",{id:"toolbar-button-num-format",tooltip:this.tipNumFormat,text:this.txtGeneral,width:100,style:"border-color:#B9B9B9;",split:!0}),this.btnBorders=Ext.create("Ext.button.Split",{id:"toolbar-button-borders",tooltip:this.tipBorders,iconCls:"asc-toolbar-btn btn-borders",icls:"borders-noborders",cls:"borders-noborders",borderswidth:"thin"}),this.btnInsertImage=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-image",tooltip:this.tipInsertImage,iconCls:"asc-toolbar-btn btn-insertimage",split:!0}),this.btnInsertHyperlink=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-hyperlink",tooltip:this.tipInsertHyperlink+" (Ctrl+K)",iconCls:"asc-toolbar-btn btn-inserthyperlink"}),this.btnAutofilter=Ext.create("Ext.button.Button",{tooltip:this.tipAutofilter,iconCls:"asc-toolbar-btn btn-autofilter",split:!0}),this.btnColorSchemas=Ext.create("Ext.button.Button",{id:"toolbar-button-color-schemas",tooltip:this.tipColorSchemas,iconCls:"asc-toolbar-btn btn-colorschemas",menu:{showSeparator:!1,id:"toolbar-menu-color-schemas",items:[]}}),this.btnNewDocument=Ext.create("Ext.Button",{id:"toolbar-button-newdocument",tooltip:this.tipNewDocument,iconCls:"asc-toolbar-btn btn-newdocument"}),this.btnOpenDocument=Ext.create("Ext.Button",{id:"toolbar-button-opendocument",tooltip:this.tipOpenDocument,iconCls:"asc-toolbar-btn btn-opendocument"}),this.btnInsertText=Ext.create("Ext.Button",{id:"toolbar-button-inserttext",tooltip:this.tipInsertText,iconCls:"asc-toolbar-btn btn-inserttext",enableToggle:!0}),this.btnInsertShape=Ext.create("Ext.Button",{id:"toolbar-button-insertshape",tooltip:this.tipInsertShape,iconCls:"asc-toolbar-btn btn-insertshape",enableToggle:!0,menu:{showSeparator:!1,id:"toolbar-menu-insertshape",items:[],plugins:[{ptype:"menuexpand"}]}}),this.btnIncFontSize=Ext.create("Ext.Button",{tooltip:this.tipIncFont,iconCls:"asc-toolbar-btn btn-incfont",group:"font-size",action:"inc"}),this.btnDecFontSize=Ext.create("Ext.Button",{tooltip:this.tipDecFont,iconCls:"asc-toolbar-btn btn-decfont",group:"font-size",action:"dec"}),this.btnPercentStyle=Ext.create("Ext.Button",{tooltip:this.tipDigStylePercent,iconCls:"asc-toolbar-btn btn-percent-style",action:"number-format",formatId:this.ascFormatOptions.Percentage}),this.btnCurrencyStyle=Ext.create("Ext.Button",{tooltip:this.tipDigStyleCurrency,iconCls:"asc-toolbar-btn btn-currency-style",action:"number-format",formatId:this.ascFormatOptions.Currency}),this.btnZoomIn=Ext.widget("button",{id:"toolbar-menu-zoomin",cls:"asc-toolbar-btn-zoom",iconCls:"asc-statusbar-btn btn-zoomin"}),this.btnZoomOut=Ext.widget("button",{id:"toolbar-menu-zoomout",cls:"asc-toolbar-btn-zoom",iconCls:"asc-statusbar-btn btn-zoomout"}),this.txtZoom=Ext.widget("label",{id:"toolbar-menu-zoom-text",text:"100%",style:"white-space:nowrap; text-align: center;"}),this.btnShowMode=Ext.create("Ext.Button",{tooltip:this.tipViewSettings,iconCls:"asc-toolbar-btn btn-showmode",menu:{}}),this.btnSettings=Ext.create("Ext.Button",{id:"toolbar-button-settings",tooltip:this.tipAdvSettings,iconCls:"asc-toolbar-btn btn-settings"}),this.btnTextOrient=Ext.create("Ext.Button",{tooltip:this.tipTextOrientation,iconCls:"asc-toolbar-btn btn-textorient",menu:{}}),this.btnAddCell=Ext.create("Ext.Button",{tooltip:this.tipInsertOpt,iconCls:"asc-toolbar-btn btn-addcell",menu:{}}),this.btnDeleteCell=Ext.create("Ext.Button",{tooltip:this.tipDeleteOpt,iconCls:"asc-toolbar-btn btn-delcell",menu:{}}),this.btnAlignLeft=Ext.create("Ext.Button",{tooltip:this.tipAlignLeft,enableToggle:!0,toggleGroup:"alignGroup",allowDepress:!1,iconCls:"asc-toolbar-btn btn-halign",cls:"halign-left"}),this.btnAlignCenter=Ext.create("Ext.Button",{tooltip:this.tipAlignCenter,enableToggle:!0,toggleGroup:"alignGroup",iconCls:"asc-toolbar-btn btn-halign",cls:"halign-center"}),this.btnAlignRight=Ext.create("Ext.Button",{tooltip:this.tipAlignRight,enableToggle:!0,toggleGroup:"alignGroup",iconCls:"asc-toolbar-btn btn-halign",cls:"halign-right"}),this.btnAlignJust=Ext.create("Ext.button.Button",{tooltip:this.tipAlignJust,enableToggle:!0,toggleGroup:"alignGroup",iconCls:"asc-toolbar-btn btn-halign",cls:"halign-just"}),this.btnAlignTop=Ext.create("Ext.button.Button",{tooltip:this.tipAlignTop,enableToggle:!0,toggleGroup:"vAlignGroup",iconCls:"asc-toolbar-btn btn-vertalign",cls:"valign-top"}),this.btnAlignMiddle=Ext.create("Ext.button.Button",{tooltip:this.tipAlignMiddle,enableToggle:!0,toggleGroup:"vAlignGroup",iconCls:"asc-toolbar-btn btn-vertalign",cls:"valign-middle"}),this.btnAlignBottom=Ext.create("Ext.button.Button",{tooltip:this.tipAlignBottom,enableToggle:!0,toggleGroup:"vAlignGroup",allowDepress:!1,iconCls:"asc-toolbar-btn btn-vertalign",cls:"valign-bottom"}),this.btnSortDown=Ext.create("Ext.button.Button",{tooltip:this.txtSortAZ,group:"sort",direction:"ascending",iconCls:"asc-toolbar-btn btn-sort-down"}),this.btnSortUp=Ext.create("Ext.button.Button",{tooltip:this.txtSortZA,group:"sort",direction:"descending",iconCls:"asc-toolbar-btn btn-sort-up"});var r=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="main-thumb">','<div class="thumb-wrap" style="height:50px;">','<img src="{imageUrl}" />',"</div>","</div>","</tpl>");this.btnTableTemplate=Ext.create("Ext.button.Button",{tooltip:this.txtTableTemplate,iconCls:"asc-toolbar-btn btn-ttempl",menu:Ext.create("Common.component.MenuDataViewPicker",{action:"table-templates",width:330,height:320,dataTpl:r,cls:"table-templates-picker",store:Ext.getStore("TableTemplates"),viewData:[],contentWidth:310})}),this.btnSetAutofilter=Ext.create("Ext.button.Button",{tooltip:this.txtFilter,iconCls:"asc-toolbar-btn btn-autofilter",group:"simple-click",action:"Filter"}),this.listStyles=Ext.create("Common.component.ComboDataView",{id:"toolbar-combo-viewstyles",height:54,flex:1,itemWidth:80,itemHeight:18,menuMaxHeight:300,minWidth:110,repeatedselect:!0,handleGlobalResize:!0,viewData:[]}),this.coauthControls=[this.cmbFont,this.cmbFontSize,this.btnIncFontSize,this.btnDecFontSize,this.btnBold,this.btnItalic,this.btnUnderline,this.btnHorizontalAlign,this.btnAlignLeft,this.btnAlignCenter,this.btnAlignRight,this.btnAlignJust,this.btnVerticalAlign,this.btnAlignTop,this.btnAlignMiddle,this.btnAlignBottom,this.btnWrap,this.btnTextOrient,this.btnClearStyle,this.btnMerge,this.btnInsertFormula,this.btnIncDecimal,this.btnInsertShape,this.btnInsertText,this.btnSortUp,this.btnSortDown,this.btnSetAutofilter,this.btnTableTemplate,this.btnPercentStyle,this.btnCurrencyStyle,this.btnDecDecimal,this.btnAddCell,this.btnDeleteCell,this.btnNumberFormat,this.btnBorders,this.btnInsertImage,this.btnInsertHyperlink,this.btnColorSchemas,this.btnAutofilter,this.listStyles];var i=function(e,t,n,r){return Ext.String.format('<div class="toolbar-btn-placeholder x-btn-default-toolbar-small-icon x-btn-default-toolbar-small document-loading{3}" id="{0}" style="{2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"",r?" "+r:"")},s=function(e,t,n,r){return Ext.String.format('<div class="toolbar-btn-placeholder x-btn-default-toolbar-small-icon x-btn-default-toolbar-small document-loading x-btn-split x-btn-split-right{3}" id="{0}" style="width: 34px; {2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"",r?" "+r:"")},o=function(e,t){return Ext.String.format('<div class="x-toolbar-separator x-toolbar-item x-toolbar-separator-horizontal manual {0}" style="{1}" role="presentation" tabindex="-1"></div>',e,t||"")},u=function(e,t,n){return Ext.String.format('<div id="{0}" class="x-container storage-combodataview x-container-default x-box-layout-ct toolbar-combo-placeholder x-item-disabled" role="presentation" tabindex="-1" style="{2}"><div class="x-trigger-index-0 x-form-trigger x-form-arrow-trigger x-form-trigger-last x-unselectable" role="button"></div>{1}</div>',e,t||"",n||"")},a=function(e,t,n){return Ext.String.format('<div id="{0}" class="x-container storage-combodataview x-container-default x-box-layout-ct toolbar-dataview-placeholder x-item-disabled" role="presentation" tabindex="-1" style="{1}"><div class="x-btn x-btn-combodataview x-box-item x-btn-default-small" style="height: 44px; margin: 0; top: 4px;"></div></div>',e,n||"")};this.isCompactView=!!JSON.parse(localStorage.getItem("sse-toolbar-compact")),this.setHeight(this.isCompactView?38:68),this.html=['<div id="id-toolbar-short" style="'+(this.isCompactView?"display: table;":"display: none;")+'width: 100%; height: 22px; margin-top: 3px;" >','<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-short-btn-print","btn-print","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-save","btn-save"),"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-short-btn-undo","btn-undo","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-redo","btn-redo"),"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="width: 190px; margin-top: 2px;">',u("id-toolbar-short-field-fontname","Calibri","display: inline; float: left; line-height: 20px; padding: 0; width: 127px; height: 22px; margin-right: 4px;"),u("id-toolbar-short-field-fontsize","11","display: inline; float: left; padding: 0; line-height: 20px; width: 49px; height: 22px; margin-right: 2px;"),"</div>","</div>",'<div class="toolbar-group" style="padding-left: 0">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-bold","btn-bold","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-italic","btn-italic","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-underline","btn-underline"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group" style="padding-left: 0">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-fontcolor","btn-fontcolor","margin: 0 4px 0 7px;"),s("id-toolbar-short-btn-highlight","btn-fillparag"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-borders","btn-borders","margin:0","borders-noborders"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-halign","btn-halign","margin: 0 2px 0 0;","halign-left"),s("id-toolbar-short-btn-valign","btn-vertalign","margin: 0 2px 0 0;","valign-bottom"),s("id-toolbar-short-btn-merge","btn-merge","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-wrap","btn-wrap"),"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-insertimage","btn-insertimage","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-inserthyperlink","btn-inserthyperlink","margin: 0 4px 0 0;"),s("id-toolbar-short-btn-insertshape","btn-insertshape","margin: 0;"),i("id-toolbar-short-btn-text","btn-inserttext","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-filter","btn-autofilter"),"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-digit-dec","btn-decdecimal","margin: 0 5px 0 0;"),i("id-toolbar-short-btn-digit-inc","btn-incdecimal","margin: 0 5px 0 0;"),'<div id="id-toolbar-short-btn-format" class="toolbar-btn-placeholder x-btn-default-toolbar-small-noicon x-btn-default-toolbar-small document-loading x-btn-split x-btn-split-right" style="width:100px;border-color:#B9B9B9;"><span class="replaceme x-btn-inner" style="text-align:center;padding-right:0;">General</span></div>',"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-formula","btn-formula","margin: 0 5px 0 0;"),s("id-toolbar-short-btn-clear","btn-clearstyle"),"</div>","</div>",'<div class="toolbar-group separator">'+o("short")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-cell-ins","btn-addcell","margin: 0 5px 0 0;"),s("id-toolbar-short-btn-cell-del","btn-delcell"),"</div>","</div>",'<div class="toolbar-group" style="width: 100%;"></div>','<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',s("id-toolbar-short-btn-hidebars","btn-showmode","margin: 0 4px 0 0;"),"</div>","</div>","</div>",'<div id="id-toolbar-full" style="'+(this.isCompactView?"display: none;":"display: table;")+'width: 100%; margin-top: 3px;" >','<div class="toolbar-group" id="id-toolbar-full-group-native">','<div class="toolbar-row">',i("id-toolbar-full-btn-newdocument","btn-newdocument"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-opendocument","btn-opendocument"),"</div>","</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-print","btn-print"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-save","btn-save"),"</div>","</div>",'<div class="toolbar-group separator">'+o("long")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-copy","btn-copy","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-paste","btn-paste"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-undo","btn-undo","margin: 0 6px 0 0;"),i("id-toolbar-full-btn-redo","btn-redo"),"</div>","</div>",'<div class="toolbar-group separator">'+o("long")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="width:230px;">',u("id-toolbar-full-field-fontname","Calibri","display: inline; float: left; line-height: 20px; padding: 0; width: 127px; height: 22px; margin-right: 4px;"),u("id-toolbar-full-field-fontsize","11","display: inline; float: left; padding: 0; line-height: 20px; width: 49px; height: 22px; margin-right: 5px;"),i("id-toolbar-full-btn-incfont","btn-incfont"),i("id-toolbar-full-btn-decfont","btn-decfont","margin: 0 0 0 2px;"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-bold","btn-bold","margin: 0 4px 0 0;"),i("id-toolbar-full-btn-italic","btn-italic","margin: 0 4px 0 0;"),i("id-toolbar-full-btn-underline","btn-underline","margin: 0 7px 0 0;"),o("short","position: absolute; margin-top: 2px;"),s("id-toolbar-full-btn-fontcolor","btn-fontcolor","margin: 0 0 0 12px;"),s("id-toolbar-full-btn-highlight","btn-fillparag","margin: 0 12px 0 4px;"),o("short","position: absolute; margin-top: 2px;"),s("id-toolbar-full-btn-borders","btn-borders","margin: 0 0 0 11px;","borders-noborders"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-align-left","btn-halign","margin: 0 5px 0 0;","halign-left"),i("id-toolbar-full-btn-align-center","btn-halign","margin: 0 5px 0 0;","halign-center"),i("id-toolbar-full-btn-align-right","btn-halign","margin: 0 5px 0 0;","halign-right"),i("id-toolbar-full-btn-align-just","btn-halign","margin: 0 5px 0 0;","halign-just"),s("id-toolbar-full-btn-merge","btn-merge"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-align-top","btn-vertalign","margin: 0 5px 0 0;","valign-top"),i("id-toolbar-full-btn-align-middle","btn-vertalign","margin: 0 5px 0 0;","valign-middle"),i("id-toolbar-full-btn-align-bottom","btn-vertalign","margin: 0 5px 0 0;","valign-bottom"),i("id-toolbar-full-btn-wrap","btn-wrap","margin: 0 5px 0 0;"),s("id-toolbar-full-btn-text-orient","btn-textorient"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-insertimage","btn-insertimage","margin: 0 2px 0 0"),i("id-toolbar-full-btn-inserthyperlink","btn-inserthyperlink","margin: 0 6px 0 0"),"</div>",'<div class="toolbar-row">',s("id-toolbar-full-btn-insertshape","btn-insertshape","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-text","btn-inserttext","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">'+o("long")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-sortdesc","btn-sort-down","margin: 0 5px 0 0;","valign-top"),i("id-toolbar-full-btn-sortasc","btn-sort-up","margin: 0;","valign-top"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-setfilter","btn-autofilter","margin: 0 5px 0 0;"),s("id-toolbar-full-btn-table-tpl","btn-ttempl","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">','<div id="id-toolbar-full-btn-format" class="toolbar-btn-placeholder x-btn-default-toolbar-small-noicon x-btn-default-toolbar-small document-loading x-btn-split x-btn-split-right" style="width:100px;border-color:#B9B9B9;"><span class="replaceme x-btn-inner" style="text-align:center;padding-right:0;">General</span></div>',"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-percents","btn-percent-style","margin: 0 5px 0 0;"),i("id-toolbar-full-btn-currency","btn-currency-style","margin: 0 5px 0 0;"),i("id-toolbar-full-btn-digit-dec","btn-decdecimal","margin: 0 5px 0 0;"),i("id-toolbar-full-btn-digit-inc","btn-incdecimal","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-formula","btn-formula"),"</div>",'<div class="toolbar-row">',s("id-toolbar-full-btn-clear","btn-clearstyle"),"</div>","</div>",'<div class="toolbar-group separator">'+o("long")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-cell-ins","btn-addcell"),"</div>",'<div class="toolbar-row">',s("id-toolbar-full-btn-cell-del","btn-delcell"),"</div>","</div>",'<div class="toolbar-group separator">'+o("long")+"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-colorschemas","btn-colorschemas"),"</div>","</div>",'<div class="toolbar-group" id="id-toolbar-full-group-styles" style="width: 100%;">',a("id-toolbar-full-field-styles","","height: 54px;"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',s("id-toolbar-full-btn-hidebars","btn-showmode","margin: 0 5px 0 0;"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-settings","btn-settings"),"</div>","</div>","</div>"],this.callParent(arguments)},setApi:function(e){return this.api=e,this.api.asc_registerCallback("asc_onCollaborativeChanges",Ext.bind(this._onCollaborativeChanges,this)),this.api.asc_registerCallback("asc_onSendThemeColorSchemes",Ext.bind(this._onSendThemeColorSchemes,this)),this},parseColor:function(e){var t=/#([0-9,aA-fF]{3,6})|rgb\((\d{1,3}),\s?(\d{1,3}),\s?(\d{1,3})/.exec(e);return t&&t.length?(t=t[1]||Number(t[2]).toString(16)+Number(t[3]).toString(16)+Number(t[4]).toString(16),t.length<6&&(t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]),t.toUpperCase()):undefined},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},_onSendThemeColorSchemes:function(e){var t=this;t.btnColorSchemas.menu.removeAll();var n=Ext.create("Ext.XTemplate",'<a class="x-menu-item-link">','<span class="colors">','<tpl for="colors">','<span class="color" style="background: {color};"></span>',"</tpl>","</span>",'<span class="text">{text}</span>',"</a>");for(var r=0;r<e.length;r++){var i=e[r],s=i.get_colors(),o=[];for(var u=2;u<7;u++){var a="#"+this.getHexColor(s[u].get_r(),s[u].get_g(),s[u].get_b());o.push({color:a})}var f=Ext.create("Ext.menu.Item",{cls:"menu-item-noicon asc-color-schemas-menu",data:{text:r<21?t.SchemeNames[r]:i.get_name(),colors:o},tpl:n,schemaType:r,listeners:{click:Ext.bind(function(e){t.api&&(t.api.asc_ChangeColorScheme(e.schemaType),Common.component.Analytics.trackEvent("ToolBar","Color Scheme"))},this)}});r==21&&t.btnColorSchemas.menu.add(Ext.create("Ext.menu.Separator",{})),t.btnColorSchemas.menu.add(f)}},_onSendThemeColors:function(e,t){if(!this.colorsText||!this.colorsBack||!this.colorsBorder){this.themeColors={user:e,standart:t};return}var n=[];if(t)for(var r=0;r<t.length;r++){var i=this.getHexColor(t[r].get_r(),t[r].get_g(),t[r].get_b());n.push(i)}var s=[],o,u,a;for(r=0;r<6;r++)for(var f=0;f<10;f++){var l=r+f*6;i={color:this.getHexColor(e[l].get_r(),e[l].get_g(),e[l].get_b()),effectId:l,effectValue:this.ThemeValues[f]},s.push(i),typeof this.colorsText.currentColor=="object"&&o===undefined&&this.colorsText.currentColor.effectId==l&&(o=i),typeof this.colorsBack.currentColor=="object"&&u===undefined&&this.colorsBack.currentColor.effectId==l&&(u=i),typeof this.colorsBorder.currentColor=="object"&&a===undefined&&this.colorsBorder.currentColor.effectId==l&&(a=i)}this.colorsText.updateColors(s,n),this.colorsBack.updateColors(s,n),this.colorsBorder.updateColors(s,n),this.colorsText.currentColor===undefined?(this.btnFontColor.setColor(n[1],!1),this.colorsText.currentColor=n[1]):o!==undefined&&(this.btnFontColor.setColor(o.color,!1),this.colorsText.currentColor=o),this.colorsBack.currentColor===undefined?(this.btnParagraphColor.setColor(n[3],!1),this.colorsBack.currentColor=n[3]):u!==undefined&&(this.btnParagraphColor.setColor(u.color,!1),this.colorsBack.currentColor=u),this.colorsBorder.currentColor===undefined?this.colorsBorder.fireEvent("select",this.colorsBorder,s[1]):a!==undefined&&this.colorsBorder.fireEvent("select",this.colorsBorder,a)},setMode:function(e){if(e.isDisconnected)this.btnOpenDocument.setDisabled(!0),this.btnNewDocument.setDisabled(!0),this.btnSave.setDisabled(!0),this.btnPaste.setDisabled(!0),this.btnUndo.setDisabled(!0),this.btnRedo.setDisabled(!0),this.cmbFont.setDisabled(!0),this.cmbFontSize.setDisabled(!0),this.btnIncFontSize.setDisabled(!0),this.btnDecFontSize.setDisabled(!0),this.btnBold.setDisabled(!0),this.btnItalic.setDisabled(!0),this.btnUnderline.setDisabled(!0),this.btnFontColor.setDisabled(!0),this.btnParagraphColor.setDisabled(!0),this.btnBorders.setDisabled(!0),this.btnHorizontalAlign.setDisabled(!0),this.btnAlignLeft.setDisabled(!0),this.btnAlignCenter.setDisabled(!0),this.btnAlignRight.setDisabled(!0),this.btnAlignJust.setDisabled(!0),this.btnAlignTop.setDisabled(!0),this.btnAlignMiddle.setDisabled(!0),this.btnAlignBottom.setDisabled(!0),this.btnMerge.setDisabled(!0),this.btnWrap.setDisabled(!0),this.btnTextOrient.setDisabled(!0),this.btnInsertImage.setDisabled(!0),this.btnInsertHyperlink.setDisabled(!0),this.btnInsertShape.setDisabled(!0),this.btnInsertText.setDisabled(!0),this.btnSortDown.setDisabled(!0),this.btnSortUp.setDisabled(!0),this.btnSetAutofilter.setDisabled(!0),this.btnTableTemplate.setDisabled(!0),this.btnAutofilter.setDisabled(!0),this.btnNumberFormat.setDisabled(!0),this.btnPercentStyle.setDisabled(!0),this.btnCurrencyStyle.setDisabled(!0),this.btnIncDecimal.setDisabled(!0),this.btnDecDecimal.setDisabled(!0),this.btnInsertFormula.setDisabled(!0),this.btnClearStyle.setDisabled(!0),this.btnAddCell.setDisabled(!0),this.btnDeleteCell.setDisabled(!0),this.btnColorSchemas.setDisabled(!0),this.listStyles.setDisabled(!0);else{this.mode=e;if(!e.nativeApp){var t=Ext.get("id-toolbar-full-group-native");t&&(t.setVisibilityMode(Ext.Element.DISPLAY),t.hide())}}},_onCollaborativeChanges:function(){if(!this.btnSave.rendered){this.needShowSynchTip=!0;return}var e=this.btnSave.getEl().down(".asc-toolbar-btn");e.removeCls("btn-save"),e.addCls("btn-synch"),this.showSynchTip&&this.isVisible()?(this.btnSave.setTooltip(""),this.synchTooltip===undefined&&this._createSynchTip(),this.synchTooltip.show()):this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)")},_createSynchTip:function(){var e=this.btnSave.getPosition();e[0]+=this.btnSave.getWidth(),e[1]+=this.btnSave.getHeight()/2,this.synchTooltip=Ext.getBody().createChild({tag:"div",cls:"synch-tip-root",style:"top: "+e[1]+"px; left: "+e[0]+"px; width: 250px;"});if(this.synchTooltip){var t=Ext.widget("commonsynchronizetip",{renderTo:this.synchTooltip});t.getEl().alignTo(this.synchTooltip,"tl"),t.addListener("dontshowclick",function(){this.showSynchTip=!1,this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)"),window.localStorage.setItem("sse-hide-synch",1)},this),t.addListener("closeclick",function(){this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)")},this)}},synchronizeChanges:function(){var e=this.btnSave.getEl().down(".asc-toolbar-btn");e.hasCls("btn-synch")&&(e.removeCls("btn-synch"),e.addCls("btn-save"),this.synchTooltip&&this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSave+" (Ctrl+S)"))},rendererComponents:function(e){var t=this,n=function(e,t,n){var r=Ext.get(e);if(r&&!r.down("button")){r.removeCls(["x-btn-default-toolbar-small-icon","x-btn-default-toolbar-small-noicon","x-btn-default-toolbar-small","x-btn-disabled","x-btn-split","x-btn-split-right","document-loading","valign-bottom"]);var i=r.down("span");i&&i.remove(),t.addCls("x-btn-default-toolbar-small x-btn-default-toolbar-small-"+(n?"noicon ":"icon ")),t.rendered?r.dom.appendChild(document.getElementById(t.getId())):t.render(r),t.removeCls(["x-btn-default-small","x-btn-default-small-icon"])}},r=function(e,t){var n=Ext.get(e);if(n&&!n.down("input")){if(/toolbar-combo-placeholder|toolbar-dataview-placeholder/.test(n.dom.className))for(var r=n.dom.childNodes.length,i;r--;)i=n.dom.childNodes[r],i.parentNode.removeChild(i);n.removeCls(["x-container","storage-combodataview","x-container-default","x-box-layout-ct","toolbar-combo-placeholder","toolbar-dataview-placeholder","x-item-disabled"]),t.rendered?n.dom.appendChild(document.getElementById(t.getId())):t.render(n)}},i="full";switch(e){case"short":i="short"}n("id-toolbar-"+i+"-btn-newdocument",t.btnNewDocument),n("id-toolbar-"+i+"-btn-opendocument",t.btnOpenDocument),n("id-toolbar-"+i+"-btn-print",t.btnPrint),n("id-toolbar-"+i+"-btn-save",t.btnSave),n("id-toolbar-"+i+"-btn-copy",t.btnCopy),n("id-toolbar-"+i+"-btn-paste",t.btnPaste),n("id-toolbar-"+i+"-btn-undo",t.btnUndo),n("id-toolbar-"+i+"-btn-redo",t.btnRedo),n("id-toolbar-"+i+"-btn-incfont",t.btnIncFontSize),n("id-toolbar-"+i+"-btn-decfont",t.btnDecFontSize),n("id-toolbar-"+i+"-btn-bold",t.btnBold),n("id-toolbar-"+i+"-btn-italic",t.btnItalic),n("id-toolbar-"+i+"-btn-underline",t.btnUnderline),n("id-toolbar-"+i+"-btn-fontcolor",t.btnFontColor),n("id-toolbar-"+i+"-btn-highlight",t.btnParagraphColor),n("id-toolbar-"+i+"-btn-borders",t.btnBorders),n("id-toolbar-"+i+"-btn-align-left",t.btnAlignLeft),n("id-toolbar-"+i+"-btn-align-center",t.btnAlignCenter),n("id-toolbar-"+i+"-btn-align-right",t.btnAlignRight),n("id-toolbar-"+i+"-btn-align-just",t.btnAlignJust),n("id-toolbar-"+i+"-btn-halign",t.btnHorizontalAlign),n("id-toolbar-"+i+"-btn-merge",t.btnMerge),n("id-toolbar-"+i+"-btn-align-top",t.btnAlignTop),n("id-toolbar-"+i+"-btn-align-middle",t.btnAlignMiddle),n("id-toolbar-"+i+"-btn-align-bottom",t.btnAlignBottom),n("id-toolbar-"+i+"-btn-valign",t.btnVerticalAlign),n("id-toolbar-"+i+"-btn-wrap",t.btnWrap),n("id-toolbar-"+i+"-btn-text-orient",t.btnTextOrient),n("id-toolbar-"+i+"-btn-insertimage",t.btnInsertImage),n("id-toolbar-"+i+"-btn-inserthyperlink",t.btnInsertHyperlink),n("id-toolbar-"+i+"-btn-insertshape",t.btnInsertShape),n("id-toolbar-"+i+"-btn-text",t.btnInsertText),n("id-toolbar-"+i+"-btn-sortdesc",t.btnSortDown),n("id-toolbar-"+i+"-btn-sortasc",t.btnSortUp),n("id-toolbar-"+i+"-btn-setfilter",t.btnSetAutofilter),n("id-toolbar-"+i+"-btn-filter",t.btnAutofilter),n("id-toolbar-"+i+"-btn-table-tpl",t.btnTableTemplate),n("id-toolbar-"+i+"-btn-format",t.btnNumberFormat,!0),n("id-toolbar-"+i+"-btn-percents",t.btnPercentStyle),n("id-toolbar-"+i+"-btn-currency",t.btnCurrencyStyle),n("id-toolbar-"+i+"-btn-digit-dec",t.btnDecDecimal),n("id-toolbar-"+i+"-btn-digit-inc",t.btnIncDecimal),n("id-toolbar-"+i+"-btn-formula",t.btnInsertFormula),n("id-toolbar-"+i+"-btn-clear",t.btnClearStyle),n("id-toolbar-"+i+"-btn-cell-ins",t.btnAddCell),n("id-toolbar-"+i+"-btn-cell-del",t.btnDeleteCell),n("id-toolbar-"+i+"-btn-colorschemas",t.btnColorSchemas),n("id-toolbar-"+i+"-btn-settings",t.btnSettings),n("id-toolbar-"+i+"-btn-hidebars",t.btnShowMode),r("id-toolbar-"+i+"-field-fontname",t.cmbFont),r("id-toolbar-"+i+"-field-fontsize",t.cmbFontSize),r("id-toolbar-"+i+"-field-styles",t.listStyles)},createDelayedElements:function(){var e=[],t=this;t.rendererComponents(this.isCompactView?"short":"full"),this.btnPrint.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,items:[{text:t.textPrint,id:"toolbar-menuitem-print",cls:"menu-item-noicon"},{text:t.textPrintOptions,id:"toolbar-menuitem-print-options",cls:"menu-item-noicon"}]}),e.push(this.btnPrint),this.btnFontColor.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,items:[this.colorsText=Ext.create("Common.component.ThemeColorPalette",{id:"menu-palette-font-color",value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,currentColor:undefined,colors:[t.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",t.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(e,n,r,i){t.btnFontColor.setColor(typeof n=="object"?n.color:n),Ext.menu.Manager.hideAll(),t.colorsText.currentColor=n,t.api&&(t.btnFontColor.ischanged=!0,t.api.asc_setCellTextColor(t.getRgbColor(n)),t.btnFontColor.ischanged=!1),Common.component.Analytics.trackEvent("ToolBar","Text Color")}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(e,n){t.colorsText.addNewColor()}}}],listeners:{hide:function(){t.fireEvent("editcomplete",t,{checkorder:!0})}}}),e.push(this.btnFontColor),this.btnHorizontalAlign.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-horalign",showSeparator:!1,defaults:{cls:"toolbar-menu-icon-item",checked:!1,hideOnClick:!0},items:[{iconCls:"mnu-icon-item mnu-align-left",text:this.textAlignLeft,icls:"halign-left",halign:"left",checked:!0},{iconCls:"mnu-icon-item mnu-align-center",text:this.textAlignCenter,icls:"halign-center",halign:"center"},{iconCls:"mnu-icon-item mnu-align-right",text:this.textAlignRight,icls:"halign-right",halign:"right"},{iconCls:"mnu-icon-item mnu-align-just",text:this.textAlignJust,icls:"halign-just",halign:"justify"}]}),e.push(this.btnHorizontalAlign),this.btnVerticalAlign.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-vertalign",showSeparator:!1,defaults:{cls:"toolbar-menu-icon-item",group:"valignGroup",checked:!1},items:[{iconCls:"mnu-icon-item mnu-align-top",text:this.textAlignTop,icls:"valign-top",valign:"top",checked:!0},{iconCls:"mnu-icon-item mnu-align-middle",text:this.textAlignMiddle,icls:"valign-middle",valign:"center"},{iconCls:"mnu-icon-item mnu-align-bottom",text:this.textAlignBottom,icls:"valign-bottom",valign:"bottom"}]}),e.push(this.btnVerticalAlign),this.btnParagraphColor.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{id:"menu-palette-paragraph-color",value:"FF0000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,currentColor:undefined,colors:[t.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",t.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(e,n,r,i){t.btnParagraphColor.setColor(typeof n=="object"?n.color:n),Ext.menu.Manager.hideAll(),t.colorsBack.currentColor=n,t.api&&(t.btnParagraphColor.ischanged=!0,t.api.asc_setCellBackgroundColor(n=="transparent"?null:t.getRgbColor(n)),t.btnParagraphColor.ischanged=!1),Common.component.Analytics.trackEvent("ToolBar","Background Color")}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(e,n){t.colorsBack.addNewColor()}}}],listeners:{hide:function(){t.fireEvent("editcomplete",t)}}}),e.push(this.btnParagraphColor),this.btnClearStyle.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-clearstyle",width:90,minWidth:90,showSeparator:!1,defaults:{cls:"menu-item-noicon"},items:[{text:this.txtClearAll,action:c_oAscCleanOptions.All},{text:this.txtClearText,action:c_oAscCleanOptions.Text},{text:this.txtClearFormat,action:c_oAscCleanOptions.Format}]}),e.push(this.btnClearStyle),this.btnMerge.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-merge",showSeparator:!1,defaults:{cls:"menu-item-noicon"},items:[{text:this.txtMergeCenter,action:c_oAscMergeOptions.MergeCenter},{text:this.txtMergeAcross,action:c_oAscMergeOptions.MergeAcross},{text:this.txtMergeCells,action:c_oAscMergeOptions.Merge},{text:this.txtUnmerge,action:c_oAscMergeOptions.Unmerge}]}),e.push(this.btnMerge),this.btnInsertFormula.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-insertformula",width:100,minWidth:100,showSeparator:!1,defaults:{cls:"menu-item-noicon"},items:[{text:"SUM",func:"SUM"},{text:"MIN",func:"MIN"},{text:"MAX",func:"MAX"},{text:"COUNT",func:"COUNT"},{xtype:"menuseparator"},{text:this.txtAdditional,func:"more"}]}),e.push(this.btnInsertFormula);var n=Ext.create("Ext.XTemplate",'<tpl if="plain">{text}</tpl><tpl if="!plain"><a id="{id}-itemEl" class="'+Ext.baseCSSPrefix+'menu-item-link menu-item-datetime-format" href="{href}" hidefocus="true" unselectable="on">'+'<img id="{id}-iconEl" src="{icon}" class="'+Ext.baseCSSPrefix+'menu-item-icon {iconCls}" />'+'<div class="menu-item-format">{[this.getTText(values.text)]}<span class="'+Ext.baseCSSPrefix+'menu-item-text menu-item-description"">{[this.getDText(values.text)]}</span></div>'+"</a>"+"</tpl>",{getTText:function(e){return/^.*(?=\|)/.exec(e)||e},getDText:function(e){var t=/\|(.*)$/.exec(e);return t?t[1]:""}});this.btnNumberFormat.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,action:"number-format",defaults:{cls:"menu-item-noicon"},items:[{text:this.txtGeneral,formatId:this.ascFormatOptions.General},{text:this.txtNumber,formatId:this.ascFormatOptions.Number},{text:this.txtInteger,formatId:"#0"},{text:this.txtScientific,formatId:this.ascFormatOptions.Scientific},{text:this.txtCurrency,hideOnClick:!1,menu:{showSeparator:!1,action:"number-format",defaults:{cls:"menu-item-noicon"},items:[{text:this.txtDollar,formatId:this.ascFormatOptions.Currency},{text:this.txtEuro,formatId:"€#,##0.00"},{text:this.txtPound,formatId:"£#,##0.00"},{text:this.txtRouble,formatId:"#,##0.00р."},{text:this.txtYen,formatId:"¥#,##0.00"}],plugins:[{ptype:"menuexpand"}]}},{text:this.txtDate,hideOnClick:!1,menu:{showSeparator:!1,action:"number-format",defaults:{cls:"menu-item-noicon",renderTpl:n},items:[{text:"07-24-88 |MM-dd-yy",formatId:"MM-dd-yy"},{text:"07-24-1988 |MM-dd-yyyy",formatId:"MM-dd-yyyy"},{text:"24-07-88 |dd-MM-yy",formatId:"dd-MM-yy"},{text:"24-07-1988 |dd-MM-yyyy",formatId:"dd-MM-yyyy"},{text:"24-Jul-1988 |dd-MMM-yyyy",formatId:"dd-MMM-yyyy"},{text:"24-Jul |dd-MMM",formatId:"dd-MMM"},{text:"Jul-88 |MMM-yy",formatId:"MMM-yy",width:180}],plugins:[{ptype:"menuexpand"}]}},{text:this.txtTime,hideOnClick:!1,menu:{showSeparator:!1,action:"number-format",defaults:{cls:"menu-item-noicon",renderTpl:n},items:[{text:"10:56 |HH:mm",formatId:"HH:mm"},{text:"21:56:00 |HH:MM:ss",formatId:"HH:MM:ss"},{text:"05:56 AM |hh:mm tt",formatId:"hh:mm AM/PM"},{text:"05:56:00 AM |hh:mm:ss tt",formatId:"hh:mm:ss AM/PM",width:180},{text:"38:56:00 |[h]:mm:ss",formatId:"[h]:mm:ss"}],plugins:[{ptype:"menuexpand"}]}},{text:this.txtPercentage,formatId:this.ascFormatOptions.Percentage},{text:this.txtText,formatId:this.ascFormatOptions.Text}],plugins:[{ptype:"menuexpand"}]}),e.push(this.btnNumberFormat);var r=[{text:"1 pt",value:"thin",offsety:0,checked:!0},{text:"2.25 pt",value:"medium",offsety:20},{text:"3 pt",value:"thick",offsety:40}];for(u=0;u<r.length;u++)r[u].text+="|"+Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px;","resources/img/toolbar/BorderSize.png",-r[u].offsety);var i=Ext.create("Ext.XTemplate",'<tpl if="plain">{text}</tpl><tpl if="!plain"><a id="{id}-itemEl" class="'+Ext.baseCSSPrefix+'menu-item-link" href="{href}" hidefocus="true" unselectable="on" style="padding-left:16px;">'+'<img id="{id}-iconEl" src="{icon}" class="'+Ext.baseCSSPrefix+'menu-item-icon {iconCls}" style="margin-left:2px" />'+'<div><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="top" style="{[this.getSText(values.text)]}"/></div>'+"</a>"+"</tpl>",{getSText:function(e){var t=/\|(.*)$/.exec(e);return t?t[1]:""}});this.btnBorders.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-borders",showSeparator:!1,defaults:{cls:"toolbar-menu-icon-item"},items:[{iconCls:"mnu-icon-item mnu-border-out",text:this.textOutBorders,icls:"borders-outer",borderId:"outer"},{iconCls:"mnu-icon-item mnu-border-all",text:this.textAllBorders,icls:"borders-all",borderId:"all"},{iconCls:"mnu-icon-item mnu-border-top",text:this.textTopBorders,icls:"borders-top",borderId:c_oAscBorderOptions.Top},{iconCls:"mnu-icon-item mnu-border-bottom",text:this.textBottomBorders,icls:"borders-bottom",borderId:c_oAscBorderOptions.Bottom},{iconCls:"mnu-icon-item mnu-border-left",text:this.textLeftBorders,icls:"borders-left",borderId:c_oAscBorderOptions.Left},{iconCls:"mnu-icon-item mnu-border-right",text:this.textRightBorders,icls:"borders-right",borderId:c_oAscBorderOptions.Right},{iconCls:"mnu-icon-item mnu-border-no",icls:"borders-noborders",text:this.textNoBorders,borderId:"none"},{xtype:"menuseparator"},{iconCls:"mnu-icon-item mnu-border-center",icls:"borders-inside",text:this.textInsideBorders,borderId:"inner"},{iconCls:"mnu-icon-item mnu-border-vmiddle",text:this.textCenterBorders,icls:"borders-inver",borderId:c_oAscBorderOptions.InnerV},{iconCls:"mnu-icon-item mnu-border-hmiddle",text:this.textMiddleBorders,icls:"borders-inhor",borderId:c_oAscBorderOptions.InnerH},{xtype:"menuseparator"},{iconCls:"mnu-icon-item mnu-border-width",hideOnClick:!1,text:this.textBordersWidth,listeners:{},menu:{id:"toolbar-menu-borders-width",showSeparator:!1,defaults:{cls:"menu-item-border-size",group:"border-width",checked:!1,hideOnClick:!1,renderTpl:i},items:r,plugins:[{ptype:"menuexpand"}]}},{iconCls:"mnu-icon-item mnu-border-color",text:this.textBordersColor,hideOnClick:!1,renderTpl:Ext.create("Ext.XTemplate",'<tpl if="plain">{text}</tpl><tpl if="!plain"><a id="{id}-itemEl" class="'+Ext.baseCSSPrefix+'menu-item-link" href="{href}" <tpl if="hrefTarget">target="{hrefTarget}"</tpl> hidefocus="true" unselectable="on">'+'<div class="'+Ext.baseCSSPrefix+'menu-item-icon mnu-icon-item" style="background-image:none !important;">'+'<span id="{[this.iid]}" style="position:absolute;width:14px;height:14px;margin:3px 5px;border:2px solid #000;"></span>'+"</div>"+'<span id="{id}-textEl" class="'+Ext.baseCSSPrefix+'menu-item-text" <tpl if="menu">style="margin-right: 17px;"</tpl> >{text}</span>'+'<tpl if="menu"><img id="{id}-arrowEl" src="{blank}" class="'+Ext.baseCSSPrefix+'menu-item-arrow" /></tpl>'+"</a>"+"</tpl>",{iid:"picker-borders-color"}),menu:{showSeparator:!1,items:[t.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{id:"toolbar-menu-borders-color",value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,currentColor:undefined,colors:[t.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",t.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"]}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(e,n){t.colorsBorder.addNewColor()}}}]}}],plugins:[{ptype:"menuexpand"}]}),e.push(this.btnBorders),this.btnInsertImage.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-insertimage",showSeparator:!1,items:[{text:this.mniImageFromFile,cls:"menu-item-noicon",from:"file"},{text:this.mniImageFromUrl,cls:"menu-item-noicon",from:"url"}]}),e.push(this.btnInsertImage);var s=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="main-thumb">','<div class="thumb-wrap" style="height:50px;">','<img src="{imageUrl}" />',"</div>","</div>","</tpl>");this.btnAutofilter.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-autofilter",showSeparator:!1,defaults:{cls:"toolbar-menu-icon-item"},items:[{iconCls:"mnu-icon-item mnu-sort-asc",text:t.txtSortAZ,direction:"ascending"},{iconCls:"mnu-icon-item mnu-sort-desc",text:t.txtSortZA,direction:"descending"},{iconCls:"mnu-icon-item mnu-filter-add",text:t.txtFilter,hideOnClick:!0,action:"set-filter",checked:!1},{iconCls:"mnu-icon-item mnu-filter-clear",text:t.txtTableTemplate,hideOnClick:!1,menu:Ext.create("Common.component.MenuDataViewPicker",{action:"table-templates",width:330,height:320,dataTpl:s,cls:"table-templates-picker",store:Ext.getStore("TableTemplates"),viewData:[],contentWidth:310})}]}),e.push(this.btnAutofilter);var o={};JSON.parse(window.localStorage.getItem("sse-hidden-title"))&&(o.title=!0),JSON.parse(window.localStorage.getItem("sse-hidden-formula"))&&(o.formula=!0),JSON.parse(window.localStorage.getItem("sse-hidden-headings"))&&(o.headings=!0),this.btnShowMode.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-app-hide",showSeparator:!1,defaults:{hideOnClick:!0},items:[{text:this.textCompactToolbar,action:"compact",checked:this.isCompactView},{text:this.textHideTBar,action:"title",checked:!!o.title},{text:this.textHideFBar,action:"formula",checked:!!o.formula},{text:this.textHideHeadings,action:"headings",checked:!!o.headings},{text:this.textHideGridlines,action:"gridlines",checked:!1},{xtype:"menuseparator"},{xtype:"container",layout:{type:"hbox",align:"middle"},width:165,style:"font-size:11px; padding:6px 2px 3px 32px;",items:[{xtype:"label",text:t.textZoom},{xtype:"tbspacer",flex:1},this.btnZoomOut,{xtype:"tbspacer",width:1},this.txtZoom,this.btnZoomIn,{xtype:"tbspacer",width:5}]}]}),e.push(this.btnShowMode),this.btnTextOrient.menu=Ext.create("Ext.menu.Menu",{id:"toolbar-menu-text-orientation",showSeparator:!1,defaults:{cls:"toolbar-menu-icon-item",checked:!1,hideOnClick:!0},items:[{iconCls:"mnu-icon-item mnu-direct-horiz",text:this.textHorizontal,angle:"horiz"},{iconCls:"mnu-icon-item mnu-direct-ccw",text:this.textCounterCw,angle:"countcw"},{iconCls:"mnu-icon-item mnu-direct-cw",text:this.textClockwise,angle:"clockwise"},{iconCls:"mnu-icon-item mnu-direct-rup",text:this.textRotateUp,angle:"rotateup"},{iconCls:"mnu-icon-item mnu-direct-rdown",text:this.textRotateDown,angle:"rotatedown"}]}),e.push(this.btnTextOrient),this.btnAddCell.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,action:"insert-cells",defaults:{cls:"menu-item-noicon"},items:[{text:this.textInsRight,kind:c_oAscInsertOptions.InsertCellsAndShiftRight},{text:this.textInsDown,kind:c_oAscInsertOptions.InsertCellsAndShiftDown},{text:this.textEntireRow,kind:c_oAscInsertOptions.InsertRows},{text:this.textEntireCol,kind:c_oAscInsertOptions.InsertColumns}]}),e.push(this.btnAddCell),this.btnDeleteCell.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,action:"delete-cells",defaults:{cls:"menu-item-noicon"},items:[{text:this.textDelLeft,kind:c_oAscDeleteOptions.DeleteCellsAndShiftLeft},{text:this.textDelUp,kind:c_oAscDeleteOptions.DeleteCellsAndShiftTop},{text:this.textEntireRow,kind:c_oAscDeleteOptions.DeleteRows},{text:this.textEntireCol,kind:c_oAscDeleteOptions.DeleteColumns}]}),e.push(this.btnDeleteCell);for(var u=e.length;u--;){var a=e[u];a.menu.ownerCt=a,a.mon(e[u].menu,{scope:a,show:a.onMenuShow,hide:a.onMenuHide}),a.rendered&&a.initAria()}var f=[{sizevalue:8,sizestring:"8"},{sizevalue:9,sizestring:"9"},{sizevalue:10,sizestring:"10"},{sizevalue:11,sizestring:"11"},{sizevalue:12,sizestring:"12"},{sizevalue:14,sizestring:"14"},{sizevalue:16,sizestring:"16"},{sizevalue:18,sizestring:"18"},{sizevalue:20,sizestring:"20"},{sizevalue:22,sizestring:"22"},{sizevalue:24,sizestring:"24"},{sizevalue:26,sizestring:"26"},{sizevalue:28,sizestring:"28"},{sizevalue:36,sizestring:"36"},{sizevalue:48,sizestring:"48"},{sizevalue:72,sizestring:"72"}];this.cmbFontSize.store.loadData(f),this.cmbFontSize.select(this.cmbFontSize.store.getAt(3)),this.cmbFontSize.rendered&&(this.cmbFontSize.getEl().set({"data-qtip":t.tipFontSize}),this.cmbFontSize.validate()),this.needShowSynchTip&&(this.needShowSynchTip=!1,this._onCollaborativeChanges()),this.themeColors&&this._onSendThemeColors(this.themeColors.user,this.themeColors.standart)},textBold:"Bold",textItalic:"Italic",textUnderline:"Underline",tipFontName:"Font Name",tipFontSize:"Font Size",tipCopy:"Copy",tipPaste:"Paste",tipUndo:"Undo",tipRedo:"Redo",tipPrint:"Print",tipSave:"Save",tipFontColor:"Font color",tipPrColor:"Background color",tipClearStyle:"Clear",tipBack:"Back",tipHAligh:"Horizontal Align",tipVAligh:"Vertical Align",tipAlignLeft:"Align Left",tipAlignRight:"Align Right",tipAlignCenter:"Align Center",tipAlignJust:"Justified",textAlignTop:"Align text to the top",textAlignMiddle:"Align text to the middle",textAlignBottom:"Align text to the bottom",tipNumFormat:"Number Format",txtNumber:"Number",txtInteger:"Integer",txtGeneral:"General",txtCurrency:"Currency",txtDollar:"$ Dollar",txtEuro:"€ Euro",txtRouble:"р. Rouble",txtPound:"£ Pound",txtYen:"¥ Yen",txtDate:"Date",txtTime:"Time",txtDateTime:"Date & Time",txtPercentage:"Percentage",txtScientific:"Scientific",txtText:"Text",tipBorders:"Borders",textOutBorders:"Outside Borders",textAllBorders:"All Borders",textTopBorders:"Top Borders",textBottomBorders:"Bottom Borders",textLeftBorders:"Left Borders",textRightBorders:"Right Borders",textNoBorders:"No Borders",textInsideBorders:"Inside Borders",textMiddleBorders:"Inside Horizontal Borders",textCenterBorders:"Inside Vertical Borders",tipWrap:"Wrap Text",txtClearAll:"All",txtClearText:"Text",txtClearFormat:"Format",txtClearFormula:"Formula",txtClearHyper:"Hyperlink",tipMerge:"Merge",txtMergeCenter:"Merge Center",txtMergeAcross:"Merge Across",txtMergeCells:"Merge Cells",txtUnmerge:"Unmerge Cells",tipIncDecimal:"Increase Decimal",tipDecDecimal:"Decrease Decimal",tipAutofilter:"Set Autofilter",tipInsertImage:"Insert Picture",tipInsertHyperlink:"Add Hyperlink",tipSynchronize:"The document has been changed by another user. Please click to save your changes and reload the updates.",tipIncFont:"Increment font size",tipDecFont:"Decrement font size",tipInsertText:"Insert Text",tipInsertShape:"Insert Autoshape",tipDigStylePercent:"Percent Style",tipDigStyleCurrency:"Currency Style",tipViewSettings:"View Settings",tipAdvSettings:"Advanced Settings",tipTextOrientation:"Orientation",tipInsertOpt:"Insert Cells",tipDeleteOpt:"Delete Cells",tipAlignTop:"Align Top",tipAlignMiddle:"Align Middle",tipAlignBottom:"Align Bottom",textBordersWidth:"Borders Width",textBordersColor:"Borders Color",textAlignLeft:"Left align text",textAlignRight:"Right align text",textAlignCenter:"Center text",textAlignJust:"Justify",txtSort:"Sort",txtFormula:"Insert Function",txtNoBorders:"No borders",txtAdditional:"Additional",mniImageFromFile:"Picture from file",mniImageFromUrl:"Picture from url",textNewColor:"Add New Custom Color",textPrint:"Print",textPrintOptions:"Print Options",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",tipColorSchemas:"Change Color Scheme",tipNewDocument:"New Document",tipOpenDocument:"Open Document",txtSortAZ:"Sort A to Z",txtSortZA:"Sort Z to A",txtFilter:"Filter",txtTableTemplate:"Format As Table Template",textHorizontal:"Horizontal Text",textCounterCw:"Angle Counterclockwise",textClockwise:"Angle Clockwise",textRotateUp:"Rotate Text Up",textRotateDown:"Rotate Text Down",textInsRight:"Shift Cells Right",textInsDown:"Shift Cells Down",textEntireRow:"Entire Row",textEntireCol:"Entire Column",textDelLeft:"Shift Cells Left",textDelUp:"Shift Cells Up",textZoom:"Zoom",textCompactToolbar:"Compact Toolbar",textHideTBar:"Hide Title Bar",textHideFBar:"Hide Formula Bar",textHideHeadings:"Hide Headings",textHideGridlines:"Hide Gridlines",txtScheme1:"Office",txtScheme2:"Grayscale",txtScheme3:"Apex",txtScheme4:"Aspect",txtScheme5:"Civic",txtScheme6:"Concourse",txtScheme7:"Equity",txtScheme8:"Flow",txtScheme9:"Foundry",txtScheme10:"Median",txtScheme11:"Metro",txtScheme12:"Module",txtScheme13:"Opulent",txtScheme14:"Oriel",txtScheme15:"Origin",txtScheme16:"Paper",txtScheme17:"Solstice",txtScheme18:"Technic",txtScheme19:"Trek",txtScheme20:"Urban",txtScheme21:"Verve"}),Ext.define("SSE.view.AutoFilterDialog",{extend:"Ext.window.Window",alias:"widget.sseautofilterdialog",requires:["Ext.window.Window","Common.plugin.GridScrollPane","Common.component.SearchField"],modal:!0,closable:!0,resizable:!1,height:350,width:270,constrain:!0,padding:"20px 20px 0 20px",layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.btnSortDesc=Ext.create("Ext.Button",{iconCls:"asc-toolbar-btn btn-sort-up",width:28,enableToggle:!0,toggleGroup:"autoFilterSort",allowDepress:!1,listeners:{click:function(){e.fireEvent("onmodalresult",e,3,"descending"),e.close()}}}),this.btnSortAsc=Ext.create("Ext.Button",{iconCls:"asc-toolbar-btn btn-sort-down",width:28,enableToggle:!0,style:"margin: 0 6px 0 0",toggleGroup:"autoFilterSort",allowDepress:!1,listeners:{click:function(){e.fireEvent("onmodalresult",e,3,"ascending"),e.close()}}}),this.chCustomFilter=Ext.widget("checkbox",{style:"margin: 0 6px 0 0",disabled:!0,boxLabel:""});var t=Ext.create("Ext.Button",{width:120,text:e.btnCustomFilter,listeners:{click:function(){e.fireEvent("onmodalresult",e,2),e.close()}}}),n,r,i=Ext.create("Common.component.SearchField",{style:"margin: 10px 0",emptyText:e.txtEmpty,listeners:{change:function(t,i,o,u){e.cellsStore.clearFilter(!0),o&&i.length<o.length&&(s.selected.clear(),r=e.cellsStore.getAt(0).ischecked,n=e.cellsStore.getRange(r?0:1),n.forEach(function(e){(r||e.ischecked)&&s.selected.add(e)})),i.length?e.cellsStore.filter([{property:"cellvalue",value:new RegExp(i,"i")},{property:"rowvisible",value:/^((?!ever|hidden).)*$/}]):e.cellsStore.filter("rowvisible",/^((?!hidden).)*$/)},searchstart:function(t,n){e.cellsStore.filter([{property:"cellvalue",value:new RegExp(n,"i")},{property:"rowvisible",value:/^((?!ever|hidden).)*$/}]),this.stopSearch(!0)},searchclear:function(){}}});this.cellsStore=Ext.create("Ext.data.Store",{fields:["cellvalue","rowvisible","groupid","intval","strval"]});var s=Ext.create("Ext.selection.CheckboxModel",{mode:"SIMPLE",listeners:{deselect:function(t,n,r){e.chCustomFilter.getValue()&&e.chCustomFilter.setValue(!1),n.ischecked=!1;if(n.data.rowvisible=="ever")t.deselectAll(),e.cellsStore.getRange(1).forEach(function(e){e.ischecked=!1});else{var i=e.cellList.getStore().getAt(0);i.data.rowvisible=="ever"&&t.isSelected(i)&&(i.ischecked=!1,t.deselect(i,!0))}},select:function(t,n,r){e.chCustomFilter.getValue()&&e.chCustomFilter.setValue(!1),n.ischecked=!0,n.data.rowvisible=="ever"&&(t.select(e.cellList.getStore().getRange(1),!1,!0),t.select(e.cellList.getStore().getAt(0),!0,!0),e.cellsStore.getRange(1).forEach(function(e){e.ischecked=!0}))}}});this.cellList=Ext.create("Ext.grid.Panel",{activeItem:0,selModel:s,store:this.cellsStore,stateful:!0,stateId:"stateGrid",scroll:!1,columns:[{flex:1,sortable:!1,dataIndex:"cellvalue"}],height:160,hideHeaders:!0,style:"margin: 0 0 14px 0",viewConfig:{stripeRows:!1},plugins:[{ptype:"gridscrollpane"}]});var o=Ext.create("Ext.Button",{text:Ext.Msg.buttonText.ok,width:80,cls:"asc-blue-button",listeners:{click:function(){s.getCount()?(e.fireEvent("onmodalresult",e,e.chCustomFilter.getValue()?0:1),e.close()):Ext.Msg.show({title:e.textWarning,msg:e.warnNoSelected,icon:Ext.Msg.WARNING,buttons:Ext.Msg.OK})}}}),u=Ext.create("Ext.Button",{text:e.cancelButtonText,width:80,listeners:{click:function(){e.fireEvent("onmodalresult",e,0),e.close()}}});this.items=[{xtype:"container",height:30,layout:{type:"hbox"},items:[this.btnSortAsc,this.btnSortDesc,{xtype:"tbspacer",flex:1},this.chCustomFilter,t]},i,this.cellList,{xtype:"container",width:250,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},o,{xtype:"tbspacer",width:5},u]}],this.callParent(arguments),this.setTitle(this.txtTitle)},afterRender:function(){this.callParent(arguments),this._setDefaults()},setSettings:function(e){var t=[{cellvalue:this.textSelectAll,rowvisible:"ever",groupid:"0"}],n,r;e.asc_getResult().forEach(function(e){r=e.asc_getVal(),n=Ext.isNumeric(r),t.push({cellvalue:r,rowvisible:e.asc_getVisible(),groupid:"1",intval:n?parseFloat(r):undefined,strval:n?"":r})}),this.cellsStore.loadData(t),this.cellsStore.group("groupid"),this._defaults=[],this._defaults.properties=e},getSettings:function(){var e=new Asc.AutoFiltersOptions;e.asc_setCellId(this._defaults.properties.asc_getCellId());var t=[],n,r=this;this.cellsStore.clearFilter(!0);var i=this.cellsStore.getRange(1);return i.forEach(function(e){(n=e.get("rowvisible"))!="hidden"&&(n=r.cellList.getSelectionModel().isSelected(e)),t.push(new Asc.AutoFiltersOptionsElements(e.get("cellvalue"),n))}),e.asc_setResult(t),e.sortState=this._defaults.properties.asc_getSortState(),e},_setDefaults:function(){var e=this._defaults.properties.asc_getSortState();e&&this[e=="ascending"?"btnSortAsc":"btnSortDesc"].toggle(!0,!0);var t=this.cellList.getStore(),n=this.cellList.getSelectionModel();t.filter("rowvisible",/^((?!hidden).)*$/);var r=t.getCount(),i,s=!0;while(r>1)i=t.getAt(--r),i.data.rowvisible===!0?(n.select(i,!0,!0),i.ischecked=!0):s=!1;s&&(t.getAt(0).ischecked=!0,n.select(0,!0,!0)),this.chCustomFilter.setValue(this._defaults.properties.asc_getIsCustomFilter()===!0)},btnCustomFilter:"Custom Filter",textSelectAll:"Select All",txtTitle:"Filter",warnNoSelected:"You must choose at least one value",textWarning:"Warning",cancelButtonText:"Cancel",txtEmpty:"Enter cell's filter"}),Ext.define("SSE.view.DigitalFilterDialog",{extend:"Ext.window.Window",alias:"widget.ssedigitalfilterdialog",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,height:226,width:500,constrain:!0,padding:"20px 20px 0 20px",layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this,t=Ext.create("Ext.data.Store",{fields:["condition","caption"],data:[{condition:c_oAscCustomAutoFilter.equals,caption:e.capCondition1},{condition:c_oAscCustomAutoFilter.doesNotEqual,caption:e.capCondition2},{condition:c_oAscCustomAutoFilter.isGreaterThan,caption:e.capCondition3},{condition:c_oAscCustomAutoFilter.isGreaterThanOrEqualTo,caption:e.capCondition4},{condition:c_oAscCustomAutoFilter.isLessThan,caption:e.capCondition5},{condition:c_oAscCustomAutoFilter.isLessThanOrEqualTo,caption:e.capCondition6},{condition:c_oAscCustomAutoFilter.beginsWith,caption:e.capCondition7},{condition:c_oAscCustomAutoFilter.doesNotBeginWith,caption:e.capCondition8},{condition:c_oAscCustomAutoFilter.endsWith,caption:e.capCondition9},{condition:c_oAscCustomAutoFilter.doesNotEndWith,caption:e.capCondition10},{condition:c_oAscCustomAutoFilter.contains,caption:e.capCondition11},{condition:c_oAscCustomAutoFilter.doesNotContain,caption:e.capCondition12}]});this.cmbCondition1=Ext.create("Ext.form.field.ComboBox",{store:t,displayField:"caption",valueField:"condition",queryMode:"local",typeAhead:!1,style:"margin-right: 10px",width:200,editable:!1}),this.txtValue1=Ext.create("Ext.form.Text",{flex:1,value:""}),this.txtValue2=Ext.create("Ext.form.Text",{flex:1,value:""});var n=Ext.create("Ext.data.Store",{fields:["condition","caption"],data:[{condition:0,caption:e.textNoFilter}]});n.loadRecords(t.data.getRange(),{addRecords:!0}),this.cmbCondition2=Ext.create("Ext.form.field.ComboBox",{store:n,displayField:"caption",valueField:"condition",queryMode:"local",typeAhead:!1,style:"margin-right: 10px",width:200,editable:!1}),this.rbMixer=Ext.widget("radiogroup",{columns:2,width:120,items:[{boxLabel:e.capAnd,name:"mix",inputValue:"and",checked:!0},{boxLabel:e.capOr,name:"mix",inputValue:"or"}]});var r=Ext.create("Ext.Button",{text:Ext.Msg.buttonText.ok,width:80,cls:"asc-blue-button",listeners:{click:function(){e.fireEvent("onmodalresult",e,1),e.close()}}}),i=Ext.create("Ext.Button",{text:e.cancelButtonText,width:80,listeners:{click:function(){e.fireEvent("onmodalresult",e,0),e.close()}}});this.items=[{xtype:"label",style:"font-weight: bold;margin:0 0 4px 0;",text:e.textShowRows},{xtype:"container",style:"margin:10px 0 0 0;",layout:{type:"hbox",align:"middle"},items:[this.cmbCondition1,this.txtValue1]},{xtype:"container",layout:{type:"hbox",align:"middle"},items:[this.rbMixer]},{xtype:"container",layout:{type:"hbox",align:"middle"},items:[this.cmbCondition2,this.txtValue2]},{xtype:"tbspacer",height:3},{xtype:"container",width:400,style:"margin:10px 0 0 0;",layout:{type:"hbox",align:"middle"},items:[{xtype:"tbspacer",flex:1},r,{xtype:"tbspacer",width:5},i]}],this.callParent(arguments),this.setTitle(this.txtTitle)},afterRender:function(){this.callParent(arguments),this._setDefaults()},setSettings:function(e){this._defaults=[],this._defaults.properties=e},getSettings:function(){var e=new Asc.AutoFiltersOptions;return e.asc_setCellId(this._defaults.properties.asc_getCellId()),e.asc_setIsChecked(this.rbMixer.getValue().mix=="or"),e.asc_setFilter1(this.cmbCondition1.getValue()),e.asc_setFilter2(this.cmbCondition2.getValue()||undefined),e.asc_setValFilter1(this.txtValue1.getValue()),e.asc_setValFilter2(this.txtValue2.getValue()),e},_setDefaults:function(){this.rbMixer.setValue({mix:this._defaults.properties.asc_getIsChecked()?"or":"and"}),this.cmbCondition1.setValue(this._defaults.properties.asc_getFilter1()||c_oAscCustomAutoFilter.equals),this.cmbCondition2.setValue(this._defaults.properties.asc_getFilter2()||0),this.txtValue1.setValue(this._defaults.properties.asc_getValFilter1()),this.txtValue2.setValue(this._defaults.properties.asc_getValFilter2())},txtTitle:"Custom Filter",capCondition1:"equals",capCondition2:"does not equal",capCondition3:"is greater than",capCondition4:"is greater than or equal to",capCondition5:"is less than",capCondition6:"is less than or equal to",capCondition7:"begins with",capCondition8:"does not begin with",capCondition9:"ends with",capCondition10:"does not end with",capCondition11:"contains",capCondition12:"does not contain",capAnd:"And",capOr:"Or",textShowRows:"Show rows where",textUse1:"Use ? to present any single character",textUse2:"Use * to present any series of character",textNoFilter:"no filter",cancelButtonText:"Cancel"}),Ext.define("SSE.view.TableOptionsDialog",{extend:"Ext.window.Window",alias:"widget.tableoptionsdialog",requires:["Ext.window.Window"],closable:!0,resizable:!1,height:145,width:300,padding:"12px 20px 0 20px",constrain:!0,layout:{type:"vbox",align:"stretch"},listeners:{show:function(){var e=this.api.asc_getAddFormatTableOptions();this.txtDataRange.setValue(e.asc_getRange()),this.chTitle.setValue(e.asc_getIsTitle()),this.api.asc_setSelectionDialogMode(!0,e.asc_getRange())},beforedestroy:function(){this.api.asc_setSelectionDialogMode(!1)}},initComponent:function(){var e=this,t="",n=this.names;if(n){t=n[0];var r=n.length;while(--r)t+="|"+n[r]}var i=new RegExp(t+"![A-Z]+[1-9]d*:[A-Z]+[1-9]d*"),s=new RegExp(t+"![A-Z]+[1-9]d*");this.txtDataRange=Ext.create("Ext.form.Text",{height:22,msgTarget:"side",validateOnBlur:!1,allowBlank:!1,value:"",editable:!1,check:!1,validator:function(e){if(!this.check)return!0;var t=i.test(e);return!t&&(t=s.test(e)),t?($("#"+this.id+" input").css("color","black"),!0):($("#"+this.id+" input").css("color","red"),"ERROR! Invalid cells range")}}),this.chTitle=Ext.widget("checkbox",{style:"margin: 0 26px 0 0",boxLabel:this.txtTitle});var o=Ext.create("Ext.Button",{text:Ext.Msg.buttonText.ok,width:80,style:"margin: 0 6px 0 0;",cls:"asc-blue-button",listeners:{click:function(){e.txtDataRange.validate()&&(e.fireEvent("onmodalresult",e,1,e.getSettings()),e.close())}}}),u=Ext.create("Ext.Button",{text:this.textCancel,width:80,cls:"asc-darkgray-button",listeners:{click:function(){e.close()}}});this.items=[this.txtDataRange,this.chTitle,{xtype:"container",height:26,style:"margin: 8px 0 0 0;",layout:{type:"hbox",align:"stretch",pack:"end"},items:[o,u]}],this.api&&this.api.asc_registerCallback("asc_onSelectionRangeChanged",Ext.bind(this._onRangeChanged,this)),this.callParent(arguments),this.setTitle(this.txtFormat)},_onRangeChanged:function(e){this.txtDataRange.setValue(e)},getSettings:function(){var e=this.api.asc_getAddFormatTableOptions();return e.asc_setRange(this.txtDataRange.getValue()),e.asc_setIsTitle(this.chTitle.getValue()),e},txtTitle:"Title",txtFormat:"Format as table",textCancel:"Cancel"}),Ext.define("SSE.view.ShapeSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.sseshapesettingsadvanced",requires:["Ext.form.field.ComboBox","Ext.window.Window","Ext.data.Model","Ext.data.Store","Ext.Array","Ext.button.Button","Ext.util.Cookies"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:340,width:516,layout:{type:"vbox",align:"stretch"},initComponent:function(){function h(e){e.pressed&&g.getLayout().setActiveItem(e.card)}var e=this;this.addEvents("onmodalresult"),this._originalProps=null,this._changedProps=null,this._beginSizeIdx=0,this._endSizeIdx=0,this._nRatio=1,this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-spin-width",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){if(this._btnRatio.pressed){var i=e.getNumberValue(),s=i/this._nRatio;s>this._spnHeight.maxValue&&(s=this._spnHeight.maxValue,i=s*this._nRatio,this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(i),this._spnWidth.resumeEvents()),this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(s),this._spnHeight.resumeEvents()}this._changedProps&&(this._changedProps.asc_putWidth(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._changedProps.asc_putHeight(Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue())))},this)}}),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-span-height",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){var i=e.getNumberValue(),s=null;this._btnRatio.pressed&&(s=i*this._nRatio,s>this._spnWidth.maxValue&&(s=this._spnWidth.maxValue,i=s/this._nRatio,this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(i),this._spnHeight.resumeEvents()),this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(s),this._spnWidth.resumeEvents()),this._changedProps&&(this._changedProps.asc_putHeight(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._changedProps.asc_putWidth(Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue())))},this)}}),this._btnRatio=Ext.create("Ext.Button",{id:"shape-advanced-button-ratio",iconCls:"advanced-btn-ratio",enableToggle:!0,width:22,height:22,style:"margin: 0 0 0 6px;",tooltip:this.textKeepRatio,toggleHandler:Ext.bind(function(e){e.pressed&&this._spnHeight.getNumberValue()>0&&(this._nRatio=this._spnWidth.getNumberValue()/this._spnHeight.getNumberValue())},this)}),this._arrCapType=[[c_oAscLineCapType.Flat,this.textFlat],[c_oAscLineCapType.Round,this.textRound],[c_oAscLineCapType.Square,this.textSquare]],this.cmbCapType=Ext.create("Ext.form.field.ComboBox",{id:"shape-advanced-cap-type",width:100,editable:!1,store:this._arrCapType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(t,n,r){this._changedProps&&((this._changedProps.asc_getShapeProperties()===null||this._changedProps.asc_getShapeProperties()===undefined)&&this._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),this._changedProps.asc_getShapeProperties().asc_getStroke()===null&&this._changedProps.asc_getShapeProperties().asc_putStroke(new Asc.asc_CStroke),this._changedProps.asc_getShapeProperties().asc_getStroke().asc_putLinecap(e._arrCapType[n[0].index][0]))},this)}}),this.cmbCapType.setValue(this._arrCapType[0][1]),this._arrJoinType=[[c_oAscLineJoinType.Round,this.textRound],[c_oAscLineJoinType.Bevel,this.textBevel],[c_oAscLineJoinType.Miter,this.textMiter]],this.cmbJoinType=Ext.create("Ext.form.field.ComboBox",{id:"shape-advanced-join-type",width:100,editable:!1,store:this._arrJoinType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(t,n,r){this._changedProps&&((this._changedProps.asc_getShapeProperties()===null||this._changedProps.asc_getShapeProperties()===undefined)&&this._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),this._changedProps.asc_getShapeProperties().asc_getStroke()===null&&this._changedProps.asc_getShapeProperties().asc_putStroke(new Asc.asc_CStroke),this._changedProps.asc_getShapeProperties().asc_getStroke().asc_putLinejoin(e._arrJoinType[n[0].index][0]))},this)}}),this.cmbJoinType.setValue(this._arrJoinType[0][1]),this.styleURL="resources/img/right-panels/Begin-EndStyle.png",this.styleURL2x="resources/img/right-panels/Begin-EndStyle@2x.png";var t=[],n=[],r=[c_oAscLineBeginType.None,c_oAscLineBeginType.Triangle,c_oAscLineBeginType.Arrow,c_oAscLineBeginType.Stealth,c_oAscLineBeginType.Diamond,c_oAscLineBeginType.Oval],i=[c_oAscLineBeginSize.small_small,c_oAscLineBeginSize.small_mid,c_oAscLineBeginSize.small_large,c_oAscLineBeginSize.mid_small,c_oAscLineBeginSize.mid_mid,c_oAscLineBeginSize.mid_large,c_oAscLineBeginSize.large_small,c_oAscLineBeginSize.large_mid,c_oAscLineBeginSize.large_large];for(var s=0;s<6;s++){var o={value:s,imagewidth:44,imageheight:20,offsetx:80*s+10,offsety:0};o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-o.offsety,this.styleURL2x),t.push(o)}t[0].type=c_oAscLineBeginType.None,t[1].type=c_oAscLineBeginType.Triangle,t[2].type=c_oAscLineBeginType.Arrow,t[3].type=c_oAscLineBeginType.Stealth,t[4].type=c_oAscLineBeginType.Diamond,t[5].type=c_oAscLineBeginType.Oval;for(s=0;s<9;s++){var o={value:s,imagewidth:44,imageheight:20,offsetx:90,offsety:20*(s+1)};o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-o.offsety,this.styleURL2x),n.push(o)}n[0].type=c_oAscLineBeginSize.small_small,n[1].type=c_oAscLineBeginSize.small_mid,n[2].type=c_oAscLineBeginSize.small_large,n[3].type=c_oAscLineBeginSize.mid_small,n[4].type=c_oAscLineBeginSize.mid_mid,n[5].type=c_oAscLineBeginSize.mid_large,n[6].type=c_oAscLineBeginSize.large_small,n[7].type=c_oAscLineBeginSize.large_mid,n[8].type=c_oAscLineBeginSize.large_large;var u=Ext.create("Ext.data.Store",{model:"SSE.model.ModelBorders",data:t}),a=Ext.create("Ext.data.Store",{model:"SSE.model.ModelBorders",data:n});for(s=0;s<t.length;s++){var o=t[s];o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-(o.offsety+200),this.styleURL2x)}for(s=0;s<n.length;s++){var o=n[s];o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-(o.offsety+200),this.styleURL2x)}var f=Ext.create("Ext.data.Store",{model:"SSE.model.ModelBorders",data:t}),l=Ext.create("Ext.data.Store",{model:"SSE.model.ModelBorders",data:n});this._updateSizeArr=function(t,r,i,s){var o=Ext.String.format("background:url({0}) repeat scroll 0 -1px","resources/img/controls/text-bg.gif");if(r.data.value>0){for(var u=0;u<n.length;u++)n[u].offsetx=r.data.value*80+10,n[u].borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",e.styleURL,n[u].imagewidth,n[u].imageheight,-n[u].offsetx,-(n[u].offsety+200*i),this.styleURL2x);t.menu.picker.store.loadData(n),t.setDisabled(!1),s!==null?(t.menu.picker.selectByIndex(s,!0),e._selectStyleItem(t,t.menu.picker.store.getAt(s),i)):Ext.DomHelper.applyStyles(t.btnEl,o)}else Ext.DomHelper.applyStyles(t.btnEl,o),t.setDisabled(!0)},this._selectStyleItem=function(t,n,r){var i;t.btnEl&&(i=Ext.String.format("background:url({0}) repeat scroll {1}px {2}px, url({3}) repeat scroll 0 -1px;",e.styleURL,-(n.data.offsetx-20),-(n.data.offsety+200*r),"resources/img/controls/text-bg.gif"),i+=Ext.String.format("background-image: -webkit-image-set(url({0}) 1x, url({1}) 2x), -webkit-image-set(url({2}) 1x, url({3}) 2x);",e.styleURL,e.styleURL2x,"resources/img/controls/text-bg.gif","resources/img/controls/text-bg@2x.gif"),Ext.DomHelper.applyStyles(t.btnEl,i))};var c=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="left" style="{borderstyle}"" />',"</div>","</tpl>");this._btnBeginStyle=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginStyleMenu=Ext.create("Common.component.MenuDataViewPicker",{width:115,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:u,contentWidth:95,listeners:{select:Ext.bind(function(t,n){e._changedProps&&((e._changedProps.asc_getShapeProperties()===null||e._changedProps.asc_getShapeProperties()===undefined)&&e._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),e._changedProps.asc_getShapeProperties().asc_getStroke()===null&&e._changedProps.asc_getShapeProperties().asc_putStroke(new Asc.asc_CStroke),e._changedProps.asc_getShapeProperties().asc_getStroke().asc_putLinebeginstyle(n.data.type));if(e._beginSizeIdx===null||e._beginSizeIdx===undefined)e._beginSizeIdx=4;e._updateSizeArr(e._btnBeginSize,n,0,e._beginSizeIdx),e._selectStyleItem(e._btnBeginStyle,n,0)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),0)}}}),this._btnEndStyle=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.EndStyleMenu=Ext.create("Common.component.MenuDataViewPicker",{width:115,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:f,contentWidth:95,listeners:{select:Ext.bind(function(t,n){e._changedProps&&((e._changedProps.asc_getShapeProperties()===null||e._changedProps.asc_getShapeProperties()===undefined)&&e._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),e._changedProps.asc_getShapeProperties().asc_getStroke()===null&&e._changedProps.asc_getShapeProperties().asc_putStroke(new Asc.asc_CStroke),e._changedProps.asc_getShapeProperties().asc_getStroke().asc_putLineendstyle(n.data.type));if(e._endSizeIdx===null||e._endSizeIdx===undefined)e._endSizeIdx=4;e._updateSizeArr(e._btnEndSize,n,1,e._endSizeIdx),e._selectStyleItem(e._btnEndStyle,n,1)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),1)}}}),this._btnBeginSize=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginSizeMenu=Ext.create("Common.component.MenuDataViewPicker",{width:167,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:a,contentWidth:147,listeners:{select:Ext.bind(function(t,n){e._changedProps&&((e._changedProps.asc_getShapeProperties()===null||e._changedProps.asc_getShapeProperties()===undefined)&&e._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),e._changedProps.asc_getShapeProperties().asc_getStroke()===null&&e._changedProps.asc_getShapeProperties().asc_putStroke(new Asc.asc_CStroke),e._changedProps.asc_getShapeProperties().asc_getStroke().asc_putLinebeginsize(n.data.type)),e._beginSizeIdx=n.data.value,e._selectStyleItem(e._btnBeginSize,n,0)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),0)}}}),this._btnEndSize=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginSizeMenu=Ext.create("Common.component.MenuDataViewPicker",{width:167,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:l,contentWidth:147,listeners:{select:Ext.bind(function(t,n){e._changedProps&&((e._changedProps.asc_getShapeProperties()===null||e._changedProps.asc_getShapeProperties()===undefined)&&e._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),e._changedProps.asc_getShapeProperties().asc_getStroke()===null&&e._changedProps.asc_getShapeProperties().asc_putStroke(new Asc.asc_CStroke),e._changedProps.asc_getShapeProperties().asc_getStroke().asc_putLineendsize(n.data.type)),e._endSizeIdx=n.data.value,e._selectStyleItem(e._btnEndSize,n,1)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),1)}}}),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getShapeProperties()===null||this._changedProps.asc_getShapeProperties()===undefined)&&this._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),this._changedProps.asc_getShapeProperties().asc_getPaddings()===null&&this._changedProps.asc_getShapeProperties().asc_putPaddings(new Asc.asc_CPaddings),this._changedProps.asc_getShapeProperties().asc_getPaddings().asc_putTop(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getShapeProperties()===null||this._changedProps.asc_getShapeProperties()===undefined)&&this._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),this._changedProps.asc_getShapeProperties().asc_getPaddings()===null&&this._changedProps.asc_getShapeProperties().asc_putPaddings(new Asc.asc_CPaddings),this._changedProps.asc_getShapeProperties().asc_getPaddings().asc_putBottom(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getShapeProperties()===null||this._changedProps.asc_getShapeProperties()===undefined)&&this._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),this._changedProps.asc_getShapeProperties().asc_getPaddings()===null&&this._changedProps.asc_getShapeProperties().asc_putPaddings(new Asc.asc_CPaddings),this._changedProps.asc_getShapeProperties().asc_getPaddings().asc_putLeft(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getShapeProperties()===null||this._changedProps.asc_getShapeProperties()===undefined)&&this._changedProps.asc_putShapeProperties(new Asc.asc_CShapeProperty),this._changedProps.asc_getShapeProperties().asc_getPaddings()===null&&this._changedProps.asc_getShapeProperties().asc_putPaddings(new Asc.asc_CPaddings),this._changedProps.asc_getShapeProperties().asc_getPaddings().asc_putRight(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'});var p=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textSize,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"shapeadvanced",pressed:!0,card:"card-size",listeners:{click:h}});this.btnShape=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textWeightArrows,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"shapeadvanced",card:"card-shape",listeners:{click:h}}),this.btnMargins=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strMargins,enableToggle:!0,allowDepress:!1,toggleGroup:"shapeadvanced",card:"card-margins",listeners:{click:h}});var d={xtype:"container",itemId:"card-size",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:43,style:"float:left;"},items:[{width:128,items:[{xtype:"label",text:this.textWidth,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:128,layout:{type:"hbox"},items:[this._spnWidth,this._btnRatio]}]},{width:175,margin:"0 0 0 7",items:[{xtype:"label",text:this.textHeight,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:175,layout:{type:"hbox"},items:[this._spnHeight]}]}]}]},v={xtype:"container",itemId:"card-shape",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textLineStyle},{xtype:"tbspacer",height:8},{xtype:"container",height:40,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textCapType,width:85},{xtype:"label",text:this.textJoinType,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbCapType,this.cmbJoinType]},this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textArrows},{xtype:"tbspacer",height:8},{xtype:"container",height:86,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textBeginStyle,width:85},{xtype:"label",text:this.textEndStyle,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._btnBeginStyle,this._btnEndStyle,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBeginSize,width:85},{xtype:"label",text:this.textEndSize,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._btnBeginSize,this._btnEndSize]}]},m={xtype:"container",itemId:"card-margins",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]}]},g=Ext.create("Ext.container.Container",{height:330,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[d,v,m]});this.items=[{xtype:"container",height:244,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:p},{height:30,items:this.btnShape},{height:30,items:this.btnMargins}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},g]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps),this.setTitle(this.textTitle)},setSettings:function(e){this._originalProps=e,this._changedProps=null},_setDefaults:function(e){if(e&&e.asc_getShapeProperties()){var t=e.asc_getShapeProperties(),n=t.asc_getStroke();if(n){var r=n.asc_getLinejoin();for(var i=0;i<this._arrJoinType.length;i++)if(r==this._arrJoinType[i][0]){this.cmbJoinType.setValue(this._arrJoinType[i][1]);break}r=n.asc_getLinecap();for(i=0;i<this._arrCapType.length;i++)if(r==this._arrCapType[i][0]){this.cmbCapType.setValue(this._arrCapType[i][1]);break}var s=n.asc_getCanChangeArrows();this._btnBeginStyle.setDisabled(!s),this._btnEndStyle.setDisabled(!s),this._btnBeginSize.setDisabled(!s),this._btnEndSize.setDisabled(!s);var o=Ext.String.format("background:url({0}) repeat scroll 0 -1px","resources/img/controls/text-bg.gif");if(s){r=n.asc_getLinebeginsize();var u=this._btnBeginSize.menu.picker.store.findRecord("type",r);u!==null?this._beginSizeIdx=u.data.value:(this._beginSizeIdx=null,Ext.DomHelper.applyStyles(this._btnBeginSize.btnEl,o)),r=n.asc_getLinebeginstyle(),u=this._btnBeginStyle.menu.picker.store.findRecord("type",r),u!==null?(this._btnBeginStyle.menu.picker.selectByIndex(u.data.value,!1),this._updateSizeArr(this._btnBeginSize,u,0,this._beginSizeIdx),this._selectStyleItem(this._btnBeginStyle,u,0)):Ext.DomHelper.applyStyles(this._btnBeginStyle.btnEl,o),r=n.asc_getLineendsize(),u=this._btnEndSize.menu.picker.store.findRecord("type",r),u!==null?this._endSizeIdx=u.data.value:(this._endSizeIdx=null,Ext.DomHelper.applyStyles(this._btnEndSize.btnEl,o)),r=n.asc_getLineendstyle(),u=this._btnEndStyle.menu.picker.store.findRecord("type",r),u!==null?(this._btnEndStyle.menu.picker.selectByIndex(u.data.value,!1),this._updateSizeArr(this._btnEndSize,u,1,this._endSizeIdx),this._selectStyleItem(this._btnEndStyle,u,1)):Ext.DomHelper.applyStyles(this._btnEndStyle.btnEl,o)}else Ext.DomHelper.applyStyles(this._btnBeginStyle.btnEl,o),Ext.DomHelper.applyStyles(this._btnEndStyle.btnEl,o),Ext.DomHelper.applyStyles(this._btnBeginSize.btnEl,o),Ext.DomHelper.applyStyles(this._btnEndSize.btnEl,o)}this._spnWidth.suspendEvents(!1),this._spnHeight.suspendEvents(!1),this._spnWidth.setValue(Common.MetricSettings.fnRecalcFromMM(e.asc_getWidth()).toFixed(2)),this._spnHeight.setValue(Common.MetricSettings.fnRecalcFromMM(e.asc_getHeight()).toFixed(2)),this._spnWidth.resumeEvents(),this._spnHeight.resumeEvents(),e.asc_getHeight()>0&&(this._nRatio=e.asc_getWidth()/e.asc_getHeight()),r=window.localStorage.getItem("sse-settings-shaperatio"),r!==null&&parseInt(r)==1&&this._btnRatio.toggle(!0);var a=t.asc_getPaddings();if(a){var f=a.asc_getLeft();this._spnMarginLeft.setValue(null!==f&&undefined!==f?Common.MetricSettings.fnRecalcFromMM(f):""),f=a.asc_getTop(),this._spnMarginTop.setValue(null!==f&&undefined!==f?Common.MetricSettings.fnRecalcFromMM(f):""),f=a.asc_getRight(),this._spnMarginRight.setValue(null!==f&&undefined!==f?Common.MetricSettings.fnRecalcFromMM(f):""),f=a.asc_getBottom(),this._spnMarginBottom.setValue(null!==f&&undefined!==f?Common.MetricSettings.fnRecalcFromMM(f):"")}}this._changedProps=new Asc.asc_CImgProperty},getSettings:function(){return window.localStorage.setItem("sse-settings-shaperatio",this._btnRatio.pressed?1:0),this._changedProps},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}},textRound:"Round",textMiter:"Miter",textSquare:"Square",textFlat:"Flat",textBevel:"Bevel",textTitle:"Shape - Advanced Settings",cancelButtonText:"Cancel",okButtonText:"Ok",txtNone:"None",textWeightArrows:"Weights & Arrows",textArrows:"Arrows",textLineStyle:"Line Style",textCapType:"Cap Type",textJoinType:"Join Type",textBeginStyle:"Begin Style",textBeginSize:"Begin Size",textEndStyle:"End Style",textEndSize:"End Size",textSize:"Size",textWidth:"Width",textHeight:"Height",textKeepRatio:"Constant Proportions",textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",strMargins:"Margins"}),Ext.define("SSE.view.ParagraphSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.sseparagraphsettingsadvanced",requires:["Ext.Array","Ext.form.field.ComboBox","Ext.window.Window","Common.component.ThemeColorPalette","Common.component.MetricSpinner","Common.component.IndeterminateCheckBox","Common.plugin.GridScrollPane","Ext.grid.Panel"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:390,width:516,layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this._changedProps=null,this.checkGroup=0,this._noApply=!0,this._tabListChanged=!1,this.numFirstLine=Ext.create("Common.component.MetricSpinner",{id:"paragraphadv-spin-first-line",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getInd()===null||this._changedProps.asc_getInd()===undefined)&&this._changedProps.asc_putInd(new Asc.asc_CParagraphInd),this._changedProps.asc_getInd().asc_putFirstLine(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this.numIndentsLeft=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-indent-left",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getInd()===null||this._changedProps.asc_getInd()===undefined)&&this._changedProps.asc_putInd(new Asc.asc_CParagraphInd),this._changedProps.asc_getInd().asc_putLeft(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this.numIndentsRight=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-indent-right",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.asc_getInd()===null||this._changedProps.asc_getInd()===undefined)&&this._changedProps.asc_putInd(new Asc.asc_CParagraphInd),this._changedProps.asc_getInd().asc_putRight(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.chStrike=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-strike",width:140,boxLabel:this.strStrike,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=1&&this._changedProps.asc_putStrikeout(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=1,this.chDoubleStrike.setValue(0),this._changedProps&&this._changedProps.asc_putDStrikeout(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putStrikeout(e.getValue()=="checked"),i.asc_putDStrikeout(this.chDoubleStrike.getValue()=="checked"),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chDoubleStrike=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-double-strike",width:140,boxLabel:this.strDoubleStrike,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=1&&this._changedProps.asc_putDStrikeout(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=1,this.chStrike.setValue(0),this._changedProps&&this._changedProps.asc_putStrikeout(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putDStrikeout(e.getValue()=="checked"),i.asc_putStrikeout(this.chStrike.getValue()=="checked"),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSuperscript=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-superscript",width:140,boxLabel:this.strSuperscript,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=2&&this._changedProps.asc_putSuperscript(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=2,this.chSubscript.setValue(0),this._changedProps&&this._changedProps.asc_putSubscript(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putSuperscript(e.getValue()=="checked"),i.asc_putSubscript(this.chSubscript.getValue()=="checked"),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSubscript=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-subscript",width:140,boxLabel:this.strSubscript,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=2&&this._changedProps.asc_putSubscript(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=2,this.chSuperscript.setValue(0),this._changedProps&&this._changedProps.asc_putSuperscript(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putSubscript(e.getValue()=="checked"),i.asc_putSuperscript(this.chSuperscript.getValue()=="checked"),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSmallCaps=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-small-caps",width:140,boxLabel:this.strSmallCaps,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=3&&this._changedProps.asc_putSmallCaps(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=3,this.chAllCaps.setValue(0),this._changedProps&&this._changedProps.asc_putAllCaps(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putSmallCaps(e.getValue()=="checked"),i.asc_putAllCaps(this.chAllCaps.getValue()=="checked"),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chAllCaps=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-all-caps",width:140,boxLabel:this.strAllCaps,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=3&&this._changedProps.asc_putAllCaps(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=3,this.chSmallCaps.setValue(0),this._changedProps&&this._changedProps.asc_putSmallCaps(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putAllCaps(e.getValue()=="checked"),i.asc_putSmallCaps(this.chSmallCaps.getValue()=="checked"),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.numSpacing=Ext.create("Common.component.MetricSpinner",{id:"paragraphadv-spin-spacing",readOnly:!1,step:.01,width:100,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.asc_putTextSpacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()));if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new Asc.asc_CParagraphProperty;i.asc_putTextSpacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.fontImage=Ext.create("Ext.container.Container",{id:"paragraphadv-font-img",width:"100%",height:80,style:"background-color:#ffffff; border:1px solid #CDCDCD;"}),this.numTab=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-tab",readOnly:!1,step:.1,width:180,defaultUnit:"cm",value:"1.25 cm",maxValue:55.87,minValue:0}),this.numDefaultTab=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-default-tab",readOnly:!1,step:.1,width:107,defaultUnit:"cm",value:"1.25 cm",maxValue:55.87,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.asc_putDefaultTab(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))},this)}}),this.btnAddTab=Ext.create("Ext.Button",{width:90,text:this.textSet,enableToggle:!1,listeners:{click:Ext.bind(function(e,n){var r=this.numTab.getNumberValue(),i=this.radioLeft.getValue()?1:this.radioCenter.getValue()?3:2,s=t.findBy(function(e,t){return Math.abs(e.data.tabPos-r)<.001},this);if(s<0){var o=t.add({tabPos:this.numTab.getNumberValue(),tabStr:this.numTab.getNumberValue()+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],tabAlign:i});t.sort(),this.tabList.getSelectionModel().select(o)}else{var o=t.getAt(s);o.set("tabAlign",i)}},this)}}),this.btnRemoveTab=Ext.create("Ext.Button",{width:90,text:this.textRemove,enableToggle:!1,listeners:{click:Ext.bind(function(e,n){var r=this.tabList.getSelectionModel().getSelection();if(r.length>0){var i=r[0].index;t.remove(r),i>t.count()-1&&(i=t.count()-1),i>-1&&this.tabList.getSelectionModel().select(i)}},this)}}),this.btnRemoveAll=Ext.create("Ext.Button",{width:90,text:this.textRemoveAll,enableToggle:!1,listeners:{click:Ext.bind(function(e,n){t.removeAll()},this)}}),this.radioLeft=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabLeft,name:"asc-radio-tab",checked:!0}),this.radioCenter=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabCenter,name:"asc-radio-tab",checked:!1}),this.radioRight=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabRight,name:"asc-radio-tab",checked:!1}),Ext.define("SSE.model.TabDataModel",{extend:"Ext.data.Model",fields:[{name:"tabPos",name:"tabStr",name:"tabAlign"}]});var t=Ext.create("Ext.data.Store",{model:"SSE.model.TabDataModel",data:[],sorters:["tabPos"],listeners:{datachanged:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this),update:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this),clear:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this)}});this.tabList=Ext.create("Ext.grid.Panel",{activeItem:0,id:"paragraphadv-tab-list",store:t,mode:"local",scroll:!1,columns:[{flex:1,dataIndex:"tabStr"}],height:80,width:180,hideHeaders:!0,viewConfig:{stripeRows:!1},plugins:[{pluginId:"scrollpane",ptype:"gridscrollpane"}],listeners:{select:function(e,t,n,r){this.numTab.setValue(t.data.tabPos),t.data.tabAlign==1?this.radioLeft.setValue(!0):t.data.tabAlign==3?this.radioCenter.setValue(!0):this.radioRight.setValue(!0)},scope:this}}),this.btnIndents=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.strParagraphIndents,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",pressed:!0,listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-indents")},scope:this}}),this.btnFont=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.strParagraphFont,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-font")},scope:this}}),this.btnTabs=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strTabs,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&(this.mainCard.getLayout().setActiveItem("card-tabs"),this.tabList.getPlugin("scrollpane").updateScrollPane())},scope:this}}),this._IndentsContainer={xtype:"container",itemId:"card-indents",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:5},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{items:[{xtype:"label",text:this.strIndentsFirstLine,width:85},{xtype:"tbspacer",height:3},this.numFirstLine]},{xtype:"tbspacer",width:23,height:3},{items:[{xtype:"label",text:this.strIndentsLeftText,width:85},{xtype:"tbspacer",height:3},this.numIndentsLeft]},{xtype:"tbspacer",width:23,height:3},{items:[{xtype:"label",text:this.strIndentsRightText,width:85},{xtype:"tbspacer",height:3},this.numIndentsRight]}]}]},this._FontContainer={xtype:"container",itemId:"card-font",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textEffects},{xtype:"tbspacer",height:8},{xtype:"container",height:85,width:"100%",padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"vertical-align: middle;"}},items:[this.chStrike,{xtype:"tbspacer",width:20,height:2},this.chSubscript,this.chDoubleStrike,{xtype:"tbspacer",width:20,height:2},this.chSmallCaps,this.chSuperscript,{xtype:"tbspacer",width:20,height:2},this.chAllCaps]},{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textCharacterSpacing},{xtype:"tbspacer",height:8},{xtype:"container",height:26,padding:"0 10",layout:{type:"vbox",align:"left"},items:[this.numSpacing]},{xtype:"tbspacer",height:10},{xtype:"container",height:85,padding:"0 10",items:[this.fontImage]}]},this._TabsContainer={xtype:"container",itemId:"card-tabs",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 0 0 10",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 7px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},style:"float:left;"},items:[{height:50,colspan:2,items:[{xtype:"label",text:this.textTabPosition,width:85},{xtype:"tbspacer",height:3},this.numTab]},{height:50,items:[{xtype:"label",text:this.textDefault,width:107},{xtype:"tbspacer",height:3},this.numDefaultTab]},{height:95,colspan:3,items:[this.tabList]},{height:100,colspan:3,items:[{xtype:"label",text:this.textAlign,width:85},{xtype:"tbspacer",height:3},this.radioLeft,this.radioCenter,this.radioRight]},this.btnAddTab,this.btnRemoveTab,this.btnRemoveAll]}]},this.items=[{xtype:"container",height:300,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:[this.btnIndents]},{height:30,items:[this.btnFont]},{height:30,items:[this.btnTabs]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},this.mainCard=Ext.create("Ext.container.Container",{height:300,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[this._IndentsContainer,this._FontContainer,this._TabsContainer]})]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps),this.setTitle(this.textTitle)},setSettings:function(e){this._originalProps=new Asc.asc_CParagraphProperty(e.paragraphProps),this._changedProps=null,this.api=e.api},_setDefaults:function(e){if(e){this._originalProps=new Asc.asc_CParagraphProperty(e),this.numFirstLine.setValue(e.asc_getInd()!==null&&e.asc_getInd().asc_getFirstLine()!==null?Common.MetricSettings.fnRecalcFromMM(e.asc_getInd().asc_getFirstLine()):""),this.numIndentsLeft.setValue(e.asc_getInd()!==null&&e.asc_getInd().asc_getLeft()!==null?Common.MetricSettings.fnRecalcFromMM(e.asc_getInd().asc_getLeft()):""),this.numIndentsRight.setValue(e.asc_getInd()!==null&&e.asc_getInd().asc_getRight()!==null?Common.MetricSettings.fnRecalcFromMM(e.asc_getInd().asc_getRight()):""),this._noApply=!0,this.chStrike.setValue(e.asc_getStrikeout()!==null&&e.asc_getStrikeout()!==undefined?e.asc_getStrikeout():"indeterminate"),this.chDoubleStrike.setValue(e.asc_getDStrikeout()!==null&&e.asc_getDStrikeout()!==undefined?e.asc_getDStrikeout():"indeterminate"),this.chSubscript.setValue(e.asc_getSubscript()!==null&&e.asc_getSubscript()!==undefined?e.asc_getSubscript():"indeterminate"),this.chSuperscript.setValue(e.asc_getSuperscript()!==null&&e.asc_getSuperscript()!==undefined?e.asc_getSuperscript():"indeterminate"),this.chSmallCaps.setValue(e.asc_getSmallCaps()!==null&&e.asc_getSmallCaps()!==undefined?e.asc_getSmallCaps():"indeterminate"),this.chAllCaps.setValue(e.asc_getAllCaps()!==null&&e.asc_getAllCaps()!==undefined?e.asc_getAllCaps():"indeterminate"),this.numSpacing.setValue(e.asc_getTextSpacing()!==null&&e.asc_getTextSpacing()!==undefined?Common.MetricSettings.fnRecalcFromMM(e.asc_getTextSpacing()):""),this.api.asc_setDrawImagePlaceParagraph("paragraphadv-font-img",this._originalProps),this.numDefaultTab.setValue(e.asc_getDefaultTab()!==null&&e.asc_getDefaultTab()!==undefined?Common.MetricSettings.fnRecalcFromMM(e.asc_getDefaultTab()):"");var t=e.asc_getTabs();if(t){var n=[],r=t.asc_getCount();for(var i=0;i<r;i++){var s=t.asc_getTab(i),o={tabPos:Common.MetricSettings.fnRecalcFromMM(s.asc_getPos()),tabAlign:s.asc_getValue()};o.tabStr=parseFloat(Ext.Number.toFixed(o.tabPos,3))+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],n.push(o)}this.tabList.getStore().loadData(n),this.tabList.getStore().sort(),this.tabList.getStore().count()>0&&this.tabList.getSelectionModel().select(0)}this._noApply=!1,this._changedProps=new Asc.asc_CParagraphProperty}},getSettings:function(){return this._tabListChanged&&((this._changedProps.asc_getTabs()===null||this._changedProps.asc_getTabs()===undefined)&&this._changedProps.asc_putTabs(new Asc.asc_CParagraphTabs),this.tabList.getStore().each(function(e,t){var n=new Asc.asc_CParagraphTab(Common.MetricSettings.fnRecalcToMM(e.data.tabPos),e.data.tabAlign);this._changedProps.asc_getTabs().add_Tab(n)},this)),{paragraphProps:this._changedProps}},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.id=="paragraphadv-spin-spacing"?n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1):n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textTitle:"Paragraph - Advanced Settings",strIndentsFirstLine:"First line",strIndentsLeftText:"Left",strIndentsRightText:"Right",strParagraphIndents:"Indents & Placement",strParagraphFont:"Font",cancelButtonText:"Cancel",okButtonText:"Ok",textEffects:"Effects",textCharacterSpacing:"Character Spacing",strDoubleStrike:"Double strikethrough",strStrike:"Strikethrough",strSuperscript:"Superscript",strSubscript:"Subscript",strSmallCaps:"Small caps",strAllCaps:"All caps",strTabs:"Tab",textSet:"Specify",textRemove:"Remove",textRemoveAll:"Remove All",textTabLeft:"Left",textTabRight:"Right",textTabCenter:"Center",textAlign:"Alignment",textTabPosition:"Tab Position",textDefault:"Default Tab"}),Ext.define("SSE.view.ImageSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.sseimagesettings",height:192,requires:["Ext.ComponentQuery","Ext.container.Container","Ext.button.Button","Ext.form.Label","Ext.toolbar.Spacer","Common.view.ImageFromUrlDialog","Ext.util.Cookies"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._nRatio=1,this._state={Width:0,Height:0},this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"image-spin-width",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:78,listeners:{change:Ext.bind(function(e,t,n,r){var i=e.getNumberValue(),s=this._spnHeight.getNumberValue();this._btnRatio.pressed&&(s=i/this._nRatio,s>this._spnHeight.maxValue&&(s=this._spnHeight.maxValue,i=s*this._nRatio,this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(i),this._spnWidth.resumeEvents()),this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(s),this._spnHeight.resumeEvents());if(this.api){var o=new Asc.asc_CImgProperty;o.asc_putWidth(Common.MetricSettings.fnRecalcToMM(i)),o.asc_putHeight(Common.MetricSettings.fnRecalcToMM(s)),this.api.asc_setGraphicObjectProps(o)}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this._spnWidth),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"image-span-height",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:78,listeners:{change:Ext.bind(function(e,t,n,r){var i=e.getNumberValue(),s=this._spnWidth.getNumberValue();this._btnRatio.pressed&&(s=i*this._nRatio,s>this._spnWidth.maxValue&&(s=this._spnWidth.maxValue,i=s/this._nRatio,this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(i),this._spnHeight.resumeEvents()),this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(s),this._spnWidth.resumeEvents());if(this.api){var o=new Asc.asc_CImgProperty;o.asc_putWidth(Common.MetricSettings.fnRecalcToMM(s)),o.asc_putHeight(Common.MetricSettings.fnRecalcToMM(i)),this.api.asc_setGraphicObjectProps(o)}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this._spnHeight);var e=window.localStorage.getItem("sse-settings-imageratio");this._btnRatio=Ext.create("Ext.Button",{id:"image-button-ratio",iconCls:"advanced-btn-ratio",enableToggle:!0,width:22,height:22,pressed:e===null||parseInt(e)==1,style:"margin: 0 0 0 4px;",tooltip:this.textKeepRatio,toggleHandler:Ext.bind(function(e){e.pressed&&this._spnHeight.getNumberValue()>0&&(this._nRatio=this._spnWidth.getNumberValue()/this._spnHeight.getNumberValue()),window.localStorage.setItem("sse-settings-imageratio",e.pressed?1:0)},this)}),this._btnOriginalSize=Ext.create("Ext.Button",{id:"image-button-original-size",text:this.textOriginalSize,width:106,listeners:{click:this.setOriginalSize,scope:this}}),this._btnInsertFromFile=Ext.create("Ext.Button",{id:"image-button-from-file",text:this.textFromFile,width:85,listeners:{click:function(e){this.api&&this.api.asc_changeImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"image-button-from-url",text:this.textFromUrl,width:85,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._SizePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:88,width:195,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:43,style:"float:left;"},items:[{items:[{xtype:"label",text:this.textWidth,width:78},{xtype:"tbspacer",height:3},{xtype:"container",width:108,layout:{type:"hbox"},items:[this._spnWidth,this._btnRatio,{xtype:"tbspacer",width:4}]}]},{items:[{xtype:"label",text:this.textHeight,width:78},{xtype:"tbspacer",height:3},this._spnHeight]}]},{xtype:"tbspacer",height:7},this._btnOriginalSize,{xtype:"tbspacer",height:3}]}),this._UrlPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:36,width:195,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},items:[this._btnInsertFromFile,this._btnInsertFromUrl]},{xtype:"tbspacer",height:2}]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textSize},this._SizePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textInsert},this._UrlPanel],this.addEvents("editcomplete"),this.callParent(arguments)},setOriginalSize:function(){if(this.api){var e=this.api.asc_getOriginalImageSize();if(e){var t=e.asc_getImageWidth(),n=e.asc_getImageHeight(),r=new Asc.asc_CImgProperty;r.asc_putWidth(t),r.asc_putHeight(n),this.api.asc_setGraphicObjectProps(r)}this.fireEvent("editcomplete",this)}},setApi:function(e){if(e==undefined)return;this.api=e},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){this.SuspendEvents();var t=e.asc_getWidth();if(Math.abs(this._state.Width-t)>.001||(this._state.Width===null||t===null)&&this._state.Width!==t)this._spnWidth.setValue(t!==null?Common.MetricSettings.fnRecalcFromMM(t):""),this._state.Width=t;t=e.asc_getHeight();if(Math.abs(this._state.Height-t)>.001||(this._state.Height===null||t===null)&&this._state.Height!==t)this._spnHeight.setValue(t!==null?Common.MetricSettings.fnRecalcFromMM(t):""),this._state.Height=t;this.ResumeEvents(),e.asc_getHeight()>0&&(this._nRatio=e.asc_getWidth()/e.asc_getHeight()),this._btnOriginalSize.setDisabled(e.asc_getImageUrl()===null||e.asc_getImageUrl()===undefined)}},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""){var i=new Asc.asc_CImgProperty;i.asc_putImageUrl(n.value),t.api.asc_setGraphicObjectProps(i)}}},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},createDelayedElements:function(){this.updateMetricUnit()},textKeepRatio:"Constant Proportions",textSize:"Size",textWidth:"Width",textHeight:"Height",textOriginalSize:"Default Size",textUrl:"Image URL",textInsert:"Change Image",textFromUrl:"From URL",textFromFile:"From File",txtTitle:"Picture"}),Ext.define("SSE.model.ModelBorders",{extend:"Ext.data.Model",fields:[{type:"string",name:"borderstyle"},{type:"string",name:"text"},{type:"string",name:"url"},{type:"float",name:"value"},{type:"int",name:"imagewidth"},{type:"int",name:"imageheight"}]}),Ext.define("SSE.view.ShapeSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.sseshapesettings",height:316,requires:["Ext.button.Button","Ext.form.Label","Ext.form.field.ComboBox","Ext.container.Container","Ext.toolbar.Spacer","Ext.Array","Ext.menu.Menu","Ext.menu.Manager","Ext.data.Model","Ext.data.Store","Ext.XTemplate","Ext.Img","Ext.slider.Single","Common.component.DataViewPicker","Common.component.MetricSpinner","Common.view.ImageFromUrlDialog","Common.component.ThemeColorPalette","SSE.view.ShapeSettingsAdvanced","Common.plugin.MenuExpand","Common.component.ComboDataView","Common.component.MultiSliderGradient","Common.plugin.ComboBoxScrollPane"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0;var e=this;this._originalProps=null,this._noApply=!0,this.imgprops=null,this._sendUndoPoint=!0,this._state={Transparency:null,FillType:c_oAscFill.FILL_TYPE_SOLID,ShapeColor:"ffffff",BlipFillType:c_oAscFillBlipType.STRETCH,StrokeType:c_oAscStrokeType.STROKE_COLOR,StrokeWidth:this._pt2mm(1),StrokeColor:"000000",FGColor:"000000",BGColor:"ffffff",GradColor:"000000",GradFillType:c_oAscFillGradType.GRAD_LINEAR,DisabledFillPanels:!1},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID,this.ShapeColor={Value:1,Color:"ffffff"},this.BlipFillType=c_oAscFillBlipType.STRETCH,this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.GradColor={values:[0,100],colors:["000000","ffffff"],currentIdx:0},this.GradLinearDirectionIdx=3,this.GradRadialDirectionIdx=0,this.PatternFillType=0,this.FGColor={Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.BorderColor={Value:1,Color:"transparent"},this.BorderSize=0,this.textureNames=[this.txtCanvas,this.txtCarton,this.txtDarkFabric,this.txtGrain,this.txtGranite,this.txtGreyPaper,this.txtKnit,this.txtLeather,this.txtBrownPaper,this.txtPapyrus,this.txtWood],this.ThemeValues=[6,15,7,16,0,1,2,3,4,5];var t=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:-1},{text:"0.5 pt",value:.5,offsety:0},{text:"1 pt",value:1,offsety:20},{text:"1.5 pt",value:1.5,offsety:40},{text:"2.25 pt",value:2.25,offsety:60},{text:"3 pt",value:3,offsety:80},{text:"4.5 pt",value:4.5,offsety:100},{text:"6 pt",value:6,offsety:120}];for(var n=1;n<t.length;n++)t[n].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-t[n].offsety);var r=Ext.create("Ext.data.Store",{model:"SSE.model.ModelBorders",data:t}),i=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:92,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:r,style:"margin-right: 8px;",listConfig:{mode:"local",width:145,itemTpl:i},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize=n[0].data.value;if(this.api&&!this._noApply){var i=new Asc.asc_CShapeProperty,s=new Asc.asc_CStroke;this.BorderSize<.01?s.asc_putType(c_oAscStrokeType.STROKE_NONE):(s.asc_putType(c_oAscStrokeType.STROKE_COLOR),this.BorderColor.Color=="transparent"||this.BorderColor.Color.color=="transparent"?s.asc_putColor(this.getRgbColor({color:"000000",effectId:0})):this._state.StrokeType==c_oAscStrokeType.STROKE_NONE&&s.asc_putColor(this.getRgbColor(this.colorValue2EffectId(this.BorderColor.Color))),s.asc_putWidth(this._pt2mm(this.BorderSize))),i.asc_putStroke(s),this.imgprops.asc_putShapeProperties(i),this.api.asc_setGraphicObjectProps(this.imgprops)}if(t.inputEl)if(n[0].data.offsety<0){var o=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,o),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}else{t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var o=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,o)}this.fireEvent("editcomplete",this)},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var s=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(s),this.BorderSize=s.data.value,this._btnBorderColor=Ext.create("Ext.button.Button",{id:"shape-button-border-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBorderColor.color=t,this._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBorderColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BorderColor={Value:1,Color:t};if(this.api&&this.BorderSize>0&&!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CStroke;this.BorderSize<.01?i.asc_putType(c_oAscStrokeType.STROKE_NONE):(i.asc_putType(c_oAscStrokeType.STROKE_COLOR),i.asc_putColor(this.getRgbColor(this.BorderColor.Color)),i.asc_putWidth(this._pt2mm(this.BorderSize))),r.asc_putStroke(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBorder),this._btnBackColor=Ext.create("Ext.button.Button",{id:"shape-button-back-color",arrowCls:"",width:45,height:22,color:"ffffff",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll();var r,i;t=="transparent"?(this._btnBackColor.color="transparent",r="transparent",i="1px solid #BEBEBE"):(this._btnBackColor.color=t,r=Ext.String.format("#{0}",typeof t=="object"?t.color:t),i="none"),this._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBackColor.btnEl,{"background-color":r,border:i}),this.ShapeColor={Value:1,Color:this._btnBackColor.color};if(this.api&&!this._noApply){var s=new Asc.asc_CShapeProperty,o=new Asc.asc_CShapeFill;this.ShapeColor.Color=="transparent"?(o.asc_putType(c_oAscFill.FILL_TYPE_NOFILL),o.asc_putFill(null)):(o.asc_putType(c_oAscFill.FILL_TYPE_SOLID),o.asc_putFill(new Asc.asc_CFillSolid),o.asc_getFill().asc_putColor(this.getRgbColor(this.ShapeColor.Color))),s.asc_putFill(o),this.imgprops.asc_putShapeProperties(s),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this._arrFillSrc=[this.textColor,this.textGradientFill,this.textImageTexture,this.textPatternFill,this.textNoFill],this.cmbFillSrc=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-fill-src",width:190,editable:!1,store:this._arrFillSrc,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._ShowHideElem([t[0].index==0,t[0].index==2,t[0].index==3,t[0].index==1,t[0].index>=0&&t[0].index<4],[this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,this._TransparencyContainer],[this._FillColorContainerHeight,this._FillImageContainerHeight,this._PatternContainerHeight,this._GradientContainerHeight,this._TransparencyContainerHeight]);switch(t[0].index){case 0:this._state.FillType=c_oAscFill.FILL_TYPE_SOLID;if(!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;this.ShapeColor.Color=="transparent"?(i.asc_putType(c_oAscFill.FILL_TYPE_NOFILL),i.asc_putFill(null)):(i.asc_putType(c_oAscFill.FILL_TYPE_SOLID),i.asc_putFill(new Asc.asc_CFillSolid),i.asc_getFill().asc_putColor(this.getRgbColor(this.ShapeColor.Color))),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}break;case 1:this._state.FillType=c_oAscFill.FILL_TYPE_GRAD;if(!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_GRAD),i.asc_putFill(new Asc.asc_CFillGrad),i.asc_getFill().asc_putGradType(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.asc_getFill().asc_putLinearAngle(l[this.GradLinearDirectionIdx].data.type*6e4),i.asc_getFill().asc_putLinearScale(!0)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(i.asc_getFill().asc_putPositions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.asc_getFill().asc_putColors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}break;case 2:this._state.FillType=c_oAscFill.FILL_TYPE_BLIP;break;case 3:this._state.FillType=c_oAscFill.FILL_TYPE_PATT;if(!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_PATT),i.asc_putFill(new Asc.asc_CFillHatch),i.asc_getFill().asc_putPatternType(this.PatternFillType),i.asc_getFill().asc_putColorFg(this.getRgbColor(this.FGColor.Color)),i.asc_getFill().asc_putColorBg(this.getRgbColor(this.BGColor.Color)),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}break;case 4:this._state.FillType=c_oAscFill.FILL_TYPE_NOFILL;if(!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_NOFILL),i.asc_putFill(null),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillSrc.setValue(this._arrFillSrc[0]),this._FillColorContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:25,width:190,items:[this._btnBackColor]}),this._FillColorContainerHeight=this._FillColorContainer.height,this._btnInsertFromFile=Ext.create("Ext.Button",{id:"shape-button-fill-from-file",text:this.textFromFile,width:90,listeners:{click:function(e){this.api&&this.api.asc_changeShapeImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"shape-button-fill-from-url",text:this.textFromUrl,width:90,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._arrFillType=[this.textStretch,this.textTile],this.cmbFillType=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-fill-type",width:90,editable:!1,store:this._arrFillType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?this.BlipFillType=c_oAscFillBlipType.STRETCH:t[0].index==1&&(this.BlipFillType=c_oAscFillBlipType.TILE);if(this.api&&this._fromTextureCmb!==!0&&this.OriginalFillType==c_oAscFill.FILL_TYPE_BLIP){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_BLIP),i.asc_putFill(new Asc.asc_CFillBlip),i.asc_getFill().asc_putType(this.BlipFillType),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillType.setValue(this._arrFillType[0]),this.controls.push(this.cmbFillType),this._btnTexture=Ext.create("Ext.button.Button",{text:this.textSelectTexture,width:90,cls:"btn-combo-style",pressedCls:"",textAlign:"left",menu:this.textureMenu=Ext.create("Common.component.MenuDataViewPicker",{width:242,height:182,cls:"texture-view",viewData:[],contentWidth:222,listeners:{select:Ext.bind(function(e,t){this._fromTextureCmb=!0,this.cmbFillType.setValue(this._arrFillType[1]),this._fromTextureCmb=!1;if(this.api){var n=new Asc.asc_CShapeProperty,r=new Asc.asc_CShapeFill;r.asc_putType(c_oAscFill.FILL_TYPE_BLIP),r.asc_putFill(new Asc.asc_CFillBlip),r.asc_getFill().asc_putType(c_oAscFillBlipType.TILE),r.asc_getFill().asc_putTextureId(t.data.data.type),n.asc_putFill(r),this.imgprops.asc_putShapeProperties(n),this.api.asc_setGraphicObjectProps(this.imgprops)}this._btnTexture.setText(t.data.name),this.fireEvent("editcomplete",this)},this),hide:function(){e.fireEvent("editcomplete",e)},show:function(e){e.picker.selectByIndex(-1,!1)}}})}),this.controls.push(this._btnTexture),this.textureImage=Ext.create("Ext.container.Container",{id:"shape-texture-img",width:50,height:50}),Ext.define("SSE.model.PatternDataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"imageStyle"},{name:"imageCls"},{name:"title"},{name:"data"},{name:"uid"}]});var o=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imageStyle}" class="{imageCls}"/>',"</div>","</tpl>");this.patternViewData=[];var u=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"SSE.model.PatternDataModel",data:this.patternViewData});this._cmbPattern=Ext.create("Common.component.ComboDataView",{id:"shape-combo-pattern",width:190,height:42,itemWidth:28,itemHeight:28,menuMaxHeight:300,repeatedselect:!0,store:u,dataTpl:o,viewData:[],emptyComboText:this.textEmptyPattern,listeners:{select:function(t,n){if(e.api&&!e._noApply){e.PatternFillType=n.data.data.type;var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_PATT),i.asc_putFill(new Asc.asc_CFillHatch),i.asc_getFill().asc_putPatternType(n.data.data.type),e.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.asc_getFill().asc_putColorFg(e.getRgbColor(e.FGColor.Color)),i.asc_getFill().asc_putColorBg(e.getRgbColor(e.BGColor.Color))),r.asc_putFill(i),e.imgprops.asc_putShapeProperties(r),e.api.asc_setGraphicObjectProps(e.imgprops)}e.fireEvent("editcomplete",e)},menuhide:function(){e.fireEvent("editcomplete",e)},releasecapture:function(t){e.fireEvent("editcomplete",e)}}}),this.controls.push(this._cmbPattern),this._cmbPattern.addCls("shape-pattern"),this._cmbPattern.dataMenu.picker.contentWidth=170,this._cmbPattern.dataMenu.picker.needArrangeSlideItems=!0,this._cmbPattern.dataMenu.picker.arrangeItems=this._arrangeSlideItems,this._cmbPattern.dataMenu.picker.resizeSlideItems=this._resizeSlideItems,this._btnFGColor=Ext.create("Ext.button.Button",{id:"shape-button-foreground-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsFG=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnFGColor.color=t,this._btnFGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnFGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.FGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_PATT),i.asc_putFill(new Asc.asc_CFillHatch),i.asc_getFill().asc_putColorFg(this.getRgbColor(this.FGColor.Color)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.asc_getFill().asc_putPatternType(this.PatternFillType),i.asc_getFill().asc_putColorBg(this.getRgbColor(this.BGColor.Color))),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsFG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsFG),this._btnBGColor=Ext.create("Ext.button.Button",{id:"shape-button-background-color",arrowCls:"",width:45,height:22,color:"ffffff",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBG=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBGColor.color=t,this._btnBGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_PATT),i.asc_putFill(new Asc.asc_CFillHatch),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.asc_getFill().asc_putPatternType(this.PatternFillType),i.asc_getFill().asc_putColorFg(this.getRgbColor(this.FGColor.Color))),i.asc_getFill().asc_putColorBg(this.getRgbColor(this.BGColor.Color)),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBG),this._PatternContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:141,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"label",text:this.strPattern},{xtype:"tbspacer",height:2},this._cmbPattern,{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strForeground,flex:1},this._btnFGColor]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strBackground,flex:1},this._btnBGColor]}]}),this._PatternContainerHeight=this._PatternContainer.height;var a=Ext.bind(function(e){this._cmbPattern.dataMenu.picker.store.getCount()>0&&(this._cmbPattern.fillComboView(this._cmbPattern.dataMenu.picker.store.getAt(0),!0),this.PatternFillType=this.patternViewData[0].data.type,this._cmbPattern.dataMenu.picker.updateScrollPane(),this._PatternContainer.un("show",a))},this);this._PatternContainer.on("show",a),this._arrGradType=[this.textLinear,this.textRadial],this.cmbGradType=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-grad-type",width:90,editable:!1,store:this._arrGradType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?(this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.btnDirection.menu.picker.store.loadData(l),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(l[this.GradLinearDirectionIdx].iconcls):this.btnDirection.setIconCls("")):t[0].index==1&&(this.GradFillType=c_oAscFillGradType.GRAD_PATH,this.btnDirection.menu.picker.store.loadData(c),this.btnDirection.menu.picker.selectByIndex(this.GradRadialDirectionIdx),this.GradRadialDirectionIdx>=0?this.btnDirection.setIconCls(c[this.GradRadialDirectionIdx].iconcls):this.btnDirection.setIconCls(""));if(this.api&&!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_GRAD),i.asc_putFill(new Asc.asc_CFillGrad),i.asc_getFill().asc_putGradType(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.asc_getFill().asc_putLinearAngle(l[this.GradLinearDirectionIdx].data.type*6e4),i.asc_getFill().asc_putLinearScale(!0)),i.asc_getFill().asc_putPositions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.asc_getFill().asc_putColors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),this.cmbGradType.setValue(this._arrGradType[0]);var f=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="item-gradient"/>',"</div>",'<tpl if="separator">','<div class="gradient-separator"></div>',"</tpl>","</tpl>"),l=[{offsetx:0,offsety:0,data:{type:45,subtype:-1},iconcls:"gradient-subtype gradient-left-top"},{offsetx:50,offsety:0,data:{type:90,subtype:4},iconcls:"gradient-subtype gradient-top"},{offsetx:100,offsety:0,data:{type:135,subtype:5},iconcls:"gradient-subtype gradient-right-top"},{offsetx:0,offsety:50,data:{type:0,subtype:6},iconcls:"gradient-subtype gradient-left",separator:!0},{offsetx:100,offsety:50,data:{type:180,subtype:1},iconcls:"gradient-subtype gradient-right"},{offsetx:0,offsety:100,data:{type:315,subtype:2},iconcls:"gradient-subtype gradient-left-bottom"},{offsetx:50,offsety:100,data:{type:270,subtype:3},iconcls:"gradient-subtype gradient-bottom"},{offsetx:100,offsety:100,data:{type:225,subtype:7},iconcls:"gradient-subtype gradient-right-bottom"}];for(var n=0;n<l.length;n++)l[n].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-l[n].offsetx,-l[n].offsety);var c=[{offsetx:100,offsety:150,data:{type:2,subtype:5},iconcls:"gradient-subtype gradient-radial-center"}];for(var n=0;n<c.length;n++)c[n].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-c[n].offsetx,-c[n].offsety);this.btnDirection=Ext.widget("button",{id:"shape-button-direction",width:72,height:58,cls:"btn-wrap-types",iconCls:"gradient-subtype gradient-left",pressedCls:"disablepressed",menuAlign:"tl-bl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:195,height:190,minWidth:50,cls:"gradient-view",dataTpl:f,viewData:l,contentWidth:175,listeners:{select:Ext.bind(function(e,t,n,r){this.btnDirection.setIconCls(t.data.iconcls),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?this.GradLinearDirectionIdx=r:this.GradRadialDirectionIdx=r;if(this.api&&!this._noApply){if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var i=new Asc.asc_CShapeProperty,s=new Asc.asc_CShapeFill;s.asc_putType(c_oAscFill.FILL_TYPE_GRAD),s.asc_putFill(new Asc.asc_CFillGrad),s.asc_getFill().asc_putGradType(this.GradFillType),s.asc_getFill().asc_putLinearAngle(t.data.data.type*6e4),s.asc_getFill().asc_putLinearScale(!0),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(s.asc_getFill().asc_putPositions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),s.asc_getFill().asc_putColors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),i.asc_putFill(s),this.imgprops.asc_putShapeProperties(i),this.api.asc_setGraphicObjectProps(this.imgprops)}Ext.menu.Manager.hideAll()}this.fireEvent("editcomplete",this)},this),hide:Ext.bind(function(){this.fireEvent("editcomplete",this)},this),beforeshow:Ext.bind(function(e){if(e.rendered){var t=e.getHeight();this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&Math.abs(t-190)>0&&(e.picker.contentWidth=175,e.setSize(195,190)),this.GradFillType==c_oAscFillGradType.GRAD_PATH&&Math.abs(t-70)>0&&(e.picker.contentWidth=50,e.setSize(70,70))}},this)}})}),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.controls.push(this.btnDirection),this._btnGradColor=Ext.create("Ext.button.Button",{id:"shape-button-gradient-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsGrad=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnGradColor.color=t,this._btnGradColor.btnEl&&Ext.DomHelper.applyStyles(this._btnGradColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.GradColor.colors[this.GradColor.currentIdx]=t,this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof t=="object"?t.color:t));if(this.api&&!this._noApply){var r=new Asc.asc_CShapeProperty,i=new Asc.asc_CShapeFill;i.asc_putType(c_oAscFill.FILL_TYPE_GRAD),i.asc_putFill(new Asc.asc_CFillGrad),i.asc_getFill().asc_putGradType(this.GradFillType),i.asc_getFill().asc_putColors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.asc_getFill().asc_putLinearAngle(l[this.GradLinearDirectionIdx].data.type*6e4),i.asc_getFill().asc_putLinearScale(!0)),i.asc_getFill().asc_putPositions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3])),r.asc_putFill(i),this.imgprops.asc_putShapeProperties(r),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsGrad.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsGrad);var h=!1,p,d=function(){if(h){var t=new Asc.asc_CShapeProperty,n=new Asc.asc_CShapeFill;n.asc_putType(c_oAscFill.FILL_TYPE_GRAD),n.asc_putFill(new Asc.asc_CFillGrad),n.asc_getFill().asc_putGradType(e.GradFillType),n.asc_getFill().asc_putPositions([e.GradColor.values[0]*1e3,e.GradColor.values[1]*1e3]),e.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(e.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(n.asc_getFill().asc_putLinearAngle(l[e.GradLinearDirectionIdx].data.type*6e4),n.asc_getFill().asc_putLinearScale(!0)),n.asc_getFill().asc_putColors([e.getRgbColor(e.GradColor.colors[0]),e.getRgbColor(e.GradColor.colors[1])])),t.asc_putFill(n),e.imgprops.asc_putShapeProperties(t),e.api.asc_setGraphicObjectProps(e.imgprops),h=!1}};this.sldrGradient=Ext.create("Common.component.MultiSliderGradient",{animate:!1,width:140,values:[0,100],increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-multi-slider-gradient",listeners:{change:Ext.bind(function(e,t,n){this.GradColor.values=e.getValues(),h=!0,this.api&&!this._noApply&&this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,p=setInterval(d,100))},this),changecomplete:Ext.bind(function(e,t,n){clearInterval(p),d(),this.api.setEndPointHistory(),this._sendUndoPoint=!0,Ext.menu.Manager.hideAll()},this),thumbclick:Ext.bind(function(e,t){this.GradColor.currentIdx=t;var n=this.GradColor.colors[this.GradColor.currentIdx];this._btnGradColor.setColor(n),this.colorsGrad.select(n,!1)},this),thumbdblclick:Ext.bind(function(e){this._btnGradColor.showMenu()},this)}}),this.controls.push(this.sldrGradient),this._GradientContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:150,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:100,height:80,items:[{xtype:"label",text:this.textStyle},{xtype:"tbspacer",height:2},this.cmbGradType,{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",flex:1},{xtype:"container",layout:"vbox",height:80,items:[{xtype:"label",text:this.textDirection},{xtype:"tbspacer",height:2},this.btnDirection]}]},{xtype:"tbspacer",height:3},{xtype:"label",text:this.textGradient,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},{xtype:"container",layout:{type:"hbox",align:"top"},width:190,height:35,items:[this.sldrGradient,{xtype:"tbspacer",flex:1},this._btnGradColor]}]}),this._GradientContainerHeight=this._GradientContainer.height;var v=function(){if(h!==undefined){var t=new Asc.asc_CShapeProperty,n=new Asc.asc_CShapeFill;n.asc_putTransparent(h*2.55),t.asc_putFill(n),e.imgprops.asc_putShapeProperties(t),e.api.asc_setGraphicObjectProps(e.imgprops),h=undefined}};this.numTransparency=Ext.create("Common.component.MetricSpinner",{id:"shape-spin-transparency",readOnly:!1,step:1,width:65,defaultUnit:"%",value:"100 %",maxValue:100,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this.sldrTransparency.suspendEvents(!1),this.sldrTransparency.setValue(e.getNumberValue()),this.sldrTransparency.resumeEvents();if(this.api){var i=e.getNumberValue(),s=new Asc.asc_CShapeProperty,o=new Asc.asc_CShapeFill;o.asc_putTransparent(i*2.55),s.asc_putFill(o),this.imgprops.asc_putShapeProperties(s),this.api.asc_setGraphicObjectProps(this.imgprops)}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numTransparency),this.sldrTransparency=Ext.create("Ext.slider.Single",{animate:!1,width:80,value:100,increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-slider",listeners:{change:Ext.bind(function(e,t,n,r){h=t,this.numTransparency.suspendEvents(!1),this.numTransparency.setValue(t),this.numTransparency.resumeEvents(),this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,p=setInterval(v,100))},this),changecomplete:Ext.bind(function(e,t,n,r){clearInterval(p),v(),this.api.setEndPointHistory(),this._sendUndoPoint=!0},this)}}),this.controls.push(this.sldrTransparency),this._TransparencyContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:55,width:190,items:[{xtype:"tbspacer",height:10},{xtype:"label",text:this.strTransparency,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:2},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:"0",style:"margin: 2px 3px 0 0"},this.sldrTransparency,{xtype:"label",text:"100",style:"margin: 2px 0 0 3px"},{xtype:"tbspacer",flex:1},this.numTransparency]}]}),this._TransparencyContainerHeight=this._TransparencyContainer.height,this._FillImageContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:120,width:190,hidden:!0,items:[{xtype:"container",layout:"hbox",width:190,items:[this._btnInsertFromFile,{xtype:"tbspacer",flex:1},this._btnInsertFromUrl]},{xtype:"tbspacer",height:11},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:90,height:80,items:[this.cmbFillType,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textTexture},{xtype:"tbspacer",height:2},this._btnTexture]},{xtype:"tbspacer",flex:1},{xtype:"container",cls:"texture-img-container",layout:"vbox",width:90,height:80,items:[this.textureImage]}]}]}),this._FillImageContainerHeight=this._FillImageContainer.height,this._FillPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:45,width:190,items:[{xtype:"label",text:this.strFill,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},this.cmbFillSrc]}),this._btnChangeShape=Ext.create("Ext.button.Button",{id:"shape-button-change",width:45,iconCls:"btn-icon-change-shape",cls:"asc-right-panel-edit-btn",tooltip:this.tipShapeArrange,menu:{showSeparator:!1,bodyCls:"no-icons",items:[],listeners:{hide:{fn:function(){e.fireEvent("editcomplete",e)}}},plugins:[{ptype:"menuexpand"}]}}),this._StrokePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:51,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:41,layout:{type:"table",columns:2,tdAttrs:{style:"vertical-align: middle;"}},items:[{xtype:"label",text:this.strSize,style:"display: block;",width:80},{xtype:"label",text:this.strColor,style:"display: block;",width:80},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbBorderSize,this._btnBorderColor]}]}),this._ChangeContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:36,width:"100%",items:[{xtype:"tbspacer",height:3},{xtype:"container",height:30,width:190,layout:"hbox",items:[{xtype:"label",text:this.strChange,margin:"2px 0 0 0",style:"font-weight: bold;margin-top: 1px;",flex:1},{xtype:"tbspacer",width:7},this._btnChangeShape,{xtype:"tbspacer",width:5}]}]}),this.items=[{xtype:"tbspacer",height:7},this._FillPanel,{xtype:"tbspacer",height:7},this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,this._TransparencyContainer,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.strStroke},this._StrokePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this._ChangeContainer,{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:195,items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="shape-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("shape-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setApi:function(e){this.api=e,this.api&&(this.api.asc_setInterfaceDrawImagePlaceShape("shape-texture-img"),this.api.asc_registerCallback("asc_onInitStandartTextures",Ext.bind(this._onInitStandartTextures,this)))},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new Asc.asc_CColor;return n.asc_putType(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.asc_putR(t>>16),n.asc_putG((t&65280)>>8),n.asc_putB(t&255),n.asc_putA(255),e.effectId!==undefined&&n.asc_putValue(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},colorValue2EffectId:function(e){if(typeof e=="object"&&e.effectValue!==undefined&&this.effectcolors){var t=e.effectValue;for(var n=0;n<this.effectcolors.length;n++)if(this.effectcolors[n].effectValue===e.effectValue&&e.color.toUpperCase()===this.effectcolors[n].color.toUpperCase()){e.effectId=this.effectcolors[n].effectId;break}}return e},_pt2mm:function(e){return e*25.4/72},_mm2pt:function(e){return e*72/25.4},FillAutoShapes:function(){var e=Ext.getStore("ShapeGroups"),t=this,n=e.getCount();t._btnChangeShape.menu.removeAll();for(var r=0;r<n;r++){if(r==n-2)continue;var i=e.getAt(r),s=Ext.widget("menuitem",{text:i.data.groupName,hideOnClick:!1,cls:"menu-item-noicon",menuAlign:"tl-tl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:i.data.groupWidth,height:i.data.groupHeight,store:i.data.groupStore,viewData:[],contentWidth:i.data.groupWidth-20,listeners:{select:Ext.bind(function(e,n){t.api&&t.api.asc_changeShapeType(n.data.data.shapeType)},this),hide:function(){t.fireEvent("editcomplete",t)},show:function(e){e.picker.selectByIndex(-1,!1)}},plugins:[{ptype:"menuexpand"}]}),deferExpandMenu:function(){if(!this.menu.rendered||!this.menu.isVisible())this.parentMenu.activeChild=this.menu,this.menu.parentItem=this,this.menu.parentMenu=this.menu.ownerCt=this.parentMenu,this.menu.showBy(this,this.menuAlign,[-this.menu.width,0])}});t._btnChangeShape.menu.add(s)}},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""&&t.BlipFillType!==null){var i=new Asc.asc_CShapeProperty,s=new Asc.asc_CShapeFill;s.asc_putType(c_oAscFill.FILL_TYPE_BLIP),s.asc_putFill(new Asc.asc_CFillBlip),s.asc_getFill().asc_putType(t.BlipFillType),s.asc_getFill().asc_putUrl(n.value),i.asc_putFill(s),t.imgprops.asc_putShapeProperties(i),t.api.asc_setGraphicObjectProps(t.imgprops)}}},_ShowHideElem:function(e,t,n){var r=this.getHeight(),i=0;for(var s=0;s<e.length;s++)e[s]&&!t[s].isVisible()&&(t[s].show(),i+=n[s]),!e[s]&&t[s].isVisible()&&(i-=n[s],t[s].hide());this.setHeight(r+i),this.initialHeight=r+i,this.ownerCt.setHeight(this.initialHeight)},ChangeSettings:function(e){this._initSettings&&this.createDelayedElements(),this._initSettings=!1,this.imgprops==null&&(this.imgprops=new Asc.asc_CImgProperty);if(e&&e.asc_getShapeProperties()){var t=e.asc_getShapeProperties();this._originalProps=t,this.SuspendEvents(),this._noApply=!0,this.disableFillPanels(!t.asc_getCanFill());var n=null,r=t.asc_getFill(),i=r.asc_getType(),s=null,o=r.asc_getTransparent();if(Math.abs(this._state.Transparency-o)>.001||Math.abs(this.numTransparency.getNumberValue()-o)>.001||(this._state.Transparency===null||o===null)&&(this._state.Transparency!==o||this.numTransparency.getNumberValue()!==o))o!==undefined&&(this.sldrTransparency.setValue(o===null?100:o/255*100),this.numTransparency.setValue(this.sldrTransparency.getValue())),this._state.Transparency=o;if(r===null||i===null||i==c_oAscFill.FILL_TYPE_NOFILL)this.OriginalFillType=c_oAscFill.FILL_TYPE_NOFILL;else if(i==c_oAscFill.FILL_TYPE_SOLID)r=r.asc_getFill(),s=r.asc_getColor(),s?s.asc_getType()==c_oAscColor.COLOR_TYPE_SCHEME?this.ShapeColor={Value:1,Color:{color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()),effectValue:s.asc_getValue()}}:this.ShapeColor={Value:1,Color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB())}:this.ShapeColor={Value:0,Color:"transparent"},this.FGColor=this.ShapeColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.ShapeColor.Color)}:{Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID;else if(i==c_oAscFill.FILL_TYPE_BLIP)r=r.asc_getFill(),this.BlipFillType=r.asc_getType(),this._state.BlipFillType!==this.BlipFillType&&(this.BlipFillType==c_oAscFillBlipType.STRETCH?this.cmbFillType.setValue(this._arrFillType[0]):this.BlipFillType==c_oAscFillBlipType.TILE?this.cmbFillType.setValue(this._arrFillType[1]):this.cmbFillType.setValue(""),this._state.BlipFillType=this.BlipFillType),this.OriginalFillType=c_oAscFill.FILL_TYPE_BLIP;else if(i==c_oAscFill.FILL_TYPE_PATT){r=r.asc_getFill(),this.PatternFillType=r.asc_getPatternType();if(this._state.PatternFillType!==this.PatternFillType){var u=this._cmbPattern.dataMenu.picker.store.findBy(function(e,t){return e.data.data.type===this.PatternFillType},this);this._cmbPattern.selectByIndex(u),this._state.PatternFillType=this.PatternFillType}s=r.asc_getColorFg(),s?s.asc_getType()==c_oAscColor.COLOR_TYPE_SCHEME?this.FGColor={Value:1,Color:{color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()),effectValue:s.asc_getValue()}}:this.FGColor={Value:1,Color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB())}:this.FGColor={Value:1,Color:"000000"},s=r.asc_getColorBg(),s?s.asc_getType()==c_oAscColor.COLOR_TYPE_SCHEME?this.BGColor={Value:1,Color:{color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()),effectValue:s.asc_getValue()}}:this.BGColor={Value:1,Color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB())}:this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_PATT,this.ShapeColor=this.FGColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.FGColor.Color)}:{Value:1,Color:"ffffff"}}else if(i==c_oAscFill.FILL_TYPE_GRAD){r=r.asc_getFill();var a=r.asc_getGradType();if(this._state.GradFillType!==a||this.GradFillType!==a)this.GradFillType=a,n=undefined,this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?n=this.cmbGradType.getStore().getAt(0):this.GradFillType==c_oAscFillGradType.GRAD_PATH?n=this.cmbGradType.getStore().getAt(1):(this.cmbGradType.setValue(""),this.btnDirection.setIconCls("")),n&&(this.cmbGradType.select(n),this.cmbGradType.fireEvent("select",this.cmbGradType,[n])),this._state.GradFillType=this.GradFillType;if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var f=Math.floor(r.asc_getLinearAngle()/6e4),l,c=this.btnDirection.menu.picker.store.findBy(function(e,t){return l=e.data.iconcls,e.data.data.type===f},this);c!==this.GradLinearDirectionIdx&&(this.GradLinearDirectionIdx=c,this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx,!1),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(l):this.btnDirection.setIconCls(""))}var h=r.asc_getColors();h&&h.length>0&&(s=h[0],s?s.asc_getType()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[0]={color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()),effectValue:s.asc_getValue()},this.colorValue2EffectId(this.GradColor.colors[0])):this.GradColor.colors[0]=this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()):this.GradColor.colors[0]="000000",s=h[1],s?s.asc_getType()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[1]={color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()),effectValue:s.asc_getValue()},this.colorValue2EffectId(this.GradColor.colors[1])):this.GradColor.colors[1]=this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()):this.GradColor.colors[1]="ffffff");var p=r.asc_getPositions();if(p&&p.length>0){var d=p[0];d!==null&&(d/=1e3,this.GradColor.values[0]=d),d=p[1],d!==null&&(d/=1e3,this.GradColor.values[1]=d)}this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[0]=="object"?this.GradColor.colors[0].color:this.GradColor.colors[0]),0),this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[1]=="object"?this.GradColor.colors[1].color:this.GradColor.colors[1]),1),this.sldrGradient.setValue(0,this.GradColor.values[0]),this.sldrGradient.setValue(1,this.GradColor.values[1]),this.OriginalFillType=c_oAscFill.FILL_TYPE_GRAD}if(this._state.FillType!==this.OriginalFillType){switch(this.OriginalFillType){case c_oAscFill.FILL_TYPE_SOLID:n=this.cmbFillSrc.getStore().getAt(0);break;case c_oAscFill.FILL_TYPE_GRAD:n=this.cmbFillSrc.getStore().getAt(1);break;case c_oAscFill.FILL_TYPE_BLIP:n=this.cmbFillSrc.getStore().getAt(2);break;case c_oAscFill.FILL_TYPE_PATT:n=this.cmbFillSrc.getStore().getAt(3);break;case c_oAscFill.FILL_TYPE_NOFILL:n=this.cmbFillSrc.getStore().getAt(4)}n&&(this.cmbFillSrc.select(n),this.cmbFillSrc.fireEvent("select",this.cmbFillSrc,[n])),this._state.FillType=this.OriginalFillType}this._btnTexture.setText(this.textSelectTexture);var v=typeof this.ShapeColor.Color,m=typeof this._state.ShapeColor;if(v!==m||v=="object"&&(this.ShapeColor.Color.effectValue!==this._state.ShapeColor.effectValue||this._state.ShapeColor.color.indexOf(this.ShapeColor.Color.color)<0)||v!="object"&&this._state.ShapeColor.indexOf(this.ShapeColor.Color)<0){this._btnBackColor.setColor(this.ShapeColor.Color);if(typeof this.ShapeColor.Color=="object"){for(var g=0;g<10;g++)if(this.ThemeValues[g]==this.ShapeColor.Color.effectValue){this.colorsBack.select(this.ShapeColor.Color,!1);break}}else this.colorsBack.select(this.ShapeColor.Color,!1);this._state.ShapeColor=this.ShapeColor.Color}var y=t.asc_getStroke(),b=y.asc_getType();y?b==c_oAscStrokeType.STROKE_COLOR?(s=y.asc_getColor(),s?s.asc_getType()==c_oAscColor.COLOR_TYPE_SCHEME?this.BorderColor={Value:1,Color:{color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB()),effectValue:s.asc_getValue()}}:this.BorderColor={Value:1,Color:this.getHexColor(s.asc_getR(),s.asc_getG(),s.asc_getB())}:this.BorderColor={Value:1,Color:"transparent"}):this.BorderColor={Value:1,Color:"transparent"}:(b=null,this.BorderColor={Value:0,Color:"transparent"}),v=typeof this.BorderColor.Color,m=typeof this._state.StrokeColor;if(v!==m||v=="object"&&(this.BorderColor.Color.effectValue!==this._state.StrokeColor.effectValue||this._state.StrokeColor.color.indexOf(this.BorderColor.Color.color)<0)||v!="object"&&(this._state.StrokeColor.indexOf(this.BorderColor.Color)<0||typeof this._btnBorderColor.color=="object")){this._btnBorderColor.setColor(this.BorderColor.Color);if(typeof this.BorderColor.Color=="object"){for(var g=0;g<10;g++)if(this.ThemeValues[g]==this.BorderColor.Color.effectValue){this.colorsBorder.select(this.BorderColor.Color,!1);break}}else this.colorsBorder.select(this.BorderColor.Color,!1);this._state.StrokeColor=this.BorderColor.Color}if(this._state.StrokeType!==b||b==c_oAscStrokeType.STROKE_COLOR){if(b==c_oAscStrokeType.STROKE_COLOR){var w=y.asc_getWidth();if(Math.abs(this._state.StrokeWidth-w)>.001||(this._state.StrokeWidth===null||w===null)&&this._state.StrokeWidth!==w){this._state.StrokeWidth=w;var c=-1;w!==null&&(w=this._mm2pt(w),Ext.each(this.cmbBorderSize.getStore().data.items,function(e,t){if(w<e.data.value+.01&&w>e.data.value-.01)return c=t,!1})),c>-1?(n=this.cmbBorderSize.getStore().getAt(c),this.cmbBorderSize.select(n),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[n])):(n={borderstyle:"",text:"",value:w,offsety:-1},n=this.cmbBorderSize.getStore().add(n),this.cmbBorderSize.select(n[0]),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[n[0]]),this.cmbBorderSize.getStore().remove(n[0]))}}else b==c_oAscStrokeType.STROKE_NONE?(this._state.StrokeWidth=0,n=this.cmbBorderSize.getStore().getAt(0),this.cmbBorderSize.select(n),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[n])):(this._state.StrokeWidth=null,n={borderstyle:"",text:"",value:-1,offsety:-1},n=this.cmbBorderSize.getStore().add(n),this.cmbBorderSize.select(n[0]),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[n[0]]),this.cmbBorderSize.getStore().remove(n[0]));this._state.StrokeType=b}v=typeof this.FGColor.Color,m=typeof this._state.FGColor;if(v!==m||v=="object"&&(this.FGColor.Color.effectValue!==this._state.FGColor.effectValue||this._state.FGColor.color.indexOf(this.FGColor.Color.color)<0)||v!="object"&&this._state.FGColor.indexOf(this.FGColor.Color)<0){this._btnFGColor.setColor(this.FGColor.Color);if(typeof this.FGColor.Color=="object"){for(var g=0;g<10;g++)if(this.ThemeValues[g]==this.FGColor.Color.effectValue){this.colorsFG.select(this.FGColor.Color,!1);break}}else this.colorsFG.select(this.FGColor.Color,!1);this._state.FGColor=this.FGColor.Color}v=typeof this.BGColor.Color,m=typeof this._state.BGColor;if(v!==m||v=="object"&&(this.BGColor.Color.effectValue!==this._state.BGColor.effectValue||this._state.BGColor.color.indexOf(this.BGColor.Color.color)<0)||v!="object"&&this._state.BGColor.indexOf(this.BGColor.Color)<0){this._btnBGColor.setColor(this.BGColor.Color);if(typeof this.BGColor.Color=="object"){for(var g=0;g<10;g++)if(this.ThemeValues[g]==this.BGColor.Color.effectValue){this.colorsBG.select(this.BGColor.Color,!1);break}}else this.colorsBG.select(this.BGColor.Color,!1);this._state.BGColor=this.BGColor.Color}s=this.GradColor.colors[this.GradColor.currentIdx],v=typeof s,m=typeof this._state.GradColor;if(v!==m||v=="object"&&(s.effectValue!==this._state.GradColor.effectValue||this._state.GradColor.color.indexOf(s.color)<0)||v!="object"&&this._state.GradColor.indexOf(s)<0){this._btnGradColor.setColor(s);if(typeof s=="object"){for(var g=0;g<10;g++)if(this.ThemeValues[g]==s.effectValue){this.colorsGrad.select(s,!1);break}}else this.colorsGrad.select(s,!1);this._state.GradColor=s}this._noApply=!1,this.ResumeEvents()}},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this._initSettings||(this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t),this.colorsFG.updateColors(e,t),this.colorsBG.updateColors(e,t),this.colorsGrad.updateColors(e,t))},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.asc_getGraphicObjectProps();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].asc_getObjectType();if(c_oAscTypeSelectElement.Image==i){s=r[o].asc_getObjectValue(),n=Ext.create("SSE.view.ShapeSettingsAdvanced",{}),n.updateMetricUnit(),n.setSettings(s);break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,t,n){t==1&&n&&this.api.asc_setGraphicObjectProps(n),this.fireEvent("editcomplete",this)},this),!1),n.show())},_onInitStandartTextures:function(e){var t=this;if(!Ext.isEmpty(e)){var n=this.textureMenu.picker.store;if(n){if(n.count()>0)return;var r=[];Ext.each(e,function(e){r.push({imageUrl:e.asc_getImage(),name:t.textureNames[e.asc_getId()],data:{type:e.asc_getId()}})}),n.add(r)}}},_arrangeSlideItems:function(){if(!this.needArrangeSlideItems)return;var e=this;if(this.getEl()){var t=this.getEl().down(".jspPane");if(t&&t.getHeight()>0&&this.getEl().getHeight()>0)var n=0,r=setInterval(function(){e.needArrangeSlideItems&&e.resizeSlideItems();if(!e.needArrangeSlideItems){clearInterval(r),e.doLayout();return}n++>5&&clearInterval(r)},100)}},_resizeSlideItems:function(){var e=5,t="div.thumb-wrap",n=this.getEl(),r=n.query(t),i=0;while(i<r.length){var s=0;for(var o=i;o<i+e;o++){if(o>=r.length)break;var u=Ext.get(r[o]),a=u.getHeight();if(a<28)return;a<s?u.setHeight(s):s=a}i+=e}r.length>0&&(this.needArrangeSlideItems=!1)},hideMenus:function(){this._btnBorderColor.hideMenu(),this._btnBackColor.hideMenu(),this._btnTexture.hideMenu(),this._btnChangeShape.hideMenu(),this._btnBGColor.hideMenu(),this._btnFGColor.hideMenu(),this._cmbPattern.dataMenu.hide(),this.btnDirection.hideMenu(),this._btnGradColor.hideMenu()},createDelayedElements:function(){var e=[0,1,3,2,4,53,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,22,23,24,25,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,49,50,51,52];this.patternViewData=[];for(var t=0;t<13;t++)for(var n=0;n<4;n++){var r=t*4+n;this.patternViewData[r]={offsetx:n*28,offsety:t*28,data:{type:e[r]}}}this.patternViewData.splice(this.patternViewData.length-2,2);for(var t=0;t<this.patternViewData.length;t++)this.patternViewData[t].imageCls="item-combo-pattern",this.patternViewData[t].imageStyle=Ext.String.format("background-position: {0}px {1}px;",-this.patternViewData[t].offsetx,-this.patternViewData[t].offsety),this.patternViewData[t].uid=Ext.id();this._cmbPattern.dataMenu.picker.store.loadData(this.patternViewData),this.FillAutoShapes(),this.effectcolors&&this.standartcolors&&(this.colorsBorder.updateColors(this.effectcolors,this.standartcolors),this.colorsBack.updateColors(this.effectcolors,this.standartcolors),this.colorsFG.updateColors(this.effectcolors,this.standartcolors),this.colorsBG.updateColors(this.effectcolors,this.standartcolors),this.colorsGrad.updateColors(this.effectcolors,this.standartcolors))},disableFillPanels:function(e){this._state.DisabledFillPanels!==e&&(this._state.DisabledFillPanels=e,this._FillPanel.setDisabled(e),this._FillColorContainer.setDisabled(e),this._FillImageContainer.setDisabled(e),this._PatternContainer.setDisabled(e),this._GradientContainer.setDisabled(e),this._TransparencyContainer.setDisabled(e))},txtTitle:"Autoshape",txtNoBorders:"No Line",strStroke:"Stroke",strColor:"Color",strSize:"Size",strChange:"Change Autoshape",strFill:"Fill",textColor:"Color Fill",textImageTexture:"Picture or Texture",textTexture:"From Texture",textFromUrl:"From URL",textFromFile:"From File",textStretch:"Stretch",textTile:"Tile",txtCanvas:"Canvas",txtCarton:"Carton",txtDarkFabric:"Dark Fabric",txtGrain:"Grain",txtGranite:"Granite",txtGreyPaper:"Grey Paper",txtKnit:"Knit",txtLeather:"Leather",txtBrownPaper:"Brown Paper",txtPapyrus:"Papyrus",txtWood:"Wood",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textAdvanced:"Show advanced settings",strTransparency:"Opacity",textNoFill:"No Fill",textSelectTexture:"Select",textGradientFill:"Gradient Fill",textPatternFill:"Pattern",strBackground:"Background color",strForeground:"Foreground color",strPattern:"Pattern",textEmptyPattern:"No Pattern",textLinear:"Linear",textRadial:"Radial",textDirection:"Direction",textStyle:"Style",textGradient:"Gradient"});var c_paragraphLinerule={LINERULE_LEAST:0,LINERULE_AUTO:1,LINERULE_EXACT:2};Ext.define("SSE.view.ParagraphSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.sseparagraphsettings",height:176,requires:["Ext.DomHelper","Ext.button.Button","Ext.form.Label","Ext.container.Container","Ext.toolbar.Spacer","Common.component.MetricSpinner","Ext.form.field.ComboBox","SSE.view.ParagraphSettingsAdvanced"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},setApi:function(e){this.api=e,this.api.asc_registerCallback("asc_onParaSpacingLine",Ext.bind(this._onLineSpacing,this))},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._state={LineRuleIdx:1,LineHeight:1.5,LineSpacingBefore:0,LineSpacingAfter:.35},this._arrLineRule=[this.textAtLeast,this.textAuto,this.textExact],this._arrLineDefaults=[[5,"cm",.03,.01],[1,"",.5,.01],[5,"cm",.03,.01]],this.cmbLineRule=Ext.create("Ext.form.field.ComboBox",{id:"table-combo-line-rule",width:85,editable:!1,store:this._arrLineRule,mode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this.api&&this.api.asc_putPrLineSpacing(t[0].index,this._arrLineDefaults[t[0].index][0]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t[0].index][1]),this.numLineHeight.setMinValue(this._arrLineDefaults[t[0].index][2]),this.numLineHeight.setStep(this._arrLineDefaults[t[0].index][3]),this.fireEvent("editcomplete",this)},this)}}),this.cmbLineRule.setValue(this._arrLineRule[1]),this.controls.push(this.cmbLineRule),this.numLineHeight=Ext.widget("commonmetricspinner",{id:"paragraph-spin-line-height",readOnly:!1,step:.01,width:85,value:"1.5",defaultUnit:"",maxValue:132,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){if(this.cmbLineRule.getValue()=="")return;var i=c_paragraphLinerule.LINERULE_AUTO;for(var s=0;s<this._arrLineRule.length;s++)if(this.cmbLineRule.getValue()==this._arrLineRule[s]){i=s;break}this.api&&this.api.asc_putPrLineSpacing(i,i==c_paragraphLinerule.LINERULE_AUTO?e.getNumberValue():Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numLineHeight),this.numSpacingBefore=Ext.create("Common.component.MetricSpinner",{id:"paragraph-spin-spacing-before",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.88,minValue:0,allowAuto:!0,autoText:this.txtAutoText,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=e.getNumberValue();i<0?this.api.asc_putLineSpacingBeforeAfter(0,-1):this.api.asc_putLineSpacingBeforeAfter(0,Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numSpacingBefore),this.numSpacingAfter=Ext.create("Common.component.MetricSpinner",{id:"paragraph-spin-spacing-after",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0.35 cm",maxValue:55.88,minValue:0,allowAuto:!0,autoText:this.txtAutoText,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=e.getNumberValue();i<0?this.api.asc_putLineSpacingBeforeAfter(1,-1):this.api.asc_putLineSpacingBeforeAfter(1,Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numSpacingAfter),this._SpacingPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:107,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:41,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;vertical-align: middle;"}},items:[{xtype:"label",text:this.strLineHeight,style:"display: block;",width:85},{xtype:"label",text:this.textAt,style:"display: block;",width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbLineRule,this.numLineHeight]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:48,style:"float:left;"},items:[{items:[{xtype:"label",text:this.strSpacingBefore,width:85},{xtype:"tbspacer",height:3},this.numSpacingBefore]},{items:[{xtype:"label",text:this.strSpacingAfter,width:85},{xtype:"tbspacer",height:3},this.numSpacingAfter]}]}]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.strParagraphSpacing},this._SpacingPanel,{xtype:"tbspacer",height:3},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:"100%",items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="paragraph-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("paragraph-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},_onLineSpacing:function(e){var t=e.asc_getLineRule(),n=e.asc_getLine();this.numLineHeight.suspendEvents(!1),this.cmbLineRule.suspendEvents(!1),this._state.LineRuleIdx!==t&&(this.cmbLineRule.setValue(t!==null?this._arrLineRule[t]:""),this.numLineHeight.setMinValue(this._arrLineDefaults[t!==null?t:1][2]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t!==null?t:1][1]),this.numLineHeight.setStep(this._arrLineDefaults[t!==null?t:1][3]),this._state.LineRuleIdx=t);if(Math.abs(this._state.LineHeight-n)>.001||(this._state.LineHeight===null||n===null)&&this._state.LineHeight!==n){var r="";t==c_paragraphLinerule.LINERULE_AUTO?r=n:t!==null&&n!==null&&(r=Common.MetricSettings.fnRecalcFromMM(n)),this.numLineHeight.setValue(r!==null?r:""),this._state.LineHeight=n}this.numLineHeight.resumeEvents(),this.cmbLineRule.resumeEvents()},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){this.SuspendEvents();var t={Line:e.asc_getSpacing().asc_getLine(),Before:e.asc_getSpacing().asc_getBefore(),After:e.asc_getSpacing().asc_getAfter(),LineRule:e.asc_getSpacing().asc_getLineRule()};this._state.LineRuleIdx!==t.LineRule&&(this.cmbLineRule.setValue(t.LineRule!==null?this._arrLineRule[t.LineRule]:""),this.numLineHeight.setMinValue(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][2]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][1]),this.numLineHeight.setStep(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][3]),this._state.LineRuleIdx=t.LineRule);if(Math.abs(this._state.LineHeight-t.Line)>.001||(this._state.LineHeight===null||t.Line===null)&&this._state.LineHeight!==t.Line){var n="";t.LineRule==c_paragraphLinerule.LINERULE_AUTO?n=t.Line:t.LineRule!==null&&t.Line!==null&&(n=Common.MetricSettings.fnRecalcFromMM(t.Line)),this.numLineHeight.setValue(n!==null?n:""),this._state.LineHeight=t.Line}if(Math.abs(this._state.LineSpacingBefore-t.Before)>.001||(this._state.LineSpacingBefore===null||t.Before===null)&&this._state.LineSpacingBefore!==t.Before)this.numSpacingBefore.setValue(t.Before!==null?t.Before<0?t.Before:Common.MetricSettings.fnRecalcFromMM(t.Before):""),this._state.LineSpacingBefore=t.Before;if(Math.abs(this._state.LineSpacingAfter-t.After)>.001||(this._state.LineSpacingAfter===null||t.After===null)&&this._state.LineSpacingAfter!==t.After)this.numSpacingAfter.setValue(t.After!==null?t.After<0?t.After:Common.MetricSettings.fnRecalcFromMM(t.After):""),this._state.LineSpacingAfter=t.After;this.ResumeEvents()}},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];if(n.id=="paragraph-spin-line-height")continue;n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}this._arrLineDefaults[2][1]=this._arrLineDefaults[0][1]=Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],this._arrLineDefaults[2][2]=this._arrLineDefaults[0][2]=parseFloat(Common.MetricSettings.fnRecalcFromMM(.3).toFixed(2)),this._arrLineDefaults[2][3]=this._arrLineDefaults[0][3]=Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1,this._state.LineRuleIdx!==null&&(this.numLineHeight.setDefaultUnit(this._arrLineDefaults[this._state.LineRuleIdx][1]),this.numLineHeight.setStep(this._arrLineDefaults[this._state.LineRuleIdx][3]))},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.asc_getGraphicObjectProps();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].asc_getObjectType(),s=r[o].asc_getObjectValue();if(c_oAscTypeSelectElement.Paragraph==i){n=Ext.create("SSE.view.ParagraphSettingsAdvanced"),n.updateMetricUnit(),n.setSettings({paragraphProps:s,api:t.api});break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,n,r){n==1&&r&&t.api.asc_setGraphicObjectProps(r.paragraphProps)},this),!1),n.addListener("close",function(){t.fireEvent("editcomplete",t)},!1),n.show())},createDelayedElements:function(){this.updateMetricUnit()},strParagraphSpacing:"Spacing",strLineHeight:"Line Spacing",strSpacingBefore:"Before",strSpacingAfter:"After",textAuto:"Multiple",textAtLeast:"At least",textExact:"Exactly",textAt:"At",txtTitle:"Paragraph",txtAutoText:"Auto",textAdvanced:"Show advanced settings"}),Ext.define("SSE.view.RightPanel",{extend:"Ext.container.Container",alias:"widget.sserightpanel",width:220,layout:{type:"auto"},autoScroll:!0,cls:"asc-right-panel-container",preventHeader:!0,requires:["Ext.toolbar.Toolbar","Ext.container.Container","Common.plugin.ScrollPane","SSE.view.ImageSettings","SSE.view.ShapeSettings","SSE.view.ParagraphSettings","Ext.button.Button","Ext.panel.Panel"],uses:["Ext.DomHelper","Ext.util.Cookies"],listeners:{afterrender:function(){var e=this.ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeRightPanels,this))}},resizeRightPanels:function(e){this.doComponentLayout()},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=this;e.editMode=!0,e.minimizedMode=!0,e.plugins=[{ptype:"scrollpane",pluginId:"scrollpane",areaSelector:".x-container",settings:{enableKeyboardNavigation:!0,verticalGutter:0}}],e.callParent(arguments)},updateScrollPane:function(){var e=this;e.getPlugin("scrollpane").updateScrollPane()},onFocusObject:function(e){if(!this.editMode)return;for(var t=0;t<this._settings.length;t++)this._settings[t]&&(this._settings[t].hidden=1);for(t=0;t<e.length;t++){var n=e[t].asc_getObjectType();if(n>=this._settings.length||this._settings[n]===undefined)continue;var r=e[t].asc_getObjectValue();n==c_oAscTypeSelectElement.Image&&r.asc_getShapeProperties()!==null&&(n=c_oAscTypeSelectElement.Shape),this._settings[n].props=r,this._settings[n].hidden=0}var i=-1,s,o=-1;for(t=0;t<this._settings.length;t++){if(this._settings[t]===undefined)continue;this._settings[t].hidden?(this._settings[t].btn.isDisabled()||this._settings[t].btn.setDisabled(!0),this.TabPanel.getLayout().getActiveItem()==this._settings[t].panel&&(s=-1)):(this._settings[t].btn.isDisabled()&&this._settings[t].btn.setDisabled(!1),i=t,this._settings[t].needShow?(this._settings[t].needShow=!1,o=t):this.TabPanel.getLayout().getActiveItem()==this._settings[t].panel&&(s=t))}if(!this.minimizedMode){var u;o>-1?u=o:i>=0&&s<0?u=i:s>=0&&(u=s),u!==undefined&&(this._settings[u].btn.pressed?this._settings[u].panel.ChangeSettings&&this._settings[u].panel.ChangeSettings.call(this._settings[u].panel,this._settings[u].props):this._settings[u].btn.toggle())}this._settings[c_oAscTypeSelectElement.Image].needShow=!1},onInsertImage:function(){this._settings[c_oAscTypeSelectElement.Image].needShow=!0},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this.ShapePanel&&this.ShapePanel.SendThemeColors(e,t)},setApi:function(e){return this.api=e,this},setMode:function(e){this.editMode=e.isEdit},FillAutoShapes:function(){this.ShapePanel.FillAutoShapes()},hideMenus:function(){for(var e=0;e<this._settings.length;e++){if(this._settings[e]===undefined)continue;Ext.isDefined(this._settings[e].panel.hideMenus)&&this._settings[e].panel.hideMenus()}},updateMetricUnit:function(){this.ImagePanel.updateMetricUnit(),this.ParagraphPanel.updateMetricUnit()},_onSelectionChanged:function(e){var t=e.asc_getLocked();this._settings.prevDisabled!=t&&(this._settings.prevDisabled=t,this._settings.forEach(function(e){e.panel[t?"disable":"enable"]()}))},createDelayedElements:function(){var e=this;e.panelHolder=Ext.create("Ext.container.Container",{layout:{type:"anchor"},items:[e.TabPanel=Ext.create("Ext.panel.Panel",{hidden:!0,id:"view-tab-panel",cls:"asc-right-tabpanel",preventHeader:!0,layout:"card",items:[e.ShapePanel=Ext.create("SSE.view.ShapeSettings",{id:"view-shape-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Shape}),e.ImagePanel=Ext.create("SSE.view.ImageSettings",{id:"view-image-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Image}),e.ParagraphPanel=Ext.create("SSE.view.ParagraphSettings",{id:"view-paragraph-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Paragraph})],listeners:{afterlayout:function(){e.updateScrollPane()}}})],listeners:{afterlayout:function(){e.updateScrollPane()}}}),e.add(e.panelHolder),e.ShapePanel.setApi(e.api),e.ImagePanel.setApi(e.api),e.ParagraphPanel.setApi(e.api),e.api.asc_registerCallback("asc_onSelectionChanged",Ext.bind(e._onSelectionChanged,e)),e._settings=[],e._settings[c_oAscTypeSelectElement.Image]={panel:e.ImagePanel,btn:e.btnImage,hidden:1},e._settings[c_oAscTypeSelectElement.Shape]={panel:e.ShapePanel,btn:e.btnShape,hidden:1},e._settings[c_oAscTypeSelectElement.Paragraph]={panel:e.ParagraphPanel,btn:e.btnText,hidden:1},this.effectcolors&&this.standartcolors&&this.ShapePanel.SendThemeColors(this.effectcolors,this.standartcolors)}});var SCALE_MIN=40,MENU_SCALE_PART=260,RIGHTMENU_TOOLBAR_ID="rightmenu-toolbar-id",RIGHTMENU_PANEL_ID="rightmenu-panel-id";Ext.define("SSE.view.RightMenu",{extend:"Ext.panel.Panel",alias:"widget.sserightmenu",requires:["Ext.toolbar.Toolbar","Ext.button.Button","Ext.container.Container","Ext.toolbar.Spacer","SSE.view.RightPanel","Ext.util.Cookies"],cls:"rm-style",id:RIGHTMENU_PANEL_ID,bodyCls:"rm-body",width:SCALE_MIN,buttonCollection:[],listeners:{afterrender:function(){var e=this.ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeMenu,this))}},initComponent:function(){this.dockedItems=this.buildDockedItems(),this._rightSettings=Ext.widget("sserightpanel",{id:"view-right-panel-settings",btnImage:this.btnImage,btnShape:this.btnShape,btnText:this.btnText}),this.items=[this._rightSettings],this.addEvents("editcomplete"),this.callParent(arguments)},buildDockedItems:function(){var e=this;return e.btnShape=Ext.create("Ext.button.Button",{id:"id-right-menu-shape",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuShape",asctype:c_oAscTypeSelectElement.Shape,enableToggle:!0,allowDepress:!0,toggleGroup:"tabpanelbtnsGroup",disabled:!0,style:"margin-bottom:8px;"}),e.btnImage=Ext.create("Ext.Button",{id:"id-right-menu-image",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuImage",asctype:c_oAscTypeSelectElement.Image,enableToggle:!0,allowDepress:!0,toggleGroup:"tabpanelbtnsGroup",disabled:!0,style:"margin-bottom:8px;"}),e.btnText=Ext.create("Ext.Button",{id:"id-right-menu-text",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuText",asctype:c_oAscTypeSelectElement.Paragraph,enableToggle:!0,allowDepress:!0,disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),this.rightToolbar=Ext.create("Ext.toolbar.Toolbar",{cls:"rm-default-toolbar",width:this.width||SCALE_MIN,vertical:!0,dock:"right",defaultType:"button",style:"padding-top:15px",items:[e.btnShape,e.btnImage,e.btnText]}),this.rightToolbar},resizeMenu:function(e,t,n,r){for(var i=0;i<this.items.length;i++)this.items.items[i].el&&n!=this.items.items[i].getHeight()&&this.items.items[i].setHeight(n);this.doComponentLayout()},setApi:function(e){return this.api=e,this.api.asc_registerCallback("asc_onСoAuthoringDisconnect",Ext.bind(this.onCoAuthoringDisconnect,this)),this},disableMenu:function(e){var t,n,r=this.rightToolbar;if(Ext.isDefined(r))for(n=0;n<r.items.length;n++)t=r.items.items[n],t&&(t.pressed&&t.toggle(!1),t.setDisabled(e))},onCoAuthoringDisconnect:function(){this.disableMenu(!0),this._rightSettings&&(this._rightSettings.setDisabled(!0),this._rightSettings.setMode({isEdit:!1}))},onSelectionChanged:function(e){var t=[];if(e.asc_getFlags().asc_getSelectionType()==c_oAscSelectionType.RangeImage||e.asc_getFlags().asc_getSelectionType()==c_oAscSelectionType.RangeShape||e.asc_getFlags().asc_getSelectionType()==c_oAscSelectionType.RangeShapeText)t=this.api.asc_getGraphicObjectProps();t.length<=0&&!this._rightSettings.minimizedMode&&(this.clearSelection(),this._rightSettings.minimizedMode=!0,this.setWidth(SCALE_MIN)),this._rightSettings.onFocusObject(t)},clearSelection:function(e){var t,n,r=this.rightToolbar;if(Ext.isDefined(r))for(n=0;n<r.items.length;n++){t=r.items.items[n];if(Ext.isDefined(t)&&t.componentCls==="x-btn"&&t.pressed){if(e)if(typeof e=="object"){if(e.id==t.id)continue}else if(t.iconCls&&!(t.iconCls.search(e)<0))continue;t.toggle(!1)}}},createDelayedElements:function(){var e=this;this.api.asc_registerCallback("asc_onSelectionChanged",Ext.bind(this.onSelectionChanged,this)),e._rightSettings.setHeight(e.getHeight());var t=function(t,n){if(n&&!e._rightSettings.minimizedMode){t.addCls("asc-main-menu-btn-selected");var r=e._rightSettings._settings[t.asctype].panel,i=e._rightSettings._settings[t.asctype].props;e._rightSettings.TabPanel.getLayout().setActiveItem(r),e._rightSettings.TabPanel.setHeight(r.initialHeight),i&&r.ChangeSettings.call(r,i)}},n=function(n){n.pressed?e._rightSettings.minimizedMode?(e._rightSettings.TabPanel.hidden&&e._rightSettings.TabPanel.setVisible(!0),e.setWidth(MENU_SCALE_PART),e._rightSettings.minimizedMode=!1,t(n,n.pressed)):n.addCls("asc-main-menu-btn-selected"):(e._rightSettings.minimizedMode=!0,e.setWidth(SCALE_MIN),n.removeCls("asc-main-menu-btn-selected")),e.fireEvent("editcomplete",e)},r,i=[e.txtShapeSettings,e.txtImageSettings,e.txtParagraphSettings];for(var s=this.rightToolbar.items.items.length;s--;)r=this.rightToolbar.items.items[s],r.on({click:n,toggle:t}),r.setTooltip(i[s])},txtImageSettings:"Image Settings",txtShapeSettings:"Shape Settings",txtParagraphSettings:"Text Settings"}),Ext.define("SSE.controller.Toolbar",{extend:"Ext.app.Controller",requires:["Common.view.ImageFromUrlDialog","Common.view.CopyWarning","SSE.view.HyperlinkSettings"],uses:["SSE.view.TableOptionsDialog"],stores:["TableTemplates"],views:["Toolbar"],refs:[{ref:"toolbar",selector:"ssetoolbar"},{ref:"btnHorizontalAlign",selector:"#toolbar-button-halign"},{ref:"btnVerticalAlign",selector:"#toolbar-button-valign"},{ref:"btnNumberFormat",selector:"#toolbar-button-num-format"},{ref:"btnBorders",selector:"#toolbar-button-borders"},{ref:"btnInsertShape",selector:"#toolbar-button-insertshape"},{ref:"menuHideOptions",selector:"#toolbar-menu-app-hide"},{ref:"listStyles",selector:"#toolbar-combo-viewstyles"}],init:function(){this.control({ssetoolbar:{afterrender:function(e){Ext.FocusManager.unsubscribe(e)}},"#toolbar-menu-merge":{click:this._handleMergeCellsMenu},"#toolbar-button-insert-hyperlink":{click:function(e){this._handleHyperlinkOptions(),Common.component.Analytics.trackEvent("ToolBar","Add Hyperlink")}},"menuitem[action=insert-hyperlink]":{click:function(e){this._handleHyperlinkOptions()}},"#toolbar-menuitem-print":{click:function(e,t){this._handleSimpleAction({action:"Print"})}},"#toolbar-menu-insertimage":{click:function(e,t,n){t.from=="file"?(this.api&&this.api.asc_showImageFileDialog(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Image")):this._handleImageFromURL()},hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-horalign":{click:this._handleMenuHorizontalAlign},"button[toggleGroup=alignGroup]":{click:this._handleButtonHorizontalAlign},"#toolbar-menu-vertalign":{click:this._handleMenuVerticalAlign},"button[toggleGroup=vAlignGroup]":{click:this._handleButtonVerticalAlign},"#toolbar-menu-horalign menuitem":{beforecheckchange:function(e){if(!e.checked){var t=this.getBtnHorizontalAlign().menu.items.items;for(var n in t)t[n].setChecked(!1,!0)}}},"#toolbar-menu-clearstyle":{click:function(e,t,n){t.isDisabled()?n.stopEvent():(this.api.asc_emptyCells(t.action),this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0}),Common.component.Analytics.trackEvent("ToolBar","Clear"))}},"#toolbar-menu-borders":{click:this._handleBordersMenu},"#toolbar-button-borders":{click:function(e){var t=e.menu.items.get(e.menu.items.findIndex("icls",e.icls));t&&this._handleBordersMenu(e.menu,t)}},"#toolbar-menu-borders-width":{click:function(e,t,n){Ext.menu.Manager.get("toolbar-menu-borders-width").hide(),this.getBtnBorders().borderswidth=t.value,Common.component.Analytics.trackEvent("ToolBar","Border Width")}},"#toolbar-menu-borders-color":{select:function(e,t,n){$("#picker-borders-color").css("border-color",Ext.String.format("#{0}",typeof t=="object"?t.color:t)),e.ownerCt.hide(),this.getBtnBorders().borderscolor=this.getRgbColor(t),this.getToolbar().colorsBorder.currentColor=t,Common.component.Analytics.trackEvent("ToolBar","Border Color")}},"button[group=simple-toggle]":{toggle:this._toggleSimpleAction},"button[group=simple-click]":{click:this._handleSimpleAction},"#toolbar-combo-fonts":{select:function(e,t,n){this.api.asc_setCellFontName(t[0].data.name),Common.component.Analytics.trackEvent("ToolBar","Font Family")},collapse:function(e,t){this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0})},render:function(e){this.getController("Common.controller.Fonts").fillFonts()}},"#toolbar-combo-font-size":{select:this._fontsizeSelect,beforequery:this._fontsizeBeforeQuery,collapse:this._fontsizeCollapse,specialkey:this._fontsizeSpecialKey},"button[group=copy-paste]":{click:function(e){this.handleCopyPaste({action:e.action})}},"menuitem[group=copy-paste]":{click:function(e){this.handleCopyPaste({action:e.action})}},"#toolbar-menu-autofilter":{click:function(e,t,n){if(t.direction)this.api.asc_sortColFilter(t.direction,"");else if(t.action=="set-filter"){var r=this.api.asc_addAutoFilter();t.setChecked(r==1)}this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"button[group=sort]":{click:this._handleButtonSort},"button[action=number-format]":{click:this._handleNumberFormatButton},"#toolbar-menu-color-schemas":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-newdocument":{click:function(e){this.api.asc_openNewDocument(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","New Document")}},"#toolbar-button-opendocument":{click:function(e){this.api.asc_loadDocumentFromDisk(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Open Document")}},"#toolbar-menu-app-hide":{click:this._handleMenuAppHide},"#toolbar-button-settings":{click:function(){Ext.menu.Manager.hideAll();var e=!1,t=Ext.getCmp("main-menu-file-options");t&&(t.activeBtn===t.btnDocumentSettings&&(e=!0),t.activeBtn=t.btnDocumentSettings);var n=Ext.getCmp("view-main-menu");n&&(n.currentFullScaleMenuBtn==undefined||n.currentFullScaleMenuBtn.id!="id-menu-file"?n.selectMenu("menuFile"):e?n.closeFullScaleMenu():t._onShow())}},"#toolbar-menu-text-orientation":{click:this._handleMenuTextOrientation},"menu[group=picker-autoshapes]":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},show:function(e){e.picker.selectByIndex(-1,!1)}},"#toolbar-menu-insertshape":{hide:function(){this.getBtnInsertShape().pressed&&!this._isAddingShape&&this._toggleFromMenuHide&&(this._toggleFromMenuHide=!1,this.getBtnInsertShape().toggle(!1,!1)),this._isAddingShape=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar())},show:function(){this._toggleFromMenuHide=!0}},"#toolbar-button-insertshape":{click:{fn:this._clickButtonAutoshape,action:"insert-shape"},afterrender:function(e){e.getEl().on("mousedown",function(e,t,n){this._toggleFromMenuHide=!1},this)}},"#toolbar-button-inserttext":{click:{fn:this._clickButtonAutoshape,action:"insert-text"}},"#toolbar-menu-zoomin":{click:function(){if(this.api){var e=this.api.asc_getZoom()+.1;e>0&&!(e>2)&&this.api.asc_setZoom(e)}this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoomout":{click:function(){if(this.api){var e=this.api.asc_getZoom()-.1;e<.5||this.api.asc_setZoom(e)}this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoom-text":{afterrender:function(e){e.setWidth(Ext.util.TextMetrics.measure(e.getEl(),"100%").width)}},"button[group=font-size]":{click:this._btnChangeFontSize},"#toolbar-combo-viewstyles":{select:this.onCellStyleSelect,menuhide:function(e,t){t.getPosition()[0]>-1e3&&this.getToolbar().fireEvent("editcomplete",this.getToolbar())},releasecapture:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},render:function(e){},afterrender:function(e){this.getListStyles().dataMenu.picker.store.getCount()>0&&this.getListStyles().fillComboView(this.getListStyles().dataMenu.picker.store.getAt(0),!0)}},tabbar:{change:this.onSheetChanged},commonextendedcolordialog:{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}}}),this.hotKeys=new Ext.util.KeyMap(document,[{key:"k",ctrl:!0,shift:!1,defaultEventAction:"stopEvent",fn:function(){!this.api.isCellEdited&&canHotKey()&&this._handleHyperlinkOptions()},scope:this}])},setApi:function(e){this.api=e,this.api.asc_registerCallback("asc_onInitTablePictures",Ext.bind(this._onInitTableTemplates,this)),this.api.asc_registerCallback("asc_onInitEditorStyles",Ext.bind(this._onInitEditorStyles,this))},_handleHyperlinkOptions:function(){var e=this,t,n;if(e.api){var r=e.api.asc_getWorksheetsCount(),i=-1,s=[];while(++i<r)this.api.asc_isWorksheetHidden(i)||s.push([e.api.asc_getWorksheetName(i)]);var o=e.api.asc_getCellInfo();n=o.asc_getHyperlink(),t=Ext.widget("ssehyperlinksettings",{sheets:s}),t.setSettings(n,o.asc_getText(),o.asc_getFlags().asc_getLockText())}t&&(t.addListener("onmodalresult",function(r,i){i==1&&(n=t.getSettings(),e.api.asc_insertHyperlink(n)),e.getToolbar().fireEvent("editcomplete",e.getToolbar())},!1),t.show())},_handleImageFromURL:function(){var e=this,t=Ext.create("Common.view.ImageFromUrlDialog",{});t.addListener("close",function(t,n){e.getToolbar().fireEvent("editcomplete",e.getToolbar())}),t.addListener("onmodalresult",function(n){var r=t.txtUrl;if(n==1&&e.api){var i=r.value.replace(/ /g,"");i!=""&&(e.api.asc_addImageDrawingObject(r.value),Common.component.Analytics.trackEvent("ToolBar","Image"))}},!1),t.show()},_handleMergeCellsMenu:function(e,t,n){function i(e){r.api.asc_mergeCells(e),r.getToolbar().fireEvent("editcomplete",r.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Merge")}var r=this;if(r.api){var s=r.api.asc_getCellInfo().asc_getFlags().asc_getMerge();!s&&r.api.asc_mergeCellsDataLost(t.action)?Ext.create("Ext.window.MessageBox",{buttonText:{ok:"OK",yes:"Yes",no:"No",cancel:this.textCancel}}).show({title:this.textWarning,msg:this.warnMergeLostData,icon:Ext.Msg.WARNING,buttons:Ext.Msg.OKCANCEL,fn:function(e,n){e=="ok"&&i(t.action)}}):i(t.action)}},_handleMenuHorizontalAlign:function(e,t,n){this.getBtnHorizontalAlign().removeCls(this.getBtnHorizontalAlign().icls),this.getBtnHorizontalAlign().icls=t.checked?t.icls:"halign-left",this.getBtnHorizontalAlign().addCls(this.getBtnHorizontalAlign().icls),this.api.asc_setCellAlign(t.checked?t.halign:"none"),this.getToolbar().btnWrap.allowDepress=t.halign!="justify",this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Horizontal Align")},_handleButtonHorizontalAlign:function(e,t,n){if(!e.pressed)this.api.asc_setCellAlign("left");else{switch(e.initialConfig.cls){case"halign-left":var r="left";break;case"halign-right":r="right";break;case"halign-center":r="center";break;case"halign-just":r="justify"}this.api.asc_setCellAlign(r)}this.getToolbar().btnWrap.allowDepress=r!="justify"},_handleMenuVerticalAlign:function(e,t,n){this.api&&this.api.asc_setCellVertAlign(t.valign),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Vertical Align")},_handleButtonVerticalAlign:function(e,t,n){if(!e.pressed)this.api.asc_setCellVertAlign("bottom");else{switch(e.initialConfig.cls){case"valign-top":var r="top";break;case"valign-middle":r="center";break;case"valign-bottom":r="bottom"}this.api.asc_setCellVertAlign(r)}},_handleNumberFormatMenu:function(e,t,n){t.menu==undefined&&(this.api&&this.api.asc_setCellFormat(t.formatId),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Number Format"))},_handleNumberFormatButton:function(e,t,n){this.api.asc_setCellFormat(e.formatId),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Number Format")},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},_handleBordersMenu:function(e,t,n){var r=this;if(r.api&&t.borderId!==undefined){r.getBtnBorders().removeCls(r.getBtnBorders().icls),r.getBtnBorders().addCls(t.icls),r.getBtnBorders().icls=t.icls;var i=[];t.borderId=="inner"?(i[c_oAscBorderOptions.InnerV]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.InnerH]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor)):t.borderId=="all"?(i[c_oAscBorderOptions.InnerV]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.InnerH]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Left]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Top]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Right]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Bottom]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor)):t.borderId=="outer"?(i[c_oAscBorderOptions.Left]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Top]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Right]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor),i[c_oAscBorderOptions.Bottom]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor)):t.borderId!="none"&&(i[t.borderId]=new Asc.asc_CBorder(r.getBtnBorders().borderswidth,r.getBtnBorders().borderscolor)),r.api.asc_setCellBorders(i)}r.getToolbar().fireEvent("editcomplete",r.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Borders")},_handleSimpleAction:function(e){var t,n,r;switch(e.action){case"Save":r="asc_Save",t="Save";break;case"Print":r="asc_Print",t="Print";break;case"Undo":r="asc_Undo";var i={checkorder:!0};break;case"Redo":r="asc_Redo",i={checkorder:!0};break;case"Decrement":r="asc_decreaseCellDigitNumbers";break;case"Increment":r="asc_increaseCellDigitNumbers";break;case"Filter":r="asc_addAutoFilter";break;default:return}this.api&&r&&this.api[r](),this.getToolbar().fireEvent("editcomplete",this.getToolbar(),i),t&&Common.component.Analytics.trackEvent(t),Common.component.Analytics.trackEvent("ToolBar",e.action)},_toggleSimpleAction:function(e){var t,n;switch(e.action){case"Bold":n="asc_setCellBold";break;case"Italic":n="asc_setCellItalic";break;case"Underline":n="asc_setCellUnderline";break;case"Wrap":n="asc_setCellTextWrap";break;default:return}this.api&&n&&this.api[n](e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0}),t&&Common.component.Analytics.trackEvent(t),Common.component.Analytics.trackEvent("ToolBar",e.action)},_getApiTextSize:function(e){return e?e.asc_getFont().asc_getSize():12},_fontsizeCollapse:function(e,t){if(!e.eventsSuspended){var n=e.getRawValue(),r=this._getApiTextSize(this.api.asc_getCellInfo());r&&n!=r&&(e.getStore().clearFilter(!1),e.setValue(r))}this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0})},_fontsizeSelect:function(e,t,n){this.api&&this.api.asc_setCellFontSize(t[0].data.sizevalue),this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0}),Common.component.Analytics.trackEvent("ToolBar","Font Size")},_fontsizeBeforeQuery:function(e,t){e.forceAll=!0,e.cancel=!0,e.combo.expand();var n=e.combo.getPicker(),r=e.combo.store.find("sizestring",e.query,undefined,undefined,undefined,!0);if(r<0)n.clearHighlight(),n.highlightedItem=undefined;else{var i=e.combo.store.getAt(r);(i=n.getNode(i))&&n.highlightItem(i)}},_fontsizeSpecialKey:function(e,t,n){if(t.getKey()==t.ENTER){var r=e.getPicker().highlightedItem,i=!1;if(r)var s=[e.getPicker().getRecord(r).data.sizestring];else s=/^\+?(\d*\.?\d+)$|^\+?(\d+\.?\d*)$/.exec(e.getValue()),s?(s=s[0]?parseFloat(s[0]):parseFloat(s[1]),s=s>100?100:s<1?1:Math.floor((s+.4)*2)/2):(s=this._getApiTextSize(this.api.asc_getCellInfo()),i=!0);e.suspendEvents(!1),e.getStore().clearFilter(!1),e.setRawValue(s),e.collapse(),i?Ext.Msg.show({title:this.textWarning,msg:this.textFontSizeErr,icon:Ext.Msg.WARNING,buttons:Ext.Msg.OK,scope:this,fn:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0})}}):(this.api.asc_setCellFontSize(s),this.getToolbar().fireEvent("editcomplete",this.getToolbar(),{checkorder:!0})),e.resumeEvents()}},handleCopyPaste:function(e){var t=e.action=="copy"?"asc_Copy":e.action=="paste"?"asc_Paste":"asc_Cut",n=this;n.api[t]()||(Ext.create("Common.view.CopyWarning",{listeners:{close:function(e,t){n.getToolbar().fireEvent("editcomplete",n.getToolbar())}}}).show(),Common.component.Analytics.trackEvent("ToolBar","Copy Warning"))},_onCanRevert:function(e,t){this.getToolbar()[t=="undo"?"btnUndo":"btnRedo"].setDisabled(!e)},_onTemplatesStoreDataChanged:function(){},_onInitTableTemplates:function(e){var t=this.getTableTemplatesStore();if(t){var n=[];e.forEach(function(e,t,r){n.push({name:e.asc_getName(),caption:e.asc_getDisplayName(),type:e.asc_getType(),imageUrl:e.asc_getImage()})}),t.removeAll(),t.add(n)}},_onEditCell:function(e){var t=this.getToolbar();if(e==c_oAscCellEditorState.editStart||e==c_oAscCellEditorState.editEnd){var n=e==c_oAscCellEditorState.editStart;t.btnInsertHyperlink.setDisabled(n),t.btnPrint.setDisabled(n),t.btnParagraphColor.setDisabled(n),t.btnVerticalAlign.setDisabled(n),t.btnHorizontalAlign.setDisabled(n),t.btnBorders.setDisabled(n),t.btnAlignLeft.setDisabled(n),t.btnAlignCenter.setDisabled(n),t.btnAlignRight.setDisabled(n),t.btnAlignJust.setDisabled(n),t.btnAlignJust.setDisabled(n),t.btnAlignTop.setDisabled(n),t.btnAlignMiddle.setDisabled(n),t.btnAlignBottom.setDisabled(n),t.btnTextOrient.setDisabled(n),t.btnMerge.setDisabled(n),t.btnInsertImage.setDisabled(n),t.btnInsertHyperlink.setDisabled(n),t.btnInsertText.setDisabled(n),t.btnInsertShape.setDisabled(n),t.btnSortDown.setDisabled(n),t.btnSortUp.setDisabled(n),t.btnTableTemplate.setDisabled(n),t.btnSetAutofilter.setDisabled(n),t.btnPercentStyle.setDisabled(n),t.btnCurrencyStyle.setDisabled(n),t.btnDecDecimal.setDisabled(n),t.btnIncDecimal.setDisabled(n),t.btnAddCell.setDisabled(n),t.btnDeleteCell.setDisabled(n),t.btnNumberFormat.setDisabled(n),t.btnWrap.setDisabled(n),t.btnClearStyle.menu.items.items[1].setDisabled(n),t.btnClearStyle.menu.items.items[2].setDisabled(n),t.btnAutofilter.setDisabled(n),t.btnShowMode.setDisabled(n),t.btnSettings.setDisabled(n),t.listStyles.setDisabled(n),n||(t.cmbFont.setDisabled(!1),t.cmbFontSize.setDisabled(!1),t.btnIncFontSize.setDisabled(!1),t.btnDecFontSize.setDisabled(!1),t.btnBold.setDisabled(!1),t.btnItalic.setDisabled(!1),t.btnUnderline.setDisabled(!1),t.btnFontColor.setDisabled(!1),t.btnInsertFormula.setDisabled(!1))}else{if(e==c_oAscCellEditorState.editText)var r=!0,i=!1;else e==c_oAscCellEditorState.editFormula?r=!(i=!0):e==c_oAscCellEditorState.editEmptyCell&&(r=i=!1);t.cmbFont.setDisabled(i),t.cmbFontSize.setDisabled(i),t.btnIncFontSize.setDisabled(i),t.btnDecFontSize.setDisabled(i),t.btnBold.setDisabled(i),t.btnItalic.setDisabled(i),t.btnUnderline.setDisabled(i),t.btnFontColor.setDisabled(i),t.btnInsertFormula.setDisabled(r)}this.checkInsertAutoshape({},{action:"cancel"})},_handleMenuAppHide:function(e,t,n){var r={},i;switch(t.action){case"title":r.title=t.checked,i="sse-hidden-title";break;case"compact":r.compact=t.checked,i="sse-toolbar-compact";break;case"formula":r.formula=t.checked,i="sse-hidden-formula";break;case"headings":r.headings=t.checked;break;case"gridlines":r.gridlines=t.checked}this.hideElements(r),i&&localStorage.setItem(i,t.checked),this.getToolbar().fireEvent("editcomplete",this.getToolbar())},hideElements:function(e,t){var n=this.getMenuHideOptions();if(e.title!==undefined){var r=Ext.ComponentQuery.query("commonheader")[0];r[e.title?"hide":"show"](),t&&n.items.getAt(1).setChecked(e.title)}e.compact!==undefined&&(this.changeViewMode(e.compact),t&&n.items.getAt(0).setChecked(e.compact));if(e.formula!==undefined){var i=Ext.ComponentQuery.query("ssecellinfo")[0],s=Ext.ComponentQuery.query("#field-formula-splitter")[0],o=Ext.ComponentQuery.query("ssedocumentholder")[0];e.formula?(i.lastHeight=i.getHeight(),i.hide(),s.hide(),o.removeCls("top-border")):(i.setHeight(i.lastHeight||23),i.show(),s.show(),o.addCls("top-border")),t&&n.items.getAt(2).setChecked(e.formula)}if(e.headings!==undefined&&this.api){var u=this.api.asc_getSheetViewSettings();u.asc_setShowRowColHeaders(!e.headings),this.api.asc_setSheetViewSettings(u)}e.gridlines!==undefined&&this.api&&(u=this.api.asc_getSheetViewSettings(),u.asc_setShowGridLines(!e.gridlines),this.api.asc_setSheetViewSettings(u))},_handleButtonSort:function(e,t){this.api.asc_sortColFilter(e.direction,"")},_handleMenuTextOrientation:function(e,t,n){var r=0;switch(t.angle){case"countcw":r=45;break;case"clockwise":r=-45;break;case"rotateup":r=90;break;case"rotatedown":r=-90}this.api.asc_setCellAngle(r),this.getToolbar().fireEvent("editcomplete",this.getToolbar())},onCoAuthoringDisconnect:function(){this.hotKeys.disable(),this.getToolbar().setMode({isDisconnected:!0})},FillAutoShapes:function(){var e=this,t=Ext.getStore("ShapeGroups");e.getBtnInsertShape().menu.removeAll();for(var n=0;n<t.getCount()-1;n++){var r=t.getAt(n),i=Ext.widget("menuitem",{hideOnClick:!1,text:r.data.groupName,cls:"menu-item-noicon",menu:Ext.create("Common.component.MenuDataViewPicker",{width:r.data.groupWidth,height:r.data.groupHeight,store:r.data.groupStore,group:"picker-autoshapes",viewData:[],contentWidth:r.data.groupWidth-20,listeners:{select:function(t,n){e._addAutoshape(!0,n.get("data").shapeType),e._isAddingShape=!0,Common.component.Analytics.trackEvent("ToolBar","Add Shape")}},plugins:[{ptype:"menuexpand"}]})});e.getBtnInsertShape().menu.add(i)}},_onEndAddShape:function(){this.getBtnInsertShape().pressed&&this.getBtnInsertShape().toggle(!1,!0),this.getToolbar().btnInsertText.pressed&&this.getToolbar().btnInsertText.toggle(!1,!0)},_clickButtonAutoshape:function(e,t,n){n.action=="insert-text"?(this._addAutoshape(e.pressed,"textRect"),Ext.ComponentQuery.query("ssedocumentholder")[0].focus(),this.getBtnInsertShape().pressed&&this.getBtnInsertShape().toggle(!1,!0),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Add Text")):n.action=="insert-shape"&&(e.pressed?this.getToolbar().btnInsertText.pressed&&(this._addAutoshape(!1),this.getToolbar().btnInsertText.toggle(!1,!0)):(e.hideMenu(),this._addAutoshape(!1),this.getToolbar().fireEvent("editcomplete",this.getToolbar())))},loadStyles:function(){this.styles&&this._onInitEditorStyles(this.styles)},_onInitEditorStyles:function(e){window.styles_loaded=!1;var t=this;if(!t.getListStyles()){t.styles=e;return}var n=document.createElement("canvas");n.id="bigimgdefaultstyles";var r=e.asc_getDocStylesImage().length>0,i=function(){t.getListStyles().dataMenu.picker.store.removeAll();var i=e.asc_getDefaultStyles();r&&(i=i.concat(e.asc_getDocStyles())),i.forEach(function(r){var i=document.createElement("canvas");i.width=e.asc_getStyleThumbnailWidth(),i.height=e.asc_getStyleThumbnailHeight();var s=i.getContext("2d");s.save(),s.translate(0,-r.asc_getThumbnailOffset()*e.asc_getStyleThumbnailHeight()),s.drawImage(r.asc_getType()==c_oAscStyleImage.Default?n:u,0,0),s.restore(),t.getListStyles().dataMenu.picker.store.add({imageUrl:i.toDataURL(),name:r.asc_getName(),uid:Ext.id()})});var s=t.getListStyles().rendered&&t.getListStyles().getEl()&&t.getListStyles().getEl().up("#id-toolbar-full-group-styles")&&t.getListStyles().getEl().up("#id-toolbar-full-group-styles").isVisible();t.getListStyles().dataMenu.picker.store.getCount()>0&&s&&(t.getListStyles().fillComboView(t.getListStyles().dataMenu.picker.store.getAt(0),!0),t.getListStyles().selectByIndex(0)),window.styles_loaded=!0},s=new Image,o=1;if(r){o++;var u=document.createElement("canvas");u.id="bigimgdocstyles";var a=new Image;a.onload=function(){u.width=a.width,u.height=a.height,u.getContext("2d").drawImage(a,0,0),--o>0||i()}}s.onload=function(){n.width=s.width,n.height=s.height,n.getContext("2d").drawImage(s,0,0),--o>0||i()},s.src=e.asc_getDefaultStylesImage(),a&&(a.src=e.asc_getDocStylesImage())},onCellStyleSelect:function(e,t){var n=this.getListStyles();this.api.refusechange=!0,this.api.asc_setCellStyle(n.dataMenu.picker.store.getAt(n.dataMenu.picker.store.find("uid",t.get("uid"))).get("name")),this.api.refusechange=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Style")},onZoomChange:function(e,t){switch(t){case 1:case 2:case 0:default:this.getToolbar().txtZoom.setText(Math.floor((e+.005)*100)+"%")}},_btnChangeFontSize:function(e){e.action=="inc"?this.api.asc_increaseFontSize():this.api.asc_decreaseFontSize()},_onMenuTableTemplate:function(e,t){if(this.api.asc_getAddFormatTableOptions()!=0){var n=this,r=n.api.asc_getWorksheetsCount(),i=[],s=-1;while(++s<r)i.push(n.api.asc_getWorksheetName(s));var o=Ext.widget("tableoptionsdialog",{api:this.api,names:i});o.addListener("onmodalresult",function(e,r,i){r==1&&(n.api.asc_setSelectionDialogMode(!1),n.api.asc_addAutoFilter(t.data.name,i)),n.getToolbar().fireEvent("editcomplete",n.getToolbar())},!1),o.addListener("show",function(){n.getToolbar().fireEvent("editcomplete",n.getToolbar())},!1),o.show()}else this.api.asc_addAutoFilter(t.data.name)},onSheetChanged:function(){var e=this.api.asc_getSheetViewSettings(),t=this.getMenuHideOptions();t&&(t.items.getAt(3).setChecked(!e.asc_getShowRowColHeaders()),t.items.getAt(4).setChecked(!e.asc_getShowGridLines()))},checkInsertAutoshape:function(e,t){this.api.asc_isAddAutoshape()&&(t.id!="editor_sdk"||t.action=="cancel")&&(this._toggleFromMenuHide=!1,this._isAddingShape=!1,this._addAutoshape(!1),this.getBtnInsertShape().toggle(!1,!1),this.getToolbar().btnInsertText.toggle(!1,!1),this.getToolbar().fireEvent("editcomplete",this.getToolbar()))},_addAutoshape:function(e,t){e?(this.api.asc_startAddShape(t),Ext.FocusManager.addListener("componentfocus",this.checkInsertAutoshape,this)):(this.api.asc_endAddShape(),Ext.FocusManager.removeListener("componentfocus",this.checkInsertAutoshape,this))},createDelayedElements:function(){this.api.asc_registerCallback("asc_onСoAuthoringDisconnect",Ext.bind(this.onCoAuthoringDisconnect,this)),this.api.asc_registerCallback("asc_onCanUndoChanged",Ext.bind(this._onCanRevert,this,["undo"],!0)),this.api.asc_registerCallback("asc_onCanRedoChanged",Ext.bind(this._onCanRevert,this,["redo"],!0)),this.api.asc_registerCallback("asc_onEditCell",Ext.bind(this._onEditCell,this)),this.api.asc_registerCallback("asc_onEndAddShape",Ext.bind(this._onEndAddShape,this)),this.api.asc_registerCallback("asc_onZoomChanged",Ext.bind(this.onZoomChange,this)),this.api.asc_registerCallback("asc_onSheetsChanged",Ext.bind(this.onSheetChanged,this)),this.wrapOnSelectionChanged=Ext.bind(this._onSelectionChanged,this),this.api.asc_registerCallback("asc_onSelectionChanged",this.wrapOnSelectionChanged),this._onSelectionChanged(this.api.asc_getCellInfo()),this.attachToControlEvents()},attachToControlEvents:function(){this.control({"menu[action=table-templates]":{select:this._onMenuTableTemplate,itemmouseenter:function(e,t,n,r,i,s){e.tooltip&&e.tooltip.close(),e.tooltip=Ext.create("Ext.tip.ToolTip",{closeAction:"destroy",dismissDelay:2e3,html:t.get("caption")});var o=i.getXY();e.tooltip.showAt([o[0]+10,o[1]+10])},itemmouseleave:function(e,t,n,r,i,s){e.tooltip&&e.tooltip.close()},hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"menu[action=number-format]":{click:this._handleNumberFormatMenu}})},changeViewMode:function(e){var t=this.getToolbar(),n=Ext.get("id-toolbar-full"),r=Ext.get("id-toolbar-short");t.isCompactView=e,n&&r&&(this.api.asc_unregisterCallback("asc_onSelectionChanged",this.wrapOnSelectionChanged),e?(r.setStyle({display:"table"}),n.setStyle({display:"none"}),t.setHeight(38),t.rendererComponents("short")):(r.setStyle({display:"none"}),n.setStyle({display:"table"}),t.setHeight(68),t.rendererComponents("full"),Ext.defer(function(){var e=t.listStyles.rendered&&t.listStyles.getEl()&&t.listStyles.getEl().up("#id-toolbar-full-group-styles")&&t.listStyles.getEl().up("#id-toolbar-full-group-styles").isVisible();t.listStyles.dataMenu.picker.store.getCount()>0&&e&&(t.listStyles.doComponentLayout(),t.listStyles.fillComboView(t.listStyles.dataMenu.picker.getSelectedRec(),!0))},100)),this.api.asc_registerCallback("asc_onSelectionChanged",this.wrapOnSelectionChanged),this._onSelectionChanged(this.api.asc_getCellInfo()))},_disableEditOptions:function(e){var t=this.getToolbar(),n=e==c_oAscSelectionType.RangeShapeText,r=e==c_oAscSelectionType.RangeShape,i=e==c_oAscSelectionType.RangeImage,s=i,o=e==c_oAscSelectionType.RangeShapeText||r;t.btnPrint.setDisabled(s||o),t.btnParagraphColor.setDisabled(s),t.btnVerticalAlign.setDisabled(s),t.btnHorizontalAlign.setDisabled(s),t.btnBorders.setDisabled(s||o),t.btnAlignLeft.setDisabled(s),t.btnAlignCenter.setDisabled(s),t.btnAlignRight.setDisabled(s),t.btnAlignJust.setDisabled(s),t.btnAlignJust.setDisabled(s),t.btnAlignTop.setDisabled(s),t.btnAlignMiddle.setDisabled(s),t.btnAlignBottom.setDisabled(s),t.btnTextOrient.setDisabled(s||o),t.btnMerge.setDisabled(s||o),t.btnInsertHyperlink.setDisabled(i),t.btnInsertImage.setDisabled(i),t.btnInsertText.setDisabled(i),t.btnInsertShape.setDisabled(i),t.btnSortDown.setDisabled(s||o),t.btnSortUp.setDisabled(s||o),t.btnTableTemplate.setDisabled(s||o),t.btnSetAutofilter.setDisabled(s||o),t.btnPercentStyle.setDisabled(s||o),t.btnCurrencyStyle.setDisabled(s||o),t.btnDecDecimal.setDisabled(s||o),t.btnIncDecimal.setDisabled(s||o),t.btnAddCell.setDisabled(s||o),t.btnDeleteCell.setDisabled(s||o),t.btnNumberFormat.setDisabled(s||o),t.btnWrap.setDisabled(s||o),t.btnInsertFormula.setDisabled(s||o),t.btnClearStyle.menu.items.items[1].setDisabled(s||o),t.btnClearStyle.menu.items.items[2].setDisabled(s||o),t.btnAutofilter.setDisabled(s||o),t.btnShowMode.setDisabled(s||o),t.btnSettings.setDisabled(s||o);if(s||o)t.listStyles.suspendEvents(!1),t.listStyles.selectByIndex(-1),t.listStyles.resumeEvents();return t.listStyles.setDisabled(s||o),t.cmbFont.setDisabled(s),t.cmbFontSize.setDisabled(s),t.btnIncFontSize.setDisabled(s),t.btnDecFontSize.setDisabled(s),t.btnBold.setDisabled(s),t.btnItalic.setDisabled(s),t.btnUnderline.setDisabled(s),t.btnFontColor.setDisabled(s),s},_onSelectionChanged:function(e){var t=e.asc_getFlags().asc_getSelectionType();if(this._disableEditOptions(t))return;var n=this.getToolbar(),r=e.asc_getFont(),i=r.asc_getName();if(i!=n.cmbFont.getValue()){var s=n.cmbFont.store.findRecord("name",i);s?n.cmbFont.select(s):n.cmbFont.setRawValue(i)}n.btnBold.toggle(r.asc_getBold(),!0),n.btnItalic.toggle(r.asc_getItalic(),!0),n.btnUnderline.toggle(r.asc_getUnderline(),!0);var o=String(r.asc_getSize());n.cmbFontSize.getValue()!=o&&n.cmbFontSize.setValue(o);var u,a;if(!n.btnFontColor.ischanged){a=r.asc_getColor(),a&&(a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?u={color:n.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}:u=n.getHexColor(a.get_r(),a.get_g(),a.get_b())),n.colorsText.suspendEvents(!1);if(typeof u=="object"){for(var f=0;f<10;f++)if(n.ThemeValues[f]==u.effectValue){n.colorsText.select(u,!1);break}}else n.colorsText.select(u,!1);n.colorsText.resumeEvents()}if(!n.btnParagraphColor.ischanged){a=e.asc_getFill().asc_getColor(),a?a.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?u={color:n.getHexColor(a.get_r(),a.get_g(),a.get_b()),effectValue:a.get_value()}:u=n.getHexColor(a.get_r(),a.get_g(),a.get_b()):u="transparent",n.colorsBack.suspendEvents(!1);if(typeof u=="object"){for(f=0;f<10;f++)if(n.ThemeValues[f]==u.effectValue){n.colorsBack.select(u,!1);break}}else n.colorsBack.select(u,!1);n.colorsBack.resumeEvents()}i=e.asc_getHorAlign();var l=-1,c,h,p=Ext.ButtonToggleManager.getPressed("alignGroup");switch(i){case"left":l=0,c="halign-left",h=n.btnAlignLeft;break;case"center":l=1,c="halign-center",h=n.btnAlignCenter;break;case"right":l=2,c="halign-right",h=n.btnAlignRight;break;case"justify":l=3,c="halign-just",h=n.btnAlignJust;break;default:l=-255,c="halign-left"}l<0?l==-255&&(!n.isCompactView&&p&&p.toggle(!1,!0),this._clearChecked(n.btnHorizontalAlign.menu.items.items)):(!n.isCompactView&&!h.pressed&&(p&&p.toggle(!1,!0),h.toggle(!0,!0)),n.btnHorizontalAlign.menu.items.getAt(l).setChecked(!0)),n.btnHorizontalAlign.removeCls(n.btnHorizontalAlign.icls),n.btnHorizontalAlign.icls=c,n.btnHorizontalAlign.addCls(c),n.btnTextOrient.menu.items.getAt(1).setDisabled(i=="justify"),n.btnTextOrient.menu.items.getAt(2).setDisabled(i=="justify"),i=e.asc_getVertAlign(),l=-1,c="";switch(i){case"top":l=0,c="valign-top",h=n.btnAlignTop;break;case"center":l=1,c="valign-middle",h=n.btnAlignMiddle;break;case"bottom":l=2,c="valign-bottom",h=n.btnAlignBottom}l<0||(!n.isCompactView&&!h.pressed&&(p=Ext.ButtonToggleManager.getPressed("vAlignGroup"),p&&p.toggle(!1,!0),h.toggle(!0,!0)),n.btnVerticalAlign.menu.items.items[l].setChecked(!0),n.btnVerticalAlign.removeCls(n.btnVerticalAlign.icls),n.btnVerticalAlign.icls=c,n.btnVerticalAlign.addCls(c)),!n.api.isCellEdited&&n.btnMerge.setDisabled(e.asc_getIsFormatTable()===!0),n.btnMerge.toggle(e.asc_getFlags().asc_getMerge(),!0),n.btnWrap.toggle(e.asc_getFlags().asc_getWrapText(),!0);var d=e.asc_getLocked();n.coauthdisable!=d&&(n.coauthdisable=d,setTimeout(function(){n.btnParagraphColor.setDisabled(d),n.btnFontColor.setDisabled(d),Ext.each(n.coauthControls,function(e,t){e.setDisabled(d)},n)},10)),i=n.numFormatTypes[e.asc_getNumFormatType()],i||(i=n.numFormatTypes[1]),n.btnNumberFormat.setText(i),this._clearChecked(n.btnTextOrient.menu.items.items);switch(e.asc_getAngle()){case 45:n.btnTextOrient.menu.items.getAt(1).setChecked(!0,!0);break;case-45:n.btnTextOrient.menu.items.getAt(2).setChecked(!0,!0);break;case 90:n.btnTextOrient.menu.items.getAt(3).setChecked(!0,!0);break;case-90:n.btnTextOrient.menu.items.getAt(4).setChecked(!0,!0);break;default:n.btnTextOrient.menu.items.getAt(0).setChecked(!0,!0)}this.api.refusechange||(n.listStyles.suspendEvents(!1),n.listStyles.selectByIndex(n.listStyles.dataMenu.picker.store.find("name",e.asc_getStyleName())),n.listStyles.resumeEvents()),n.btnAddCell.menu.items.getAt(0).setDisabled(t==c_oAscSelectionType.RangeRow),n.btnAddCell.menu.items.getAt(1).setDisabled(t==c_oAscSelectionType.RangeCol),n.btnAddCell.menu.items.getAt(2).setDisabled(t==c_oAscSelectionType.RangeCol),n.btnAddCell.menu.items.getAt(3).setDisabled(t==c_oAscSelectionType.RangeRow),n.btnDeleteCell.menu.items.getAt(0).setDisabled(t==c_oAscSelectionType.RangeRow),n.btnDeleteCell.menu.items.getAt(1).setDisabled(t==c_oAscSelectionType.RangeCol),n.btnDeleteCell.menu.items.getAt(2).setDisabled(t==c_oAscSelectionType.RangeCol),n.btnDeleteCell.menu.items.getAt(3).setDisabled(t==c_oAscSelectionType.RangeRow)},_clearChecked:function(e){for(var t in e)e[t].setChecked(!1,!0)},textEmptyImgUrl:"You need to specify image URL.",warnMergeLostData:"Operation will can destroy data in the selected cells.<br>Continue?",textWarning:"Warning",textFontSizeErr:"The entered value must be more than 0",textCancel:"Cancel"}),Ext.define("SSE.controller.Print",{extend:"Ext.app.Controller",uses:["SSE.view.DocumentStatusInfo","SSE.view.PrintSettings"],views:["MainSettingsPrint"],refs:[{ref:"toolbar",selector:"ssetoolbar"},{ref:"printAdvanced",selector:"ssemainsettingsprint"}],init:function(){this.adjPrintParams=new Asc.asc_CAdjustPrint,this.adjPrintParams.asc_setPrintType(c_oAscPrintType.ActiveSheets),this.adjPrintParams.asc_setLayoutPageType(c_oAscLayoutPageType.FitToWidth),this.control({documentstatusinfo:{updatesheetsinfo:function(){this.isFillSheets=!1,this.diffParams={}}},ssemainsettingsprint:{show:function(){this.isFillSheets||(this.isFillSheets=!0,this.updateSettings()),this.isUpdatedSettings||(this.isUpdatedSettings=!0,this.getPrintAdvanced().cmbSheet.select(this.getPrintAdvanced().cmbSheet.getStore().findRecord("sheetindex",this.api.asc_getActiveWorksheetIndex())))}},sseprintsettings:{onmodalresult:this.closePrintSettings},"#advsettings-print-combo-sheets":{change:this.comboSheetsChange},"#advsettings-print-button-save":{click:this.querySavePrintSettings},"#toolbar-menuitem-print-options":{click:this.openPrintSettings},"#dialog-print-options-ok":{click:this.queryClosePrintSettings},"#dialog-printoptions-grouprange":{change:function(e,t,n,r){if(typeof t.printrange=="number"){var i=e.up("window");t.printrange==c_oAscPrintType.EntireWorkbook?this.indeterminatePageOptions(i):e.lastCheckedRange==c_oAscPrintType.EntireWorkbook&&this.fillPageOptions(i,this.api.asc_getPageOptions()),e.lastCheckedRange=t.printrange}}}})},setApi:function(e){this.api=e},updateSettings:function(){var e=this.getPrintAdvanced();e.cmbSheet.getStore().removeAll();var t=this.api.asc_getWorksheetsCount(),n=-1,r=[{sheetname:this.strAllSheets,sheetindex:-255}];while(++n<t)this.api.asc_isWorksheetHidden(n)||r.push({sheetname:this.api.asc_getWorksheetName(n).replace(/\s/g,"&nbsp;"),sheetindex:n});e.cmbSheet.getStore().loadData(r)},comboSheetsChange:function(e,t,n,r){var i=this.getPrintAdvanced();t==-255?this.indeterminatePageOptions(i):this.fillPageOptions(i,this.api.asc_getPageOptions(t))},isDiffRefill:function(){for(var e in this.diffParams)if(this.diffParams[e]==undefined)return!0;return e==undefined},indeterminatePageOptions:function(e){if(this.isDiffRefill()){var t=this.api.asc_getWorksheetsCount();if(t==1)this.diffParams.orientation=!1,this.diffParams.size=!1,this.diffParams.headings=!1,this.diffParams.grid=!1,this.diffParams.margintop=!1,this.diffParams.marginright=!1,this.diffParams.marginbottom=!1,this.diffParams.marginleft=!1;else{var n=0,r=this.api.asc_getPageOptions(n),i;while(++n<t)i=this.api.asc_getPageOptions(n),this.diffParams.orientation==undefined&&(this.diffParams.orientation=r.asc_getPageSetup().asc_getOrientation()!=i.asc_getPageSetup().asc_getOrientation()),this.diffParams.size==undefined&&(this.diffParams.size=r.asc_getPageSetup().asc_getWidth()!=i.asc_getPageSetup().asc_getWidth()||r.asc_getPageSetup().asc_getHeight()!=i.asc_getPageSetup().asc_getHeight()),this.diffParams.headings==undefined&&(this.diffParams.headings=r.asc_getHeadings()!=i.asc_getHeadings()),this.diffParams.grid==undefined&&(this.diffParams.grid=r.asc_getGridLines()!=i.asc_getGridLines()),this.diffParams.margintop==undefined&&(this.diffParams.margintop=r.asc_getPageMargins().asc_getTop()!=i.asc_getPageMargins().asc_getTop()),this.diffParams.marginright==undefined&&(this.diffParams.marginright=r.asc_getPageMargins().asc_getRight()!=i.asc_getPageMargins().asc_getRight()),this.diffParams.marginbottom==undefined&&(this.diffParams.marginbottom=r.asc_getPageMargins().asc_getBottom()!=i.asc_getPageMargins().asc_getBottom()),this.diffParams.marginleft==undefined&&(this.diffParams.marginleft=r.asc_getPageMargins().asc_getLeft()!=i.asc_getPageMargins().asc_getLeft())}}this.diffParams.orientation&&e.cmbPaperOrientation.setValue("-"),this.diffParams.size&&e.cmbPaperSize.setValue("-"),this.diffParams.margintop&&e.spnMarginTop.setRawValue("-"),this.diffParams.marginright&&e.spnMarginRight.setRawValue("-"),this.diffParams.marginbottom&&e.spnMarginBottom.setRawValue("-"),this.diffParams.marginleft&&e.spnMarginLeft.setRawValue("-"),this.diffParams.grid&&e.chPrintGrid.setValue("indeterminate"),this.diffParams.headings&&e.chPrintRows.setValue("indeterminate")},fillPageOptions:function(e,t){var n=t.asc_getPageSetup(),r=e.cmbPaperOrientation.getStore().find("orient",n.asc_getOrientation());e.cmbPaperOrientation.select(e.cmbPaperOrientation.getStore().getAt(r));var i=n.asc_getWidth(),s=n.asc_getHeight();r=e.cmbPaperSize.getStore().find("size",i+"|"+s),r<0?e.cmbPaperSize.setValue("Custom ("+i+" x "+s):e.cmbPaperSize.select(e.cmbPaperSize.getStore().getAt(r)),n=t.asc_getPageMargins(),e.spnMarginLeft.setValue(Common.MetricSettings.fnRecalcFromMM(n.asc_getLeft())),e.spnMarginTop.setValue(Common.MetricSettings.fnRecalcFromMM(n.asc_getTop())),e.spnMarginRight.setValue(Common.MetricSettings.fnRecalcFromMM(n.asc_getRight())),e.spnMarginBottom.setValue(Common.MetricSettings.fnRecalcFromMM(n.asc_getBottom())),e.chPrintGrid.setValue(t.asc_getGridLines()),e.chPrintRows.setValue(t.asc_getHeadings())},fillPrintOptions:function(e,t){e.groupRange.setValue({printrange:t.asc_getPrintType()}),e.groupLayout.setValue({printlayout:t.asc_getLayoutPageType()})},getPageOptions:function(e){var t=new Asc.asc_CPageOptions;t.asc_setGridLines(e.chPrintGrid.getValue()=="indeterminate"?undefined:e.chPrintGrid.getValue()=="checked"?1:0),t.asc_setHeadings(e.chPrintRows.getValue()=="indeterminate"?undefined:e.chPrintRows.getValue()=="checked"?1:0);var n=new Asc.asc_CPageSetup;n.asc_setOrientation(e.cmbPaperOrientation.getValue()=="-"?undefined:e.cmbPaperOrientation.getValue());var r=/^\d{3}\.?\d*/.exec(e.cmbPaperSize.getValue()),i=/\d{3}\.?\d*$/.exec(e.cmbPaperSize.getValue());return n.asc_setWidth(r?parseFloat(r[0]):undefined),n.asc_setHeight(i?parseFloat(i[0]):undefined),t.asc_setPageSetup(n),n=new Asc.asc_CPageMargins,n.asc_setLeft(e.spnMarginLeft.getRawValue()=="-"?undefined:Common.MetricSettings.fnRecalcToMM(e.spnMarginLeft.getNumberValue())),n.asc_setTop(e.spnMarginTop.getRawValue()=="-"?undefined:Common.MetricSettings.fnRecalcToMM(e.spnMarginTop.getNumberValue())),n.asc_setRight(e.spnMarginRight.getRawValue()=="-"?undefined:Common.MetricSettings.fnRecalcToMM(e.spnMarginRight.getNumberValue())),n.asc_setBottom(e.spnMarginBottom.getRawValue()=="-"?undefined:Common.MetricSettings.fnRecalcToMM(e.spnMarginBottom.getNumberValue())),t.asc_setPageMargins(n),t},savePageOptions:function(e,t){var n=this.getPageOptions(e);if(t==-255){var r=this.api.asc_getWorksheetsCount();t=-1;while(++t<r)this.api.asc_setPageOptions(n,t);this.diffParams.orientation&&(this.diffParams.orientation=n.asc_getPageSetup().asc_getOrientation()==undefined),this.diffParams.size&&(this.diffParams.size=n.asc_getPageSetup().asc_getWidth()==undefined||n.asc_getPageSetup().asc_getHeight()==undefined),this.diffParams.headings&&(this.diffParams.headings=n.asc_getHeadings()==undefined),this.diffParams.grid&&(this.diffParams.grid=n.asc_getGridLines()==undefined),this.diffParams.margintop&&(this.diffParams.margintop=n.asc_getPageMargins().asc_getTop()==undefined),this.diffParams.marginright&&(this.diffParams.marginright=n.asc_getPageMargins().asc_getRight()==undefined),this.diffParams.marginbottom&&(this.diffParams.marginbottom=n.asc_getPageMargins().asc_getBottom()==undefined),this.diffParams.marginleft&&(this.diffParams.marginleft=n.asc_getPageMargins().asc_getLeft()==undefined)}else this.api.asc_setPageOptions(n,t),this.diffParams={}},openPrintSettings:function(){if(this.api){var e=Ext.widget("sseprintsettings",{});this.fillPageOptions(e,this.api.asc_getPageOptions()),this.fillPrintOptions(e,this.adjPrintParams),e.updateMetricUnit(),e.show()}},closePrintSettings:function(e,t){t==1&&(this.savePageOptions(e,e.groupRange.getValue().printrange==c_oAscPrintType.EntireWorkbook?-255:undefined),this.adjPrintParams.asc_setPrintType(e.groupRange.getValue().printrange),this.adjPrintParams.asc_setLayoutPageType(e.groupLayout.getValue().printlayout),this.api.asc_Print(this.adjPrintParams),this.isUpdatedSettings=!1),this.getToolbar().fireEvent("editcomplete",this.getToolbar())},querySavePrintSettings:function(){var e=this.getPrintAdvanced();this.checkMargins(e)&&(this.savePageOptions(e,e.cmbSheet.getValue()),e.up("ssedocumentsettings").fireEvent("savedocsettings",e))},queryClosePrintSettings:function(e){var t=e.up("window");this.checkMargins(t)&&(t.fireEvent("onmodalresult",t,1),t.close())},checkMargins:function(e){if(e.cmbPaperOrientation.getValue()==c_oAscPageOrientation.PagePortrait)var t=/^\d{3}\.?\d*/.exec(e.cmbPaperSize.getValue()),n=/\d{3}\.?\d*$/.exec(e.cmbPaperSize.getValue());else n=/^\d{3}\.?\d*/.exec(e.cmbPaperSize.getValue()),t=/\d{3}\.?\d*$/.exec(e.cmbPaperSize.getValue());var r=Common.MetricSettings.fnRecalcToMM(e.spnMarginLeft.getNumberValue()),i=Common.MetricSettings.fnRecalcToMM(e.spnMarginRight.getNumberValue()),s=Common.MetricSettings.fnRecalcToMM(e.spnMarginTop.getNumberValue()),o=Common.MetricSettings.fnRecalcToMM(e.spnMarginBottom.getNumberValue()),u=!1;return r>t?u="left":i>t-r?u="right":s>n?u="top":o>n-s&&(u="bottom"),u?(Ext.Msg.show({title:this.textWarning,msg:this.warnCheckMargings,icon:Ext.Msg.WARNING,buttons:Ext.Msg.OK,fn:function(t,n){switch(u){case"left":e.spnMarginLeft.focus();return;case"right":e.spnMarginRight.focus();return;case"top":e.spnMarginTop.focus();return;case"bottom":e.spnMarginBottom.focus();return}}}),!1):!0},warnCheckMargings:"Margins are incorrect",strAllSheets:"All Sheets",textWarning:"Warning"});