/*
 * (c) Copyright Ascensio System SIA 2010-2015
 *
 * This program is a free software product. You can redistribute it and/or 
 * modify it under the terms of the GNU Affero General Public License (AGPL) 
 * version 3 as published by the Free Software Foundation. In accordance with 
 * Section 7(a) of the GNU AGPL its Section 15 shall be amended to the effect 
 * that Ascensio System SIA expressly excludes the warranty of non-infringement
 * of any third-party rights.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR  PURPOSE. For 
 * details, see the GNU AGPL at: http://www.gnu.org/licenses/agpl-3.0.html
 *
 * You can contact Ascensio System SIA at Lubanas st. 125a-25, Riga, Latvia,
 * EU, LV-1021.
 *
 * The  interactive user interfaces in modified source and object code versions
 * of the Program must display Appropriate Legal Notices, as required under 
 * Section 5 of the GNU AGPL version 3.
 *
 * Pursuant to Section 7(b) of the License you must retain the original Product
 * logo when distributing the program. Pursuant to Section 7(e) we decline to
 * grant you any rights under trademark law for use of our trademarks.
 *
 * All the Product's GUI elements, including illustrations and icon sets, as
 * well as technical writing content are licensed under the terms of the
 * Creative Commons Attribution-ShareAlike 4.0 International. See the License
 * terms at http://creativecommons.org/licenses/by-sa/4.0/legalcode
 *
 * Version: 1.0 (build:28)
 */
Ext.define("Common.plugin.GridScrollPane",{extend:"Common.plugin.ScrollPane",alias:"plugin.gridscrollpane",areaSelector:".x-grid-view",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001},init:function(e){var t=this,n;t.callParent(arguments),n=t.cmp.getStore(),n&&n.on("datachanged",t.updateScrollPane,t,{buffer:10}),t.cmp.on("viewready",t.onViewReady,t,{single:!0})},onKeyDown:function(e,t){var n=this,r=n.cmp.getStore(),i=function(e){var t=n.cmp.getView().getNode(r.getAt(e)),i=Ext.create("Ext.Element",t);if(t){var s=Ext.getDom(n.cmp.getTargetEl())||Ext.getBody().dom,o=i.getOffsetsTo(s),u=o[1]+s.scrollTop,a=u+t.offsetHeight,f=s.clientHeight,l=parseInt(s.scrollTop,10),c=l+f;t.offsetHeight>f||u<l?n.jspApi&&n.jspApi.scrollByY(u,!1):a>c&&n.jspApi&&n.jspApi.scrollByY(a-f,!1)}};switch(e.getKey()){case e.UP:case e.DOWN:var s=n.cmp.getSelectionModel().getLastSelected(),o=s?r.indexOf(s):-1;i(o);break;case e.PAGE_UP:case e.PAGE_DOWN:break;case e.HOME:i(0);break;case e.END:i(r.count()-1)}},onViewReady:function(){var e=this;e.cmp.getView().getEl().on("keydown",e.onKeyDown,e,{stopEvent:!0})}}),Ext.define("Common.plugin.ComboBoxScrollPane",{extend:"Common.plugin.ScrollPane",alias:"plugin.comboboxscrollpane",areaSelector:".list-ct",init:function(e){e.on("expand",this.onExpand,this)},onExpand:function(e){var t=this;if(!t.picker){t.picker=e.getPicker(),t.picker.on({viewready:t.onViewReady,resize:function(){t.updateScrollPane()},beforecontainerclick:function(){return!1},beforeitemmouseenter:function(t,n,r,i,s,o){if(e.scrolllocked)return!1},scope:t}),t.cmp.on("afterlayout",t.onViewReady,t,{single:!0}),e.on("keydown",t.onKeyDown,t);var n=e.getStore();n.on("datachanged",t.onDataChanged,t,{buffer:10})}},onKeyDown:function(e,t,n){var r=this,i=function(e){var t=r.picker,n=t.all.item(e);if(n){var i=Ext.getDom(t.getTargetEl())||Ext.getBody().dom,s=n.dom,o=n.getOffsetsTo(i),u=o[1]+i.scrollTop,a=u+s.offsetHeight,f=i.clientHeight,l=parseInt(i.scrollTop,10),c=l+f;s.offsetHeight>f||u<l?r.jspApi&&r.jspApi.scrollByY(u,!1):a>c&&r.jspApi&&r.jspApi.scrollByY(a-f,!1)}};switch(t.getKey()){case t.UP:var s=r.picker,o=s.all,u=s.highlightedItem,a=u?s.indexOf(u):-1,f=a>0?a-1:o.getCount()-1;i(f);break;case t.DOWN:var s=r.picker,o=s.all,u=s.highlightedItem,a=u?s.indexOf(u):-1,f=a<o.getCount()-1?a+1:0;i(f);break;case t.PAGE_UP:case t.PAGE_DOWN:break;case t.HOME:i(0);break;case t.END:i(r.picker.all.getCount()-1)}},onViewReady:function(){var e=this;e.initScrollPane(e.picker.getEl().dom)},onDataChanged:function(){var e=this;e.picker.getWidth()&&e.picker.getHeight()&&e.initScrollPane(e.picker.getEl().dom)}}),Ext.define("Common.component.util.RGBColor",{alternateClassName:"Common.util.RGBColor",constructor:function(e){this.ok=!1,e.charAt(0)=="#"&&(e=e.substr(1,6)),e=e.replace(/ /g,""),e=e.toLowerCase();var t=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){return[parseInt(e[1]),parseInt(e[2]),parseInt(e[3])]}},{re:/^hsb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(e){var t={},n=Math.round(e[1]),r=Math.round(e[2]*255/100),i=Math.round(e[3]*255/100);if(r==0)t.r=t.g=t.b=i;else{var s=i,o=(255-r)*i/255,u=(s-o)*(n%60)/60;n==360&&(n=0),n<60?(t.r=s,t.b=o,t.g=o+u):n<120?(t.g=s,t.b=o,t.r=s-u):n<180?(t.g=s,t.r=o,t.b=o+u):n<240?(t.b=s,t.r=o,t.g=s-u):n<300?(t.b=s,t.g=o,t.r=o+u):n<360?(t.r=s,t.g=o,t.b=s-u):(t.r=0,t.g=0,t.b=0)}return[Math.round(t.r),Math.round(t.g),Math.round(t.b)]}},{re:/^(\w{2})(\w{2})(\w{2})$/,process:function(e){return[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,process:function(e){return[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]}}];for(var n=0;n<t.length;n++){var r=t[n].re,i=t[n].process,s=r.exec(e);if(s){var o=i(s);this.r=o[0],this.g=o[1],this.b=o[2],this.ok=!0}}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.isEqual=function(e){return this.r==e.r&&this.g==e.g&&this.b==e.b},this.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"},this.toRGBA=function(e){return e===undefined&&(e=1),"rgba("+this.r+", "+this.g+", "+this.b+", "+e+")"},this.toHex=function(){var e=this.r.toString(16),t=this.g.toString(16),n=this.b.toString(16);return e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),"#"+e+t+n},this.toHSB=function(){var e={h:0,s:0,b:0},t=Math.min(this.r,this.g,this.b),n=Math.max(this.r,this.g,this.b),r=n-t;return e.b=n,e.s=n!=0?255*r/n:0,e.s!=0?this.r==n?e.h=0+(this.g-this.b)/r:this.g==n?e.h=2+(this.b-this.r)/r:e.h=4+(this.r-this.g)/r:e.h=0,e.h*=60,e.h<0&&(e.h+=360),e.s*=100/255,e.b*=100/255,e.h=parseInt(e.h),e.s=parseInt(e.s),e.b=parseInt(e.b),e}}}),Ext.define("Common.component.DataViewPicker",{extend:"Ext.container.Container",requires:["Ext.data.Store","Ext.data.Model","Ext.view.View","Ext.XTemplate","Ext.container.Container","Common.plugin.DataViewScrollPane"],uses:["Common.component.GroupedDataView"],alias:"widget.cmddataviewpicker",layout:{type:"fit"},constructor:function(e){if(!e||!e.viewData)throw Error("Common.component.DataViewPicker creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);e.selectedRec=null,Ext.define("DataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]}),e.store=Ext.isDefined(t.store)?t.store:Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"DataModel",data:t.viewData});var n=Ext.isDefined(t.dataTpl)?t.dataTpl:Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">',e.itemWidth!==undefined&&e.itemHeight!==undefined?'<img src="{imageUrl}" width="'+e.itemWidth+'" height="'+e.itemHeight+'"/>':'<img src="{imageUrl}" />','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>");if(e.isGroupedDataView)var r=Ext.create("Common.component.GroupedDataView",{store:e.store,listeners:{itemclick:function(t,n,r,i,s,o){e.selectedRec=n,e.fireEvent("select",e,n,r,i)},beforecontainerclick:function(e,t,n){return!1},selectionchange:function(t,n,i){var s=r.getPlugin("scrollpane"),o=r.getNode(n[0]);s&&o&&s.scrollToElement(o),e.fireEvent("selectionchange",e,t,n)},itemkeydown:function(e,t,n,r,i,s){i.getKey()==i.ENTER&&e.fireEvent("itemclick",e,t,n,r,i,s)}},plugins:[{ptype:"dataviewscrollpane",areaSelector:".grouped-data-view",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001,contentWidth:e.contentWidth}}]});else var r=Ext.create("Ext.view.View",{store:e.store,tpl:n,singleSelect:!0,trackOver:!0,autoScroll:!0,overItemCls:"x-item-over",itemSelector:"div.thumb-wrap",emptyText:"",cls:"storage-data-view",listeners:{itemclick:function(t,n,r,i,s,o){e.selectedRec=n,e.fireEvent("select",e,n,r,i)},beforecontainerclick:function(e,t,n){return!1},selectionchange:function(t,n,r){e.fireEvent("selectionchange",e,t,n)},itemkeydown:function(e,t,n,r,i,s){i.getKey()==i.ENTER&&e.fireEvent("itemclick",e,t,n,r,i,s)},itemmouseenter:function(t,n,r,i,s,o){e.fireEvent("itemmouseenter",e,n,r,i,s,o)},itemmouseleave:function(t,n,r,i,s,o){e.fireEvent("itemmouseleave",e,n,r,i,s,o)}},plugins:[{ptype:"dataviewscrollpane",areaSelector:".storage-data-view",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0,keyboardSpeed:.001,contentWidth:e.contentWidth}}]});e.addEvents("select","itemmouseenter","itemmouseleave"),e.handler&&e.on("select",e.handler,e.scope,e),e.getSelectedRec=function(){return e.isGroupedDataView?r.getSelected():r.getSelectionModel().getSelection()[0]},e.selectByIndex=function(t,n){if(r.rendered)if(t<0)r.getSelectionModel().deselectAll(!1),e.selectedRec=null;else{var i=Ext.isDefined(n)?n:!0;e.selectedRec=e.store.getAt(t),r.getSelectionModel().select(e.store.getAt(t),!1,i)}else r.on("afterrender",Ext.bind(function(t){e.selectByIndex(t)},this,[t]),{single:!0})},e.selectGroupItem=function(t,n){return!e.isGroupedDataView||!r?null:(e.selectedRec=r.selectGroupItem(t,n),e.selectedRec)},e.updateScrollPane=function(){var t=r.getPlugin("scrollpane");t&&r.getEl()&&r.getEl().getWidth()>0&&(t.settings&&(t.settings.contentWidth=e.contentWidth),t.updateScrollPane(r.getEl().dom),e.checkScrolls(),e.arrangeItems&&e.arrangeItems.call(e))},e.checkScrolls=function(){var t=r.getPlugin("scrollpane");if(t&&r.getEl()){var n=e.getEl().down(".jspPane");if(n.getHeight()>0&&e.getEl().getHeight()>0)var i=0,s=setInterval(function(){n.getHeight()>e.getEl().getHeight()&&(e.getEl().down(".jspVerticalBar")?clearInterval(s):(t.updateScrollPane(r.getEl().dom),clearInterval(s))),i++>3&&clearInterval(s)},100)}},e.showUpdated=function(){e.updateScrollPane(),r&&r.getEl()&&(r.getEl().focus(50),e.selectedRec?r.getSelectionModel().select(e.selectedRec,!1,!1):r.getSelectionModel().deselectAll(!1))},r.getStore().on("datachanged",e.updateScrollPane,e,{buffer:10}),r.on("viewready",e.updateScrollPane,e),e.on("resize",e.updateScrollPane,e),e.on("afterlayout",e.updateScrollPane,e),e.items=[r],this.callParent(arguments)}}),Ext.define("Common.component.MenuDataViewPicker",{extend:"Ext.menu.Menu",alias:"widget.cmdmenudataviewpicker",requires:["Common.component.DataViewPicker"],hideOnClick:!0,hideMode:"display",constructor:function(e){if(!e||!e.viewData)throw Error("Common.component.MenuDataViewPicker creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);delete t.listeners,Ext.apply(e,{plain:!0,showSeparator:!1,items:Ext.applyIf({xtype:"cmddataviewpicker",padding:Ext.isDefined(t.pickerpadding)?t.pickerpadding:"2px 4px 1px 2px",store:t.store},t)}),e.callParent(arguments),e.picker=e.down("cmddataviewpicker"),e.relayEvents(e.picker,["select","itemmouseenter","itemmouseleave"]),e.hideOnClick&&e.on("select",e.hidePickerOnSelect,e),e.on("resize",function(t,n,r,i){e.applyContentWidth&&n>=20&&(e.picker.contentWidth=n-20),e.picker.setSize(n,r)},this),e.on("show",function(t){e.picker.showUpdated()},this)},hidePickerOnSelect:function(e,t,n){Ext.menu.Manager.hideAll()}}),Ext.define("Common.component.HSBColorPicker",{extend:"Ext.Component",alias:"widget.hsbcolorpicker",requires:["Common.component.util.RGBColor","Ext.XTemplate"],baseCls:"cmp-hsb-colorpicker",allowEmptyColor:!1,changeSaturation:!0,showCurrentColor:!0,config:{color:"#ff0000"},renderTpl:['<div class="{baseCls}-root">','<tpl if="showCurrentColor">','<div class="{baseCls}-top-panel">','<span class="{baseCls}-color-value">','<span class="transparent-color"></span>',"</span>",'<div class="{baseCls}-color-text"></div>',"</div>","</tpl>","<div>",'<div class="{baseCls}-cnt-hb">','<div class="{baseCls}-cnt-hb-arrow"></div>',"</div>",'<tpl if="changeSaturation">','<div class="{baseCls}-cnt-root">','<div class="{baseCls}-cnt-sat">','<div class="{baseCls}-cnt-sat-arrow"></div>',"</div>","</div>","</tpl>","</div>",'<tpl if="allowEmptyColor">','<div class="{baseCls}-empty-color">{textNoColor}</div>',"</tpl>","</div>"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t,n,r,i,s,o,u,a,f=0,l=100,c=100,h=function(t,n){var r=new Common.util.RGBColor(Ext.String.format("hsb({0}, {1}, {2})",t.h,t.s,t.b)),i=r.toHex();e.color=n?"transparent":i,p(),e.fireEvent("changecolor",e,e.color)},p=function(){s&&o&&(e.color=="transparent"?o.show():(s.setStyle("background-color",e.color),o.hide())),r&&r.setStyle("background-color",(new Common.util.RGBColor(Ext.String.format("hsb({0}, 100, 100)",f))).toHex()),u&&(u.dom.innerHTML=e.color=="transparent"?e.textNoColor:e.color.toUpperCase()),t&&n&&(t.setLeft(l+"%"),t.setTop(100-c+"%"),n.setTop(parseInt(f*100/360)+"%"))},d=function(e,n,i){if(t&&r){var s=[Math.max(0,Math.min(100,parseInt((e.getX()-r.getX())/r.getWidth()*100))),Math.max(0,Math.min(100,parseInt((e.getY()-r.getY())/r.getHeight()*100)))];t.setLeft(s[0]+"%"),t.setTop(s[1]+"%"),l=s[0],c=100-s[1],h({h:f,s:l,b:c})}},v=function(e,t,r){if(n&&i){var s=Math.max(0,Math.min(100,parseInt((e.getY()-i.getY())/i.getHeight()*100)));n.setTop(s+"%"),f=parseInt(360*s/100),h({h:f,s:l,b:c})}},m=function(e,t,n){Ext.getDoc().on("mouseup",g),Ext.getDoc().on("mousemove",d)},g=function(e,t,n){Ext.getDoc().un("mouseup",g),Ext.getDoc().un("mousemove",d),d(e,t,n)},y=function(e,t,n){Ext.getDoc().on("mouseup",b),Ext.getDoc().on("mousemove",v),v(e,t,n)},b=function(e,t,n){Ext.getDoc().un("mouseup",b),Ext.getDoc().un("mousemove",v)},w=function(t){var n=(new Common.util.RGBColor(e.color)).toHSB();h(n,!0)},E=function(h){var d=e.getEl(),v;d&&(t=d.down("."+e.baseCls+"-cnt-hb-arrow"),n=d.down("."+e.baseCls+"-cnt-sat-arrow"),r=d.down("."+e.baseCls+"-cnt-hb"),i=d.down("."+e.baseCls+"-cnt-sat"),s=d.down("."+e.baseCls+"-color-value"),u=d.down("."+e.baseCls+"-color-text"),a=d.down("."+e.baseCls+"-empty-color"),s&&(o=s.child(".transparent-color")),r&&(r.un("mousedown"),r.on("mousedown",m,e)),i&&(i.un("mousedown"),i.on("mousedown",y,e)),a&&(a.un("click"),a.on("click",w,e)),e.color=="transparent"?v={h:0,s:100,b:100}:v=(new Common.util.RGBColor(e.color)).toHSB(),f=v.h,l=v.s,c=v.b,f==l&&f==c&&f==0&&(l=100),p())};e.setColor=function(t){if(e.color==t)return;var n;t=="transparent"?n={h:0,s:100,b:100}:n=(new Common.util.RGBColor(t)).toHSB(),f=n.h,l=n.s,c=n.b,f==l&&f==c&&f==0&&(l=100),e.color=t,p()},e.on("afterrender",E,this),e.callParent(arguments),this.addEvents("changecolor")},onRender:function(e,t){var n=this;Ext.applyIf(n.renderData,n.getTemplateArgs()),n.callParent(arguments)},getTemplateArgs:function(){var e=this;return{allowEmptyColor:e.allowEmptyColor,changeSaturation:e.changeSaturation,textNoColor:e.textNoColor,showCurrentColor:e.showCurrentColor}},textNoColor:"No Color"}),Ext.define("Common.component.MultiSliderGradient",{extend:"Ext.slider.Multi",requires:[],uses:[],alias:"widget.cmdmultislidergradient",cls:"asc-multi-slider-gradient",values:[0,100],increment:1,minValue:0,maxValue:100,clickRange:[1,20],colorValues:["#000000","#ffffff"],currentThumb:0,initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);if(e.initialConfig.listeners&&e.initialConfig.listeners.change){var n=e.initialConfig.listeners.change;e.initialConfig.listeners.change=function(t,r,i){e.changeGradientStyle(),n.call(e,t,r,i)}}this.styleStr="",Ext.isChrome&&Ext.chromeVersion<10||Ext.isSafari&&Ext.safariVersion<5.1?this.styleStr="-webkit-gradient(linear, left top, right top, color-stop({1}%,{0}), color-stop({3}%,{2})); /* Chrome,Safari4+ */":Ext.isChrome||Ext.isSafari?this.styleStr="-webkit-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isGecko?this.styleStr="-moz-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isOpera&&Ext.operaVersion>11?this.styleStr="-o-linear-gradient(left, {0} {1}%, {2} {3}%)":Ext.isIE&&(this.styleStr="-ms-linear-gradient(left, {0} {1}%, {2} {3}%)"),this.callParent(arguments),this.addEvents("thumbclick"),this.addEvents("thumbdblclick")},listeners:{afterrender:function(e){var t=this,n="";if(t.thumbs){for(var r=0;r<t.thumbs.length;r++)t.thumbs[r]&&t.thumbs[r].tracker&&(t.thumbs[r].tracker.addListener("mousedown",Ext.bind(t.setActiveThumb,t,[r,!0]),t),t.thumbs[r].tracker.el.addListener("dblclick",function(){t.fireEvent("thumbdblclick",t)},t));t.setActiveThumb(0),t.innerEl&&(Ext.isEmpty(t.styleStr)||(n=Ext.String.format(t.styleStr,t.colorValues[0],0,t.colorValues[1],100),t.innerEl.setStyle("background",n)),Ext.isIE&&(n=Ext.String.format("progid:DXImageTransform.Microsoft.gradient( startColorstr={0}, endColorstr={1},GradientType=1 )",t.colorValues[0],t.colorValues[1]),t.innerEl.setStyle("filter",n)),n=Ext.String.format("linear-gradient(to right, {0} {1}%, {2} {3}%)",t.colorValues[0],0,t.colorValues[1],100),t.innerEl.setStyle("background",n))}}},setActiveThumb:function(e,t){this.currentThumb=e,this.thumbs[e].el.addCls("active-thumb");for(var n=0;n<this.thumbs.length;n++){if(e==n)continue;this.thumbs[n].el.removeCls("active-thumb")}t&&this.fireEvent("thumbclick",this,e)},setColorValue:function(e,t){var n=t!==undefined?t:this.currentThumb;this.colorValues[n]=e,this.changeGradientStyle()},getColorValue:function(e){var t=e!==undefined?e:this.currentThumb;return this.colorValues[t]},changeGradientStyle:function(){if(this.innerEl){var e;Ext.isEmpty(this.styleStr)||(e=Ext.String.format(this.styleStr,this.colorValues[0],this.getValue(0),this.colorValues[1],this.getValue(1)),this.innerEl.setStyle("background",e)),Ext.isIE&&(e=Ext.String.format("progid:DXImageTransform.Microsoft.gradient( startColorstr={0}, endColorstr={1},GradientType=1 )",this.colorValues[0],this.colorValues[1]),this.innerEl.setStyle("filter",e)),e=Ext.String.format("linear-gradient(to right, {0} {1}%, {2} {3}%)",this.colorValues[0],this.getValue(0),this.colorValues[1],this.getValue(1)),this.innerEl.setStyle("background",e)}},getNearest:function(e,t){var n=this,r=t=="top"?n.innerEl.getHeight()-e[t]:e[t],i=n.reverseValue(r),s=n.maxValue-n.minValue+5,o=0,u=null,a=n.thumbs,f=0,l=a.length,c,h,p;for(;f<l;f++){c=n.thumbs[f],h=c.value,p=Math.abs(h-i);if(Math.abs(p<=s)){if(n.constrainThumbs){var d=n.thumbs[f+1],v=n.thumbs[f-1];if(v!==undefined&&i<v.value)continue;if(d!==undefined&&i>d.value)continue}u=c,o=f,s=p}}return u}}),Ext.define("Common.component.SynchronizeTip",{extend:"Ext.container.Container",alias:"widget.commonsynchronizetip",cls:"asc-synchronizetip",requires:["Ext.button.Button","Ext.form.Label"],layout:{type:"vbox",align:"stretch"},width:240,height:95,hideMode:"visibility",constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this;e.addEvents("dontshowclick"),e.addEvents("closeclick");var t=Ext.widget("button",{cls:"btn-close-tip",iconCls:"icon-close-tip",listeners:{click:function(){e.fireEvent("closeclick",e)}}});e.items=[{xtype:"container",html:'<div class="tip-arrow"></div>'},{xtype:"container",flex:1,style:"padding-left: 15px;",layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",flex:1,style:"margin-top: 15px;line-height: 1.2;",html:"<div>"+e.textSynchronize+"</div>"},t]},{xtype:"container",cls:"show-link",items:[{xtype:"label",text:e.textDontShow,listeners:{afterrender:function(t){t.getEl().on("click",function(t,n){e.fireEvent("dontshowclick",e)})},scope:this}}]}],e.callParent(arguments)},textDontShow:"Don't show this message again",textSynchronize:"The document has changed. <br/>Refresh the document to see the updates."}),Ext.define("Common.component.ComboDataView",{extend:"Ext.container.Container",requires:["Ext.data.Model","Ext.data.Store","Ext.view.View","Ext.XTemplate"],alias:"widget.commoncombodataview",padding:4,itemWidth:80,itemHeight:40,menuHeight:100,menuMaxHeight:500,minWidth:150,emptyComboText:"No styles",handleGlobalResize:!1,constructor:function(e){if(!e||!e.viewData||!e.itemWidth||!e.itemHeight)throw Error("ComboDataView creation failed: required parameters are missing.");return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig),n=0,r=0,i=0,s=0,o=0,u=0,a=!0,f=Ext.util.CSS.getRule(".storage-combodataview");f&&(n=parseInt(f.style.borderWidth),isNaN(n)&&(n=0)),Ext.define("DataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]});var l=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:Ext.isDefined(t.store)?t.store.model:"DataModel",data:t.viewData}),c=Ext.isDefined(t.dataTpl)?t.dataTpl:Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="{imageUrl}" width="'+e.itemWidth+'" height="'+e.itemHeight+'"/>','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>");this.dataMenu=Ext.widget("cmdmenudataviewpicker",{width:e.width,height:e.menuHeight,cls:"x-dataview-combo-menu",viewData:t.viewData,dataTpl:t.dataTpl,store:t.store,itemWidth:e.itemWidth,itemHeight:e.itemHeight,constrain:!1,pickerpadding:e.padding-1,listeners:{hide:function(t,n){e.fireEvent("menuhide",e,t)}}});var h=Ext.widget("dataview",{store:l,tpl:c,singleSelect:!0,trackOver:!0,style:"overflow:auto",overItemCls:"x-item-over",itemSelector:"div.thumb-wrap",emptyText:'<div class="emptyText">'+e.emptyComboText+"</div>",deferEmptyText:!1,cls:"x-view-context",listeners:{itemclick:function(n,r,i,s,o,u){t.repeatedselect&&n.getSelectionModel().getLastSelected()!==null&&n.getSelectionModel().getLastSelected().id==r.id&&e.fireEvent("select",e,r)},afterrender:Ext.bind(function(e,t){l.getCount()>0&&(e.select(l.getAt(0)),this.dataMenu.picker.selectByIndex(0))},this),beforecontainerclick:function(e,t,n){return!1},itemdblclick:function(t,n,r,i,s,o){e.fireEvent("releasecapture",e)}}}),p=Ext.widget("container",{flex:1,height:e.height-2*(e.padding+n),items:[h]}),d=Ext.widget("button",{cls:"x-btn-combodataview",height:e.height-2*(e.padding+n),handler:Ext.bind(function(t,r){a&&e.getDataViewCSSRules();var i=Math.floor(e.getEl().getWidth()/(e.itemWidth+s+o)),f=e.dataMenu.picker.store.getCount(),l=Math.ceil(f/i);if(l>1){var c=l*(e.itemHeight+2*u+s+o)+6,h=Math.min(e.menuMaxHeight,Ext.Element.getViewportHeight()-this.getPosition()[1]-6);c>h&&(c=h),e.dataMenu.show(),e.dataMenu.setSize(e.getEl().getWidth(),c),e.dataMenu.showBy(p,"tl-tl",[-e.padding+n,-e.padding+n])}},this)});this.fillComboView=function(t,n,r){if(Ext.isDefined(t)){var i=e.dataMenu.picker.store;if(i){if(r||l.find("uid",t.data.uid)<0){a&&e.getDataViewCSSRules(),l.removeAll();var u=i.indexOf(t),f=i.getCount(),c=Math.floor(p.getWidth()/(e.itemWidth+s+o)),d=[];p.getHeight()/e.itemHeight>2&&(c*=Math.floor(p.getHeight()/e.itemHeight));if(u<0)return;u=Math.floor(u/c)*c;for(var v=u,m=0;v<f&&m<c;v++,m++){var g=i.getAt(v),y={};for(var b=0;b<g.fields.length;b++)y[g.fields.items[b].name]=g.data[g.fields.items[b].name];d.push(y)}l.add(d)}if(n){var w=l.find("uid",t.data.uid);w>-1&&h.select(l.getAt(w),!1,!0)}}}},this.selectByIndex=function(t){t<0&&h.getSelectionModel().deselectAll(!1),e.dataMenu.picker.selectByIndex(t,!1)};var v=function(t,n){e.fillComboView(n,!0),n&&e.fireEvent("select",e,n)},m=function(t,n,r){var i=n[0];i&&(e.dataMenu.picker.selectByIndex(e.dataMenu.picker.store.findExact("uid",i.get("uid")),!1),e.fireEvent("select",e,i))},g=function(t,n,r){e.fillComboView(r[0],!0)},y=function(t,n){if(e.dataMenu){e.dataMenu.setWidth(t),e.dataMenu.hide();var r=e.dataMenu.picker;if(r){var i=r.getSelectedRec();e.fillComboView(i||r.store.getAt(0),!!i,!0)}}};e.handleGlobalResize?(e.on("afterrender",function(e){var t=e.getEl().down(".x-box-inner");t&&t.addCls("combodataview-auto-width")},this),Ext.EventManager.onWindowResize(function(){var t=e.getEl();t&&(e.doLayout(),y(t.getWidth()))},this)):e.on("resize",function(e,t,n){y(t,n)},this),this.dataMenu.addListener("select",v,e),this.dataMenu.picker.addListener("selectionchange",g,e),h.addListener("selectionchange",m,e),e.addEvents("select","menuhide","releasecapture"),e.addListener("afterrender",function(){Ext.util.CSS.refreshCache();var t=Ext.util.CSS.getRule(".x-dataview-combo-menu .storage-data-view .thumb-wrap");t&&(s=parseInt(t.style.paddingLeft),isNaN(s)&&(s=0),o=parseInt(t.style.paddingRight),isNaN(o)&&(o=0),u=parseInt(t.style.marginRight),isNaN(u)&&(u=0),a=!1),Ext.defer(function(){e.dataMenu.showAt([-1e4,-1e4]),e.fireEvent("releasecapture",e)},100)},this),e.getDataViewCSSRules=function(){if(e.dataMenu.picker.getEl()){var t=e.dataMenu.picker.getEl().down(".thumb-wrap");t&&(s=parseInt(t.getStyle("paddingLeft")),isNaN(s)&&(s=0),o=parseInt(t.getStyle("paddingRight")),isNaN(o)&&(o=0),u=parseInt(t.getStyle("marginRight")),isNaN(u)&&(u=0),a=!1)}},Ext.apply(e,{layout:{type:"hbox",align:"stretch"},cls:"storage-combodataview",items:[p,d]},t),this.callParent(arguments)}}),Ext.define("Common.view.ExtendedColorDialog",{extend:"Ext.window.Window",alias:"widget.commonextendedcolordialog",cls:"common-extendedcolordialog",requires:["Ext.window.Window","Common.component.HSBColorPicker"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,closeAction:"destroy",plain:!0,height:276,width:326,minWidth:188,padding:"16px",layout:{type:"vbox",align:"stretch"},listeners:{beforehide:function(){this._modalresult===undefined&&this.fireEvent("onmodalresult",0)},show:function(){this.textColor.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){function r(e){if(!n.stopevents){var t=(n.spinR.getValue()==null?0:n.spinR.getValue()).toString(16),r=(n.spinG.getValue()==null?0:n.spinG.getValue()).toString(16),i=(n.spinB.getValue()==null?0:n.spinB.getValue()).toString(16),s=(t.length==1?"0"+t:t)+(r.length==1?"0"+r:r)+(i.length==1?"0"+i:i);n.colorsPicker.setColor("#"+s),e!="hex"&&n.textColor.setValue(s.toUpperCase()),n.colorNew.getEl().setStyle("background-color","#"+s)}}var e=Ext.create("Ext.Button",{text:this.addButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),n=this;n.hexRe=/\s*#?([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)([0-9a-fA-F][0-9a-fA-F]?)\s*/,this.colorsPicker=Ext.widget("hsbcolorpicker",{height:198,color:"#000000",width:220,changeSaturation:!0,showCurrentColor:!1,style:"margin-top:2px;margin-right:6px;",listeners:{render:function(e){$("."+this.baseCls+"-cnt-root").css("margin-right","0")},changecolor:function(e,t){n.colorNew.getEl().setStyle("background-color",t),n.stopevents=!0;var r=t.match(n.hexRe);n.spinR.setValue(parseInt(r[1],16)),n.spinG.setValue(parseInt(r[2],16)),n.spinB.setValue(parseInt(r[3],16)),n.textColor.setValue((r[1]+r[2]+r[3]).toUpperCase()),n.stopevents=!1}}}),this.spinR=Ext.widget("numberfield",{fieldLabel:"R",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:4px;",listeners:{change:r}}),this.spinG=Ext.widget("numberfield",{fieldLabel:"G",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:4px;",listeners:{change:r}}),this.spinB=Ext.widget("numberfield",{fieldLabel:"B",labelWidth:10,width:80,minValue:0,maxValue:255,value:0,style:"margin-bottom:16px;",listeners:{change:r}}),this.colorSaved=Ext.widget("box",{id:"field-start-color",height:20}),this.colorNew=Ext.widget("box",{height:20}),this.textColor=Ext.widget("textfield",{fieldLabel:"#",labelWidth:10,maskRe:/[a-fA-F0-9]/,maxLength:6,enforceMaxLength:!0,validator:function(e){if(!/^[a-fA-F0-9]{0,6}$/.test(e))return"Incorrect color value";e="000000"+e;var t=e.match(/([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$/i);return n.stopevents=!0,n.spinR.setValue(parseInt(t[1],16)),n.spinG.setValue(parseInt(t[2],16)),n.spinB.setValue(parseInt(t[3],16)),n.stopevents=!1,this.rendered&&r("hex"),!0},listeners:{afterrender:function(e){e.inputEl.setStyle("text-align","right")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"container",height:202,layout:{type:"hbox",align:"stretch"},items:[this.colorsPicker,{xtype:"container",width:68,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",text:this.textNew,style:"text-align:center;width:100%;margin-bottom:2px;"},this.colorNew,this.colorSaved,{xtype:"label",text:this.textCurrent,style:"text-align:center;width:100%;margin-top:2px;margin-bottom:14px;"},this.spinR,this.spinG,this.spinB,this.textColor]}]},{xtype:"tbspacer",height:14},{xtype:"container",layout:{type:"hbox",align:"middle",pack:"center"},items:[e,{xtype:"tbspacer",width:10},t]}],this.callParent(arguments)},getColor:function(){var e=/#?([a-fA-F0-9]{6})/.exec(this.colorsPicker.getColor());return e?e[1]:null},setColor:function(e){function r(){e=="transparent"?t.colorSaved.addCls("color-transparent"):(t.colorSaved.removeCls("color-transparent"),t.colorSaved.getEl().setStyle("background-color","#"+e)),t.colorNew.getEl().setStyle("background-color","#"+n)}var t=this,n=/#?([a-fA-F0-9]{6})/.test(e)?e:"ff0000";t.colorsPicker.setColor("#"+n),t.colorSaved.rendered?r():t.colorSaved.on("afterrender",r,{single:!0}),t.stopevents=!0;var i=t.hexRe.exec(n);t.spinR.setValue(parseInt(i[1],16)),t.spinG.setValue(parseInt(i[2],16)),t.spinB.setValue(parseInt(i[3],16)),t.textColor.setValue((i[1]+i[2]+i[3]).toUpperCase()),t.stopevents=!1},cancelButtonText:"Cancel",addButtonText:"Add",textNew:"New",textCurrent:"Current"}),Ext.define("Common.view.ImageFromUrlDialog",{extend:"Ext.window.Window",alias:"widget.commonimagefromurldialog",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,preventHeader:!0,plain:!0,height:114,width:350,padding:"20px",layout:"vbox",layoutConfig:{align:"stretch"},listeners:{show:function(){this.txtUrl.focus(!1,500)}},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=Ext.create("Ext.Button",{id:"imgdialog-button-ok",text:this.okButtonText,width:80,cls:"asc-blue-button",listeners:{click:function(){if(!this.txtUrl.isValid())return;this._modalresult=1,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}}),t=Ext.create("Ext.Button",{id:"imgdialog-button-cancel",text:this.cancelButtonText,width:80,cls:"asc-darkgray-button",listeners:{click:function(){this._modalresult=0,this.fireEvent("onmodalresult",this._modalresult),this.close()},scope:this}});this.txtUrl=Ext.create("Ext.form.Text",{id:"imgdialog-text-url",width:310,msgTarget:"side",validateOnBlur:!1,allowBlank:!1,value:"",blankText:this.txtEmpty,regex:/(((^https?)|(^ftp)):\/\/([\-\wа-яё]+\.)+[\wа-яё]{2,3}(\/[%\-\wа-яё]+(\.[\wа-яё]{2,})?)*(([\wа-яё\-\.\?\\\/+@&#;`~=%!]*)(\.[\wа-яё]{2,})?)*\/?)/i,regexText:this.txtNotUrl,listeners:{specialkey:function(n,r){r.getKey()==r.ENTER?e.fireEvent("click"):r.getKey()==r.ESC&&t.fireEvent("click")}}}),this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.textUrl,width:"100%",style:"text-align:left"},{xtype:"tbspacer",height:3},this.txtUrl,{xtype:"tbspacer",height:3},{xtype:"container",width:310,layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"tbspacer",flex:1},e,{xtype:"tbspacer",width:5},t]}],this.callParent(arguments)},textUrl:"Paste an image URL:",cancelButtonText:"Cancel",okButtonText:"Ok",txtEmpty:"This field is required",txtNotUrl:'This field should be a URL in the format "http://www.example.com"'}),Ext.define("Common.view.CopyWarning",{extend:"Ext.window.Window",alias:"widget.commoncopywarning",requires:["Ext.window.Window"],modal:!0,closable:!0,resizable:!1,constrain:!0,plain:!0,width:410,height:270,layout:{type:"border"},onEsc:function(){this.close()},initComponent:function(){this.items=[{xtype:"container",region:"center",layout:{type:"vbox",align:"center"},items:[{xtype:"box",padding:"15px 0 0 0",html:'<p style="font-size: 14pt; text-align: center;font-family: Arial;">'+this.textTitle+"</p><br>"+'<p style="height:52px; text-align: center; font-size: 8pt; font-family: Arial; color: #636363;padding: 10px 30px 0 30px;">'+this.textMsg+"</p>"},{xtype:"container",width:300,height:70,padding:"15px 0 0 0",layout:{type:"hbox",align:"stretch"},defaults:{xtype:"container",width:"50%"},items:[{layout:{type:"vbox",align:"center"},items:[{xtype:"box",html:'<p style="text-align: center; font-size: 18pt;font-family: Arial;">Ctrl+C</p><p style="text-align: center;font-family: Arial;">'+this.textToCopy+"</p>"}]},{style:"left: 50%;",layout:{type:"vbox",align:"center"},items:[{xtype:"box",html:'<p style="text-align: center; font-size: 18pt;font-family: Arial;">Ctrl+V</p><p style="text-align: center;font-family: Arial;">'+this.textToPaste+"</p>"}]}]}]},{xtype:"container",region:"south",height:58,style:"border-top: 1px solid #E5E5E5",padding:"16px 0 0 0",layout:{type:"vbox",align:"center"},items:[{xtype:"button",cls:"asc-blue-button",width:85,text:Ext.Msg.buttonText.ok,handler:Ext.bind(function(e){this.close()},this)}]}],this.callParent(arguments)},textTitle:"ONLYOFFICE Docs Copy & Paste Functions",textMsg:"For the security reasons the right-click menu copy and paste functions are disabled. You can still do the same using your keyboard:",textToCopy:"to copy",textToPaste:"to paste"}),Ext.define("Common.view.AbstractSettingsPanel",{extend:"Ext.panel.Panel",alias:"widget.commonabstractsettingspanel",bodyPadding:"0 0 0 15px",preventHeader:!0,constructor:function(e){return this.controls=[],this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=this;this.initialHeight=this.height,e.callParent(arguments)},SuspendEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].suspendEvents(!1)},ResumeEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].resumeEvents()}}),Ext.define("Common.component.ThemeColorPalette",{extend:"Ext.ColorPalette",alias:"widget.cmpthemecolorpalette",allowReselect:!0,dyncolorscount:12,width:193,maxWidth:200,baseCls:"cmp-theme-colorpalette",requires:["Common.view.ExtendedColorDialog"],renderTpl:['<div style="padding: 12px;">','<tpl for="colors">','<tpl if="this.isBlankSeparator(values)"><div class="palette-color-spacer" style="width:100%;height:8px;float:left;"></div></tpl>','<tpl if="this.isSeparator(values)"></div><div class="palette-color-separator" style="width:100%;height:1px;float:left;border-bottom: 1px solid #E0E0E0"></div><div style="padding: 12px;"></tpl>','<tpl if="this.isColor(values)">','<a href="#" class="palette-color color-{.}" style="background:#{.} "hidefocus="on">','<em><span style="background:#{.}; border: 1px solid rgba(0, 0, 0, 0.2);" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isTransparent(values)">','<a href="#" class="color-{.}" hidefocus="on">','<em><span unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isCustom(values)">','<a href="#" id="{id}" class="palette-color-custom {cls}" hidefocus="on">','<em><span style="background:#FFFFFF;background-image:url({image});" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isEffect(values)">','<a href="#" effectid="{effectId}" effectvalue="{effectValue}" class="palette-color-effect color-{color}" style="background:#{color}" hidefocus="on">','<em><span style="background:#{color}; border: 1px solid rgba(0, 0, 0, 0.2);" unselectable="on">&#160;</span></em>',"</a>","</tpl>",'<tpl if="this.isCaption(values)"><div class="palette-color-caption" style="width:100%;float:left;font-size: 11px;">{.}</div></tpl>',"</tpl>","</div>",{isBlankSeparator:function(e){return typeof e=="string"&&e=="-"},isSeparator:function(e){return typeof e=="string"&&e=="--"},isColor:function(e){return typeof e=="string"&&/[0-9A-F]{6}/.test(e)},isTransparent:function(e){return typeof e=="string"&&e=="transparent"},isCaption:function(e){return typeof e=="string"&&e!="-"&&e!="--"&&!/[0-9A-F]{6}|transparent/.test(e)},isEffect:function(e){return typeof e=="object"&&e.effectId!==undefined},isCustom:function(e){return typeof e=="object"&&e.effectId===undefined}}],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.callParent(arguments)},onRender:function(e){this.callParent(arguments);if(this.dynamiccolors){var t=e.down(".x-color-picker");if(t){var n=-1,r='<div class="palette-color-spacer" style="width:100%;height:8px;float:left;"></div><div style="padding: 12px;">';while(++n<this.dyncolorscount)r+=Ext.String.format('<a href="#" class="color-dynamic-{0} dynamic-empty-color" style="background:#ffffff" color="" hidefocus="on"><em><span unselectable="on">&#160;</span></em></a>',n);r+="</div>",Ext.DomHelper.insertHtml("beforeEnd",t.dom,r)}}var i=this.el.up(".x-menu");i&&Ext.menu.Manager.menus[i.id].addListener("beforeshow",this.updateCustomColors,this),this.updateCustomColors()},afterRender:function(e){this.callParent(arguments),this.updateColorsArr&&this.updateColors(this.updateColorsArr[0],this.updateColorsArr[1]),this.lastvalue&&this.select(this.lastvalue,!0)},setCustomColor:function(e){e=/#?([a-fA-F0-9]{6})/.exec(e);if(e){var t=this.getEl();if(t){this._saveCustomColor(e[1]),$("#"+t.id+" a."+this.selectedCls).removeClass(this.selectedCls);var n=t.down(".dynamic-empty-color");n||(this.updateCustomColors(),n=t.down(".color-dynamic-"+(this.dyncolorscount-1))),n.removeCls("dynamic-empty-color").addCls(this.selectedCls).dom.setAttribute("color",e[1]),n.down("span").setStyle("background-color","#"+e[1]).setStyle("border","none")}}},select:function(e,t){if(!this.rendered){this.lastvalue=e;return}var n=this.getEl();n&&$("#"+n.id+" a."+this.selectedCls).removeClass(this.selectedCls);if(typeof e=="object"){var r;e.effectId!==undefined?(r=n.down('a[effectid="'+e.effectId+'"]'),r?(r.addCls(this.selectedCls),this.value=r.dom.className.match(this.colorRe)[1].toUpperCase()):this.value=!1):e.effectValue!==undefined&&(r=n.down('a[effectvalue="'+e.effectValue+'"].color-'+e.color.toUpperCase()),r?(r.addCls(this.selectedCls),this.value=r.dom.className.match(this.colorRe)[1].toUpperCase()):this.value=!1)}else{/#?[a-fA-F0-9]{6}/.test(e)&&(e=/#?([a-fA-F0-9]{6})/.exec(e)[1].toUpperCase(),this.value=e);if(/^[a-fA-F0-9]{6}|transparent$/.test(e)&&Ext.Array.contains(this.colors,e)){Ext.Array.contains(this.colors,this.value)||(this.value=!1);if(e!=this.value||this.allowReselect)this.value&&(this.value=="transparent"?n.down("a.color-transparent").removeCls(this.selectedCls):n.down("a.palette-color.color-"+this.value).removeCls(this.selectedCls)),e=="transparent"?n.down("a.color-transparent").addCls(this.selectedCls):n.down("a.palette-color.color-"+e).addCls(this.selectedCls),this.value=e,t!==!0&&this.fireEvent("select",this,e)}else if(n){var i=n.down("#"+e)||n.down('a[color="'+e+'"]');i?(i.addCls(this.selectedCls),this.value=e.toUpperCase()):n.down("a."+this.selectedCls)?this.value=!1:this.dynamiccolors}else this.lastvalue=e}},handleClick:function(e,t){var n=this,r,i;if(t.className.search("palette-color-custom")<0)if(t.className.search("color-transparent")<0)if(t.className.search("color-dynamic")<0){i=Ext.get(t.parentNode).down("a.palette-color-custom"),i&&i.removeCls(n.selectedCls);if(!/^[a-fA-F0-9]{6}$/.test(this.value)||!Ext.Array.contains(this.colors,this.value))this.value=!1;if(t.className.search("palette-color-effect")<0)this.callParent(arguments);else{r=t.className.match(n.colorRe)[1];var s=t.getAttribute("effectid");r&&(n.fireEvent("select",n,{color:r,effectId:s}),this.value=r.toUpperCase()),$("#"+this.getEl().id+" a."+n.selectedCls).removeClass(n.selectedCls),Ext.get(t).addCls(n.selectedCls)}}else/dynamic-empty-color/.test(t.className)?setTimeout(function(){n.addNewColor(),Ext.menu.Manager.hideAll()},10):(r=t.getAttribute("color"),r&&n.fireEvent("select",n,r),this.value=r.toUpperCase(),$("#"+this.getEl().id+" a."+n.selectedCls).removeClass(n.selectedCls),Ext.get(t).addCls(n.selectedCls));else{e.stopEvent(),i=Ext.get(t.parentNode).down("a."+n.selectedCls);if(!i||i.id!=t.id)i&&i.removeCls(n.selectedCls),Ext.get(t).addCls(n.selectedCls),n.value="transparent";n.fireEvent("select",n,"transparent")}else e.stopEvent(),i=Ext.get(t.parentNode).down("a."+n.selectedCls),!i||i.id!=t.id?(i&&i.removeCls(n.selectedCls),Ext.get(t.id).addCls(n.selectedCls),n.value=!1,n.fireEvent("select",n,t.id)):n.fireEvent("select",n,i.id)},addNewColor:function(){var e=this,t=Ext.create("Common.view.ExtendedColorDialog",{});t.addListener("onmodalresult",function(n){e._isdlgopen=!1,n==1&&(e.setCustomColor(t.getColor()),e.fireEvent("select",e,t.getColor()))},!1),e._isdlgopen=!0,t.setColor(e.value),t.show()},isDialogOpen:function(){return this._isdlgopen==1},updateColors:function(e,t){if(!this.rendered){this.updateColorsArr=[e,t.length==0&&this.updateColorsArr?this.updateColorsArr[1]:t];return}var n=this,r=this.getEl();n.aColorElements===undefined&&(n.aColorElements=r.query("a.palette-color")),n.aEffectElements===undefined&&(n.aEffectElements=r.query("a.palette-color-effect"));var i,s=0,o=0;for(var u=0;u<n.colors.length;u++)if(typeof n.colors[u]=="string"&&/[0-9A-F]{6}/.test(n.colors[u])){if(s>=t.length)continue;i=Ext.get(n.aColorElements[s]),i.removeCls("color-"+n.colors[u]),n.colors[u]=t[s].toUpperCase(),i.addCls("color-"+n.colors[u]),i.applyStyles({background:"#"+n.colors[u]}),i.down("span").applyStyles({background:"#"+n.colors[u]}),s++}else if(typeof n.colors[u]=="object"&&n.colors[u].effectId!==undefined){if(o>=e.length)continue;i=Ext.get(n.aEffectElements[o]),e[o].color=e[o].color.toUpperCase(),n.colors[u].color!==e[o].color&&(i.removeCls("color-"+n.colors[u].color),i.addCls("color-"+e[o].color),i.applyStyles({background:"#"+e[o].color}),i.down("span").applyStyles({background:"#"+e[o].color})),n.colors[u].effectId!==e[o].effectId&&i.set({effectid:e[o].effectId}),n.colors[u].effectValue!==e[o].effectValue&&i.set({effectvalue:e[o].effectValue}),n.colors[u]=e[o],o++}this.updateColorsArr=undefined},updateCustomColors:function(){var e=this.getEl();if(e){var t=localStorage["asc."+window.storagename+".colors.custom"];t=t?t.split(","):[];var n=-1,r,i=t.length<this.dyncolorscount?t.length:this.dyncolorscount;while(++n<i)r=e.down(".color-dynamic-"+n),r.removeCls("dynamic-empty-color").dom.setAttribute("color",t[n]),r.down("span").setStyle("background-color","#"+t[n]).setStyle("border","none")}},_saveCustomColor:function(e){var t=localStorage["asc."+window.storagename+".colors.custom"];t=t?t.split(","):[],t.push(e)>this.dyncolorscount&&t.shift(),localStorage["asc."+window.storagename+".colors.custom"]=t.join().toUpperCase()},_menuBeforeShow:function(){this.updateCustomColors()}}),Ext.define("Common.model.Group",{extend:"Ext.data.Model",fields:["group","groupname"],proxy:{type:"memory"},hasMany:{model:"Common.model.GroupItem",name:"getGroupItems"}}),Ext.define("Common.model.GroupItem",{extend:"Ext.data.Model",fields:["group","groupitem","iconcls"],proxy:{type:"memory"},belongsTo:{model:"Common.model.Group",name:"group"}}),Ext.define("Common.component.GroupedDataView",{extend:"Ext.DataView",alias:"widget.cmdgroupeddataview",requires:["Common.model.GroupItem","Common.model.Group","Ext.XTemplate"],selModel:{enableKeyNav:!1},tpl:new Ext.XTemplate('<tpl for=".">','<div class="asc-grouped-data">','<div class="group-description">','<span class="description-text">{[values[this.fieldGroupName]]}</span>',"</div>",'<div class="group-items-container">','<tpl for="getGroupItems">','<div class="group-item">','<span class="{iconcls}"></span>',"</div>","</tpl>","</div>","</div>",'<div class="asc-grouped-data-selector"></div>',"</tpl>",{compiled:!0,fieldGroupName:"groupname"}),itemSelector:"div.group-item",trackOver:!0,overItemCls:"group-item-over",cls:"grouped-data-view",listeners:{beforecontainerclick:function(e,t,n){return!1},viewready:function(){this.delayedSelection&&(this.getSelectionModel().doSingleSelect(this.delayedSelection),this.delayedSelection=undefined)}},constructor:function(e){return e.selModel&&(e.selModel.enableKeyNav=!1),this.initConfig(e),this.callParent(arguments),this},initComponent:function(){this.callParent(arguments)},updateIndexes:function(e,t){var n=this.all.elements,r=[],i;this.store.each(function(e,t,n){Ext.Array.insert(r,r.length,e.getGroupItems().getRange())}),e=e||0,t=t||(t===0?0:n.length-1);for(i=e;i<=t;i++)n[i].viewIndex=i,n[i].viewRecordId=r[i].internalId,n[i].boundView||(n[i].boundView=this.id)},getRecord:function(e){var t,n,r=-1,i=this.store.getCount();while(!t&&++r<i)n=this.store.getAt(r),n&&(t=n.getGroupItems().data.getByKey(Ext.getDom(e).viewRecordId));return t},onRender:function(e){this.callParent(arguments);var t=this;t.el.set({tabIndex:-1}),t.keyNav=Ext.create("Ext.util.KeyNav",t.el,{down:Ext.pass(t.onNavKey,[1,1],t),right:Ext.pass(t.onNavKey,[1,null],t),left:Ext.pass(t.onNavKey,[-1,null],t),up:Ext.pass(t.onNavKey,[-1,-1],t),scope:t})},onNavKey:function(e,t){e=e||1;var n=this.getSelectionModel().getSelection()[0],r=this.all.elements.length,i;if(n){if(t){var s=this.getIndexInStore(n);e=this.getShiftedStep(s,t)}i=this.indexOf(this.getNode(n))+e}else i=0;i<0?i=r-1:i>=r&&(i=0);var o=this.getRecord(this.all.elements[i]);this.getSelectionModel().doSingleSelect(o)},getIndexInStore:function(e){var t=[],n,r,i=-1,s=this.store.getCount();while(++i<s){n=this.store.getAt(i),r=n.getGroupItems().indexOf(e);if(!(r<0)){t=[i,r,n.getGroupItems().getCount()];break}}return t},getShiftedStep:function(e,t){var n=e[0]+t;n<0?n=this.store.getCount()-1:n<this.store.getCount()||(n=0);var r=this.store.getAt(n);if(t>0){var i=e[1]<r.getGroupItems().getCount()?e[1]:r.getGroupItems().getCount()-1;i+=e[2]-e[1]}else i=e[1]<r.getGroupItems().getCount()?e[1]-r.getGroupItems().getCount():-1,i-=e[1];return i},refresh:function(){this.callParent(arguments)},selectGroupItem:function(e,t){var n=this.store.findRecord("group",e);return n&&(n=n.getGroupItems().findRecord("groupitem",t),this.rendered?n&&this.getSelectionModel().doSingleSelect(n):this.delayedSelection=n),n},getSelected:function(){return this.delayedSelection||this.getSelectionModel().getSelection()[0]}}),Ext.define("PE.model.ShapeModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"data"}]}),Ext.define("PE.model.ShapeGroup",{extend:"Ext.data.Model",fields:[{name:"groupName"},{name:"groupId"},{name:"groupStore"}]}),Ext.define("PE.model.SlideLayout",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"title"},{name:"data"},{name:"uid"}]}),Ext.define("PE.store.ShapeGroups",{extend:"Ext.data.Store",model:"PE.model.ShapeGroup"}),Ext.define("PE.store.SlideLayouts",{extend:"Ext.data.Store",model:"PE.model.SlideLayout"}),Ext.define("PE.component.DimensionPicker",{extend:"Ext.Component",requires:"Ext.XTemplate",alias:"widget.pedimensionpicker",baseCls:"x-dimension-picker",itemSize:18,minRows:5,minColumns:5,maxRows:20,maxColumns:20,stalign:"bottom",padding:4,clickEvent:"click",value:null,renderTpl:['<div style="width: 100%; height: 100%;">','<div class="{baseCls}-observecontainer">','<div class="{baseCls}-mousecatcher"></div>','<div class="{baseCls}-unhighlighted"></div>','<div class="{baseCls}-highlighted"></div>',"</div>",'<div class="{baseCls}-status">0x0</div>',"</div>"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this,t=undefined,n=undefined,r=undefined,i=undefined,s=undefined,o=0,u=0,a=function(t,n,r){var i=[t.browserEvent.layerX||(Ext.isDefined(t.browserEvent.offsetX)?t.browserEvent.offsetX:0),t.browserEvent.layerY||(Ext.isDefined(t.browserEvent.offsetY)?t.browserEvent.offsetY:0)];e.setTableSize(Math.floor(i[0]/this.itemSize),Math.floor(i[1]/this.itemSize))},f=function(t,n,r){var i=[t.browserEvent.layerX||(Ext.isDefined(t.browserEvent.offsetX)?t.browserEvent.offsetX:0),t.browserEvent.layerY||(Ext.isDefined(t.browserEvent.offsetY)?t.browserEvent.offsetY:0)];e.setTableSize(Math.ceil(i[0]/this.itemSize),Math.ceil(i[1]/this.itemSize))},l=function(t,n,r){var i=[t.browserEvent.layerX||(Ext.isDefined(t.browserEvent.offsetX)?t.browserEvent.offsetX:0),t.browserEvent.layerY||(Ext.isDefined(t.browserEvent.offsetY)?t.browserEvent.offsetY:0)];e.setTableSize(Math.ceil(i[0]/this.itemSize),Math.ceil(i[1]/this.itemSize))},c=function(t){e.fireEvent("select",e,o,u)};this.setTableSize=function(n,a){n>this.maxColumns&&(n=this.maxColumns),a>this.maxRows&&(a=this.maxRows);if(o!=n||u!=a)o=n,u=a,i.setSize(o+"em",u+"em"),r.setSize((o<e.minColumns?e.minColumns:o+1>e.maxColumns?e.maxColumns:o+1)+"em",(u<e.minRows?e.minRows:u+1>e.maxRows?e.maxRows:u+1)+"em"),t.setWidth(r.getWidth()),s.update(Ext.String.format("{0} x {1}",o,u)),s.setWidth(r.getWidth()),e.fireEvent("change",e,o,u)};var h=function(h){t=e.getEl(),t&&(n=t.down("."+e.baseCls+"-mousecatcher"),r=t.down("."+e.baseCls+"-unhighlighted"),i=t.down("."+e.baseCls+"-highlighted"),s=t.down("."+e.baseCls+"-status"),t.setStyle({width:e.minColumns+"em"}),n.setSize(e.maxColumns+"em",e.maxRows+"em"),r.setSize(e.minColumns+"em",e.minRows+"em"),s.update(Ext.String.format("{0} x {1}",o,u)),s.setWidth(r.getWidth())),n.on("mousemove",a,e),i.on("mousemove",f,e),r.on("mousemove",l,e),i.on("click",c,e)};this.getColumnsCount=function(){return o},this.getRowsCount=function(){return u},e.on("afterrender",h,this),e.callParent(arguments),e.addEvents("change","select")}}),Ext.define("PE.component.MenuDimensionPicker",{extend:"Ext.menu.Menu",alias:"widget.pemenudimensionpicker",requires:["PE.component.DimensionPicker"],hideOnClick:!0,minWidth:10,minHeight:10,maxWidth:1e3,maxHeight:1e3,minRows:5,minColumns:5,maxRows:20,maxColumns:20,baseCls:"dimension-picker-menu",initComponent:function(){var e=this,t=Ext.apply({},e.initialConfig);delete t.listeners,Ext.apply(e,{plain:!0,showSeparator:!1,items:Ext.applyIf({xtype:"pedimensionpicker",minRows:this.minRows,minColumns:this.minColumns,maxRows:this.maxRows,maxColumns:this.maxColumns},t)}),e.callParent(arguments),e.picker=e.down("pedimensionpicker"),e.relayEvents(e.picker,["select"]),e.hideOnClick&&e.on("select",e.hidePickerOnSelect,e);var n=function(t,n,r){var i=n<e.picker.minColumns?e.picker.minColumns:n+1>e.picker.maxColumns?e.picker.maxColumns:n+1,s=r<e.picker.minRows?e.picker.minRows:r+1>e.picker.maxRows?e.picker.maxRows:r+1;i=i*e.picker.itemSize+2*e.picker.padding,s=s*e.picker.itemSize+2*e.picker.padding+e.picker.itemSize,e.setSize(i,s)};e.picker.addListener("change",n,this)},show:function(e,t,n){var r=this;r.callParent(arguments),r.picker.setTableSize(0,0),this.setSize(r.picker.minColumns*r.picker.itemSize+2*r.picker.padding,r.picker.minRows*r.picker.itemSize+2*r.picker.padding+r.picker.itemSize)},hidePickerOnSelect:function(e,t,n){Ext.menu.Manager.hideAll()}}),Ext.define("PE.view.InsertTableDialog",{extend:"Ext.window.Window",alias:"widget.peinserttabledialog",requires:["Ext.window.Window"],modal:!0,closable:!1,resizable:!1,preventHeader:!0,plain:!0,height:172,width:236,padding:"20px",layout:{type:"vbox",align:"stretch"},listeners:{show:function(){this.udColumns.focus(!1,500)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.items=[{xtype:"label",text:this.labelTitle||this.txtTitle,style:"margin: 0 0 15px 0; font-size: 15px;"},{xtype:"container",height:32,layout:{type:"hbox",align:"stretch"},items:[{xtype:"label",padding:"4px 0 0 0",width:130,text:this.txtColumns},this.udColumns=Ext.widget("numberfield",{minValue:1,maxValue:63,value:2,step:1,width:64,allowDecimals:!1,validateOnBlur:!1,msgTarget:"side",minText:this.txtMinText,maxText:this.txtMaxText,listeners:{specialkey:Ext.bind(function(e,t){t.getKey()==t.ENTER?this.btnOk.fireEvent("click"):t.getKey()==t.ESC&&this.btnCancel.fireEvent("click")},this)}})]},{xtype:"container",height:42,layout:{type:"hbox",align:"stretch"},items:[{xtype:"label",padding:"4px 0 0 0",width:130,text:this.txtRows},this.udRows=Ext.widget("numberfield",{minValue:1,maxValue:100,value:2,step:1,width:64,allowDecimals:!1,validateOnBlur:!1,msgTarget:"side",minText:this.txtMinText,maxText:this.txtMaxText,listeners:{specialkey:Ext.bind(function(e,t){t.getKey()==t.ENTER?this.btnOk.fireEvent("click"):t.getKey()==t.ESC&&this.btnCancel.fireEvent("click")},this)}})]},{xtype:"container",height:30,layout:{type:"vbox",align:"center"},items:[{xtype:"container",width:182,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){var t=this.udColumns.isValid(),n=this.udRows.isValid();if(!t||!n)return;this.fireEvent("onmodalresult",this,1,[this.udColumns.value,this.udRows.value]),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},txtTitle:"Table size",txtColumns:"Number of Columns",txtRows:"Number of Rows",textInvalidRowsCols:"You need to specify valid rows and columns count.",cancelButtonText:"Cancel",okButtonText:"Ok",txtMinText:"The minimum value for this field is {0}",txtMaxText:"The maximum value for this field is {0}"});var c_oHyperlinkType={InternalLink:0,WebLink:1};Ext.define("PE.view.HyperlinkSettings",{extend:"Ext.window.Window",alias:"widget.pehyperlinksettings",requires:["Ext.window.Window","Ext.form.field.ComboBox","Ext.form.field.Text","Ext.Array","Ext.form.field.Radio","Common.plugin.ComboBoxScrollPane"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:410,width:366,layout:{type:"vbox",align:"stretch"},listeners:{show:function(){this.contExtLink.isVisible()?this.txtLink.focus(!1,500):this.txtLinkText.focus(!1,500)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this.isTextChanged=!1,this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.cmbLinkType=Ext.widget("combo",{store:Ext.create("Ext.data.Store",{fields:["description","type"],data:[{type:c_oHyperlinkType.InternalLink,description:e.textInternalLink},{type:c_oHyperlinkType.WebLink,description:e.textExternalLink}]}),displayField:"description",valueField:"type",queryMode:"local",editable:!1,value:e.textExternalLink,listeners:{change:function(t,n,r){var i=n==c_oHyperlinkType.InternalLink;e.contIntLink.setVisible(i),e.contExtLink.setVisible(!i)}}}),this.cmbSlides=Ext.create("Ext.form.field.ComboBox",{store:this.slides,mode:"local",triggerAction:"all",editable:!1,width:50,listConfig:{maxHeight:200},listeners:{select:Ext.bind(function(t,n,r){this.slideNum=n[0].index+1,t.blur(),e.radioSlide.setValue(!0)},this)},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]}),this.txtLink=Ext.widget("textfield",{allowBlank:!1,blankText:e.txtEmpty,emptyText:e.textEmptyLink,validateOnChange:!1,msgTarget:"side",regex:/(([\-\wа-яё]+\.)+[\wа-яё]{2,3}(\/[%\-\wа-яё]+(\.[\wа-яё]{2,})?)*(([\wа-яё\-\.\?\\\/+@&#;`~=%!]*)(\.[\wа-яё]{2,})?)*\/?)/i,regexText:e.txtNotUrl,listeners:{specialkey:function(t,n){n.getKey()==n.ENTER?e.btnOk.fireEvent("click"):n.getKey()==n.ESC&&e.btnCancel.fireEvent("click")}}}),this.txtLinkText=Ext.widget("textfield",{allowBlank:!1,blankText:e.txtEmpty,msgTarget:"side",emptyText:e.textEmptyDesc,listeners:{specialkey:function(t,n){n.getKey()==n.ENTER?e.btnOk.fireEvent("click"):n.getKey()==n.ESC&&e.btnCancel.fireEvent("click")},change:function(t,n,r){e.isTextChanged=!0},scope:this}}),this.txtLinkTip=Ext.widget("textfield",{emptyText:e.textEmptyTooltip,listeners:{specialkey:function(t,n){n.getKey()==n.ENTER?e.btnOk.fireEvent("click"):n.getKey()==n.ESC&&e.btnCancel.fireEvent("click")}}}),this.label=Ext.widget("label",{width:"100%",margin:"0 0 2 0",style:"font-weight: bold;"}),this.contExtLink=Ext.widget("container",{height:44,layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.strLinkTo}),this.txtLink]}),this.contIntLink=Ext.widget("container",{height:120,hidden:!0,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[this.radioNext=Ext.create("Ext.form.field.Radio",{boxLabel:this.txtNext,name:"asc-radio-slide",checked:!0}),this.radioPrev=Ext.create("Ext.form.field.Radio",{boxLabel:this.txtPrev,name:"asc-radio-slide"}),this.radioFirst=Ext.create("Ext.form.field.Radio",{boxLabel:this.txtFirst,name:"asc-radio-slide"}),this.radioLast=Ext.create("Ext.form.field.Radio",{boxLabel:this.txtLast,name:"asc-radio-slide"}),{xtype:"container",flex:1,layout:{type:"hbox",align:"stretch"},items:[this.radioSlide=Ext.create("Ext.form.field.Radio",{boxLabel:this.txtSlide,name:"asc-radio-slide"}),{xtype:"tbspacer",width:10},this.cmbSlides]}]}]}),this.items=[{xtype:"container",height:316,padding:"18 25",layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.textLinkType}),this.cmbLinkType,{xtype:"tbspacer",height:10},this.contExtLink,this.contIntLink,{xtype:"tbspacer",height:10},this.labelDisplay=this.label.cloneConfig({text:e.strDisplay}),this.txtLinkText,{xtype:"tbspacer",height:10},this.label.cloneConfig({text:e.textTipText}),this.txtLinkTip]},this._spacer.cloneConfig(),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(t){if(e.cmbLinkType.getValue()==c_oHyperlinkType.WebLink&&!e.txtLink.isValid()){e.txtLink.focus(!0,500);return}if(!e.txtLinkText.isValid()){e.txtLinkText.focus(!0,500);return}this.fireEvent("onmodalresult",1),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",0),this.close()},scope:this}})]}]}],this.callParent(arguments),this.setTitle(this.textTitle)},afterRender:function(){this.callParent(arguments)},setSettings:function(e,t){if(e){var n=this.parseUrl(e.get_Value());this.cmbLinkType.setValue(n),e.get_Text()!==null?(this.txtLinkText.setValue(e.get_Text()),this.txtLinkText.setDisabled(!1)):(this.txtLinkText.setValue(this.textDefault),this.txtLinkText.setDisabled(!0)),this.isTextChanged=!1,this.txtLinkTip.setValue(e.get_ToolTip())}},getSettings:function(){var e=new CHyperlinkProperty;if(this.cmbLinkType.getValue()==c_oHyperlinkType.InternalLink){var t="ppaction://hlink",n="",r=this.txtLinkTip.getValue();this.radioSlide.getValue()?(t=t+"sldjumpslide"+(this.cmbSlides.getValue()-1),n=this.txtSlide+" "+this.cmbSlides.getValue()):this.radioFirst.getValue()?(t+="showjump?jump=firstslide",n=this.txtFirst):this.radioLast.getValue()?(t+="showjump?jump=lastslide",n=this.txtLast):this.radioNext.getValue()?(t+="showjump?jump=nextslide",n=this.txtNext):this.radioPrev.getValue()&&(t+="showjump?jump=previousslide",n=this.txtPrev),e.put_Value(t),e.put_ToolTip(r!==""?r:n)}else{var t=this.txtLink.getValue();/(((^https?)|(^ftp)):\/\/)/i.test(t)||(t="http://"+t),e.put_Value(t),e.put_ToolTip(this.txtLinkTip.getValue())}return!this.txtLinkText.isDisabled()&&this.isTextChanged?e.put_Text(this.txtLinkText.getValue()):e.put_Text(null),e},parseUrl:function(e){if(e===null||e===undefined||e=="")return c_oHyperlinkType.WebLink;var t=e.indexOf("ppaction://hlink");if(0==t){if(e=="ppaction://hlinkshowjump?jump=firstslide")this.radioFirst.setValue(!0);else if(e=="ppaction://hlinkshowjump?jump=lastslide")this.radioLast.setValue(!0);else if(e=="ppaction://hlinkshowjump?jump=nextslide")this.radioNext.setValue(!0);else if(e=="ppaction://hlinkshowjump?jump=previousslide")this.radioPrev.setValue(!0);else{this.radioSlide.setValue(!0);var n="ppaction://hlinksldjumpslide",r=e.indexOf(n);if(0==r){var i=parseInt(e.substring(n.length));i>=0&&i<this.slides.length&&this.cmbSlides.setValue(i+1)}}return c_oHyperlinkType.InternalLink}return this.txtLink.setValue(e?e:""),c_oHyperlinkType.WebLink},textTitle:"Hyperlink Settings",textInternalLink:"Place In This Document",textExternalLink:"File or Web Page",textEmptyLink:"Enter link here",textEmptyDesc:"Enter caption here",textEmptyTooltip:"Enter tooltip here",txtSlide:"Slide",textLinkType:"Link Type",strDisplay:"Display",textTipText:"Screen Tip Text",strLinkTo:"Link To",txtEmpty:"This field is required",textInvalidRange:"ERROR! Invalid cells range",txtNotUrl:'This field should be a URL in the format "http://www.example.com"',strPlaceInDocument:"Select a Place in This Document",cancelButtonText:"Cancel",okButtonText:"Ok",txtNext:"Next Slide",txtPrev:"Previous Slide",txtFirst:"First Slide",txtLast:"Last Slide"}),Ext.define("PE.view.ImageSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.peimagesettingsadvanced",requires:["Common.component.MetricSpinner","Ext.window.Window","Ext.util.Cookies"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:253,width:516,layout:{type:"vbox",align:"stretch"},_defaults:{sizeOriginal:{width:0,height:0},sizeMax:{width:55.88,height:55.88},properties:null},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this._nRatio=1,this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"image-advanced-spin-width",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:80,listeners:{change:Ext.bind(function(e,t,n,r){if(this._btnRatio.pressed){var i=e.getNumberValue(),s=i/this._nRatio;s>this._defaults.sizeMax.height&&(s=this._defaults.sizeMax.height,i=s*this._nRatio,this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(i),this._spnWidth.resumeEvents()),this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(s),this._spnHeight.resumeEvents()}},this)}}),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"image-advanced-span-height",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:80,listeners:{change:Ext.bind(function(e,t,n,r){var i=e.getNumberValue(),s=null;this._btnRatio.pressed&&(s=i*this._nRatio,s>this._defaults.sizeMax.width&&(s=this._defaults.sizeMax.width,i=s/this._nRatio,this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(i),this._spnHeight.resumeEvents()),this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(s),this._spnWidth.resumeEvents())},this)}}),this._btnOriginalSize=Ext.create("Ext.Button",{id:"image-advanced-button-original-size",text:this.textOriginalSize,width:100,height:22,style:"margin: 0 0 0 7px",listeners:{click:function(e,t){this._spnWidth.suspendEvents(!1),this._spnHeight.suspendEvents(!1),this._spnWidth.setValue(this._defaults.sizeOriginal.width),this._spnHeight.setValue(this._defaults.sizeOriginal.height),this._spnWidth.resumeEvents(),this._spnHeight.resumeEvents(),this._nRatio=this._defaults.sizeOriginal.width/this._defaults.sizeOriginal.height},scope:this}}),this._btnRatio=Ext.create("Ext.Button",{id:"image-advanced-button-ratio",iconCls:"advanced-btn-ratio",enableToggle:!0,width:22,height:22,style:"margin: 0 0 0 6px;",tooltip:this.textKeepRatio,toggleHandler:Ext.bind(function(e){e.pressed&&this._spnHeight.getNumberValue()>0&&(this._nRatio=this._spnWidth.getNumberValue()/this._spnHeight.getNumberValue())},this)}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this._spnX=Ext.create("Common.component.MetricSpinner",{id:"image-span-x",readOnly:!1,maxValue:55.87,minValue:-55.87,step:.1,defaultUnit:"cm",value:"0 cm",width:85}),this._spnY=Ext.create("Common.component.MetricSpinner",{id:"image-span-y",readOnly:!1,maxValue:55.87,minValue:-55.87,step:.1,defaultUnit:"cm",value:"0 cm",width:85}),this._contPosition=Ext.create("Ext.Container",{cls:"image-advanced-container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{width:113,items:[{xtype:"label",text:"X",width:85},{xtype:"tbspacer",height:3},this._spnX]},{items:[{xtype:"label",text:"Y",width:85},{xtype:"tbspacer",height:3},this._spnY]}]}),this.items=[{xtype:"container",height:157,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"18 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",padding:"0 10 0 0",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:54,items:[{xtype:"label",text:this.textSize,style:"font-weight: bold;"}]},{height:80,cls:"image-advanced-container",items:[{xtype:"label",text:this.textPosition,style:"font-weight: bold;"}]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},{xtype:"container",padding:"18 0 0 10",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:43,style:"float:left;"},items:[{width:108,items:[{xtype:"label",text:this.textWidth,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:108,layout:{type:"hbox"},items:[this._spnWidth,this._btnRatio]}]},{width:195,margin:"0 0 0 7",items:[{xtype:"label",text:this.textHeight,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:195,layout:{type:"hbox"},items:[this._spnHeight,this._btnOriginalSize]}]}]},this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),this._contPosition]}]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._defaults.properties),this.setTitle(this.textTitle)},setSizeOriginal:function(e){this._defaults.sizeOriginal.width=Common.MetricSettings.fnRecalcFromMM(e.width),this._defaults.sizeOriginal.height=Common.MetricSettings.fnRecalcFromMM(e.height)},setSizeMax:function(e){this._defaults.sizeMax.width=Common.MetricSettings.fnRecalcFromMM(e.width),this._defaults.sizeMax.height=Common.MetricSettings.fnRecalcFromMM(e.height)},setSettings:function(e){this._defaults.properties=e},_setDefaults:function(e){if(e){this._spnWidth.suspendEvents(!1),this._spnHeight.suspendEvents(!1),this._spnWidth.setMaxValue(this._defaults.sizeMax.width),this._spnHeight.setMaxValue(this._defaults.sizeMax.height),this._spnWidth.setValue(e.get_Width()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Width()).toFixed(2):""),this._spnHeight.setValue(e.get_Height()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Height()).toFixed(2):""),this._spnWidth.resumeEvents(),this._spnHeight.resumeEvents();if(e.get_Position()){var t={X:e.get_Position().get_X(),Y:e.get_Position().get_Y()};t.X!==null&&t.X!==undefined&&this._spnX.setValue(Common.MetricSettings.fnRecalcFromMM(t.X)),t.Y!==null&&t.Y!==undefined&&this._spnY.setValue(Common.MetricSettings.fnRecalcFromMM(t.Y))}else this._spnX.setValue(""),this._spnY.setValue("");e.get_Height()>0&&(this._nRatio=e.get_Width()/e.get_Height());var n=window.localStorage.getItem("pe-settings-imageratio");(n===null||parseInt(n)==1)&&this._btnRatio.toggle(!0),this._btnOriginalSize.setDisabled(e.get_ImageUrl()===null||e.get_ImageUrl()===undefined)}},getSettings:function(){window.localStorage.setItem("pe-settings-imageratio",this._btnRatio.pressed?1:0);var e=new CImgProperty;this._spnWidth.getValue()!==""&&e.put_Width(Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue())),this._spnHeight.getValue()!==""&&e.put_Height(Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue()));var t=new CPosition;return this._spnX.getValue()!==""&&t.put_X(Common.MetricSettings.fnRecalcToMM(this._spnX.getNumberValue())),this._spnY.getValue()!==""&&t.put_Y(Common.MetricSettings.fnRecalcToMM(this._spnY.getNumberValue())),e.put_Position(t),e},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}this._defaults.sizeMax.width=Common.MetricSettings.fnRecalcFromMM(this._defaults.sizeMax.width*10),this._defaults.sizeMax.height=Common.MetricSettings.fnRecalcFromMM(this._defaults.sizeMax.height*10)},textOriginalSize:"Default Size",textPosition:"Position",textSize:"Size",textWidth:"Width",textHeight:"Height",textTitle:"Image - Advanced Settings",textKeepRatio:"Constant Proportions",cancelButtonText:"Cancel",okButtonText:"Ok"}),Ext.define("PE.view.ShapeSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.peshapesettingsadvanced",requires:["Ext.form.field.ComboBox","Ext.window.Window","Ext.data.Model","Ext.data.Store","Ext.Array","Ext.button.Button"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:340,width:516,layout:{type:"vbox",align:"stretch"},initComponent:function(){function h(e){e.pressed&&g.getLayout().setActiveItem(e.card)}var e=this;this.addEvents("onmodalresult"),this._originalProps=null,this._changedProps=null,this._beginSizeIdx=0,this._endSizeIdx=0,this._nRatio=1,this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-spin-width",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){if(this._btnRatio.pressed){var i=e.getNumberValue(),s=i/this._nRatio;s>this._spnHeight.maxValue&&(s=this._spnHeight.maxValue,i=s*this._nRatio,this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(i),this._spnWidth.resumeEvents()),this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(s),this._spnHeight.resumeEvents()}this._changedProps&&(this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._changedProps.put_Height(Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue())))},this)}}),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-span-height",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"3 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){var i=e.getNumberValue(),s=null;this._btnRatio.pressed&&(s=i*this._nRatio,s>this._spnWidth.maxValue&&(s=this._spnWidth.maxValue,i=s/this._nRatio,this._spnHeight.suspendEvents(!1),this._spnHeight.setValue(i),this._spnHeight.resumeEvents()),this._spnWidth.suspendEvents(!1),this._spnWidth.setValue(s),this._spnWidth.resumeEvents()),this._changedProps&&(this._changedProps.put_Height(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this._changedProps.put_Width(Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue())))},this)}}),this._btnRatio=Ext.create("Ext.Button",{id:"shape-advanced-button-ratio",iconCls:"advanced-btn-ratio",enableToggle:!0,width:22,height:22,style:"margin: 0 0 0 6px;",tooltip:this.textKeepRatio,toggleHandler:Ext.bind(function(e){e.pressed&&this._spnHeight.getNumberValue()>0&&(this._nRatio=this._spnWidth.getNumberValue()/this._spnHeight.getNumberValue())},this)}),this._arrCapType=[[c_oAscLineCapType.Flat,this.textFlat],[c_oAscLineCapType.Round,this.textRound],[c_oAscLineCapType.Square,this.textSquare]],this.cmbCapType=Ext.create("Ext.form.field.ComboBox",{id:"shape-advanced-cap-type",width:100,editable:!1,store:this._arrCapType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(t,n,r){this._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linecap(e._arrCapType[n[0].index][0]))},this)}}),this.cmbCapType.setValue(this._arrCapType[0][1]),this._arrJoinType=[[c_oAscLineJoinType.Round,this.textRound],[c_oAscLineJoinType.Bevel,this.textBevel],[c_oAscLineJoinType.Miter,this.textMiter]],this.cmbJoinType=Ext.create("Ext.form.field.ComboBox",{id:"shape-advanced-join-type",width:100,editable:!1,store:this._arrJoinType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(t,n,r){this._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linejoin(e._arrJoinType[n[0].index][0]))},this)}}),this.cmbJoinType.setValue(this._arrJoinType[0][1]),this.styleURL="resources/img/right-panels/Begin-EndStyle.png",this.styleURL2x="resources/img/right-panels/Begin-EndStyle@2x.png";var t=[],n=[],r=[c_oAscLineBeginType.None,c_oAscLineBeginType.Triangle,c_oAscLineBeginType.Arrow,c_oAscLineBeginType.Stealth,c_oAscLineBeginType.Diamond,c_oAscLineBeginType.Oval],i=[c_oAscLineBeginSize.small_small,c_oAscLineBeginSize.small_mid,c_oAscLineBeginSize.small_large,c_oAscLineBeginSize.mid_small,c_oAscLineBeginSize.mid_mid,c_oAscLineBeginSize.mid_large,c_oAscLineBeginSize.large_small,c_oAscLineBeginSize.large_mid,c_oAscLineBeginSize.large_large];for(var s=0;s<6;s++){var o={value:s,imagewidth:44,imageheight:20,offsetx:80*s+10,offsety:0};o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-o.offsety,this.styleURL2x),t.push(o)}t[0].type=c_oAscLineBeginType.None,t[1].type=c_oAscLineBeginType.Triangle,t[2].type=c_oAscLineBeginType.Arrow,t[3].type=c_oAscLineBeginType.Stealth,t[4].type=c_oAscLineBeginType.Diamond,t[5].type=c_oAscLineBeginType.Oval;for(s=0;s<9;s++){var o={value:s,imagewidth:44,imageheight:20,offsetx:90,offsety:20*(s+1)};o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-o.offsety,this.styleURL2x),n.push(o)}n[0].type=c_oAscLineBeginSize.small_small,n[1].type=c_oAscLineBeginSize.small_mid,n[2].type=c_oAscLineBeginSize.small_large,n[3].type=c_oAscLineBeginSize.mid_small,n[4].type=c_oAscLineBeginSize.mid_mid,n[5].type=c_oAscLineBeginSize.mid_large,n[6].type=c_oAscLineBeginSize.large_small,n[7].type=c_oAscLineBeginSize.large_mid,n[8].type=c_oAscLineBeginSize.large_large;var u=Ext.create("Ext.data.Store",{model:"PE.model.ModelBorders",data:t}),a=Ext.create("Ext.data.Store",{model:"PE.model.ModelBorders",data:n});for(s=0;s<t.length;s++){var o=t[s];o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-(o.offsety+200),this.styleURL2x)}for(s=0;s<n.length;s++){var o=n[s];o.borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",this.styleURL,o.imagewidth,o.imageheight,-o.offsetx,-(o.offsety+200),this.styleURL2x)}var f=Ext.create("Ext.data.Store",{model:"PE.model.ModelBorders",data:t}),l=Ext.create("Ext.data.Store",{model:"PE.model.ModelBorders",data:n});this._updateSizeArr=function(t,r,i,s){var o=Ext.String.format("background:url({0}) repeat scroll 0 -1px","resources/img/controls/text-bg.gif");if(r.data.value>0){for(var u=0;u<n.length;u++)n[u].offsetx=r.data.value*80+10,n[u].borderstyle=Ext.String.format("background:url({0}) {3}px {4}px; width:{1}px; height:{2}px; background-image: -webkit-image-set(url({0}) 1x, url({5}) 2x);",e.styleURL,n[u].imagewidth,n[u].imageheight,-n[u].offsetx,-(n[u].offsety+200*i),this.styleURL2x);t.menu.picker.store.loadData(n),t.setDisabled(!1),s!==null?(t.menu.picker.selectByIndex(s,!0),e._selectStyleItem(t,t.menu.picker.store.getAt(s),i)):Ext.DomHelper.applyStyles(t.btnEl,o)}else Ext.DomHelper.applyStyles(t.btnEl,o),t.setDisabled(!0)},this._selectStyleItem=function(t,n,r){var i;t.btnEl&&(i=Ext.String.format("background:url({0}) repeat scroll {1}px {2}px, url({3}) repeat scroll 0 -1px;",e.styleURL,-(n.data.offsetx-20),-(n.data.offsety+200*r),"resources/img/controls/text-bg.gif"),i+=Ext.String.format("background-image: -webkit-image-set(url({0}) 1x, url({1}) 2x), -webkit-image-set(url({2}) 1x, url({3}) 2x);",e.styleURL,e.styleURL2x,"resources/img/controls/text-bg.gif","resources/img/controls/text-bg@2x.gif"),Ext.DomHelper.applyStyles(t.btnEl,i))};var c=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="left" style="{borderstyle}"" />',"</div>","</tpl>");this._btnBeginStyle=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginStyleMenu=Ext.create("Common.component.MenuDataViewPicker",{width:115,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:u,contentWidth:95,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linebeginstyle(n.data.type));if(this._beginSizeIdx===null||this._beginSizeIdx===undefined)this._beginSizeIdx=4;e._updateSizeArr(e._btnBeginSize,n,0,this._beginSizeIdx),e._selectStyleItem(e._btnBeginStyle,n,0)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),0)}}}),this._btnEndStyle=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.EndStyleMenu=Ext.create("Common.component.MenuDataViewPicker",{width:115,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:f,contentWidth:95,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_lineendstyle(n.data.type));if(this._endSizeIdx===null||this._endSizeIdx===undefined)this._endSizeIdx=4;e._updateSizeArr(e._btnEndSize,n,1,this._endSizeIdx),e._selectStyleItem(e._btnEndStyle,n,1)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),1)}}}),this._btnBeginSize=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginSizeMenu=Ext.create("Common.component.MenuDataViewPicker",{width:167,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:a,contentWidth:147,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_linebeginsize(n.data.type)),this._beginSizeIdx=n.data.value,e._selectStyleItem(e._btnBeginSize,n,0)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),0)}}}),this._btnEndSize=Ext.create("Ext.button.Button",{width:100,cls:"btn-combo-style",pressedCls:"",menu:this.BeginSizeMenu=Ext.create("Common.component.MenuDataViewPicker",{width:167,height:92,cls:"arrow-view",dataTpl:c,viewData:[],store:l,contentWidth:147,listeners:{select:Ext.bind(function(t,n){e._changedProps&&(this._changedProps.get_stroke()===null&&this._changedProps.put_stroke(new CAscStroke),this._changedProps.get_stroke().put_lineendsize(n.data.type)),this._endSizeIdx=n.data.value,e._selectStyleItem(e._btnEndSize,n,1)},e),hide:function(){e.fireEvent("editcomplete",e)}}}),listeners:{afterRender:function(){e._selectStyleItem(this,this.menu.picker.store.getAt(1),1)}}}),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_paddings()===null||this._changedProps.get_paddings()===undefined)&&this._changedProps.put_paddings(new CPaddings),this._changedProps.get_paddings().put_Top(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_paddings()===null||this._changedProps.get_paddings()===undefined)&&this._changedProps.put_paddings(new CPaddings),this._changedProps.get_paddings().put_Bottom(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_paddings()===null||this._changedProps.get_paddings()===undefined)&&this._changedProps.put_paddings(new CPaddings),this._changedProps.get_paddings().put_Left(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"shape-advanced-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:100,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_paddings()===null||this._changedProps.get_paddings()===undefined)&&this._changedProps.put_paddings(new CPaddings),this._changedProps.get_paddings().put_Right(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'});var p=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textSize,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"shapeadvanced",pressed:!0,card:"card-size",listeners:{click:h}});this.btnShape=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.textWeightArrows,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"shapeadvanced",card:"card-shape",listeners:{click:h}}),this.btnMargins=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strMargins,enableToggle:!0,allowDepress:!1,toggleGroup:"shapeadvanced",card:"card-margins",listeners:{click:h}});var d={xtype:"container",itemId:"card-size",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:43,style:"float:left;"},items:[{width:128,items:[{xtype:"label",text:this.textWidth,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:128,layout:{type:"hbox"},items:[this._spnWidth,this._btnRatio]}]},{width:175,margin:"0 0 0 7",items:[{xtype:"label",text:this.textHeight,width:80},{xtype:"tbspacer",height:3},{xtype:"container",width:175,layout:{type:"hbox"},items:[this._spnHeight]}]}]}]},v={xtype:"container",itemId:"card-shape",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textLineStyle},{xtype:"tbspacer",height:8},{xtype:"container",height:40,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textCapType,width:85},{xtype:"label",text:this.textJoinType,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbCapType,this.cmbJoinType]},this._spacer.cloneConfig({style:"margin: 16px 0 11px 0;",height:6}),{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textArrows},{xtype:"tbspacer",height:8},{xtype:"container",height:86,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textBeginStyle,width:85},{xtype:"label",text:this.textEndStyle,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._btnBeginStyle,this._btnEndStyle,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBeginSize,width:85},{xtype:"label",text:this.textEndSize,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._btnBeginSize,this._btnEndSize]}]},m={xtype:"container",itemId:"card-margins",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]}]},g=Ext.create("Ext.container.Container",{height:330,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[d,v,m]});this.items=[{xtype:"container",height:244,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:p},{height:30,items:this.btnShape},{height:30,items:this.btnMargins}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},g]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps),this.setTitle(this.textTitle)},setSettings:function(e){this._originalProps=e,this._changedProps=null},_setDefaults:function(e){if(e){var t=e.get_stroke();if(t){var n=t.get_linejoin();for(var r=0;r<this._arrJoinType.length;r++)if(n==this._arrJoinType[r][0]){this.cmbJoinType.setValue(this._arrJoinType[r][1]);break}n=t.get_linecap();for(r=0;r<this._arrCapType.length;r++)if(n==this._arrCapType[r][0]){this.cmbCapType.setValue(this._arrCapType[r][1]);break}var i=t.get_canChangeArrows();this._btnBeginStyle.setDisabled(!i),this._btnEndStyle.setDisabled(!i),this._btnBeginSize.setDisabled(!i),this._btnEndSize.setDisabled(!i);var s=Ext.String.format("background:url({0}) repeat scroll 0 -1px","resources/img/controls/text-bg.gif");if(i){n=t.get_linebeginsize();var o=this._btnBeginSize.menu.picker.store.findRecord("type",n);o!==null?this._beginSizeIdx=o.data.value:(this._beginSizeIdx=null,Ext.DomHelper.applyStyles(this._btnBeginSize.btnEl,s)),n=t.get_linebeginstyle(),o=this._btnBeginStyle.menu.picker.store.findRecord("type",n),o!==null?(this._btnBeginStyle.menu.picker.selectByIndex(o.data.value,!1),this._updateSizeArr(this._btnBeginSize,o,0,this._beginSizeIdx),this._selectStyleItem(this._btnBeginStyle,o,0)):Ext.DomHelper.applyStyles(this._btnBeginStyle.btnEl,s),n=t.get_lineendsize(),o=this._btnEndSize.menu.picker.store.findRecord("type",n),o!==null?this._endSizeIdx=o.data.value:(this._endSizeIdx=null,Ext.DomHelper.applyStyles(this._btnEndSize.btnEl,s)),n=t.get_lineendstyle(),o=this._btnEndStyle.menu.picker.store.findRecord("type",n),o!==null?(this._btnEndStyle.menu.picker.selectByIndex(o.data.value,!1),this._updateSizeArr(this._btnEndSize,o,1,this._endSizeIdx),this._selectStyleItem(this._btnEndStyle,o,1)):Ext.DomHelper.applyStyles(this._btnEndStyle.btnEl,s)}else Ext.DomHelper.applyStyles(this._btnBeginStyle.btnEl,s),Ext.DomHelper.applyStyles(this._btnEndStyle.btnEl,s),Ext.DomHelper.applyStyles(this._btnBeginSize.btnEl,s),Ext.DomHelper.applyStyles(this._btnEndSize.btnEl,s)}this._spnWidth.suspendEvents(!1),this._spnHeight.suspendEvents(!1),this._spnWidth.setValue(Common.MetricSettings.fnRecalcFromMM(e.get_Width()).toFixed(2)),this._spnHeight.setValue(Common.MetricSettings.fnRecalcFromMM(e.get_Height()).toFixed(2)),this._spnWidth.resumeEvents(),this._spnHeight.resumeEvents(),e.get_Height()>0&&(this._nRatio=e.get_Width()/e.get_Height()),n=window.localStorage.getItem("pe-settings-shaperatio"),n!==null&&parseInt(n)==1&&this._btnRatio.toggle(!0);var u=e.get_paddings();if(u){var a=u.get_Left();this._spnMarginLeft.setValue(null!==a&&undefined!==a?Common.MetricSettings.fnRecalcFromMM(a):""),a=u.get_Top(),this._spnMarginTop.setValue(null!==a&&undefined!==a?Common.MetricSettings.fnRecalcFromMM(a):""),a=u.get_Right(),this._spnMarginRight.setValue(null!==a&&undefined!==a?Common.MetricSettings.fnRecalcFromMM(a):""),a=u.get_Bottom(),this._spnMarginBottom.setValue(null!==a&&undefined!==a?Common.MetricSettings.fnRecalcFromMM(a):"")}}this._changedProps=new CAscShapeProp},getSettings:function(){return window.localStorage.setItem("pe-settings-shaperatio",this._btnRatio.pressed?1:0),this._changedProps},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}},textRound:"Round",textMiter:"Miter",textSquare:"Square",textFlat:"Flat",textBevel:"Bevel",textTitle:"Shape - Advanced Settings",cancelButtonText:"Cancel",okButtonText:"Ok",txtNone:"None",textWeightArrows:"Weights & Arrows",textArrows:"Arrows",textLineStyle:"Line Style",textCapType:"Cap Type",textJoinType:"Join Type",textBeginStyle:"Begin Style",textBeginSize:"Begin Size",textEndStyle:"End Style",textEndSize:"End Size",textSize:"Size",textWidth:"Width",textHeight:"Height",textKeepRatio:"Constant Proportions",textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",strMargins:"Margins"}),Ext.define("PE.view.TableSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.petablesettingsadvanced",requires:["Common.component.MetricSpinner","Ext.window.Window","Ext.form.field.Checkbox","Ext.Button","Ext.container.Container","Common.component.IndeterminateCheckBox","Ext.Array"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:396,width:516,layout:{type:"vbox",align:"stretch"},listeners:{},initComponent:function(){this.addEvents("onmodalresult"),this.controls=[],this._originalProps=null,this._changedProps=null,this._allTable=!1,this.TableMargins={Left:.19,Right:.19,Top:0,Bottom:0},this.CellMargins={Left:.19,Right:.19,Top:null,Bottom:null,Flag:0},this._initialMarginsDefault=!1,this._marginsChange=function(e,t,n,r,i,s){i=="table"?this.TableMargins[s]=e.getNumberValue():this.CellMargins[s]=e.getNumberValue()},this._chCellMargins=Ext.create("Common.component.IndeterminateCheckBox",{id:"tableadv-checkbox-margins",boxLabel:this.textCheckMargins,checked:!0,style:"margin-left:10px;",listeners:{change:Ext.bind(function(e,t,n,r){n=="checked"&&this._originalProps&&this._originalProps.get_CellMargins().get_Flag()==1&&(e.suspendEvents(!1),e.setValue("indeterminate"),e.resumeEvents()),this.fillMargins.call(this,e.getValue()),this.CellMargins.Flag=e.getValue(),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Left(this.CellMargins.Left!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Left):null),this._changedProps.get_CellMargins().put_Top(this.CellMargins.Top!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Top):null),this._changedProps.get_CellMargins().put_Bottom(this.CellMargins.Bottom!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Bottom):null),this._changedProps.get_CellMargins().put_Right(this.CellMargins.Right!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Right):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._chCellMargins),this._spnMarginTop=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Top"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Top(this.CellMargins.Top!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Top):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginTop),this._spnMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Bottom"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Bottom(this.CellMargins.Bottom!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Bottom):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginBottom),this._spnMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Left"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Left(this.CellMargins.Left!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Left):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginLeft),this._spnMarginRight=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"cell","Right"),this._changedProps&&(this._changedProps.get_CellMargins()===undefined&&this._changedProps.put_CellMargins(new CMargins),this._changedProps.get_CellMargins().put_Right(this.CellMargins.Right!==null?Common.MetricSettings.fnRecalcToMM(this.CellMargins.Right):null),this.CellMargins.Flag=="indeterminate"?this._changedProps.get_CellMargins().put_Flag(1):this.CellMargins.Flag=="checked"?this._changedProps.get_CellMargins().put_Flag(0):this._changedProps.get_CellMargins().put_Flag(2))},this)}}),this.controls.push(this._spnMarginRight),this._spnTableMarginTop=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-top",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Top"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Top(this.TableMargins.Top!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Top):null))},this)}}),this.controls.push(this._spnTableMarginTop),this._spnTableMarginBottom=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-bottom",readOnly:!1,maxValue:55.87,minValue:0,step:.1,defaultUnit:"cm",value:"0 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Bottom"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Bottom(this.TableMargins.Bottom!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Bottom):null))},this)}}),this.controls.push(this._spnTableMarginBottom),this._spnTableMarginLeft=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-left",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Left"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Left(this.TableMargins.Left!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Left):null))},this)}}),this.controls.push(this._spnTableMarginLeft),this._spnTableMarginRight=Ext.create("Common.component.MetricSpinner",{id:"tableadv-number-margin-table-right",readOnly:!1,maxValue:9.34,minValue:0,step:.1,defaultUnit:"cm",value:"0.19 cm",width:85,listeners:{change:Ext.bind(function(e,t,n,r){this._marginsChange(e,t,n,r,"table","Right"),this._changedProps&&(this._changedProps.get_DefaultMargins()===undefined&&this._changedProps.put_DefaultMargins(new CPaddings),this._changedProps.get_DefaultMargins().put_Right(this.TableMargins.Right!==null?Common.MetricSettings.fnRecalcToMM(this.TableMargins.Right):null))},this)}}),this.controls.push(this._spnTableMarginRight),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.items=[{xtype:"container",height:300,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10 0 0",layout:{type:"hbox",align:"middle",pack:"end"},height:300,items:[{xtype:"label",text:this.textWidthSpaces,style:"font-weight: bold;"}]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},{xtype:"container",padding:"18 0 0 10",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textMargins},{xtype:"tbspacer",height:8},this._chCellMargins,{xtype:"tbspacer",height:5},{xtype:"container",height:86,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginTop,this._spnMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnMarginBottom,this._spnMarginRight]},{xtype:"tbspacer",height:12},{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textDefaultMargins},{xtype:"tbspacer",height:8},{xtype:"container",height:84,padding:"0 10",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 40px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textTop,width:85},{xtype:"label",text:this.textLeft,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnTableMarginTop,this._spnTableMarginLeft,{xtype:"tbspacer",height:5},{xtype:"tbspacer",height:5},{xtype:"label",text:this.textBottom,width:85},{xtype:"label",text:this.textRight,width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this._spnTableMarginBottom,this._spnTableMarginRight]}]}]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps),this.setTitle(this.textTitle)},setSettings:function(e){this._originalProps=new CTableProp(e.tableProps),this._changedProps=null},_setDefaults:function(e){if(e){this._allTable=!e.get_CellSelect();var t=e.get_DefaultMargins();t&&(this.TableMargins={Left:t.get_Left()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Left()):null,Right:t.get_Right()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Right()):null,Top:t.get_Top()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Top()):null,Bottom:t.get_Bottom()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Bottom()):null}),t=e.get_CellMargins();if(t){this.CellMargins={Left:t.get_Left()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Left()):null,Right:t.get_Right()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Right()):null,Top:t.get_Top()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Top()):null,Bottom:t.get_Bottom()!==null?Common.MetricSettings.fnRecalcFromMM(t.get_Bottom()):null};var n=t.get_Flag();n==1?(this.CellMargins.Flag="indeterminate",this._chCellMargins.setValue(this.CellMargins.Flag)):n==0?(this.CellMargins.Flag="checked",this._chCellMargins.setValue(1)):(this.CellMargins.Flag="unchecked",this._chCellMargins.setValue(0)),this._initialMarginsDefault=n==0}this.fillMargins(this.CellMargins.Flag)}this._changedProps=new CTableProp},getSettings:function(){return{tableProps:this._changedProps}},SuspendEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].suspendEvents(!1)},ResumeEvents:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].resumeEvents()},fillMargins:function(e){this.SuspendEvents(),this._initialMarginsDefault&&e=="unchecked"&&(this.CellMargins.Left===null&&(this.CellMargins.Left=0),this.CellMargins.Top===null&&(this.CellMargins.Top=0),this.CellMargins.Right===null&&(this.CellMargins.Right=0),this.CellMargins.Bottom===null&&(this.CellMargins.Bottom=0)),this._spnMarginLeft.setValue(this.CellMargins.Left!==null?this.CellMargins.Left:""),this._spnMarginTop.setValue(this.CellMargins.Top!==null?this.CellMargins.Top:""),this._spnMarginRight.setValue(this.CellMargins.Right!==null?this.CellMargins.Right:""),this._spnMarginBottom.setValue(this.CellMargins.Bottom!==null?this.CellMargins.Bottom:"");var t=e=="checked";this._spnMarginTop.setDisabled(t),this._spnMarginBottom.setDisabled(t),this._spnMarginLeft.setDisabled(t),this._spnMarginRight.setDisabled(t),this._spnTableMarginLeft.setValue(this.TableMargins.Left!==null?this.TableMargins.Left:""),this._spnTableMarginTop.setValue(this.TableMargins.Top!==null?this.TableMargins.Top:""),this._spnTableMarginRight.setValue(this.TableMargins.Right!==null?this.TableMargins.Right:""),this._spnTableMarginBottom.setValue(this.TableMargins.Bottom!==null?this.TableMargins.Bottom:""),this.ResumeEvents()},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textWidthSpaces:"Margins",textMargins:"Cell Margins",textTop:"Top",textLeft:"Left",textBottom:"Bottom",textRight:"Right",textTitle:"Table - Advanced Settings",textDefaultMargins:"Default Margins",textCheckMargins:"Use default margins",cancelButtonText:"Cancel",okButtonText:"Ok"}),Ext.define("PE.view.ParagraphSettingsAdvanced",{extend:"Ext.window.Window",alias:"widget.peparagraphsettingsadvanced",requires:["Ext.Array","Ext.form.field.ComboBox","Ext.window.Window","Common.component.ThemeColorPalette","Common.component.MetricSpinner","Common.component.IndeterminateCheckBox","Common.plugin.GridScrollPane","Ext.grid.Panel"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:390,width:516,layout:{type:"vbox",align:"stretch"},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this._changedProps=null,this.checkGroup=0,this._noApply=!0,this._tabListChanged=!1,this.numFirstLine=Ext.create("Common.component.MetricSpinner",{id:"paragraphadv-spin-first-line",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Ind()===null||this._changedProps.get_Ind()===undefined)&&this._changedProps.put_Ind(new CParagraphInd),this._changedProps.get_Ind().put_FirstLine(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this.numIndentsLeft=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-indent-left",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Ind()===null||this._changedProps.get_Ind()===undefined)&&this._changedProps.put_Ind(new CParagraphInd),this._changedProps.get_Ind().put_Left(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this.numIndentsRight=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-indent-right",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&((this._changedProps.get_Ind()===null||this._changedProps.get_Ind()===undefined)&&this._changedProps.put_Ind(new CParagraphInd),this._changedProps.get_Ind().put_Right(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())))},this)}}),this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.chStrike=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-strike",width:140,boxLabel:this.strStrike,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=1&&this._changedProps.put_Strikeout(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=1,this.chDoubleStrike.setValue(0),this._changedProps&&this._changedProps.put_DStrikeout(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Strikeout(e.getValue()=="checked"),i.put_DStrikeout(this.chDoubleStrike.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chDoubleStrike=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-double-strike",width:140,boxLabel:this.strDoubleStrike,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=1&&this._changedProps.put_DStrikeout(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=1,this.chStrike.setValue(0),this._changedProps&&this._changedProps.put_Strikeout(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_DStrikeout(e.getValue()=="checked"),i.put_Strikeout(this.chStrike.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSuperscript=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-superscript",width:140,boxLabel:this.strSuperscript,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=2&&this._changedProps.put_Superscript(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=2,this.chSubscript.setValue(0),this._changedProps&&this._changedProps.put_Subscript(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Superscript(e.getValue()=="checked"),i.put_Subscript(this.chSubscript.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSubscript=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-subscript",width:140,boxLabel:this.strSubscript,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=2&&this._changedProps.put_Subscript(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=2,this.chSuperscript.setValue(0),this._changedProps&&this._changedProps.put_Superscript(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_Subscript(e.getValue()=="checked"),i.put_Superscript(this.chSuperscript.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chSmallCaps=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-small-caps",width:140,boxLabel:this.strSmallCaps,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=3&&this._changedProps.put_SmallCaps(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=3,this.chAllCaps.setValue(0),this._changedProps&&this._changedProps.put_AllCaps(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_SmallCaps(e.getValue()=="checked"),i.put_AllCaps(this.chAllCaps.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.chAllCaps=Ext.create("Common.component.IndeterminateCheckBox",{id:"paragraphadv-checkbox-all-caps",width:140,boxLabel:this.strAllCaps,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this.checkGroup!=3&&this._changedProps.put_AllCaps(e.getValue()=="checked"),this.checkGroup=0,e.getValue()=="checked"&&(this.checkGroup=3,this.chSmallCaps.setValue(0),this._changedProps&&this._changedProps.put_SmallCaps(!1),this.checkGroup=0);if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_AllCaps(e.getValue()=="checked"),i.put_SmallCaps(this.chSmallCaps.getValue()=="checked"),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.numSpacing=Ext.create("Common.component.MetricSpinner",{id:"paragraphadv-spin-spacing",readOnly:!1,step:.01,width:100,defaultUnit:"cm",value:"0 cm",maxValue:55.87,minValue:-55.87,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_TextSpacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()));if(this.api&&!this._noApply){var i=this._originalProps?this._originalProps:new CParagraphProp;i.put_TextSpacing(Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",i)}},this)}}),this.fontImage=Ext.create("Ext.container.Container",{id:"paragraphadv-font-img",width:"100%",height:80,style:"background-color:#ffffff; border:1px solid #CDCDCD;"}),this.numTab=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-tab",readOnly:!1,step:.1,width:180,defaultUnit:"cm",value:"1.25 cm",maxValue:55.87,minValue:0}),this.numDefaultTab=Ext.widget("commonmetricspinner",{id:"paragraphadv-spin-default-tab",readOnly:!1,step:.1,width:107,defaultUnit:"cm",value:"1.25 cm",maxValue:55.87,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this._changedProps&&this._changedProps.put_DefaultTab(parseFloat(Common.MetricSettings.fnRecalcToMM(e.getNumberValue()).toFixed(1)))},this)}}),this.btnAddTab=Ext.create("Ext.Button",{width:90,text:this.textSet,enableToggle:!1,listeners:{click:Ext.bind(function(e,n){var r=this.numTab.getNumberValue(),i=this.radioLeft.getValue()?1:this.radioCenter.getValue()?3:2,s=t.findBy(function(e,t){return Math.abs(e.data.tabPos-r)<.001},this);if(s<0){var o=t.add({tabPos:r,tabStr:r+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],tabAlign:i});t.sort(),this.tabList.getSelectionModel().select(o)}else{var o=t.getAt(s);o.set("tabAlign",i)}},this)}}),this.btnRemoveTab=Ext.create("Ext.Button",{width:90,text:this.textRemove,enableToggle:!1,listeners:{click:Ext.bind(function(e,n){var r=this.tabList.getSelectionModel().getSelection();if(r.length>0){var i=r[0].index;t.remove(r),i>t.count()-1&&(i=t.count()-1),i>-1&&this.tabList.getSelectionModel().select(i)}},this)}}),this.btnRemoveAll=Ext.create("Ext.Button",{width:90,text:this.textRemoveAll,enableToggle:!1,listeners:{click:Ext.bind(function(e,n){t.removeAll()},this)}}),this.radioLeft=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabLeft,name:"asc-radio-tab",checked:!0}),this.radioCenter=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabCenter,name:"asc-radio-tab",checked:!1}),this.radioRight=Ext.create("Ext.form.field.Radio",{boxLabel:this.textTabRight,name:"asc-radio-tab",checked:!1}),Ext.define("PE.model.TabDataModel",{extend:"Ext.data.Model",fields:[{name:"tabPos",name:"tabStr",name:"tabAlign"}]});var t=Ext.create("Ext.data.Store",{model:"PE.model.TabDataModel",data:[],sorters:["tabPos"],listeners:{datachanged:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this),update:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this),clear:Ext.bind(function(e,t){this._noApply||(this._tabListChanged=!0)},this)}});this.tabList=Ext.create("Ext.grid.Panel",{activeItem:0,id:"paragraphadv-tab-list",store:t,mode:"local",scroll:!1,columns:[{flex:1,dataIndex:"tabStr"}],height:80,width:180,hideHeaders:!0,viewConfig:{stripeRows:!1},plugins:[{pluginId:"scrollpane",ptype:"gridscrollpane"}],listeners:{select:function(e,t,n,r){this.numTab.setValue(t.data.tabPos),t.data.tabAlign==1?this.radioLeft.setValue(!0):t.data.tabAlign==3?this.radioCenter.setValue(!0):this.radioRight.setValue(!0)},scope:this}}),this.btnIndents=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.strParagraphIndents,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",pressed:!0,listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-indents")},scope:this}}),this.btnFont=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",text:this.strParagraphFont,textAlign:"right",enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&this.mainCard.getLayout().setActiveItem("card-font")},scope:this}}),this.btnTabs=Ext.widget("button",{width:160,height:27,cls:"asc-dialogmenu-btn",textAlign:"right",text:this.strTabs,enableToggle:!0,allowDepress:!1,toggleGroup:"advtablecardGroup",listeners:{click:function(e){e.pressed&&(this.mainCard.getLayout().setActiveItem("card-tabs"),this.tabList.getPlugin("scrollpane").updateScrollPane())},scope:this}}),this._IndentsContainer={xtype:"container",itemId:"card-indents",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 10",layout:{type:"table",columns:5},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:40,style:"float:left;"},items:[{items:[{xtype:"label",text:this.strIndentsFirstLine,width:85},{xtype:"tbspacer",height:3},this.numFirstLine]},{xtype:"tbspacer",width:23,height:3},{items:[{xtype:"label",text:this.strIndentsLeftText,width:85},{xtype:"tbspacer",height:3},this.numIndentsLeft]},{xtype:"tbspacer",width:23,height:3},{items:[{xtype:"label",text:this.strIndentsRightText,width:85},{xtype:"tbspacer",height:3},this.numIndentsRight]}]}]},this._FontContainer={xtype:"container",itemId:"card-font",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textEffects},{xtype:"tbspacer",height:8},{xtype:"container",height:85,width:"100%",padding:"0 10",layout:{type:"table",columns:3,tdAttrs:{style:"vertical-align: middle;"}},items:[this.chStrike,{xtype:"tbspacer",width:20,height:2},this.chSubscript,this.chDoubleStrike,{xtype:"tbspacer",width:20,height:2},this.chSmallCaps,this.chSuperscript,{xtype:"tbspacer",width:20,height:2},this.chAllCaps]},{xtype:"label",style:"font-weight: bold;margin-top: 1px; padding-left:10px;height:13px;",text:this.textCharacterSpacing},{xtype:"tbspacer",height:8},{xtype:"container",height:26,padding:"0 10",layout:{type:"vbox",align:"left"},items:[this.numSpacing]},{xtype:"tbspacer",height:10},{xtype:"container",height:85,padding:"0 10",items:[this.fontImage]}]},this._TabsContainer={xtype:"container",itemId:"card-tabs",width:330,layout:{type:"vbox",align:"stretch"},items:[{xtype:"container",padding:"0 0 0 10",layout:{type:"table",columns:3,tdAttrs:{style:"padding-right: 7px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},style:"float:left;"},items:[{height:50,colspan:2,items:[{xtype:"label",text:this.textTabPosition,width:85},{xtype:"tbspacer",height:3},this.numTab]},{height:50,items:[{xtype:"label",text:this.textDefault,width:107},{xtype:"tbspacer",height:3},this.numDefaultTab]},{height:95,colspan:3,items:[this.tabList]},{height:100,colspan:3,items:[{xtype:"label",text:this.textAlign,width:85},{xtype:"tbspacer",height:3},this.radioLeft,this.radioCenter,this.radioRight]},this.btnAddTab,this.btnRemoveTab,this.btnRemoveAll]}]},this.items=[{xtype:"container",height:300,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",width:160,padding:"5px 0 0 0",layout:{type:"vbox",align:"stretch"},defaults:{xtype:"container",layout:{type:"hbox",align:"middle",pack:"end"}},items:[{height:30,items:[this.btnIndents]},{height:30,items:[this.btnFont]},{height:30,items:[this.btnTabs]}]},{xtype:"box",cls:"advanced-settings-separator",height:"100%",width:8},this.mainCard=Ext.create("Ext.container.Container",{height:300,flex:1,padding:"12px 18px 0 10px",layout:"card",items:[this._IndentsContainer,this._FontContainer,this._TabsContainer]})]},this._spacer.cloneConfig({style:"margin: 0 18px"}),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,1,this.getSettings()),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",this,0),this.close()},scope:this}})]}]}],this.callParent(arguments)},afterRender:function(){this.callParent(arguments),this._setDefaults(this._originalProps),this.setTitle(this.textTitle)},setSettings:function(e){this._originalProps=new CParagraphProp(e.paragraphProps),this._changedProps=null,this.api=e.api},_setDefaults:function(e){if(e){this._originalProps=new CParagraphProp(e),this.numFirstLine.setValue(e.get_Ind()!==null&&e.get_Ind().get_FirstLine()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Ind().get_FirstLine()):""),this.numIndentsLeft.setValue(e.get_Ind()!==null&&e.get_Ind().get_Left()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Ind().get_Left()):""),this.numIndentsRight.setValue(e.get_Ind()!==null&&e.get_Ind().get_Right()!==null?Common.MetricSettings.fnRecalcFromMM(e.get_Ind().get_Right()):""),this._noApply=!0,this.chStrike.setValue(e.get_Strikeout()!==null&&e.get_Strikeout()!==undefined?e.get_Strikeout():"indeterminate"),this.chDoubleStrike.setValue(e.get_DStrikeout()!==null&&e.get_DStrikeout()!==undefined?e.get_DStrikeout():"indeterminate"),this.chSubscript.setValue(e.get_Subscript()!==null&&e.get_Subscript()!==undefined?e.get_Subscript():"indeterminate"),this.chSuperscript.setValue(e.get_Superscript()!==null&&e.get_Superscript()!==undefined?e.get_Superscript():"indeterminate"),this.chSmallCaps.setValue(e.get_SmallCaps()!==null&&e.get_SmallCaps()!==undefined?e.get_SmallCaps():"indeterminate"),this.chAllCaps.setValue(e.get_AllCaps()!==null&&e.get_AllCaps()!==undefined?e.get_AllCaps():"indeterminate"),this.numSpacing.setValue(e.get_TextSpacing()!==null&&e.get_TextSpacing()!==undefined?Common.MetricSettings.fnRecalcFromMM(e.get_TextSpacing()):""),this.api.SetDrawImagePlaceParagraph("paragraphadv-font-img",this._originalProps),this.numDefaultTab.setValue(e.get_DefaultTab()!==null&&e.get_DefaultTab()!==undefined?Common.MetricSettings.fnRecalcFromMM(parseFloat(e.get_DefaultTab().toFixed(1))):"");var t=e.get_Tabs();if(t){var n=[],r=t.get_Count();for(var i=0;i<r;i++){var s=t.get_Tab(i),o={tabPos:Common.MetricSettings.fnRecalcFromMM(parseFloat(s.get_Pos().toFixed(1))),tabAlign:s.get_Value()};o.tabStr=parseFloat(Ext.Number.toFixed(o.tabPos,3))+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],n.push(o)}this.tabList.getStore().loadData(n),this.tabList.getStore().sort(),this.tabList.getStore().count()>0&&this.tabList.getSelectionModel().select(0)}this._noApply=!1,this._changedProps=new CParagraphProp}},getSettings:function(){return this._tabListChanged&&((this._changedProps.get_Tabs()===null||this._changedProps.get_Tabs()===undefined)&&this._changedProps.put_Tabs(new CParagraphTabs),this.tabList.getStore().each(function(e,t){var n=new CParagraphTab(Common.MetricSettings.fnRecalcToMM(e.data.tabPos),e.data.tabAlign);this._changedProps.get_Tabs().add_Tab(n)},this)),{paragraphProps:this._changedProps}},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.id=="paragraphadv-spin-spacing"?n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1):n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textTitle:"Paragraph - Advanced Settings",strIndentsFirstLine:"First line",strIndentsLeftText:"Left",strIndentsRightText:"Right",strParagraphIndents:"Indents & Placement",strParagraphFont:"Font",cancelButtonText:"Cancel",okButtonText:"Ok",textEffects:"Effects",textCharacterSpacing:"Character Spacing",strDoubleStrike:"Double strikethrough",strStrike:"Strikethrough",strSuperscript:"Superscript",strSubscript:"Subscript",strSmallCaps:"Small caps",strAllCaps:"All caps",strTabs:"Tab",textSet:"Specify",textRemove:"Remove",textRemoveAll:"Remove All",textTabLeft:"Left",textTabRight:"Right",textTabCenter:"Center",textAlign:"Alignment",textTabPosition:"Tab Position",textDefault:"Default Tab"}),Ext.define("PE.view.ImageSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.peimagesettings",height:202,requires:["Ext.ComponentQuery","Ext.container.Container","Ext.button.Button","Ext.form.Label","Ext.toolbar.Spacer","Common.view.ImageFromUrlDialog","PE.view.ImageSettingsAdvanced"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._nRatio=1,this._state={Width:0,Height:0},this._btnOriginalSize=Ext.create("Ext.Button",{id:"image-button-original-size",text:this.textOriginalSize,width:100,listeners:{click:this.setOriginalSize,scope:this}}),this._btnInsertFromFile=Ext.create("Ext.Button",{id:"image-button-from-file",text:this.textFromFile,width:85,listeners:{click:function(e){this.api&&this.api.ChangeImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"image-button-from-url",text:this.textFromUrl,width:85,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._SizePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:61,width:200,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:16,style:"float:left;"},items:[{items:[this.labelWidth=Ext.create("Ext.form.Label",{text:this.textWidth,width:85})]},{items:[this.labelHeight=Ext.create("Ext.form.Label",{text:this.textHeight,width:85})]}]},{xtype:"tbspacer",height:7},this._btnOriginalSize,{xtype:"tbspacer",height:3}]}),this._UrlPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:36,width:200,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},items:[this._btnInsertFromFile,this._btnInsertFromUrl]},{xtype:"tbspacer",height:2}]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textSize},this._SizePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textInsert},this._UrlPanel,{xtype:"tbspacer",height:8},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:200,items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="image-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("image-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setOriginalSize:function(){if(this.api){var e=this.api.get_OriginalSizeImage();if(e){var t=e.get_ImageWidth(),n=e.get_ImageHeight();this.labelWidth.setText(this.textWidth+": "+Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(t),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),this.labelHeight.setText(this.textHeight+": "+Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(n),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]);var r=new CImgProperty;r.put_Width(t),r.put_Height(n),this.api.ImgApply(r)}this.fireEvent("editcomplete",this)}},setApi:function(e){if(e==undefined)return;this.api=e},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){var t=e.get_Width();if(Math.abs(this._state.Width-t)>.001||(this._state.Width===null||t===null)&&this._state.Width!==t)this.labelWidth.setText(this.textWidth+": "+(t!==null?Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(t),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]:"-")),this._state.Width=t;t=e.get_Height();if(Math.abs(this._state.Height-t)>.001||(this._state.Height===null||t===null)&&this._state.Height!==t)this.labelHeight.setText(this.textHeight+": "+(t!==null?Ext.util.Format.round(Common.MetricSettings.fnRecalcFromMM(t),1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]:"-")),this._state.Height=t;this._btnOriginalSize.setDisabled(e.get_ImageUrl()===null||e.get_ImageUrl()===undefined)}},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""){var i=new CImgProperty;i.put_ImageUrl(n.value),t.api.ImgApply(i)}}},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Image==i){n=Ext.create("PE.view.ImageSettingsAdvanced",{}),n.updateMetricUnit(),n.setSettings(s);break}}}}if(n){if(!t._btnOriginalSize.isDisabled()){var u=this.api.get_OriginalSizeImage();u&&n.setSizeOriginal({width:u.get_ImageWidth(),height:u.get_ImageHeight()})}n.addListener("onmodalresult",Ext.bind(function(e,n,r){n==1&&r&&t.api.ImgApply(r),this.fireEvent("editcomplete",this)},this),!1),n.show()}},updateMetricUnit:function(){var e=Common.MetricSettings.fnRecalcFromMM(this._state.Width);this.labelWidth.setText(this.textWidth+": "+Ext.util.Format.round(e,1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),e=Common.MetricSettings.fnRecalcFromMM(this._state.Height),this.labelHeight.setText(this.textHeight+": "+Ext.util.Format.round(e,1)+" "+Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()])},createDelayedElements:function(){this.updateMetricUnit()},textSize:"Size",textKeepRatio:"Constant Proportions",textWidth:"Width",textHeight:"Height",textOriginalSize:"Default Size",textUrl:"Image URL",textInsert:"Change Image",textFromUrl:"From URL",textFromFile:"From File",textAdvanced:"Show advanced settings",txtTitle:"Picture"}),Ext.define("PE.model.ModelBorders",{extend:"Ext.data.Model",fields:[{type:"string",name:"borderstyle"},{type:"string",name:"text"},{type:"string",name:"url"},{type:"float",name:"value"},{type:"int",name:"imagewidth"},{type:"int",name:"imageheight"}]}),Ext.define("PE.view.ShapeSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.peshapesettings",height:316,requires:["Ext.button.Button","Ext.form.Label","Ext.form.field.ComboBox","Ext.container.Container","Ext.toolbar.Spacer","Ext.Array","Ext.menu.Menu","Ext.menu.Manager","Ext.data.Model","Ext.data.Store","Ext.XTemplate","Ext.Img","Ext.slider.Single","Common.component.DataViewPicker","Common.component.MetricSpinner","Common.view.ImageFromUrlDialog","Common.component.ThemeColorPalette","PE.view.ShapeSettingsAdvanced","Common.plugin.MenuExpand","Common.component.ComboDataView","Common.component.MultiSliderGradient","Common.plugin.ComboBoxScrollPane"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0;var e=this;this._originalProps=null,this._noApply=!0,this._sendUndoPoint=!0,this._state={Transparency:null,FillType:c_oAscFill.FILL_TYPE_SOLID,ShapeColor:"ffffff",BlipFillType:c_oAscFillBlipType.STRETCH,StrokeType:c_oAscStrokeType.STROKE_COLOR,StrokeWidth:this._pt2mm(1),StrokeColor:"000000",FGColor:"000000",BGColor:"ffffff",GradColor:"000000",GradFillType:c_oAscFillGradType.GRAD_LINEAR,DisabledFillPanels:!1},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID,this.ShapeColor={Value:1,Color:"ffffff"},this.BlipFillType=c_oAscFillBlipType.STRETCH,this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.GradColor={values:[0,100],colors:["000000","ffffff"],currentIdx:0},this.GradLinearDirectionIdx=3,this.GradRadialDirectionIdx=0,this.PatternFillType=0,this.FGColor={Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.BorderColor={Value:1,Color:"transparent"},this.BorderSize=0,this.textureNames=[this.txtCanvas,this.txtCarton,this.txtDarkFabric,this.txtGrain,this.txtGranite,this.txtGreyPaper,this.txtKnit,this.txtLeather,this.txtBrownPaper,this.txtPapyrus,this.txtWood],this.ThemeValues=[6,15,7,16,0,1,2,3,4,5];var t=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:-1},{text:"0.5 pt",value:.5,offsety:0},{text:"1 pt",value:1,offsety:20},{text:"1.5 pt",value:1.5,offsety:40},{text:"2.25 pt",value:2.25,offsety:60},{text:"3 pt",value:3,offsety:80},{text:"4.5 pt",value:4.5,offsety:100},{text:"6 pt",value:6,offsety:120}];for(var n=1;n<t.length;n++)t[n].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-t[n].offsety);var r=Ext.create("Ext.data.Store",{model:"PE.model.ModelBorders",data:t}),i=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:92,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:r,style:"margin-right: 8px;",listConfig:{mode:"local",width:145,itemTpl:i},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize=n[0].data.value;if(this.api&&!this._noApply){var i=new CAscShapeProp,s=new CAscStroke;this.BorderSize<.01?s.put_type(c_oAscStrokeType.STROKE_NONE):(s.put_type(c_oAscStrokeType.STROKE_COLOR),this.BorderColor.Color=="transparent"||this.BorderColor.Color.color=="transparent"?s.put_color(this.getRgbColor({color:"000000",effectId:0})):this._state.StrokeType==c_oAscStrokeType.STROKE_NONE&&s.put_color(this.getRgbColor(this.colorValue2EffectId(this.BorderColor.Color))),s.put_width(this._pt2mm(this.BorderSize))),i.put_stroke(s),this.api.ShapeApply(i)}if(t.inputEl)if(n[0].data.offsety<0){var o=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,o),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}else{t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var o=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,o)}this.fireEvent("editcomplete",this)},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var s=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(s),this.BorderSize=s.data.value,this._btnBorderColor=Ext.create("Ext.button.Button",{id:"shape-button-border-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBorderColor.color=t,this._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBorderColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BorderColor={Value:1,Color:t};if(this.api&&this.BorderSize>0&&!this._noApply){var r=new CAscShapeProp,i=new CAscStroke;this.BorderSize<.01?i.put_type(c_oAscStrokeType.STROKE_NONE):(i.put_type(c_oAscStrokeType.STROKE_COLOR),i.put_color(this.getRgbColor(this.BorderColor.Color)),i.put_width(this._pt2mm(this.BorderSize))),r.put_stroke(i),this.api.ShapeApply(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBorder),this._btnBackColor=Ext.create("Ext.button.Button",{id:"shape-button-back-color",arrowCls:"",width:45,height:22,color:"ffffff",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll();var r,i;t=="transparent"?(this._btnBackColor.color="transparent",r="transparent",i="1px solid #BEBEBE"):(this._btnBackColor.color=t,r=Ext.String.format("#{0}",typeof t=="object"?t.color:t),i="none"),this._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBackColor.btnEl,{"background-color":r,border:i}),this.ShapeColor={Value:1,Color:this._btnBackColor.color};if(this.api&&!this._noApply){var s=new CAscShapeProp,o=new CAscFill;this.ShapeColor.Color=="transparent"?(o.put_type(c_oAscFill.FILL_TYPE_NOFILL),o.put_fill(null)):(o.put_type(c_oAscFill.FILL_TYPE_SOLID),o.put_fill(new CAscFillSolid),o.get_fill().put_color(this.getRgbColor(this.ShapeColor.Color))),s.put_fill(o),this.api.ShapeApply(s)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this._arrFillSrc=[this.textColor,this.textGradientFill,this.textImageTexture,this.textPatternFill,this.textNoFill],this.cmbFillSrc=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-fill-src",width:190,editable:!1,store:this._arrFillSrc,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._ShowHideElem([t[0].index==0,t[0].index==2,t[0].index==3,t[0].index==1,t[0].index>=0&&t[0].index<4],[this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,this._TransparencyContainer],[this._FillColorContainerHeight,this._FillImageContainerHeight,this._PatternContainerHeight,this._GradientContainerHeight,this._TransparencyContainerHeight]);switch(t[0].index){case 0:this._state.FillType=c_oAscFill.FILL_TYPE_SOLID;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;this.ShapeColor.Color=="transparent"?(i.put_type(c_oAscFill.FILL_TYPE_NOFILL),i.put_fill(null)):(i.put_type(c_oAscFill.FILL_TYPE_SOLID),i.put_fill(new CAscFillSolid),i.get_fill().put_color(this.getRgbColor(this.ShapeColor.Color))),r.put_fill(i),this.api.ShapeApply(r)}break;case 1:this._state.FillType=c_oAscFill.FILL_TYPE_GRAD;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(l[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),r.put_fill(i),this.api.ShapeApply(r)}break;case 2:this._state.FillType=c_oAscFill.FILL_TYPE_BLIP;break;case 3:this._state.FillType=c_oAscFill.FILL_TYPE_PATT;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color)),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color)),r.put_fill(i),this.api.ShapeApply(r)}break;case 4:this._state.FillType=c_oAscFill.FILL_TYPE_NOFILL;if(!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_NOFILL),i.put_fill(null),r.put_fill(i),this.api.ShapeApply(r)}}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillSrc.setValue(this._arrFillSrc[0]),this._FillColorContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:25,width:190,items:[this._btnBackColor]}),this._FillColorContainerHeight=this._FillColorContainer.height,this._btnInsertFromFile=Ext.create("Ext.Button",{id:"shape-button-fill-from-file",text:this.textFromFile,width:90,listeners:{click:function(e){this.api&&this.api.ChangeShapeImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"shape-button-fill-from-url",text:this.textFromUrl,width:90,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._arrFillType=[this.textStretch,this.textTile],this.cmbFillType=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-fill-type",width:90,editable:!1,store:this._arrFillType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?this.BlipFillType=c_oAscFillBlipType.STRETCH:t[0].index==1&&(this.BlipFillType=c_oAscFillBlipType.TILE);if(this.api&&this._fromTextureCmb!==!0&&this.OriginalFillType==c_oAscFill.FILL_TYPE_BLIP){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_BLIP),i.put_fill(new CAscFillBlip),i.get_fill().put_type(this.BlipFillType),r.put_fill(i),this.api.ShapeApply(r)}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillType.setValue(this._arrFillType[0]),this.controls.push(this.cmbFillType),this._btnTexture=Ext.create("Ext.button.Button",{text:this.textSelectTexture,width:90,cls:"btn-combo-style",pressedCls:"",textAlign:"left",menu:this.textureMenu=Ext.create("Common.component.MenuDataViewPicker",{width:242,height:182,cls:"texture-view",viewData:[],contentWidth:222,listeners:{select:Ext.bind(function(e,t){this._fromTextureCmb=!0,this.cmbFillType.setValue(this._arrFillType[1]),this._fromTextureCmb=!1;if(this.api){var n=new CAscShapeProp,r=new CAscFill;r.put_type(c_oAscFill.FILL_TYPE_BLIP),r.put_fill(new CAscFillBlip),r.get_fill().put_type(c_oAscFillBlipType.TILE),r.get_fill().put_texture_id(t.data.data.type),n.put_fill(r),this.api.ShapeApply(n)}this._btnTexture.setText(t.data.name),this.fireEvent("editcomplete",this)},this),hide:function(){e.fireEvent("editcomplete",e)},show:function(e){e.picker.selectByIndex(-1,!1)}}})}),this.controls.push(this._btnTexture),this.textureImage=Ext.create("Ext.container.Container",{id:"shape-texture-img",width:50,height:50});var o=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imageStyle}" class="{imageCls}"/>',"</div>","</tpl>");this.patternViewData=[];var u=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"PE.model.PatternDataModel",data:this.patternViewData});this._cmbPattern=Ext.create("Common.component.ComboDataView",{id:"shape-combo-pattern",width:190,height:42,itemWidth:28,itemHeight:28,menuMaxHeight:300,repeatedselect:!0,store:u,dataTpl:o,viewData:[],emptyComboText:this.textEmptyPattern,listeners:{select:function(t,n){if(e.api&&!e._noApply){e.PatternFillType=n.data.data.type;var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_pattern_type(n.data.data.type),e.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_color_fg(e.getRgbColor(e.FGColor.Color)),i.get_fill().put_color_bg(e.getRgbColor(e.BGColor.Color))),r.put_fill(i),e.api.ShapeApply(r)}e.fireEvent("editcomplete",e)},menuhide:function(){e.fireEvent("editcomplete",e)},releasecapture:function(t){e.fireEvent("editcomplete",e)}}}),this.controls.push(this._cmbPattern),this._cmbPattern.addCls("shape-pattern"),this._cmbPattern.dataMenu.picker.contentWidth=170,this._cmbPattern.dataMenu.picker.needArrangeSlideItems=!0,this._cmbPattern.dataMenu.picker.arrangeItems=this._arrangeSlideItems,this._cmbPattern.dataMenu.picker.resizeSlideItems=this._resizeSlideItems,this._btnFGColor=Ext.create("Ext.button.Button",{id:"shape-button-foreground-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsFG=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnFGColor.color=t,this._btnFGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnFGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.FGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color))),r.put_fill(i),this.api.ShapeApply(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsFG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsFG),this._btnBGColor=Ext.create("Ext.button.Button",{id:"shape-button-background-color",arrowCls:"",width:45,height:22,color:"ffffff",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBG=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBGColor.color=t,this._btnBGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color))),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color)),r.put_fill(i),this.api.ShapeApply(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBG),this._PatternContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:141,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"label",text:this.strPattern},{xtype:"tbspacer",height:2},this._cmbPattern,{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strForeground,flex:1},this._btnFGColor]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strBackground,flex:1},this._btnBGColor]}]}),this._PatternContainerHeight=this._PatternContainer.height;var a=Ext.bind(function(e){this._cmbPattern.dataMenu.picker.store.getCount()>0&&(this._cmbPattern.fillComboView(this._cmbPattern.dataMenu.picker.store.getAt(0),!0),this.PatternFillType=this.patternViewData[0].data.type,this._cmbPattern.dataMenu.picker.updateScrollPane(),this._PatternContainer.un("show",a))},this);this._PatternContainer.on("show",a),this._arrGradType=[this.textLinear,this.textRadial],this.cmbGradType=Ext.create("Ext.form.field.ComboBox",{id:"shape-combo-grad-type",width:90,editable:!1,store:this._arrGradType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?(this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.btnDirection.menu.picker.store.loadData(l),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(l[this.GradLinearDirectionIdx].iconcls):this.btnDirection.setIconCls("")):t[0].index==1&&(this.GradFillType=c_oAscFillGradType.GRAD_PATH,this.btnDirection.menu.picker.store.loadData(c),this.btnDirection.menu.picker.selectByIndex(this.GradRadialDirectionIdx),this.GradRadialDirectionIdx>=0?this.btnDirection.setIconCls(c[this.GradRadialDirectionIdx].iconcls):this.btnDirection.setIconCls(""));if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(l[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),r.put_fill(i),this.api.ShapeApply(r)}this.fireEvent("editcomplete",this)},this)}}),this.cmbGradType.setValue(this._arrGradType[0]);var f=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="item-gradient"/>',"</div>",'<tpl if="separator">','<div class="gradient-separator"></div>',"</tpl>","</tpl>"),l=[{offsetx:0,offsety:0,data:{type:45,subtype:-1},iconcls:"gradient-subtype gradient-left-top"},{offsetx:50,offsety:0,data:{type:90,subtype:4},iconcls:"gradient-subtype gradient-top"},{offsetx:100,offsety:0,data:{type:135,subtype:5},iconcls:"gradient-subtype gradient-right-top"},{offsetx:0,offsety:50,data:{type:0,subtype:6},iconcls:"gradient-subtype gradient-left",separator:!0},{offsetx:100,offsety:50,data:{type:180,subtype:1},iconcls:"gradient-subtype gradient-right"},{offsetx:0,offsety:100,data:{type:315,subtype:2},iconcls:"gradient-subtype gradient-left-bottom"},{offsetx:50,offsety:100,data:{type:270,subtype:3},iconcls:"gradient-subtype gradient-bottom"},{offsetx:100,offsety:100,data:{type:225,subtype:7},iconcls:"gradient-subtype gradient-right-bottom"}];for(var n=0;n<l.length;n++)l[n].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-l[n].offsetx,-l[n].offsety);var c=[{offsetx:100,offsety:150,data:{type:2,subtype:5},iconcls:"gradient-subtype gradient-radial-center"}];for(var n=0;n<c.length;n++)c[n].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-c[n].offsetx,-c[n].offsety);this.btnDirection=Ext.widget("button",{id:"shape-button-direction",width:72,height:58,cls:"btn-wrap-types",iconCls:"gradient-subtype gradient-left",pressedCls:"disablepressed",menuAlign:"tl-bl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:195,height:190,minWidth:50,cls:"gradient-view",dataTpl:f,viewData:l,contentWidth:175,listeners:{select:Ext.bind(function(e,t,n,r){this.btnDirection.setIconCls(t.data.iconcls),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?this.GradLinearDirectionIdx=r:this.GradRadialDirectionIdx=r;if(this.api&&!this._noApply){if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var i=new CAscShapeProp,s=new CAscFill;s.put_type(c_oAscFill.FILL_TYPE_GRAD),s.put_fill(new CAscFillGrad),s.get_fill().put_grad_type(this.GradFillType),s.get_fill().put_linear_angle(t.data.data.type*6e4),s.get_fill().put_linear_scale(!0),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(s.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),s.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),i.put_fill(s),this.api.ShapeApply(i)}Ext.menu.Manager.hideAll()}this.fireEvent("editcomplete",this)},this),hide:Ext.bind(function(){this.fireEvent("editcomplete",this)},this),beforeshow:Ext.bind(function(e){if(e.rendered){var t=e.getHeight();this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&Math.abs(t-190)>0&&(e.picker.contentWidth=175,e.setSize(195,190)),this.GradFillType==c_oAscFillGradType.GRAD_PATH&&Math.abs(t-70)>0&&(e.picker.contentWidth=50,e.setSize(70,70))}},this)}})}),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.controls.push(this.btnDirection),this._btnGradColor=Ext.create("Ext.button.Button",{id:"shape-button-gradient-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsGrad=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnGradColor.color=t,this._btnGradColor.btnEl&&Ext.DomHelper.applyStyles(this._btnGradColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.GradColor.colors[this.GradColor.currentIdx]=t,this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof t=="object"?t.color:t));if(this.api&&!this._noApply){var r=new CAscShapeProp,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(l[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3])),r.put_fill(i),this.api.ShapeApply(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsGrad.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsGrad);var h=!1,p,d=function(){if(h){var t=new CAscShapeProp,n=new CAscFill;n.put_type(c_oAscFill.FILL_TYPE_GRAD),n.put_fill(new CAscFillGrad),n.get_fill().put_grad_type(e.GradFillType),n.get_fill().put_positions([e.GradColor.values[0]*1e3,e.GradColor.values[1]*1e3]),e.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(e.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(n.get_fill().put_linear_angle(l[e.GradLinearDirectionIdx].data.type*6e4),n.get_fill().put_linear_scale(!0)),n.get_fill().put_colors([e.getRgbColor(e.GradColor.colors[0]),e.getRgbColor(e.GradColor.colors[1])])),t.put_fill(n),e.api.ShapeApply(t),h=!1}};this.sldrGradient=Ext.create("Common.component.MultiSliderGradient",{animate:!1,width:140,values:[0,100],increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-multi-slider-gradient",listeners:{change:Ext.bind(function(e,t,n){this.GradColor.values=e.getValues(),h=!0,this.api&&!this._noApply&&this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,p=setInterval(d,100))},this),changecomplete:Ext.bind(function(e,t,n){clearInterval(p),d(),this.api.setEndPointHistory(),this._sendUndoPoint=!0,Ext.menu.Manager.hideAll()},this),thumbclick:Ext.bind(function(e,t){this.GradColor.currentIdx=t;var n=this.GradColor.colors[this.GradColor.currentIdx];this._btnGradColor.setColor(n),this.colorsGrad.select(n,!1)},this),thumbdblclick:Ext.bind(function(e){this._btnGradColor.showMenu()},this)}}),this.controls.push(this.sldrGradient),this._GradientContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:150,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:100,height:80,items:[{xtype:"label",text:this.textStyle},{xtype:"tbspacer",height:2},this.cmbGradType,{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",flex:1},{xtype:"container",layout:"vbox",height:80,items:[{xtype:"label",text:this.textDirection},{xtype:"tbspacer",height:2},this.btnDirection]}]},{xtype:"tbspacer",height:3},{xtype:"label",text:this.textGradient,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},{xtype:"container",layout:{type:"hbox",align:"top"},width:190,height:35,items:[this.sldrGradient,{xtype:"tbspacer",flex:1},this._btnGradColor]}]}),this._GradientContainerHeight=this._GradientContainer.height;var v=function(){if(h!==undefined){var t=new CAscShapeProp,n=new CAscFill;n.put_transparent(h*2.55),t.put_fill(n),e.api.ShapeApply(t),h=undefined}};this.numTransparency=Ext.create("Common.component.MetricSpinner",{id:"shape-spin-transparency",readOnly:!1,step:1,width:65,defaultUnit:"%",value:"100 %",maxValue:100,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){this.sldrTransparency.suspendEvents(!1),this.sldrTransparency.setValue(e.getNumberValue()),this.sldrTransparency.resumeEvents();if(this.api){var i=e.getNumberValue(),s=new CAscShapeProp,o=new CAscFill;o.put_transparent(i*2.55),s.put_fill(o),this.api.ShapeApply(s)}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numTransparency),this.sldrTransparency=Ext.create("Ext.slider.Single",{animate:!1,width:80,value:100,increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-slider",listeners:{change:Ext.bind(function(e,t,n,r){h=t,this.numTransparency.suspendEvents(!1),this.numTransparency.setValue(t),this.numTransparency.resumeEvents(),this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,p=setInterval(v,100))},this),changecomplete:Ext.bind(function(e,t,n,r){clearInterval(p),v(),this.api.setEndPointHistory(),this._sendUndoPoint=!0},this)}}),this.controls.push(this.sldrTransparency),this._TransparencyContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:55,width:190,items:[{xtype:"tbspacer",height:10},{xtype:"label",text:this.strTransparency,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:2},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:"0",style:"margin: 2px 3px 0 0"},this.sldrTransparency,{xtype:"label",text:"100",style:"margin: 2px 0 0 3px"},{xtype:"tbspacer",flex:1},this.numTransparency]}]}),this._TransparencyContainerHeight=this._TransparencyContainer.height,this._FillImageContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:120,width:190,hidden:!0,items:[{xtype:"container",layout:"hbox",width:190,items:[this._btnInsertFromFile,{xtype:"tbspacer",flex:1},this._btnInsertFromUrl]},{xtype:"tbspacer",height:11},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:90,height:80,items:[this.cmbFillType,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textTexture},{xtype:"tbspacer",height:2},this._btnTexture]},{xtype:"tbspacer",flex:1},{xtype:"container",cls:"texture-img-container",layout:"vbox",width:90,height:80,items:[this.textureImage]}]}]}),this._FillImageContainerHeight=this._FillImageContainer.height,this._FillPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:45,width:190,items:[{xtype:"label",text:this.strFill,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},this.cmbFillSrc]}),this._btnChangeShape=Ext.create("Ext.button.Button",{id:"shape-button-change",width:45,iconCls:"btn-icon-change-shape",cls:"asc-right-panel-edit-btn",tooltip:this.tipShapeArrange,menu:{showSeparator:!1,bodyCls:"no-icons",items:[],listeners:{hide:{fn:function(){e.fireEvent("editcomplete",e)}}},plugins:[{ptype:"menuexpand"}]}}),this._StrokePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:51,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:41,layout:{type:"table",columns:2,tdAttrs:{style:"vertical-align: middle;"}},items:[{xtype:"label",text:this.strSize,style:"display: block;",width:80},{xtype:"label",text:this.strColor,style:"display: block;",width:80},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbBorderSize,this._btnBorderColor]}]}),this._ChangeContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:36,width:"100%",items:[{xtype:"tbspacer",height:3},{xtype:"container",height:30,width:190,layout:"hbox",items:[{xtype:"label",text:this.strChange,margin:"2px 0 0 0",style:"font-weight: bold;margin-top: 1px;",flex:1},{xtype:"tbspacer",width:7},this._btnChangeShape,{xtype:"tbspacer",width:5}]}]}),this.items=[{xtype:"tbspacer",height:7},this._FillPanel,{xtype:"tbspacer",height:7},this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,this._TransparencyContainer,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.strStroke},this._StrokePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this._ChangeContainer,{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:195,items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="shape-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("shape-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setApi:function(e){this.api=e;if(this.api){this.api.SetInterfaceDrawImagePlaceShape("shape-texture-img");var t=this.api.get_PropertyStandartTextures();t&&this._onInitStandartTextures(t)}},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},colorValue2EffectId:function(e){if(typeof e=="object"&&e.effectValue!==undefined&&this.effectcolors){var t=e.effectValue;for(var n=0;n<this.effectcolors.length;n++)if(this.effectcolors[n].effectValue===e.effectValue&&e.color.toUpperCase()===this.effectcolors[n].color.toUpperCase()){e.effectId=this.effectcolors[n].effectId;break}}return e},_pt2mm:function(e){return e*25.4/72},_mm2pt:function(e){return e*72/25.4},FillAutoShapes:function(){var e=Ext.getStore("ShapeGroups"),t=this,n=e.getCount();t._btnChangeShape.menu.removeAll();for(var r=0;r<n;r++){if(r==n-2)continue;var i=e.getAt(r),s=Ext.widget("menuitem",{text:i.data.groupName,hideOnClick:!1,cls:"menu-item-noicon",menuAlign:"tl-tl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:i.data.groupWidth,height:i.data.groupHeight,store:i.data.groupStore,viewData:[],contentWidth:i.data.groupWidth-20,listeners:{select:Ext.bind(function(e,n){t.api&&t.api.ChangeShapeType(n.data.data.shapeType)},this),hide:function(){t.fireEvent("editcomplete",t)},show:function(e){e.picker.selectByIndex(-1,!1)}},plugins:[{ptype:"menuexpand"}]}),deferExpandMenu:function(){if(!this.menu.rendered||!this.menu.isVisible())this.parentMenu.activeChild=this.menu,this.menu.parentItem=this,this.menu.parentMenu=this.menu.ownerCt=this.parentMenu,this.menu.showBy(this,this.menuAlign,[-this.menu.width,0])}});t._btnChangeShape.menu.add(s)}},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""&&t.BlipFillType!==null){var i=new CAscShapeProp,s=new CAscFill;s.put_type(c_oAscFill.FILL_TYPE_BLIP),s.put_fill(new CAscFillBlip),s.get_fill().put_type(t.BlipFillType),s.get_fill().put_url(n.value),i.put_fill(s),t.api.ShapeApply(i)}}},_ShowHideElem:function(e,t,n){var r=this.getHeight(),i=0;for(var s=0;s<e.length;s++)e[s]&&!t[s].isVisible()&&(t[s].show(),i+=n[s]),!e[s]&&t[s].isVisible()&&(i-=n[s],t[s].hide());this.setHeight(r+i),this.initialHeight=r+i,this.ownerCt.setHeight(this.initialHeight)},ChangeSettings:function(e){this._initSettings&&this.createDelayedElements(),this._initSettings=!1;if(e){this._originalProps=e,this.SuspendEvents(),this._noApply=!0,this.disableFillPanels(!e.get_CanFill());var t=null,n=e.get_fill(),r=n.get_type(),i=null,s=n.get_transparent();if(Math.abs(this._state.Transparency-s)>.001||Math.abs(this.numTransparency.getNumberValue()-s)>.001||(this._state.Transparency===null||s===null)&&(this._state.Transparency!==s||this.numTransparency.getNumberValue()!==s))s!==undefined&&(this.sldrTransparency.setValue(s===null?100:s/255*100),this.numTransparency.setValue(this.sldrTransparency.getValue())),this._state.Transparency=s;if(n===null||r===null||r==c_oAscFill.FILL_TYPE_NOFILL)this.OriginalFillType=c_oAscFill.FILL_TYPE_NOFILL;else if(r==c_oAscFill.FILL_TYPE_SOLID)n=n.get_fill(),i=n.get_color(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.ShapeColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.ShapeColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.ShapeColor={Value:0,Color:"transparent"},this.FGColor=this.ShapeColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.ShapeColor.Color)}:{Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID;else if(r==c_oAscFill.FILL_TYPE_BLIP)n=n.get_fill(),this.BlipFillType=n.get_type(),this._state.BlipFillType!==this.BlipFillType&&(this.BlipFillType==c_oAscFillBlipType.STRETCH?this.cmbFillType.setValue(this._arrFillType[0]):this.BlipFillType==c_oAscFillBlipType.TILE?this.cmbFillType.setValue(this._arrFillType[1]):this.cmbFillType.setValue(""),this._state.BlipFillType=this.BlipFillType),this.OriginalFillType=c_oAscFill.FILL_TYPE_BLIP;else if(r==c_oAscFill.FILL_TYPE_PATT){n=n.get_fill(),this.PatternFillType=n.get_pattern_type();if(this._state.PatternFillType!==this.PatternFillType){var o=this._cmbPattern.dataMenu.picker.store.findBy(function(e,t){return e.data.data.type===this.PatternFillType},this);this._cmbPattern.selectByIndex(o),this._state.PatternFillType=this.PatternFillType}i=n.get_color_fg(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.FGColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.FGColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.FGColor={Value:1,Color:"000000"},i=n.get_color_bg(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.BGColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.BGColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_PATT,this.ShapeColor=this.FGColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.FGColor.Color)}:{Value:1,Color:"ffffff"}}else if(r==c_oAscFill.FILL_TYPE_GRAD){n=n.get_fill();var u=n.get_grad_type();if(this._state.GradFillType!==u||this.GradFillType!==u)this.GradFillType=u,t=undefined,this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?t=this.cmbGradType.getStore().getAt(0):this.GradFillType==c_oAscFillGradType.GRAD_PATH?t=this.cmbGradType.getStore().getAt(1):(this.cmbGradType.setValue(""),this.btnDirection.setIconCls("")),t&&(this.cmbGradType.select(t),this.cmbGradType.fireEvent("select",this.cmbGradType,[t])),this._state.GradFillType=this.GradFillType;if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var a=Math.floor(n.get_linear_angle()/6e4),f,l=this.btnDirection.menu.picker.store.findBy(function(e,t){return f=e.data.iconcls,e.data.data.type===a},this);l!==this.GradLinearDirectionIdx&&(this.GradLinearDirectionIdx=l,this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx,!1),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(f):this.btnDirection.setIconCls(""))}var c=n.get_colors();c&&c.length>0&&(i=c[0],i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[0]={color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()},this.colorValue2EffectId(this.GradColor.colors[0])):this.GradColor.colors[0]=this.getHexColor(i.get_r(),i.get_g(),i.get_b()):this.GradColor.colors[0]="000000",i=c[1],i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[1]={color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()},this.colorValue2EffectId(this.GradColor.colors[1])):this.GradColor.colors[1]=this.getHexColor(i.get_r(),i.get_g(),i.get_b()):this.GradColor.colors[1]="ffffff");var h=n.get_positions();if(h&&h.length>0){var p=h[0];p!==null&&(p/=1e3,this.GradColor.values[0]=p),p=h[1],p!==null&&(p/=1e3,this.GradColor.values[1]=p)}this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[0]=="object"?this.GradColor.colors[0].color:this.GradColor.colors[0]),0),this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[1]=="object"?this.GradColor.colors[1].color:this.GradColor.colors[1]),1),this.sldrGradient.setValue(0,this.GradColor.values[0]),this.sldrGradient.setValue(1,this.GradColor.values[1]),this.OriginalFillType=c_oAscFill.FILL_TYPE_GRAD}if(this._state.FillType!==this.OriginalFillType){switch(this.OriginalFillType){case c_oAscFill.FILL_TYPE_SOLID:t=this.cmbFillSrc.getStore().getAt(0);break;case c_oAscFill.FILL_TYPE_GRAD:t=this.cmbFillSrc.getStore().getAt(1);break;case c_oAscFill.FILL_TYPE_BLIP:t=this.cmbFillSrc.getStore().getAt(2);break;case c_oAscFill.FILL_TYPE_PATT:t=this.cmbFillSrc.getStore().getAt(3);break;case c_oAscFill.FILL_TYPE_NOFILL:t=this.cmbFillSrc.getStore().getAt(4)}t&&(this.cmbFillSrc.select(t),this.cmbFillSrc.fireEvent("select",this.cmbFillSrc,[t])),this._state.FillType=this.OriginalFillType}this._btnTexture.setText(this.textSelectTexture);var d=typeof this.ShapeColor.Color,v=typeof this._state.ShapeColor;if(d!==v||d=="object"&&(this.ShapeColor.Color.effectValue!==this._state.ShapeColor.effectValue||this._state.ShapeColor.color.indexOf(this.ShapeColor.Color.color)<0)||d!="object"&&this._state.ShapeColor.indexOf(this.ShapeColor.Color)<0){this._btnBackColor.setColor(this.ShapeColor.Color);if(typeof this.ShapeColor.Color=="object"){for(var m=0;m<10;m++)if(this.ThemeValues[m]==this.ShapeColor.Color.effectValue){this.colorsBack.select(this.ShapeColor.Color,!1);break}}else this.colorsBack.select(this.ShapeColor.Color,!1);this._state.ShapeColor=this.ShapeColor.Color}var g=e.get_stroke(),y=g.get_type();g?y==c_oAscStrokeType.STROKE_COLOR?(i=g.get_color(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.BorderColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.BorderColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.BorderColor={Value:1,Color:"transparent"}):this.BorderColor={Value:1,Color:"transparent"}:(y=null,this.BorderColor={Value:0,Color:"transparent"}),d=typeof this.BorderColor.Color,v=typeof this._state.StrokeColor;if(d!==v||d=="object"&&(this.BorderColor.Color.effectValue!==this._state.StrokeColor.effectValue||this._state.StrokeColor.color.indexOf(this.BorderColor.Color.color)<0)||d!="object"&&(this._state.StrokeColor.indexOf(this.BorderColor.Color)<0||typeof this._btnBorderColor.color=="object")){this._btnBorderColor.setColor(this.BorderColor.Color);if(typeof this.BorderColor.Color=="object"){for(var m=0;m<10;m++)if(this.ThemeValues[m]==this.BorderColor.Color.effectValue){this.colorsBorder.select(this.BorderColor.Color,!1);break}}else this.colorsBorder.select(this.BorderColor.Color,!1);this._state.StrokeColor=this.BorderColor.Color}if(this._state.StrokeType!==y||y==c_oAscStrokeType.STROKE_COLOR){if(y==c_oAscStrokeType.STROKE_COLOR){var b=g.get_width();if(Math.abs(this._state.StrokeWidth-b)>.001||(this._state.StrokeWidth===null||b===null)&&this._state.StrokeWidth!==b){this._state.StrokeWidth=b;var l=-1;b!==null&&(b=this._mm2pt(b),Ext.each(this.cmbBorderSize.getStore().data.items,function(e,t){if(b<e.data.value+.01&&b>e.data.value-.01)return l=t,!1})),l>-1?(t=this.cmbBorderSize.getStore().getAt(l),this.cmbBorderSize.select(t),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t])):(t={borderstyle:"",text:"",value:b,offsety:-1},t=this.cmbBorderSize.getStore().add(t),this.cmbBorderSize.select(t[0]),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t[0]]),this.cmbBorderSize.getStore().remove(t[0]))}}else y==c_oAscStrokeType.STROKE_NONE?(this._state.StrokeWidth=0,t=this.cmbBorderSize.getStore().getAt(0),this.cmbBorderSize.select(t),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t])):(this._state.StrokeWidth=null,t={borderstyle:"",text:"",value:-1,offsety:-1},t=this.cmbBorderSize.getStore().add(t),this.cmbBorderSize.select(t[0]),this.cmbBorderSize.fireEvent("select",this.cmbBorderSize,[t[0]]),this.cmbBorderSize.getStore().remove(t[0]));this._state.StrokeType=y}d=typeof this.FGColor.Color,v=typeof this._state.FGColor;if(d!==v||d=="object"&&(this.FGColor.Color.effectValue!==this._state.FGColor.effectValue||this._state.FGColor.color.indexOf(this.FGColor.Color.color)<0)||d!="object"&&this._state.FGColor.indexOf(this.FGColor.Color)<0){this._btnFGColor.setColor(this.FGColor.Color);if(typeof this.FGColor.Color=="object"){for(var m=0;m<10;m++)if(this.ThemeValues[m]==this.FGColor.Color.effectValue){this.colorsFG.select(this.FGColor.Color,!1);break}}else this.colorsFG.select(this.FGColor.Color,!1);this._state.FGColor=this.FGColor.Color}d=typeof this.BGColor.Color,v=typeof this._state.BGColor;if(d!==v||d=="object"&&(this.BGColor.Color.effectValue!==this._state.BGColor.effectValue||this._state.BGColor.color.indexOf(this.BGColor.Color.color)<0)||d!="object"&&this._state.BGColor.indexOf(this.BGColor.Color)<0){this._btnBGColor.setColor(this.BGColor.Color);if(typeof this.BGColor.Color=="object"){for(var m=0;m<10;m++)if(this.ThemeValues[m]==this.BGColor.Color.effectValue){this.colorsBG.select(this.BGColor.Color,!1);break}}else this.colorsBG.select(this.BGColor.Color,!1);this._state.BGColor=this.BGColor.Color}i=this.GradColor.colors[this.GradColor.currentIdx],d=typeof i,v=typeof this._state.GradColor;if(d!==v||d=="object"&&(i.effectValue!==this._state.GradColor.effectValue||this._state.GradColor.color.indexOf(i.color)<0)||d!="object"&&this._state.GradColor.indexOf(i)<0){this._btnGradColor.setColor(i);if(typeof i=="object"){for(var m=0;m<10;m++)if(this.ThemeValues[m]==i.effectValue){this.colorsGrad.select(i,!1);break}}else this.colorsGrad.select(i,!1);this._state.GradColor=i}this._noApply=!1,this.ResumeEvents()}},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this._initSettings||(this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t),this.colorsFG.updateColors(e,t),this.colorsBG.updateColors(e,t),this.colorsGrad.updateColors(e,t))},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Shape==i){n=Ext.create("PE.view.ShapeSettingsAdvanced",{}),n.updateMetricUnit(),n.setSettings(s);break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,t,n){t==1&&n&&this.api.ShapeApply(n),this.fireEvent("editcomplete",this)},this),!1),n.show())},_onInitStandartTextures:function(e){var t=this;if(!Ext.isEmpty(e)){var n=this.textureMenu.picker.store;if(n){if(n.count()>0)return;var r=[];Ext.each(e,function(e){r.push({imageUrl:e.get_image(),name:t.textureNames[e.get_id()],data:{type:e.get_id()}})}),n.add(r)}}},_arrangeSlideItems:function(){if(!this.needArrangeSlideItems)return;var e=this;if(this.getEl()){var t=this.getEl().down(".jspPane");if(t&&t.getHeight()>0&&this.getEl().getHeight()>0)var n=0,r=setInterval(function(){e.needArrangeSlideItems&&e.resizeSlideItems();if(!e.needArrangeSlideItems){clearInterval(r),e.doLayout();return}n++>5&&clearInterval(r)},100)}},_resizeSlideItems:function(){var e=5,t="div.thumb-wrap",n=this.getEl(),r=n.query(t),i=0;while(i<r.length){var s=0;for(var o=i;o<i+e;o++){if(o>=r.length)break;var u=Ext.get(r[o]),a=u.getHeight();if(a<28)return;a<s?u.setHeight(s):s=a}i+=e}r.length>0&&(this.needArrangeSlideItems=!1)},hideMenus:function(){this._btnBorderColor.hideMenu(),this._btnBackColor.hideMenu(),this._btnTexture.hideMenu(),this._btnChangeShape.hideMenu(),this._btnBGColor.hideMenu(),this._btnFGColor.hideMenu(),this._cmbPattern.dataMenu.hide(),this.btnDirection.hideMenu(),this._btnGradColor.hideMenu()},createDelayedElements:function(){var e=[0,1,3,2,4,53,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,22,23,24,25,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,49,50,51,52];this.patternViewData=[];for(var t=0;t<13;t++)for(var n=0;n<4;n++){var r=t*4+n;this.patternViewData[r]={offsetx:n*28,offsety:t*28,data:{type:e[r]}}}this.patternViewData.splice(this.patternViewData.length-2,2);for(var t=0;t<this.patternViewData.length;t++)this.patternViewData[t].imageCls="item-combo-pattern",this.patternViewData[t].imageStyle=Ext.String.format("background-position: {0}px {1}px;",-this.patternViewData[t].offsetx,-this.patternViewData[t].offsety),this.patternViewData[t].uid=Ext.id();this._cmbPattern.dataMenu.picker.store.loadData(this.patternViewData),this.FillAutoShapes(),this.effectcolors&&this.standartcolors&&(this.colorsBorder.updateColors(this.effectcolors,this.standartcolors),this.colorsBack.updateColors(this.effectcolors,this.standartcolors),this.colorsFG.updateColors(this.effectcolors,this.standartcolors),this.colorsBG.updateColors(this.effectcolors,this.standartcolors),this.colorsGrad.updateColors(this.effectcolors,this.standartcolors))},disableFillPanels:function(e){this._state.DisabledFillPanels!==e&&(this._state.DisabledFillPanels=e,this._FillPanel.setDisabled(e),this._FillColorContainer.setDisabled(e),this._FillImageContainer.setDisabled(e),this._PatternContainer.setDisabled(e),this._GradientContainer.setDisabled(e),this._TransparencyContainer.setDisabled(e))},txtTitle:"Autoshape",txtNoBorders:"No Line",strStroke:"Stroke",strColor:"Color",strSize:"Size",strChange:"Change Autoshape",strFill:"Fill",textColor:"Color Fill",textImageTexture:"Picture or Texture",textTexture:"From Texture",textFromUrl:"From URL",textFromFile:"From File",textStretch:"Stretch",textTile:"Tile",txtCanvas:"Canvas",txtCarton:"Carton",txtDarkFabric:"Dark Fabric",txtGrain:"Grain",txtGranite:"Granite",txtGreyPaper:"Grey Paper",txtKnit:"Knit",txtLeather:"Leather",txtBrownPaper:"Brown Paper",txtPapyrus:"Papyrus",txtWood:"Wood",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textAdvanced:"Show advanced settings",strTransparency:"Opacity",textNoFill:"No Fill",textSelectTexture:"Select",textGradientFill:"Gradient Fill",textPatternFill:"Pattern",strBackground:"Background color",strForeground:"Foreground color",strPattern:"Pattern",textEmptyPattern:"No Pattern",textLinear:"Linear",textRadial:"Radial",textDirection:"Direction",textStyle:"Style",textGradient:"Gradient"}),Ext.define("PE.view.SlideSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.peslidesettings",height:347,requires:["Ext.button.Button","Ext.form.Label","Ext.form.field.ComboBox","Ext.container.Container","Ext.toolbar.Spacer","Ext.Array","Ext.menu.Menu","Ext.menu.Manager","Ext.XTemplate","Ext.Img","Ext.slider.Single","Common.component.DataViewPicker","Common.component.MetricSpinner","Common.view.ImageFromUrlDialog","Common.component.ThemeColorPalette","Common.component.IndeterminateCheckBox","Common.component.ComboDataView","Common.component.MultiSliderGradient"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0;var e=this;this._originalProps=null,this._noApply=!0,this._sendUndoPoint=!0,this._stateDisabled={background:!1,effects:!1,timing:!1},this._state={FillType:c_oAscFill.FILL_TYPE_SOLID,SlideColor:"ffffff",BlipFillType:c_oAscFillBlipType.STRETCH,FGColor:"000000",BGColor:"ffffff",GradColor:"000000",GradFillType:c_oAscFillGradType.GRAD_LINEAR},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID,this.SlideColor={Value:1,Color:"ffffff"},this.BlipFillType=c_oAscFillBlipType.STRETCH,this.Effect=c_oAscSlideTransitionTypes.None,this.EffectType=undefined,this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.GradColor={values:[0,100],colors:["000000","ffffff"],currentIdx:0},this.GradLinearDirectionIdx=3,this.GradRadialDirectionIdx=0,this.PatternFillType=0,this.FGColor={Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.textureNames=[this.txtCanvas,this.txtCarton,this.txtDarkFabric,this.txtGrain,this.txtGranite,this.txtGreyPaper,this.txtKnit,this.txtLeather,this.txtBrownPaper,this.txtPapyrus,this.txtWood],this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this._btnBackColor=Ext.create("Ext.button.Button",{id:"slide-button-back-color",arrowCls:"",width:45,height:22,color:"ffffff",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll();var r,i;t=="transparent"?(this._btnBackColor.color="transparent",r="transparent",i="1px solid #BEBEBE"):(this._btnBackColor.color=t,r=Ext.String.format("#{0}",typeof t=="object"?t.color:t),i="none"),this._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBackColor.btnEl,{"background-color":r,border:i}),this.SlideColor={Value:1,Color:this._btnBackColor.color};if(this.api){var s=new CAscSlideProps,o=new CAscFill;this.SlideColor.Color=="transparent"?(o.put_type(c_oAscFill.FILL_TYPE_NOFILL),o.put_fill(null)):(o.put_type(c_oAscFill.FILL_TYPE_SOLID),o.put_fill(new CAscFillSolid),o.get_fill().put_color(this.getRgbColor(this.SlideColor.Color))),s.put_background(o),this.api.SetSlideProps(s)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this._arrFillSrc=[this.textColor,this.textGradientFill,this.textImageTexture,this.textPatternFill,this.textNoFill],this.cmbFillSrc=Ext.create("Ext.form.field.ComboBox",{id:"slide-combo-fill-src",width:190,editable:!1,store:this._arrFillSrc,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this._ShowHideElem([t[0].index==0,t[0].index==2,t[0].index==3,t[0].index==1],[this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer],[this._FillColorContainerHeight,this._FillImageContainerHeight,this._PatternContainerHeight,this._GradientContainerHeight]);switch(t[0].index){case 0:this._state.FillType=c_oAscFill.FILL_TYPE_SOLID;if(!this._noApply){var r=new CAscSlideProps,i=new CAscFill;this.SlideColor.Color=="transparent"?(i.put_type(c_oAscFill.FILL_TYPE_NOFILL),i.put_fill(null)):(i.put_type(c_oAscFill.FILL_TYPE_SOLID),i.put_fill(new CAscFillSolid),i.get_fill().put_color(this.getRgbColor(this.SlideColor.Color))),r.put_background(i),this.api.SetSlideProps(r)}break;case 1:this._state.FillType=c_oAscFill.FILL_TYPE_GRAD;if(!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(s[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),r.put_background(i),this.api.SetSlideProps(r)}break;case 2:this._state.FillType=c_oAscFill.FILL_TYPE_BLIP;break;case 3:this._state.FillType=c_oAscFill.FILL_TYPE_PATT;if(!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color)),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color)),r.put_background(i),this.api.SetSlideProps(r)}break;case 4:this._state.FillType=c_oAscFill.FILL_TYPE_NOFILL;if(!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_NOFILL),i.put_fill(null),r.put_background(i),this.api.SetSlideProps(r)}}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillSrc.setValue(this._arrFillSrc[0]),this._FillColorContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:25,width:190,items:[this._btnBackColor]}),this._FillColorContainerHeight=this._FillColorContainer.height,this._btnInsertFromFile=Ext.create("Ext.Button",{id:"slide-button-fill-from-file",text:this.textFromFile,width:90,listeners:{click:function(e){this.api&&this.api.ChangeSlideImageFromFile(),this.fireEvent("editcomplete",this)},scope:this}}),this._btnInsertFromUrl=Ext.create("Ext.Button",{id:"slide-button-fill-from-url",text:this.textFromUrl,width:90,listeners:{click:function(e){var t=Ext.create("Common.view.ImageFromUrlDialog");t.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,t]),!1),t.addListener("close",Ext.bind(function(e,t){this.fireEvent("editcomplete",this)},this)),t.show()},scope:this}}),this._arrFillType=[this.textStretch,this.textTile],this.cmbFillType=Ext.create("Ext.form.field.ComboBox",{id:"slide-combo-fill-type",width:90,editable:!1,store:this._arrFillType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?this.BlipFillType=c_oAscFillBlipType.STRETCH:t[0].index==1&&(this.BlipFillType=c_oAscFillBlipType.TILE);if(this.api&&this._fromTextureCmb!==!0&&this.OriginalFillType==c_oAscFill.FILL_TYPE_BLIP){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_BLIP),i.put_fill(new CAscFillBlip),i.get_fill().put_type(this.BlipFillType),r.put_background(i),this.api.SetSlideProps(r)}this.fireEvent("editcomplete",this)},this)}}),this.cmbFillType.setValue(this._arrFillType[0]),this.controls.push(this.cmbFillType),this._btnTexture=Ext.create("Ext.button.Button",{text:this.textSelectTexture,width:90,cls:"btn-combo-style",pressedCls:"",textAlign:"left",menu:this.textureMenu=Ext.create("Common.component.MenuDataViewPicker",{width:242,height:182,cls:"texture-view",viewData:[],contentWidth:222,listeners:{select:Ext.bind(function(e,t){this._fromTextureCmb=!0,this.cmbFillType.setValue(this._arrFillType[1]),this._fromTextureCmb=!1;if(this.api){var n=new CAscSlideProps,r=new CAscFill;r.put_type(c_oAscFill.FILL_TYPE_BLIP),r.put_fill(new CAscFillBlip),r.get_fill().put_type(c_oAscFillBlipType.TILE),r.get_fill().put_texture_id(t.data.data.type),n.put_background(r),this.api.SetSlideProps(n)}this._btnTexture.setText(t.data.name),this.fireEvent("editcomplete",this)},this),hide:function(){e.fireEvent("editcomplete",e)},show:function(e){e.picker.selectByIndex(-1,!1)}}})}),this.controls.push(this._btnTexture),this.textureImage=Ext.create("Ext.container.Container",{id:"slide-texture-img",width:50,height:50}),this._FillImageContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:120,width:190,hidden:!0,items:[{xtype:"container",layout:"hbox",width:190,items:[this._btnInsertFromFile,{xtype:"tbspacer",flex:1},this._btnInsertFromUrl]},{xtype:"tbspacer",height:11},{xtype:"container",layout:"hbox",width:190,height:80,items:[{xtype:"container",layout:"vbox",width:90,height:80,items:[this.cmbFillType,{xtype:"tbspacer",height:15},{xtype:"label",text:this.textTexture},{xtype:"tbspacer",height:2},this._btnTexture]},{xtype:"tbspacer",flex:1},{xtype:"container",cls:"texture-img-container",layout:"vbox",width:90,height:80,items:[this.textureImage]}]}]}),this._FillImageContainerHeight=this._FillImageContainer.height,this._FillPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:45,width:190,items:[{xtype:"label",text:this.strFill,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},this.cmbFillSrc]});var t=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imageStyle}" class="{imageCls}"/>',"</div>","</tpl>");this.patternViewData=[];var n=Ext.create("Ext.data.Store",{storeId:Ext.id(),model:"PE.model.PatternDataModel",data:this.patternViewData});this._cmbPattern=Ext.create("Common.component.ComboDataView",{id:"slide-combo-pattern",width:190,height:42,itemWidth:28,itemHeight:28,menuMaxHeight:300,repeatedselect:!0,store:n,dataTpl:t,viewData:[],emptyComboText:this.textEmptyPattern,listeners:{select:function(t,n){if(e.api&&!e._noApply){e.PatternFillType=n.data.data.type;var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_pattern_type(n.data.data.type),e.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_color_fg(e.getRgbColor(e.FGColor.Color)),i.get_fill().put_color_bg(e.getRgbColor(e.BGColor.Color))),r.put_background(i),e.api.SetSlideProps(r)}e.fireEvent("editcomplete",e)},menuhide:function(){e.fireEvent("editcomplete",e)},releasecapture:function(t){e.fireEvent("editcomplete",e)}}}),this.controls.push(this._cmbPattern),this._cmbPattern.addCls("shape-pattern"),this._cmbPattern.dataMenu.picker.contentWidth=170,this._cmbPattern.dataMenu.picker.needArrangeSlideItems=!0,this._cmbPattern.dataMenu.picker.arrangeItems=this._arrangeSlideItems,this._cmbPattern.dataMenu.picker.resizeSlideItems=this._resizeSlideItems,this._btnFGColor=Ext.create("Ext.button.Button",{id:"slide-button-foreground-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsFG=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnFGColor.color=t,this._btnFGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnFGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.FGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color)),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color))),r.put_background(i),this.api.SetSlideProps(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsFG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsFG),this._btnBGColor=Ext.create("Ext.button.Button",{id:"slide-button-background-color",arrowCls:"",width:45,height:22,color:"ffffff",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsBG=Ext.create("Common.component.ThemeColorPalette",{value:"ffffff",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBGColor.color=t,this._btnBGColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBGColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.BGColor={Value:1,Color:t};if(this.api&&!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_PATT),i.put_fill(new CAscFillHatch),this.OriginalFillType!==c_oAscFill.FILL_TYPE_PATT&&(i.get_fill().put_pattern_type(this.PatternFillType),i.get_fill().put_color_fg(this.getRgbColor(this.FGColor.Color))),i.get_fill().put_color_bg(this.getRgbColor(this.BGColor.Color)),r.put_background(i),this.api.SetSlideProps(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBG.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBG),this._PatternContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:141,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"label",text:this.strPattern},{xtype:"tbspacer",height:2},this._cmbPattern,{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strForeground,flex:1},this._btnFGColor]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,height:27,items:[{xtype:"label",text:this.strBackground,flex:1},this._btnBGColor]}]}),this._PatternContainerHeight=this._PatternContainer.height;var r=Ext.bind(function(e){this._cmbPattern.dataMenu.picker.store.getCount()>0&&(this._cmbPattern.fillComboView(this._cmbPattern.dataMenu.picker.store.getAt(0),!0),this.PatternFillType=this.patternViewData[0].data.type,this._cmbPattern.dataMenu.picker.updateScrollPane(),this._PatternContainer.un("show",r))},this);this._PatternContainer.on("show",r),this._arrGradType=[this.textLinear,this.textRadial],this.cmbGradType=Ext.create("Ext.form.field.ComboBox",{id:"slide-combo-grad-type",width:90,editable:!1,store:this._arrGradType,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){t[0].index==0?(this.GradFillType=c_oAscFillGradType.GRAD_LINEAR,this.btnDirection.menu.picker.store.loadData(s),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(s[this.GradLinearDirectionIdx].iconcls):this.btnDirection.setIconCls("")):t[0].index==1&&(this.GradFillType=c_oAscFillGradType.GRAD_PATH,this.btnDirection.menu.picker.store.loadData(u),this.btnDirection.menu.picker.selectByIndex(this.GradRadialDirectionIdx),this.GradRadialDirectionIdx>=0?this.btnDirection.setIconCls(u[this.GradRadialDirectionIdx].iconcls):this.btnDirection.setIconCls(""));if(this.api&&!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(s[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),r.put_background(i),this.api.SetSlideProps(r)}this.fireEvent("editcomplete",this)},this)}}),this.cmbGradType.setValue(this._arrGradType[0]);var i=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" class="item-gradient"/>',"</div>",'<tpl if="separator">','<div class="gradient-separator"></div>',"</tpl>","</tpl>"),s=[{offsetx:0,offsety:0,data:{type:45,subtype:-1},iconcls:"gradient-subtype gradient-left-top"},{offsetx:50,offsety:0,data:{type:90,subtype:4},iconcls:"gradient-subtype gradient-top"},{offsetx:100,offsety:0,data:{type:135,subtype:5},iconcls:"gradient-subtype gradient-right-top"},{offsetx:0,offsety:50,data:{type:0,subtype:6},iconcls:"gradient-subtype gradient-left",separator:!0},{offsetx:100,offsety:50,data:{type:180,subtype:1},iconcls:"gradient-subtype gradient-right"},{offsetx:0,offsety:100,data:{type:315,subtype:2},iconcls:"gradient-subtype gradient-left-bottom"},{offsetx:50,offsety:100,data:{type:270,subtype:3},iconcls:"gradient-subtype gradient-bottom"},{offsetx:100,offsety:100,data:{type:225,subtype:7},iconcls:"gradient-subtype gradient-right-bottom"}];for(var o=0;o<s.length;o++)s[o].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-s[o].offsetx,-s[o].offsety);var u=[{offsetx:100,offsety:150,data:{type:2,subtype:5},iconcls:"gradient-subtype gradient-radial-center"}];for(var o=0;o<u.length;o++)u[o].imgstyle=Ext.String.format("background-position: {0}px {1}px;",-u[o].offsetx,-u[o].offsety);this.btnDirection=Ext.widget("button",{id:"slide-button-direction",width:72,height:58,cls:"btn-wrap-types",iconCls:"gradient-subtype gradient-left",pressedCls:"disablepressed",menuAlign:"tl-bl?",menu:Ext.create("Common.component.MenuDataViewPicker",{width:195,height:190,minWidth:50,cls:"gradient-view",dataTpl:i,viewData:s,contentWidth:175,listeners:{select:Ext.bind(function(e,t,n,r){this.btnDirection.setIconCls(t.data.iconcls),this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?this.GradLinearDirectionIdx=r:this.GradRadialDirectionIdx=r;if(this.api&&!this._noApply){if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var i=new CAscSlideProps,s=new CAscFill;s.put_type(c_oAscFill.FILL_TYPE_GRAD),s.put_fill(new CAscFillGrad),s.get_fill().put_grad_type(this.GradFillType),s.get_fill().put_linear_angle(t.data.data.type*6e4),s.get_fill().put_linear_scale(!0),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(s.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3]),s.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])])),i.put_background(s),this.api.SetSlideProps(i)}Ext.menu.Manager.hideAll()}this.fireEvent("editcomplete",this)},this),hide:Ext.bind(function(){this.fireEvent("editcomplete",this)},this),beforeshow:Ext.bind(function(e){if(e.rendered){var t=e.getHeight();this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&Math.abs(t-190)>0&&(e.picker.contentWidth=175,e.setSize(195,190)),this.GradFillType==c_oAscFillGradType.GRAD_PATH&&Math.abs(t-70)>0&&(e.picker.contentWidth=50,e.setSize(70,70))}},this)}})}),this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx),this.controls.push(this.btnDirection),this._btnGradColor=Ext.create("Ext.button.Button",{id:"slide-button-gradient-color",arrowCls:"",width:45,height:22,color:"000000",style:"margin-bottom:5px;",menu:{showSeparator:!1,items:[this.colorsGrad=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnGradColor.color=t,this._btnGradColor.btnEl&&Ext.DomHelper.applyStyles(this._btnGradColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)}),this.GradColor.colors[this.GradColor.currentIdx]=t,this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof t=="object"?t.color:t));if(this.api&&!this._noApply){var r=new CAscSlideProps,i=new CAscFill;i.put_type(c_oAscFill.FILL_TYPE_GRAD),i.put_fill(new CAscFillGrad),i.get_fill().put_grad_type(this.GradFillType),i.get_fill().put_colors([this.getRgbColor(this.GradColor.colors[0]),this.getRgbColor(this.GradColor.colors[1])]),this.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(i.get_fill().put_linear_angle(s[this.GradLinearDirectionIdx].data.type*6e4),i.get_fill().put_linear_scale(!0)),i.get_fill().put_positions([this.GradColor.values[0]*1e3,this.GradColor.values[1]*1e3])),r.put_background(i),this.api.SetSlideProps(r)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsGrad.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsGrad);var a=!1,f,l=function(){if(a){var t=new CAscSlideProps,n=new CAscFill;n.put_type(c_oAscFill.FILL_TYPE_GRAD),n.put_fill(new CAscFillGrad),n.get_fill().put_grad_type(e.GradFillType),n.get_fill().put_positions([e.GradColor.values[0]*1e3,e.GradColor.values[1]*1e3]),e.OriginalFillType!==c_oAscFill.FILL_TYPE_GRAD&&(e.GradFillType==c_oAscFillGradType.GRAD_LINEAR&&(n.get_fill().put_linear_angle(s[e.GradLinearDirectionIdx].data.type*6e4),n.get_fill().put_linear_scale(!0)),n.get_fill().put_colors([e.getRgbColor(e.GradColor.colors[0]),e.getRgbColor(e.GradColor.colors[1])])),t.put_background(n),e.api.SetSlideProps(t),a=!1}};this.sldrGradient=Ext.create("Common.component.MultiSliderGradient",{animate:!1,width:140,values:[0,100],increment:1,minValue:0,maxValue:100,useTips:!1,hideLabel:!0,cls:"asc-multi-slider-gradient",listeners:{change:Ext.bind(function(e,t,n){this.GradColor.values=e.getValues(),a=!0,this.api&&!this._noApply&&this._sendUndoPoint&&(this.api.setStartPointHistory(),this._sendUndoPoint=!1,f=setInterval(l,100))},this),changecomplete:Ext.bind(function(e,t,n){clearInterval(f),l(),this.api.setEndPointHistory(),this._sendUndoPoint=!0,Ext.menu.Manager.hideAll()},this),thumbclick:Ext.bind(function(e,t){this.GradColor.currentIdx=t;var n=this.GradColor.colors[this.GradColor.currentIdx];this._btnGradColor.setColor(n),this.colorsGrad.select(n,!1)},this),thumbdblclick:Ext.bind(function(e){this._btnGradColor.showMenu()},this)}}),this.controls.push(this.sldrGradient),this._GradientContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:150,width:190,hidden:!0,items:[{xtype:"tbspacer",height:5},{xtype:"container",layout:"hbox",width:190,items:[{xtype:"container",layout:"vbox",width:100,height:80,items:[{xtype:"label",text:this.textStyle},{xtype:"tbspacer",height:2},this.cmbGradType,{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",flex:1},{xtype:"container",layout:"vbox",height:80,items:[{xtype:"label",text:this.textDirection},{xtype:"tbspacer",height:2},this.btnDirection]}]},{xtype:"tbspacer",height:3},{xtype:"label",text:this.textGradient,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},{xtype:"container",layout:{type:"hbox",align:"top"},width:190,height:35,items:[this.sldrGradient,{xtype:"tbspacer",flex:1},this._btnGradColor]}]}),this._GradientContainerHeight=this._GradientContainer.height,this.fillEffectTypeCombo=function(t){var n=[];switch(t){case c_oAscSlideTransitionTypes.Fade:n.push(e._arrEffectType[0],e._arrEffectType[1]);break;case c_oAscSlideTransitionTypes.Push:n=e._arrEffectType.slice(2,6);break;case c_oAscSlideTransitionTypes.Wipe:n=e._arrEffectType.slice(2,10);break;case c_oAscSlideTransitionTypes.Split:n=e._arrEffectType.slice(10,14);break;case c_oAscSlideTransitionTypes.UnCover:n=e._arrEffectType.slice(2,10);break;case c_oAscSlideTransitionTypes.Cover:n=e._arrEffectType.slice(2,10);break;case c_oAscSlideTransitionTypes.Clock:n=e._arrEffectType.slice(14,17);break;case c_oAscSlideTransitionTypes.Zoom:n=e._arrEffectType.slice(17)}n.length>0?(e.cmbEffectType.getStore().loadData(n),e.cmbEffectType.setValue(n[0][0]),e.EffectType=n[0][0]):(e.cmbEffectType.getStore().removeAll(),e.EffectType=undefined),e.cmbEffectType.setDisabled(n.length<1)},this._arrEffectName=[[c_oAscSlideTransitionTypes.None,this.textNone],[c_oAscSlideTransitionTypes.Fade,this.textFade],[c_oAscSlideTransitionTypes.Push,this.textPush],[c_oAscSlideTransitionTypes.Wipe,this.textWipe],[c_oAscSlideTransitionTypes.Split,this.textSplit],[c_oAscSlideTransitionTypes.UnCover,this.textUnCover],[c_oAscSlideTransitionTypes.Cover,this.textCover],[c_oAscSlideTransitionTypes.Clock,this.textClock],[c_oAscSlideTransitionTypes.Zoom,this.textZoom]],this.cmbEffectName=Ext.create("Ext.form.field.ComboBox",{id:"slide-combo-effect-name",width:190,editable:!1,store:this._arrEffectName,queryMode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){var r=t[0].data.field1;this.Effect!==r&&(this.Effect!==c_oAscSlideTransitionTypes.Wipe&&this.Effect!==c_oAscSlideTransitionTypes.UnCover&&this.Effect!==c_oAscSlideTransitionTypes.Cover||r!==c_oAscSlideTransitionTypes.Wipe&&r!==c_oAscSlideTransitionTypes.UnCover&&r!==c_oAscSlideTransitionTypes.Cover)&&this.fillEffectTypeCombo(r),this.Effect=r;if(this.api&&!this._noApply){var i=new CAscSlideProps,s=new CAscSlideTiming;s.put_TransitionType(r),s.put_TransitionOption(this.EffectType),i.put_timing(s),this.api.SetSlideProps(i)}this.fireEvent("editcomplete",this)},this)}}),this.cmbEffectName.setValue(this._arrEffectName[0][0]),this._arrEffectType=[[c_oAscSlideTransitionParams.Fade_Smoothly,this.textSmoothly],[c_oAscSlideTransitionParams.Fade_Through_Black,this.textBlack],[c_oAscSlideTransitionParams.Param_Left,this.textLeft],[c_oAscSlideTransitionParams.Param_Top,this.textTop],[c_oAscSlideTransitionParams.Param_Right,this.textRight],[c_oAscSlideTransitionParams.Param_Bottom,this.textBottom],[c_oAscSlideTransitionParams.Param_TopLeft,this.textTopLeft],[c_oAscSlideTransitionParams.Param_TopRight,this.textTopRight],[c_oAscSlideTransitionParams.Param_BottomLeft,this.textBottomLeft],[c_oAscSlideTransitionParams.Param_BottomRight,this.textBottomRight],[c_oAscSlideTransitionParams.Split_VerticalIn,this.textVerticalIn],[c_oAscSlideTransitionParams.Split_VerticalOut,this.textVerticalOut],[c_oAscSlideTransitionParams.Split_HorizontalIn,this.textHorizontalIn],[c_oAscSlideTransitionParams.Split_HorizontalOut,this.textHorizontalOut],[c_oAscSlideTransitionParams.Clock_Clockwise,this.textClockwise],[c_oAscSlideTransitionParams.Clock_Counterclockwise,this.textCounterclockwise],[c_oAscSlideTransitionParams.Clock_Wedge,this.textWedge],[c_oAscSlideTransitionParams.Zoom_In,this.textZoomIn],[c_oAscSlideTransitionParams.Zoom_Out,this.textZoomOut],[c_oAscSlideTransitionParams.Zoom_AndRotate,this.textZoomRotate]],this.cmbEffectType=Ext.create("Ext.form.field.ComboBox",{id:"slide-combo-effect-type",width:190,editable:!1,store:[[c_oAscSlideTransitionParams.Fade_Smoothly,this.textSmoothly]],queryMode:"local",triggerAction:"all",disabled:!0,listeners:{select:Ext.bind(function(e,t,n){var r=t[0].data.field1;this.EffectType=r;if(this.api&&!this._noApply){var i=new CAscSlideProps,s=new CAscSlideTiming;s.put_TransitionType(this.Effect),s.put_TransitionOption(this.EffectType),i.put_timing(s),this.api.SetSlideProps(i)}this.fireEvent("editcomplete",this)},this)}}),this.cmbEffectName.setValue(""),this.chStartOnClick=Ext.create("Common.component.IndeterminateCheckBox",{id:"slide-checkbox-start-click",boxLabel:this.strStartOnClick,colspan:2,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api&&!this._noApply){var i=new CAscSlideProps,s=new CAscSlideTiming;s.put_SlideAdvanceOnMouseClick(e.getValue()=="checked"),i.put_timing(s),this.api.SetSlideProps(i)}this.fireEvent("editcomplete",this)},this)}}),this.chDelay=Ext.create("Common.component.IndeterminateCheckBox",{id:"slide-checkbox-delay",boxLabel:this.strDelay,listeners:{change:Ext.bind(function(e,t,n,r){this.numDelay.setDisabled(e.getValue()!=="checked");if(this.api&&!this._noApply){var i=new CAscSlideProps,s=new CAscSlideTiming;s.put_SlideAdvanceAfter(e.getValue()=="checked"),i.put_timing(s),this.api.SetSlideProps(i)}this.fireEvent("editcomplete",this)},this)}}),this.numDuration=Ext.create("Common.component.MetricSpinner",{id:"slide-duration",readOnly:!1,step:1,width:65,defaultUnit:"s",value:"2 s",maxValue:300,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api&&!this._noApply){var i=new CAscSlideProps,s=new CAscSlideTiming;s.put_TransitionDuration(e.getNumberValue()*1e3),i.put_timing(s),this.api.SetSlideProps(i)}this.fireEvent("editcomplete",this)},this)}}),this.numDelay=Ext.create("Common.component.MetricSpinner",{id:"slide-delay",readOnly:!1,step:1,width:70,defaultUnit:"s",value:"2 s",maxValue:300,minValue:0,disabled:!0,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api&&!this._noApply){var i=new CAscSlideProps,s=new CAscSlideTiming;s.put_SlideAdvanceDuration(e.getNumberValue()*1e3),i.put_timing(s),this.api.SetSlideProps(i)}this.fireEvent("editcomplete",this)},this)}}),this.btnPreview=Ext.create("Ext.Button",{id:"slide-button-preview",text:this.textPreview,width:70,listeners:{click:function(e,t,n,r){this.api&&this.api.SlideTransitionPlay(),this.fireEvent("editcomplete",this)},scope:this}}),this.btnApplyToAll=Ext.create("Ext.Button",{id:"slide-button-apply-all",text:this.textApplyAll,width:190,listeners:{click:function(e,t,n,r){this.api&&this.api.SlideTimingApplyToAll(),this.fireEvent("editcomplete",this)},scope:this}}),this._TransitionPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:250,width:190,items:[{xtype:"label",text:this.strEffect,style:"margin-top: 1px;font-weight: bold;"},{xtype:"tbspacer",height:7},this.cmbEffectName,{xtype:"tbspacer",height:7},this.cmbEffectType,{xtype:"tbspacer",height:7},{xtype:"container",width:190,layout:{type:"table",columns:2},items:[{xtype:"container",layout:{type:"hbox",align:"middle"},width:120,items:[{xtype:"label",text:this.strDuration},{xtype:"tbspacer",width:5},this.numDuration]},this.btnPreview,{xtype:"tbspacer",height:10,colspan:2},{xtype:"tbspacer",width:190,height:10,colspan:2,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this.chStartOnClick,{xtype:"tbspacer",height:5,colspan:2},this.chDelay,this.numDelay]},{xtype:"tbspacer",height:7},{xtype:"tbspacer",width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},this.btnApplyToAll]}),this.items=[{xtype:"tbspacer",height:7},this._FillPanel,{xtype:"tbspacer",height:7},this._FillColorContainer,this._FillImageContainer,this._PatternContainer,this._GradientContainer,{xtype:"tbspacer",height:7},this._TransitionPanel],this.addEvents("editcomplete"),this.callParent(arguments)},setApi:function(e){this.api=e;if(this.api){this.api.SetInterfaceDrawImagePlaceSlide("slide-texture-img");var t=this.api.get_PropertyStandartTextures();t&&this._onInitStandartTextures(t)}},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},colorValue2EffectId:function(e){if(typeof e=="object"&&e.effectValue!==undefined&&this.effectcolors){var t=e.effectValue;for(var n=0;n<this.effectcolors.length;n++)if(this.effectcolors[n].effectValue===e.effectValue&&e.color.toUpperCase()===this.effectcolors[n].color.toUpperCase()){e.effectId=this.effectcolors[n].effectId;break}}return e},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");if(r!=""&&t.BlipFillType!==null){var i=new CAscSlideProps,s=new CAscFill;s.put_type(c_oAscFill.FILL_TYPE_BLIP),s.put_fill(new CAscFillBlip),s.get_fill().put_type(t.BlipFillType),s.get_fill().put_url(n.value),i.put_background(s),t.api.SetSlideProps(i)}}},_ShowHideElem:function(e,t,n){var r=this.getHeight(),i=0;for(var s=0;s<e.length;s++)e[s]&&!t[s].isVisible()&&(t[s].show(),i+=n[s]),!e[s]&&t[s].isVisible()&&(i-=n[s],t[s].hide());this.setHeight(r+i),this.initialHeight=r+i,this.ownerCt.setHeight(this.initialHeight)},ChangeSettings:function(e){this._initSettings&&this.createDelayedElements(),this._initSettings=!1;if(e){this._originalProps=e,this.SuspendEvents(),this._noApply=!0;var t=null,n=e.get_background(),r=n.get_type(),i=null;if(n===null||r===null||r==c_oAscFill.FILL_TYPE_NOFILL)this.OriginalFillType=c_oAscFill.FILL_TYPE_NOFILL;else if(r==c_oAscFill.FILL_TYPE_SOLID)n=n.get_fill(),i=n.get_color(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.SlideColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.SlideColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.SlideColor={Value:0,Color:"transparent"},this.FGColor=this.SlideColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.SlideColor.Color)}:{Value:1,Color:"000000"},this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_SOLID;else if(r==c_oAscFill.FILL_TYPE_BLIP)n=n.get_fill(),this.BlipFillType=n.get_type(),this.BlipFillType==c_oAscFillBlipType.STRETCH?this.cmbFillType.setValue(this._arrFillType[0]):this.BlipFillType==c_oAscFillBlipType.TILE?this.cmbFillType.setValue(this._arrFillType[1]):this.cmbFillType.setValue(""),this.OriginalFillType=c_oAscFill.FILL_TYPE_BLIP;else if(r==c_oAscFill.FILL_TYPE_PATT){n=n.get_fill(),this.PatternFillType=n.get_pattern_type();if(this._state.PatternFillType!==this.PatternFillType){var s=this._cmbPattern.dataMenu.picker.store.findBy(function(e,t){return e.data.data.type===this.PatternFillType},this);this._cmbPattern.selectByIndex(s),this._state.PatternFillType=this.PatternFillType}i=n.get_color_fg(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.FGColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.FGColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.FGColor={Value:1,Color:"000000"},i=n.get_color_bg(),i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.BGColor={Value:1,Color:{color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()}}:this.BGColor={Value:1,Color:this.getHexColor(i.get_r(),i.get_g(),i.get_b())}:this.BGColor={Value:1,Color:"ffffff"},this.OriginalFillType=c_oAscFill.FILL_TYPE_PATT,this.SlideColor=this.FGColor.Color!=="transparent"?{Value:1,Color:this.colorValue2EffectId(this.FGColor.Color)}:{Value:1,Color:"ffffff"}}else if(r==c_oAscFill.FILL_TYPE_GRAD){n=n.get_fill(),this.GradFillType=n.get_grad_type(),this._state.GradFillType!==this.GradFillType&&(t=undefined,this.GradFillType==c_oAscFillGradType.GRAD_LINEAR?t=this.cmbGradType.getStore().getAt(0):this.GradFillType==c_oAscFillGradType.GRAD_PATH?t=this.cmbGradType.getStore().getAt(1):(this.cmbGradType.setValue(""),this.btnDirection.setIconCls("")),t&&(this.cmbGradType.select(t),this.cmbGradType.fireEvent("select",this.cmbGradType,[t])),this._state.GradFillType=this.GradFillType);if(this.GradFillType==c_oAscFillGradType.GRAD_LINEAR){var o=Math.floor(n.get_linear_angle()/6e4),u,a=this.btnDirection.menu.picker.store.findBy(function(e,t){return u=e.data.iconcls,e.data.data.type===o},this);a!==this.GradLinearDirectionIdx&&(this.GradLinearDirectionIdx=a,this.btnDirection.menu.picker.selectByIndex(this.GradLinearDirectionIdx,!1),this.GradLinearDirectionIdx>=0?this.btnDirection.setIconCls(u):this.btnDirection.setIconCls(""))}var f=n.get_colors();f&&f.length>0&&(i=f[0],i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[0]={color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()},this.colorValue2EffectId(this.GradColor.colors[0])):this.GradColor.colors[0]=this.getHexColor(i.get_r(),i.get_g(),i.get_b()):this.GradColor.colors[0]="000000",i=f[1],i?i.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?(this.GradColor.colors[1]={color:this.getHexColor(i.get_r(),i.get_g(),i.get_b()),effectValue:i.get_value()},this.colorValue2EffectId(this.GradColor.colors[1])):this.GradColor.colors[1]=this.getHexColor(i.get_r(),i.get_g(),i.get_b()):this.GradColor.colors[1]="ffffff");var l=n.get_positions();if(l&&l.length>0){var c=l[0];c!==null&&(c/=1e3,this.GradColor.values[0]=c),c=l[1],c!==null&&(c/=1e3,this.GradColor.values[1]=c)}this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[0]=="object"?this.GradColor.colors[0].color:this.GradColor.colors[0]),0),this.sldrGradient.setColorValue(Ext.String.format("#{0}",typeof this.GradColor.colors[1]=="object"?this.GradColor.colors[1].color:this.GradColor.colors[1]),1),this.sldrGradient.setValue(0,this.GradColor.values[0]),this.sldrGradient.setValue(1,this.GradColor.values[1]),this.OriginalFillType=c_oAscFill.FILL_TYPE_GRAD}if(this._state.FillType!==this.OriginalFillType){switch(this.OriginalFillType){case c_oAscFill.FILL_TYPE_SOLID:t=this.cmbFillSrc.getStore().getAt(0);break;case c_oAscFill.FILL_TYPE_GRAD:t=this.cmbFillSrc.getStore().getAt(1);break;case c_oAscFill.FILL_TYPE_BLIP:t=this.cmbFillSrc.getStore().getAt(2);break;case c_oAscFill.FILL_TYPE_PATT:t=this.cmbFillSrc.getStore().getAt(3);break;case c_oAscFill.FILL_TYPE_NOFILL:t=this.cmbFillSrc.getStore().getAt(4)}t&&(this.cmbFillSrc.select(t),this.cmbFillSrc.fireEvent("select",this.cmbFillSrc,[t])),this._state.FillType=this.OriginalFillType}this._btnTexture.setText(this.textSelectTexture);var h=typeof this.SlideColor.Color,p=typeof this._state.SlideColor;if(h!==p||h=="object"&&(this.SlideColor.Color.effectValue!==this._state.SlideColor.effectValue||this._state.SlideColor.color.indexOf(this.SlideColor.Color.color)<0)||h!="object"&&this._state.SlideColor.indexOf(this.SlideColor.Color)<0){this._btnBackColor.setColor(this.SlideColor.Color);if(typeof this.SlideColor.Color=="object"){for(var d=0;d<10;d++)if(this.ThemeValues[d]==this.SlideColor.Color.effectValue){this.colorsBack.select(this.SlideColor.Color,!1);break}}else this.colorsBack.select(this.SlideColor.Color,!1);this._state.SlideColor=this.SlideColor.Color}var v=e.get_timing();if(v){var o=v.get_TransitionType(),m=!1;if(this._state.Effect!==o){for(var d=0;d<this._arrEffectName.length;d++)if(o===this._arrEffectName[d][0]){this.cmbEffectName.setValue(this._arrEffectName[d][0]),m=!0;break}m||this.cmbEffectName.setValue(""),this.fillEffectTypeCombo(m?o:undefined),this.Effect=o,this._state.Effect=o}o=v.get_TransitionOption();if(this._state.EffectType!==o||m){m=!1;for(var d=0;d<this._arrEffectType.length;d++)if(o===this._arrEffectType[d][0]){this.cmbEffectType.setValue(this._arrEffectType[d][0]),m=!0;break}m||this.cmbEffectType.setValue(""),this._state.EffectType=o}o=v.get_TransitionDuration();if(Math.abs(this._state.Duration-o)>.001||(this._state.Duration===null||o===null)&&this._state.Duration!==o||(this._state.Duration===undefined||o===undefined)&&this._state.Duration!==o)this.numDuration.setValue(o!==null&&o!==undefined?o/1e3:""),this._state.Duration=o;o=v.get_SlideAdvanceDuration();if(Math.abs(this._state.Delay-o)>.001||(this._state.Delay===null||o===null)&&this._state.Delay!==o||(this._state.Delay===undefined||o===undefined)&&this._state.Delay!==o)this.numDelay.setValue(o!==null&&o!==undefined?o/1e3:""),this._state.Delay=o;o=v.get_SlideAdvanceOnMouseClick(),this._state.OnMouseClick!==o&&(this.chStartOnClick.setValue(o!==null&&o!==undefined?o:"indeterminate"),this._state.OnMouseClick=o),o=v.get_SlideAdvanceAfter(),this._state.AdvanceAfter!==o&&(this.chDelay.setValue(o!==null&&o!==undefined?o:"indeterminate"),this._state.AdvanceAfter=o)}h=typeof this.FGColor.Color,p=typeof this._state.FGColor;if(h!==p||h=="object"&&(this.FGColor.Color.effectValue!==this._state.FGColor.effectValue||this._state.FGColor.color.indexOf(this.FGColor.Color.color)<0)||h!="object"&&this._state.FGColor.indexOf(this.FGColor.Color)<0){this._btnFGColor.setColor(this.FGColor.Color);if(typeof this.FGColor.Color=="object"){for(var d=0;d<10;d++)if(this.ThemeValues[d]==this.FGColor.Color.effectValue){this.colorsFG.select(this.FGColor.Color,!1);break}}else this.colorsFG.select(this.FGColor.Color,!1);this._state.FGColor=this.FGColor.Color}h=typeof this.BGColor.Color,p=typeof this._state.BGColor;if(h!==p||h=="object"&&(this.BGColor.Color.effectValue!==this._state.BGColor.effectValue||this._state.BGColor.color.indexOf(this.BGColor.Color.color)<0)||h!="object"&&this._state.BGColor.indexOf(this.BGColor.Color)<0){this._btnBGColor.setColor(this.BGColor.Color);if(typeof this.BGColor.Color=="object"){for(var d=0;d<10;d++)if(this.ThemeValues[d]==this.BGColor.Color.effectValue){this.colorsBG.select(this.BGColor.Color,!1);break}}else this.colorsBG.select(this.BGColor.Color,!1);this._state.BGColor=this.BGColor.Color}i=this.GradColor.colors[this.GradColor.currentIdx],h=typeof i,p=typeof this._state.GradColor;if(h!==p||h=="object"&&(i.effectValue!==this._state.GradColor.effectValue||this._state.GradColor.color.indexOf(i.color)<0)||h!="object"&&this._state.GradColor.indexOf(i)<0){this._btnGradColor.setColor(i);if(typeof i=="object"){for(var d=0;d<10;d++)if(this.ThemeValues[d]==i.effectValue){this.colorsGrad.select(i,!1);break}}else this.colorsGrad.select(i,!1);this._state.GradColor=i}this._noApply=!1,this.ResumeEvents()}},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this._initSettings||(this.colorsBack.updateColors(e,t),this.colorsFG.updateColors(e,t),this.colorsBG.updateColors(e,t),this.colorsGrad.updateColors(e,t))},_onInitStandartTextures:function(e){var t=this;if(!Ext.isEmpty(e)){var n=this.textureMenu.picker.store;if(n){if(n.count()>0)return;var r=[];Ext.each(e,function(e){r.push({imageUrl:e.get_image(),name:t.textureNames[e.get_id()],data:{type:e.get_id()}})}),n.add(r)}}},_arrangeSlideItems:function(){if(!this.needArrangeSlideItems)return;var e=this;if(this.getEl()){var t=this.getEl().down(".jspPane");if(t&&t.getHeight()>0&&this.getEl().getHeight()>0)var n=0,r=setInterval(function(){e.needArrangeSlideItems&&e.resizeSlideItems();if(!e.needArrangeSlideItems){clearInterval(r),e.doLayout();return}n++>5&&clearInterval(r)},100)}},_resizeSlideItems:function(){var e=5,t="div.thumb-wrap",n=this.getEl(),r=n.query(t),i=0;while(i<r.length){var s=0;for(var o=i;o<i+e;o++){if(o>=r.length)break;var u=Ext.get(r[o]),a=u.getHeight();if(a<28)return;a<s?u.setHeight(s):s=a}i+=e}r.length>0&&(this.needArrangeSlideItems=!1)},hideMenus:function(){this._btnBackColor.hideMenu(),this._btnTexture.hideMenu(),this._btnBGColor.hideMenu(),this._btnFGColor.hideMenu(),this._cmbPattern.dataMenu.hide(),this.btnDirection.hideMenu(),this._btnGradColor.hideMenu()},setSlideDisabled:function(e,t,n){e!==this._stateDisabled.background&&(this.cmbFillSrc.setDisabled(e),this._FillColorContainer.setDisabled(e),this._FillImageContainer.setDisabled(e),this._PatternContainer.setDisabled(e),this._GradientContainer.setDisabled(e),this._stateDisabled.background=e),t!==this._stateDisabled.effects&&(this.cmbEffectName.setDisabled(t),this.cmbEffectType.setDisabled(t),this.numDuration.setDisabled(t),this.btnPreview.setDisabled(t),this._stateDisabled.effects=t),n!==this._stateDisabled.timing&&(this.chStartOnClick.setDisabled(n),this.chDelay.setDisabled(n),this.numDelay.setDisabled(n),this.btnApplyToAll.setDisabled(n),this._stateDisabled.timing=n)},createDelayedElements:function(){var e=[0,1,3,2,4,53,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,22,23,24,25,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,49,50,51,52];this.patternViewData=[];for(var t=0;t<13;t++)for(var n=0;n<4;n++){var r=t*4+n;this.patternViewData[r]={offsetx:n*28,offsety:t*28,data:{type:e[r]}}}this.patternViewData.splice(this.patternViewData.length-2,2);for(var t=0;t<this.patternViewData.length;t++)this.patternViewData[t].imageCls="item-combo-pattern",this.patternViewData[t].imageStyle=Ext.String.format("background-position: {0}px {1}px;",-this.patternViewData[t].offsetx,-this.patternViewData[t].offsety),this.patternViewData[t].uid=Ext.id();this._cmbPattern.dataMenu.picker.store.loadData(this.patternViewData),this.effectcolors&&this.standartcolors&&(this.colorsBack.updateColors(this.effectcolors,this.standartcolors),this.colorsFG.updateColors(this.effectcolors,this.standartcolors),this.colorsBG.updateColors(this.effectcolors,this.standartcolors),this.colorsGrad.updateColors(this.effectcolors,this.standartcolors))},txtTitle:"Slide",strColor:"Color",strFill:"Fill",textColor:"Color Fill",textImageTexture:"Picture or Texture",textTexture:"From Texture",textFromUrl:"From URL",textFromFile:"From File",textStretch:"Stretch",textTile:"Tile",txtCanvas:"Canvas",txtCarton:"Carton",txtDarkFabric:"Dark Fabric",txtGrain:"Grain",txtGranite:"Granite",txtGreyPaper:"Grey Paper",txtKnit:"Knit",txtLeather:"Leather",txtBrownPaper:"Brown Paper",txtPapyrus:"Papyrus",txtWood:"Wood",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textAdvanced:"Show advanced settings",textNoFill:"No Fill",textSelectTexture:"Select",textNone:"None",textFade:"Fade",textPush:"Push",textWipe:"Wipe",textSplit:"Split",textUnCover:"UnCover",textCover:"Cover",textClock:"Clock",textZoom:"Zoom",textSmoothly:"Smoothly",textBlack:"Through Black",textLeft:"Left",textTop:"Top",textRight:"Right",textBottom:"Bottom",textTopLeft:"Top-Left",textTopRight:"Top-Right",textBottomLeft:"Bottom-Left",textBottomRight:"Bottom-Right",textVerticalIn:"Vertical In",textVerticalOut:"Vertical Out",textHorizontalIn:"Horizontal In",textHorizontalOut:"Horizontal Out",textClockwise:"Clockwise",textCounterclockwise:"Counterclockwise",textWedge:"Wedge",textZoomIn:"Zoom In",textZoomOut:"Zoom Out",textZoomRotate:"Zoom and Rotate",strStartOnClick:"Start On Click",strDelay:"Delay",textApplyAll:"Apply to All Slides",textPreview:"Preview",strEffect:"Effect",strDuration:"Duration",textGradientFill:"Gradient Fill",textPatternFill:"Pattern",strBackground:"Background color",strForeground:"Foreground color",strPattern:"Pattern",textEmptyPattern:"No Pattern",textLinear:"Linear",textRadial:"Radial",textDirection:"Direction",textStyle:"Style",textGradient:"Gradient"}),Ext.define("PE.view.ParagraphSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.peparagraphsettings",height:176,requires:["Ext.DomHelper","Ext.button.Button","Ext.form.Label","Ext.container.Container","Ext.toolbar.Spacer","Common.component.MetricSpinner","Ext.form.field.ComboBox","PE.view.ParagraphSettingsAdvanced"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},setApi:function(e){this.api=e,e&&this.api.asc_registerCallback("asc_onParaSpacingLine",Ext.bind(this._onLineSpacing,this))},initComponent:function(){this.title=this.txtTitle,this._initSettings=!0,this._state={LineRuleIdx:1,LineHeight:1.5,LineSpacingBefore:0,LineSpacingAfter:.35},this._arrLineRule=[this.textAtLeast,this.textAuto,this.textExact],this._arrLineDefaults=[[5,"cm",.03,.01],[1,"",.5,.01],[5,"cm",.03,.01]],this.cmbLineRule=Ext.create("Ext.form.field.ComboBox",{id:"table-combo-line-rule",width:85,editable:!1,store:this._arrLineRule,mode:"local",triggerAction:"all",listeners:{select:Ext.bind(function(e,t,n){this.api&&this.api.put_PrLineSpacing(t[0].index,this._arrLineDefaults[t[0].index][0]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t[0].index][1]),this.numLineHeight.setMinValue(this._arrLineDefaults[t[0].index][2]),this.numLineHeight.setStep(this._arrLineDefaults[t[0].index][3]),this.fireEvent("editcomplete",this)},this)}}),this.cmbLineRule.setValue(this._arrLineRule[1]),this.controls.push(this.cmbLineRule),this.numLineHeight=Ext.widget("commonmetricspinner",{id:"paragraph-spin-line-height",readOnly:!1,step:.01,width:85,value:"1.5",defaultUnit:"",maxValue:132,minValue:0,listeners:{change:Ext.bind(function(e,t,n,r){if(this.cmbLineRule.getValue()=="")return;var i=c_paragraphLinerule.LINERULE_AUTO;for(var s=0;s<this._arrLineRule.length;s++)if(this.cmbLineRule.getValue()==this._arrLineRule[s]){i=s;break}this.api&&this.api.put_PrLineSpacing(i,i==c_paragraphLinerule.LINERULE_AUTO?e.getNumberValue():Common.MetricSettings.fnRecalcToMM(e.getNumberValue())),this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numLineHeight),this.numSpacingBefore=Ext.create("Common.component.MetricSpinner",{id:"paragraph-spin-spacing-before",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0 cm",maxValue:55.88,minValue:0,allowAuto:!0,autoText:this.txtAutoText,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=e.getNumberValue();i<0?this.api.put_LineSpacingBeforeAfter(0,-1):this.api.put_LineSpacingBeforeAfter(0,Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numSpacingBefore),this.numSpacingAfter=Ext.create("Common.component.MetricSpinner",{id:"paragraph-spin-spacing-after",readOnly:!1,step:.1,width:85,defaultUnit:"cm",value:"0.35 cm",maxValue:55.88,minValue:0,allowAuto:!0,autoText:this.txtAutoText,listeners:{change:Ext.bind(function(e,t,n,r){if(this.api){var i=e.getNumberValue();i<0?this.api.put_LineSpacingBeforeAfter(1,-1):this.api.put_LineSpacingBeforeAfter(1,Common.MetricSettings.fnRecalcToMM(e.getNumberValue()))}this.fireEvent("editcomplete",this)},this)}}),this.controls.push(this.numSpacingAfter),this._SpacingPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:107,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",height:41,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;vertical-align: middle;"}},items:[{xtype:"label",text:this.strLineHeight,style:"display: block;",width:85},{xtype:"label",text:this.textAt,style:"display: block;",width:85},{xtype:"tbspacer",height:2},{xtype:"tbspacer",height:2},this.cmbLineRule,this.numLineHeight]},{xtype:"tbspacer",height:10},{xtype:"container",layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;"}},defaults:{xtype:"container",layout:"vbox",layoutConfig:{align:"stretch"},height:48,style:"float:left;"},items:[{items:[{xtype:"label",text:this.strSpacingBefore,width:85},{xtype:"tbspacer",height:3},this.numSpacingBefore]},{items:[{xtype:"label",text:this.strSpacingAfter,width:85},{xtype:"tbspacer",height:3},this.numSpacingAfter]}]}]}),this.items=[{xtype:"tbspacer",height:9},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.strParagraphSpacing},this._SpacingPanel,{xtype:"tbspacer",height:3},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:"100%",items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="paragraph-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("paragraph-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},_onLineSpacing:function(e){var t=e.get_LineRule(),n=e.get_Line();this.numLineHeight.suspendEvents(!1),this.cmbLineRule.suspendEvents(!1),this._state.LineRuleIdx!==t&&(this.cmbLineRule.setValue(t!==null?this._arrLineRule[t]:""),this.numLineHeight.setMinValue(this._arrLineDefaults[t!==null?t:1][2]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t!==null?t:1][1]),this.numLineHeight.setStep(this._arrLineDefaults[t!==null?t:1][3]),this._state.LineRuleIdx=t);if(Math.abs(this._state.LineHeight-n)>.001||(this._state.LineHeight===null||n===null)&&this._state.LineHeight!==n){var r="";t==c_paragraphLinerule.LINERULE_AUTO?r=n:t!==null&&n!==null&&(r=Common.MetricSettings.fnRecalcFromMM(n)),this.numLineHeight.setValue(r!==null?r:""),this._state.LineHeight=n}this.numLineHeight.resumeEvents(),this.cmbLineRule.resumeEvents()},ChangeSettings:function(e){this._initSettings&&(this.createDelayedElements(),this._initSettings=!1);if(e){this.SuspendEvents();var t={Line:e.get_Spacing().get_Line(),Before:e.get_Spacing().get_Before(),After:e.get_Spacing().get_After(),LineRule:e.get_Spacing().get_LineRule()};this._state.LineRuleIdx!==t.LineRule&&(this.cmbLineRule.setValue(t.LineRule!==null?this._arrLineRule[t.LineRule]:""),this.numLineHeight.setMinValue(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][2]),this.numLineHeight.setDefaultUnit(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][1]),this.numLineHeight.setStep(this._arrLineDefaults[t.LineRule!==null?t.LineRule:1][3]),this._state.LineRuleIdx=t.LineRule);if(Math.abs(this._state.LineHeight-t.Line)>.001||(this._state.LineHeight===null||t.Line===null)&&this._state.LineHeight!==t.Line){var n="";t.LineRule==c_paragraphLinerule.LINERULE_AUTO?n=t.Line:t.LineRule!==null&&t.Line!==null&&(n=Common.MetricSettings.fnRecalcFromMM(t.Line)),this.numLineHeight.setValue(n!==null?n:""),this._state.LineHeight=t.Line}if(Math.abs(this._state.LineSpacingBefore-t.Before)>.001||(this._state.LineSpacingBefore===null||t.Before===null)&&this._state.LineSpacingBefore!==t.Before)this.numSpacingBefore.setValue(t.Before!==null?t.Before<0?t.Before:Common.MetricSettings.fnRecalcFromMM(t.Before):""),this._state.LineSpacingBefore=t.Before;if(Math.abs(this._state.LineSpacingAfter-t.After)>.001||(this._state.LineSpacingAfter===null||t.After===null)&&this._state.LineSpacingAfter!==t.After)this.numSpacingAfter.setValue(t.After!==null?t.After<0?t.After:Common.MetricSettings.fnRecalcFromMM(t.After):""),this._state.LineSpacingAfter=t.After;this.ResumeEvents()}},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];if(n.id=="paragraph-spin-line-height")continue;n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1)}this._arrLineDefaults[2][1]=this._arrLineDefaults[0][1]=Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()],this._arrLineDefaults[2][2]=this._arrLineDefaults[0][2]=parseFloat(Common.MetricSettings.fnRecalcFromMM(.3).toFixed(2)),this._arrLineDefaults[2][3]=this._arrLineDefaults[0][3]=Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.01:1,this._state.LineRuleIdx!==null&&(this.numLineHeight.setDefaultUnit(this._arrLineDefaults[this._state.LineRuleIdx][1]),this.numLineHeight.setStep(this._arrLineDefaults[this._state.LineRuleIdx][3]))},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Paragraph==i){n=Ext.create("PE.view.ParagraphSettingsAdvanced"),n.updateMetricUnit(),n.setSettings({paragraphProps:s,api:t.api});break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,n,r){n==1&&r&&t.api.paraApply(r.paragraphProps)},this),!1),n.addListener("close",function(){t.fireEvent("editcomplete",t)},!1),n.show())},createDelayedElements:function(){this.updateMetricUnit()},strParagraphSpacing:"Spacing",strLineHeight:"Line Spacing",strSpacingBefore:"Before",strSpacingAfter:"After",textAuto:"Multiple",textAtLeast:"At least",textExact:"Exactly",textAt:"At",txtTitle:"Paragraph",txtAutoText:"Auto",textAdvanced:"Show advanced settings"}),Ext.define("PE.view.SlideSizeSettings",{extend:"Ext.window.Window",alias:"widget.peslidesizesettings",requires:["Ext.window.Window","Ext.form.field.ComboBox","Common.component.MetricSpinner","Ext.Array","Common.plugin.ComboBoxScrollPane"],cls:"asc-advanced-settings-window",modal:!0,resizable:!1,plain:!0,constrain:!0,height:230,width:270,layout:{type:"vbox",align:"stretch"},listeners:{show:function(){this._spnWidth.focus(!1,500)}},initComponent:function(){var e=this;this.addEvents("onmodalresult"),this._noApply=!1,this._sizeIdx=0,this._spacer=Ext.create("Ext.toolbar.Spacer",{width:"100%",height:10,html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'}),this.cmbSlideSize=Ext.widget("combo",{store:Ext.create("Ext.data.Store",{fields:["description","type","size"],data:[{type:1,description:e.txtStandard,size:[254,190.5]},{type:2,description:e.txtWidescreen1,size:[254,143]},{type:3,description:e.txtWidescreen2,size:[254,158.7]},{type:4,description:e.txtLetter,size:[254,190.5]},{type:5,description:e.txtLedger,size:[338.3,253.7]},{type:6,description:e.txtA3,size:[355.6,266.7]},{type:7,description:e.txtA4,size:[275,190.5]},{type:8,description:e.txtB4,size:[300.7,225.5]},{type:9,description:e.txtB5,size:[199.1,149.3]},{type:10,description:e.txt35,size:[285.7,190.5]},{type:11,description:e.txtOverhead,size:[254,190.5]},{type:12,description:e.txtBanner,size:[203.2,25.4]},{type:-1,description:e.txtCustom,size:[]}]}),displayField:"description",valueField:"type",queryMode:"local",editable:!1,value:e.txtStandard,listeners:{select:Ext.bind(function(t,n,r){e._sizeIdx=n[0].index,t.blur(),e._noApply=!0,n[0].index!=12&&(e._spnWidth.setValue(Common.MetricSettings.fnRecalcFromMM(n[0].data.size[0])),e._spnHeight.setValue(Common.MetricSettings.fnRecalcFromMM(n[0].data.size[1]))),e._noApply=!1},this)}}),this.cmbSlideSize.select(this.cmbSlideSize.getStore().getAt(0)),this._spnWidth=Ext.create("Common.component.MetricSpinner",{id:"slide-advanced-spin-width",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"25.4 cm",width:75,listeners:{change:Ext.bind(function(t,n,r,i){!e._noApply&&e._sizeIdx!=12&&(e.cmbSlideSize.select(e.cmbSlideSize.getStore().getAt(12)),e._sizeIdx=12)},this),specialkey:function(t,n){n.getKey()==n.ENTER?e.btnOk.fireEvent("click"):n.getKey()==n.ESC&&e.btnCancel.fireEvent("click")}}}),this._spnHeight=Ext.create("Common.component.MetricSpinner",{id:"slide-advanced-span-height",readOnly:!1,maxValue:55.88,minValue:0,step:.1,defaultUnit:"cm",value:"19.05 cm",width:75,listeners:{change:Ext.bind(function(t,n,r,i){!e._noApply&&e._sizeIdx!=12&&(e.cmbSlideSize.select(e.cmbSlideSize.getStore().getAt(12)),e._sizeIdx=12)},this),specialkey:function(t,n){n.getKey()==n.ENTER?e.btnOk.fireEvent("click"):n.getKey()==n.ESC&&e.btnCancel.fireEvent("click")}}}),this.label=Ext.widget("label",{width:"100%",margin:"0 0 2 0",style:"font-weight: bold;"}),this.items=[{xtype:"container",height:136,padding:"18 25",layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.textSlideSize}),this.cmbSlideSize,{xtype:"tbspacer",height:10},{xtype:"container",height:44,layout:{type:"hbox",align:"stretch"},items:[{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.textWidth}),this._spnWidth]},{xtype:"tbspacer",width:18},{xtype:"container",flex:1,layout:{type:"vbox",align:"stretch"},items:[this.label.cloneConfig({text:e.textHeight}),this._spnHeight]}]}]},this._spacer.cloneConfig(),{xtype:"container",height:40,layout:{type:"vbox",align:"center",pack:"center"},items:[{xtype:"container",width:182,height:24,layout:{type:"hbox",align:"middle"},items:[this.btnOk=Ext.widget("button",{cls:"asc-blue-button",width:86,height:22,margin:"0 5px 0 0",text:this.okButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",1),this.close()},scope:this}}),this.btnCancel=Ext.widget("button",{cls:"asc-darkgray-button",width:86,height:22,text:this.cancelButtonText,listeners:{click:function(e){this.fireEvent("onmodalresult",0),this.close()},scope:this}})]}]}],this.callParent(arguments),this.setTitle(this.textTitle)},afterRender:function(){this.callParent(arguments)},setSettings:function(e,t,n){this._spnWidth.setValue(Common.MetricSettings.fnRecalcFromMM(t)),this._spnHeight.setValue(Common.MetricSettings.fnRecalcFromMM(n)),this.cmbSlideSize.select(this.cmbSlideSize.getStore().getAt(e<0?12:e))},getSettings:function(){var e=[this._sizeIdx<12?this._sizeIdx:-1,Common.MetricSettings.fnRecalcToMM(this._spnWidth.getNumberValue()),Common.MetricSettings.fnRecalcToMM(this._spnHeight.getNumberValue())];return e},updateMetricUnit:function(){var e=this.query("commonmetricspinner");if(e)for(var t=0;t<e.length;t++){var n=e[t];n.setDefaultUnit(Common.MetricSettings.metricName[Common.MetricSettings.getCurrentMetric()]),n.setStep(Common.MetricSettings.getCurrentMetric()==Common.MetricSettings.c_MetricUnits.cm?.1:1)}},textTitle:"Slide Size Settings",textSlideSize:"Slide Size",textWidth:"Width",textHeight:"Height",cancelButtonText:"Cancel",okButtonText:"Ok",txtStandard:"Standard (4:3)",txtWidescreen1:"Widescreen (16:9)",txtWidescreen2:"Widescreen (16:10)",txtLetter:"Letter Paper (8.5x11 in)",txtLedger:"Ledger Paper (11x17 in)",txtA3:"A3 Paper (297x420 mm)",txtA4:"A4 Paper (210x297 mm)",txtB4:"B4 (ICO) Paper (250x353 mm)",txtB5:"B5 (ICO) Paper (176x250 mm)",txt35:"35 mm Slides",txtOverhead:"Overhead",txtBanner:"Banner",txtCustom:"Custom"}),Ext.define("PE.view.TableSettings",{extend:"Common.view.AbstractSettingsPanel",alias:"widget.petablesettings",height:488,requires:["Common.component.ThemeColorPalette","Ext.button.Button","Ext.form.Label","Ext.form.field.ComboBox","Ext.container.Container","Ext.toolbar.Spacer","Ext.Array","Ext.menu.Menu","Ext.menu.Manager","PE.view.InsertTableDialog","Ext.data.Model","Ext.data.Store","Ext.XTemplate","PE.view.TableSettingsAdvanced","Common.component.ComboDataView","Common.plugin.ComboBoxScrollPane"],constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){this.title=this.txtTitle,this._initedSettings=!1,this._state={TemplateId:0,CheckHeader:!1,CheckTotal:!1,CheckBanded:!1,CheckFirst:!1,CheckLast:!1,CheckColBanded:!1,BackColor:"#000000"},this._originalLook=new CTablePropLook;var e=this;this._originalProps=null,this.CellBorders={},this.CellColor={Value:1,Color:"transparent"},this.BorderSize=0,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5],this._cmbTableTemplate=Ext.create("Common.component.ComboDataView",{id:"table-combo-template",width:185,height:64,itemWidth:70,itemHeight:50,menuMaxHeight:300,repeatedselect:!0,viewData:[],emptyComboText:this.textEmptyTemplate,listeners:{select:function(t,n){if(e.api&&!e._noApply){var r=new CTableProp;r.put_TableStyle(n.data.data.templateId),e.api.tblApply(r)}e.fireEvent("editcomplete",e)},menuhide:function(){e.fireEvent("editcomplete",e)},releasecapture:function(t){e.fireEvent("editcomplete",e)}}}),this.controls.push(this._cmbTableTemplate),this._chHeader=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-header",boxLabel:this.textHeader,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_FirstRow(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",this)},e)}}),this.controls.push(this._chHeader),this._chTotal=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-total",boxLabel:this.textTotal,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_LastRow(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",this)},e)}}),this.controls.push(this._chTotal),this._chBanded=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-banded",boxLabel:this.textBanded,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_BandHor(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",this)},e)}}),this.controls.push(this._chBanded),this._chFirst=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-first",boxLabel:this.textFirst,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_FirstCol(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",this)},e)}}),this.controls.push(this._chFirst),this._chLast=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-last",boxLabel:this.textLast,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_LastCol(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",this)},e)}}),this.controls.push(this._chLast),this._chColBanded=Ext.create("Ext.form.field.Checkbox",{id:"table-checkbox-col-banded",boxLabel:this.textBanded,checked:!1,width:85,listeners:{change:Ext.bind(function(t,n,r,i){if(e.api){var s=new CTableProp,o=e._originalLook?e._originalLook:new CTablePropLook;o.put_BandVer(n),s.put_TableLook(o),e.api.tblApply(s)}e.fireEvent("editcomplete",this)},e)}}),this.controls.push(this._chColBanded),this._TemplatePanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:185,width:"100%",items:[{xtype:"container",height:86,layout:{type:"table",columns:2,tdAttrs:{style:"padding-right: 8px;vertical-align: middle;"}},items:[{xtype:"label",text:this.textRows,style:"display: block;font-weight: bold;",width:85},{xtype:"label",text:this.textColumns,style:"display: block;font-weight: bold;",width:85},{xtype:"tbspacer",height:4},{xtype:"tbspacer",height:4},this._chHeader,this._chFirst,this._chTotal,this._chLast,this._chBanded,this._chColBanded]},{xtype:"tbspacer",height:8},{xtype:"label",text:this.textTemplate,style:"font-weight: bold;margin-bottom: 8px;"},this._cmbTableTemplate]});var t=[[c_tableBorder.BORDER_VERTICAL_LEFT,"l","asc-right-panel-small-btn btn-position-left","table-button-border-left",this.tipLeft],[c_tableBorder.BORDER_VERTICAL_CENTER,"c","asc-right-panel-small-btn btn-position-inner-vert","table-button-border-inner-vert",this.tipInnerVert],[c_tableBorder.BORDER_VERTICAL_RIGHT,"r","asc-right-panel-small-btn btn-position-right","table-button-border-right",this.tipRight],[c_tableBorder.BORDER_HORIZONTAL_TOP,"t","asc-right-panel-small-btn btn-position-top","table-button-border-top",this.tipTop],[c_tableBorder.BORDER_HORIZONTAL_CENTER,"m","asc-right-panel-small-btn btn-position-inner-hor","table-button-border-inner-hor",this.tipInnerHor],[c_tableBorder.BORDER_HORIZONTAL_BOTTOM,"b","asc-right-panel-small-btn btn-position-bottom","table-button-border-bottom",this.tipBottom],[c_tableBorder.BORDER_INNER,"cm","asc-right-panel-small-btn btn-position-inner","table-button-border-inner",this.tipInner],[c_tableBorder.BORDER_OUTER,"lrtb","asc-right-panel-small-btn btn-position-outer","table-button-border-outer",this.tipOuter],[c_tableBorder.BORDER_ALL,"lrtbcm","asc-right-panel-small-btn btn-position-all","table-button-border-all",this.tipAll],[c_tableBorder.BORDER_NONE,"","asc-right-panel-small-btn btn-position-none","table-button-border-none",this.tipNone]];this._btnsBorderPosition=[],Ext.Array.forEach(t,function(e,t){var n=Ext.create("Ext.Button",{id:e[3],cls:e[2],posId:e[0],strId:e[1],text:"",tooltip:e[4],enableToggle:!1,listeners:{click:Ext.bind(function(e,t){this._UpdateBordersStyle(e.strId,!0);if(this.api){var n=new CTableProp;n.put_CellBorders(this.CellBorders),n.put_CellSelect(!0),this.api.tblApply(n)}this.fireEvent("editcomplete",this)},this)}});this._btnsBorderPosition.push(n)},this);var n=[{borderstyle:"",text:this.txtNoBorders,value:0,offsety:0},{text:"0.5 pt",value:.5,offsety:0},{text:"1 pt",value:1,offsety:20},{text:"1.5 pt",value:1.5,offsety:40},{text:"2.25 pt",value:2.25,offsety:60},{text:"3 pt",value:3,offsety:80},{text:"4.5 pt",value:4.5,offsety:100},{text:"6 pt",value:6,offsety:120}];for(var r=1;r<n.length;r++)n[r].borderstyle=Ext.String.format("background:url({0}) 0 {1}px; width:69px; height:20px; margin-right:5px;","resources/img/right-panels/BorderSize.png",-n[r].offsety);var i=Ext.create("Ext.data.Store",{model:"PE.model.ModelBorders",data:n}),s=Ext.create("Ext.XTemplate",'<tpl for="."><span style="display: inline-block; margin-top: 3px; font-size: 11px; height: 17px;">{text}</span><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" align="right" style="{borderstyle}"></tpl>');this.cmbBorderSize=Ext.create("Ext.form.field.ComboBox",{width:93,height:21,editable:!1,queryMode:"local",matchFieldWidth:!1,displayField:"text",store:i,listConfig:{mode:"local",width:145,itemTpl:s},listeners:{select:Ext.bind(function(t,n,r){this.BorderSize=n[0].data.value;if(t.inputEl)if(n[0].data.value>0){t.inputEl.set({type:"image"}),t.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var i=Ext.String.format("background:url({0}) no-repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-n[0].data.offsety,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i)}else{var i=Ext.String.format("background: url({0}) repeat scroll 0 0 white","resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(t.inputEl,i),t.inputEl.set({type:"text"}),t.inputEl.set({value:e.txtNoBorders}),t.onItemClick(t.picker,n[0])}},this),afterRender:function(){if(this.inputEl){Ext.DomHelper.applyStyles(this.inputEl,"padding-left:7px"),this.inputEl.set({type:"image"}),this.inputEl.set({src:"data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="});var e=Ext.String.format("background:url({0}) repeat scroll 0 {1}px, url({2}) repeat scroll 0 0 white","resources/img/right-panels/BorderSize.png",-20,"resources/img/controls/text-bg.gif");Ext.DomHelper.applyStyles(this.inputEl,e)}}},plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]});var o=this.cmbBorderSize.getStore().getAt(2);this.cmbBorderSize.select(o),this.BorderSize=o.data.value,this._btnBorderColor=Ext.create("Ext.button.Button",{id:"table-button-border-color",arrowCls:"",width:45,height:22,color:"000000",menu:{showSeparator:!1,items:[this.colorsBorder=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"3D55FE",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll(),this._btnBorderColor.color=t,this._btnBorderColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBorderColor.btnEl,{"background-color":Ext.String.format("#{0}",typeof t=="object"?t.color:t)})},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBorder.addNewColor()}}}]},listeners:{render:function(e){var t=Ext.String.format("background-color:#{0}",typeof e.color=="object"?e.color.color:e.color);Ext.DomHelper.applyStyles(e.btnEl,t)}},setColor:function(e){var t,n;this.color=e,e=="transparent"||e.color=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this._btnBackColor=Ext.create("Ext.button.Button",{id:"table-button-back-color",arrowCls:"",width:45,height:22,color:"transparent",menu:{showSeparator:!1,items:[this.colorsBack=Ext.create("Common.component.ThemeColorPalette",{value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,colors:[this.textThemeColors,"-",{color:"3366FF",effectId:1},{color:"0000FF",effectId:2},{color:"000090",effectId:3},{color:"660066",effectId:4},{color:"800000",effectId:5},{color:"FF0000",effectId:1},{color:"FF6600",effectId:1},{color:"FFFF00",effectId:2},{color:"CCFFCC",effectId:3},{color:"008000",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",this.textStandartColors,"-","transparent","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:Ext.bind(function(e,t,n){Ext.menu.Manager.hideAll();var r,i;t=="transparent"?(this._btnBackColor.color="transparent",r="transparent",i="1px solid #BEBEBE"):(this._btnBackColor.color=t,r=Ext.String.format("#{0}",typeof t=="object"?t.color:t),i="none"),this._btnBackColor.btnEl&&Ext.DomHelper.applyStyles(this._btnBackColor.btnEl,{"background-color":r,border:i}),this.CellColor={Value:1,Color:this._btnBackColor.color};if(this.api){var s=new CTableProp,o=new CBackground;s.put_CellsBackground(o);var u=new CAscFill;this.CellColor.Color=="transparent"?(o.put_Value(1),u.put_type(c_oAscFill.FILL_TYPE_NOFILL),u.put_fill(null)):(o.put_Value(0),u.put_type(c_oAscFill.FILL_TYPE_SOLID),u.put_fill(new CAscFillSolid),u.get_fill().put_color(this.getRgbColor(this.CellColor.Color))),o.put_fill(u),this.api.tblApply(s)}this.fireEvent("editcomplete",this)},this)}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(t,n){e.colorsBack.addNewColor()}}}]},listeners:{render:function(e){var t,n;e.color=="transparent"?(t="1px solid #BEBEBE",n=e.color):(t="none",n=Ext.String.format("#{0}",typeof e.color=="object"?e.color.color:e.color)),Ext.DomHelper.applyStyles(e.btnEl,{"background-color":n,border:t})}},setColor:function(e){var t,n;this.color=e,e=="transparent"?(t="1px solid #BEBEBE",n=e):(t="none",n=Ext.String.format("#{0}",typeof e=="object"?e.color:e)),this.btnEl!==undefined&&Ext.DomHelper.applyStyles(this.btnEl,{"background-color":n,border:t})}}),this.controls.push(this.colorsBack),this._BordersPanel=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:168,width:190,items:[{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"hbox",align:"middle"},height:26,width:190,style:"vertical-align: middle;",items:[this.cmbBorderSize,{xtype:"tbspacer",flex:1},{xtype:"label",text:this.textBorderColor},{xtype:"tbspacer",width:7},this._btnBorderColor,{xtype:"tbspacer",width:5}]},{xtype:"tbspacer",height:8},{xtype:"container",height:30,width:190,layout:"hbox",items:[{xtype:"label",height:30,flex:1,text:this.textSelectBorders},{xtype:"tbspacer",width:5}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,items:[this._btnsBorderPosition[8],this._btnsBorderPosition[9],this._btnsBorderPosition[6],this._btnsBorderPosition[7],{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",height:8},{xtype:"container",layout:{type:"hbox",align:"middle"},width:190,items:[this._btnsBorderPosition[0],this._btnsBorderPosition[1],this._btnsBorderPosition[2],this._btnsBorderPosition[3],this._btnsBorderPosition[4],this._btnsBorderPosition[5],{xtype:"tbspacer",flex:1}]},{xtype:"tbspacer",height:12},{xtype:"container",height:25,width:190,layout:"hbox",items:[{xtype:"label",text:this.textBackColor,margin:"2px 0 0 0",style:"text-align: right;",flex:1},{xtype:"tbspacer",width:7},this._btnBackColor,{xtype:"tbspacer",width:5}]}]});var u=Ext.widget("menu",{showSeparator:!1,bodyCls:"no-icons",listeners:{hide:function(t,n){e.fireEvent("editcomplete",e)},show:function(t,n){e.api&&(e.mnuMerge.setDisabled(!e.api.CheckBeforeMergeCells()),e.mnuSplit.setDisabled(!e.api.CheckBeforeSplitCells()))}},items:[{text:e.selectRowText,listeners:{click:function(t){e.api&&e.api.selectRow()}}},{text:e.selectColumnText,listeners:{click:function(t){e.api&&e.api.selectColumn()}}},{text:e.selectCellText,listeners:{click:function(t){e.api&&e.api.selectCell()}}},{text:e.selectTableText,listeners:{click:function(t){e.api&&e.api.selectTable()}}},{xtype:"menuseparator"},{text:e.insertRowAboveText,listeners:{click:function(t){e.api&&e.api.addRowAbove()}}},{text:e.insertRowBelowText,listeners:{click:function(t){e.api&&e.api.addRowBelow()}}},{text:e.insertColumnLeftText,listeners:{click:function(t){e.api&&e.api.addColumnLeft()}}},{text:e.insertColumnRightText,listeners:{click:function(t){e.api&&e.api.addColumnRight()}}},{xtype:"menuseparator"},{text:e.deleteRowText,listeners:{click:function(t){e.api&&e.api.remRow()}}},{text:e.deleteColumnText,listeners:{click:function(t){e.api&&e.api.remColumn()}}},{text:e.deleteTableText,listeners:{click:function(t){e.api&&e.api.remTable()}}},{xtype:"menuseparator"},e.mnuMerge=Ext.create("Ext.menu.Item",{text:e.mergeCellsText,listeners:{click:function(t){e.api&&e.api.MergeCells()}}}),e.mnuSplit=Ext.create("Ext.menu.Item",{text:e.splitCellsText,listeners:{click:function(t){if(e.api){var n=Ext.create("PE.view.InsertTableDialog",{labelTitle:this.splitCellTitleText});n.addListener("onmodalresult",Ext.bind(function(t,n,r){n&&e.api.SplitCell(r[0],r[1]),e.fireEvent("editcomplete",e)},this),!1),n.show()}}}})]});this._btnEdit=Ext.create("Ext.button.Button",{id:"table-button-edit",width:45,iconCls:"btn-icon-edit-table",cls:"asc-right-panel-edit-btn",menu:u}),this._EditContainer=Ext.create("Ext.container.Container",{layout:"vbox",layoutConfig:{align:"stretch"},height:38,width:"100%",items:[{xtype:"tbspacer",height:5},{xtype:"container",height:40,width:190,layout:"hbox",items:[{xtype:"label",text:this.textEdit,margin:"2px 0 0 0",style:"font-weight: bold;margin-top: 1px;",flex:1},{xtype:"tbspacer",width:7},this._btnEdit,{xtype:"tbspacer",width:5}]}]}),this.items=[{xtype:"tbspacer",height:8},this._TemplatePanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"label",style:"font-weight: bold;margin-top: 1px;",text:this.textBorders},this._BordersPanel,{xtype:"tbspacer",height:5},{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},this._EditContainer,{xtype:"tbspacer",width:"100%",height:10,style:"padding-right: 10px;",html:'<div style="width: 100%; height: 40%; border-bottom: 1px solid #C7C7C7"></div>'},{xtype:"tbspacer",height:3},{xtype:"container",height:20,width:200,items:[{xtype:"box",html:'<div style="width:100%;text-align:center;padding-right:15px;"><label id="table-advanced-link" class="asc-advanced-link">'+this.textAdvanced+"</label></div>",listeners:{afterrender:function(e){document.getElementById("table-advanced-link").onclick=Ext.bind(this._openAdvancedSettings,this)},scope:this}}]}],this.addEvents("editcomplete"),this.callParent(arguments)},setApi:function(e){this.api=e,e&&this.api.asc_registerCallback("asc_onInitTableTemplates",Ext.bind(this._onInitTemplates,this))},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},ChangeSettings:function(e){!this._initedSettings&&this.effectcolors&&this.standartcolors&&(this.colorsBorder.updateColors(this.effectcolors,this.standartcolors),this.colorsBack.updateColors(this.effectcolors,this.standartcolors)),this._initedSettings=!0;if(e){this._originalProps=new CTableProp(e),this._originalProps.put_CellSelect(!0),this.SuspendEvents();var t=e.get_TableStyle();if(this._state.TemplateId!==t||this._isTemplatesChanged){var n=this._cmbTableTemplate.dataMenu.picker.store.findBy(function(e,n){return e.data.data.templateId===t},this);this._cmbTableTemplate.selectByIndex(n),this._isTemplatesChanged&&(n>=0?this._cmbTableTemplate.fillComboView(this._cmbTableTemplate.dataMenu.picker.store.getAt(n),!0,!0):this._cmbTableTemplate.fillComboView(this._cmbTableTemplate.dataMenu.picker.store.getAt(0),!1,!0)),this._state.TemplateId=t}this._isTemplatesChanged=!1;var r=e.get_TableLook();r&&(t=r.get_FirstRow(),this._state.CheckHeader!==t&&(this._chHeader.setValue(t),this._state.CheckHeader=t,this._originalLook.put_FirstRow(t)),t=r.get_LastRow(),this._state.CheckTotal!==t&&(this._chTotal.setValue(t),this._state.CheckTotal=t,this._originalLook.put_LastRow(t)),t=r.get_BandHor(),this._state.CheckBanded!==t&&(this._chBanded.setValue(t),this._state.CheckBanded=t,this._originalLook.put_BandHor(t)),t=r.get_FirstCol(),this._state.CheckFirst!==t&&(this._chFirst.setValue(t),this._state.CheckFirst=t,this._originalLook.put_FirstCol(t)),t=r.get_LastCol(),this._state.CheckLast!==t&&(this._chLast.setValue(t),this._state.CheckLast=t,this._originalLook.put_LastCol(t)),t=r.get_BandVer(),this._state.CheckColBanded!==t&&(this._chColBanded.setValue(t),this._state.CheckColBanded=t,this._originalLook.put_BandVer(t)));var i=e.get_CellsBackground();if(i){var s=i.get_fill(),o=s.get_type();if(s===null||o===null||o==c_oAscFill.FILL_TYPE_NOFILL)this.CellColor={Value:1,Color:"transparent"};else if(o==c_oAscFill.FILL_TYPE_SOLID){s=s.get_fill();var u=s.get_color();u?u.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?this.CellColor={Value:1,Color:{color:this.getHexColor(u.get_r(),u.get_g(),u.get_b()),effectValue:u.get_value()}}:this.CellColor={Value:1,Color:this.getHexColor(u.get_r(),u.get_g(),u.get_b())}:this.CellColor={Value:0,Color:"transparent"}}}else this.CellColor={Value:0,Color:"transparent"};var a=typeof this.CellColor.Color,f=typeof this._state.BackColor;if(a!==f||a=="object"&&(this.CellColor.Color.effectValue!==this._state.BackColor.effectValue||this._state.BackColor.color.indexOf(this.CellColor.Color.color)<0)||a!="object"&&this._state.BackColor.indexOf(this.CellColor.Color)<0){this._btnBackColor.setColor(this.CellColor.Color);if(typeof this.CellColor.Color=="object"){for(var l=0;l<10;l++)if(this.ThemeValues[l]==this.CellColor.Color.effectValue){this.colorsBack.select(this.CellColor.Color,!1);break}}else this.colorsBack.select(this.CellColor.Color,!1);this._state.BackColor=this.CellColor.Color}this.ResumeEvents()}},_UpdateBordersStyle:function(e){this.CellBorders=new CBorders;var t=this.CellBorders,n=e!="";if(e.indexOf("l")>-1||!n)(t.get_Left()===null||t.get_Left()===undefined)&&t.put_Left(new CBorder),this._UpdateBorderStyle(t.get_Left(),n);if(e.indexOf("t")>-1||!n)(t.get_Top()===null||t.get_Top()===undefined)&&t.put_Top(new CBorder),this._UpdateBorderStyle(t.get_Top(),n);if(e.indexOf("r")>-1||!n)(t.get_Right()===null||t.get_Right()===undefined)&&t.put_Right(new CBorder),this._UpdateBorderStyle(t.get_Right(),n);if(e.indexOf("b")>-1||!n)(t.get_Bottom()===null||t.get_Bottom()===undefined)&&t.put_Bottom(new CBorder),this._UpdateBorderStyle(t.get_Bottom(),n);if(e.indexOf("c")>-1||!n)(t.get_InsideV()===null||t.get_InsideV()===undefined)&&t.put_InsideV(new CBorder),this._UpdateBorderStyle(t.get_InsideV(),n);if(e.indexOf("m")>-1||!n)(t.get_InsideH()===null||t.get_InsideH()===undefined)&&t.put_InsideH(new CBorder),this._UpdateBorderStyle(t.get_InsideH(),n)},_UpdateBorderStyle:function(e,t){null==e&&(e=new CBorder);if(t&&this.BorderSize>0){var n=parseFloat(this.BorderSize);e.put_Value(1),e.put_Size(n*25.4/72);var r=this.getRgbColor(this._btnBorderColor.color);e.put_Color(r)}else e.put_Value(0)},_openAdvancedSettings:function(e){var t=this,n;if(t.api){var r=t.api.getSelectedElements();if(r&&Ext.isArray(r)){var i,s;for(var o=r.length-1;o>=0;o--){i=r[o].get_ObjectType(),s=r[o].get_ObjectValue();if(c_oAscTypeSelectElement.Table==i){n=Ext.create("PE.view.TableSettingsAdvanced"),n.updateMetricUnit(),n.setSettings({tableProps:s});break}}}}n&&(n.addListener("onmodalresult",Ext.bind(function(e,r,i){if(r==1){var s=n.getSettings();t.borderAdvancedProps=s.borderProps,t.api.tblApply(s.tableProps)}t.fireEvent("editcomplete",t)},this),!1),n.show())},_onInitTemplates:function(e){var t=this;this._isTemplatesChanged=!0;var n=t._cmbTableTemplate.dataMenu.picker.store.getCount();if(n>0&&n==e.length){var r=t._cmbTableTemplate.dataMenu.picker.store.data.items;Ext.each(e,function(e,t){r[t].data.imageUrl=e.get_Image()}),t._cmbTableTemplate.dataMenu.picker.store.fireEvent("datachanged",t._cmbTableTemplate.dataMenu.picker.store)}else{var i=[];t._cmbTableTemplate.dataMenu.picker.store.removeAll(),Ext.each(e,function(e){i.push({imageUrl:e.get_Image(),uid:Ext.id(),data:{templateId:e.get_Id()}})}),t._cmbTableTemplate.dataMenu.picker.store.loadData(i)}},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this._initedSettings&&(this.colorsBorder.updateColors(e,t),this.colorsBack.updateColors(e,t))},hideMenus:function(){this._btnBorderColor.hideMenu(),this._btnBackColor.hideMenu(),this._cmbTableTemplate.dataMenu.hide(),this._btnEdit.hideMenu()},textBorders:"Border's Style",textBorderColor:"Color",textBackColor:"Background color",textEdit:"Rows & Columns",selectRowText:"Select Row",selectColumnText:"Select Column",selectCellText:"Select Cell",selectTableText:"Select Table",insertRowAboveText:"Insert Row Above",insertRowBelowText:"Insert Row Below",insertColumnLeftText:"Insert Column Left",insertColumnRightText:"Insert Column Right",deleteRowText:"Delete Row",deleteColumnText:"Delete Column",deleteTableText:"Delete Table",mergeCellsText:"Merge Cells",splitCellsText:"Split Cell...",splitCellTitleText:"Split Cell",textSelectBorders:"Select borders that you want to change",textAdvanced:"Show advanced settings",txtTitle:"Table",txtNoBorders:"No borders",textTemplate:"Select From Template",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",textRows:"Rows",textColumns:"Columns",textHeader:"Header",textTotal:"Total",textBanded:"Banded",textFirst:"First",textLast:"Last",textEmptyTemplate:"No templates",tipTop:"Set Outer Top Border Only",tipLeft:"Set Outer Left Border Only",tipBottom:"Set Outer Bottom Border Only",tipRight:"Set Outer Right Border Only",tipAll:"Set Outer Border and All Inner Lines",tipNone:"Set No Borders",tipInner:"Set Inner Lines Only",tipInnerVert:"Set Vertical Inner Lines Only",tipInnerHor:"Set Horizontal Inner Lines Only",tipOuter:"Set Outer Border Only"}),Ext.define("PE.model.PatternDataModel",{extend:"Ext.data.Model",fields:[{name:"imageUrl"},{name:"imageStyle"},{name:"imageCls"},{name:"title"},{name:"data"},{name:"uid"}]}),Ext.define("PE.view.RightPanel",{extend:"Ext.container.Container",alias:"widget.perightpanel",width:220,layout:{type:"auto"},autoScroll:!0,cls:"asc-right-panel-container",preventHeader:!0,requires:["Ext.toolbar.Toolbar","Ext.container.Container","Common.plugin.ScrollPane","PE.view.TableSettings","PE.view.ParagraphSettings","PE.view.ImageSettings","PE.view.ShapeSettings","PE.view.SlideSettings","Ext.button.Button","Ext.panel.Panel"],uses:["Ext.DomHelper","Ext.util.Cookies"],listeners:{afterrender:function(){var e=this.ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeRightPanels,this))}},resizeRightPanels:function(e){this.doComponentLayout(),this.hideMenus()},constructor:function(e){return this.callParent(arguments),this.initConfig(e),this},initComponent:function(){var e=this;e.editMode=!0,e.minimizedMode=!0,e.plugins=[{ptype:"scrollpane",pluginId:"scrollpane",areaSelector:".x-container",settings:{enableKeyboardNavigation:!0,verticalGutter:0}}],e.callParent(arguments)},updateScrollPane:function(){var e=this;e.getPlugin("scrollpane").updateScrollPane()},onFocusObject:function(e){if(!this.editMode)return;for(var t=0;t<this._settings.length;t++)this._settings[t]&&(this._settings[t].hidden=1,this._settings[t].locked=undefined);this._settings[c_oAscTypeSelectElement.Slide].hidden=0;for(t=0;t<e.length;t++){var n=e[t].get_ObjectType();if(n>=this._settings.length||this._settings[n]===undefined)continue;this._settings[n].props=e[t].get_ObjectValue(),this._settings[n].hidden=0,n==c_oAscTypeSelectElement.Slide?(this._settings[n].locked=this._settings[n].props.get_LockDelete(),this._settings[n].lockedBackground=this._settings[n].props.get_LockBackground(),this._settings[n].lockedEffects=this._settings[n].props.get_LockTranzition(),this._settings[n].lockedTiming=this._settings[n].props.get_LockTiming()):this._settings[n].locked=this._settings[n].props.get_Locked()}if(this._settings[c_oAscTypeSelectElement.Slide].locked)for(t=0;t<this._settings.length;t++)this._settings[t]&&(this._settings[t].locked=!0);var r=-1,i,s=-1;for(t=0;t<this._settings.length;t++){if(this._settings[t]===undefined)continue;this._settings[t].hidden?(this._settings[t].btn.isDisabled()||this._settings[t].btn.setDisabled(!0),this.TabPanel.getLayout().getActiveItem()==this._settings[t].panel&&(i=-1)):(this._settings[t].btn.isDisabled()&&this._settings[t].btn.setDisabled(!1),t!=c_oAscTypeSelectElement.Slide&&(r=t),this._settings[t].needShow?(this._settings[t].needShow=!1,s=t):(t!=c_oAscTypeSelectElement.Slide||this._settings[t].isCurrent)&&this.TabPanel.getLayout().getActiveItem()==this._settings[t].panel&&(i=t),t==c_oAscTypeSelectElement.Slide?this._settings[t].locked!==undefined&&this._settings[t].panel.setSlideDisabled(this._settings[t].lockedBackground||this._settings[t].locked,this._settings[t].lockedEffects||this._settings[t].locked,this._settings[t].lockedTiming||this._settings[t].locked):this._settings[t].panel.isDisabled()!==this._settings[t].locked&&this._settings[t].panel.setDisabled(this._settings[t].locked))}if(!this.minimizedMode){var o;s>-1?o=s:i>=0?o=i:r>=0?o=r:o=c_oAscTypeSelectElement.Slide,o!==undefined&&(this._settings[o].btn.pressed?this._settings[o].panel.ChangeSettings.call(this._settings[o].panel,this._settings[o].props):this._settings[o].btn.toggle())}this._settings[c_oAscTypeSelectElement.Image].needShow=!1,this._settings[c_oAscTypeSelectElement.Shape].needShow=!1},onInsertTable:function(){this._settings[c_oAscTypeSelectElement.Table].needShow=!0},onInsertImage:function(){this._settings[c_oAscTypeSelectElement.Image].needShow=!0},onInsertShape:function(){this._settings[c_oAscTypeSelectElement.Shape].needShow=!0},setApi:function(e){return this.api=e,this},setMode:function(e){this.editMode=e.isEdit},FillAutoShapes:function(){this.ShapePanel.FillAutoShapes()},hideMenus:function(){if(this._settings)for(var e=0;e<this._settings.length;e++){if(this._settings[e]===undefined)continue;Ext.isDefined(this._settings[e].panel.hideMenus)&&this._settings[e].panel.hideMenus()}},updateMetricUnit:function(){this.ParagraphPanel.updateMetricUnit(),this.ImagePanel.updateMetricUnit()},SendThemeColors:function(e,t){this.effectcolors=e,t&&t.length>0&&(this.standartcolors=t),this.ShapePanel&&this.TablePanel&&this.SlidePanel&&(this.ShapePanel.SendThemeColors(e,t),this.TablePanel.SendThemeColors(e,t),this.SlidePanel.SendThemeColors(e,t))},createDelayedElements:function(){var e=this;e.panelHolder=Ext.create("Ext.container.Container",{layout:{type:"anchor"},items:[e.TabPanel=Ext.create("Ext.panel.Panel",{hidden:!0,id:"view-tab-panel",cls:"asc-right-tabpanel",preventHeader:!0,layout:"card",items:[e.SlidePanel=Ext.create("PE.view.SlideSettings",{id:"view-slide-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Slide}),e.ShapePanel=Ext.create("PE.view.ShapeSettings",{id:"view-shape-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Shape}),e.ParagraphPanel=Ext.create("PE.view.ParagraphSettings",{id:"view-paragraph-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Paragraph}),e.TablePanel=Ext.create("PE.view.TableSettings",{id:"view-table-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Table}),e.ImagePanel=Ext.create("PE.view.ImageSettings",{id:"view-image-settings",cls:"asc-right-panel",type:c_oAscTypeSelectElement.Image})],listeners:{afterlayout:function(){e.updateScrollPane()}}})],listeners:{afterlayout:function(){e.updateScrollPane()}}}),e.add(e.panelHolder),e._settings=[],e._settings[c_oAscTypeSelectElement.Paragraph]={panel:e.ParagraphPanel,btn:e.btnText,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Table]={panel:e.TablePanel,btn:e.btnTable,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Image]={panel:e.ImagePanel,btn:e.btnImage,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Shape]={panel:e.ShapePanel,btn:e.btnShape,hidden:1,locked:!1},e._settings[c_oAscTypeSelectElement.Slide]={panel:e.SlidePanel,btn:e.btnSlide,hidden:1,locked:!1},this.api&&(this.ShapePanel.setApi(this.api),this.ImagePanel.setApi(this.api),this.ParagraphPanel.setApi(this.api),this.TablePanel.setApi(this.api),this.SlidePanel.setApi(this.api));if(this.editMode&&this.api){var t=this.api.getSelectedElements();t.length>0&&this.onFocusObject(t)}this.effectcolors&&this.standartcolors&&(this.ShapePanel.SendThemeColors(this.effectcolors,this.standartcolors),this.TablePanel.SendThemeColors(this.effectcolors,this.standartcolors),this.SlidePanel.SendThemeColors(this.effectcolors,this.standartcolors))}});var SCALE_MIN=40,MENU_SCALE_PART=260,RIGHTMENU_TOOLBAR_ID="rightmenu-toolbar-id",RIGHTMENU_PANEL_ID="rightmenu-panel-id";Ext.define("PE.view.RightMenu",{extend:"Ext.panel.Panel",alias:"widget.perightmenu",requires:["Ext.toolbar.Toolbar","Ext.button.Button","Ext.container.Container","Ext.toolbar.Spacer","PE.view.RightPanel","Ext.util.Cookies"],cls:"rm-style",id:RIGHTMENU_PANEL_ID,bodyCls:"rm-body",width:SCALE_MIN,buttonCollection:[],listeners:{afterrender:function(){var e=this.ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeMenu,this))}},initComponent:function(){this.dockedItems=this.buildDockedItems(),this._rightSettings=Ext.widget("perightpanel",{id:"view-right-panel-settings",btnText:this.btnText,btnTable:this.btnTable,btnImage:this.btnImage,btnShape:this.btnShape,btnSlide:this.btnSlide}),this.items=[this._rightSettings],this.addEvents("editcomplete"),this.callParent(arguments)},buildDockedItems:function(){var e=this;return e.btnSlide=Ext.create("Ext.button.Button",{id:"id-right-menu-slide",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuSlide",asctype:c_oAscTypeSelectElement.Slide,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnShape=Ext.create("Ext.button.Button",{id:"id-right-menu-shape",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuShape",asctype:c_oAscTypeSelectElement.Shape,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnImage=Ext.create("Ext.Button",{id:"id-right-menu-image",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuImage",asctype:c_oAscTypeSelectElement.Image,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnText=Ext.create("Ext.Button",{id:"id-right-menu-text",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuText",asctype:c_oAscTypeSelectElement.Paragraph,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),e.btnTable=Ext.create("Ext.Button",{id:"id-right-menu-table",cls:"asc-main-menu-buttons",iconCls:"asc-main-menu-btn menuTable",asctype:c_oAscTypeSelectElement.Table,enableToggle:!0,allowDepress:!0,style:"margin-bottom: 8px;",disabled:!0,toggleGroup:"tabpanelbtnsGroup"}),this.rightToolbar=Ext.create("Ext.toolbar.Toolbar",{cls:"rm-default-toolbar",width:this.width||SCALE_MIN,vertical:!0,dock:"right",defaultType:"button",style:"padding-top: 15px;",items:[e.btnSlide,e.btnShape,e.btnImage,e.btnText,e.btnTable]}),this.rightToolbar},resizeMenu:function(e,t,n,r){for(var i=0;i<this.items.length;i++)this.items.items[i].el&&n!=this.items.items[i].getHeight()&&this.items.items[i].setHeight(n);this.doComponentLayout()},setApi:function(e){return this.api=e,this.api.asc_registerCallback("asc_onСoAuthoringDisconnect",Ext.bind(this.onCoAuthoringDisconnect,this)),this},disableMenu:function(e){var t,n,r=this.rightToolbar;if(Ext.isDefined(r))for(n=0;n<r.items.length;n++)t=r.items.items[n],Ext.isDefined(t)&&t.componentCls==="x-btn"&&(t.pressed&&t.toggle(!1),t.setDisabled(e))},onCoAuthoringDisconnect:function(){this.disableMenu(!0),this._rightSettings&&(this._rightSettings.setDisabled(!0),this._rightSettings.setMode({isEdit:!1}))},createDelayedElements:function(){var e=this;e._rightSettings.setHeight(e.getHeight());var t=function(t,n){if(n&&!e._rightSettings.minimizedMode){t.addCls("asc-main-menu-btn-selected");var r=e._rightSettings._settings[t.asctype].panel,i=e._rightSettings._settings[t.asctype].props;e._rightSettings.TabPanel.getLayout().setActiveItem(r),e._rightSettings.TabPanel.setHeight(r.initialHeight),i&&r.ChangeSettings.call(r,i)}},n=function(n){n.pressed?(e._rightSettings.minimizedMode?(e._rightSettings.TabPanel.hidden&&e._rightSettings.TabPanel.setVisible(!0),e.setWidth(MENU_SCALE_PART),e._rightSettings.minimizedMode=!1,t(n,n.pressed),window.localStorage.setItem("de-hidden-right-settings",0)):n.addCls("asc-main-menu-btn-selected"),e._rightSettings._settings[c_oAscTypeSelectElement.Slide].isCurrent=n.asctype==c_oAscTypeSelectElement.Slide):(e.setWidth(SCALE_MIN),e._rightSettings.minimizedMode=!0,n.removeCls("asc-main-menu-btn-selected"),window.localStorage.setItem("de-hidden-right-settings",1)),e.fireEvent("editcomplete",e)},r,i=[e.txtSlideSettings,e.txtShapeSettings,e.txtImageSettings,e.txtParagraphSettings,e.txtTableSettings];for(var s=this.rightToolbar.items.items.length;s--;)r=this.rightToolbar.items.items[s],r.on({click:n,toggle:t}),r.setTooltip(i[s])},txtParagraphSettings:"Text Settings",txtImageSettings:"Image Settings",txtTableSettings:"Table Settings",txtShapeSettings:"Shape Settings",txtSlideSettings:"Slide Settings",txtChartSettings:"Chart Settings"}),Ext.define("PE.view.Toolbar",{extend:"Ext.toolbar.Toolbar",alias:"widget.petoolbar",cls:"pe-toolbar",height:68,minWidth:1080,requires:["Ext.data.Store","Ext.Array","Common.component.MenuDataViewPicker","Common.component.SplitColorButton","Common.plugin.ComboBoxScrollPane","Common.view.ComboFonts","Common.component.ThemeColorPalette","PE.component.DimensionPicker","Common.component.ComboDataView","Common.plugin.MenuExpand","Ext.util.Cookies","Common.component.SynchronizeTip"],constructor:function(e){return this.initConfig(e),this.callParent(arguments),this},initComponent:function(){var e=this;this.addEvents("editcomplete"),this.addEvents("inserttable","insertimage","insertshape"),this._state={clrtext:undefined},this.paragraphControls=[],this.shapeControls=[],this.slideOnlyControls=[],this.synchTooltip=undefined,this.ThemeValues=[6,15,7,16,0,1,2,3,4,5];var t=window.localStorage.getItem("pe-hide-synch");this.showSynchTip=!t||parseInt(t)!=1,this.needShowSynchTip=!1,this.cmbFont=Ext.create("Common.view.ComboFonts",{id:"toolbar-combo-fonts",margin:"0 4 0 0",width:128,cls:"asc-toolbar-combo",editable:!0,selectOnFocus:!0,tooltip:this.tipFontName,showlastused:!0,enableKeyEvents:!0,preventMark:!0,validateOnBlur:!1,validateOnChange:!1,plugins:[{ptype:"comboboxscrollpane",pluginId:"scrollpane",settings:{enableKeyboardNavigation:!0}}]}),this.paragraphControls.push(this.cmbFont),Ext.define("PE.view.FontSize",{extend:"Ext.data.Model",fields:[{type:"int",name:"sizevalue"},{type:"string",name:"sizestring"}]});var n=Ext.create("Ext.data.Store",{model:"PE.view.FontSize",data:[]});this.cmbFontSize=Ext.create("Ext.form.field.ComboBox",{id:"toolbar-combo-font-size",store:n,displayField:"sizestring",queryMode:"local",typeAhead:!1,selectOnFocus:!0,margin:"0 0 0 0",width:60,listConfig:{maxHeight:400},preventMark:!0,validateOnBlur:!1,validateOnChange:!1,listeners:{render:{fn:function(t){t.el.set({"data-qtip":e.tipFontSize}),t.validate()}}}}),this.paragraphControls.push(this.cmbFontSize),this.btnBold=Ext.create("Ext.Button",{id:"toolbar-button-bold",tooltip:this.textBold+" (Ctrl+B)",margin:"0 2 0 0",iconCls:"asc-toolbar-btn btn-bold",enableToggle:!0}),this.paragraphControls.push(this.btnBold),this.btnItalic=Ext.create("Ext.Button",{id:"toolbar-button-italic",tooltip:this.textItalic+" (Ctrl+I)",iconCls:"asc-toolbar-btn btn-italic",enableToggle:!0}),this.paragraphControls.push(this.btnItalic),this.btnUnderline=Ext.create("Ext.Button",{id:"toolbar-button-underline",tooltip:this.textUnderline+" (Ctrl+U)",iconCls:"asc-toolbar-btn btn-underline",enableToggle:!0}),this.paragraphControls.push(this.btnUnderline),this.btnStrikeout=Ext.create("Ext.Button",{id:"toolbar-strikeout",tooltip:this.textStrikeout,iconCls:"asc-toolbar-btn btn-strike",enableToggle:!0}),this.paragraphControls.push(this.btnStrikeout),this.btnSuperscript=Ext.create("Ext.Button",{id:"toolbar-button-superscript",tooltip:this.textSuperscript,iconCls:"asc-toolbar-btn btn-superscript",enableToggle:!0,toggleGroup:"subscriptGroup"}),this.paragraphControls.push(this.btnSuperscript),this.btnSubscript=Ext.create("Ext.Button",{id:"toolbar-button-subscript",tooltip:this.textSubscript,iconCls:"asc-toolbar-btn btn-subscript",enableToggle:!0,toggleGroup:"subscriptGroup"}),this.paragraphControls.push(this.btnSubscript),this.btnPrint=Ext.create("Ext.Button",{id:"toolbar-button-print",tooltip:this.tipPrint+" (Ctrl+P)",iconCls:"asc-toolbar-btn btn-print"}),this.btnSave=Ext.create("Ext.Button",{id:"toolbar-button-save",tooltip:this.tipSave+" (Ctrl+S)",iconCls:"asc-toolbar-btn btn-save"}),this.btnCopy=Ext.create("Ext.Button",{id:"toolbar-button-copy",tooltip:this.tipCopy+" (Ctrl+C)",iconCls:"asc-toolbar-btn btn-copy"}),this.slideOnlyControls.push(this.btnCopy),this.btnPaste=Ext.create("Ext.Button",{id:"toolbar-button-paste",tooltip:this.tipPaste+" (Ctrl+V)",iconCls:"asc-toolbar-btn btn-paste"}),this.slideOnlyControls.push(this.btnPaste),this.btnUndo=Ext.create("Ext.Button",{id:"toolbar-button-undo",tooltip:this.tipUndo+" (Ctrl+Z)",iconCls:"asc-toolbar-btn btn-undo",disabled:!0}),this.slideOnlyControls.push(this.btnUndo),this.btnRedo=Ext.create("Ext.Button",{id:"toolbar-button-redo",tooltip:this.tipRedo+" (Ctrl+Y)",iconCls:"asc-toolbar-btn btn-redo",disabled:!0}),this.slideOnlyControls.push(this.btnRedo),this.btnClearStyle=Ext.create("Ext.button.Button",{id:"toolbar-button-clear-style",tooltip:this.tipClearStyle,iconCls:"asc-toolbar-btn btn-clearstyle"}),this.paragraphControls.push(this.btnClearStyle),this.btnCopyStyle=Ext.create("Ext.button.Button",{id:"toolbar-button-copy-style",tooltip:this.tipCopyStyle+" (Ctrl+Shift+C)",iconCls:"asc-toolbar-btn btn-copystyle",enableToggle:!0}),this.slideOnlyControls.push(this.btnCopyStyle),this.btnFontColor=Ext.widget("cmdsplitcolorbutton",{id:"toolbar-button-font-color",tooltip:this.tipFontColor,color:"000000",horizontalOffset:3,verticalOffset:2,split:!0,listeners:{changecolor:function(t,n){e.fireEvent("editcomplete",e)},click:function(t){e.colorsText.fireEvent("select",e.colorsText,e.colorsText.currentColor)}},iconCls:"asc-toolbar-btn btn-fontcolor"}),this.paragraphControls.push(this.btnFontColor),this.btnMarkers=Ext.create("Ext.button.Split",{id:"toolbar-btn-markers",tooltip:this.tipMarkers,enableToggle:!0,toggleGroup:"markersGroup",iconCls:"asc-toolbar-btn btn-setmarkers",split:!0}),this.paragraphControls.push(this.btnMarkers),this.btnNumbers=Ext.create("Ext.button.Split",{id:"toolbar-btn-numbering",tooltip:this.tipNumbers,enableToggle:!0,toggleGroup:"markersGroup",iconCls:"asc-toolbar-btn btn-numbering",split:!0}),this.paragraphControls.push(this.btnNumbers),this.btnDecLeftOffset=Ext.create("Ext.button.Button",{id:"toolbar-button-dec-left-offset",tooltip:this.tipDecPrLeft+" (Ctrl+Shift+M)",iconCls:"asc-toolbar-btn btn-decoffset"}),this.paragraphControls.push(this.btnDecLeftOffset),this.btnIncLeftOffset=Ext.create("Ext.button.Button",{id:"toolbar-button-inc-left-offset",tooltip:this.tipIncPrLeft+" (Ctrl+M)",iconCls:"asc-toolbar-btn btn-incoffset"}),this.paragraphControls.push(this.btnIncLeftOffset),this.btnLineSpace=Ext.create("Ext.button.Button",{id:"toolbar-button-line-space",tooltip:this.tipLineSpace,iconCls:"asc-toolbar-btn btn-linespace",menu:{id:"toolbar-menu-line-space",width:76,defaults:{group:"linespace",checked:!1},items:[{text:"1.0",linespace:1,checked:!0},{text:"1.15",linespace:1.15},{text:"1.5",linespace:1.5},{text:"2.0",linespace:2},{text:"2.5",linespace:2.5},{text:"3.0",linespace:3}]}}),this.paragraphControls.push(this.btnLineSpace),this.btnHorizontalAlign=Ext.create("Ext.Button",{id:"toolbar-button-halign",tooltip:this.tipHAligh,iconCls:"asc-toolbar-btn btn-halign",cls:"halign-left",icls:"halign-left",menu:{showSeparator:!1,id:"toolbar-menu-horalign",defaults:{cls:"toolbar-menu-icon-item",group:"halignGroup",checked:!1},items:[{iconCls:"mnu-icon-item mnu-align-left",text:this.textAlignLeft,icls:"halign-left",halign:1,checked:!0},{iconCls:"mnu-icon-item mnu-align-center",text:this.textAlignCenter,icls:"halign-center",halign:2},{iconCls:"mnu-icon-item mnu-align-right",text:this.textAlignRight,icls:"halign-right",halign:0},{iconCls:"mnu-icon-item mnu-align-just",text:this.textAlignJust,icls:"halign-just",halign:3}]}}),this.paragraphControls.push(this.btnHorizontalAlign),this.btnVerticalAlign=Ext.create("Ext.button.Button",{id:"toolbar-button-valign",tooltip:this.tipVAligh,iconCls:"asc-toolbar-btn btn-vertalign",cls:"valign-middle",icls:"valign-middle",menu:{showSeparator:!1,id:"toolbar-menu-vertalign",defaults:{cls:"toolbar-menu-icon-item",group:"valignGroup",checked:!1},items:[{iconCls:"mnu-icon-item mnu-align-top",text:this.textAlignTop,icls:"valign-top",valign:c_oAscVerticalTextAlign.TEXT_ALIGN_TOP},{iconCls:"mnu-icon-item mnu-align-middle",text:this.textAlignMiddle,icls:"valign-middle",valign:c_oAscVerticalTextAlign.TEXT_ALIGN_CTR,checked:!0},{iconCls:"mnu-icon-item mnu-align-bottom",text:this.textAlignBottom,icls:"valign-bottom",valign:c_oAscVerticalTextAlign.TEXT_ALIGN_BOTTOM}]}}),this.paragraphControls.push(this.btnVerticalAlign),this.btnInsertTable=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-table",tooltip:this.tipInsertTable,iconCls:"asc-toolbar-btn btn-inserttable",menu:{showSeparator:!1,id:"toolbar-menu-insert-table",items:[{xtype:"container",width:200,items:[{xtype:"pedimensionpicker",minRows:8,minColumns:10,maxRows:8,maxColumns:10,stalign:"top",padding:"10px"}]},{text:this.mniCustomTable,id:"toolbar-insert-custom-table",cls:"menu-item-noicon"}]}}),this.slideOnlyControls.push(this.btnInsertTable),this.btnInsertImage=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-image",tooltip:this.tipInsertImage,iconCls:"asc-toolbar-btn btn-insertimage",menu:{showSeparator:!1,id:"toolbar-menu-insertimage",items:[{text:this.mniImageFromFile,cls:"menu-item-noicon",from:"file"},{text:this.mniImageFromUrl,cls:"menu-item-noicon",from:"url"}]}}),this.slideOnlyControls.push(this.btnInsertImage),this.btnInsertHyperlink=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-hyperlink",tooltip:this.tipInsertHyperlink,iconCls:"asc-toolbar-btn btn-inserthyperlink"}),this.paragraphControls.push(this.btnInsertHyperlink),this.btnInsertText=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-text",tooltip:this.tipInsertText,iconCls:"asc-toolbar-btn btn-text",enableToggle:!0}),this.slideOnlyControls.push(this.btnInsertText),this.btnInsertShape=Ext.create("Ext.button.Button",{id:"toolbar-button-insert-shape",tooltip:this.tipInsertShape,iconCls:"asc-toolbar-btn btn-insertshape",enableToggle:!0,menu:{showSeparator:!1,id:"toolbar-menu-insert-shape",items:[],plugins:[{ptype:"menuexpand"}]}}),this.slideOnlyControls.push(this.btnInsertShape),this.btnColorSchemas=Ext.create("Ext.button.Button",{id:"toolbar-button-color-schemas",tooltip:this.tipColorSchemas,iconCls:"asc-toolbar-btn btn-colorschemas",split:!0}),this.btnAddSlide=Ext.create("Ext.button.Button",{id:"toolbar-button-add-slide",tooltip:this.tipAddSlide,iconCls:"asc-toolbar-btn btn-addslide",scale:"large",split:!0}),this.btnChangeSlide=Ext.create("Ext.button.Button",{id:"toolbar-button-change-slide",tooltip:this.tipChangeSlide,iconCls:"asc-toolbar-btn btn-changeslide",split:!0}),this.btnPreview=Ext.create("Ext.Button",{id:"toolbar-button-preview",tooltip:this.tipPreview,iconCls:"asc-toolbar-btn btn-preview"}),this.btnNewDocument=Ext.create("Ext.Button",{id:"toolbar-button-newdocument",tooltip:this.tipNewDocument,iconCls:"asc-toolbar-btn btn-newdocument"}),this.btnOpenDocument=Ext.create("Ext.Button",{id:"toolbar-button-opendocument",tooltip:this.tipOpenDocument,iconCls:"asc-toolbar-btn btn-opendocument"}),this.btnShapeAlign=Ext.create("Ext.Button",{id:"toolbar-button-shape-align",tooltip:this.tipShapeAlign,iconCls:"asc-toolbar-btn btn-align-shape",menu:{showSeparator:!1,id:"toolbar-menu-shape-align",defaults:{cls:"toolbar-menu-icon-item"},items:[{iconCls:"mnu-icon-item mnu-shape-align-left",text:this.textShapeAlignLeft,halign:c_oAscAlignShapeType.ALIGN_LEFT},{iconCls:"mnu-icon-item mnu-shape-align-center",text:this.textShapeAlignCenter,halign:c_oAscAlignShapeType.ALIGN_CENTER},{iconCls:"mnu-icon-item mnu-shape-align-right",text:this.textShapeAlignRight,halign:c_oAscAlignShapeType.ALIGN_RIGHT},{iconCls:"mnu-icon-item mnu-shape-align-top",text:this.textShapeAlignTop,halign:c_oAscAlignShapeType.ALIGN_TOP},{iconCls:"mnu-icon-item mnu-shape-align-middle",text:this.textShapeAlignMiddle,halign:c_oAscAlignShapeType.ALIGN_MIDDLE},{iconCls:"mnu-icon-item mnu-shape-align-bottom",text:this.textShapeAlignBottom,halign:c_oAscAlignShapeType.ALIGN_BOTTOM},{xtype:"menuseparator"},{iconCls:"mnu-icon-item mnu-distrib-hor",text:this.txtDistribHor,halign:6},{iconCls:"mnu-icon-item mnu-distrib-vert",text:this.txtDistribVert,halign:7}]}}),this.shapeControls.push(this.btnShapeAlign),this.slideOnlyControls.push(this.btnShapeAlign),this.btnShapeArrange=Ext.create("Ext.Button",{id:"toolbar-button-shape-arrange",tooltip:this.tipShapeArrange,iconCls:"asc-toolbar-btn btn-arrange-shape",menu:{showSeparator:!1,id:"toolbar-menu-shape-arrange",defaults:{cls:"toolbar-menu-icon-item"},items:[{iconCls:"mnu-icon-item mnu-arrange-front",text:this.textArrangeFront,halign:1},{iconCls:"mnu-icon-item mnu-arrange-back",text:this.textArrangeBack,halign:2},{iconCls:"mnu-icon-item mnu-arrange-forward",text:this.textArrangeForward,halign:3},{iconCls:"mnu-icon-item mnu-arrange-backward",text:this.textArrangeBackward,halign:4},{xtype:"menuseparator"},this.mnuGroupShapes=Ext.widget("menuitem",{iconCls:"mnu-icon-item mnu-group",text:this.txtGroup,halign:5}),this.mnuUnGroupShapes=Ext.widget("menuitem",{iconCls:"mnu-icon-item mnu-ungroup",text:this.txtUngroup,halign:6})]}}),this.slideOnlyControls.push(this.btnShapeArrange),this.btnSlideSize=Ext.create("Ext.button.Button",{id:"toolbar-button-slide-size",tooltip:this.tipSlideSize,iconCls:"asc-toolbar-btn btn-slidesize",menu:{showSeparator:!1,id:"toolbar-menu-slide-size",items:[{text:this.mniSlideStandard,cls:"menu-item-noicon",slidetype:0,checked:!1,group:"slidesize"},{text:this.mniSlideWide,cls:"menu-item-noicon",slidetype:1,checked:!1,group:"slidesize"},Ext.widget("menuseparator"),{text:this.mniSlideAdvanced,cls:"menu-item-noicon"}]}}),this.btnFitPage=Ext.widget("menucheckitem",{id:"toolbar-menu-fit-page",text:this.textFitPage,checked:!1,hideOnClick:!0}),this.btnFitWidth=Ext.widget("menucheckitem",{id:"toolbar-menu-fit-width",text:this.textFitWidth,checked:!1,hideOnClick:!0}),this.btnZoomIn=Ext.widget("button",{id:"toolbar-menu-zoomin",cls:"asc-toolbar-btn-zoom",iconCls:"asc-statusbar-btn btn-zoomin"}),this.btnZoomOut=Ext.widget("button",{id:"toolbar-menu-zoomout",cls:"asc-toolbar-btn-zoom",iconCls:"asc-statusbar-btn btn-zoomout"}),this.txtZoom=Ext.widget("label",{id:"toolbar-menu-zoom-text",text:"100%",style:"white-space:nowrap; text-align: center;"}),this.btnHide=Ext.create("Ext.button.Button",{id:"toolbar-button-hide",tooltip:this.tipViewSettings,iconCls:"asc-toolbar-btn btn-hidebars",split:!0}),this.btnAdvSettings=Ext.create("Ext.button.Button",{id:"toolbar-button-settings",tooltip:this.tipAdvSettings,iconCls:"asc-toolbar-btn btn-settings"});var r=function(e,t,n){return Ext.String.format('<div class="toolbar-btn-placeholder x-btn-default-toolbar-small-icon x-btn-default-toolbar-small document-loading" id="{0}" style="{2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"")},i=function(e,t,n,r){return Ext.String.format('<div class="toolbar-btn-placeholder x-btn-default-toolbar-small-icon x-btn-default-toolbar-small document-loading x-btn-split x-btn-split-right{3}" id="{0}" style="width: 34px; {2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"",r?" "+r:"")},s=function(e,t,n,r){return Ext.String.format('<div class="toolbar-btn-large-placeholder x-btn-default-toolbar-large-icon x-btn-default-toolbar-large document-loading x-btn-split x-btn-split-right{3}" id="{0}" style="{2}"><span class="replaceme x-btn-icon asc-toolbar-btn {1}">&nbsp;</span></div>',e,t,n||"",r?" "+r:"")},o=function(e,t){return Ext.String.format('<div class="x-toolbar-separator x-toolbar-item x-toolbar-separator-horizontal manual {0}" style="{1}" role="presentation" tabindex="-1"></div>',e,t||"")},u=function(e,t,n){return Ext.String.format('<div id="{0}" class="x-container storage-combodataview x-container-default x-box-layout-ct toolbar-combo-placeholder x-item-disabled" role="presentation" tabindex="-1" style="{2}"><div class="x-trigger-index-0 x-form-trigger x-form-arrow-trigger x-form-trigger-last x-unselectable" role="button"></div>{1}</div>',e,t||"",n||"")},a=function(e,t,n){return Ext.String.format('<div id="{0}" class="x-container storage-combodataview x-container-default x-box-layout-ct toolbar-dataview-placeholder x-item-disabled" role="presentation" tabindex="-1" style="{1}"><div class="x-btn x-btn-combodataview x-box-item x-btn-default-small" style="height: 44px; margin: 0; top: 4px;"></div></div>',e,n||"")},f=window.localStorage.getItem("pe-compact-toolbar")&&parseInt(window.localStorage.getItem("pe-compact-toolbar"))==1||!1;this.setHeight(f?38:68),this.html=['<div id="id-toolbar-short" style="'+(f?"display: table;":"display: none;")+'width: 100%; height: 22px; margin-top: 3px;" >','<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-short-btn-addslide","btn-addslide","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-changeslide","btn-changeslide","margin: 0 4px 0 0;"),r("id-toolbar-short-btn-preview","btn-preview","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',r("id-toolbar-short-btn-print","btn-print","margin: 0 4px 0 0;"),r("id-toolbar-short-btn-save","btn-save"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',r("id-toolbar-short-btn-undo","btn-undo","margin: 0 4px 0 0;"),r("id-toolbar-short-btn-redo","btn-redo","margin: 0 1px 0 3px;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="width: 200px; margin-top: 2px;">',u("id-toolbar-short-field-fontname","","display: inline; float: left; line-height: 20px; padding: 0; width: 127px; height: 22px; margin-right: 4px;"),u("id-toolbar-short-field-fontsize","","display: inline; float: left; padding: 0; line-height: 20px; width: 59px; height: 22px; margin-right: 2px;"),"</div>","</div>",'<div class="toolbar-group" style="padding-left: 0">','<div class="toolbar-row" style="margin-top: 2px;">',r("id-toolbar-short-btn-bold","btn-bold","margin: 0 2px 0 0;"),r("id-toolbar-short-btn-italic","btn-italic","margin: 0 2px 0 0;"),r("id-toolbar-short-btn-underline","btn-underline","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-fontcolor","btn-fontcolor","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',r("id-toolbar-short-btn-clearstyle","btn-clearstyle","margin: 0 4px 0 0;"),r("id-toolbar-short-btn-copystyle","btn-copystyle","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-setmarkers","btn-setmarkers","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-numbering","btn-numbering","margin: 0 4px 0 0;"),r("id-toolbar-short-btn-decoffset","btn-decoffset","margin: 0 4px 0 2px;"),r("id-toolbar-short-btn-incoffset","btn-incoffset","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-halign","btn-align-left","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-vertalign","btn-valign-middle","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-linespace","btn-linespace","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-arrange-shape","btn-arrange-shape","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-align-shape","btn-align-shape","margin: 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("short"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-insertshape","btn-insertshape","margin: 0 2px 0 0;"),r("id-toolbar-short-btn-text","btn-text","margin: 0 4px 0 0;"),i("id-toolbar-short-btn-inserttable","btn-inserttable","margin: 0 2px 0 0;"),i("id-toolbar-short-btn-insertimage","btn-insertimage","margin: 0 2px 0 0;"),r("id-toolbar-short-btn-inserthyperlink","btn-inserthyperlink","margin: 0 4px 0 0;"),"</div>","</div>",'<div class="toolbar-group" style="width: 100%;"></div>','<div class="toolbar-group">','<div class="toolbar-row" style="margin-top: 2px;">',i("id-toolbar-short-btn-hidebars","btn-hidebars","margin: 0 4px 0 0;"),"</div>","</div>","</div>",'<div id="id-toolbar-full" style="'+(f?"display: none;":"display: table;")+'width: 100%; margin-top: 3px;" >','<div class="toolbar-group" id="id-toolbar-full-group-native">','<div class="toolbar-row">',r("id-toolbar-full-btn-newdocument","btn-newdocument"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-opendocument","btn-opendocument"),"</div>","</div>",'<div class="toolbar-group separator" id="id-toolbar-full-separator-native">',o("long"),"</div>",'<div class="toolbar-group" style="vertical-align: middle;">',s("id-toolbar-full-btn-addslide","btn-addslide"),"</div>",'<div class="toolbar-group" style="padding-left: 4px;">','<div class="toolbar-row">',i("id-toolbar-full-btn-changeslide","btn-changeslide"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-preview","btn-preview"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',r("id-toolbar-full-btn-print","btn-print"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-save","btn-save"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',r("id-toolbar-full-btn-copy","btn-copy","margin: 0 6px 0 0;"),r("id-toolbar-full-btn-paste","btn-paste"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-undo","btn-undo","margin: 0 6px 0 0;"),r("id-toolbar-full-btn-redo","btn-redo"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',u("id-toolbar-full-field-fontname","","display: inline; float: left; line-height: 20px; padding: 0; width: 127px; height: 22px; margin-right: 4px;"),u("id-toolbar-full-field-fontsize","","display: inline; float: left; padding: 0; line-height: 20px; width: 59px; height: 22px;"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-bold","btn-bold","margin: 0 1px 0 0;"),r("id-toolbar-full-btn-italic","btn-italic","margin: 0 2px 0 0;"),r("id-toolbar-full-btn-underline","btn-underline","margin: 0 2px 0 0;"),r("id-toolbar-full-btn-strikeout","btn-strike","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-fontcolor","btn-fontcolor","margin: 0 2px 0 0;"),r("id-toolbar-full-btn-superscript","btn-superscript","margin: 0 2px 0 0;"),r("id-toolbar-full-btn-subscript","btn-subscript","margin: 0 18px 0 0;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',r("id-toolbar-full-btn-clearstyle","btn-clearstyle"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-copystyle","btn-copystyle"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row" style="width:144px;">',i("id-toolbar-full-btn-setmarkers","btn-setmarkers","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-numbering","btn-numbering","margin: 0 8px 0 0;"),o("short","position: absolute; margin-top: 2px;"),r("id-toolbar-full-btn-decoffset","btn-decoffset","margin: 0 8px 0 14px;"),r("id-toolbar-full-btn-incoffset","btn-incoffset"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-halign","btn-align-left","margin: 0 2px 0 0;"),i("id-toolbar-full-btn-vertalign","btn-valign-middle","margin: 0 8px 0 0;"),o("short","position: absolute; margin-top: 2px;"),i("id-toolbar-full-btn-linespace","btn-linespace","margin: 0 2px 0 14px;"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-arrange-shape","btn-arrange-shape"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-align-shape","btn-align-shape"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-insertshape","btn-insertshape","margin: 0 2px 0 0;"),r("id-toolbar-full-btn-text","btn-text","margin: 0 14px 0 0"),r("id-toolbar-full-btn-inserthyperlink","btn-inserthyperlink","margin: 0 0 0 0"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-inserttable","btn-inserttable","margin: 0 2px 0 0"),i("id-toolbar-full-btn-insertimage","btn-insertimage","margin: 0 2px 0 0"),"</div>","</div>",'<div class="toolbar-group separator">',o("long"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-colorschemas","btn-colorschemas"),"</div>",'<div class="toolbar-row">',i("id-toolbar-full-btn-slidesize","btn-slidesize"),"</div>","</div>",'<div class="toolbar-group" id="id-toolbar-full-group-styles" style="width: 100%;">',a("id-toolbar-full-field-styles","","margin: 0 10px; height: 54px;"),"</div>",'<div class="toolbar-group">','<div class="toolbar-row">',i("id-toolbar-full-btn-hidebars","btn-hidebars","margin: 0 5px 0 0;"),"</div>",'<div class="toolbar-row">',r("id-toolbar-full-btn-settings","btn-settings"),"</div>","</div>","</div>"],this.items=[],this.listTheme=Ext.create("Common.component.ComboDataView",{id:"toolbar-combo-view-themes",flex:1,height:54,itemWidth:71,itemHeight:40,menuMaxHeight:500,minWidth:100,repeatedselect:!0,handleGlobalResize:!0,viewData:[]}),this.listTheme.dataMenu.applyContentWidth=!0,this.callParent(arguments)},setApi:function(e){return this.api=e,this.api&&this.api.asc_registerCallback("asc_onCollaborativeChanges",Ext.bind(this._onCollaborativeChanges,this)),this},_onTextColor:function(e){var t;e&&(e.get_type()==c_oAscColor.COLOR_TYPE_SCHEME?t={color:this.getHexColor(e.get_r(),e.get_g(),e.get_b()),effectValue:e.get_value()}:t=this.getHexColor(e.get_r(),e.get_g(),e.get_b()));var n=typeof t,r=typeof this._state.clrtext;if(n!==r||n=="object"&&(t.effectValue!==this._state.clrtext.effectValue||this._state.clrtext.color.indexOf(t.color)<0)||n!="object"&&this._state.clrtext.indexOf(t)<0){this.colorsText.suspendEvents(!1);if(typeof t=="object"){for(var i=0;i<10;i++)if(this.ThemeValues[i]==t.effectValue){this.colorsText.select(t,!1);break}}else this.colorsText.select(t,!1);this.colorsText.resumeEvents(),this._state.clrtext=t}},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},getRgbColor:function(e){var t=typeof e=="object"?e.color:e;t=t.replace(/#/,""),t.length==3&&(t=t.replace(/(.)/g,"$1$1")),t=parseInt(t,16);var n=new CAscColor;return n.put_type(typeof e=="object"?c_oAscColor.COLOR_TYPE_SCHEME:c_oAscColor.COLOR_TYPE_SRGB),n.put_r(t>>16),n.put_g((t&65280)>>8),n.put_b(t&255),n.put_a(255),e.effectId!==undefined&&n.put_value(e.effectId),n},_onSendThemeColors:function(e,t){var n=[];if(t)for(var r=0;r<t.length;r++){var i=this.getHexColor(t[r].get_r(),t[r].get_g(),t[r].get_b());n.push(i)}var s=[],o;for(r=0;r<6;r++)for(var u=0;u<10;u++){var a=r+u*6,i={color:this.getHexColor(e[a].get_r(),e[a].get_g(),e[a].get_b()),effectId:a,effectValue:this.ThemeValues[u]};s.push(i),typeof this.colorsText.currentColor=="object"&&o===undefined&&this.colorsText.currentColor.effectId==a&&(o=i)}this.colorsText.updateColors(s,n),this.colorsText.currentColor===undefined?(this.btnFontColor.setColor(s[1].color,!1),this.colorsText.currentColor=s[1]):o!==undefined&&(this.btnFontColor.setColor(o.color,!1),this.colorsText.currentColor=o)},_onSlideStoreDataChanged:function(){this.btnAddSlide.menu.picker.needArrangeSlideItems=!0,this.btnChangeSlide.menu.picker.needArrangeSlideItems=!0},_arrangeSlideItems:function(){if(!this.needArrangeSlideItems)return;var e=this;if(this.getEl()){var t=this.getEl().down(".jspPane");if(t&&t.getHeight()>0&&this.getEl().getHeight()>0)var n=0,r=setInterval(function(){e.needArrangeSlideItems&&e.resizeSlideItems();if(!e.needArrangeSlideItems){clearInterval(r),e.doLayout();return}n++>5&&clearInterval(r)},100)}},_resizeSlideItems:function(){var e=3,t="div.main-thumb",n=this.getEl(),r=n.query(t),i=0,s=this.itemHeight!==undefined?this.itemHeight:50;while(i<r.length){var o=0;for(var u=i;u<i+e;u++){if(u>=r.length)break;var a=Ext.get(r[u]),f=a.getHeight();if(f<s)return;f<o?a.setHeight(o):o=f}i+=e}r.length>0&&(this.needArrangeSlideItems=!1)},setMode:function(e){e.isDisconnected&&(this.btnNewDocument.setDisabled(!0),this.btnOpenDocument.setDisabled(!0),this.btnAddSlide.setDisabled(!0),this.btnChangeSlide.setDisabled(!0),this.btnSave.setDisabled(!0),this.btnCopy.setDisabled(!0),this.btnPaste.setDisabled(!0),this.btnUndo.setDisabled(!0),this.btnRedo.setDisabled(!0),this.cmbFont.setDisabled(!0),this.cmbFontSize.setDisabled(!0),this.btnBold.setDisabled(!0),this.btnItalic.setDisabled(!0),this.btnUnderline.setDisabled(!0),this.btnStrikeout.setDisabled(!0),this.btnSuperscript.setDisabled(!0),this.btnSubscript.setDisabled(!0),this.btnFontColor.setDisabled(!0),this.btnClearStyle.setDisabled(!0),this.btnCopyStyle.setDisabled(!0),this.btnMarkers.setDisabled(!0),this.btnNumbers.setDisabled(!0),this.btnDecLeftOffset.setDisabled(!0),this.btnIncLeftOffset.setDisabled(!0),this.btnLineSpace.setDisabled(!0),this.btnHorizontalAlign.setDisabled(!0),this.btnVerticalAlign.setDisabled(!0),this.btnShapeArrange.setDisabled(!0),this.btnShapeAlign.setDisabled(!0),this.btnInsertTable.setDisabled(!0),this.btnInsertImage.setDisabled(!0),this.btnInsertText.setDisabled(!0),this.btnInsertHyperlink.setDisabled(!0),this.btnInsertShape.setDisabled(!0),this.btnColorSchemas.setDisabled(!0),this.btnSlideSize.setDisabled(!0),this.listTheme.setDisabled(!0));if(!e.nativeApp){var t=Ext.get("id-toolbar-full-group-native");t&&(t.setVisibilityMode(Ext.Element.DISPLAY),t.hide());var n=Ext.get("id-toolbar-full-separator-native");n&&(n.setVisibilityMode(Ext.Element.DISPLAY),n.hide())}},changeViewMode:function(e){var t=this,n=Ext.get("id-toolbar-full"),r=Ext.get("id-toolbar-short");n&&r&&(e?(r.setStyle({display:"table"}),n.setStyle({display:"none"}),this.setHeight(38),this.rendererComponents("short")):(r.setStyle({display:"none"}),n.setStyle({display:"table"}),this.setHeight(68),this.rendererComponents("full"),Ext.defer(function(){var e=t.listTheme.rendered&&t.listTheme.getEl()&&t.listTheme.getEl().up("#id-toolbar-full-group-styles")&&t.listTheme.getEl().up("#id-toolbar-full-group-styles").isVisible();t.listTheme.dataMenu.picker.store.getCount()>0&&e&&(t.listTheme.doComponentLayout(),t.listTheme.fillComboView(t.listTheme.dataMenu.picker.getSelectedRec(),!0))},100)))},rendererComponents:function(e){var t=this,n=function(e,t){var n=Ext.get(e);if(n&&!n.down("button")){n.removeCls(["x-btn-default-toolbar-small-icon","x-btn-default-toolbar-small","x-btn-disabled","x-btn-split","x-btn-split-right","document-loading"]);var r=n.down("span");r&&r.remove(),t.addCls("x-btn-default-toolbar-small x-btn-default-toolbar-small-icon "),t.rendered?n.dom.appendChild(document.getElementById(t.getId())):t.render(n),t.removeCls(["x-btn-default-small","x-btn-default-small-icon"])}},r=function(e,t){var n=Ext.get(e);if(n&&!n.down("button")){n.removeCls(["x-btn-default-toolbar-large-icon","x-btn-default-toolbar-large","x-btn-disabled","x-btn-split","x-btn-split-right","document-loading"]);var r=n.down("span");r&&r.remove(),t.addCls("x-btn-default-toolbar-large x-btn-default-toolbar-large-icon "),t.rendered?n.dom.appendChild(document.getElementById(t.getId())):t.render(n),t.removeCls(["x-btn-default-large","x-btn-default-large-icon"])}},i=function(e,t){var n=Ext.get(e);if(n&&!n.down("input")){if(/toolbar-combo-placeholder|toolbar-dataview-placeholder/.test(n.dom.className))for(var r=n.dom.childNodes.length,i;r--;)i=n.dom.childNodes[r],i.parentNode.removeChild(i);n.removeCls(["x-container","storage-combodataview","x-container-default","x-box-layout-ct","toolbar-combo-placeholder","toolbar-dataview-placeholder","x-item-disabled"]),t.rendered?n.dom.appendChild(document.getElementById(t.getId())):t.render(n)}},s=e==="short"?"short":"full";n("id-toolbar-"+s+"-btn-newdocument",t.btnNewDocument),n("id-toolbar-"+s+"-btn-opendocument",t.btnOpenDocument),e==="short"?(n("id-toolbar-"+s+"-btn-addslide",t.btnAddSlide),this.btnAddSlide.removeCls("x-btn-default-large"),this.btnAddSlide.removeCls("x-btn-default-large-icon"),this.btnAddSlide.removeCls("x-btn-default-toolbar-large"),this.btnAddSlide.removeCls("x-btn-default-toolbar-large-icon")):(r("id-toolbar-"+s+"-btn-addslide",t.btnAddSlide),this.btnAddSlide.removeCls("x-btn-default-small"),this.btnAddSlide.removeCls("x-btn-default-small-icon"),this.btnAddSlide.removeCls("x-btn-default-toolbar-small"),this.btnAddSlide.removeCls("x-btn-default-toolbar-small-icon")),n("id-toolbar-"+s+"-btn-changeslide",t.btnChangeSlide),n("id-toolbar-"+s+"-btn-preview",t.btnPreview),n("id-toolbar-"+s+"-btn-print",t.btnPrint),n("id-toolbar-"+s+"-btn-save",t.btnSave),n("id-toolbar-"+s+"-btn-copy",t.btnCopy),n("id-toolbar-"+s+"-btn-paste",t.btnPaste),n("id-toolbar-"+s+"-btn-undo",t.btnUndo),n("id-toolbar-"+s+"-btn-redo",t.btnRedo),n("id-toolbar-"+s+"-btn-bold",t.btnBold),n("id-toolbar-"+s+"-btn-italic",t.btnItalic),n("id-toolbar-"+s+"-btn-underline",t.btnUnderline),n("id-toolbar-"+s+"-btn-strikeout",t.btnStrikeout),n("id-toolbar-"+s+"-btn-superscript",t.btnSuperscript),n("id-toolbar-"+s+"-btn-subscript",t.btnSubscript),n("id-toolbar-"+s+"-btn-fontcolor",t.btnFontColor),n("id-toolbar-"+s+"-btn-setmarkers",t.btnMarkers),n("id-toolbar-"+s+"-btn-numbering",t.btnNumbers),n("id-toolbar-"+s+"-btn-halign",t.btnHorizontalAlign),n("id-toolbar-"+s+"-btn-vertalign",t.btnVerticalAlign),n("id-toolbar-"+s+"-btn-arrange-shape",t.btnShapeArrange),n("id-toolbar-"+s+"-btn-align-shape",t.btnShapeAlign),n("id-toolbar-"+s+"-btn-decoffset",t.btnDecLeftOffset),n("id-toolbar-"+s+"-btn-incoffset",t.btnIncLeftOffset),n("id-toolbar-"+s+"-btn-linespace",t.btnLineSpace),n("id-toolbar-"+s+"-btn-inserttable",t.btnInsertTable),n("id-toolbar-"+s+"-btn-insertimage",t.btnInsertImage),n("id-toolbar-"+s+"-btn-text",t.btnInsertText),n("id-toolbar-"+s+"-btn-inserthyperlink",t.btnInsertHyperlink),n("id-toolbar-"+s+"-btn-insertshape",t.btnInsertShape),n("id-toolbar-"+s+"-btn-clearstyle",t.btnClearStyle),n("id-toolbar-"+s+"-btn-copystyle",t.btnCopyStyle),n("id-toolbar-"+s+"-btn-colorschemas",t.btnColorSchemas),n("id-toolbar-"+s+"-btn-slidesize",t.btnSlideSize),n("id-toolbar-"+s+"-btn-hidebars",t.btnHide),n("id-toolbar-"+s+"-btn-settings",t.btnAdvSettings),i("id-toolbar-"+s+"-field-fontname",t.cmbFont),i("id-toolbar-"+s+"-field-fontsize",t.cmbFontSize),i("id-toolbar-"+s+"-field-styles",t.listTheme)},_onCollaborativeChanges:function(){if(!this.btnSave.rendered){this.needShowSynchTip=!0;return}var e=this.btnSave.getEl().down(".asc-toolbar-btn");e.removeCls("btn-save"),e.addCls("btn-synch"),this.showSynchTip&&this.isVisible()?(this.btnSave.setTooltip(""),this.synchTooltip===undefined&&this._createSynchTip(),this.synchTooltip.show()):this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)")},_createSynchTip:function(){var e=this.btnSave.getPosition();e[0]+=this.btnSave.getWidth(),e[1]+=this.btnSave.getHeight()/2,this.synchTooltip=Ext.getBody().createChild({tag:"div",cls:"synch-tip-root",style:"top: "+e[1]+"px; left: "+e[0]+"px; width: 250px;"});if(this.synchTooltip){var t=Ext.widget("commonsynchronizetip",{renderTo:this.synchTooltip});t.getEl().alignTo(this.synchTooltip,"tl"),t.addListener("dontshowclick",function(){this.showSynchTip=!1,this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)"),window.localStorage.setItem("pe-hide-synch",1)},this),t.addListener("closeclick",function(){this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSynchronize+" (Ctrl+S)")},this)}},synchronizeChanges:function(){var e=this.btnSave.getEl().down(".asc-toolbar-btn");e.hasCls("btn-synch")&&(e.removeCls("btn-synch"),e.addCls("btn-save"),this.synchTooltip&&this.synchTooltip.hide(),this.btnSave.setTooltip(this.tipSave+" (Ctrl+S)"))},createDelayedElements:function(){var e=[],t=this,n=window.localStorage.getItem("pe-compact-toolbar")&&parseInt(window.localStorage.getItem("pe-compact-toolbar"))==1||!1;t.rendererComponents(n?"short":"full");var r=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="thumb-wrap">','<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" style="{imgstyle}" />','<tpl if="title">','<span class="title">{title}</span>',"</tpl>","</div>","</tpl>"),i=[{offsety:0,data:{type:0,subtype:-1}},{offsety:38,data:{type:0,subtype:1}},{offsety:76,data:{type:0,subtype:2}},{offsety:114,data:{type:0,subtype:3}},{offsety:152,data:{type:0,subtype:4}},{offsety:190,data:{type:0,subtype:5}},{offsety:228,data:{type:0,subtype:6}},{offsety:266,data:{type:0,subtype:7}}];for(var s=0;s<i.length;s++)i[s].imgstyle=Ext.String.format("background-image:url({0});","resources/img/toolbar/bullets.png"),i[s].imgstyle+=Ext.String.format("background-image:-webkit-image-set(url({0}) 1x, url({1}) 2x);","resources/img/toolbar/bullets.png","resources/img/toolbar/bullets@2x.png"),i[s].imgstyle+=Ext.String.format("background-position:0 {0}px; width:38px; height:38px;",-i[s].offsety);this.btnMarkers.menu=Ext.create("Common.component.MenuDataViewPicker",{width:194,height:108,contentWidth:174,dataTpl:r,viewData:i}),e.push(this.btnMarkers),i=[{offsety:0,data:{type:1,subtype:-1}},{offsety:296,data:{type:1,subtype:4}},{offsety:370,data:{type:1,subtype:5}},{offsety:444,data:{type:1,subtype:6}},{offsety:74,data:{type:1,subtype:1}},{offsety:148,data:{type:1,subtype:2}},{offsety:222,data:{type:1,subtype:3}},{offsety:518,data:{type:1,subtype:7}}];for(var s=0;s<i.length;s++)i[s].imgstyle=Ext.String.format("background-image:url({0});","resources/img/toolbar/numbering.png"),i[s].imgstyle+=Ext.String.format("background-image:-webkit-image-set(url({0}) 1x, url({1}) 2x);","resources/img/toolbar/numbering.png","resources/img/toolbar/numbering@2x.png"),i[s].imgstyle+=Ext.String.format("background-position:0 {0}px; width:74px; height:74px;",-i[s].offsety);this.btnNumbers.menu=Ext.create("Common.component.MenuDataViewPicker",{width:336,height:180,contentWidth:316,dataTpl:r,viewData:i}),e.push(this.btnNumbers),this.btnFontColor.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,items:[this.colorsText=Ext.create("Common.component.ThemeColorPalette",{id:"menu-palette-font-color",value:"000000",width:165,height:214,dynamiccolors:!0,dyncolorscount:10,currentColor:undefined,colors:[t.textThemeColors,"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},"-",{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:3},{color:"FFFFFF",effectId:4},{color:"000000",effectId:5},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},{color:"FFFFFF",effectId:2},{color:"000000",effectId:1},"-","--","-",t.textStandartColors,"-","3D55FE","5301B3","980ABD","B2275F","F83D26","F86A1D","F7AC16","F7CA12","FAFF44","D6EF39","-","--"],listeners:{select:{fn:function(e,n,r){typeof n=="object"?t.btnFontColor.setColor(n.color):t.btnFontColor.setColor(n),Ext.menu.Manager.hideAll(),t.colorsText.currentColor=n,t.api.put_TextColor(t.getRgbColor(n)),Common.component.Analytics.trackEvent("ToolBar","Text Color")}}}}),{cls:"menu-item-noicon menu-item-color-palette-theme",text:this.textNewColor,listeners:{click:function(e,n){t.colorsText.addNewColor()}}}],listeners:{hide:function(){t.fireEvent("editcomplete",t)}}}),e.push(this.btnFontColor),this.btnColorSchemas.menu=Ext.create("Ext.menu.Menu",{showSeparator:!1,id:"toolbar-menu-color-schemas",items:[]}),e.push(this.btnColorSchemas);var o=Ext.create("Ext.XTemplate",'<tpl for=".">','<div class="main-thumb">','<div class="thumb-wrap">','<img src="{imageUrl}" />',"</div>",'<tpl if="title">','<div class="caption"','<tpl if="itemWidth">',' style="width:{itemWidth}px;"',"</tpl>","><span>{title}</span></div>","</tpl>","</div>","</tpl>"),u=Ext.getStore("SlideLayouts");u.on("datachanged",t._onSlideStoreDataChanged,t),this.btnAddSlide.menu=Ext.create("Common.component.MenuDataViewPicker",{width:421,height:320,dataTpl:o,cls:"slide-picker",store:u,viewData:[],contentWidth:401,arrangeItems:t._arrangeSlideItems,resizeSlideItems:t._resizeSlideItems,listeners:{select:Ext.bind(function(e,t){this.api&&(this.api.AddSlide(t.data.data.idx),this.fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Add Slide"))},this),hide:function(){t.fireEvent("editcomplete",t)},show:function(e){e.picker.selectByIndex(-1,!1)},beforeshow:Ext.bind(function(e){if(e.rendered){var t=e.picker.contentWidth,n=e.picker.store.getCount()>0?e.picker.store.getAt(0):null;if(n){var r=n.data.itemWidth*3+64;t!==r-20&&(e.picker.itemHeight=n.data.itemHeight,e.picker.contentWidth=r-20,e.setWidth(r))}}},t)}}),e.push(this.btnAddSlide),this.btnChangeSlide.menu=Ext.create("Common.component.MenuDataViewPicker",{width:421,height:320,dataTpl:o,cls:"slide-picker",store:u,viewData:[],contentWidth:401,arrangeItems:t._arrangeSlideItems,resizeSlideItems:t._resizeSlideItems,listeners:{select:Ext.bind(function(e,t){this.api&&(this.api.ChangeLayout(t.data.data.idx),this.fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Change Layout"))},this),hide:function(){t.fireEvent("editcomplete",t)},show:function(e){e.picker.selectByIndex(-1,!1)},beforeshow:Ext.bind(function(e){if(e.rendered){var t=e.picker.contentWidth,n=e.picker.store.getCount()>0?e.picker.store.getAt(0):null;if(n){var r=n.data.itemWidth*3+64;t!==r-20&&(e.picker.itemHeight=n.data.itemHeight,e.picker.contentWidth=r-20,e.setWidth(r))}}},t)}}),e.push(this.btnChangeSlide);var a=window.localStorage.getItem("pe-compact-toolbar"),f=a!==null&&parseInt(a)==1;a=window.localStorage.getItem("pe-hidden-title");var l=a!==null&&parseInt(a)==1;a=window.localStorage.getItem("pe-hidden-status");var c=a!==null&&parseInt(a)==1;this.btnHide.menu=Ext.create("Ext.menu.Menu",{id:"menu-hide-bars",showSeparator:!1,defaults:{checked:!1,targetbar:undefined,hideOnClick:!0},items:[{id:"mnu-hide-bars-toolbar",text:this.textCompactView,checked:f},{text:this.textHideStatusBar,checked:c,checkHandler:function(e,n){e.targetbar===undefined&&(e.targetbar=Ext.ComponentQuery.query("documentstatusinfo")[0]),e.targetbar&&(n?e.targetbar.hide():e.targetbar.show()),window.localStorage.setItem("pe-hidden-status",n?1:0),t.fireEvent("editcomplete",t)}},{xtype:"menuseparator"},this.btnFitPage,this.btnFitWidth,{xtype:"container",layout:{type:"hbox",align:"middle"},width:165,style:"font-size:11px; padding:6px 2px 3px 32px;",items:[{xtype:"label",text:t.textZoom},{xtype:"tbspacer",flex:1},this.btnZoomOut,{xtype:"tbspacer",width:1},this.txtZoom,this.btnZoomIn,{xtype:"tbspacer",width:5}]}]}),e.push(this.btnHide);for(s=0;s<e.length;s++){var h=e[s];h.menu.ownerCt=h,h.mon(e[s].menu,{scope:h,show:h.onMenuShow,hide:h.onMenuHide}),h.rendered&&h.initAria()}var p=[{sizevalue:8,sizestring:"8"},{sizevalue:9,sizestring:"9"},{sizevalue:10,sizestring:"10"},{sizevalue:11,sizestring:"11"},{sizevalue:12,sizestring:"12"},{sizevalue:14,sizestring:"14"},{sizevalue:16,sizestring:"16"},{sizevalue:18,sizestring:"18"},{sizevalue:20,sizestring:"20"},{sizevalue:22,sizestring:"22"},{sizevalue:24,sizestring:"24"},{sizevalue:26,sizestring:"26"},{sizevalue:28,sizestring:"28"},{sizevalue:36,sizestring:"36"},{sizevalue:48,sizestring:"48"},{sizevalue:72,sizestring:"72"}];this.cmbFontSize.store.loadData(p),this.api&&this.api.asc_registerCallback("asc_onTextColor",Ext.bind(this._onTextColor,this)),this.needShowSynchTip&&(this.needShowSynchTip=!1,this._onCollaborativeChanges())},textBold:"Bold",textItalic:"Italic",textUnderline:"Underline",textStrikeout:"Strikeout",textSuperscript:"Superscript",textSubscript:"Subscript",tipFontName:"Font Name",tipFontSize:"Font Size",tipCopy:"Copy",tipPaste:"Paste",tipUndo:"Undo",tipRedo:"Redo",tipPrint:"Print",tipSave:"Save",tipFontColor:"Font color",tipMarkers:"Bullets",tipNumbers:"Numbering",tipBack:"Back",tipClearStyle:"Clear Style",tipCopyStyle:"Copy Style",textTitleError:"Error",tipHAligh:"Horizontal Align",tipVAligh:"Vertical Align",textAlignTop:"Align text to the top",textAlignMiddle:"Align text to the middle",textAlignBottom:"Align text to the bottom",textAlignLeft:"Left align text",textAlignRight:"Right align text",textAlignCenter:"Center text",textAlignJust:"Justify",tipDecPrLeft:"Decrease Indent",tipIncPrLeft:"Increase Indent",tipLineSpace:"Line Spacing",tipInsertTable:"Insert Table",tipInsertImage:"Insert Picture",mniImageFromFile:"Picture from file",mniImageFromUrl:"Picture from url",mniCustomTable:"Insert Custom Table",tipInsertHyperlink:"Add Hyperlink",tipInsertText:"Insert Text",tipInsertShape:"Insert Autoshape",tipPreview:"Start Preview",tipAddSlide:"Add Slide",tipNewDocument:"New Document",tipOpenDocument:"Open Document",tipShapeAlign:"Align Shape",tipShapeArrange:"Arrange Shape",textShapeAlignLeft:"Align Left",textShapeAlignRight:"Align Right",textShapeAlignCenter:"Align Center",textShapeAlignTop:"Align Top",textShapeAlignBottom:"Align Bottom",textShapeAlignMiddle:"Align Middle",textArrangeFront:"Bring To Front",textArrangeBack:"Send To Back",textArrangeForward:"Bring Forward",textArrangeBackward:"Send Backward",txtGroup:"Group",txtUngroup:"Ungroup",txtDistribHor:"Distribute Horizontally",txtDistribVert:"Distribute Vertically",tipChangeSlide:"Change Slide Layout",textOK:"OK",textCancel:"Cancel",tipColorSchemas:"Change Color Scheme",textNewColor:"Add New Custom Color",textThemeColors:"Theme Colors",textStandartColors:"Standart Colors",mniSlideStandard:"Standard (4:3)",mniSlideWide:"Widescreen (16:9)",mniSlideAdvanced:"Advanced Settings",tipSlideSize:"Select Slide Size",tipViewSettings:"View Settings",tipAdvSettings:"Advanced Settings",textCompactView:"View Compact Toolbar",textHideTitleBar:"Hide Title Bar",textHideStatusBar:"Hide Status Bar",textFitPage:"Fit Slide",textFitWidth:"Fit Width",textZoom:"Zoom",tipInsertChart:"Insert Chart",textLine:"Line Chart",textColumn:"Column Chart",textBar:"Bar Chart",textArea:"Area Chart",textPie:"Pie Chart",textPoint:"Point Chart",textStock:"Stock Chart",tipSynchronize:"The document has been changed by another user. Please click to save your changes and reload the updates."}),Ext.define("PE.controller.Toolbar",{extend:"Ext.app.Controller",requires:["Common.view.ImageFromUrlDialog","Common.view.CopyWarning","PE.view.HyperlinkSettings","PE.view.InsertTableDialog","PE.view.SlideSizeSettings","Common.component.MenuDataViewPicker","Ext.data.Store","Common.plugin.MenuExpand","Ext.util.Cookies"],views:["Toolbar"],refs:[{ref:"toolbar",selector:"petoolbar"},{ref:"cmbFontSize",selector:"#toolbar-combo-font-size"},{ref:"menuLineSpace",selector:"#toolbar-menu-line-space"},{ref:"listTheme",selector:"#toolbar-combo-view-themes"},{ref:"btnInsertShape",selector:"#toolbar-button-insert-shape"},{ref:"btnHorizontalAlign",selector:"#toolbar-button-halign"},{ref:"btnVerticalAlign",selector:"#toolbar-button-valign"}],flg:{},init:function(){this._state={ThemeIdx:0,bullets:{type:undefined,subtype:undefined},undo:undefined,redo:undefined,prcontrolsdisable:undefined,slidecontrolsdisable:undefined,slidelayoutdisable:undefined,shapecontrolsdisable:undefined,prstyleNoStyles:!0},this._isAddingShape=!1,this.SchemeNames=[this.txtScheme1,this.txtScheme2,this.txtScheme3,this.txtScheme4,this.txtScheme5,this.txtScheme6,this.txtScheme7,this.txtScheme8,this.txtScheme9,this.txtScheme10,this.txtScheme11,this.txtScheme12,this.txtScheme13,this.txtScheme14,this.txtScheme15,this.txtScheme16,this.txtScheme17,this.txtScheme18,this.txtScheme19,this.txtScheme20,this.txtScheme21],this.slideSizeArr=[[254,190.5],[254,143],[254,158.7],[254,190.5],[338.3,253.7],[355.6,266.7],[275,190.5],[300.7,225.5],[199.1,149.3],[285.7,190.5],[254,190.5],[203.2,25.4]],this.currentPageSize={type:-1,width:0,height:0},this.control({petoolbar:{afterrender:function(){var e=this.getToolbar().ownerCt;Ext.isDefined(e)&&e.addListener("resize",Ext.bind(this.resizeToolbar,this))}},"#toolbar-combo-fonts":{select:function(e,t,n){this.api&&this.api.put_TextPrFontName(t[0].data.name),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Font Name")},collapse:function(e,t){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-combo-font-size":{select:this._fontsizeSelect,beforequery:this._fontsizeBeforeQuery,collapse:this._fontsizeCollapse,specialkey:this._fontsizeSpecialKey},"#toolbar-button-bold":{click:this._clickBold},"#toolbar-button-italic":{click:this._clickItalic},"#toolbar-button-underline":{click:this._clickUnderline},"#toolbar-strikeout":{click:this._clickStrikeout},"#toolbar-button-superscript":{click:this._clickSuperscript},"#toolbar-button-subscript":{click:this._clickSubscript},"#toolbar-button-print":{click:this._handlePrint},"#toolbar-button-save":{click:this._handleSave},"#toolbar-button-copy":{click:{fn:this.handleCopyPaste,action:"copy"}},"#toolbar-button-paste":{click:{fn:this.handleCopyPaste,action:"paste"}},"#toolbar-button-undo":{click:this._handleUndo},"#toolbar-button-redo":{click:this._handleRedo},"#toolbar-button-clear-style":{click:function(e){this.api&&this.api.ClearFormating(),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-copy-style":{click:function(e){this.api&&this.api.SetPaintFormat(e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-btn-markers":{click:function(e){var t={data:{data:{type:0,subtype:e.pressed?0:-1}}};this._onSelectBullets(e.menu.picker,t,e.id,e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-btn-numbering":{click:function(e){var t={data:{data:{type:1,subtype:e.pressed?0:-1}}};this._onSelectBullets(e.menu.picker,t,e.id,e.pressed),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-dec-left-offset":{click:function(e){this.api&&this.api.DecreaseIndent(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Indent")}},"#toolbar-button-inc-left-offset":{click:function(e){this.api&&this.api.IncreaseIndent(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Indent")}},"#toolbar-menu-line-space":{hide:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-line-space menuitem":{click:function(e){this.api&&this.api.put_PrLineSpacing(c_paragraphLinerule.LINERULE_AUTO,e.linespace),Common.component.Analytics.trackEvent("ToolBar","Line Spacing")}},"#toolbar-menu-horalign":{click:this._handleHorizontalAlign},"#toolbar-menu-vertalign":{click:this._handleVerticalAlign},"#toolbar-menu-horalign menuitem":{beforecheckchange:function(e){e.checked||this._clearChecked(this.getBtnHorizontalAlign().menu.items.items)}},"#toolbar-menu-insert-table":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-insert-table pedimensionpicker":{beforerender:function(e){if(e.stalign=="top"){var t=e.renderTpl.splice(6,1);e.renderTpl.splice(1,0,t[0])}},select:function(e,t,n){this.api&&(this.getToolbar().fireEvent("inserttable",this.getToolbar()),this.api.put_Table(t,n)),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Ext.menu.Manager.hideAll(),Common.component.Analytics.trackEvent("ToolBar","Table")},afterrender:function(e){$("#"+e.id).mouseleave(function(){Ext.getCmp(this.id).setTableSize(0,0)})}},"#toolbar-insert-custom-table":{click:function(e){var t=Ext.create("PE.view.InsertTableDialog",{}),n=this;t.addListener("onmodalresult",function(e,t,r){t&&n.api&&(n.getToolbar().fireEvent("inserttable",n.getToolbar()),n.api.put_Table(r[0],r[1])),n.getToolbar().fireEvent("editcomplete",n.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Table")},!1),t.show()}},"#toolbar-menu-insertimage":{click:function(e,t,n){t.from=="file"?(this.getToolbar().fireEvent("insertimage",this.getToolbar()),this.api&&this.api.AddImage(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Image")):this._mnuOpenImageFromURL()},hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-insert-hyperlink":{click:function(e){this._handleHyperlinkOptions()}},"#toolbar-button-newdocument":{click:function(e){this.api&&this.api.OpenNewDocument(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","New Document")}},"#toolbar-button-opendocument":{click:function(e){this.api&&this.api.LoadDocumentFromDisk(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Open Document")}},"#toolbar-combo-view-themes":{select:function(e,t){this.api&&this.api.ChangeTheme(t.data.data.themeId),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Style")},menuhide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},releasecapture:function(e){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},render:function(e){this.themes&&(this._onInitEditorThemes(this.themes[0],this.themes[1]),delete this.themes)}},"#toolbar-button-preview":{click:function(e){var t=Ext.getCmp("pe-preview");t&&(t.setPosition(0,0),t.setSize(Ext.getBody().getWidth(),Ext.getBody().getHeight()),t.show(),Ext.getCmp("pe-applicationUI").hide());if(this.api){var n=this.api.getCurrentPage();this.api.StartDemonstration("presentation-preview",Ext.isNumber(n)?n:0),Common.component.Analytics.trackEvent("ToolBar","Preview")}}},"#toolbar-button-insert-shape":{click:function(e){e.pressed?this.getToolbar().btnInsertText.pressed&&(this.getToolbar().btnInsertText.toggle(!1,!0),this.api&&this._addAutoshape(!1)):(this.api&&this._addAutoshape(!1),e.hideMenu(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()))},afterrender:Ext.bind(function(e){e.getEl().on("mousedown",function(e,t,n){this._toggleFromMenuHide=!1},this)},this)},"#toolbar-menu-insert-shape":{hide:function(){this.getBtnInsertShape().pressed&&!this._isAddingShape&&this._toggleFromMenuHide&&(this._toggleFromMenuHide=!1,this.getBtnInsertShape().toggle(!1,!1)),this._isAddingShape=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar())},show:function(){this._toggleFromMenuHide=!0}},"#toolbar-button-insert-text":{click:function(e){this.api&&this._addAutoshape(e.pressed,"textRect"),this.getBtnInsertShape().pressed&&this.getBtnInsertShape().toggle(!1,!0),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Add Text")}},"#toolbar-menu-color-schemas":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-shape-align":{click:this._handleShapeAlign},"#toolbar-menu-shape-arrange":{click:this._handleShapeArrange},"#toolbar-menu-slide-size":{click:function(e,t,n){t.slidetype!==undefined?(this.currentPageSize={type:t.slidetype,width:this.slideSizeArr[t.slidetype][0],height:this.slideSizeArr[t.slidetype][1]},this.api&&this.api.changeSlideSize(this.slideSizeArr[t.slidetype][0],this.slideSizeArr[t.slidetype][1]),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Slide Size")):this._mnuOpenSlideSize()},hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-button-settings":{click:function(){Ext.menu.Manager.hideAll();var e=!1,t=Ext.getCmp("main-menu-file-options");t&&(t.activeBtn===t.btnDocumentSettings&&(e=!0),t.activeBtn=t.btnDocumentSettings);var n=Ext.getCmp("view-main-menu");n&&(n.currentFullScaleMenuBtn==undefined||n.currentFullScaleMenuBtn.id!="id-menu-file"?n.selectMenu("menuFile","menuSlides"):e?n.closeFullScaleMenu():t._onShow())}},"#toolbar-menu-fit-page":{click:function(e){this.api&&(e.checked?this.api.zoomFitToPage():this.api.zoomCustomMode()),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-fit-width":{click:function(e){this.api&&(e.checked?this.api.zoomFitToWidth():this.api.zoomCustomMode()),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoomin":{click:function(){this.api&&this.api.zoomIn(),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoomout":{click:function(){this.api&&this.api.zoomOut(),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#toolbar-menu-zoom-text":{afterrender:function(e){e.setWidth(Ext.util.TextMetrics.measure(e.getEl(),"100%").width)}},"#menu-hide-bars":{hide:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},"#mnu-hide-bars-toolbar":{click:function(e){this.getToolbar().changeViewMode(e.checked),window.localStorage.setItem("pe-compact-toolbar",e.checked?1:0),this._state.prstyleNoStyles&&!e.checked&&this.getListTheme().dataMenu.picker.store.getCount()>0&&this.getListTheme().selectByIndex(this._state.ThemeIdx>=0?this._state.ThemeIdx:0),this._state.prstyleNoStyles=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar())}}})},_onLongActionBegin:function(e,t){switch(t){case c_oAscAsyncAction.Save:this.getToolbar().btnSave.disable(),Ext.ComponentQuery.query("pefile")[0].btnSave.disable()}},_onLongActionEnd:function(e,t){switch(t){case c_oAscAsyncAction.Save:this.getToolbar().btnSave.enable(),Ext.ComponentQuery.query("pefile")[0].btnSave.enable()}},setApi:function(e){this.api=e},resizeToolbar:function(e,t,n){var r=this.getToolbar().getWidth();r!==t&&this.getToolbar().setWidth(t),this.shapeMenuExpandLeft=t<1072},_getApiTextSize:function(){var e=12,t=this.api.get_TextProps();return t&&t.get_TextPr&&(e=t.get_TextPr().get_FontSize()),e},_fontsizeCollapse:function(e,t){if(!this.flg.setFontSize){var n=e.getRawValue(),r=this._getApiTextSize();r&&n!=r&&(e.getStore().clearFilter(!1),e.setValue(r)),this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},_fontsizeSelect:function(e,t,n){this.flg.setFontSize=!0,this.api&&this.api.put_TextPrFontSize(t[0].data.sizevalue),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),this.flg.setFontSize=!1,Common.component.Analytics.trackEvent("ToolBar","Font Size")},_fontsizeBeforeQuery:function(e,t){e.forceAll=!0,e.cancel=!0,e.combo.expand();var n=e.combo.getPicker(),r=e.combo.store.find("sizestring",e.query,undefined,undefined,undefined,!0);if(r<0)n.clearHighlight(),n.highlightedItem=undefined;else{var i=e.combo.store.getAt(r);(i=n.getNode(i))&&n.highlightItem(i)}},_fontsizeSpecialKey:function(e,t,n){if(t.getKey()==t.ENTER){var r=e.getPicker().highlightedItem,i=!1;if(r)var s=[e.getPicker().getRecord(r).data.sizestring];else s=/^\+?(\d*\.?\d+)$|^\+?(\d+\.?\d*)$/.exec(e.getValue()),s?(s=s[0]?parseFloat(s[0]):parseFloat(s[1]),s=s>100?100:s<1?1:Math.floor((s+.4)*2)/2):(s=this._getApiTextSize(),i=!0);this.flg.setFontSize=!0,e.getStore().clearFilter(!1),e.setRawValue(s),e.collapse(),i?Ext.Msg.show({title:this.textWarning,msg:this.textFontSizeErr,icon:Ext.Msg.WARNING,buttons:Ext.Msg.OK,fn:function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},scope:this}):this.api.put_TextPrFontSize(s),this.flg.setFontSize=!1,this.getToolbar().fireEvent("editcomplete",this.getToolbar())}},_onFontSize:function(e){if(!this.flg.setFontSize&&e!==undefined){var t=String(e);this.getCmbFontSize().getValue()!=t&&this.getCmbFontSize().setValue(t)}},_onBold:function(e){this.getToolbar().btnBold.toggle(e,!0)},_clickBold:function(e){this.api&&this.api.put_TextPrBold(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Bold")},_onItalic:function(e){this.getToolbar().btnItalic.toggle(e,!0)},_clickItalic:function(e){this.api&&this.api.put_TextPrItalic(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Italic")},_onUnderline:function(e){this.getToolbar().btnUnderline.toggle(e,!0)},_clickUnderline:function(e){this.api&&this.api.put_TextPrUnderline(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Underline")},_onStrikeout:function(e){this.getToolbar().btnStrikeout.toggle(e,!0)},_clickStrikeout:function(e){this.api&&this.api.put_TextPrStrikeout(e.pressed),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Strikeout")},_onSubScript:function(e){this.getToolbar().btnSuperscript.toggle(!1,!0),this.getToolbar().btnSubscript.toggle(!1,!0);switch(e){case 1:this.getToolbar().btnSuperscript.toggle(!0,!0);break;case 2:this.getToolbar().btnSubscript.toggle(!0,!0)}},_clickSuperscript:function(e){this.getToolbar().btnSubscript.pressed||(this.api&&this.api.put_TextPrBaseline(e.pressed?1:0),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Superscript"))},_clickSubscript:function(e){this.getToolbar().btnSuperscript.pressed||(this.api&&this.api.put_TextPrBaseline(e.pressed?2:0),this.getToolbar().fireEvent("editcomplete",this),Common.component.Analytics.trackEvent("ToolBar","Subscript"))},_handlePrint:function(e){this.api&&this.api.asc_Print(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("Print"),Common.component.Analytics.trackEvent("ToolBar","Print")},_handleSave:function(e){this.api&&this.api.asc_Save(),Common.component.Analytics.trackEvent("Save"),Common.component.Analytics.trackEvent("ToolBar","Save"),this.getToolbar().fireEvent("editcomplete",this.getToolbar())},handleCopyPaste:function(e,t,n){var r=this;r.api&&n.action=="copy"&&!r.api.Copy()||n.action=="paste"&&!r.api.Paste()?(Ext.create("Common.view.CopyWarning",{listeners:{close:function(e,t){r.getToolbar().fireEvent("editcomplete",r.getToolbar())}}}).show(),Common.component.Analytics.trackEvent("ToolBar","Copy Warning")):r.getToolbar().fireEvent("editcomplete",r.getToolbar())},_handleUndo:function(e){this.api&&this.api.Undo(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Undo")},_handleRedo:function(e){this.api&&this.api.Redo(),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Redo")},_onCanRevert:function(e,t){t=="undo"?(this._state.undo!==e&&this.getToolbar().btnUndo.setDisabled(!e),this._state.undo=e):(this._state.redo!==e&&this.getToolbar().btnRedo.setDisabled(!e),this._state.redo=e)},_onStyleChange:function(e){this.getToolbar().btnCopyStyle.toggle(e,!0)},_onSelectBullets:function(e,t,n,r){this._clearBullets();var i=Ext.getCmp(n);i&&(typeof r=="boolean"?i.toggle(r,!0):i.toggle(!(t.data.data.subtype<0),!0)),this.api&&this.api.put_ListType(t.data.data.type,t.data.data.subtype),Common.component.Analytics.trackEvent("ToolBar","List Type")},_clearBullets:function(){this.getToolbar().btnMarkers.toggle(!1,!0),this.getToolbar().btnNumbers.toggle(!1,!0),this.getToolbar().btnMarkers.menu.picker.selectByIndex(0),this.getToolbar().btnNumbers.menu.picker.selectByIndex(0)},_onBullets:function(e){if(this._state.bullets.type!=e.get_ListType()||this._state.bullets.subtype!=e.get_ListSubType()){this._state.bullets.type=e.get_ListType(),this._state.bullets.subtype=e.get_ListSubType(),this._clearBullets();if(this._state.bullets.type==0)this.getToolbar().btnMarkers.toggle(!0,!0),this.getToolbar().btnMarkers.menu.picker.selectByIndex(this._state.bullets.subtype);else if(this._state.bullets.type==1){var t=0;switch(this._state.bullets.subtype){case 1:t=4;break;case 2:t=5;break;case 3:t=6;break;case 4:t=1;break;case 5:t=2;break;case 6:t=3;break;case 7:t=7}this.getToolbar().btnNumbers.toggle(!0,!0),this.getToolbar().btnNumbers.menu.picker.selectByIndex(t)}}},_oncanIncreaseIndent:function(e){var t=!e||this._state.prcontrolsdisable;this.getToolbar().btnIncLeftOffset.isDisabled()!==t&&this.getToolbar().btnIncLeftOffset.setDisabled(t)},_oncanDecreaseIndent:function(e){var t=!e||this._state.prcontrolsdisable;this.getToolbar().btnDecLeftOffset.isDisabled()!==t&&this.getToolbar().btnDecLeftOffset.setDisabled(t)},_onLineSpacing:function(e){if(e.get_Line()===null||e.get_LineRule()===null||e.get_LineRule()!=1){Ext.each(this.getMenuLineSpace().items.items,function(e){e.setChecked(!1,!0)},this);return}var t=e.get_Line();Math.abs(t-1)<1e-4?this.getMenuLineSpace().items.items[0].setChecked(!0,!0):Math.abs(t-1.15)<1e-4?this.getMenuLineSpace().items.items[1].setChecked(!0,!0):Math.abs(t-1.5)<1e-4?this.getMenuLineSpace().items.items[2].setChecked(!0,!0):Math.abs(t-2)<1e-4?this.getMenuLineSpace().items.items[3].setChecked(!0,!0):Math.abs(t-2.5)<1e-4?this.getMenuLineSpace().items.items[4].setChecked(!0,!0):Math.abs(t-3)<1e-4?this.getMenuLineSpace().items.items[5].setChecked(!0,!0):Ext.each(this.getMenuLineSpace().items.items,function(e){e.setChecked(!1,!0)},this)},_clearChecked:function(e){for(var t=0;t<e.length;t++)e[t].setChecked(!1,!0)},_handleHorizontalAlign:function(e,t,n){this.getBtnHorizontalAlign().removeCls(this.getBtnHorizontalAlign().icls),this.getBtnHorizontalAlign().icls=t.checked?t.icls:"halign-left",this.getBtnHorizontalAlign().addCls(this.getBtnHorizontalAlign().icls),this.api&&this.api.put_PrAlign(t.checked?t.halign:"none"),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Horizontal Align")},_handleVerticalAlign:function(e,t,n){this.getBtnVerticalAlign().removeCls(this.getBtnVerticalAlign().icls),this.getBtnVerticalAlign().icls=t.icls,this.getBtnVerticalAlign().addCls(this.getBtnVerticalAlign().icls),this.api&&this.api.setVerticalAlign(t.valign),this.getToolbar().fireEvent("editcomplete",this.getToolbar()),Common.component.Analytics.trackEvent("ToolBar","Vertical Align")},_onParagraphAlign:function(e){var t=-1,n;switch(e){case 0:t=2,n="halign-right";break;case 1:t=0,n="halign-left";break;case 2:t=1,n="halign-center";break;case 3:t=3,n="halign-just";break;default:t=-255,n="halign-left"}t<0?t==-255&&this._clearChecked(this.getBtnHorizontalAlign().menu.items.items):this.getBtnHorizontalAlign().menu.items.items[t].setChecked(!0),this.getBtnHorizontalAlign().removeCls(this.getBtnHorizontalAlign().icls),this.getBtnHorizontalAlign().icls=n,this.getBtnHorizontalAlign().addCls(n)},_onVerticalTextAlign:function(e){var t=-1,n="";switch(e){case c_oAscVerticalTextAlign.TEXT_ALIGN_TOP:t=0,n="valign-top";break;case c_oAscVerticalTextAlign.TEXT_ALIGN_CTR:t=1,n="valign-middle";break;case c_oAscVerticalTextAlign.TEXT_ALIGN_BOTTOM:t=2,n="valign-bottom";break;default:t=-255,n="valign-middle"}t<0?t==-255&&this._clearChecked(this.getBtnVerticalAlign().menu.items.items):this.getBtnVerticalAlign().menu.items.items[t].setChecked(!0),this.getBtnVerticalAlign().removeCls(this.getBtnVerticalAlign().icls),this.getBtnVerticalAlign().icls=n,this.getBtnVerticalAlign().addCls(n)},_mnuOpenImageFromURL:function(){var e=Ext.create("Common.view.ImageFromUrlDialog",{});e.addListener("onmodalresult",Ext.bind(this._onOpenImageFromURL,[this,e]),!1),e.addListener("close",Ext.bind(function(e,t){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)),e.show()},_onOpenImageFromURL:function(e){var t=this[0],n=this[1].txtUrl;if(e==1&&t.api){var r=n.value.replace(/ /g,"");r!=""?(t.getToolbar().fireEvent("insertimage",t.getToolbar()),t.api.AddImageUrl(n.value),Common.component.Analytics.trackEvent("ToolBar","Image")):Ext.MessageBox.show({msg:t.textEmptyImgUrl,buttons:Ext.Msg.OK,icon:Ext.Msg.ERROR,width:300,fn:Ext.bind(function(e,n,r){t.getToolbar().fireEvent("editcomplete",t.getToolbar())},t)})}},_handleHyperlinkOptions:function(e){var t,n,r=this;if(r.api){var i=r.api.can_AddHyperlink();if(i!==!1){var s=[];for(var o=0;o<r.api.getCountPages();o++)s.push(o+1);t=Ext.create("PE.view.HyperlinkSettings",{slides:s}),n=new CHyperlinkProperty,n.put_Text(i),t.setSettings(n,r.api.getCurrentPage())}}t&&(t.addListener("onmodalresult",function(e){e==1&&(n=t.getSettings(),r.api.add_Hyperlink(n)),r.getToolbar().fireEvent("editcomplete",r.getToolbar())},!1),t.addListener("close",function(){r.getToolbar().fireEvent("editcomplete",r.getToolbar())}),t.show()),Common.component.Analytics.trackEvent("ToolBar","Add Hyperlink")},_onCanAddHyperlink:function(e){var t=!e||this._state.prcontrolsdisable;t!==this.getToolbar().btnInsertHyperlink.isDisabled()&&this.getToolbar().btnInsertHyperlink.setDisabled(t)},_onInitEditorThemes:function(e,t){var n=this;if(!n.getListTheme()){n.themes=[e,t];return}var r=[],i=[];r=r.concat(e),i=i.concat(t),n.getListTheme().dataMenu.picker.store.removeAll(),Ext.each(r,function(e){n.getListTheme().dataMenu.picker.store.add({imageUrl:e.get_Image(),uid:Ext.id(),data:{themeId:e.get_Index()}})}),Ext.each(i,function(e){n.getListTheme().dataMenu.picker.store.add({imageUrl:e.get_Image(),uid:Ext.id(),data:{themeId:e.get_Index()}})});var s=n.getListTheme().rendered&&n.getListTheme().getEl()&&n.getListTheme().getEl().up("#id-toolbar-full-group-styles")&&n.getListTheme().getEl().up("#id-toolbar-full-group-styles").isVisible();n.getListTheme().dataMenu.picker.store.getCount()>0&&s&&(n.getListTheme().fillComboView(n.getListTheme().dataMenu.picker.store.getAt(0),!0),n.getListTheme().selectByIndex(0))},_onUpdateThemeIndex:function(e){if(this._state.ThemeIdx!==e){this._state.ThemeIdx=e;var t=this.getListTheme().rendered&&this.getListTheme().getEl()&&this.getListTheme().getEl().up("#id-toolbar-full-group-styles")&&this.getListTheme().getEl().up("#id-toolbar-full-group-styles").isVisible();t&&(this.getListTheme().suspendEvents(!1),e<this.getListTheme().dataMenu.picker.store.getCount()&&this.getListTheme().selectByIndex(e),this.getListTheme().resumeEvents())}},_onEndAddShape:function(){this.getToolbar().fireEvent("insertshape",this.getToolbar()),this.getBtnInsertShape().pressed&&this.getBtnInsertShape().toggle(!1,!0),this.getToolbar().btnInsertText.pressed&&this.getToolbar().btnInsertText.toggle(!1,!0),Ext.FocusManager.removeListener("componentfocus",this.checkInsertAutoshape,this)},_addAutoshape:function(e,t){e?(this.api.StartAddShape(t,!0),Ext.FocusManager.addListener("componentfocus",this.checkInsertAutoshape,this)):(this.api.StartAddShape("",!1),Ext.FocusManager.removeListener("componentfocus",this.checkInsertAutoshape,this))},checkInsertAutoshape:function(e,t){(this.getToolbar().btnInsertText.pressed||this.getBtnInsertShape().pressed)&&t.id!="editor_sdk"&&(this.getToolbar().btnInsertText.pressed&&t.id!=this.getToolbar().btnInsertText.id||this.getBtnInsertShape().pressed&&t.id!=this.getBtnInsertShape().id)&&(this._toggleFromMenuHide=!1,this._isAddingShape=!1,this._addAutoshape(!1),this.getBtnInsertShape().toggle(!1,!1),this.getToolbar().btnInsertText.toggle(!1,!1),this.getToolbar().fireEvent("editcomplete",this.getToolbar()))},FillAutoShapes:function(){var e=Ext.getStore("ShapeGroups"),t=this;t.getBtnInsertShape().menu.removeAll();for(var n=0;n<e.getCount()-1;n++){var r=e.getAt(n),i=Ext.widget("menuitem",{text:r.data.groupName,hideOnClick:!1,cls:"menu-item-noicon",menu:Ext.create("Common.component.MenuDataViewPicker",{width:r.data.groupWidth,height:r.data.groupHeight,store:r.data.groupStore,viewData:[],contentWidth:r.data.groupWidth-20,listeners:{select:Ext.bind(function(e,n){t.api&&(t._addAutoshape(!0,n.data.data.shapeType),t._isAddingShape=!0,Common.component.Analytics.trackEvent("ToolBar","Add Shape"))},this),hide:function(){t.getToolbar().fireEvent("editcomplete",t.getToolbar())},show:function(e){e.picker.selectByIndex(-1,!1)}},plugins:[{ptype:"menuexpand"}]}),deferExpandMenu:function(){if(!this.menu.rendered||!this.menu.isVisible())this.parentMenu.activeChild=this.menu,this.menu.parentItem=this,this.menu.parentMenu=this.menu.ownerCt=this.parentMenu,t.shapeMenuExpandLeft?this.menu.showBy(this,"tr-tl?",[-this.menu.width,0]):this.menu.showBy(this,"tl-tr?")}});t.getBtnInsertShape().menu.add(i)}},getHexColor:function(e,t,n){return e=e.toString(16),t=t.toString(16),n=n.toString(16),e.length==1&&(e="0"+e),t.length==1&&(t="0"+t),n.length==1&&(n="0"+n),e+t+n},_onSendThemeColorSchemes:function(e){var t=this;t.getToolbar().btnColorSchemas.menu.removeAll();var n=Ext.create("Ext.XTemplate",'<a class="x-menu-item-link">','<span class="colors">','<tpl for="colors">','<span class="color" style="background: {color};"></span>',"</tpl>","</span>",'<span class="text">{text}</span>',"</a>");for(var r=0;r<e.length;r++){var i=e[r],s=i.get_colors(),o=[];for(var u=2;u<7;u++){var a="#"+this.getHexColor(s[u].get_r(),s[u].get_g(),s[u].get_b());o.push({color:a})}var f=Ext.create("Ext.menu.Item",{cls:"menu-item-noicon asc-color-schemas-menu",data:{text:r<21?t.SchemeNames[r]:i.get_name(),colors:o},tpl:n,schemaType:r,listeners:{click:Ext.bind(function(e){t.api&&(t.api.ChangeColorScheme(e.schemaType),Common.component.Analytics.trackEvent("ToolBar","Color Scheme"))},this)}});r==21&&t.getToolbar().btnColorSchemas.menu.add(Ext.create("Ext.menu.Separator",{})),t.getToolbar().btnColorSchemas.menu.add(f)}},_handleShapeAlign:function(e,t,n){t.halign<6?(this.api&&this.api.put_ShapesAlign(t.halign),Common.component.Analytics.trackEvent("ToolBar","Shape Align")):t.halign==6?(this.api&&this.api.DistributeHorizontally(),Common.component.Analytics.trackEvent("ToolBar","Distribute")):(this.api&&this.api.DistributeVertically(),Common.component.Analytics.trackEvent("ToolBar","Distribute")),this.getToolbar().fireEvent("editcomplete",this.getToolbar())},_handleShapeArrange:function(e,t,n){switch(t.halign){case 1:this.api&&this.api.shapes_bringToFront(),Common.component.Analytics.trackEvent("ToolBar","Shape Arrange");break;case 2:this.api&&this.api.shapes_bringToBack(),Common.component.Analytics.trackEvent("ToolBar","Shape Arrange");break;case 3:this.api&&this.api.shapes_bringForward(),Common.component.Analytics.trackEvent("ToolBar","Shape Arrange");break;case 4:this.api&&this.api.shapes_bringBackward(),Common.component.Analytics.trackEvent("ToolBar","Shape Arrange");break;case 5:this.api&&this.api.groupShapes(),Common.component.Analytics.trackEvent("ToolBar","Shape Group");break;case 6:this.api&&this.api.unGroupShapes(),Common.component.Analytics.trackEvent("ToolBar","Shape UnGroup")}this.getToolbar().fireEvent("editcomplete",this.getToolbar())},_onCanGroup:function(e){this.getToolbar().mnuGroupShapes.setDisabled(!e)},_onCanUnGroup:function(e){this.getToolbar().mnuUnGroupShapes.setDisabled(!e)},_mnuOpenSlideSize:function(){var e,t,n=this;this.api&&(e=Ext.create("PE.view.SlideSizeSettings"),e.updateMetricUnit(),e.setSettings(n.currentPageSize.type,n.currentPageSize.width,n.currentPageSize.height)),e&&(e.addListener("onmodalresult",function(r){r==1&&(t=e.getSettings(),n.currentPageSize={type:t[0],width:t[1],height:t[2]},n.getToolbar().btnSlideSize.menu.items.items[0].setChecked(t[0]==0),n.getToolbar().btnSlideSize.menu.items.items[1].setChecked(t[0]==1),n.api&&n.api.changeSlideSize(t[1],t[2])),n.getToolbar().fireEvent("editcomplete",n.getToolbar())},!1),e.addListener("close",function(){n.getToolbar().fireEvent("editcomplete",n.getToolbar())}),e.show()),Common.component.Analytics.trackEvent("ToolBar","Slide Size")},_onPresentationSize:function(e,t){this.currentPageSize.width=e,this.currentPageSize.height=t,this.currentPageSize.type=-1;for(var n=0;n<this.slideSizeArr.length;n++)if(Math.abs(this.slideSizeArr[n][0]-this.currentPageSize.width)<.001&&Math.abs(this.slideSizeArr[n][1]-this.currentPageSize.height)<.001){this.currentPageSize.type=n;break}this.getToolbar().btnSlideSize.menu.items.items[0].setChecked(this.currentPageSize.type==0),this.getToolbar().btnSlideSize.menu.items.items[1].setChecked(this.currentPageSize.type==1)},onCoAuthoringDisconnect:function(){this.getToolbar().setMode({isDisconnected:!0})},onZoomChange:function(e,t){this.getToolbar().btnFitPage.setChecked(t==2,!0),this.getToolbar().btnFitWidth.setChecked(t==1,!0),this.getToolbar().txtZoom.setText(e+"%")},_onLockDocumentProps:function(){this.getToolbar().btnSlideSize.setDisabled(!0)},_onUnLockDocumentProps:function(){this.getToolbar().btnSlideSize.setDisabled(!1)},_onLockDocumentTheme:function(){this.getListTheme().setDisabled(!0),this.getToolbar().btnColorSchemas.setDisabled(!0)},_onUnLockDocumentTheme:function(){this.getListTheme().setDisabled(!1),this.getToolbar().btnColorSchemas.setDisabled(!1)},_onFocusObject:function(e){var t,n,r=-1,i,s=undefined,o=undefined,u=undefined,a=undefined;while(++r<e.length){i=e[r].get_ObjectType(),t=e[r].get_ObjectValue();if(i==c_oAscTypeSelectElement.Paragraph)s=t.get_Locked();else if(i==c_oAscTypeSelectElement.Slide)u=t.get_LockDelete(),a=t.get_LockLayout();else if(i==c_oAscTypeSelectElement.Image||i==c_oAscTypeSelectElement.Shape||i==c_oAscTypeSelectElement.Chart)o=t.get_Locked()}(s!==undefined||u!==undefined)&&this._state.prcontrolsdisable!==(s||u)&&(this._state.prcontrolsdisable=s||u,Ext.each(this.getToolbar().paragraphControls,function(e){e.setDisabled(this._state.prcontrolsdisable)},this)),o!==undefined&&u!==undefined&&this._state.shapecontrolsdisable!==(o||u)&&(this._state.shapecontrolsdisable=o||u,Ext.each(this.getToolbar().shapeControls,function(e){e.setDisabled(this._state.shapecontrolsdisable)},this)),u!==undefined&&a!==undefined&&this._state.slidelayoutdisable!==(a||u)&&(this._state.slidelayoutdisable=a||u,this.getToolbar().btnChangeSlide.setDisabled(this._state.slidelayoutdisable)),u!==undefined&&this._state.slidecontrolsdisable!==u&&(this._state.slidecontrolsdisable=u,Ext.each(this.getToolbar().slideOnlyControls,function(e){e.setDisabled(u)},this))},createDelayedElements:function(){var e=this.getToolbar().btnMarkers;e.menu.addListener("select",Ext.bind(this._onSelectBullets,this,[e.id,2],2),this),e.menu.addListener("hide",Ext.bind(function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this)),e=this.getToolbar().btnNumbers,e.menu.addListener("select",Ext.bind(this._onSelectBullets,this,[e.id,2],2),this),e.menu.addListener("hide",Ext.bind(function(){this.getToolbar().fireEvent("editcomplete",this.getToolbar())},this));var t=this.api.get_PropertyEditorThemes();t&&this._onInitEditorThemes(t[0],t[1]),this.api.asc_registerCallback("asc_onFontSize",Ext.bind(this._onFontSize,this)),this.api.asc_registerCallback("asc_onBold",Ext.bind(this._onBold,this)),this.api.asc_registerCallback("asc_onItalic",Ext.bind(this._onItalic,this)),this.api.asc_registerCallback("asc_onUnderline",Ext.bind(this._onUnderline,this)),this.api.asc_registerCallback("asc_onStrikeout",Ext.bind(this._onStrikeout,this)),this.api.asc_registerCallback("asc_onVerticalAlign",Ext.bind(this._onSubScript,this)),this.api.asc_registerCallback("asc_onCanUndo",Ext.bind(this._onCanRevert,this,["undo"],!0)),this.api.asc_registerCallback("asc_onCanRedo",Ext.bind(this._onCanRevert,this,["redo"],!0)),this.api.asc_registerCallback("asc_onPaintFormatChanged",Ext.bind(this._onStyleChange,this)),this.api.asc_registerCallback("asc_onListType",Ext.bind(this._onBullets,this)),this.api.asc_registerCallback("asc_canIncreaseIndent",Ext.bind(this._oncanIncreaseIndent,this)),this.api.asc_registerCallback("asc_canDecreaseIndent",Ext.bind(this._oncanDecreaseIndent,this)),this.api.asc_registerCallback("asc_onLineSpacing",Ext.bind(this._onLineSpacing,this)),this.api.asc_registerCallback("asc_onPrAlign",Ext.bind(this._onParagraphAlign,this)),this.api.asc_registerCallback("asc_onVerticalTextAlign",Ext.bind(this._onVerticalTextAlign,this)),this.api.asc_registerCallback("asc_onCanAddHyperlink",Ext.bind(this._onCanAddHyperlink,this)),this.api.asc_registerCallback("asc_onUpdateThemeIndex",Ext.bind(this._onUpdateThemeIndex,this)),this.api.asc_registerCallback("asc_onEndAddShape",Ext.bind(this._onEndAddShape,this)),this.api.asc_registerCallback("asc_onSendThemeColorSchemes",Ext.bind(this._onSendThemeColorSchemes,this)),this.api.asc_registerCallback("asc_onCanGroup",Ext.bind(this._onCanGroup,this)),this.api.asc_registerCallback("asc_onCanUnGroup",Ext.bind(this._onCanUnGroup,this)),this.api.asc_registerCallback("asc_onPresentationSize",Ext.bind(this._onPresentationSize,this)),this.api.asc_registerCallback("asc_onСoAuthoringDisconnect",Ext.bind(this.onCoAuthoringDisconnect,this)),this.api.asc_registerCallback("asc_onZoomChange",Ext.bind(this.onZoomChange,this)),this.api.asc_registerCallback("asc_onStartAction",Ext.bind(this._onLongActionBegin,this)),this.api.asc_registerCallback("asc_onEndAction",Ext.bind(this._onLongActionEnd,this)),this.api.asc_registerCallback("asc_onFocusObject",Ext.bind(this._onFocusObject,this)),this.api.asc_registerCallback("asc_onLockDocumentProps",Ext.bind(this._onLockDocumentProps,this)),this.api.asc_registerCallback("asc_onUnLockDocumentProps",Ext.bind(this._onUnLockDocumentProps,this)),this.api.asc_registerCallback("asc_onLockDocumentTheme",Ext.bind(this._onLockDocumentTheme,this)),this.api.asc_registerCallback("asc_onUnLockDocumentTheme",Ext.bind(this._onUnLockDocumentTheme,this)),this._onPresentationSize(this.api.get_PresentationWidth(),this.api.get_PresentationHeight())},textEmptyImgUrl:"You need to specify image URL.",textWarning:"Warning",textFontSizeErr:"The entered value must be more than 0",txtScheme1:"Office",txtScheme2:"Grayscale",txtScheme3:"Apex",txtScheme4:"Aspect",txtScheme5:"Civic",txtScheme6:"Concourse",txtScheme7:"Equity",txtScheme8:"Flow",txtScheme9:"Foundry",txtScheme10:"Median",txtScheme11:"Metro",txtScheme12:"Module",txtScheme13:"Opulent",txtScheme14:"Oriel",txtScheme15:"Origin",txtScheme16:"Paper",txtScheme17:"Solstice",txtScheme18:"Technic",txtScheme19:"Trek",txtScheme20:"Urban",txtScheme21:"Verve"});