﻿<%@ Page Title="Preview" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="MFile.aspx.cs" Inherits="GladinetPayFlow.MFile"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
            padding-left: 5px;
        }
     
        input
        {
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
        }

        video::-internal-media-controls-download-button {
    display:none;
}

        audio::-internal-media-controls-download-button {
    display:none;
}
        audio::-webkit-media-controls-enclosure {
    overflow:hidden;
}

audio::-webkit-media-controls-panel {
    width: calc(100% + 30px); /* Adjust as needed */
}

    </style>
    <script type="text/javascript">

        var fid = "<%=m_FID%>";

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d !== null && d !== undefined) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //document.body.style.backgroundColor = "White";

        function XSSDecode(x) {
            var r = /\\u([\d\w]{4})/gi;
            x = x.replace(r, function (match, grp) {
                return String.fromCharCode(parseInt(grp, 16));
            });
            x = unescape(x);
            return x;
        }

        function PrintFile() {
            var originalContents = document.body.innerHTML;
            document.title = "<%=FullPath.Text%>"
            var printReport = document.getElementById('contentdiv').innerHTML;
            document.body.innerHTML = printReport;
            document.body.style.overflow = "visible";
            window.print();

            document.body.innerHTML = originalContents;
            document.body.style.overflow = "hidden";
        }
    </script>
</asp:Content>   
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">                                                             
    <asp:Localize ID="LocBwrNotSupVid" meta:resourcekey="str_bwrNotSupVid" runat="server" Visible="false">Your browser doesn't support video playback</asp:Localize> 
    <asp:Localize ID="LocVidPrvDisByAdm" meta:resourcekey="str_vidPrvDisByAdm" runat="server" Visible="false">Video preview has been disabled by the administrator</asp:Localize> 
    <%if (!string.IsNullOrEmpty(ErrorMessage.Text))
      { %>
    <asp:Label ID="ErrorMessage" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMessageResource1"></asp:Label>
    <% } %>
    <div class='x-tab-bar-default-light' style="background-color: white">
        <table align="center" width="100%" border="0" style="background-color: white; overflow: auto;-webkit-overflow-scrolling: touch;" >
            <tr>
                <td colspan="3" align="center" style='overflow: auto; padding: 0px; background-color: transparent;
                    '>
                    <div id='contentdiv' style='overflow: auto; vertical-align: middle; align-content: center; border: 0px solid white;-webkit-overflow-scrolling: touch;
                        width: 100%; background-color: white;'>
                        <% if (!m_SupportPreview)
                           { %>
                        <div style="background-color: transparent; padding-top: 30px; ">
                            <asp:Image ID="FileTypeImage" runat="server" Width="128px" Height="128px" />
                            <br />
                            <br />
                            <asp:Label ID="FullPath" runat="server" Width="90%" Visible="true" Font-Size="12px"
                                meta:resourcekey="FullPathResource1"></asp:Label>
                        </div>
                        <% }else{ %>
                        <% } %>
                    </div>
                </td>
            </tr>
            
            
            
        </table>
    </div>
    <div  id="toolbar" >
                    <table align="center">
                        <tr >
                            <td id="PageInfo" height="32px" style='font-size: 18px;display: none; color:white;' nowrap="nowrap">
                            </td>
                            <td id='PrevPageBtn' title='Previous Page' onclick='ShowPreviousPage();' style='padding-left: 10px;
                                display: none; cursor: pointer; color: white;' valign="middle">
                                <div onmouseover="OnMouseOver(this);" onmouseout="OnMouseLeave(this);" style="height: 24px;
                                    font-size: 24px;">
                                    &#x25B2;</div>
                            </td>
                            <td id='NextPageBtn' title='Next Page' onclick='ShowNextPage();' style='cursor: pointer;
                                display: none; color: white;'>
                                <div onmouseover="OnMouseOver(this);" onmouseout="OnMouseLeave(this);" style="height: 24px;
                                    font-size: 24px;">
                                    &#x25BC;</div>
                            </td>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <% if (m_SupportPreview)
                               { %>
                            <td width="32px" onclick='Zoomin();return false;' style="display: none;">
                                <img src="/portal/images/zoomin.png" title="Zoom in" onmouseover="OnMouseOver(this);"
                                    onmouseout="OnMouseLeave(this);" name="aa" id='zoomin' />
                            </td>
                            <td width="32px" onclick='Zoomout();return false;' style="display: none;">
                                <img src="/portal/images/zoomout.png" title="Zoom out" onmouseover="OnMouseOver(this);"
                                    onmouseout="OnMouseLeave(this);" name="aa" id='zoomout' />
                            </td>
                            <% } %>
                            <%if (CanDownload){ %>
                            <td width="32px" onclick='DownloadCurrentFile();return false;'>
                                <img src="/portal/images/download.png" title="Download" onmouseover="OnMouseOver(this);"
                                    onmouseout="OnMouseLeave(this);" name="aa" />
                            </td>
                            <%} %>
                            <% if (CanShare)
                               { %>
                            <td width="32px" onclick='ShareCurrentFile();return false;'>
                                <img src="/portal/images/ic_action_share.png" title="Share" onmouseover="OnMouseOver(this);"
                                    onmouseout="OnMouseLeave(this);" name="aa" />
                            </td>
                            <% } %>
                        </tr>
                    </table>
                    </div>
    <div style="display: none; width: 1px; height: 1px">
        <iframe id='downloadframe' style="display: none;"></iframe>
    </div>
    <script type="text/javascript">
        
        var gPageCount = 0;
        var gTotalPage = 0;
        var gLastFilePreviewUri;
        var gRandom = 0;
        var gWidth = 0;
        var gHeight;
        ++gRandom;

        var viewOnlyFolder = false;
        try {
            viewOnlyFolder = parent.document.getElementById("DashboardView").contentWindow._gCurrentFolderIsViewOnly;
        } catch (ex) {
            console.log("[mfile] Cannot retrieve value for viewOnly" + ex);
        }
        try {
            //try to disable buttons on the master template  
            if (viewOnlyFolder===true) {
                parent.document.getElementById("downloadButtonRow").style.display = "none";
                parent.document.getElementById("shareButtonRow").style.display = "none";  
                parent.document.getElementById("printButtonRow").style.display = "none";
            } else {   
                parent.document.getElementById("downloadButtonRow").style.display = "";
                parent.document.getElementById("shareButtonRow").style.display = "";  
                parent.document.getElementById("printButtonRow").style.display = "";
            }
        } catch (ex) {
            console.log("[mfile] Cannot find template controls to hide for viewOnly" + ex);
        }

        function OnMouseOver(o) {
            
            o.style.border = "1px solid white";
        }

        function OnMouseLeave(o) {
            o.style.border = "0px solid white";
        }

        function maxw(hin) {
            var hMax = document.documentElement.clientWidth || 200;
            
            hMax -= 5;
            if (hMax < 100) {
                hMax = 100;
            }

            if (hin > hMax) {
                return hMax;
            }
            return hin;
        }
        var ActiveWin;
    function OpenHtmlWindowShort(id, title, Html, w, h) {
     <% if (IsMobile()){ %>
        ActiveWin = new Ext.Window({
            id: id,
            title: '',
            width: maxw(w),
            height: maxh(h),
            plain: true,
            modal: true,
            constrain: true,
            maximizable: false,
            maximized: false,
            bodyPadding: 0,
            border: false,
            resizable: false,
            header: false,
        iconCls: 'publish',
        bodyStyle: 'background:white;border:0px; padding:0px;',
        
        html: Html,        
        defaults: {
            border: false
        }
    });
    <%}else{ %>
    ActiveWin = new Ext.Window({
        id: id,
        title: '',
        width: maxw(w),
        height: maxh(h),
        plain: true,
        modal: true,
        constrain: true,
        maximizable: false,
        maximized: false,
        bodyPadding: 0,
        border: false,
        resizable: false,
        shadow: 'drop',
        iconCls: 'publish',
        bodyStyle: 'background:white;border:0px; padding:0px;',
        shadowOffset: 10,
        html: Html,
        header: false,
        defaults: {
            border: false
        }
    });
    <%} %>
        ActiveWin.show();

    }

function closeActiveWin() {

    
    try {
        ActiveWin.close();
    } catch (e) {
    }

}


function closeCancelActiveWin() {

   
    ActiveWin.close();
}
function gEncodeUri(str) {
    var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
    while (true) {
        var i = s.indexOf('+');
        if (i == -1)
            break;
        s = s.replace('+', ':');
    }

    return s;

}

        function ShareCurrentFile() {
            try {
                var cdir = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");
                
                var uri = "<iframe id='openwin' src='/portal/AddSharePage.aspx?src=browser&location=";
                uri += gEncodeUri(cdir);
                uri += "&folder=false&size=" + "0";
                uri += "' scrolling='no' style='width:100%;height:100%;margin:0;padding:0;background-color: #dfe8f6; border:0px solid black;'></iframe>";
                
                OpenHtmlWindowShort('link_win_2', 'Edit Share', uri, 728, 628);
                
            } catch (e) {
            }
            
        }

        function DownloadCurrentFile() {
            
            try {
                var uri = "<%=m_DownloadFileUri %>";
                <% if (IsMobile()){ %>
                window.open(uri, "downloadframe1", "location=no,menubar=no,toolbar=no", true);
                <% }else{ %>
                    //window.open(uri, "downloadframe", "location=no,menubar=no,toolbar=no", true);
                var e = document.getElementById("downloadframe");
                e.src = uri;

                <% } %>
                return;
            } catch (e) {
            }
        }

        var PageLoaded = false;
        function ClickOnPage(index, src) {
            
            var s1 = document.getElementById('imgdiv');
            s1.style.display = 'block';
            s1 = document.getElementById('loadtext');
            s1.style.display = 'none';
            

            gPageCount = index;

            if (gTotalPage != 0) {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1) + " of " + gTotalPage;
            } else {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1);

            }

            return;


            var s = document.getElementById('imgdiv');
            s.src = src;

            if (gTotalPage != 0 && gPageCount == gTotalPage - 1) {

                s = document.getElementById('NextPageBtn');
                s.style.display = 'none';
            } else {
                s = document.getElementById('NextPageBtn');
                s.style.display = 'block';
                
            }

            if (gPageCount == 0) {

                s = document.getElementById('PrevPageBtn');
                s.style.display = 'none';
            } else {
                s = document.getElementById('PrevPageBtn');
                s.style.display = 'block';
                
            }            

        }


        function LoadPages() {
            if (PageLoaded)
                return;
            PageLoaded = true;

            if (gTotalPage <= 1)
                return;

            var i = 0;
            var di = document.getElementById("contentdiv");
            
            var dp = document.createElement("div");
            dp.style.height = "5px";
            dp.style.backgroundColor = "#a0a0a0";
            di.appendChild(dp);
            for (i=1; i<gTotalPage;++i) {
                var myImage = new Image();
                
                myImage.src = gLastFilePreviewUri + "&p=" + i + "&w=" + gWidth + "&h=" + gHeight;
                
                   myImage.style.display = "none";
                myImage.onload = function() {
                    this.style.display = "";
                    try {
                        this.countsp.style.display = ""; 
                    } catch (e) {
                        
                    }
                };
                var sp = document.createElement("div");
                sp.style.paddingLeft = "10px";
                
                
                sp.appendChild(myImage);
                var sp1 = document.createElement("span");
                sp1.style.position = "relative";
                sp1.innerHTML = "" + (i+1);
                sp1.style.left = "10x";
                sp1.style.display = "none";
                myImage.countsp = sp1;
                sp1.style.top = "10px";
                sp1.style.fontSize = "18px";
                
                sp.PageCount = i;
                sp.src = myImage.src;
                sp.onclick = function() {
                    ClickOnPage(this.PageCount, this.src);
                };
                sp.appendChild(sp1);
                di.appendChild(sp);

                dp = document.createElement("div");
                dp.style.height = "5px";
                
                dp.style.backgroundColor = "#a0a0a0";
                <% if (IsMobile()){ %>
                dp.style.backgroundColor = "black";
                <% }%>
                   di.appendChild(dp);

            }
        }

        var gUri;
        function PreviewContentLoaded() {

            var w;
            var h;
            closeWait();
            var s1 = document.getElementById('imgdiv');
            s1.style.display = 'block';
            w = s1.width;
            h = s1.height;
            s1 = document.getElementById('loadtext');
            s1.style.display = 'none';


            var c = Ext.util.Cookies.get("x-glad-pagecount");
            
            if (c) {
                try {
                    gTotalPage = parseInt(c);
                } catch (e) {

                }
            } else {
                gTotalPage = 1;
            }

            if (gTotalPage != 0) {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1) + " of " + gTotalPage;
            } else {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1);

            }
            
            if (parent.SetPreviewImage && gTotalPage == 1) {
                if(w == 1 && h == 1)
                    parent.SetPreviewFrameNoPrev("<%=FileTypeImage.ImageUrl%>");
                else 
                    parent.SetPreviewImage(gUri, w, h);               
                return;
            }

            if (gTotalPage != 0 && gPageCount == gTotalPage - 1) {

                var s = document.getElementById('NextPageBtn');
                s.style.display = 'none';
                return;
            }


            //var s = document.getElementById('NextPageBtn');
            //s.style.display = '';
            if (parent.SetPreviewFrame) {
                parent.SetPreviewFrame();
            }
            
            LoadPages();

        }

        function Zoomin() {
            gWidth = gWidth * 2;
            gHeight = gHeight * 2;

            var s = document.getElementById('imgdiv');
            s.src = gLastFilePreviewUri + "&p=" + gPageCount + "&w=" + gWidth + "&h=" + gHeight;
        }

        function Zoomout() {
            if (gWidth <= 50 || gHeight <= 50)
                return;
            gWidth = Math.floor(gWidth / 2);
            gHeight = Math.floor(gHeight / 2);

            var s = document.getElementById('imgdiv');
            s.src = gLastFilePreviewUri + "&p=" + gPageCount + "&w=" + gWidth + "&h=" + gHeight;
        }

        function ShowNextPage() {

            var s1 = document.getElementById('imgdiv');
            s1.style.display = 'none';
            s1 = document.getElementById('loadtext');
            s1.style.display = 'block';

            if (gTotalPage == 0) {
                var c = Ext.util.Cookies.get("x-glad-pagecount");
                try {
                    gTotalPage = parseInt(c)
                } catch (e) {
                }
            }

            if (gTotalPage != 0 && gPageCount == gTotalPage - 1) {
                //alert(ExplorerDetail3_339_End_of_document_reached);
                s = document.getElementById('NextPageBtn');
                s.style.display = 'none';
                return;
            }

            gPageCount++;
            if (gTotalPage != 0) {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1) + " of " + gTotalPage;
            } else {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1);

            }


            s = document.getElementById('PrevPageBtn');
            s.style.display = 'block';

            var s = document.getElementById('imgdiv');
            s.src = gLastFilePreviewUri + "&p=" + gPageCount + "&w=" + gWidth + "&h=" + gHeight;

            if (gTotalPage != 0 && gPageCount == gTotalPage - 1) {

                s = document.getElementById('NextPageBtn');
                s.style.display = 'none';
                return;
            }


        }
        function ShowPreviousPage() {
            gPageCount--;

            var s1 = document.getElementById('imgdiv');
            s1.style.display = 'none';
            s1 = document.getElementById('loadtext');
            s1.style.display = 'block';

            var s = document.getElementById('imgdiv');
            s.src = gLastFilePreviewUri + "&p=" + gPageCount + "&w=" + gWidth + "&h=" + gHeight;
            if (gPageCount == 0) {
                s = document.getElementById('PrevPageBtn');
                s.style.display = 'none';
            }

            if (gTotalPage == 0 || gTotalPage > gPageCount) {
                s = document.getElementById('NextPageBtn');
                s.style.display = 'block';
            }

            if (gTotalPage != 0) {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1) + " of " + gTotalPage;
            } else {
                s1 = document.getElementById('PageInfo');
                s1.innerHTML = "Page " + (gPageCount + 1);

            }
        }
        var _maxParentCheckTries = 0;
        function adjustex1() {
            if (_maxParentCheckTries > 50) return;
            try {
                //adjustex1 accesses parent window properties. If the parent is not present, wait a little and try again
                //otherwise browser security exceptions will occur and prevent the rest of the code from executing
                var securityCheck = parent.window.innerHeight;
            } catch (ex) {
                _maxParentCheckTries++;
                setTimeout("adjustex1()", 100);
                return;
            }

            document.body.style.backgroundColor = "white";
            document.body.height = parent.window.innerHeight;
            var headerh = 128;
            var f = document.getElementById('contentdiv');
            gPageCount = 0;
            var dw = 60;
            var height = parent.window.innerHeight-8;

            headerh = 120;
            dw = 0;
            
            f.style.height = ( height- 20) + "px";
            f.style.width = (parent.window.innerWidth-40) + "px";
            <% if (IsMobile()){ %>
            //f.style.height = (height - 4) + "px";
            //f.style.width = (parent.window.innerWidth - 4) + "px";

            <% } %>
            var h = Math.floor((height - headerh)*9.0/10)-40 ;
            var w = Math.floor((parent.window.innerWidth-40)*9.5/10);
            if (w > 1024)
                w = 1024;
            <% if (IsMobile()){ %>
            h = height;
            w = parent.window.innerWidth - 8;
          
          <% } %>

            //f.style.width = w + "px";
           // if (w > Math.floor(h * 8.5 / 11))
            //    w = Math.floor(h * 8.5 / 11);

            f.style.width = (document.documentElement.clientWidth+dw) + "px";

            var toolbar = document.getElementById("toolbar");
            toolbar.style.top = (height-70)+"px";
            toolbar.style.left = (Math.floor(parent.window.innerWidth/2-30))+"px";

            toolbar.style.display = 'none';

            var uri = "<%=m_FileUri %>";
            gLastFilePreviewUri = uri;


            <% if (IsMobile()){ %>
            uri += "&w=" + Math.floor(w * 1.0);
            <% }else {%>
            uri += "&w=" + Math.floor(w * 1.0);
                <% }%>

            var ph = Math.floor(w * 11 / 8);
          <% if (IsMobile()){ %>
            //ph = Math.floor(h);
          <% } %>

            <% if (FileClass == "filepic"){ %>
                uri += "&h=" + h;
                gHeight =  h;
            <% }else{ %>
                uri += "&h=" + ph;
                gHeight =  ph;
            <% } %>
            gWidth = Math.floor(w);
            if (gWidth > parent.window.innerWidth)
                gWidth = parent.window.innerWidth;
            
            
            uri += "&r=" + gRandom;
            <% if (IsAudio){ %>
            f.style.display = 'block';
            


            if (parent.SetPreviewFrameEx) {

                document.body.innerHTML = "<div style='width:100%;height:100%; background-color:rgba(0,0,0,0.85); padding:5px; padding-top:20px;align-content:center; border-radius:0px;' align='center' valign='middle'><audio width='290px' height='40px' style=' padding-left:0px;'  controls oncontextmenu='return false;'><source src='<%= m_VideoUri %>' type='audio/<%=AudioFormat%>'>Your browser doesn't audio tag.</audio></div>";

                parent.SetPreviewFrameEx(320,80);
            } else {
                f.innerHTML = "<div id='loadtext'  style='background-color:transparent;height:" + h + "px; width:" + w + "px;'><br/><br/><audio width='95%' style='padding-top:40px'  controls oncontextmenu='return false;'><source src='<%= m_VideoUri %>' type='audio/<%=AudioFormat%>'>Your browser doesn't audio tag.</audio> </div>";
                f = document.getElementById('zoomin');
                f.style.display = 'none';

                f = document.getElementById('zoomout');
                f.style.display = 'none';

                
            }

            <% }else if (IsVideo){ %>
            f.style.display = 'block';
            
            <%if (!CanDownload && DisableVideoOnShareWithoutDownload) { %>                                      
            document.body.innerHTML = "<div style='padding:90px 30px 30px 30px;text-align:center;color:#202020;font-size:18px;'><%=LocVidPrvDisByAdm.Text %></div>";  
            parent.SetPreviewFrameEx(640, 220);
            return;
            <% } %>

            if (parent.SetPreviewFrameEx) {
                document.body.innerHTML = "<video id='videodiv' loop controlsList='nodownload' autoplay width='680' height='540' controls='true' poster='/webui/image128/movie.png'><source src='<%=m_VideoUri %>' type='video/mp4'><%=LocBwrNotSupVid.Text %></video>";
                parent.SetPreviewFrameEx(680, 540);
                var videoTagRef = document.getElementById('videodiv');
                //the loadedmetadata event does not trigger on iOS devices (it only triggers after successful playback)
                //the loadedmetadata does not fire "sometimes" on android
                //so just make sure the width is not too wide on mobile
                var msw = Math.floor(parent.window.innerWidth * 8 / 10);
                videoTagRef.width = msw;
                parent.SetPreviewFrameEx(msw, "auto");

                videoTagRef.addEventListener('loadedmetadata', function (e) {

                    var height = videoTagRef.videoHeight;
                    var width = videoTagRef.videoWidth;

                    var sh = Math.floor(parent.window.innerHeight * 8 / 10);
                    var sw = Math.floor(parent.window.innerWidth * 8 / 10);
                    
                    if (height > sh)
                        height = sh;
                    if (width > sw)
                        width = sw;

                    if (width != videoTagRef.videoWidth || height != videoTagRef.videoHeight) {
                        var rh = (width * videoTagRef.videoHeight / videoTagRef.videoWidth);
                        if (rh < height)
                            height = rh;
                        else {
                            var rw = (height * videoTagRef.videoWidth / videoTagRef.videoHeight);
                            if (rw < width)
                                width = rw;
                        }
                    }
                    
                    //videoTagRef.style.width = width + "px";
                    //videoTagRef.style.height = height + "px";

                    videoTagRef.width = width;
                    videoTagRef.height = height;
                    
                    parent.SetPreviewFrameEx(width, height);
                    
                });
                
            } else {
                f.innerHTML = "<div id='loadtext'  style='background-color:transparent;height:" +
                    h +
                    "px; width:" +
                    w +
                    "px;'><br/><br/><video width='95%' style='padding-top:40px' controlsList='nodownload' controls><source src='<%=m_VideoUri %>' type='video/mp4'><%=LocBwrNotSupVid.Text %></video> </div>";

                f = document.getElementById('zoomin');
                f.style.display = 'none';

                f = document.getElementById('zoomout');
                f.style.display = 'none';
            }
            <% }else if(IsPDF){ %>
            
            if (parent.SetPreviewFrameWithUrl) {
                parent.SetPreviewFrameWithUrl("<%=m_FileUri%>");
            } else {


                f.style.display = 'block';
                h -= 10;
                w -= 10;
                f
                    .innerHTML =
                    "<iframe id='loadtext'  style='border:0; margin:0;padding:0;background-color:white;height:" +
                    h +
                    "px; width:" +
                    w +
                    "px;' src='<%=m_FileUri%>" +                    
                    "'></iframe>";

                f = document.getElementById('zoomin');
                f.style.display = 'none';

                f = document.getElementById('zoomout');
                f.style.display = 'none';
               
            }

            <% }else if(IsText){ %>
            var cdir = XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>");
            if (parent.SetPreviewFrameWithUrl) {
                if(fid == "")
                    parent.SetPreviewFrameWithUrl('/portal/webapps/TextViewer.aspx?f=' + gEncodeUri(cdir));
                else
                    parent.SetPreviewFrameWithUrl('/portal/webapps/TextViewer.aspx?f=' + gEncodeUri(cdir)+"&fid="+fid);
            } else {


                f.style.display = 'block';
                h -= 10;
                w -= 10;
                f
                    .innerHTML =
                    "<iframe id='loadtext'  style='border:0; margin:0;padding:0;background-color:white;height:" +
                    h +
                    "px; width:" +
                    w +
                    "px;' src='/portal/webapps/TextViewer.aspx?f=" +
                    gEncodeUri(cdir) + "&fid=" + fid+
                    "'></iframe>";

                f = document.getElementById('zoomin');
                f.style.display = 'none';

                f = document.getElementById('zoomout');
                f.style.display = 'none';
               
            }
            <% }else{ %>            
            gUri = uri;
                f.innerHTML = "<div id='loadtext'  style='background-color:rgba(0,0,0,0.4); color:white;vertical-align:middle;display:none; font-size:24px; height:" + h + "px; width:100%;padding-top:120px'><img src='/portal/images/loading.gif'/></div><img  id='imgdiv' onload='PreviewContentLoaded();' style='display:none;border:0px solid #404040;vertical-align:middle;;background-color:white;opacity:1;' src='" + uri + "' />";
            <% } %>
        }
        
        function adjustex2() {
            
            var headerh = 18;
            var f = document.getElementById('contentdiv');

            document.body.backgroundColor = "transparent";
            var height = document.documentElement.clientHeight-18;
            f.style.height = ( height- headerh) + "px";
            f.style.width = (document.documentElement.clientWidth) + "px";
            

        }
        <% if (m_SupportPreview)
            { %>
        adjustex1();
        <% }
            else
            { %>
        adjustex2();
        <% } %>
		
		var oldOnResize = window.parent.onresize;
		window.parent.onresize = function () {
		    try {
		        //this sometimes blocked by browser security: "Security Manager vetoed action"
		        if(oldOnResize) oldOnResize();
		    } catch (ex) {
		        //having this catch ensures that the rest of the resizing functions can execute
		        console.log("mfile oldOnResize " + ex);                
		    }
            <% if (m_SupportPreview) { %>
		    adjustex1();
            <% } else { %>
            adjustex2();
            <% } %>
        };

        document.body.style.overflow = "hidden";

        try {
            parent.SetPrevieFileContent("<%=FileClass %>", XSSDecode("<%=XSSUrlEncode(FullPath.Text)%>"),"<%=m_DownloadFileUri %>", "<%=CanShare %>", "<%=!CanDownload %>" );
        } catch (e) {
            
        }

        <% if (!m_SupportPreview){ %>
        if (parent.SetPreviewFrameNoPrev) {
            parent.SetPreviewFrameNoPrev("<%=FileTypeImage.ImageUrl%>");
        }
        <% }%>

        <% if (!CanDownload){ %>
        document.body.oncontextmenu = function (evt) {
            evt.preventDefault();
            evt.stopPropagation();
            return false;
        }
        <% }%>
           </script>
</asp:Content>
