﻿<%@ Page Title="Gladinet Cloud - Local File Servers" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="LDAPUserPage.aspx.cs" Inherits="GladinetPayFlow.LDAPUserPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        
        .adsicon
        {
            background-image: url("images/activedir.png");
        }
    </style>
    <script type="text/javascript">



        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);

        function OnCancel() {
            parent.closeCancelActiveWin();
        }

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }
        function SetSearchLocation() {
            activewin = new Ext.Window({
                id: 'On_Set_Location',
                title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Select Search Location</asp:Localize>",
                width: 480,
                height: 450,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPLocation.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

        function SetLocation(loc) {
            var e = document.getElementById("MainContent_OU");
            e.value = loc;
            activewin.close();
        }

        function OnPubClicked() {
            var o = document.getElementById("MainContent_LDAPHomeDrive");
            var o1 = document.getElementById("MainContent_VisibleHomeDir");
            var o2 = document.getElementById("MainContent_CreateDefaultDir");
            var o11 = document.getElementById("o1");
            var o22 = document.getElementById("o2");

            if (o.checked) {
                o1.checked = false;
                o2.checked = false;
                o11.style.display = 'none';
                o22.style.display = 'none';
            } else {
                o11.style.display = '';
                o22.style.display = '';

            }
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="99%" class="checkout3" style="background-color: white; margin-top: 8px;"
        align="center">
        <tr>
            <td>
                <table width="100%">
                    <tr>
                        <td height="10px">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                        <td colspan="2" valign="bottom" style="padding: 10px; border: 1px solid #d0d0d0;"
                            align="left">
                            <table width="100%">
                                <tr>
                                    <td>
                                        <span style="font-size: 14px; vertical-align: top"><asp:Localize runat="server" meta:resourcekey="str_Loc">Location:</asp:Localize></span>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="OU" runat="server" Width="250px" CssClass="x-form-field x-form-text"
                                            meta:resourcekey="OUResource1"></asp:TextBox>&nbsp;&nbsp;&nbsp;
                                    </td>
                                    <td style="text-align: left;">
                                        <span style="color: #606060;"><asp:Localize runat="server" meta:resourcekey="str_IeOuo">(i.e. /ou/ou1/...)</asp:Localize></span>
                                        <asp:LinkButton ID="LinkButton4" runat="server" Font-Size="8pt" ForeColor="#009000"
                                            OnClientClick="SetSearchLocation();return false" Font-Underline="True" meta:resourcekey="LinkButton4Resource1"><asp:Localize meta:resourcekey="asp_string1" runat="server">Browse</asp:Localize></asp:LinkButton>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span style="font-size: 14px; vertical-align: top">
                                            <asp:Localize meta:resourcekey="asp_string2" runat="server">Name(cn) Contains:</asp:Localize></span>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="Contains" runat="server" Width="250px" CssClass="x-form-field x-form-text"
                                            meta:resourcekey="ContainsResource1"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:LinkButton Font-Size="14px" ID="Refresh" OnClientClick="Wait('Loading Users');"
                                            runat="server" OnClick="Refresh_Click" CssClass="x-btn x-btn-toolbar x-toolbar-item x-btn-default-toolbar-large x-icon-text-left x-btn-icon-text-left x-btn-default-toolbar-large-icon-text-left"
                                            meta:resourcekey="RefreshResource1">
                        <span unselectable="on"
        class="x-btn-wrap"><span class="x-btn-button">
            <span unselectable="on" class="x-btn-inner x-btn-inner-center" style="color:#008000;font-weight:400;">
                <asp:Localize meta:resourcekey="asp_string3" runat="server">Query Users</asp:Localize></span><span style="" unselectable="on" class="x-btn-icon-el adsicon"
                   role="img">&nbsp;</span></span></span>
                                        </asp:LinkButton>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td>
                            &nbsp;
                        </td>
                        <td valign="top" align="left" style="padding-left: 10px">
                            <table align="left" border="0" cellspacing="0" cellpadding="0">
                                <tr>
                                    <td align="left">
                                    </td>
                                    <td style="padding-left: 10px;">
                                        <div>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <table width="100%" align="center" style="display: <%=( m_ResultPage||m_UserCount==0)? "none" :""%>;">
                    <tr>
                        <td>
                            <div id="grid-example">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <table width="100%">
                                <tr>
                                    <td valign="top">
                                        <a href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                            color: #008000">
                                            <asp:Localize meta:resourcekey="asp_string4" runat="server">Select All</asp:Localize></a>
                                    </td>
                                    <td valign="top">
                                        <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                            <asp:Localize meta:resourcekey="asp_string5" runat="server">Deselect All</asp:Localize></a>
                                    </td>
                                    <td valign="top">
                                        <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                            <asp:Localize meta:resourcekey="asp_string6" runat="server">Undo Selection</asp:Localize></a>
                                    </td>
                                    <td align="right" style="padding-right: 10px; display: none;">
                                        <table>
                                            <tr>
                                                <td width="32px">
                                                    <img width="32px" src="images/addusers.png" />
                                                </td>
                                                <td>
                                                    <asp:LinkButton ID="LinkButton1" Font-Size="14px" runat="server" OnClientClick="Wait('Creating Users...');"
                                                        OnClick="LinkButton1_Click1" meta:resourcekey="LinkButton1Resource1"><asp:Localize meta:resourcekey="asp_string7" runat="server">Configure AD/LDAP Service</asp:Localize></asp:LinkButton>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td align="right" style="padding-right: 10px">
                                        <table>
                                            <tr id="o1">
                                                <td colspan="2" style="padding-top: 2px;" align="left">
                                                    <asp:CheckBox ID="CreateDefaultDir" Checked="True" runat="server" Text="Create default folder(Documents, Pictures)"
                                                        meta:resourcekey="CreateDefaultDirResource1" />
                                                </td>
                                            </tr>
                                            <tr id="o2" style="display: none;">
                                                <td colspan="2" style="padding-top: 2px;" align="left">
                                                    <asp:CheckBox ID="VisibleHomeDir" runat="server" Text="Make user's home directory visible to administrator"
                                                        meta:resourcekey="VisibleHomeDirResource1" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" style="padding-top: 2px;" align="left">
                                                    <asp:CheckBox ID="LDAPHomeDrive" runat="server" Text="Publish user's home drive"
                                                        onclick="OnPubClicked();" meta:resourcekey="LDAPHomeDriveResource1" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td width="32px">
                                                    <img width="32px" src="images/addusers.png" />
                                                </td>
                                                <td align="left">
                                                    <asp:LinkButton ID="LinkButton3" Font-Size="14px" runat="server" OnClick="AddUser_Click"
                                                        OnClientClick="Wait('Creating Users...');" ForeColor="Green" meta:resourcekey="LinkButton3Resource1"><asp:Localize meta:resourcekey="asp_string8" runat="server">Add Selected Users</asp:Localize></asp:LinkButton>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <table width="100%" align="center" style="display: <%=( !m_ResultPage&&m_UserCount==0)? "" :"none"%>;">
                    <tr>
                        <td style="padding: 40px">
                            <p class='idea_flex' style="height: 140px; display: <%=( !string.IsNullOrEmpty(ErrorMsg.Text)||!string.IsNullOrEmpty(EmptyList.Text))? "" :"none"%>;">
                                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b><br />
                                <asp:Label ID="EmptyList" runat="server" Font-Size="14px" meta:resourcekey="EmptyListResource1"></asp:Label>
                            </p>
                            <asp:Panel ID="Panel1" runat="server" meta:resourcekey="Panel1Resource1">
                                <div class='idea_flex' style="height: 100px; display: <%=( !string.IsNullOrEmpty(ErrorMsg.Text)&&!string.IsNullOrEmpty(EmptyList.Text))? "none" :""%>;">
                                    <asp:Localize meta:resourcekey="asp_string9" runat="server">Click 'Query Users' above to
                            load user list from your Active Directory or LDAP Server.</asp:Localize>
                                    <br />
                                    <br />
                                    <%if (m_ShowConfig)
                          { %>
                                    <asp:LinkButton ID="LinkButton12" Font-Size="12px" runat="server" Font-Underline="True"
                                        ForeColor="#009000" OnClientClick="Wait('Loading...');" OnClick="LinkButton1_Click1"
                                        meta:resourcekey="LinkButton12Resource1"><asp:Localize meta:resourcekey="asp_string10" runat="server">Configure AD/LDAP Service</asp:Localize></asp:LinkButton>
                                    <%} %>
                                </div>
                            </asp:Panel>
                        </td>
                    </tr>
                </table>
                <table width="90%" align="center" style="display: <%=( !m_ResultPage)? "none" :""%>;">
                    <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px;">
                        <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                            &nbsp;
                        </td>
                        <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                            &nbsp;
                        </td>
                        <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                            &nbsp;
                        </td>
                    </tr>
                    <asp:Repeater ID="ResultsList" runat="server">
                        <ItemTemplate>
                            <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px;">
                                <td style="padding: 5px; border-bottom: 1px solid #e0e0e0; border-left: 1px solid #e0e0e0;
                                    border-right: 1px solid #e0e0e0;">
                                    <%#(((RepeaterItem)Container).ItemIndex+1) %>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #e0e0e0;">
                                    <b>
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%></b>
                                </td>
                                <td style="padding: 5px; border-bottom: 1px solid #e0e0e0; border-right: 1px solid #e0e0e0;">
                                    <%#DataBinder.Eval(Container.DataItem,"Value") %>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
            </td>
        </tr>
    </table>
 <asp:Repeater ID="UsersRepeater" runat="server" >
        <ItemTemplate>
        </ItemTemplate>
    </asp:Repeater>      

    <script type="text/javascript">
  var myData = [
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'fullname' },
                    { name: 'email' },
                    { name: 'keyvalue' },
                    { name: 'added' }
                ],
                data: myData
            });



            var grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                columnLines: true,
                border: 1,
                scroll: true,
                layout: 'fit',
                height: 380,
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hdide';
                        }
                    },
                    {
                        text: "<asp:Localize meta:resourcekey="js_string2" runat="server">Full Name</asp:Localize>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'fullname',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<b>" + value + "</b>";
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="js_string3" runat="server">Email</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'email'
            },
            {
                text: '',
                width: 50,
                sortable: true,
                dataIndex: 'keyvalue',
                renderer: function (value, metaData, record, rowIndex) {
                    var d = record.data;
                    if (d.added.toLowerCase() == 'true')
                        return "<b><asp:Localize runat="server" meta:resourcekey="str_Add">Added</asp:Localize></b>";

                    return "<input type='checkbox' name='uu^user^" + d.email + "' value='" + value + "' />";
                }
            }
        ],
                renderTo: 'grid-example'
            });

            Ext.EventManager.onWindowResize(grid.doLayout, grid);
        });

    </script>
</asp:Content>
