﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="LDAPLocation.aspx.cs" Inherits="GladinetPayFlow.LDAPLocation" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        

        
        .style1
        {
            width: 63px;
        }
        
        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "UserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="js_string1" runat="server">Confirm you want to delete (</asp:Localize>" + name + ")?"))
                window.location = h;

        }

    
        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  window.location;
        }

       

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }

        function OnUserSelected() {
            var e = document.getElementById("MainContent_Label1");            
            if (e.innerHTML == "") {
                alert("<asp:Localize meta:resourcekey="asp_string1" runat="server">please select the organization before continue</asp:Localize>");
                return;
            }
            parent.SetLocation(e.innerHTML);
        }

       

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <b><asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
    

    
    <table width="100%" class="checkout3" style="background-color: white; margin-top: 8px;"
        align="center">
        <tr>
            <td colspan="2" style="padding: 10px">
                <asp:Localize meta:resourcekey="string1" runat="server">Current Location:</asp:Localize>
                <asp:Label ID="Parent" runat="server" meta:resourcekey="ParentResource1"></asp:Label>
                <%if (string.Compare(Parent.Text, "/") != 0)
                  { %>
                <asp:Button ID="BackButton" runat="server" Text="Back" Style="padding: 5px" OnClick="BackButton_Click"
                    meta:resourcekey="BackButtonResource1" />
                <%} %>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <div id="grid-example">
                </div>
            </td>
        </tr>
        <tr>
            <td style="padding: 10px;">
            </td>
        </tr>
        <tr>
            <td style="padding-left: 10px;">
                <asp:Label ID="Label1" runat="server" meta:resourcekey="Label1Resource1"></asp:Label>
            </td>
            <td align="right">
                <asp:Button ID="Button3" OnClientClick="OnUserSelected();return false;" runat="server"
                    Text="Select" Width="128px" Height="24px" meta:resourcekey="Button3Resource1" />
            </td>
        </tr>
        <tr>
            <td colspan="2" class="idea_flex">
                <asp:Localize ID="Localize1" meta:resourcekey="string4" runat="server">*Click to select, double click to browse into.</asp:Localize>
            </td>
        </tr>
    </table>
  
<script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#DataBinder.Eval(Container.DataItem, "FullName").ToString().Replace("'","%27")%>', '<%#DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27") %>', '<%#DataBinder.Eval(Container.DataItem,"KeyValue").ToString().Replace("'","%27") %>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'fullname' },
                  { name: 'email' },
                  { name: 'keyvalue' }
              ],
              data: myData
          });



          var grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              border:true,
              scroll: true,
              layout: 'fit',
              height: 270,
              columns: [

                  {
                      text: "<asp:Localize meta:resourcekey="string2" runat="server">Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'fullname',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + value + "</b>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="string3" runat="server">Description</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'email'
            }
        ],
              renderTo: 'grid-example',
              listeners: {
                  itemdblclick: function (dv, record, item, index, e) {
                      var d = record.data;
                      window.location = "LDAPLocation.aspx?r=" + d.keyvalue;
                  },
                  itemclick: function (dv, record, item, index, e) {
                      var d = record.data;
                      var e = document.getElementById("MainContent_Label1");
                      e.innerHTML = d.keyvalue;

                  }
              }
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });

  </script>

 
    <asp:HiddenField ID="CurrentLocation" runat="server" />
</asp:Content>
