﻿<%@ Page Title="Active Directory Settings" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="LDAPCfgPage.aspx.cs" Inherits="GladinetPayFlow.LDAPCfgPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .style6
        {
            height: 29px;
        }
        
        html , #Form1, .main
        {
     
            overflow: auto;
        } 
        body 
        {
        
            overflow: auto;
        }
        
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
     
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



    function closeCancelActiveWin()
    {
    }

    function closeActiveWin() {
        window.location = "LDAPCfgPage.aspx";
    }

    function OnCancelAddUser() {
        parent.closeCancelActiveWin();
    }
    
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
        <table cellspacing="0" width="100%" align="center">
            <tr>
                <td class="checkout3 x-panel-header-light x-panel-header-text-container-light" style="height: 68px;
                    border-top: 0; border-left: 0; border-right: 0; padding-left: 16px; vertical-align: middle;
                    text-align: left; font-size: 16px;">
                   <h2> <asp:Localize ID="Localize1" meta:resourcekey="string1" runat="server" 
               Text="Configure Active Directory/LDAP Service"></asp:Localize></h2>
                </td>
            </tr>
            </table>
        <asp:Label ID="ErrorMsg" runat="server" ForeColor=Red 
            meta:resourcekey="ErrorMsgResource1" ></asp:Label>
   
   <table width="100%" class="checkout3" style="background-color: white;margin: 0px;" align="center">
    
    <tr>
        <td style="padding:5px">
            <asp:CheckBox ID="UseLDAP" runat="server" 
                Text="Enable Active Directory Integration" AutoPostBack="True"
                oncheckedchanged="UseLDAP_CheckedChanged" 
                meta:resourcekey="UseLDAPResource1" />
        </td>
    </tr>
    <tr>
    <td style="padding:5px">
        <asp:Localize meta:resourcekey="string2" runat="server" 
            Text="Domain Controller or LDAP Server Address"></asp:Localize>(myhost:389)<asp:RequiredFieldValidator ControlToValidate="LDAPSvr"
            ID="RequiredFieldValidator1" runat="server" ErrorMessage="Required" 
            ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" 
            meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
    </td>
    </tr>
    <tr>
    <td style="padding:5px">
        <asp:TextBox ID="LDAPSvr" width="95%" runat="server" 
            CssClass="x-form-field x-form-text" meta:resourcekey="LDAPSvrResource1"></asp:TextBox><br />
        <asp:CheckBox ID="LDAPS" runat="server" 
            Text="Use secure channel(LDAPS) to access" meta:resourcekey="LDAPSResource1"/>
    </td>
    </tr>

    <tr>
    <td style="padding:5px">
        <asp:Localize meta:resourcekey="string3" runat="server" 
            Text="User name (the user will be used to connect to your Active Directory(or LDAP) Service"></asp:Localize><asp:RequiredFieldValidator ControlToValidate="UserName"
            ID="RequiredFieldValidator2" runat="server" ErrorMessage="Required" 
            ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" 
            meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
    </td>
    </tr>
    <tr>
    <td style="padding:5px">
        <asp:TextBox ID="UserName" width="95%" runat="server" 
            CssClass="x-form-field x-form-text" meta:resourcekey="UserNameResource1"></asp:TextBox>
    </td>
    </tr>

    <tr>
    <td style="padding:5px">
        <asp:Localize meta:resourcekey="asp_string1" runat="server" Text="Password"></asp:Localize><asp:RequiredFieldValidator ControlToValidate="Password"
            ID="RequiredFieldValidator3" runat="server" ErrorMessage="Required" 
            ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" 
            meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
    </td>
    </tr>
    <tr>
    <td style="padding:5px">
        <asp:TextBox ID="Password" width="95%" runat="server" TextMode="Password" 
            CssClass="x-form-field x-form-text" meta:resourcekey="PasswordResource1" ></asp:TextBox>
    </td>
    </tr>

    <tr>
    <td style="padding:5px">
        <asp:Localize meta:resourcekey="string4" runat="server" 
            Text="Friendly Domain Name (i.e. mydomain.com)"></asp:Localize><asp:RequiredFieldValidator ControlToValidate="Domain"
            ID="RequiredFieldValidator4" runat="server" ErrorMessage="Required" 
            ForeColor="Red" Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" 
            meta:resourcekey="RequiredFieldValidator4Resource1"></asp:RequiredFieldValidator>
    </td>
    </tr>
    <tr>
    <td style="padding:5px">
        <asp:TextBox ID="Domain" width="95%" runat="server" 
            CssClass="x-form-field x-form-text" meta:resourcekey="DomainResource1"></asp:TextBox>
    </td>
    </tr>

    <tr>
    <td style="padding:5px">
        <asp:Localize meta:resourcekey="string5" runat="server" 
            Text="Limit user and group from following Organization unit (i.e. OU=ou1,OU=ou2, empty means no limitation )"></asp:Localize>
    </td>
    </tr>
    <tr>
    <td style="padding:5px">
        <asp:TextBox ID="ScopeOU" width="95%" runat="server" 
            CssClass="x-form-field x-form-text" meta:resourcekey="ScopeOUResource1"></asp:TextBox>
    </td>
    </tr>
    <tr style="display:none;">
            <td style="padding: 5px">
                <asp:CheckBox ID="sAMAccountNameFirst" runat="server" Text="Authenticate with user's sAMAccountName first"
                    AutoPostBack="True" 
                    oncheckedchanged="sAMAccountNameFirst_CheckedChanged" 
                    meta:resourcekey="sAMAccountNameFirstResource1"  />
            </td>
        </tr>
<tr >
            <td style="padding: 5px">
                <asp:CheckBox ID="RecursiveGroupCheck" runat="server" 
                    Text="Disable Nested Group (Enable it may slow down your access to cloud)" meta:resourcekey="RecursiveGroupCheck"                    
                     />
            </td>
        </tr>
 <tr >
            <td style="padding: 5px">
                <asp:CheckBox ID="ForestRoot" runat="server" 
                    Text="This is root of AD Forest and contains multiple sub-domains" meta:resourcekey="ForestRoot"                    
                     />
            </td>
        </tr>
            <tr>
                <td style="padding: 5px">
                    <asp:CheckBox ID="NoUserAutoCreation" runat="server" 
                        meta:resourcekey="NoUserAutoCreation" Text="Don't allow user auto-creation" />
                </td>
            </tr>

    <tr >
            <td style="padding: 5px">
                <asp:CheckBox ID="AllowGC" runat="server" 
                    Text="Allow Switching to Global Catalog If needed" meta:resourcekey="AllowGCResource1"                    
                     />
            </td>
        </tr>



    </table>


        <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align:right; padding-right:64px;" align="right">
        <tr>

    <td style="padding-right:10px;"  align=right>
        <asp:Button Width="128px" Height="28px" ID="Button1"  
            Font-Size=14px runat="server" Text="Apply" onclick="Button1_Click"  
            OnClientClick="Wait('Verifying Settings...');" 
            meta:resourcekey="Button1Resource1"/>
            </td>
            <td style="padding-right:10px;" >
        <asp:Button Width="128px" Height="28px" ID="Button2" 
            Font-Size=14px runat="server" Text="Cancel" onclick="Button2_Click" 
            meta:resourcekey="Button2Resource1" />
    </td>
    </tr>
    </table>
    </div>

    <asp:HiddenField ID="CancelMode" runat="server" />
    <asp:HiddenField ID="ConfigId" runat="server" />
   </asp:Content>
