﻿<%@ Page Title="Forget Password" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ForgotPassword.aspx.cs" Inherits="GladinetPayFlow.ResetPassword"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .loginbox
        {
            border-radius: 6px 6px 6px 6px;
            border: 1px solid #c0c0c0;
            padding: 8px;
            -moz-box-shadow: 0 0 8px #909090;
            -webkit-box-shadow: 0 0 8px #909090;
            box-shadow: 0 0 8px #909090;
            background-color: white;
        }
        .loginimage
        {
            border-radius: 2px 2px 2px 2px;
            border: 0px solid #F0F0F0;
            padding: 2px;
            background-color: white;
        }
        .textbox
        {
            border: 1px solid #D0D0D0;
            padding: 8px;
            padding-top: 0px;
            padding-bottom: 0px;
            -moz-box-shadow: 0 0 5px #ccc;
            -webkit-box-shadow: 0 0 5px#ccc;
            box-shadow: 0 0 5px #ccc;
            background-color: white;
        }
        
        .loginbtnbox
        {
            border-radius: 3px 3px 3px 3px;
            border: 1px solid #c0c0c0;
            padding: 2px;
            color: white;
            font-weight: 700;
        }
        
        div.main
        {
            background-image: url('<%=bgImage%>');
            -webkit-background-size: cover;
            -moz-background-size: cover;
            -o-background-size: cover;
            background-size: cover;
        }

        .i-am-centered { margin: auto; max-width: 300px;}

        ::placeholder {
          color: #CCC !important;
        }
        .nobr {white-space:nowrap;}
        #captchaImg{font-size:12px;}
        @media (max-width: 430px) { 
            #captchaText{width:100%;float:none;margin-bottom:10px;}
            #captchaImg{float:none;width:100%;text-align:center;}
        } 
        @media (min-width: 431px) { 
            #captchaText{width:calc(100% - 195px);float:left;padding-right:15px;}
            #captchaImg{float:right;width:195px;text-align:right;}
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocResPasForAnActDirUseIsNotAll" meta:resourcekey="str_resPasForAnActDirUseIsNotAll" Visible="false">Reset password for an active directory user is not allowed.</asp:Localize>
<asp:Localize runat="server" ID="LocUseNotFou" meta:resourcekey="str_useNotFou" Visible="false">User not found</asp:Localize>
<asp:Localize runat="server" ID="LocInvCapTex" meta:resourcekey="str_invCapTex" Visible="false">invalid CAPTCHA text</asp:Localize>
    <div style="margin: 0; padding: 0; border: 0px; max-width:600px; margin-top:calc((100vh - 380px) / 2); margin-left: auto; margin-right: auto;">


                <div class="viewcard " style="opacity: 1;height:380px;padding:20px;">
                    <div class="row">

                        <div class="form-group row" style="margin-left: 32px; margin-right: 32px;">
                            <h3 id="h3Txt" style="font-weight: 100;font-size:1.4rem;">
                                <asp:Localize ID="Localize1" meta:resourcekey="string2" runat="server"
                                    Text="What is your username (E-mail Address)?"></asp:Localize></h3>
                        </div>
                        <script>
                            function wrapTitle() {
                                //adds nowrap to only the text between parenthesis
                                //this way, it should work with all localizations
                                var h3Obj = document.querySelector("#h3Txt");
                                var titl = h3Obj.innerHTML;
                                if (titl.indexOf("<span") == -1) {
                                    h3Obj.innerHTML = titl.replace("(", '<span class="nobr">(').replace(")", ')</span>');
                                }
                            };
                            wrapTitle();
                            
                            var oldOnload = window.onload;
                            window.onload = function () {
                                try{
                                    if (oldOnload) oldOnload();
                                    var defaultEmail = "";
                                    if (window.opener) {
                                        if (window.opener.document.getElementById("MainContent_UserName")) {
                                            defaultEmail = window.opener.document.getElementById("MainContent_UserName").value;
                                            if (defaultEmail.indexOf("<") > -1 || defaultEmail.indexOf(">") > -1) {
                                                defaultEmail = "";
                                            }
                                        }
                                    }
                                    document.getElementById("<%=txtEmail.ClientID%>").value = defaultEmail;
                                } catch (ex) {
                                    console.log(ex);
                                }
                            }
                            function submitForm() {
                                var u = document.getElementById("<%=txtEmail.ClientID %>");
                                if (u && u.value.indexOf("+") > -1) {
                                    u.value = u.value.replace(/\+/g,"%2B");
                                } 
                                document.getElementById("<%=Button1.ClientID %>").click();
                            }
                            function submitOnEnter(event) {
                                if (event.key === "Enter") {
                                    // Cancel the default action, if needed
                                    event.preventDefault();
                                    // Trigger the button element with a click
                                    submitForm();
                                }
                            }
                            function cancelWin() {
                                setTimeout(function () {
                                    location.href = '/portal/CloseWinCancel.htm';
                                }, 200);
                            }

                        </script>
                    </div>
                    <div class="row">

                        <div class="form-group" style="margin-left:15px; margin-right:15px; width:100%;">
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div class="gladinet-icons md-28 md-dark" style="float:left;width:32px;margin-top:5px;">b</div>
                                <div style="float:left;width:calc(100% - 32px);">
                                    <asp:TextBox ID="txtEmail" autocomplete="off" runat="server" meta:resourcekey="txtEmailResource1" CssClass="form-control" placeholder="johndoe@example.com" TabIndex="1"></asp:TextBox>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="row" style="display:none;">

                        <div class="form-group" style="margin-left: 32px; margin-right: 32px;">
                            <asp:Localize ID="Localize4" meta:resourcekey="enter_capt" runat="server"
                                Text="Please enter the string displayed in the box below:"></asp:Localize>
                        </div>

                    </div>

                    <div class="row">
                        <div class="form-group" style="margin-left:15px; margin-right:15px;width:100%;">
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <div id="captchaText">
                                    <div class="gladinet-icons md-28 md-dark" style="float:left;width:32px;margin-top:5px;">&#xFA;</div>
                                    <div style="float:left;width:calc(100% - 32px);margin-bottom:10px;">
                                        <asp:TextBox ID="capt" autocomplete="off" onkeypress="submitOnEnter(event)" runat="server" CssClass="form-control" meta:resourcekey="captResource1" placeholder="[enter code]" TabIndex="2"></asp:TextBox>
                                    </div>
                                </div>
                                <div id="captchaImg">
                                    <img src="/storage/captcha.dn?f=<%=FSessionId.Value %>" style="width:195px;margin-bottom:5px;" alt="CAPTCHA code" /><br />
                                    <asp:Localize meta:resourcekey="str_clear" runat="server">Not Clear?</asp:Localize>&nbsp;<asp:LinkButton ID="LinkButton1" runat="server" OnClick="LinkButton1_Click" meta:resourcekey="LinkButton1Resource1" style="font-size:12px;">Refresh</asp:LinkButton>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group" style="width:100%;display:block;margin:32px 15px 15px 15px;">
                            <div style="float:left;width:calc(100% - 88px);padding-left:47px;padding-top:10px;">
                                <asp:Label ID="ErrorMsg" runat="server" Style="color:red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                            </div>
                            <div style="float:right;display:flex;text-align:right;">
                                <input type="button" onclick="submitForm();" value="<%=Button1.Text %>" class="btn btn-lg btn-primary gladbtn " style="width:88px;" tabindex="3" />
                            <div style="display:none">
                                <asp:Button ID="Button1" runat="server" Text="Submit" OnClick="btnSubmit_Click"
                                OnClientClick="Wait('One minute...');" CausesValidation="False"
                                CssClass="btn btn-lg btn-primary gladbtn " meta:resourcekey="Button1Resource2"/>
                            </div>

                                <% if ("1".Equals(Request.QueryString["wc"])) { %>
                                <div style="width: 100%;text-align: center;"><div id="doneBtn" class="btn btn-lg btn-primary gladbtn" onclick="cancelWin()">Cancel</div></div>
                                <% } %>  
                                  
                            </div> 
                        </div>

                    </div>

                </div>

    </div>
    <asp:HiddenField ID="FSessionId" runat="server" />
</asp:Content>
