﻿<%@ Page Title="Folder Permissions" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="FolderPerms.aspx.cs" Inherits="GladinetPayFlow.FolderPerms" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <style type="text/css">
         td {
            font-size: 14px;
            font-family: Verdana,sans-serif;
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        label {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
            
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
        {
            height: 100%;
        }

        .wrapper
        {

        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        .custom-select{
            width:calc(100% + 8px) ;
            background-position-x:right;
        }
    </style>
    <script type="text/javascript">
            var UserCount = 0;
        <%if(m_AclList != null ){ %>
            UserCount = <%=m_AclList.Count%>;
        <%} %>
        
        function OnSaveChanges() {
            ConfirmResetChild();

        }
        function RefreshFolderPermsAspx() {
            //invoked by syncperms
            OnCancelChanges();
        }
        function OnCancelChanges()
        {
            window.location = window.location;
        }
            function Toggle(name) {
                var d = document.getElementById(name);
                if (d.style.display == 'none')
                    d.style.display = 'block';
                else
                    d.style.display = 'none';
            }
            function ShowSavePanel() {
                var e = document.getElementById("SaveBtnDiv");
                e.style.display = "";
            }
            function removeNodeSafely(node) {

                try {
                    node.innerHTML = ''; // in IE 8, it doesn't work for TR and TABLE
                
                } catch (e1) {
                    try {
                        node.parentNode.removeChild(node);
                    } catch (e2) {
                    
                    }
                }
                ShowSavePanel();
            }
                
            function DeleteACL(idd){
                var PermTable = document.getElementById("PermTable");
                var ch = document.getElementById(idd);
                ch.id = idd+"xxxx";
                removeNodeSafely(ch); //ch.innerHTML = "";
                --UserCount;
                AdjustPanel();
            }


            function EditPerm() {
                var d = document.getElementById("no_acl");
                var t = document.getElementById("has_acl");

                d.style.display = 'none';
                t.style.display = "block";
                t.style.backgroundColor = "white";
                t.style.border = "1px solid #c0c0c0";
                t.style.padding = "5px";
            }
            function TogglePubUser() {
                var d = document.getElementById("pubusers");
                var t = document.getElementById("pubusersc");
                if (d.style.display == 'none') {
                    d.style.display = 'block';
                    //t.style.height = "300px";
                } else {
                    //t.style.height = "300px";
                    d.style.display = 'none';
                }
            }
            function ClearErrorMsg() {

                var d = document.getElementById("errmsgdiv");
                if (d) {
                    d.style.display = 'none';
                }
            }
            setTimeout("ClearErrorMsg()", 8000);
            var showalert = true;

            function ToggelAceType(id) {
                
                var acediv = document.getElementById("ace_" + id);
                var checkc = document.getElementById("did_" + id);

                if (checkc.checked) {
                        checkc.checked = false;
                        acediv.innerHTML ="<span class='fa fa-plus'  style='color:green;cursor:pointer;' title='<%=str_allow.Text%>'>";
                } else {
                    if (showalert) {
                        showalert = false;
                        gConfirm('<%=str_deny.Text%>',
                            "<%=str_denyhint.Text%>",
                            function() {
                        checkc.checked = true;
                    acediv.innerHTML ="<span class='fa fa-minus' style='color:red; cursor:pointer;' title='<%=str_deny.Text%>'>";
                            });
                    } else {
                        checkc.checked = true;
                        acediv.innerHTML ="<span class='fa fa-minus' style='color:red; cursor:pointer;' title='<%=str_deny.Text%>'>";

                    }
                    
                }
                ShowSavePanel();
            }
            function OnUserSelected(UserList) {
                var users = UserList.split("\n");
                
                var PermTable = document.getElementById("PermTable");
                

                for (i = 0; i < users.length; ++i) {
                    var para = users[i].split(',');
                    var etr = document.createElement("tr");
                    var etd;
                    var echeck;
                    var eid = document.getElementById(para[0]);
                    var ediv;

                    if( !para )
                        continue;   
                    if( para.length < 2)
                        continue;
                    if (eid)
                        continue;
                    etr.id = para[0];

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = false;
                    echeck.style.display = "none";
                    echeck.name = "uu_deny_" + para[0];
                    echeck.id = "did_" + para[0];
                    etd.appendChild(echeck);

                    ediv = document.createElement("div");
                    etd.appendChild(ediv);
                    ediv.id = "ace_" + para[0];
                    ediv.innerHTML =  "<span class='fa fa-plus'  style='color:green;cursor:pointer;' title='<%=str_allow.Text%>'>";
                    ediv.onclick = function() {
                        ToggelAceType(this.id.replace("ace_",""));
                    };
                    
                    


                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    etd.innerHTML = "<img style='border-radius: 50%;' src='/storage/avarta.dn?u="+para[0]+"&w=32&h=32&d=<%=SessionDomainId%>'/>";

                    


                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    etd.innerHTML = para[2];
                    etd.align = "left";
                    etd.title = para[1];
                    //etd.style.paddingLeft = "10px";
                    //etd.style.width = (document.documentElement.clientWidth -185) + "px";


                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_list_" + para[0];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_read_" + para[0];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_write_" + para[0];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_delete_" + para[0];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_share_" + para[0];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("select");
                    echeck.name = "uu_in_" + para[0];
                    echeck.className = "browser-default custom-select";
                    echeck.style="background-color:transparent!important; border:0px white solid!important; padding:2px!important; font-size:10px!important; font-weight:100!important;";
                    echeck.innerHTML = '<option value="this_and_subfolder">This folder and subfolders</option> <option value="empty_subfolder">Subfolders without permission</option> <option value="this_folder">This folder only</option><option value="sub_folder">Subfolders</option>';
                    etd.appendChild(echeck);


                    etd = document.createElement("td");
                    etd.id = para[0];
                    etr.appendChild(etd);
                    var str = "<a href='#' onclick='DeleteACL(\"" + para[0] + "\");return false;'>"; ;
                    str += '<i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >n</i></a>'; ;

                    etd.innerHTML = str;
                    etd.style.paddingRight = "4px";


                    PermTable.appendChild(etr);
                    ++UserCount;
                }
                
                AdjustPanel();
                ShowSavePanel();
            }
        function EncodeGroupName(str) {
            return str.replace(/_/g, '^');
        }
            function OnGroupSelected(UserList) {
                var users = UserList.split("\n");
            
                var PermTable = document.getElementById("PermTable");

                for (i = 0; i < users.length; ++i) {

                   
                    var para = users[i].split(';');
                    var etr = document.createElement("tr");
                    var etd;
                    var echeck;
                    var ediv;
                    var eid = document.getElementById(para[0]);

                    if( !para )
                        continue;   
                    if( para.length < 2)
                        continue;
                    if (eid)
                        continue;
                    etr.id = para[2];

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = false;
                    echeck.style.display = "none";
                    echeck.name = "uu_deny_" + para[0];
                    echeck.id = "did_" + para[0];
                    etd.appendChild(echeck);

                    ediv = document.createElement("div");
                    etd.appendChild(ediv);
                    ediv.id = "ace_" + para[0];
                    ediv.innerHTML =  "<span class='fa fa-plus'  style='color:green;cursor:pointer;' title='<%=str_allow.Text%>'>";
                    ediv.onclick = function() {
                        ToggelAceType(this.id.replace("ace_",""));
                    };
                    etd = document.createElement("td");
                    etr.appendChild(etd);



                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    etd.innerHTML = "[Proxied Group] "+para[0];
                    etd.align = "left";
                    etd.style.paddingLeft = "5px";

                    
                    para[0] = EncodeGroupName(para[0]);
                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_list_" + para[2]+"_"+para[0]+"_"+para[3];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_read_" + para[2]+"_"+para[0]+"_"+para[3];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_write_" + para[2]+"_"+para[0];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_delete_" + para[2]+"_"+para[0]+"_"+para[3];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("input");
                    echeck.type = "checkbox";
                    echeck.checked = true;
                    echeck.name = "uu_share_" + para[2]+"_"+para[0]+"_"+para[3];
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etr.appendChild(etd);
                    echeck = document.createElement("select");
                    echeck.name = "uu_in_" + para[0];
                    echeck.className = "browser-default custom-select";
                    echeck.style="background-color:transparent!important; border:0px white solid!important; padding:2px!important; font-size:10px!important; font-weight:100!important;";
                    echeck.innerHTML = '<option value="this_and_subfolder">This folder and subfolders</option> <option value="empty_subfolder">Subfolders without permission</option> <option value="this_folder">This folder only</option><option value="sub_folder">Subfolders</option>';
                    etd.appendChild(echeck);

                    etd = document.createElement("td");
                    etd.id = para[0];
                    etr.appendChild(etd);
                    var str = "<a href='#' onclick='DeleteACL(\"" + para[2] + "\");return false;'>"; ;
                    str += '<i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >n</i></a>'; ;

                    etd.innerHTML = str;
                    etd.style.paddingRight = "4px";


                    PermTable.appendChild(etr);
                    ++UserCount;
                }
                
                AdjustPanel();
                ShowSavePanel();
            }
        
            var activewin;
            function closeCancelActiveWin()
            {
                activewin.close();
            }

            function closeActiveWin() {
                window.location = window.location;
            }

            function OnCancelPub() {
                parent.closeCancelActiveWin();
            }

            function OnAddUser() {

                activewin = new Ext.Window({
                    id: 'pubs_win',
                    title: '<asp:Localize meta:resourcekey="js_create_user" runat="server">Create New User</asp:Localize>',
                    width: 480,
                    height: 450,
                    plain: true,
                    modal: true,
                    maximizable: true,
                    constrain: true,
                    maximized: false,
                    layout: 'fit',
                    bodyPadding: 3,
                    html: "<iframe id='openwin' src='AddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                    defaults: {
                        border: false
                    }
                });
                activewin.show();



            }

         function gEncodeUri(str) {
            return str.replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
        }

        function OnClickTeam()
        {
            window.location = "/portal/addpubpage.aspx?location="+gEncodeUri( XSSDecode("<%=XSSUrlEncode(Location.Text) %>"))+"&vdid=<%=SessionDomainId %>";
        }

        function SelectUser() {
            
            try{
                if (parent.parent.OnSelectUser) {
                    parent.parent.OnSelectUserWithDomain('<%=SessionDomainId %>');
                    return;
                }
            } 
            catch(e)
           {
                    
            }
            
            
                parent.OnSelectUserWithDomain('<%=SessionDomainId %>');
            

        }

        function SelectLDAPUser() {
            
            try{
                if (parent.parent.OnLDAPSelectUserWithDomain) {
                    parent.parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
                    return;
                } 
            }catch(e){

            }


                parent.OnLDAPSelectUserWithDomain('<%=SessionDomainId %>');
            

        }
        function ApplyPerm(recur) {
            $('#ConfirmApply').modal('hide');
            var e = document.getElementById("MainContent_ResetChild");
            e.value = recur;
            e = document.getElementById("MainContent_PublishNow1");
            Wait('Applying settings');
            e.click();
        }
        function ConfirmResetChild() {
            
            <% if (HasChildPerm){ %>
            $('#ConfirmApply').modal({backdrop: 'static', keyboard: false});
            <% }else{ %>
            ApplyPerm('true');
            <% }%>

        }
        function SaveOfflineOption(chkBxObjRef){
            var forceOffline = "0";
            if(chkBxObjRef.checked){
                forceOffline = "1";
            }
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log("updated force offline setting successfully");
                }
            };
            xhttp.onerror = function(error) {
                alert("ERROR: "+error);
            };
            xhttp.open("GET", "FolderPerms.aspx?frcofflne=" + forceOffline + "&vdid=<%=SessionDomainId %>&location="+gEncodeUri( XSSDecode("<%=XSSUrlEncode(Location.Text) %>")), true);
            xhttp.send();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocFaiToCopFolPer" meta:resourcekey="str_faiToCopFolPer" runat="server" Visible="False">Failed to copy folder permissions</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToSetPer" meta:resourcekey="str_faiToSetPer" Visible="false">Failed to set permissions</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToBuiPerLis" meta:resourcekey="str_faiToBuiPerLis" Visible="false">Failed to build permissions list</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToCopFolPerCanNotGetSubFolLis" meta:resourcekey="str_faiToCopFolPerCanNotGetSubFolLis" Visible="false">Failed to copy folder permissions. Cannot get sub folder list</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToGetPerSet" meta:resourcekey="str_faiToGetPerSet" Visible="false">Failed to get permissions settings</asp:Localize>
    <asp:Localize runat="server" ID="LocEvn" meta:resourcekey="str_evn" Visible="false">Everyone</asp:Localize>
<asp:Localize runat="server" ID="LocAllADUsr" meta:resourcekey="str_allADUsr" Visible="false">All AD Users</asp:Localize>
<asp:Localize runat="server" ID="LocUkn" meta:resourcekey="str_ukn" Visible="false">Unknown</asp:Localize>
<asp:Localize runat="server" ID="LocNa" meta:resourcekey="str_na" Visible="false">N/A</asp:Localize>
<asp:Localize runat="server" ID="LocUknUsr" meta:resourcekey="str_uknUsr" Visible="false">Unknown User</asp:Localize>
    <div style="float: right;position: absolute; bottom:50px;right:50px;z-index: 9999; background: transparent; display: none; " id="SaveBtnDiv" >
<div style=" border-radius: 50%; width: 50px; height: 50px; background-color: #0288d1;  box-shadow: 3px 3px 3px #cccccc ; align-content: center; padding-top: 10px; padding-left: 9px; " class="savebtn" title="<asp:Localize meta:resourcekey="str_savechanges" runat="server">Save changes</asp:Localize>" onclick="OnSaveChanges();">
    
    <img  src="/webui/images/save_white_32.png"/>
</div>
    <div style="height:5px"></div>
    <div style=" border-radius: 50%; width: 50px; height: 50px; background-color: #ffa000;  box-shadow: 3px 3px 3px #cccccc; align-content: center; padding-top: 10px; padding-left: 9px; " class="savebtn" title="Discard changes" onclick="OnCancelChanges();">
    <img  src="/webui/images/discard_white_32.png"/>
</div>

    </div>
<div class="wrapper" style="text-align:center; overflow:hidden; background-color: white;" id="mainviewid">
    
            <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
          { %>        
         <div class="alert alert-warning  " style="padding-top: 2px; " id='errmsgdiv' role="alert">
           <a href="javascript:;" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                            <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                                </b>
                                        </div>
                                        
        <%} %>
    <table cellspacing="0" cellpadding="0"  align="left" style="height: 38px; width:100%; display:none;" >
                    <tr>
                        <td class="tabhead" style="background-color: white; padding: 3px; background: #E0e0e0;
                                                                                                                                                                                                                                                                                                                  border: 1px solid #f0f0f0; width: 200px; border-right: 1px solid white; border-bottom: 0px solid GRAY;"
                            onclick="OnClickTeam();" align="center">
                            <asp:Localize ID="Localize2" meta:resourcekey="asp_string9" runat="server" 
                                Text="Team Folder"></asp:Localize>
                        </td>
                        <td style="background-color: white; cursor: hand; padding: 3px; border: 1px solid #d0d0d0;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                border-right: 2px solid #a0a0a0; width: 200px; border-bottom: 0px solid #C0C0C0;"
                            align="center" class="tabhead tabheadfront">
                            <b style='font-size: 14px;'>
                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string8" runat="server" 
                                Text="Permissions"></asp:Localize></b>
                        </td>

                        <td>&nbsp;</td>
                        </tr>
                        </table>
    
                
    <div style="border:0px solid #c0c0c0;padding:5px;border-bottom:1px solid #c0c0c0;padding:0px;   background-color:white;display: none;">
                    <table width="100%"   align="center" style="height:100%;" >
                        <tr >
                            <td class="InputLabel"  align="left" style="background-color: #f0f0f0; padding: 5px;">
                                <b><asp:Localize meta:resourcekey="string1" runat="server" Text="Folder"></asp:Localize>:</b>
                                <asp:Label ID="PathLoc" runat="server" meta:resourcekey="PathLocResource1"></asp:Label>
                            </td>
                            <td align="right" style="background-color: #f0f0f0;padding: 5px;">
                               
                            </td>
                        </tr>

                        <tr >
                            <td class="InputLabel" colspan='2' >                                
                               
                            </td>
                        </tr>

                        <tr style="display: none;">
                            <td class="InputLabel" width="100%" colspan=2 style="padding-top:3px; padding-bottom:5px;">
                            <table>
                            <tr>
                            <td><asp:Localize meta:resourcekey="string2" runat="server" Text="Location"></asp:Localize>:</td>
                            <td> 
                                <asp:TextBox ID="Location" runat="server"  class="InputText"   Width=350px  
                                    CssClass="x-form-field x-form-text" meta:resourcekey="LocationResource1"></asp:TextBox>
                             </td>
                            </tr>
                            </table>
                                

                            </td>
                      
                        </tr>
                        </table>
    </div>
    
    <div id="has_acl"  
        style="border:0px solid #c0c0c0;padding:0px;  background-color:white"
    >
    <table width="100%"   align="center"  id="usetbl">
        <tr style="
            <% if (IsChildUi){ %>
            display: none;
            <% } %>
            ">
            <td style="padding-bottom: 10px;">
                        <div style="border-bottom: 0px solid #c0c0c0; <% if (!IsChildUi){ %>box-shadow: 0px 3px 3px #cccccc !important<% } %>">

                <table width="100%">
                    <tr>
                            <td height="32px" style="padding: 0px;align-content: left;padding-right: 20px;padding-left: 10px;max-width:160px;border-bottom: 0px solid #c0c0c0;">
                                
                                <table width="100%">
                                    <tr>
                                         <td style="padding-top:10px;padding-bottom:10px; background-color: white; border-bottom: 0px solid #c0c0c0; font-size: 16px; font-weight: 100; color: #868686;" align="left">
                                             <% if (!IsChildUi)
                                                 { %>
                                                 Folder Permission:<%=PathLoc.Text %></td>
                                        <%} %>
                                        <td>
                                            <asp:Panel ID="NoPubPanel" runat="server" Visible="False">
                                                
                                            <div class="alert alert-warning" style="margin: 0px;padding: 5px;">
                                                <asp:Localize ID="Localize3" meta:resourcekey="str_nopub" runat="server">User will not see this folder until published as a team folder</asp:Localize>
                                            </div>
                                            </asp:Panel>
                                        </td>
                                    </tr>
                                </table>
                                                
                                            </td>
                           
                            <td class="InputLabel" align=right style="padding-top:10px;padding-bottom:10px; background-color: white; border-bottom: 0px solid #c0c0c0;">
                                    <table>
                                        <tr>
                                            
                                        <td style="padding-right:10px;display: none;"><input type="checkbox" name="pub_to_all"  onclick="Toggle('pubusers')" style="display:none;" /><b><asp:Localize 
                                                meta:resourcekey="string3" runat="server" 
                                                Text="Assign access permission for your team members"></asp:Localize> </b></td>
                                            <td  style="padding-right: 5px;">
                                                <a href="#" onclick="SelectUser();return false;" style="font-size: 12px;" title="<%=AddUserText.Text %>">
                                                    <button class="btn btn-default" style="padding-left: 3px; padding-right: 3px;">
                                                                            <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: -5px; margin-top: 17px; display: inline-block; position: absolute;">
                                                                            </span>
                                                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >M</i>
                                                <asp:Localize meta:resourcekey="string4" runat="server" id="AddUserText" Text="Add User" Visible="False"></asp:Localize>
                                                </button>
                                                </a>
                                            </td>
                                            
                                            <%if (m_AllowLDAPUser)
                                              { %>
                                            <td style="padding-right: 5px;">
                                                <a href="#" onclick="SelectLDAPUser();return false;" style="font-size: 12px; display: none;">
                                                    <button class="btn btn-default">
                                                                            <span class="fa fa-plus" aria-hidden="true" style="font-size: 14px;">
                                                                            </span>
                                                <asp:Localize meta:resourcekey="string5" runat="server" Text="Add AD User"></asp:Localize>
                                                </button>
                                                </a>
                                            </td>
                                            <%} %>
                                            <%if (m_AllowSvrAgentGroup && !EditingTenant)
                                              { %>
                                           
                                            <td  style="padding-right: 5px;">
                                                <a href="#" onclick="parent.parent.OnSvrAgentGroup();return false;" style="font-size: 12px;">
                                                    <button class="btn btn-default">
                                                                            <span class="fa fa-plus" aria-hidden="true" style="font-size: 14px;">
                                                                            </span>
                                                <asp:Localize meta:resourcekey="string6" runat="server" Text="Proxy(AD) Group"></asp:Localize>
                                                </button>
                                                </a>
                                            </td>
                                            <%} %>

                                        </tr>
                                    </table>
                                    
                               </td>
                               
                            
                        </tr>
                </table>
                                        </div>

            </td>
        </tr>
                        
                        <tr>
                            <td class="InputLabel" colspan="2" valign="top" id="pubusersc"   style="padding-top: 0px; border: 0px solid red;">
                            <div id="pubusers"  style="background-color: white; border:0px solid #C0C0C0;">
                                <table style="background-color: white;width: calc(100vw - 2px);display:block;height:calc(100vh - 50px);overflow:auto;" class="table-striped" >
                                <tbody id="PermTable" style="display:table !important;width:100% !important;">
                                    <tr style="background-color:white; border-bottom:1px solid #f0f0f0;">
                                        <td width="50px" style="Padding:10px; padding-left: 20px; font-size:16px; " align="left"> 

                                        </td>
                                        <td style="Padding:10px; font-size:16px; width: 55px;" align="left">
                                            
                                        </td>
                                        

                                        <td style="Padding:10px; font-size:16px; font-weight: 100!important; color: #868686;" align="left" id="namefield">
                                            <asp:Localize meta:resourcekey="string7" runat="server" Text="User Name"></asp:Localize>
                                        </td>
                                        <td width="50px" style="Padding:10px; font-size:16px;font-weight: 100!important; color: #868686; " align="left">
                                            <asp:Localize meta:resourcekey="string9" runat="server" Text="List"></asp:Localize>
                                        </td>
                                        <td width="50px" style="Padding:10px; font-size:16px; font-weight: 100!important; color: #868686;" align="left">
                                            <asp:Localize meta:resourcekey="string10" runat="server" Text="Read"></asp:Localize>
                                        </td>
                                        <td width="50px" style="Padding:10px; font-size:16px; font-weight: 100!important; color: #868686;" align="left">
                                            <asp:Localize meta:resourcekey="string11" runat="server" Text="Write"></asp:Localize>
                                        </td>
                                        <td width="50px" style="Padding:10px; font-size:16px; font-weight: 100!important; color: #868686;" align="left"> 
                                            <asp:Localize meta:resourcekey="string12" runat="server" Text="Delete"></asp:Localize>
                                        </td>
                                        <td width="50px" style="Padding:10px; font-size:16px; font-weight: 100!important; color: #868686;" align="left"> 
                                            <asp:Localize meta:resourcekey="str_share" runat="server">Share</asp:Localize>
                                        </td>
                                        <td width="180px" style="Padding:0px; font-size:16px; font-weight: 100!important; color: #868686;" align="left"> 
                                            <asp:Localize meta:resourcekey="str_inherit" runat="server">Inheritance</asp:Localize>
                                        </td>
                                        <td width="42px">&nbsp;</td>
                                    </tr>
                                    <asp:Repeater ID="UsersRepeater" runat="server">
                                        <ItemTemplate>
                                            <tr class="trbordercolor"  id='<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>'     style='padding-top: 10px; background-color:<%# (Container.ItemIndex % 2 == 0)? "white": "#f0f0f0" %>' onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';"  onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                                <td style="padding-right:4px;">
                                                     <input type="checkbox" name='uu_deny_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' style="display: none;" id='did_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>'
                                                        value="1" <%# DataBinder.Eval(Container.DataItem, "DenyAcl") %>>
                                                    <div id="ace_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>" onclick="ToggelAceType('<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>');">
                                                    <%# DataBinder.Eval(Container.DataItem, "AceTypeDisplay") %>
                                                        </div>
                                                </td>
                                                <td>
                                                    <img style="border-radius: 50%;" src='/storage/avarta.dn?u=<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>&w=32&h=32&d=<%=SessionDomainId%>'/>
                                                </td>
                                                
                                                <td style="padding:5px;padding-left:10px;" align="left" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString()) %>">
                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString())%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString())%></td>
                                                <td>
                                                    <input type="checkbox" name='uu_list_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' onclick="ShowSavePanel();"
                                                        value="1" <%# DataBinder.Eval(Container.DataItem, "ListRight") %>>

                                                </td>

                                                <td>
                                                    <input type="checkbox" name='uu_read_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' onclick="ShowSavePanel();"
                                                        value="1" <%# DataBinder.Eval(Container.DataItem, "ReadRight") %>>

                                                </td>
                                                <td>
                                                    <input type="checkbox" name='uu_write_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' onclick="ShowSavePanel();"
                                                        value="1" <%# DataBinder.Eval(Container.DataItem, "WriteRight") %>>
                                                        
                                                </td>
                                                <td>
                                                    <input type="checkbox" name='uu_delete_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' onclick="ShowSavePanel();"
                                                        value="1" <%# DataBinder.Eval(Container.DataItem, "DeleteRight") %>>
                                                        
                                                </td>
                                                <td>
                                                    <input type="checkbox" name='uu_share_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' onclick="ShowSavePanel();"
                                                        value="1" <%# DataBinder.Eval(Container.DataItem, "ShareRight") %>>
                                                        
                                                </td>
                                                <td>
                                                    <select title="<%# DataBinder.Eval(Container.DataItem, "InheritedFrom") %>" onchange="ShowSavePanel();"  name='uu_in_<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>' class="browser-default custom-select" style="background-color:transparent!important; border:0px white solid!important; padding:2px!important; font-size:10px!important; font-weight:100!important;">
                                                       <option value="this_and_subfolder" <%# DataBinder.Eval(Container.DataItem, "ThisAndSubFolderSelect") %>>This folder and subfolders</option>    
                                                        <option value="empty_subfolder" <%# DataBinder.Eval(Container.DataItem, "EmptySubfolderSelect") %>>Subfolders without permission</option>
                                                      <option value="this_folder" <%# DataBinder.Eval(Container.DataItem, "ThisFolderSelect") %>>This folder only</option>
                                                      <option value="sub_folder" <%# DataBinder.Eval(Container.DataItem, "SubfolderSelect") %>>Subfolders</option>        
                                                        <option value="inherited" <%# DataBinder.Eval(Container.DataItem, "InheritedSelect") %>>Inherited from parent</option>                                              
                                                    </select>
                                                </td>
                                                <td>
                                                   
                                                    <a href='#' style="<%# DataBinder.Eval(Container.DataItem, "EditDisplay") %>"
                                                        onclick='DeleteACL("<%# DataBinder.Eval(Container.DataItem, "UserGuid") %>");return false;'><i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >n</i></a>
                                                        
                                                </td>
                                                

                                            </tr>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                    </tbody>
                                </table>
                                <table id='non_user' width="100%" style="display:none; ">
                                <tr>
                                <td style="padding-top:50px;" align="center">
                                 <div   style="margin: 6px; margin-left: 46px; margin-right: 26px; font-family:roboto, helvetica, arial, verdana, sans-serif; vertical-align: middle;padding-top: 8px; padding-bottom: 8px; height: auto; width:580px; background-color: white; color: #565656; 
                                        font-size:20px; font-weight:100; ">
                                     <p>
                                     <asp:Localize meta:resourcekey="string13" runat="server" 
                                         Text="This folder has no permissions configured, therefore all team users have unrestricted access by default. The admin user has full access at all times."></asp:Localize> <br /><br />
                                     <asp:Localize meta:resourcekey="string14" runat="server" 
                                         Text="To add user(s) to this folder, please click the 'Add Users' icon on the upper-right corner."></asp:Localize> <br /> <br />
                                         <%if (!IsServo){ %>
                                     <asp:Localize meta:resourcekey="string15" runat="server" 
                                         Text="This folder may not be visible to team users if it is not part of a team folder, regardless of permission."></asp:Localize>
                                         <%} %>
                                         </p>
                                </div>

                                </td>
                                </tr>
                                </table>                                

                                </div>
                            </td>
                     
                        </tr>
                    </table>
                    </div>
        <div id="ConfirmApply" class="modal fade" role="dialog">
  <div class="modal-dialog" style="width:700px;min-width:700px;">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><asp:Localize meta:resourcekey="str_childperm" runat="server">Child Folder Permissions</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body" style="height: 120px; padding-top: 40px;">
        <p><asp:Localize meta:resourcekey="str_replacechild" runat="server">Replace all child object permissions with new permissions?</asp:Localize></p>
      </div>
      <div class="modal-footer" style="padding-top: 10px; padding-bottom: 10px;">
          <table>
              <tr>
                  <td>
          <button type="button" class="btn btn-warning" onclick="ApplyPerm('true')"><asp:Localize meta:resourcekey="str_replacechild1" runat="server">Replace with New Permission</asp:Localize></button>
          <button type="button" class="btn btn-warning" onclick="ApplyPerm('true1')"><asp:Localize meta:resourcekey="str_replacechild12" runat="server">Replace if No Permission Defined</asp:Localize></button>

                  </td>
              </tr>
              <tr>
                  <td>
          <button type="button" class="btn btn-primary gladbtn" onclick="ApplyPerm('false')"><asp:Localize meta:resourcekey="str_kepp" runat="server">Keep Existing Permission</asp:Localize></button>
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_Can">Cancel</asp:Localize></button>

                  </td>
              </tr>
          </table>
      </div>
    </div>

  </div>
</div>
    
</div>
    <asp:HiddenField ID="ResetChild" runat="server" />
<asp:Localize meta:resourcekey="str_allow" id="str_allow" runat="server" Visible="False">Allow</asp:Localize>
<asp:Localize meta:resourcekey="str_deny" ID="str_deny" runat="server" Visible="False">Deny</asp:Localize>
<asp:Localize meta:resourcekey="str_denyhint" id="str_denyhint" runat="server" Visible="False">You are setting a Deny-Permission record. Deny records take precedence over any Allow records. Do you want to continue?</asp:Localize>
 <div  style="position:absolute; bottom:10px; width:100%;">
   
<table width="100%" align="center" style="height: 64px; text-align: right; padding-right: 64px; display:none;"                                >
                                    <tr>
                                        <td align="left" style="border-top: 0px solid #d0d0d0; padding-top: 0px; padding-left: 10px;">
                                        </td>
                                        <td width="338px" align="right" colspan="2" style="border-top: 0px solid #d0d0d0;padding-right: 10px;padding-top: 0px; display:none;">
                                            <div style="display: none" id='blueloader'>
                                                <asp:Button ID="PublishNow1" runat="server" Text="Apply" CssClass="btn btn-primary gladbtn"
                                                OnClick="PublishNow_Click" Width="128px" 
                                                meta:resourcekey="PublishNowResource1" /></div>

                                            <asp:Button ID="PublishNow" runat="server" Text="Apply" CssClass="btn btn-primary gladbtn"
                                                Width="128px" OnClientClick="ConfirmResetChild();return false;"
                                                meta:resourcekey="PublishNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                                            <asp:Button ID="CancelPublish" runat="server" Text="Cancel" CssClass="btn"
                                                Width="128px" CausesValidation="False" OnClick="CancelPublish_Click"
                                                meta:resourcekey="CancelPublishResource1" />
                                        </td>
                                    </tr>
                                </table>
                                </div>
    <div style="position:relative; top:10px; left:10px;">
                                             <asp:CheckBox ID="ForceOffline" runat="server" 
                                    Text="Enable offline access for native Client"  AutoPostBack="false"
                                    meta:resourcekey="ForceOfflineResource1" onclick="SaveOfflineOption(this);" />
        </div>

<script type="text/javascript">
    function AdjustPanel() {

        var Perm = document.getElementById("PermTable");
        var nu = document.getElementById("non_user");

        if (UserCount == 0) {
            Perm.style.display = 'none';
            nu.style.display = '';
        } else {
            Perm.style.display = 'table';
            nu.style.display = 'none';
        }
        

                
    }

    function Adjust() {
        try {
            AdjustPanel();
        } catch (e) {
            
        }
        
        //var e = document.getElementById("pubusers");
        
        
        //e.style.height = (document.documentElement.clientHeight - 195) + "px";
        
        // = document.getElementById("mainviewid");
        //e.style.height =  (document.documentElement.clientHeight - 80) + "px";

        //e = document.getElementById("has_acl");
        //e.style.height =  (document.documentElement.clientHeight - 85) + "px";

        //e = document.getElementById("pubusersc");
        //e.style.height =  (document.documentElement.clientHeight - 85) + "px";

        //e = document.getElementById("usetbl");
        //e.style.height =  (document.documentElement.clientHeight - 85) + "px";
        
        
    }

    

    
        Ext.onReady(function () {
            Adjust();

            Ext.EventManager.onWindowResize(function () {
                Adjust();
            });
            


        });

</script>

</asp:Content>
