﻿<%@ Page Title="File Browser" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="FileDashboard.aspx.cs" Inherits="GladinetPayFlow.FileDashboard"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <asp:Localize ID="LocFolNamCanConTheFolCha" meta:resourcekey="str_folNamCanConTheFolCha" runat="server" Visible="False">Folder names cannot contain the following characters:</asp:Localize>
    <asp:Localize meta:resourcekey="str_favorite" Visible="False" id="LocFavorite" runat="server">Favorite</asp:Localize>
    <asp:Localize meta:resourcekey="str_delete" Visible="False" id="LocDelete" runat="server">Delete</asp:Localize>
    <asp:Localize meta:resourcekey="str_rename" Visible="False" id="LocRename" runat="server">Rename</asp:Localize>
    <asp:Localize meta:resourcekey="str_publicLink" Visible="False" id="LocPublicLink" runat="server">PublicLink</asp:Localize>
    <asp:Localize meta:resourcekey="str_share" Visible="False" id="LocShare" runat="server">Share</asp:Localize>
    <asp:Localize meta:resourcekey="str_showDeleted" Visible="False" id="LocShowDeleted" runat="server">Show Deleted</asp:Localize>
    <asp:Localize meta:resourcekey="str_unknownError" Visible="False" id="LocUnknownError" runat="server">Unknown Error</asp:Localize>
    <asp:Localize meta:resourcekey="str_deleteDenied" Visible="False" id="LocDeleteDenied" runat="server">Delete Denied</asp:Localize>
    <asp:Localize meta:resourcekey="str_cannotDelete" Visible="False" id="LocCannotDelete" runat="server">Cannot Delete</asp:Localize>
    <asp:Localize meta:resourcekey="str_pleaseWait" Visible="False" id="LocPleaseWait" runat="server">Please Wait</asp:Localize>
    <asp:Localize meta:resourcekey="str_refresh" Visible="False" id="LocRefresh" runat="server">Refresh</asp:Localize>
    <asp:Localize meta:resourcekey="str_download" Visible="False" id="LocDownload" runat="server">Download</asp:Localize>
    <asp:Localize meta:resourcekey="str_copy" Visible="False" id="LocCopy" runat="server">Copy</asp:Localize>
    <asp:Localize meta:resourcekey="str_paste" Visible="False" id="LocPaste" runat="server">Paste</asp:Localize>
    <asp:Localize meta:resourcekey="str_cut" Visible="False" id="LocCut" runat="server">Copy</asp:Localize>
    <asp:Localize meta:resourcekey="str_uploadfiles1" Visible="False" id="str_uploadfiles1" runat="server">Upload</asp:Localize>
    <asp:Localize meta:resourcekey="str_add" Visible="False" id="LocAdd" runat="server">Add</asp:Localize>
    <asp:Localize meta:resourcekey="str_cancel" Visible="False" id="LocCancel" runat="server">Cancel</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilDay" Visible="False" id="LocDay" runat="server">Day</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilDays" Visible="False" id="LocDays" runat="server">Days</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilWeek" Visible="False" id="LocWeek" runat="server">Week</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilWeeks" Visible="False" id="LocWeeks" runat="server">Weeks</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilMonth" Visible="False" id="LocMonth" runat="server">Month</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilMonths" Visible="False" id="LocMonths" runat="server">Months</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilYear" Visible="False" id="LocYear" runat="server">Year</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilYears" Visible="False" id="LocYears" runat="server">Years</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFilNever" Visible="False" id="LocNever" runat="server">Never</asp:Localize>
    <asp:Localize meta:resourcekey="str_reqFil" Visible="False" id="LocReqFil" runat="server">Request a File</asp:Localize>
    <asp:Localize meta:resourcekey="str_cnotPasFroDifStg" Visible="False" id="LocCnotPasFroDifStg" runat="server">ERROR: Cannot paste from a different storage type</asp:Localize>
    <script type="text/javascript">
        var ExplorerDetail_cannotPasteFromDiffStorage = "<%=LocCnotPasFroDifStg.Text%>";
        var _refreshTokenNeeded = false;
        var _draggingSelection = false;
        var _draggingSelectionInitPos = { "x": 0, "y": 0 };
        var _resizingTableCol = false;
        var _prevPreviewPath = "";
        var _nextPreviewPath = "";
        var _isRepeaterPage = true;        
        var _isServo = "<%=IsServo.ToString().ToLower()%>"; 
        var _vdid = "<%=SessionDomainId %>";                     
        var _hasMoreRecentItems = "<%=m_HasMoreRecentItems %>";        
        var _hasMoreRecentItemsNextPage = "<%=m_HasMoreRecentItemsNextPage %>"; 
        var _m_OpenOfficeFileUsingO365Web = "<%=m_OpenOfficeFileUsingO365Web.ToString().ToLower()%>";
        var _autoOpenShareFolder = "<%=m_autoOpenShareFolder%>";
        var _disableSearch = "<%=m_disableSearch.ToString().ToLower()%>";
        function acceptableValue(possibleValsArr, defaultVal, setVal) {
            //verifies if setVal is an acceptable value
            //returns the defaultVal if it is not
            for (var i = 0; i < possibleValsArr.length; i++) {
                if (setVal == possibleValsArr[i]) {
                    return setVal;
                }
            }
            return defaultVal;
        }
        function rpt_isDeleted(strLastOp) {
            var isDel = false;
            if (typeof strLastOp == "undefined" || strLastOp == null) strLastOp = "";
            if (strLastOp == "d") isDel = true;
            return isDel;
        }
        function rpt_fixLeadingDoubleSlash(strPath) {
            //sometimes the AliasLocation has double slashes. Replace them with single slashes to avoid problems with the api
            if (typeof strPath == "undefined" || strPath == null) strPath = "";
            return strPath.replace(/^\/\//, '/');
        }   
		function localStorageTest(){
			try {
				localStorage.setItem('test', 'test');
				localStorage.removeItem('test');
				return true;
			} catch(e) {
				return false;
			}
		}
		function sessionStorageTest(){
			try {
				sessionStorage.setItem('test', 'test');
				sessionStorage.removeItem('test');
				return true;
			} catch(e) {
				return false;
			}
		}
        /*function msSetCookie(name, value) {
			if(localStorageTest()===true){
		    	localStorage.setItem(name, value);
			}else{
				var dt = new Date();
				var daysToExpirationInMillisecs = (30 * 24 * 60 * 60 * 1000);
				dt.setTime(dt.getTime() + daysToExpirationInMillisecs);
				document.cookie = encodeURIComponent(name) + "=" + encodeURIComponent(value) + ";expires="+ dt.toGMTString() +";path=/";
			}
        }*/
        function msGetCookie(name) {
			var value = "";
			var isOldCookie = (name.indexOf("x-glad-")>-1);
			if(!isOldCookie && localStorageTest()===true){
				value = localStorage.getItem(name);
			}else{
				var nme = encodeURIComponent(name) + "=";
				var arr = document.cookie.split(";");
				for (var i = 0; i < arr.length; i++) {
					if (arr[i].indexOf(nme) >-1) {
						value = arr[i].substring((arr[i].indexOf("=") + 1), arr[i].length);
						break;
					}
				}
			}
			if(value==null) value = "";
            return value;
        }
        function getBool(str){
            if(!str) return false;
            if(str.toLowerCase()=="true" || str=="1") return true;
            else return false;
        }
        function isBeingCut(id){
            return $("#"+id).hasClass("isBeingCut");
        }
        var _str_sortAsc = '<asp:Localize runat="server" meta:resourcekey="str_SorAsc">Sort Ascending</asp:Localize>';
        var _str_sortDesc = '<asp:Localize runat="server" meta:resourcekey="str_SorDes">Sort Descending</asp:Localize>';
        var _m_curCMenuID = -1;
        var _m_refreshAfterQuickWinClose = false;
        var _m_showdeleted = false;
        var _m_folderDownloadEnabled = getBool("<%=m_folderDownloadEnabled %>");
        var _m_showIconViewByDefault = getBool("<%=m_showIconViewByDefault %>");
        var _m_dontShowRecentActivities = getBool("<%=m_dontShowRecentActivities %>");
        var _m_hidePurge = getBool("<%=m_hidePurge %>");
        var _m_downloadPage = "<%=m_DownloadPage %>";
        var _m_disableClientDownload = "<%=m_disableClientDownload %>";
        var _m_disableMobileClient = "<%=m_disableMobileClient %>";
        var _m_storageQuotaGB = "<%=m_storageQuotaGB %>";
        var _m_storageUsedBytes = "<%=m_storageUsedBytes %>";
        var _m_guestMode = "<%=m_guestMode %>";
        var _m_devBackupRoot = "<%=m_DeviceBackRoot%>"
        var _m_externalURL = "<%=m_externalURL %>";
        var _m_tntId = "<%=m_tntId %>";
        var _m_thumbnailThresholdKB = "<%=m_thumbnailThresholdKB %>";
        var _m_dontShowDeviceBackups = getBool("<%=m_dontShowDeviceBackups %>");
        var _m_showAllMyFilesFirst = getBool("<%=m_showAllMyFilesFirst %>");
        var _m_disableFolderSharing = getBool("<%=m_disableFolderSharing %>");
        var _m_disablePublicLink = getBool("<%=m_disablePublicLink %>");
        var _m_showListViewByDefault = getBool("<%=m_showListViewByDefault %>");
        var _m_disableNativeClientForGuestUsers = getBool("<%=m_disableNativeClientForGuestUsers %>");
        var _m_hideCreateFileOptions = getBool("<%=m_hideCreateFileOptions %>");  
        var _m_allowEmptyFile = getBool("<%=m_AllowEmptyFile %>");
        var _m_allowPersonalDrive = true;
        <% if (IsServo) { %>
        _m_allowPersonalDrive = getBool("<%=m_allowPersonalDrive %>");
        <% } %>
        //UTC+01:30
        var _m_utcTimeZone = "<%=m_utcTimeZone %>";
		var _m_language = "<%=m_language %>";
		if(_m_language=="") _m_language = "en-US";
        var _m_utcMillisecsOffset = 0;
		var utcTmp = _m_utcTimeZone.replace("UTC+","").replace("UTC-","");
		var utcTmp2 = utcTmp.split(":");
		if(utcTmp2.length==2){
			var millisecsPerMin = 60000;
			var hourOffset = parseInt(utcTmp2[0]*60);
			var minOffset = parseInt(utcTmp2[1]);
			_m_utcMillisecsOffset = (hourOffset + minOffset) * millisecsPerMin;
			if(_m_utcTimeZone.indexOf("UTC-")>-1) _m_utcMillisecsOffset = (_m_utcMillisecsOffset * -1);
		}
        //load the default icon view set by the cluster or tenant admin
        var _m_showIconView = getBool("<%=m_showIconViewByDefault %>");
        var _m_onNewFolderCreateVersioned = false;

        //these properties used to be in cookies but are now in global vars. They have to now reside on the parent (if a parent exists) to prevent getting reset on any repeater pages.
        var par = self; 
        if (top != self) {
            par = top;
        } 
        var mode = acceptableValue(["icon", "detail"], "icon", par._m_gladviewmode);
        var _m_gladviewmode = mode;
        if (mode == "icon") {
            _m_showIconView = true;
        } else {
            _m_showIconView = false;
        }
        var _m_gladviewdensity = acceptableValue(["loose", "normal", "dense"], "normal", par._m_gladviewdensity);
        var _m_gladviewmodeiconsize = acceptableValue(["large", "medium", "small"], "medium", par._m_gladviewmodeiconsize);

        var _m_gladshowcolumnsinlist = "version,size,type,date";
        var m_gladMode = "<%=m_isAdmin%>";
        var _m_gladScrollPos = "0";//msGetCookie("_gladScrollPos");
        //value correction
        if(m_gladMode=="1")_m_hidePurge = false; //hide purge is not applicable to admin
        //console.log("_m_gladviewmode" + _m_gladviewmode)
        //console.log("_m_showIconView" + _m_showIconView)
        //console.log("_m_showListViewByDefault" + _m_showListViewByDefault)
        if(_m_gladviewmode=="detail") {
			_m_showIconView = false;
        }else if(_m_gladviewmode=="icon") {
			_m_gladviewmode = "icon";
			_m_showIconView = true;
        }

        //cluster setting default to icon
        if(_m_showIconViewByDefault==true){
            _m_gladviewmode = "icon";
            _m_showIconView = true;
        }
        //tenant setting default to list
        if(_m_showListViewByDefault==true){
            _m_gladviewmode="detail";
            _m_showIconView = false;
        }
        //still not set, default to icon
        if(_m_gladviewmode!="icon" && _m_gladviewmode!="detail"){
            _m_gladviewmode = "icon";
            _m_showIconView = true;
        }
        
        par._m_gladviewmode = _m_gladviewmode;        
        par._m_gladviewdensity = _m_gladviewdensity;
        par._m_gladviewmodeiconsize = _m_gladviewmodeiconsize;
        //localizations for filedashboard.js
        var _locFavorite = "<%=LocFavorite.Text%>";
        var _locDelete = "<%=LocDelete.Text%>";
        var _locRename = "<%=LocRename.Text%>";
        var _locPublicLink = "<%=LocPublicLink.Text%>";
        var _locShare = "<%=LocShare.Text%>";
        var _locUnknownError = "<%=LocUnknownError.Text%>";

        var _locDeleteDenied = "<%=LocDeleteDenied.Text%>";
        var _locCannotDelete = "<%=LocCannotDelete.Text%>";
        var _locPleaseWait = "<%=LocPleaseWait.Text%>";
        var _locReqFil = "<%=LocReqFil.Text%>";
        var _m_forceDefaultMsfOfcApp = "<%=m_forceDefaultMsfOfcApp%>";
        var _m_forceDefaultPixWebApp = "<%=m_forceDefaultPixWebApp%>";
        var _m_forceDefaultOlyOfcApp = "<%=m_forceDefaultOlyOfcApp%>";
        var _m_forceDefaultZhoApp = "<%=m_forceDefaultZhoApp%>";
        var _m_forceDefaultApp = "<%=m_forceDefaultApp%>";
        _m_HideMacClient = "<%=m_HideMacClient%>";
        _m_HideIOSClient = "<%=m_HideIOSClient%>";
        _m_HideAndroidClient = "<%=m_HideAndroidClient%>";
        _m_HideWindwosPhoneClient = "<%=m_HideWindwosPhoneClient%>";
        _m_HideWindowsStoreClient = "<%=m_HideWindowsStoreClient%>";
        _m_HideWindowsClient = "<%=m_HideWindowsClient%>";
        _m_HideServerAgent ="<%=m_HideServerAgent%>";
        _m_maxKeys ="<%=m_maxKeys%>";

        var Explorer_FilFolNamConSpeTex = "<asp:Localize id="LocFilFolNamConSpeTex" meta:resourcekey="str_filFolNamConSpeTex" runat="server">Filter for folder or file names containing a specific text</asp:Localize>";
        function clearSearch() {
            $("#<%=SearchText.ClientID%>").val("");
        }
    </script>
    <script type="text/javascript" src="/portal/webui_strings.aspx"></script>  
    <script type="text/javascript">
    var ExplorerDetail_no_files_found2 = ExplorerDetail_no_files_found; //no files or folders were found
    <% if (m_guestMode && m_hideSharedFilesFolders) { %>
        ExplorerDetail_no_files_found2 = Explorer_sharedItemsDisabled; //Shared files/folders were disabled by the administrator
	<% } %> 
    </script>
    <script type="text/javascript" src="/portal/filebrowser.js?ver=<%=mFileBrowserVer %>"></script>
    <script type="text/javascript" src="/portal/filedashboard.js?ver=<%=mFileDashboardVer %>"></script>
    <script type="text/javascript" src="/portal/fileuploadTaskMan.js?ver=<%=mFileUploadTaskManVer %>"></script>
    <script type="text/javascript" src="/portal/fileupload.js?ver=<%=mFileUploadVer %>"></script>
    <script type="text/javascript" src="/portal/filedashboardAll.js?ver=<%=mFileDashboardVer %>"></script>
    <script type="text/javascript" src="/portal/filedashboardstorage.js?ver=<%=mFileDashboardStorageVer %>"></script>
    <style id="myStyles" type="text/css">
    video::-internal-media-controls-download-button{display:none}
    /*.filebox{padding:5px;width:100%;position:absolute;border:none;align-content:center;margin-left:auto;margin-right:auto;margin-top:2%;border-radius:10px;}*/
    .filebox{padding:0px;width:100%;position:absolute;border:none;align-content:center;border-radius:10px;}
    .rptItem .filebox{padding:0px;width:100%;position:relative;border:none;align-content:center;border-radius:10px;}
    .filenode{border-width:1px;border-radius:3px;position:absolute;border-style:solid;font-weight:100;color:#878787;font-size:14px;cursor:pointer;overflow:hidden;display:block;align-items:center;text-align:center;background-color:#fff;}
    .fileoutbox{padding:15px}
    .isFile{padding:15px}
    .titletxt{font-size: 13px;font-weight:100;}
    .icodiv{z-index:1!important}
    .titlediv{height:40px;align-content:center;text-align:center;vertical-align:middle;position:absolute;border-top:1px solid #f0f0f0;bottom:0;width:100%;line-height:40px;background-color:#fff;overflow:hidden;z-index:2!important;}
    .sel_fld{border-radius:7px}
    #ListViewContainer{overflow-y:auto;height:auto;}  
    #MainContentDiv[data-pagetype="1"] #ListViewContainer{height: calc(100vh - 120px);}
    #ListView{margin-bottom: 60px;}
    #FolderList {overflow: auto; padding:7px 0px 0px 0px;}
    #FolderList .isFolder{min-width:156px;padding-left:0;padding-right:0;margin-bottom:15px;}
    #FolderList .btniconcolor{vertical-align:middle;text-overflow:ellipsis;white-space:nowrap;overflow:hidden;cursor:pointer}
    #FolderList .gladinet-icons.md-dark.center.toolbtn.folderIcon.btniconcolor{font-size:32px;line-height:100%;display:block;float:left;min-width:45px;width:70px;margin-top:10px;min-height:45px;cursor:default}
    #FolderList .titletxt.toolnavbtn{vertical-align:middle;text-overflow:ellipsis;white-space:nowrap;overflow:hidden;display:block;margin-top:15px;font-weight:100;cursor:pointer;min-width:45px;min-height:27px;max-width:90%;}
    #FolderList .iconsize_large .titletxt.toolnavbtn {max-width:155px;}
    #FolderList .iconsize_medium .titletxt.toolnavbtn {max-width:115px;}
    #FolderList .iconsize_small .titletxt.toolnavbtn {max-width:75px;}
    .btn-link{font-weight:400!important;font-size:16px!important}
    #waitPopup{position:absolute;top:25%;left:calc(50% - 70px);width:140px;height:100px;display:none;z-index:1000}
    #waitContainer{position:relative;width:100%;height:100%;margin-left:auto;margin-right:auto;border:1px solid transparent}
    .spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}
    #waitBigCog{position:relative;animation-duration:20s;float:left;width:90px;height:90px;font-size:90px;line-height:90px;opacity:.5}
    #waitBigCogInv{position:relative;top:-90px;animation-duration:20s;float:left;width:90px;height:90px;font-size:90px;line-height:90px;opacity:.8;color:#fff}
    #waitSmallCog{position:relative;top:50px;left:-8px;animation-direction:reverse;animation-duration:10s;width:45px;height:45px;font-size:45px;line-height:45px;opacity:.5}
    #waitSmallCogInv{position:relative;top:5px;left:-8px;animation-direction:reverse;animation-duration:10s;width:45px;height:45px;font-size:45px;line-height:45px;opacity:.8;color:#fff}
    .deletedfld .viewcard{background-color:rgba(240,240,240,0.50)!important}
    .deletedfld .titletxt{text-decoration:line-through;font-style:italic}
    .deletedfil .filenode,.deletedfil .titlediv{background-color:rgba(240,240,240,0.50)!important}
    .deletedfil .titletxt{text-decoration:line-through;font-style:italic}
    .deletedfld .toolnavbtn:before,.deletedfil .toolnavbtn:before {content:"";position:absolute;width:0;height:0;bottom:0;left:0;background-color:transparent;visibility:hidden;-webkit-transform:none!important;transform:none!important;-webkit-transition:none!important;transition:none!important}
    .deletedfld .toolnavbtn:hover:before,.deletedfil .toolnavbtn:hover:before{visibility:hidden!important;-webkit-transform:none!important;transform:none!important}
    .deletedfld .clickableFoldername,.deletedfil .clickableFilename{text-decoration:line-through;font-style:italic}
    .vGridItemRow.deletedfld,.vGridItemRow.deletedfil{background-color:rgba(240,240,240,0.50)!important}
    .thumbimg{width:100%;border-radius:3px;height:auto;position:absolute;z-index:1;left:-3px;top:-5px;}
    .icoViwLg .thumbimg{left:-4px;top:-8px;}    
    .icoViwMd .thumbimg{left:-3px;top:-5px;}
    .icoViwSm .thumbimg{left:-4px;top:-4px;}
    #myConfirmModel1{z-index:2000}
    #CurrentFname{width:100%;text-align:center;color:#BDBDBD;padding-bottom:10px;overflow-wrap:break-word;word-break:break-all;}
    .myProgressAction{height:auto;padding-bottom:7px;padding-left:2px;overflow-wrap:break-word;word-break:break-all;}
    .myProgCntr{display:block;width:100%;height:30px;border-radius:3px}
    .myProgBar{width:0;height:30px;border-radius:3px}
    .toolbtnex:focus{border-radius:4px 4px 4px 4px;-ms-animation:wiggle .3s 2;-moz-animation:wiggle .3s 2;-webkit-animation:wiggle .3s 2;animation:wiggle .3s 2}
    .myProgCntr{width:100%;height:20px;background-color:#F5F5F5}
    .myProgBar{width:0;height:20px;background-color:#D5DBDF}
    #taskcontainer{z-index:10010}
    .uploadProgressDiv{padding:10px;width:100%;height:40px}
    .uploadProgressBarBG{background-color:gray;width:100%;height:15px}
    .uploadProgressBar{background-color:#3ec6c6;width:10px;height:15px}
    #toast{position:absolute;top:65px;left:0px;display:block;background-color:#FFF;opacity:0.8;color:#000;font-size:14px;white-space:nowrap;border-radius:3px;z-index:5000;padding:13px;}
    .vGrid{border-collapse:collapse;color:#666;font-weight:200!important;width:100%;font-size:15px;}
    .vGridItemRow:nth-child(even){background-color:#FAFAFA}
    .vGridItemRow:nth-child(odd){background-color:#FFF}
    .vGridItemRow:hover{background-color:#CCE4F7}
    .vGridCell{width:100px;overflow:hidden;}
    .vGridCell table{width:100%}
    .vGridCell table tr td{font-size:14px;line-height:14px;}
    .vGrid20{width:20px}
    .vGrid40{width:40px}
    .vGridClip{overflow-x:hidden;}
    .vGridChkCol{min-width:60px;cursor:pointer}
    .vGridVersionCol,.vGridTypeCol{text-align:center;}
    .vGridDateCol,.vGridSizeCol{text-align:right;}
    .vGridRight{float:right;}
    .vGridLeft{float:left}
    .iconLbl{margin-top:-2px}
    .vGridCell{white-space:nowrap;border:none;font-weight:400!important}
    .vGridHeaderRow .vGridCell{background:#FFF}
    .vGridHeaderRow .vGridCell:hover{background:#F4F5F6}
    .vGridHeaderRow i{float:right;width:20px;height:20px;font-size:14px;text-align:center;line-height:14px;white-space:nowrap}
    .vGridNameCol{width:auto}
    .vGridInpCol,.vGridActionsCol,.vGridVersionCol,.vGridSizeCol,.vGridTypeCol,.vGridDateCol{width:1%}
    .vHidden{visibility:hidden}
    .vVisible{visibility:visible}
    .vMenu{display:none}
    .vMenu div{display:block;white-space:nowrap;cursor:pointer}
    #vMenuActions,#vMenuActionsSubMenu{position:absolute;color:#666;top:0;left:0;border:1px solid #d8d8d8;background-color:#FFF;padding:0;z-index:3000}
    .vMenuRow{display:block;min-height:30px;width:100%;padding:5px;white-space:nowrap}
    .vMenuRow i,.vMenuRow input{margin:0 0 0 7px}
    .vGridChkCol{width:90px}
    .vGridCell{font-family:roboto,helvetica,arial,verdana,sans-serif !important;font-weight:200 !important;font-size:15px;min-width:90px;height:65px;padding:0px 10px;}
	.vGridChkCol .gladinet-icons{cursor:pointer;font-size:36px!important;padding-top:5px;padding-bottom:5px;padding-left:10px}
    .vGridChkCol .vGrid40 img{padding-left:10px}
    .vMenuRow .gladinet-icons{padding-right:10px;margin-top:5px}
    .vGridLeft.iconLbl{padding-top:2px}
    .vMenuArrow{width:20px;margin-top: 5px;text-align:right}
    .vMenuArrow .gladinet-icons{font-size:14px;line-height:14px;cursor:pointer}
    #vColumnsMenuArrow{margin-top:-2px;margin-left:20px}
    .actionIco.gladinet-icons{font-size:24px!important;padding-left:5px!important;padding-right:5px!important;cursor:pointer;height:22px;margin-top:5px;}
    .vMenuActionSelected{background-color:#CCE4F7}
    #vMenuActionsSubMenu .vMenuRow span{padding:10px}
    .vGridActionsCol,.vGridSizeCol,.vGridTypeCol,.vGridVersionCol,.vGridDateCol{display:table-cell;white-space:nowrap;width:1%;min-width:100px;}
    .vViewMenuIcon{font-size:32px;padding-right:7px;width:40px}
    #viewChoicesMenu{display:none;position:absolute;top:0;left:0;z-index:5000;padding:0;font-size:12px;background-color:#fff;width:260px;box-shadow:rgba(0,0,0,0.2) 0 4px 9px 0px,rgba(0,0,0,0.19) 0 3px 10px 0;border-radius:2px}
    #viewChoicesMenu .choice{display:block;clear:both;width:100%;height:40px;padding-left:10px;padding-top:12px;margin-top:3px;}
    #viewSubChoicesMenu{display:none;position:absolute;top:0;left:0;z-index:4999;padding:0;font-size:12px;background-color:#fff;width:140px;height:40px;box-shadow:rgba(0,0,0,0.2) 0 4px 9px 0px,rgba(0,0,0,0.19) 0 3px 10px 0;border-radius:2px;padding-left:10px;}
    #viewSubChoicesMenu .choice{display:inline-block;clear:both;width:40px;height:40px;}
    #icoHighDensity,#icoNormalDensity,#icoLowDensity{line-height:40px;padding-left:3px;}
	#createMenu{display:none;position:absolute;top:0;left:0;z-index:5000;padding:0;font-size:12px;background-color:#fff;width:300px;height:290px;box-shadow:rgba(0,0,0,0.2) 0 4px 9px 0px,rgba(0,0,0,0.19) 0 3px 10px 0;border-radius:2px}
    #createMenu div{display:block;width:100%;height:50px;float:left;padding-left:10px;padding-top:15px;white-space:nowrap;}
    .viewChoicesMenuLnk{font-size:14px;cursor:pointer;float:left;margin-top:-5px}
    .viewChoicesMenuLnk:hover{text-decoration:underline}
    .vViewMenuIcon.iconsize_large{font-size:32px;float:left}
    .vViewMenuIcon.iconsize_medium{font-size:32px;float:left}
    .vViewMenuIcon.iconsize_small{font-size:32px;float:left}
    #createMenu .createMenuLnk{font-size:14px;cursor:pointer;float:left;margin-top:-5px; font-weight:100; color:#565656;}
    #createMenu .createMenuLnk:hover{text-decoration:underline}
    #createMenu .gladinet-icons{font-size:32px;float:left;margin-right:10px;}
    #FileList .isFile.iconsize_large{min-width:264px;min-height:190px;width:264px !important;height:190px !important;max-width:264px;max-height:190px;}
    #FileList .isFile.iconsize_medium{min-width:203px;min-height:146px;width:203px !important;height:146px !important;max-width:203px;max-height:146px;}
    #FileList .isFile.iconsize_small{min-width:156px;min-height:112px;width:156px !important;height:112px !important;max-width:156px;max-height:112px;line-height:20px;}
    #FolderList .isFolder.iconsize_large{min-width:243px;width:243px;max-width:243px;}
    #FolderList .isFolder.iconsize_medium{min-width:190px;width:190px;max-width:190px;}
    #FolderList .isFolder.iconsize_small{min-width:150px;width:150px;max-width:150px;}
    #filediv .fileoutbox.iconsize_large {min-width:264px;min-height:190px;width:264px !important;height:190px !important;max-width:264px;max-height:190px;}
    #filediv .fileoutbox.iconsize_medium {min-width:203px;min-height:146px;width:203px !important;height:146px !important;max-width:203px;max-height:146px;}
    #filediv .fileoutbox.iconsize_small {min-width:156px;min-height:112px;width:156px !important;height:112px !important;max-width:156px;max-height:112px;line-height:20px;}
    .menuArrow{font-size:18px!important;display:inline-block;height:20px;margin-top:-2px;margin-left:-3px}
    .rotated90{margin-top:-4px!important;margin-left:-8px!important;-webkit-transform:rotate(90deg);-moz-transform:rotate(90deg);-o-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg)}
    .nodeSize,.nodeDate{display:none !important;}
    .clickableFoldername,.clickableFilename{cursor:pointer;float:left;display:block;}
    .isBeingCut{opacity:.3}
    #writectrls{text-align:right;padding-right:30px;}
    .versionLink{cursor:pointer;}
    .renameFoldername{display:none;width:80%;height:32px;padding:10px;border-radius:4px;border:1px solid #d8d8d8;float:left;}
    .renameFilename{display:none;width:80%;height:32px;padding:10px;border-radius:4px;border:1px solid #d8d8d8;float:left;}
    .iconsize_large .renameFoldername,.iconsize_medium .renameFoldername,.iconsize_small .renameFoldername{margin-top:10px;width:60%;}
    .iconsize_large .renameFilename,.iconsize_medium .renameFilename,.iconsize_small .renameFilename{margin-top:3px;width:95%;margin-left:2.5%;margin-right:auto;}
    .renaming{display:block !important;}
    #ShortWindowModal .modal-content .modal-header {padding:10px 10px 0px 10px !important;}
    #ShortWindowModal .modal-content .modal-body {padding:0px 0px 0px 0px !important;}
    #ShortWindow {padding:0px 0px 0px 0px !important;}
    .cMenuRow{display:block;width:100%;white-space:nowrap;clear:both; font-weight:100!important;}
    .cMenuRow .actionIco{float:left;clear:both;padding-right:10px;margin-top:2px;width:40px;font-weight:100!important;}
	.cMenuRow .cMenuActionName{float:left;cursor:pointer;height:40px; color:#565656!important; font-weight:100!important;}
	.cMenuRow .cMenuActionName:hover{text-decoration:underline;}
    .modal-header.topnavcolor{background-color:#FFF !important;}
    #dragImg{position:absolute;top:-80px;left:-80px;width:80px;height:80px;font-size:80px;line-height:80px;}
    #ListView .moreMenu{float:left;display:block;width:10px;cursor:pointer;height:25px;line-height:1;}
    .titletxt{text-align:center !important;white-space:nowrap;}
    #DefaultMode {white-space: nowrap;}
    #DefaultContent .gladinet-icons:hover{box-shadow:none;}
    #createButton,#nextButton,#prevButton,#upLevelButton{z-index:1000;position:fixed;font-size:50px;color:white;line-height:0;width:45px;height:45px;display:block;border-radius:50%;box-shadow: 2px 4px 8px 0 rgba(0,0,0,0.2),-2px -1px 8px 0 rgba(0,0,0,0.2) ;top:300px;left:auto;padding: 20px 0px 10px 0px !important;}
    #prevButton{padding: 20px 9px 10px 0px !important;}    
    #fabbarDiv {margin:0 0 0 0;padding:0 0 0 0;display:none;white-space:nowrap;}
	#writectrls {margin:0 0 0 0;padding:0 130px 0 0;}
	#writectrls .toolbtn{font-size:24px;padding:0px 10px 0px 10px !important;height:30px;line-height:30px !important;}
    #refreshButton,#viewTrashButton,#purgeTrashButton {display:none !important;}
    #writectrls .tooltip{margin:15px 0px 0px 0px !important;z-index:10001;  /*tooltip positioning*/ }
    #fabbarDiv .tooltip{margin:5px 0px 0px 0px !important;z-index:10001;  /*tooltip positioning*/ }
    #cmenu hr{clear:both;height:1px;width:100%;margin-top:20px;margin-bottom:20px;}
    #createMenu hr{clear:both;height:1px;width:100%;margin-top:20px;margin-bottom:0px;}
    .aliasLoc{display:none;}
    .filebox .icodiv .gladinet-icons{width: 100%;line-height: 120px;margin-top:2%;}
    .iconsize_small .mainActionIcons{display:none;}
    .iconsize_medium .mainActionIcons{display:inline;}
    .iconsize_large .mainActionIcons{display:inline;}
    #filediv #ListView{margin-top:30px;}
    #foldercontentsubdiv #ListView{margin-top:0px;}
    #ListView .colResizer{display:block;float:right;margin:-25px -10px -25px 0px;width:1px;height:70px;cursor:col-resize;border-right:4px solid transparent;overflow:hidden;}
    #colResizerCursor {position:absolute;top:0px;left:-10px;border-right:1px solid #A6A6A6;width:1px;height:70px;z-index:99999;}
    h5{font-weight: 200;margin-top:20px;}
    .filebox .icodiv.icoDiv_large .gladinet-icons{font-size: 120px; margin-top: 70px;}
    .filebox .icodiv.icoDiv_medium .gladinet-icons{font-size: 88px; margin-top: 35px;}
    .filebox .icodiv.icoDiv_small .gladinet-icons{font-size: 38px; margin-top: 0px;}
     .breadcrumFont {color:#666666;font-size:14px;line-height:14px;font-weight:100; padding:10px 0px 10px 0px;height: 40px;}
     /*.fldToolbar {position:absolute;z-index:10;border:none;height:55px;top:5px;padding-top:15px;right:0px;width:30px;box-shadow:none;background-color:transparent;}*/
     .fldToolbar {z-index:10;border:none;height:55px;margin-top:-3px;padding-top:15px;float:right;width:30px;box-shadow:none;background-color:transparent;}
     #cmenu .closeButton{position:relative;z-index:12;right:auto;top:17px;font-size:14px;cursor:pointer}
    .selMarquee {display: none;position: absolute;top: 1px;left: 1px;height: 1px;border: 1px dashed #000;background-color: rgba(0,0,0,0.19);z-index:9999;}
    #foldercontentdiv {overflow-y: auto; -webkit-overflow-scrolling: touch; padding: 0px 0px 0px 0px; align-content: center; align-items: center;}
    .col-vk-1,.col-vk-2,.col-vk-3 {margin-top:10px;margin-right:10px;margin-left:10px;margin-bottom:10px;display:inline-block;}
    .ico_small,.ico_medium,.ico_large {display:inline-block;}
    #filediv{overflow-y:auto;width:calc(100% - 18px);overflow-x:auto;margin-left:20px;}
    #foldercontentdiv{}
	.headerbgcolor{background-color:#FAFAFA !important;}
    #menuBarTable{height:50px !important;}
    <% if (IsMobile()) { %>
    #createButton,#nextButton,#prevButton,#upLevelButton{top:auto;}
    #maintbl,#maindiv{padding-top:0px !important;}
    #foldercontentsubdiv{padding-top:20px !important;}
    #menuBarTable{display:none !important;}
    #leftmenutd{width:100%;white-space:nowrap;padding-left:10px;padding-right:10px;overflow:hidden;display:none;}
    #FolderList .isFolder{width:calc(100% - 20px);height:65px;padding-right:0px !important;}
    .toolbar,.fldToolbar{display: none;}
    #FolderList .titletxt.toolnavbtn {width:calc(100% - 90px) !important;max-width:calc(100% - 90px) !important;text-align:left !important;}
    .rptActionIcons {padding-top:10px;padding-bottom:10px;padding-right:35px;}
    .modal-dialog {max-width: 100%;}
    #ListView .moreMenu{margin-top:-2px;}
    <% }else{ %>
    #maintbl,#maindiv{padding-top:2px !important;}
    #foldercontentsubdiv{padding-top:10px !important;}
    #leftmenutd{width:300px !important;min-width:300px !important;white-space:nowrap;padding-left:10px;padding-right:10px;overflow:hidden;}
    #FolderList .isFolder{height:65px;margin:10px 5px 10px 0px;}
    .toolbar,.fldToolbar{display: none;}
    #FolderList .titletxt.toolnavbtn {width:auto;}
    .modal-dialog {max-width:900px;}
    <% } %>
    .toolbar.toolbarmobile{display: block;}
    .toolnavbtn{white-space:nowrap;}
    #FolderList{margin-bottom:0px;overflow-x:hidden;}
    #ext-gen1018{-webkit-overflow-scrolling:touch;}  /*absence of this line prevents scrolling on ios devices*/
    #maindiv{text-align:left; margin: 0;-webkit-overflow-scrolling: touch; overflow-y: auto;overflow-x: hidden; padding:10px 0px 0px 0px; background-color: #f8f8f8; -moz-user-select: none; -webkit-user-select: none; -ms-user-select:none; user-select:none;-o-user-select:none;}
    #maindivtbl{padding-bottom: 30px; display: none;}
    #maindivtbl td{width:80px;text-align:center;color: #868686; display: none;}
    #maintbl{width:95%;}
    #noFilesMsg{padding: 0px 0px 10px 20px;}
    .rptActionIcons{padding-top:0px;padding-right:10px;}
    .rptActionIcons .gladinet-icons{font-size:24px;padding:0px 10px 0px 10px !important;height:30px;line-height:30px !important;}
    .deletedfil .gladinet-icons,.deletedfld .gladinet-icons{color:gray !important;}
    .deletedfil .clickableFilename,.deletedfld .clickableFoldername{color:gray !important;}
    .deletedfil .thumbimg{opacity:0 !important;}
    .deletedfil .icodiv{display:block !important;}
    #ListViewFiles .vGridChkCol .gladinet-icons{font-size:35px !important;margin-top:5px;padding-left:30px;width:30px;height:30px;display:block;}
    #rpt_searchResults,#rpt_recentFiles,#rpt_myShares,#rpt_sharedWithMe,#rpt_myFiles,#rpt_teamFolders,#sharedItemsContainer,#rpt_myFaves{display:flex;flex-wrap:wrap;align-content:flex-start;}
    #rpt_searchResults{overflow:visible;height:calc(100vh);}
    #Form1,.main{overflow: visible;}
    #maindiv{overflow-y: hidden;}
    #maintbl{width:100%;}
    #foldercontentdiv{overflow-y:visible;}
    #foldercontentsubdiv,#rpt_recentFiles,#rpt_myFiles,#rpt_teamFolders,#sharedItemsContainer,#rpt_myFaves{overflow-y:auto;overflow-x:hidden;-webkit-overflow-scrolling:touch;height:auto;}
    #rpt_sharedWithMe,#rpt_myShares#rpt_sharedWithMe,{overflow-y:auto;-webkit-overflow-scrolling:touch;height:auto;}
    .sel_fil .filebox .filenode .titlediv{display:block !important;} /*never hide the title of selected tiles, even after mouseovers*/
    .titlediv.titledivmobile{display:block !important;}
    #foldercontentdiv{display:none;}
    #leftmenutd .leftMenuIcon {width:32px;padding:10px 10px 10px 10px;font-size:24px;line-height: 0%;}
    #leftmenutd .leftMenuLabel {font-size:14px;cursor:pointer;font-weight:400;line-height: 0%;}
    #dragAndDropMsg {display:none;}
    .noEffects {text-decoration:none !important;;cursor:default !important;}
    .noEffects:hover {text-decoration:none !important;;cursor:default !important;}
    #main_body {width:90% !important;height:calc(100vh - 110px);margin-left:3%;}
    #RequestFileModal .row{margin-bottom:15px;}
    #RequestFileModal .row div{margin-bottom:15px;}
    #RequestFileModal input::placeholder{color:lightgray;opacity:1;}
    #RequestFileModal input:-ms-input-placeholder{color:lightgray;}
    #RequestFileModal input::-ms-input-placeholder{color:lightgray;}
    #taskpanel gladinet-icons{cursor:pointer;}
    #downloadNativeRow,#statsRow,#statsRowDivider{display:none;}
    .noUnderline{text-decoration:none !important;}
    .noUnderline:hover{text-decoration:none !important;}
    .statsLabel{line-height:140% !important;font-weight:200 !important;font-style:italic !important;padding-top:13px !important;}
    .statsLabel:hover{text-decoration:none !important;}
    .statsLabel b{font-weight:400;}
    .statsIconCell{vertical-align:top;padding-top:15px;padding-left:10px;}
    #statsRowDivider td{border-bottom-width:1px;border-bottom-style:solid;height:20px;}
    .statsLabel progress,.statsLabel progress div{height:3px;width:100%;background-color:#eee;}
    .statsLabel progress,.statsLabel progress::-webkit-progress-bar {background-color:#eee;border-radius: 2px;box-shadow: 0 2px 5px rgba(0, 0, 0, 0.25) inset;}
    .statsLabel progress::-moz-progress-bar,.statsLabel progress[value]::-webkit-progress-value {background-color:#666;}
    .statsLabel progress.full::-moz-progress-bar,.statsLabel progress.full[value]::-webkit-progress-value {background-color:red;}
	#statsTxt{max-width:230px;display:block;overflow-x:hidden;}
	.cMenuInfo{max-width:380px;}
    .cMenuWrappableName{white-space:pre-wrap;white-space:-moz-pre-wrap;white-space:-pre-wrap;white-space:-o-pre-wrap;word-wrap:break-word;}
	#sideBarDiv{display:none;border:none;position:absolute;top:53px;right:0px;height:calc(100% - 46px);padding-top:0px;padding-left:0px;padding-right:0px;background-color:#FFF;width:500px;z-index:1000;border-left: 1px solid #E0E0E0;}
	#menuBarTable{display:none;border-bottom:1px solid #E0E0E0;width:calc(100% - 20px);margin-top:0px;}
	#foldercontentdiv{width:100%;}
	#treeDiv{display:none;position:absolute;top:35px;left:317px;border:1px solid #E0E0E0;border-radius:5px;padding:10px 50px 10px 20px;background-color:#FFF;overflow:auto;font-family:roboto,helvetica,arial,verdana,sans-serif;color:#565656;font-size:12px;font-weight:100;line-height:200%;z-index: 2999;max-height:calc(100% - 95px);box-shadow: 0 4px 8px 0 rgba(0,0,0,0.25);min-width: 370px;}
	#treeDiv .gladinet-icons{margin-right:5px;}
	#treeButton{margin-right:5px;}
	<% if (IsMobile()) { %>
	#createButton,#upLevelButton{right:25px;}
	#prevButton{right:140px;}              
	#nextButton{right:80px;}
	#foldercontentsubdiv.iconView{margin-left:10px;}
	#foldercontentsubdiv.listView{margin-left:0px;}
	#FolderList{margin-left:7px;}
	#ListViewContainer,#ListView{margin-left:0px !important;}
	.breadcrumTable{display:none;}
    .hide{display:none;}
    <% } %>

	<% if (IsMobile()) { %>
		#miniSearchRow td.leftMenuIcon {padding-top:20px;}
		#leftmenutd #fullSearchBoxRow {display:none;}
    <% } %>

	<% if (!IsMobile()) { %>
	#menuBarTable{margin-left:20px;}
	#createButton,#upLevelButton{right:42px;}  
	#prevButton{right:155px;}
	#nextButton{right:97px;}
	@media (max-width: 1120px) {
		#leftmenutd {width: 55px !important;min-width: 55px !important;max-width: 55px !important;}
		#leftmenutd .leftMenuLabel {display:none;}
		#leftmenutd #fullSearchBoxRow {display:none;}
		#leftmenutd #miniSearchRow {display:table-row;}
		.contentwithminussidebar{width:calc(100% - 498px) !important;}
		.contentwithminussidebar #foldercontentsubdiv{width:100% !important;}
		#treeDiv{left:72px;}
	}
	@media (min-width: 1121px) and (max-width: 1620px) {
        #leftmenutd {width: 300px !important;min-width: 300px !important;max-width: 300px !important;}
		#leftmenutd.leftmenuWithSidebarOpened{width: 55px !important;min-width: 55px !important;max-width: 55px !important;}
		#leftmenutd.leftmenuWithSidebarOpened .leftMenuLabel {display:none;}
		#leftmenutd #fullSearchBoxRow {display:table-row;}
		#leftmenutd #miniSearchRow {display:none;}
		#leftmenutd.leftmenuWithSidebarOpened #fullSearchBoxRow {display:none;}
		#leftmenutd.leftmenuWithSidebarOpened #miniSearchRow {display:table-row;}
		.contentwithminussidebar{width:calc(100% - 498px) !important;}
		.contentwithminussidebar #foldercontentsubdiv{width:100% !important;}
		#sideBarDiv{width:500px;}
		.sidebarOffset{right:545px !important;}/*sidebarOffset is for positioning the createButton*/    
		.sidebarOffsetForPrevBtn{right:655px !important;}
		.sidebarOffsetForNextBtn{right:600px !important;}
		#treeDiv{left:317px}
		#treeDiv.treeWithSidebarOpened{left:72px;}
	}
	@media (min-width: 1621px) {
        #leftmenutd {width: 300px !important;min-width: 300px !important;max-width: 300px !important;}
		#leftmenutd .leftMenuLabel {display:table-cell;}
		#fullSearchBoxRow {display:table-row;}
		#miniSearchRow {display:none;}

		.contentwithminussidebar{width:calc(100% - 498px) !important;}
		.contentwithminussidebar #foldercontentsubdiv{width:100% !important;}
		#sideBarDiv{width:500px;}
		.sidebarOffset{right:545px !important;}
		.sidebarOffsetForPrevBtn{right:655px !important;}  
		.sidebarOffsetForNextBtn{right:600px !important;}
		#treeDiv{left:317px}
	}
    <% } %>
	.showDeletedMenu,.purgeMenu{margin-left:2px;}
	.refreshButton{display:none;}
	/*<<<<<js-treeview*/
	.tree-leaf {position:relative;margin:5px auto 5px auto;white-space:nowrap;}
	.tree-leaf .tree-child-leaves {display:block;margin-left:15px;}
	.tree-leaf .hidden {display:none;}
	.tree-leaf .tree-expando {display:none;}
	.tree-leaf .hidden {visibility:hidden;}
	.tree-leaf .tree-leaf-text {cursor:pointer;float:left;margin-left:5px;}
	.tree-leaf .tree-leaf-text:hover {text-decoration:underline;}
	.tree-leaf .tree-leaf-content:before, .tree-leaf .tree-leaf-content:after {content:" ";display:table;}
	.tree-leaf .tree-leaf-content:after {clear:both;}
	/*js-treeview>>>>>*/
    #viewChoicesMenu .dense,#viewChoicesMenu .normal,#viewChoicesMenu .low {margin-left:30px;display:block;}
	#FolderList,#FileList {display:flex;flex-wrap: wrap;overflow-y:hidden;}
	#FolderList,#FileList{padding-left:0px;margin:0 0 0 0;}
	#FolderList .isFolder{padding:0 0 0 5px;margin:0 0 0 0;}
	#FolderList{margin-left:16px;}
	#FileList{margin-left:20px;}
	<% if (!IsMobile()) { %>
	#FolderList{margin-left:23px;}
	#FileList{margin-left:20px;padding-left:7px;}
	<% } %>
	#menuBarTable{visibility:hidden;}
	#FileList {padding-bottom:50px;}
	.vGridItemRow .vGridCell.vGridNameCol .itemNameDiv{width:calc(100% - 60px);}
	.vGridItemRow .clickableFoldername,.vGridItemRow .clickableFilename{width:100%;}
	#rpt_teamFolders,#rpt_myFaves,#rpt_myShares,#rpt_sharedWithMe{width:calc(100% - 35px);} 
	#rpt_recentFiles{width:100%;}
	#rpt_searchResults{width:100%;}
	.tagMatched{display:inline-block;background-color:green;padding:5px;border-radius:5px;margin-right:5px;margin-top:5px;}
    .tagUnmatched{display:inline-block;background-color:red;padding:5px;border-radius:5px;margin-right:5px;margin-top:5px;}
	.lstLine2Left{float:left !important;width:calc(100% - 25px) !important;overflow-x:hidden;}
	<% if (IsMobile()) { %>
	.vGridItemRow .clickableFoldername, .vGridItemRow .clickableFilename {width: calc(100% - 40px) !important;overflow-x: hidden;}
	<% } %>
    .hand{cursor:pointer !important;}
    ::-webkit-scrollbar {width: auto !important;}
	<% if (!IsMobile()) { %>
    .lstLine2Left{display:none !important;}
    .lstLine2Left .nodeVersion{display:none !important;}
    .lstLine2Left .nodeSize{display:none !important;}
    .lstLine2Left .nodeType{display:none !important;}
    .lstLine2Left .nodeDate{display:none !important;}
	@media (min-width: 0px) and (max-width: 1024px) {
        #ListView .vGridCell.vGridVersionCol.sidebarOpened{display:none !important;}
        #ListView .vGridCell.vGridSizeCol.sidebarOpened{display:none !important;}
        #ListView .vGridCell.vGridTypeCol.sidebarOpened{display:none !important;}
        #ListView .vGridCell.vGridDateCol.sidebarOpened{display:none !important;}
        .lstLine2Left.sidebarOpened {display:block !important;}
		.lstLine2Left.sidebarOpened .nodeVersion,.lstLine2Left .fmtNodeSize,.lstLine2Left .fmtNodeType,.lstLine2Left .nodeDateSep,.lstLine2Left .fmtNodeDate{display:inline-block !important;}
	}
	@media (min-width: 1025px) and (max-width: 1179px) {
        #ListView .vGridCell.vGridVersionCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridSizeCol.sidebarOpened{display:none !important;}
        #ListView .vGridCell.vGridTypeCol.sidebarOpened{display:none !important;}
        #ListView .vGridCell.vGridDateCol.sidebarOpened{display:none !important;}
        .lstLine2Left.sidebarOpened {display:block !important;}
		.lstLine2Left.sidebarOpened .nodeVersion{display:none !important;}
		.lstLine2Left.sidebarOpened .fmtNodeSize,.lstLine2Left .nodeDateSep,.lstLine2Left .fmtNodeDate{display:inline-block !important;}
	}
	@media (min-width: 1180px) and (max-width: 1259px) {
        #ListView .vGridCell.vGridVersionCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridSizeCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridTypeCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridDateCol.sidebarOpened{display:none !important;}
        .lstLine2Left.sidebarOpened {display:block !important;}
		.lstLine2Left.sidebarOpened .nodeVersion,.lstLine2Left .fmtNodeSize,.lstLine2Left .fmtNodeType,.lstLine2Left .nodeDateSep{display:none !important;}
		.lstLine2Left.sidebarOpened .fmtNodeDate{display:inline-block !important;}
	}
    #filediv {width:calc(100vw - 45px)}
    #list_sharedWithMe, #list_myShares{width:100%}
    #list_sharedWithMe .ListViewContainer, #list_myShares .ListViewContainer{width:100%}
	@media (min-width: 1260px) {
        #ListView .vGridCell.vGridVersionCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridSizeCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridTypeCol.sidebarOpened{display:table-cell !important;}
        #ListView .vGridCell.vGridDateCol.sidebarOpened{display:table-cell !important;}
        .lstLine2Left.sidebarOpened {display:none !important;}
		.lstLine2Left.sidebarOpened .nodeVersion,.lstLine2Left .fmtNodeSize,.lstLine2Left .fmtNodeType,.lstLine2Left .nodeDateSep,.lstLine2Left .fmtNodeDate{display:none !important;}
        /*#list_sharedWithMe .ListViewContainer, #list_myShares .ListViewContainer{width:calc(100% - 80px)}*/
        #filediv {width:calc(100vw - 320px)}
        /*#list_sharedWithMe, #list_myShares{width:calc(100% - 45px)}*/
	}
	<% } %>
    #list_sharedWithMe .vGridItemRow .vGridNameCol .clickableFoldername {white-space:normal;}
	.sharedInfoButton{}
	#divLoading{z-index:9999 !important;}
    .vGridCell.vGridNameCol.vGridClip{display:flex;align-items:center;font-size:12px !important;padding: 0px 10px !important;}
    .vGridItemRow .vGridCell.vGridNameCol .itemNameDiv {overflow:hidden;float:left;height:20px;line-height:20px;}
    .overflowDots{flex: 0 0 15px !important;}
    .lstLine2Right{flex: 0 0 20px !important;}
    <% if (IsMobile()) { %>
    .vGridCell.mobileMoreColumn .lstLine2Left {padding-right:10px;width:calc(100% - 10px) !important;font-size:12px;}
    .vGridItemRow .clickableFoldername, .vGridItemRow .clickableFilename { width:100% !important;overflow-x:hidden;}  
    @media (min-width:1px) and (max-width:519px) {
        .lstLine2Left { display:inline-block; }
        .vGridCell.vGridNameCol.vGridClip{width:calc(100vw - 130px);}
        .vGridCell.mobileMoreColumn{width:160px;text-align:right;}
        #ListViewFiles .lstLine2Right .moreMenu{margin-top:0px;line-height:1.2;}
        .fmtNodeSize,.nodeType,.nodeVersion,.nodeDateSep,.fmtNodeDate{ display:none; }
	}
    @media (min-width:520px) and (max-width:639px) {
        .lstLine2Left { display:inline-block; }
        .vGridCell.vGridNameCol.vGridClip{width:calc(100vw - 130px);}
        .vGridCell.mobileMoreColumn{width:160px;text-align:right;}
        #ListViewFiles .lstLine2Right .moreMenu{margin-top:0px;line-height:1.2;}
        .fmtNodeSize,.nodeType,.nodeVersion,.nodeDateSep{ display:none; }
        .fmtNodeDate { display:inline-block;width:65px !important;height:18px;overflow:hidden; }
        .vGridCell.vGridNameCol.vGridClip{width: calc(100vw - 200px);}
	}
    @media (min-width: 640px) and (max-width:799px) {
        .lstLine2Left { display:inline-block; }
        .nodeDateSep { display:inline-block;width:10px; }
        .fmtNodeDate { display:inline-block;width:65px !important;height:18px;overflow:hidden; }
        .vGridCell.vGridNameCol.vGridClip{width: calc(100vw - 330px);}
        .vGridCell.mobileMoreColumn{width:160px;text-align:right;padding-left:0px !important;}
        #ListViewFiles .lstLine2Right .moreMenu{margin-top:0px;line-height:1.2;}
	}
    @media (min-width: 800px) {
        .lstLine2Left { display:inline-block; }
        .nodeDateSep { display:inline-block;width:10px; }
        .fmtNodeDate { display:inline-block;width:auto !important; }
        .vGridCell.vGridNameCol.vGridClip{width: calc(100vw - 410px);}
        .vGridCell.mobileMoreColumn{width:290px;text-align:right;}
        #ListViewFiles .lstLine2Right .moreMenu{margin-top:0px;line-height:1.2;}
    }
	<% } else { %>
	@media (min-width: 0px) and (max-width: 640px) {
        .vGridCell.vGridNameCol.vGridClip{width: 145px;}
	}
	@media (min-width: 1511px) {
        .vGridCell.vGridNameCol.vGridClip{width: 100%;}
	}    
    .vGridItemRow .vGridCell.vGridNameCol .itemNameDiv { flex:0 0 100%; }
	<% } %>
    .vGridCheckbox.vGridFile.listOnlyHidden,.vGridCheckbox.vGridFolder.listOnlyHidden{display:none !important;}    
    .zeroByteList {margin-left: 30px !important;padding-top: 10px !important;}
    .zeroByteList li {font-size:15px !important;}
    #folderFilterContainer {display:inline-block;margin-top:-10px;height:15px;}
    #folderFilterFlex{display:flex;align-items:center;font-size:14px;font-weight:100;cursor:pointer;padding-left: 7px;}
    #folderFilterButton{font-size:12px;margin-top: 5px;}
    #filterFoldersBreadcrumTextField{display:none;margin-left: 7px;height:22px;width:100px;}
    #breadcrumFilter .bmd-form-group {padding-top:0px;height:22px;margin-top: 0px;}

    #recentPrevButton,#recentNextButton{color:white !important;font-size:32px;line-height:45px;position:fixed;bottom:30px;z-index:1000;width:50px;height:50px;border:0;border-radius:35px;padding:0px;display:none;}
    <% if (m_HasMoreRecentItemsNextPage){ %>
    #recentNextButton { display:block; }
    <% } %>
    #GProgressError{white-space:nowrap;display:flex;}
    #GProgressError span{display:inline-block;overflow-x:hidden;white-space:nowrap;max-width:335px;}
    /*hide checkboxes on quick access page under list view*/
    .ListViewContainer.currPage_1 input[type=checkbox]{display:none;}

    /*list view   My Team Folders                    My Folders                  My Favorites */
    .ListViewContainer.currPage_8,.ListViewContainer.currPage_9,.ListViewContainer.currPage_4{height: calc(100vh - 70px) !important;}
    .hideOnRepeaters{visibility:hidden !important;}

    @media (max-width:849px) {
        #ShortWindowModal .modal-dialog {width:100vw !important;max-width:100vw !important;margin-left:0px;margin-right:0px;}
	}
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToCreFol" meta:resourcekey="str_faiToCreFol" Visible="false">failed to create folder</asp:Localize>
<asp:Localize runat="server" ID="LocFolNamCanNotBeEmp" meta:resourcekey="str_folNamCanNotBeEmp" Visible="false">folder names can not be empty</asp:Localize>
<asp:Localize runat="server" ID="LocDchFldFal" meta:resourcekey="str_dchFldFal" Visible="false">Failed to detach folder</asp:Localize>
    <div id="maindiv">
        <table  id="maindivtbl">
            <tr>
                <td class="btniconcolor">
                    <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" onclick="parent.CloseMainWindow(); return false;" style="font-size: 48px; margin-top: -13px; margin-left: -1px;" title="<%=str_filebrowser.Text %>">^</span><br />
                    <asp:Localize meta:resourcekey="str_filebrowser" ID="str_filebrowser" Visible="false" runat="server">File Browser</asp:Localize>
                </td>
                <td class="btniconcolor">
                    <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" style="font-size: 48px; margin-top: -10px; margin-left: -1px;" onclick="OnNewFolder();" title="<%=str_newFolder.Text %>">&#xC8;</span><br />
                </td>
                <td class="btniconcolor">
                    <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" style="font-size: 48px; margin-top: -13px; margin-left: -1px;" onclick="OnUploadFiles(false);" title="<%=str_uploadfiles.Text %>">&#xC6;</span><br />
                </td>
                <td class="btniconcolor">
                    <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" onclick="parent.downloadDesktop(); return false;" style="font-size: 40px; margin-top: -13px; margin-left: -1px;" title="<%=str_downloads.Text %>">&#xC5;</span><br />
                    <asp:Localize meta:resourcekey="str_downloads" ID="str_downloads" runat="server">Downloads</asp:Localize>
                </td>
                <td class="btniconcolor">
                    <% if (m_HasSearchResult)
                        { %>
                    <asp:LinkButton ID="GoHome" runat="server" OnClick="GoHome_Click" OnClientClick="Wait('...');">
                        <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" style="font-size: 48px; margin-top: -13px; margin-left: -1px;" title="<%=str_filedash.Text %>">t</span><br/>
                    </asp:LinkButton>
                    <asp:Localize meta:resourcekey="str_filedash" ID="str_filedash" runat="server">File Dashboard</asp:Localize>
                    <% } %>
                </td>
                <td> <%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
                         <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                     <% } %></td>
                <td style="padding: 10px;width:322px;">&nbsp;</td>
            </tr>
        </table>
        <table id="maintbl">
            <tr>
                <td id="leftmenutd" style="<% if (IsMobile()){ %>
                                 display: none;
                        <% }%>" valign="top">

                    <table width="100%">
                        <% if (!m_disableSearch) { %>
                        <tr id="fullSearchBoxRow">
                            <td colspan="2" style="padding-bottom: 10px; padding-right: 0px;">
                                <asp:Panel ID="Panel1" runat="server" DefaultButton="SearchFiles">
                                    <div style="padding-left: 0px;" class="trbordercolor">
                                        <table width="100%">
                                            <tr>
                                                <td height="45px" style="padding-right: 10px;" align="right">
                                                    <asp:TextBox ID="SearchText" CssClass="form-control" runat="server" onkeyup="autoSuggestSearchTags()" onfocus="autoSuggestSearchTags()" list="suggestTagsOptions" autocomplete="off"></asp:TextBox><datalist id="suggestTagsOptions"></datalist>
                                                </td>
                                                <td width="32px" align="left">
                                                    <asp:LinkButton ID="SearchFiles" runat="server" OnClick="SearchFiles_Click" OnClientClick="dontSearchIfEmpty(event);Wait('...');">
                                                <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" style="font-size: 18px; margin-top: -3px; margin-left: -6px;">&#xA7;</span>
                                                    </asp:LinkButton>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr id="miniSearchRow" onclick="OnMiniSearch();">
                            <td class="leftMenuIcon" colspan="2">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="Search">&#xA7;</span>
                            </td>
                        </tr>
                        <% }%>

                        <% if (m_guestMode) { %>
                        <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr class="<%=m_SharedClass %>" onclick="OnShared() " id="ms_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_ffsha.Text %>">k</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_ffsha" id="Localize1" runat="server">Shared files/folders</asp:Localize></span>
                            </td>
                        </tr>
                         <% } else {%>
                         <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr onclick="OnAllMyFiles();clearSearch();resetRecentNavButtons();return false;" id="mf_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_allmyf.Text %>">t</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_allmyf" ID="str_allmyf" runat="server">All my files</asp:Localize></span>
                            </td>
                        </tr>
                        <% }%>
                        <% if (!m_dontShowRecentActivities) { %>
                         <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr class="<%=m_QuickAccessClass %>" onclick="OnQuickAccess();resetRecentNavButtons();" id="myq_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_quickAccess.Text %>">&#xDB;</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_quickAccess" id="str_quickAccess" runat="server">Quick access</asp:Localize></span>
                            </td>
                        </tr>
                        <% }%>
                        <% if (!m_hideMyFavorites) { %>
                        <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr class="<%=m_StarClass %>" onclick="OnStared();resetRecentNavButtons();" id="mfav_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_myfav.Text %>">&#xE9;</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_myfav" ID="str_myfav" runat="server">My favorites</asp:Localize></span>
                            </td>
                        </tr>
                        <% }%>
                        <% if (!SessionIsAdmin && !m_guestMode && !IsServo) { %>
                        <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr class="<%=m_FolderClass %>" onclick="OnMyFolders();resetRecentNavButtons();" id="perFld_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_myFolders.Text %>">#</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn"><%=str_myFolders.Text %></span>
                            </td>
                        </tr>
                        <% } %>
                        <% if (!SessionIsAdmin && !m_guestMode && !m_hideMyTeamFolders && !IsServo) { %>
                        <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr class="<%= m_TeamClass %>" onclick="OnTeamFolder();resetRecentNavButtons();" id="mt_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_myTeamFolder.Text %>">+</span>
                            </td>
                            <td class="leftMenuLabel">
                                <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_myTeamFolder" id="str_myTeamFolder" runat="server">My team folders</asp:Localize></span>
                            </td>
                        </tr>
                        <% } %>
						<% if (!m_guestMode) { %>

						<% if (!m_hideSharedFilesFolders) { %>    
                        <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr class="<%=m_SharedClass %>" onclick="OnShared();resetRecentNavButtons();" id="ms_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_ffsha.Text %>">k</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_ffsha" id="str_ffsha" runat="server">Shared files/folders</asp:Localize></span>
                            </td>
                        </tr>
                        <% } %>
						<% if (!m_dontShowDeviceBackups) { %>
                         <tr><td colspan="2" height="10px" style="overflow: hidden;"></td></tr>
                        <tr style="" onclick="OnDeviceBackup();resetRecentNavButtons();return false;" id="db_tr">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=str_endpoint.Text %>">&#x60;</span>
                            </td>
                            <td class="leftMenuLabel">
                                <span class="sectextcolor toolnavbtn"><asp:Localize meta:resourcekey="str_endpoint" ID="str_endpoint" runat="server">Device backups</asp:Localize></span>
                            </td>
                        </tr>
                        <% } %>

                        <% } %>
                        <% if (!SessionFromClient && !m_disableClientDownload && !m_hideDeviceDownloadLink && !FromClientShell) { %>
                         <tr><td colspan="2" style="height:10px;"></td></tr>
                        <tr onclick="downloadDesktop();return false;" id="downloadNativeRow">
                            <td class="leftMenuIcon">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" id="desktopClientIcon" data-toggle="tooltip" data-placement="bottom" data-original-title="">&#xEC;</span>
                            </td>
                            <td class="leftMenuLabel">
                                 <span class="sectextcolor toolnavbtn" id="installTxt"></span>
                            </td>
                        </tr>
                        <% } %>

                        <% if (!m_guestMode && !m_hideStorageStats) { %>
                        <tr id="statsRowDivider"><td colspan="2" class="boxbordercolor"></td></tr>
						<tr id="statsRow" onclick="OnStorageDetails();resetRecentNavButtons();">
                            <td class="statsIconCell">
                                 <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" id="statsIcon">C</span>
                            </td>
                            <td class="statsLabel">
                                 <span class="sectextcolor toolnavbtn noUnderline" id="statsTxt"></span>
                            </td>
                        </tr>
                        <% } %>

                    </table>
                </td>
                <td valign="top" id="DefaultContent">
                    <div id="filediv">

        <% if (!m_disableSearch && !m_HasSearchResult) { %>
        <div id="rpt_emptySearchResults" style="display:none;"></div>
        <% } %>
        <% if (!m_disableSearch && m_HasSearchResult) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);border-bottom:1px solid #E0E0E0;">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_searchResult" runat="server">Search Result:</asp:Localize></td>
            <td class="text-right rptActionIcons">
                <span id="sr_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="refreshSearch();" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="sr_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('sr_viewButton');" >&#xBA;</span>
            </td>
            </tr>
        </table>
        <div id="rpt_searchResults">
            <asp:Repeater ID="SResultRepeater" runat="server">
                <ItemTemplate>
                    <div class="sResultItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>" style="padding-bottom: 25px!important;">
                        <div class="filebox">
                            <div class="filenode iconobj boxbordercolor clickableFileNode" data-toggle="tooltip" data-placement="bottom" data-custom-class="tooltip-searchResult" data-original-title="<%#DataBinder.Eval(Container.DataItem, "DescTitle")%>" style="background-color: white;"  id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick="OnItemClickedFromSearchResults('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>','rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>');">
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">
                                    <span class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                   <span class='titletxt' style='vertical-align: middle;'> <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = rpt_isDeleted("<%#DataBinder.Eval(Container.DataItem, "LastOp")%>");obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = "<%#DataBinder.Eval(Container.DataItem, "Faved")%>";obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "<%#DataBinder.Eval(Container.DataItem, "SupportCut")%>";obj.SupportMove = "<%#DataBinder.Eval(Container.DataItem, "SupportMove")%>";obj.SupportPreview = "<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>";obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastUpdateUserName = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateUserName")%>";obj.Ext = getFileExtensionFromObj(obj);obj.SupportPreview = getSupportPreviewFromObj(obj);obj.LastUpdateSec = getLastUpdateSecFromObj(obj);obj.SearchedTags = "<%#DataBinder.Eval(Container.DataItem, "DescTitle").ToString().Replace("\n","\\n")%>";})();
                    </script>
                </ItemTemplate>
                <FooterTemplate>
                    <script type="text/javascript">
                        setCurrentPage(_dashboardPages.searchResults);
                        getFolderStats(_m_storageQuotaGB,_m_storageUsedBytes);
						ForceNavigateToInitialFolder(true);
                    </script>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <% } %>
        <% if (m_HasRecent && !m_dontShowRecentActivities) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);border-bottom:1px solid #E0E0E0;">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_quickAccess" runat="server">Quick Access:</asp:Localize></td>
            <td class="text-right rptActionIcons">
                <span id="qa_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="refreshQuickAccess();" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="qa_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('qa_viewButton');">&#xBA;</span>
            </td>
            </tr>
        </table>
        <div id="rpt_recentFiles" style="display:none;" >
            <asp:Repeater ID="QuickAccessRepeater" runat="server">
                <ItemTemplate>
                    <div class="quickPanelItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>">
                        <div class="filebox" >
                            <div class="filenode iconobj boxbordercolor clickableFileNode" title="<%#DataBinder.Eval(Container.DataItem, "DescTitle")%>" style="background-color: white; overflow: hidden;" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');">
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">

                                    <span class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                    <span class='titletxt' style='vertical-align: middle;'> <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = rpt_isDeleted("<%#DataBinder.Eval(Container.DataItem, "LastOp")%>");obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = "<%#DataBinder.Eval(Container.DataItem, "Faved")%>";obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "<%#DataBinder.Eval(Container.DataItem, "SupportCut")%>";obj.SupportMove = "<%#DataBinder.Eval(Container.DataItem, "SupportMove")%>";obj.SupportPreview = "<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>";obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastAccessedSec = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateSec")%>";obj.LastUpdateUserName = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateUserName")%>";obj.Ext = getFileExtensionFromObj(obj);obj.SupportPreview = getSupportPreviewFromObj(obj);obj.LastUpdateSec = getLastUpdateSecFromObj(obj);})();
                    </script>
                </ItemTemplate>
                <FooterTemplate>
                    <script type="text/javascript">
                        setCurrentPage(_dashboardPages.recentFiles);
                        getFolderStats(_m_storageQuotaGB,_m_storageUsedBytes);
						ForceNavigateToInitialFolder(true);
                    </script>
                </FooterTemplate>
            </asp:Repeater>
        </div>                    
        <% } %>
        <% if (m_HasFolders) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_myFolders" ID="str_myFolders" runat="server">My Folders</asp:Localize></td>
            <td class="text-right rptActionIcons">
                <span id="pf_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="msMainWndRefreshDir();" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="pf_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('pf_viewButton');" style="font-size: 29px; margin-top:0px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" >&#xBA;</span>
            </td>
            </tr>
        </table>
        <div class="row1" id="rpt_myFiles" style="display:none;">
            <asp:Repeater ID="MyFoldersRepeater" runat="server">
                <ItemTemplate>
                    <div class="myFoldersItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>">
                        <div class="filebox">
                            <div class="filenode iconobj boxbordercolor clickableFileNode" title="<%#DataBinder.Eval(Container.DataItem, "DescTitle")%>" style="background-color: white;padding-right: 5px;"  id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');">
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">
                                    <span onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');" class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                   <span class='titletxt' style='vertical-align: middle;'> <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = rpt_isDeleted("<%#DataBinder.Eval(Container.DataItem, "LastOp")%>");obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = "<%#DataBinder.Eval(Container.DataItem, "Faved")%>";obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "<%#DataBinder.Eval(Container.DataItem, "SupportCut")%>";obj.SupportMove = "<%#DataBinder.Eval(Container.DataItem, "SupportMove")%>";obj.SupportPreview = "<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>";obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastUpdateUserName = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateUserName")%>";obj.Ext = getFileExtensionFromObj(obj);obj.SupportPreview = getSupportPreviewFromObj(obj);obj.LastUpdateSec = getLastUpdateSecFromObj(obj);})();
                    </script>
                </ItemTemplate>
                <FooterTemplate>
                    <script type="text/javascript">
                        setCurrentPage(_dashboardPages.personalFolders);
                        getFolderStats(_m_storageQuotaGB,_m_storageUsedBytes);
                    </script>
                </FooterTemplate>
            </asp:Repeater>
            <% if (m_HasMore) { %>
            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-2  " style="padding: 10px;">

                            <div style=" cursor: pointer; padding: 5px; padding-top: 10px; font-weight: 100;" class="sectextcolor"   onclick='parent.CloseMainWindowWithDir("");'><asp:Localize runat="server" meta:resourcekey="str_Mor">More ...</asp:Localize></div>
                    </div>
            <% } %>
        </div>
        <% } %>
        <% if (m_HasTeamFolder && !m_hideMyTeamFolders) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_myTeamFolder" runat="server">My Team Folders:</asp:Localize></td>
            <td class="text-right rptActionIcons">
                <span id="tf_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="msMainWndRefreshDir();" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="tf_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('tf_viewButton');" style="font-size: 29px; margin-top:0px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" >&#xBA;</span>
            </td>
            </tr>
        </table>
        <div id="rpt_teamFolders" style="display:none;">
            <asp:Repeater ID="TeamFolderRepeater" runat="server">
                <ItemTemplate>
                    <div class="teamFolderItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>">
                        <div class="filebox">
                            <div class="filenode iconobj boxbordercolor clickableFileNode" title="<%#DataBinder.Eval(Container.DataItem, "DescTitle")%>" style="background-color: white;padding-right: 5px;"  id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');">
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">
                                    <span onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');" class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                   <span class='titletxt' style='vertical-align: middle;'> <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = rpt_isDeleted("<%#DataBinder.Eval(Container.DataItem, "LastOp")%>");obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = "<%#DataBinder.Eval(Container.DataItem, "Faved")%>";obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "<%#DataBinder.Eval(Container.DataItem, "SupportCut")%>";obj.SupportMove = "<%#DataBinder.Eval(Container.DataItem, "SupportMove")%>";obj.SupportPreview = "<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>";obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastUpdateUserName = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateUserName")%>";obj.Ext = getFileExtensionFromObj(obj);obj.SupportPreview = getSupportPreviewFromObj(obj);obj.LastUpdateSec = getLastUpdateSecFromObj(obj);})();
                    </script>
                </ItemTemplate>
                <FooterTemplate>
                    <script type="text/javascript">
                        setCurrentPage(_dashboardPages.teamFolders);
                        getFolderStats(_m_storageQuotaGB,_m_storageUsedBytes);
						ForceNavigateToInitialFolder(true);
                    </script>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <% } %>      
        <% if (!m_hideSharedFilesFolders) { %>          
        <% if (m_HasSharedWith) { %>                
        <table class="breadcrumTable" style="width:calc(100% - 20px);border-bottom:1px solid #E0E0E0;">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_ffsha" runat="server">Shared files/folders</asp:Localize></td>
            <td class="text-right rptActionIcons" style="padding-right:30px;">
                <span id="sm_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="OnShared();" style="font-size: 38px; margin-top:-5px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="sm_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('sm_viewButton');" style="font-size: 29px; margin-top:0px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" >&#xBA;</span>
                <span id="sharedInfoButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor infoButton sharedInfoButton" onclick="OnToggleSharedItem();">J</span>
            </td>
            </tr>
        </table>
        <% } %>
        <% if (m_HasSharedWith || m_HasSharedBy) { %>
        <div style="display: none;">
            <asp:HiddenField ID="ShareAclType" runat="server" />
            <asp:HiddenField ID="ShareLoc" runat="server" />
            <asp:HiddenField ID="ShareId" runat="server" />
            <asp:HiddenField ID="ShareAclEmail" runat="server" />
            <asp:HiddenField ID="OwnerId" runat="server" />
            <asp:HiddenField ID="DeleteFile" runat="server" />
            <asp:HiddenField ID="Token" runat="server" />
            <asp:HiddenField ID="Vendor" runat="server" />
            <asp:HiddenField ID="PVendor" runat="server" />
            <asp:Button ID="DeleteAcl" runat="server" Text="Button" OnClick="DeleteAcl_Click" />
        </div>
        <div id="sharedItemsContainer">
        <% } %>
        <% if (m_HasSharedWith) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);border-bottom:1px solid #E0E0E0;">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_fileShareWithMe" runat="server">Files/Folders shared with me:</asp:Localize></td>
            </tr>
        </table>
        <div id="list_sharedWithMe" style="display:none;"></div>
        <div id="rpt_sharedWithMe" style="display:none;">
            <asp:Repeater ID="ShareWithMeRepeater" runat="server">
                <ItemTemplate>
                    <div class="shareWithMeItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>">
                        <div class="filebox">
                            <div class="filenode iconobj boxbordercolor clickableFileNode" title="<%#DataBinder.Eval(Container.DataItem, "DisplayName")%>" style="background-color: white; padding-right: 5px;"  id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick='OnSharedWithMeItemClicked(event,"rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>","<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>","<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>","<%#DataBinder.Eval(Container.DataItem, "ViewOnly")%>");'>
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">
                                    <span onclick='OnSharedWithMeItemClicked(event,"rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>","<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>","<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>","<%#DataBinder.Eval(Container.DataItem, "ViewOnly")%>");' class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                   <span class='titletxt' style='vertical-align: middle;'><%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.DownloadDisabled = isTrue("<%#DataBinder.Eval(Container.DataItem, "ViewOnly")%>");obj.PreviewDisabled = !isTrue("<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>");obj.Perm = "<%#DataBinder.Eval(Container.DataItem, "Perm")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = false;obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = false;obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "false";obj.SupportMove = "false";obj.SupportPreview = "<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>";obj.ViewOnly = "<%#DataBinder.Eval(Container.DataItem, "ViewOnly")%>";obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastUpdateUserName = "";obj.SharePermissions = "<%#DataBinder.Eval(Container.DataItem, "SPVendorData")%>";obj.Ext = "<%#DataBinder.Eval(Container.DataItem, "Ext")%>";obj.SupportPreview = getSupportPreviewFromObj(obj);obj.LastUpdateSec = getLastUpdateSecFromObj(obj);})();
					</script>
                </ItemTemplate>
            </asp:Repeater>
        </div>
        <% } %>
        <% if (m_HasSharedBy) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);border-bottom:1px solid #E0E0E0;">
            <tr>
            <td class="breadcrumFont"><asp:Localize meta:resourcekey="str_filSharedBy" runat="server">Files/Folders shared by me:</asp:Localize></td>
            <% if (!m_HasSharedWith) { %>
            <td class="text-right rptActionIcons" style="padding-right:30px;">
                <span id="sb_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="OnShared();" style="font-size: 38px; margin-top:-5px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="sb_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('sb_viewButton');" style="font-size: 29px; margin-top:0px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" >&#xBA;</span>
                <span id="sharedInfoButton2" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor infoButton sharedInfoButton" onclick="OnToggleSharedItem();">J</span>
            </td>
            <% } %>
            </tr>
        </table>
        <div id="list_myShares" style="display:none;" onclick="CloseSideBar();"></div>
        <div id="rpt_myShares" style="display:none;" onclick="CloseSideBar();">
            <asp:Repeater ID="MySharesRepeater" runat="server">
                <ItemTemplate>
                    <div class="mySharesItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>">
                        <div class="filebox">
                            <div class="filenode iconobj boxbordercolor clickableFileNode" title="<%#DataBinder.Eval(Container.DataItem, "DisplayName")%>" style="background-color: white;"  id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick="OnSharedByMeItemClicked(event,'<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>','rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>');">
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">
                                    <span class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                   <span class='titletxt' style='vertical-align: middle;'> <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = rpt_isDeleted("<%#DataBinder.Eval(Container.DataItem, "LastOp")%>");obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = "<%#DataBinder.Eval(Container.DataItem, "Faved")%>";obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "<%#DataBinder.Eval(Container.DataItem, "SupportCut")%>";obj.SupportMove = "<%#DataBinder.Eval(Container.DataItem, "SupportMove")%>";obj.Perm = 120;obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastUpdateUserName = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateUserName")%>";obj.SharePermissions = "<%#DataBinder.Eval(Container.DataItem, "SPVendorData")%>";obj.Ext = getFileExtensionFromObj(obj);obj.SupportPreview = "True";obj.ViewOnly="False";obj.DownloadDisabled="False";obj.PreviewDisabled="False";obj.LastUpdateSec = getLastUpdateSecFromObj(obj);})();
                    </script>
                </ItemTemplate>
            </asp:Repeater>
        </div>
        <% } %>
        <% if (m_HasSharedWith || m_HasSharedBy) { %>
        </div>
        <script type="text/javascript">
            setCurrentPage(_dashboardPages.sharedFiles);
            getFolderStats(_m_storageQuotaGB,_m_storageUsedBytes);
			ForceNavigateToInitialFolder(true);
        </script>
        <% } %>
        <% } %>
        <% if (m_HasStars && !m_hideMyFavorites) { %>
        <table class="breadcrumTable" style="width:calc(100% - 20px);border-bottom:1px solid #E0E0E0;">
            <tr>
            <td class="breadcrumFont"><%=str_myfav.Text %></td>
            <td class="text-right rptActionIcons">
                <span id="mf_refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="refreshFaves();" style="font-size: 38px; margin-top:-5px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>
                <span id="mf_viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('mf_viewButton');" style="font-size: 29px; margin-top:0px; margin-left:0px; padding-right:5px;height:30px;line-height:100%;" >&#xBA;</span>
            </td>
            </tr>
        </table>
        <div id="rpt_myFaves" style="display:none;">
            <asp:Repeater ID="MyFavRepater" runat="server">
                <ItemTemplate>
                    <div class="myFavesItem rptItem <%#DataBinder.Eval(Container.DataItem, "IsFolder").ToString() == "True" ? "rptFolder" : "rptFile" %>" id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>">
                        <div class="filebox">
                            <div class="filenode iconobj boxbordercolor clickableFileNode" title="<%#DataBinder.Eval(Container.DataItem, "DescTitle")%>" style="background-color: white;"  id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_n" onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');">
                                <div class="icodiv" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico">
                                    <span onclick="OnItemClicked('<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>','<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>');" class="gladinet-icons md-dark hand center toolbtn " id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                <img class="thumbimg" style="display: none;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                                <div class="titlediv btniconcolor" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_tt" >
                                   <span class='titletxt' style='vertical-align: middle;'> <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <script type="text/javascript">
                        (function(){var obj = document.getElementById("rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>");obj.Attribute = "<%#DataBinder.Eval(Container.DataItem, "Attribute")%>";obj.PreviewImgUrl = "<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>";obj.IsDeleted = rpt_isDeleted("<%#DataBinder.Eval(Container.DataItem, "LastOp")%>");obj.AliasLocation = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "AliasLocation"))%>");obj.Faved = "true";obj.IsFolder = "<%#DataBinder.Eval(Container.DataItem, "IsFolder")%>";obj.Key = rpt_fixLeadingDoubleSlash("<%#SanitizeOutput(DataBinder.Eval(Container.DataItem, "Key"))%>");obj.Size = "<%#DataBinder.Eval(Container.DataItem, "Size")%>";obj.SupportCut = "<%#DataBinder.Eval(Container.DataItem, "SupportCut")%>";obj.SupportMove = "<%#DataBinder.Eval(Container.DataItem, "SupportMove")%>";obj.SupportPreview = "<%#DataBinder.Eval(Container.DataItem, "SupportPreview")%>";obj.LastModified = "<%#DataBinder.Eval(Container.DataItem, "LastModified")%>";obj.LastUpdateUserName = "<%#DataBinder.Eval(Container.DataItem, "LastUpdateUserName")%>";obj.Ext = getFileExtensionFromObj(obj);obj.SupportPreview = getSupportPreviewFromObj(obj);obj.LastUpdateSec = getLastUpdateSecFromObj(obj);})();
                    </script>
                </ItemTemplate>
                <FooterTemplate>
                    <script type="text/javascript">
                        setCurrentPage(_dashboardPages.myFaves);
                        getFolderStats(_m_storageQuotaGB,_m_storageUsedBytes);
						ForceNavigateToInitialFolder(true);
                    </script>
                </FooterTemplate>
            </asp:Repeater>
        </div>
        <% } %>
        <% if (!m_HasSharedWith && !m_HasRecent && !m_HasSharedBy && !m_HasTeamFolder && !m_HasSearchResult && !m_HasFolders && !m_HasStars) { %>
            <div class="row1">
                <div id="emptyPageBreadcrum" class="col-md-12 breadcrumFont"></div>
            </div>
            <!--div  style="align-self: center; align-content: center; width: 100%; padding-top: 70px; font-size: 18px; font-weight: 100; ">
                <table width="100%">
                    <tr>
                        <td align="center" style="font-size: 24px; font-weight: 100; color: #565656;">
                           <asp:Localize meta:resourcekey="str_noItsFnd" runat="server">No items were found</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td align="center" style="padding-top: 40px;display: none;">
                            <table>
                                <tr>
                                    <td><span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" style="font-size: 30px; margin-top: -3px; margin-left: -1px;" onclick="OnNewFolder();" title="<%=str_newFolder.Text %>">&#xC8;</span></td>

                                     <td style="padding-left: 10px;"><span style="font-size: 18px; cursor: pointer; " onclick="OnNewFolder();" class="toolnavbtn"><asp:Localize meta:resourcekey="str_newFolder" ID="str_newFolder" runat="server">Create a new folder</asp:Localize></span></td>
                                </tr>
                                <tr><td colspan="2" height="30px">&nbsp;</td></tr>
                                  <tr>
                                    <td><span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" onclick="OnUploadFiles(false); return false;" style="font-size: 30px; margin-top: -3px; margin-left: -1px;" title="<%=str_uploadfiles.Text %>">&#xC6;</span></td>

                                     <td style="padding-left: 10px;"><span style="font-size: 18px; cursor: pointer; " class="toolnavbtn" onclick="OnUploadFiles(false); return false;"><asp:Localize meta:resourcekey="str_uploadfiles" id="str_uploadfiles" runat="server">Upload some files to root</asp:Localize></span></td>
                                </tr>
                                <tr>
                                    <td colspan="2" height="10px">&nbsp;</td>
                                </tr>
                                <tr style="display: none;">
                                    <td><span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" onclick="parent.downloadDesktop(); return false;" style="font-size: 30px; margin-top: -3px; margin-left: -1px;" title="<%=str_downloads.Text %>">&#xC5;</span></td>
                                    <td style="padding-left: 10px;"><span style="font-size: 18px; cursor: pointer; " onclick="parent.downloadDesktop(); return false;" class="toolnavbtn"><asp:Localize runat="server" meta:resourcekey="str_DowCliAccFilSeaFroDes">Download client, access files seamlessly from desktop</asp:Localize></span></td>
                                </tr>

                            </table>
                        </td>
                    </tr>
                </table>
            </div-->
        <% } %>
        <!-- Modal -->

                <!--div style="width: 300px; height: 100%; right: 10px; top: 30px; background-color: white;  border:1px solid #f0f0f0; padding: 2px; overflow: auto; position: absolute; display: none;" class="trbordercolor viewcard" id="subtaskpanel" >

            </div-->


        <div style="display: none">
            <input type="hidden" id="hidCurrRecentPageNum" runat="server" value="" />
            <asp:LinkButton ID="HideGoHome" runat="server" OnClick="GoHome_Click" OnClientClick="Wait('...');"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></asp:LinkButton>
            <asp:LinkButton ID="HideShared" runat="server" OnClick="GoShared_Click" OnClientClick="Wait('...');">shares</asp:LinkButton>
            <asp:LinkButton ID="HideStared" runat="server" OnClick="GoStar_Click" OnClientClick="Wait('...');">shares</asp:LinkButton>
            <asp:LinkButton ID="HideFolders" runat="server" OnClick="GoFolders_Click" OnClientClick="Wait('...');">shares</asp:LinkButton>
            <asp:LinkButton ID="HideTeamFolder" runat="server" OnClick="GoTeamFolder_Click" OnClientClick="Wait('...');">shares</asp:LinkButton>
        </div>
                        </div>
						<div ondrop="drop(event)" ondragenter="dragEnterEvt(event)" ondragover="allowDrop(event)" ondragleave="onLeve(event)">

					<table id="menuBarTable">
                            <tr>
                                <td id="allBreadCrumsTD">
                                    <table>
                                        <tr>
											<td id="treeButtonTd"><span id="treeButton" class="gladinet-icons hand btniconcolor" onclick="OnToggleTree();">&#xAB;</span></td>
                                            <td style=" font-size: 14px; font-weight: 100; cursor: pointer;" class="toolnavbtn sectextcolor breadcrumbFolder" onclick="CloseFolderView();" id="DefaultMode">
                                                <asp:Label ID="ModeText" runat="server" Text=""></asp:Label>
                                            </td>
                                            <td id="foldernav" style="color: #868686; font-size: 14px; font-weight: 100; cursor: pointer; " nowrap="nowrap"></td>
                                            <td id="appnav" style="color: #868686; font-size: 14px; font-weight: 100; cursor: pointer;"></td> 
                                        </tr>


                                    </table>
                                </td>
                                <td id="allBreadCrumsSpacerTD"></td>
                                <td id="writectrls">
                                    <div style="position:absolute;right:0;text-align:right;top:10px;background-color:#f8f8f8;">

                                    <span id="fabbarDiv">

                                        <span id="pasteButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor secsubbordercolor " onclick="OnPaste(false);" style="display:none;">&#xC2;</span>

                                        <span id="deleteButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor secsubbordercolor " onclick="cancelDefaults(event);ConfirmDelete();" style="display: none;">n</span>

                                        <span id="downloadButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor secsubbordercolor " onclick="OnDownload();" style="display: none;">&#xC5;</span>

                                        <span id="cutButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor secsubbordercolor " onclick="OnCut();" style="display: none;">&#xC1;</span>

                                        <span id="copyButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor secsubbordercolor " onclick="OnCopy();" style="display: none;">&#xC0;</span>

                                    </span>


                                    <span id="moreButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="onTogglePageContextMenu();" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#x110;</span>

                                    <span id="refreshButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor refreshButton" onclick="msMainWndRefreshDir();" data-toggle="tooltip" data-placement="bottom" data-original-title="<%=LocRefresh.Text %>">&#xB5;</span>

                                    <span id="viewTrashButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor" onclick="OnShowDeleted();">&#xD4;</span>

                                    <span id="purgeTrashButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor" onclick="OnPurgeDeleted();">.</span>

                                    <span id="viewButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor viewButton" onclick="OnToggleViewChoicesMenu('viewButton');">&#xBA;</span>

									<span id="infoButton" class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor infoButton" onclick="OnToggleSideBar();">J</span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="3" style="height:5px;font-size:1px;line-height:1px;">&nbsp;</td>
                            </tr>
                        </table>
					</div>
                    <div id="foldercontentdiv" ondrop="drop(event)" ondragenter="dragEnterEvt(event)" ondragover="allowDrop(event)" ondragleave="onLeve(event)">


                                    <div id="createMenu"></div>
                                    <!--div style="position:absolute; padding-top:13px; padding-left:3px; bottom:30px; right:10px; border:1px solid #cccccc; border-radius:50%; height:60px; width:60px;background-color: #0288d1;  box-shadow: 3px 3px 3px #cccccc ;"-->
                                    <span id="prevButton" onclick="OnPrevPage(event)" class="gladinet-icons md-24 highlighted hand center btniconcolor secsubbordercolor topnavcolor" style="color:white!important;font-size:32px;line-height:3px;letter-spacing:-5px;display:none;">&#x10A;</span>
                                    <span id="nextButton" onclick="OnNextPage(event)" class="gladinet-icons md-24 highlighted hand center btniconcolor secsubbordercolor topnavcolor" style="color:white!important;font-size:32px;line-height:3px;letter-spacing:-5px;display:none;">&#xDD;</span>
                                    <span id="createButtonParent"><span id="createButton" class="highlighted hand center btniconcolor secsubbordercolor topnavcolor" style="color:white!important;">+</span></span>   
                                    <% if (m_HasRecent && !m_dontShowRecentActivities) { %>
                                    <span id="recentPrevButton" onclick="OnRecentPrevPage(event)" class="gladinet-icons md-24 highlighted hand center btniconcolor secsubbordercolor topnavcolor" style="right:100px;padding-right:4px;">&#x10A;</span>
                                    <span id="recentNextButton" onclick="OnRecentNextPage(event)" class="gladinet-icons md-24 highlighted hand center btniconcolor secsubbordercolor topnavcolor" style="right:40px;padding-left:5px;">&#xDD;</span>
                                    <% } %>
                                    <!--/div-->
                        <div id="foldercontentsubdiv" style="overflow-y: auto;"><!-- beginDragSelection(event) currently interferring with drag and drop events -->
                        <iframe id="main_body" style="width: 100%; display: none;" frameborder="0" border="0" class="staticcard"></iframe>

                        <div class="row1" id="FolderList"></div>
                        <div class="row1" id="FileList"></div>

                        <div style="display: none; width: 100%; height: 200px; font-weight: 100; font-size: 18px; align-self: center; padding-top: 40px;justify-content: center; text-align: center;" id="EmptyPanel" class="sectextcolor">
                            <asp:Localize meta:resourcekey="str_fldIsEmt" runat="server">Folder is empty</asp:Localize>
                            <br/><br/><span id="dragAndDropMsg">
                            <asp:Localize meta:resourcekey="str_drgNDropToUpd" runat="server">(Drag & drop files here to upload)</asp:Localize></span>
                        </div>
                            </div>
                    </div>
						<script type="text/javascript">
							addTooltipProps("moreButton", ExplorerDetail_more_actions);
							addTooltipProps("createButton", "<%=LocAdd.Text %>");
							addTooltipProps("pasteButton", "<%=LocPaste.Text %>");
							addTooltipProps("deleteButton", "<%=LocDelete.Text %>");
							addTooltipProps("downloadButton", "<%=LocDownload.Text %>");
							addTooltipProps("cutButton", "<%=LocCut.Text %>");
							addTooltipProps("copyButton", "<%=LocCopy.Text %>");
						</script>
                    </td>

            </tr>
        </table>
        <div id="ShortWindowModal" class="modal fade" role="dialog">
            <div class="modal-dialog " 
                <% if (m_language!=null && ("de".Equals(m_language) || m_language.StartsWith("de-"))) { %>
                style="width: 1000px; max-width:1000px;"
                <% } else { %>
                    <%if (IsMobile()){ %>
                        style="width:100vw;"
                    <%}else {%>
                        style="width: 850px; max-width:850px;"
                    <% } %>
                <% } %>
                >

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header topnavcolor" >
                        <h4 class="modal-title sectextcolor" style="padding:10px;font-size:20px;" id="ShortTitle"></h4>
                        <button type="button" class="close" data-dismiss="modal" style="">&times;</button>

                    </div>
                    <div class="modal-body" style="height:575px;padding-top:10px;" id="ShortBody">
                         <iframe id='ShortWindow' width="100%"  style="padding:0px;"
        frameborder="0" border="0" height="100%"></iframe>
                    </div>
                </div>

            </div>
        </div>



        <div id="myConfirmModel2" class="modal fade" role="dialog">
            <div class="modal-dialog modal-vertical-centered" style="max-width: 400px;">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header" style="display: none;">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <span style="color: #808080; font-size: 24px;" class="fa fa-exclamation-sign"></span>
                    </div>
                    <div class="modal-body" style="overflow: auto; align-content: center;">
                        <table width="100%">
                            <tr>
                                <td align="center" style="overflow: auto; padding-bottom: 5px; padding-top: 10px; height: 150px;" valign="middle">
                                    <span style="color: #565656; font-size: 16px; font-weight: 100;" id='Confirm2Title'></span>
                                    <br />
                                    <span id="Confirm2Body" style="font-weight: 100; padding-top: 20px; font-size: 14px; color: #808080;" align="center" valign="middle"></span>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="modal-footer" style="border-top: 0px solid #d0d0d0;">
                        <table width="100%">
                            <tr style="border-top: 0px solid #d0d0d0;">
                                <td  height="3px">&nbsp;</td>
                            </tr>
                            <tr>
                                <td  style="border-right: 0px solid #d0d0d0; padding-right:10px;" align="right">
                                    <button id="myConfirm2YesBtn" type="button" class="btn btn-link sectextcolor" onclick="ConfirmCallback2();" style=" font-weight: 400; font-size: 16px;"><asp:Localize runat="server" meta:resourcekey="str_Yes">Yes</asp:Localize></button>
                                    <button id="myConfirm2NoBtn" type="button" class="btn btn-link" style=" font-weight: 400; font-size: 16px;" onclick="ConfirmNoCallback2();"><asp:Localize runat="server" meta:resourcekey="str_No">No</asp:Localize></button>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>


        <div id="myConfirmModel1" class="modal fade" role="dialog"  >
        <div class="modal-dialog modal-vertical-centered">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header secsubbordercolor" style="border-bottom: 1px solid #f0f0f0; padding: 10px; display: none;" >
                                        <span style="color:#808080;font-size: 24px;" class="fa fa-exclamation-sign"></span>
                    <span style="color:#808080;font-size: 24px; display: none;" ><%=GetProductName()%></span>

                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                </div>
                <div class="modal-body"  >
                    <table width="100%">
                        <tr>
                            <td id="ConfirmBody" style=" padding-top: 20px; font-size: 16px; height: 140px; color:#565656;" align="center" valign="top" ></td>
                        </tr>

                    </table>
                </div>

                <div class="modal-footer secsubbordercolor" style="border-top: 0px solid #f0f0f0; padding: 5px;" >
                    <table width="100%">
                        <tr>
                            <td align="right">
                                <button type="button" id="confirmOkBtn" class="btn btn-link" data-dismiss="modal" style="width:100px;font-weight: 400; font-size:16px;"  ><asp:Localize runat="server" meta:resourcekey="str_Ok">Ok</asp:Localize></button>
                            </td>
                        </tr>
                    </table>

                </div>

            </div>

        </div>
    </div>
    <div id="NewFolderModel" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_newfname" runat="server">New Folder Name:</asp:Localize></p>
              <asp:TextBox ID="FolderName" runat="server" CssClass="form-control"></asp:TextBox>
          </div>

          <div class="modal-footer" style="font-size: 16px;">
              <asp:LinkButton ID="CreateFolder" CssClass="btn btn-primary gladbtn" runat="server" OnClick="CreateFolder_Click" OnClientClick="OnCreateFolder();return false;"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_crt" runat="server">Create</asp:Localize></span></asp:LinkButton>
            <button type="button" id="btnNewFolderClose" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>

    </div>
  </div>
    <div id="UnpublishTeamFolderAndDeleteModal" class="modal fade" role="dialog" style="z-index:99999;">
      <div class="modal-dialog">

      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_unpTFDltFldMsg" runat="server">Would you like to unpublish this Team Folder and then proceed with the deletion?</asp:Localize></p>
            <input type="hidden" id="hidUnpTFAltPath" /><input type="hidden" id="hidUnpTFID" />
          </div>

          <div class="modal-footer" style="font-size: 16px;">
              <button type="button" id="btnUnpTFGo" class="btn btn-primary gladbtn" data-dismiss="modal" onclick="callAjaxUnpublishAndDeleteTeamFolder();"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_unpubDlt" runat="server">Unpublish and Delete Folder</asp:Localize></span></button>
              <button type="button" id="btnUnpTFCnl" class="btn btn-default" data-dismiss="modal" onclick="cancelUnpublishAndDeleteTeamFolder();"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>
        </div>

    </div>
  </div>
    <div id="UnshareAndDeleteModal" class="modal fade" role="dialog" style="z-index:99999;">
      <div class="modal-dialog">

      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_ushDltMsg" runat="server">This file/folder is shared with others. Would you like to unshare it and then proceed with the deletion?</asp:Localize></p>
            <input type="hidden" id="hidUshAltPath" /><input type="hidden" id="hidUshID" />
          </div>

          <div class="modal-footer" style="font-size: 16px;">
              <button type="button" id="btnUshGo" class="btn btn-primary gladbtn" data-dismiss="modal" onclick="callAjaxUnshareAndDelete();"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_unshrDlt" runat="server">Unshare and Delete</asp:Localize></span></button>
              <button type="button" id="btnUshCnl" class="btn btn-default" data-dismiss="modal" onclick="cancelUnshareAndDelete();"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>
        </div>

    </div>
  </div>
    <div id="MiniSearchModal" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_srcTxt" runat="server">Search Text:</asp:Localize></p>
              <input type="text" ID="txtMiniSearch" class="form-control" />
          </div>

          <div class="modal-footer" style="font-size: 16px;">
              <asp:LinkButton ID="btnMiniSearchSubmit" CssClass="btn btn-primary gladbtn" runat="server" OnClientClick="OnMiniSearchSubmit();return false;"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_src" runat="server">Search</asp:Localize></span></asp:LinkButton>
            <button type="button" id="btnMiniSearchClose" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>

    </div>
  </div>
  <div id="TFSearchModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <iframe id="TFSearchModalFrame" src="about:blank" style="width:100%;height:calc(100vh - 180px);border:none;"></iframe>
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="TFSearchModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
    <div id="RequestFileModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
              <div class="row">
                <div class="col-12">
                    <asp:HiddenField ID = "txtReqFilPath" runat="server"></asp:HiddenField>
                    <asp:Localize meta:resourcekey="str_reqFilEmailsLbl" runat="server">Enter one or more email addresses below(multiple addresses can be separated by semicolons ;)</asp:Localize>:
                </div>
                <div class="col-12"><asp:TextBox ID = "txtReqFilEmails" runat="server" CssClass="form-control" placeholder="email@example.com"></asp:TextBox></div>
              </div>
              <div class="row">
                <div class="col-2"><asp:Localize meta:resourcekey="str_reqFilPwd" runat="server">Password</asp:Localize>:
                </div>
                <div class="col-10"><asp:TextBox ID = "txtReqFilPwd" runat="server" CssClass="form-control" Width="50%" placeholder="p@ss123"></asp:TextBox></div>
              </div>
              <div class="row">
                <div class="col-2"><asp:Localize meta:resourcekey="str_reqExpiration" runat="server">Expiration</asp:Localize>:
                </div>
                <div class="col-10"><asp:DropDownList ID = "ExpirationTime" runat="server" CssClass="browser-default custom-select secsubbordercolor" Width="50%" meta:resourcekey="ExpirationTimeResource1">
                </asp:DropDownList></div>
              </div>
          </div>
          <div class="modal-footer" style="font-size: 16px;">
              <asp:LinkButton ID="lnkRequestFile" CssClass="btn btn-primary gladbtn" runat="server" OnClientClick="OnRequestFileSubmit();return false;"><span style="font-size: 16px; font-weight: 200;" ><asp:Localize meta:resourcekey="str_reqFil" runat="server">Request File</asp:Localize></span></asp:LinkButton>
            <button type="button" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;" ><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
  <div id="RestoreFolderModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p id="txtRestoreFolder"></p>
          </div>

          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" class="btn btn-primary gladbtn" onclick="ConfirmedFolderRestoreFile(true)"><span style="font-size: 16px; font-weight: 200;" id="restoreFolderModal_yesBtn"><asp:Localize runat="server" meta:resourcekey="str_Yes">Yes</asp:Localize></span></button>
            <button type="button" class="btn btn-default" onclick="ConfirmedFolderRestoreFile(false)" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;" id="restoreFolderModal_noBtn"><asp:Localize runat="server" meta:resourcekey="str_No">No</asp:Localize></span></button>
            <button type="button" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize runat="server" meta:resourcekey="str_cnl">Cancel</asp:Localize></span></button>
            </div>
        </div>

    </div>
  </div>
  <div id="NewFileModel" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <!--p><asp:Localize meta:resourcekey="str_newfilename" runat="server">Rename</asp:Localize>:</p-->
              <input ID="NewFileName" type="text" class="form-control" />
          </div>

          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="newFileModalCreateBtn" class="btn btn-primary gladbtn" onclick="ConfirmedNewFile()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_crt" runat="server">Create</asp:Localize></span></asp:LinkButton></button>
            <button type="button" id="newFileModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>

    </div>
  </div>
  <div id="RenameModel" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_newfilename" runat="server">Name</asp:Localize>:</p>
              <input ID="inpNewName" type="text" class="form-control" />
              <input ID="inpID" type="text" style="display:none;" />
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="renameModalApplyBtn" class="btn btn-primary gladbtn" onclick="ApplyRename()"><span style="font-size: 16px; font-weight: 200;" id="btn_rename"></span></button>
            <button type="button" id="renameModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
  <div id="TagsModel" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_tgs" runat="server">Tags</asp:Localize>:</p>
              <input ID="inpTags" type="text" class="form-control" /><br />
              <input ID="inpOldTags" type="text" style="display:none;"  />
              <asp:Localize meta:resourcekey="str_tgsHlp" runat="server">(Separate multiple tags with a space. Ex: tag1 tag2 tag3)</asp:Localize>
              <input ID="inpTaggedObjID" type="text" style="display:none;" />
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="tagsModalApplyBtn" class="btn btn-primary gladbtn" onclick="ApplyTags()"><span style="font-size: 16px; font-weight: 200;" id="btn_saveTags"></span></asp:LinkButton></button>
            <button type="button" id="tagsModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
  <div id="DeleteShareModal" class="modal fade" role="dialog" style="width:750px;margin-left:auto;margin-right:auto;">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;"></div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="DeleteMySharesBtn" class="btn btn-primary gladbtn" onclick="DeleteShares()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_delShaOnl" runat="server">Delete Share(s) Only</asp:Localize></span></button>
            <button type="button" id="DeletePublicLinkBtn" class="btn btn-primary gladbtn" onclick="DeletePublicLink()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_delPubLinOnl" runat="server">Delete Public Link Only</asp:Localize></span></button>
            <button type="button" id="DeleteBothBtn" class="btn btn-primary gladbtn" onclick="DeleteSharesAndPublicLink()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_delBot" runat="server">Delete Both</asp:Localize></span></button>
            <button type="button" id="DeleteShareModalCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
  <div id="ConfirmZeroByteModal" class="modal fade" role="dialog" style="width:750px;margin-left:auto;margin-right:auto;margin-top:100px;">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content" style="min-height:200px;">
          <div class="modal-header"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;" id="ConfirmZeroByteModalBody"></div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" class="btn btn-primary gladbtn" onclick="ConfirmZeroByte(false)"><span style="font-size: 16px; font-weight: 200;"><asp:Localize runat="server" meta:resourcekey="str_Ok">OK</asp:Localize></span></button>
            <button type="button" class="btn btn-primary gladbtn" onclick="ConfirmZeroByte(true)"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_okToAll" runat="server">Suppress future warnings</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div> 
  <div id="ConfirmPasteConflict" class="modal fade" role="dialog" style="width:750px;margin-left:auto;margin-right:auto;margin-top:100px;">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content" style="min-height:200px;">
          <div class="modal-header"><asp:Localize runat="server" meta:resourcekey="str_repExiIte">Replace Existing Items?</asp:Localize></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;"><asp:Localize runat="server" meta:resourcekey="str_filAlrExiInThiLoc">The item already exists in this location. Do you want to replace it with the one you are copying?</asp:Localize></div>
          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" class="btn btn-primary gladbtn" onclick="OnPaste('replace')"><span style="font-size: 16px; font-weight: 200;"><asp:Localize runat="server" meta:resourcekey="str_rep">Replace</asp:Localize></span></button>   
            <button type="button" class="btn btn-primary gladbtn" onclick="OnPaste('keep_both')"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_kepBot" runat="server">Keep Both</asp:Localize></span></button>
            <button type="button" class="btn btn-primary gladbtn" onclick="abortClipboardOperations()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>        
        </div>
    </div>
  </div>

</div>

    <div style="display: none; width: 1px; height: 1px">
        <iframe id='downloadframe' style="display: none;" onload="OnDownloadError();"></iframe>
    </div>
    <div id='sideBarDiv'>
        <!--div style="float:left;width:2px;cursor:col-resize;height:100%;"></div-->
		<iframe id='sideBarFrame' style="float:right;width:calc(100% - 2px);height:100%;border:none;" src="/portal/WaitWin.htm"></iframe>
    </div>
    <script type="text/javascript" defer>
       function ToggelLeftMenu() {
           var e = document.getElementById("leftmenutd");
           if (e.style.display == "none") {
               e.style.display = "block";
               e = document.getElementById("DefaultContent");
               e.style.display = "none";
           } else {
               e.style.display = "none";
               e = document.getElementById("DefaultContent");
               e.style.display = "block";
           }
       }

       function OnMiniSearch(){
           $('#MiniSearchModal').modal({ backdrop: 'static', keyboard: false });
       }
       function OnMiniSearchSubmit(){
           $("#<%=SearchText.ClientID %>").val($("#txtMiniSearch").val());
            $('#NewFolderModel').modal('hide');
            setTimeout(function(){$("#<%=SearchFiles.ClientID %>")[0].click()},200);
       }
       function OnTeamFolder() {
			clearClipboardIfChangingSection(_dashboardPages.teamFolders);
			parent._loadedInFolderAlready = true;
            var e = document.getElementById("MainContent_HideTeamFolder");
            e.click();
        }
        function OnQuickAccess() {
            clearClipboardIfChangingSection(_dashboardPages.recentFiles);
            parent._loadedInFolderAlready = true;   
            try {
                GetCurrentRecFilePage();
            } catch (ex) {}
            if (getCurrentPage() == _dashboardPages.recentFiles) {
                _currRecFilPage = 1;
                localStorage.setItem("currRecFilPage", _currRecFilPage);
            } 
            var e = document.getElementById("MainContent_HideGoHome");
            $("#<%=hidCurrRecentPageNum.ClientID%>").val(_currRecFilPage);
            e.click();
        }

        function OnStared() {
			clearClipboardIfChangingSection(_dashboardPages.myFaves);
			parent._loadedInFolderAlready = true;
            var e = document.getElementById("MainContent_HideStared");
            e.click();
        }
        function OnMyFolders() {
            clearClipboardIfChangingSection(_dashboardPages.personalFolders);
			parent._loadedInFolderAlready = true;
            var e = document.getElementById("MainContent_HideFolders");
            e.click();

        }
        function ViewActivities() {
            var e = document.getElementById("MainContent_HideShared");
            e.click();
        }
        function ViewSharingAndCollaboration() {
            var e = document.getElementById("MainContent_HideShared");
            e.click();
        }

        function OnShared() {
			clearClipboardIfChangingSection(_dashboardPages.sharedFiles);
			parent._loadedInFolderAlready = true;
            var e = document.getElementById("MainContent_HideShared");
            e.click();
        }
        function GetPrevAndNextFilesForPreview(currPath){
            var getNext = false;
            _prevPreviewPath = "";
            _nextPreviewPath = "";
            var prevPath = "";
            $(".isFile").each(function(){
                var thisPath = $(this)[0].AliasLocation;
                if(removeLeadingSlash($(this)[0].AliasLocation) == removeLeadingSlash(currPath)){
                    _prevPreviewPath = prevPath;
                    getNext = true;
                }else{
                    if(getNext){
                        _nextPreviewPath = thisPath;
                        return false;
                    }
                }
                prevPath = thisPath;
            });
            return {"previous":_prevPreviewPath,"next":_nextPreviewPath};
        }
		function isForceUseDefault(appID){
			if(!appID) return false;
			switch(appID.toLowerCase()){
				case "019ff07b-7838-4718-b519-1fa93fbb054a":
					return isTrue(_m_forceDefaultMsfOfcApp);
					break;
				case "83072a99-bbe3-4388-9b19-82e793a60f95":
					return isTrue(_m_forceDefaultPixWebApp);
					break;
				case "47ac8b28-84c0-4b27-a58b-219504aca965":
					return isTrue(_m_forceDefaultOlyOfcApp);
					break;
				case "abebb110-c439-4d34-a962-89a1ae2dbb67":
					return isTrue(_m_forceDefaultZhoApp);
					break;
                case "6de3f1ec-8814-4333-a4db-5241de0a8b89":
					//force default of gladoffice
                    return isTrue(_m_forceDefaultApp);
                    break;
				default:
					return false;
					break;
			}
		}
        function OnItemClickedEditWithApp(al, f, nid) {
            if (f != "True") {
                //OnItemClicked(al, f, nid);
                //return;
				var foundDefaultEditingApp = false;
				var ext = getFileExtension(al);
				if(isTrue(_m_OpenOfficeFileUsingO365Web)){
				    if(IsOfficeExt(ext)){
				        if (isTrue(_m_OpenOfficeFileUsingO365Web)) {
                            //                  ms office ID
				            EditFileWithApp(nid,"019ff07b-7838-4718-b519-1fa93fbb054a");
				        }else{
                            //                   gladoffice id
				            EditFileWithApp(nid, "6DE3F1EC-8814-4333-A4DB-5241DE0A8B89");
				        }
				        return;
				    }
				}
				if (_editingApps) {
					for (var i = 0; i < _editingApps.length; i++) {
						if(isForceUseDefault(_editingApps[i].ApplicationId)){
							if (_editingApps[i].FileTyeList != "" && ext != "") {
								if (_editingApps[i].FileTyeList.indexOf("." + ext) > -1) {
                                    foundDefaultEditingApp = true;
									EditFileWithApp(nid,_editingApps[i].ApplicationId);
								}
							}
						}
					}
				}
				if(!foundDefaultEditingApp) parent.ShowPreviewPanel(gEncodeUri(al));
				return;
            }
            //ListFolder(al);
        }
        function OnItemClickedFromSearchResults(al, optIsFolderStr, optNodeID) {
            try{   
                $(".tooltip.show").removeClass("show");
            }catch(ex){}

            if(!isNullOrEmpty(optIsFolderStr)){
                if(optIsFolderStr.toLowerCase()=="true"){
                    OpenFolder(optNodeID);
                    return;
                }
            }
            if(!isNullOrEmpty(optNodeID)){
                var nodeRef = document.getElementById(optNodeID);
                if(nodeRef){
                    if(nodeRef.SupportPreview){
                        OpenFile(optNodeID);
                        return;
                    }
                }
            }
            //old preview for backwards compatibility
            parent.ShowSearchPreviewPanel(gEncodeUri(al));
        }

        function PreviewSharedItem(id){            
            var canSee = false;
            console.log("PreviewSharedItem",id)
            var singleItem = $("#"+id)[0];
            if(singleItem){
                resetPreviewToolbarTitle(id);
                var perm = ExtractPermissionsFromNode(singleItem);
                canSee = (!perm.listOnlyPerm);
                if(canSee){
                    OpenFile(id);
                    //OnItemClickedEditWithApp(gCurrentFolder + "/" + singleItem.Key, "False", id);
                    return;
                }
            }
        }
        function OnToggleSharedItem(opt_row_id,opt_f){    
            if($("#sideBarDiv").is(":visible")){
                OnSharedItemCloseSideBar();
            }else{
                $("#sideBarFrame").prop("src", "about:blank");
                $("#foldercontentdiv").addClass("contentwithminussidebar");
                $("#leftmenutd").addClass("leftmenuWithSidebarOpened");
                $("#treeDiv").addClass("treeWithSidebarOpened");
                $("#sideBarDiv").show();
                AdjustSharedBodyWidth();                
                OnSharedItemLoadSideBar(opt_row_id,opt_f);
            }
        }
        function OnSharedItemCloseSideBar(){         
            $("#sideBarFrame").prop("src", "about:blank");
            $("#foldercontentdiv").removeClass("contentwithminussidebar");
            $("#leftmenutd").removeClass("leftmenuWithSidebarOpened");
            $("#treeDiv").removeClass("treeWithSidebarOpened");  
            $("#sideBarDiv").hide();
            AdjustSharedBodyWidth();     
        }
        function OnSharedItemLoadSideBar(row_id,f){                   
            $("#sideBarFrame").prop("src", "about:blank");
            if($("#sideBarDiv").is(":visible")){
                if(varExists(row_id)){
                    var singleItem = $("#"+row_id)[0];
                    if(isTrue(f)){
                        getFolderInfo(singleItem.AliasLocation, null);
                    }else{
                        getFileInfo(singleItem.id, singleItem.AliasLocation, null);
                    }
                }else{
                    //when opening the side panel, if nothing was clicked on, load it
                    //with the path of the first item
                    var sharedItemsArr = $(".rptItem");
                    var path = "";
                    var isFld = false;
                    try{
                        if(sharedItemsArr.length > 0){
                            path = sharedItemsArr[0].AliasLocation;
                            isFld = isTrue(sharedItemsArr[0].IsFolder);
                            getFolderInfo(path, isFld);
                        }
                    }catch(ex){}
                }
            }
        }
        function resetPreviewToolbarTitle(id){
            //shared files will display the sharename on the title, which can differ from the filename if it has been renamed.
            //To prevent confusion reset the title.
            try{
                var ft = parent.document.getElementById("filetitle");
                if(ft){
                    ft.innerHTML = "...";
                }
                ForcePreviewTitle(document.getElementById(id).Key);
            }catch(ex){
                console.log("resetPreviewToolbarTitle:"+id+":"+ex);
            }
        }
        function SetCurrSharedMode(mode){
            if(mode=="sharedWithMe"){
                $("#ms_tr").removeClass("sharedByMe");
                $("#ms_tr").addClass("sharedWithMe");
            }else{
                $("#ms_tr").removeClass("sharedWithMe");
                $("#ms_tr").addClass("sharedByMe");
            }
        }
        function GetAliasFromID(id){
            var alias = "";
            try{
                alias = $("#" + id)[0].AliasLocation;
            }catch(ex){
                console.log(ex);
                alertError(ExplorerDetail_2668_error_get_file);//ajax post failure: get file
            }
            return alias;
        }
        function OnSharedByMeItemClicked(event,f, id){
            ms_closeAllMenus();
            if (event) {
                event.preventDefault();
                event.stopPropagation();
            }
            SetCurrSharedMode("sharedByMe");
            _curFldObj = $("#"+id)[0];
            _gCurrentFolderIsViewOnly = false;
            _gCurrentFolderSupportsPreview = true;
            _parFldPerm = ExtractPermissionsFromNode(_curFldObj);
            

            if (ms_NumClicks() == 1 && !gIsMobile) {
                OnSharedItemLoadSideBar(id,f);
            }else{
                if(isTrue(f)){
                    ListFolder(GetAliasFromID(id));
                }else{
                    PreviewSharedItem(id);
                }
            }
        }
        function OnSharedWithMeItemClicked(event,nodeID, isFolder, supportPreview, viewOnly){
            ms_closeAllMenus();
            if (event) {
                event.preventDefault();
                event.stopPropagation();
            }
            SetCurrSharedMode("sharedWithMe");
            _curFldObj = $("#"+nodeID)[0];
            _parFldPerm = ExtractPermissionsFromNode(_curFldObj);
            
            _gCurrentFolderIsViewOnly = isTrue(viewOnly);
            _gCurrentFolderSupportsPreview = isTrue(supportPreview);

            if (ms_NumClicks() == 1 && !gIsMobile) {
                OnSharedItemLoadSideBar(nodeID,isFolder);
            }else{
                var alias = GetAliasFromID(nodeID);
                if (!isTrue(isFolder)) {
                    if(_gCurrentFolderSupportsPreview){
                        PreviewSharedItem(nodeID);
                        if(!_m_folderDownloadEnabled || _gCurrentFolderIsViewOnly){
                            waitUntilDownloadLinkIsRenderedInPreviewThenHide();
                        }
                    }else{
                        alertError(ExplorerDetail_preview_not_supported);
                    }
                }else{
                    ListFolder(alias);
                }
            }
        }
        function OnItemClicked(al, f, optID) {
            ms_closeAllMenus();
            if (f != "True") {
                parent.ShowPreviewPanel(gEncodeUri(al));
                return;
            }
            if(al.indexOf(_folderTypes.teamFolderFromExisting)>-1){
                //below is parent.EditPubFolder(al) code, but with a window title correction for tf-from-existing
                //show the sharename in the breadcrum instead of the tf-from-existing GUI path
                var uri = "/portal/AddPubPage.aspx?location=" + gEncodeUri(unescape(al)) + "&src=filebrowser";
                parent.OpenMainWindow(uri, optID ? $("#"+optID)[0].Key : al);
                return;
            }else{
                ListFolder(al);
            }
        }
		var _maxForcePreviewTitleTries = 0;
		function ForcePreviewTitle(newStr){
		    _maxForcePreviewTitleTries++;
			var ft = parent.document.getElementById("filetitle");
			if(ft){
			   if((ft.innerHTML == "..." || ft.innerHTML == "")  && _maxForcePreviewTitleTries<100){
			  	  setTimeout(function(){
				  	ForcePreviewTitle(newStr);
				  },100);
			   }else{
			      ft.innerHTML = newStr;
			   }
			}
		}
		var _tryTimes = 0;
		function waitUntilDownloadLinkIsRenderedInPreviewThenHide(){
			var dlink = parent.document.getElementById("dlink");
			if(dlink){
				dlink.style.display = "none";
			}else{
				_tryTimes++;
				if(_tryTimes<20){
					//this is necessary because the base.DisableShareDownload may not be set for independently shared files
					//and the download button is rendered only after the content is rendered in the preview (mfile)
					setTimeout(function(){
					waitUntilDownloadLinkIsRendered();
					},10);
				}
			}
		}
        
        function OnUploadFiles(isFolder) {
            FileSelector = document.createElement('input');
            FileSelector.setAttribute('type', 'file');
            FileSelector.setAttribute('multiple', 'multiple');
            if(isFolder){
                FileSelector.onchange = function(){
                    onFolderSelected(this);
                }
                FileSelector.webkitdirectory = "webkitdirectory";
                FileSelector.directory = "directory";
                FileSelector.allow_dirs = "allow_dirs";
                FileSelector.allowdirs = "allowdirs";
                FileSelector.mozdirectory = "mozdirectory";
            }else{
                FileSelector.onchange = onFileSelected;
            }
            try {
                var bs = detectBrowser();
                if (bs.indexOf("Chrome") == -1 && bs.indexOf("Firefox") == -1) {
                    document.body.appendChild(FileSelector);
                } else {
                }
            } catch (e) {
                alert(e);
            }

            FileSelector.click();
        }
        function OnCreateFolder() {
            $('#NewFolderModel').modal('hide');
            var e = document.getElementById("MainContent_FolderName");
            //remove keyboard listeners from modal buttons
            window["keyHandler1ForModal"] = function () { }
            window["keyHandler2ForModal"] = function () { }
            var fileName = e.value.trim();
            var endsWithPeriod = (fileName.length-1 == fileName.lastIndexOf("."));

            if (!isValidFileName(fileName) || endsWithPeriod) {
                //plain alert to block further processing
                alertError(fileName.replace(/</g,"&lt;").replace(/>/g,"&gt;") + " " + ExplorerDetail_invalid_name);
                return;
            }
            var duplicateFound = false;
            $(".isFolder").each(function(){
                if($(this)[0].Key.toLowerCase() == fileName.toLowerCase()){
                    duplicateFound = true;
                    alertError(fileName.replace(/</g,"&lt;").replace(/>/g,"&gt;") + ": " + Explorer_duplicateFolderFound);
                    return false;
                }
            });
            if(duplicateFound){
                return;
            }
			if (gCurrentFolder == "")
				msCreateSingleDir(fileName, _m_onNewFolderCreateVersioned);
			else
				msCreateSingleDir(gCurrentFolder +"/"+fileName, _m_onNewFolderCreateVersioned);
        }
        function OnNewFolder(createVersioned) {
          if(createVersioned){
            closeCreateMenu();
            closeViewMenu();
            _m_refreshAfterQuickWinClose = true;
            var uri = "/portal/AddVersionedFolder.aspx?src=mgr";
            OpenQuickWindow(uri, ExplorerDetail_create_new_versioned_folder);
          }else{
              var folderNameID = "#<%=FolderName.ClientID%>";
              $(folderNameID).val("");
              //define keyboard listeners
              window["keyHandler1ForModal"] = function () {
                  $("#<%=CreateFolder.ClientID%>").click();
              }
              window["keyHandler2ForModal"] = function () {
                  $("#btnNewFolderClose").click();
              }
              $('#NewFolderModel').on('shown.bs.modal', function () {
                  $(folderNameID).focus();
              })
            $('#NewFolderModel').modal({ backdrop: 'static', keyboard: false });
          }
        }
        function OnRequestFile(optFolderID) {
            var path = gCurrentFolder;
            var isFld = "false";
            if (optFolderID) {
                var fldObj = document.getElementById(optFolderID);
                if (fldObj) {
                    path = fldObj.AliasLocation;
                    isFld = isTrue(fldObj.IsFolder) ? "true" : "false";
                }
            }
            var uri = "/portal/AddSharePage.aspx?l=2&src=browser&location=" + gEncodeUri(path) + "&folder=" + isFld;
            OpenQuickWindow(uri, ExplorerDetail_request_file);
            //$("#<%=txtReqFilPath.ClientID%>").val(path);
            //$("#<%=txtReqFilEmails.ClientID%>").val("");
            //$("#<%=ExpirationTime.ClientID%>").val("7");
            //$("#<%=txtReqFilPwd.ClientID%>").val("");
            //$('#RequestFileModal').modal({ backdrop: 'static', keyboard: false });
        }
        function AdjustSizeSub(){
            var e = document.getElementById("maindiv");
            <%if (IsMobile()){ %>
           
            
            <%}else {%>
            
            //e = document.getElementById("rpt_searchResults");
            
            //if(e)e.style.height = (document.documentElement.clientHeight - 72) + "px";
            
            
            <%}%>
           


        }
        function AdjustSize() {
            var e = document.getElementById("maindiv");
            <%if (IsMobile()){ %>
            e.style.height = "100%";
            e = document.getElementById("main_body");
            e.style.height = (document.documentElement.clientHeight - 32) + "px";
            e = document.getElementById("foldercontentsubdiv");
            e.style.height = (document.documentElement.clientHeight - 32) + "px";
            e = document.getElementById("SResultRepeater");
            if(e)e.style.height = (document.documentElement.clientHeight - 32) + "px";

            
            <%}
        else
        {%>
            
            e.style.height = (document.documentElement.clientHeight - 1) + "px";
            e = document.getElementById("main_body");
            e.style.height = (document.documentElement.clientHeight - 182) + "px";
            e = document.getElementById("foldercontentsubdiv");
            e.style.height = (document.documentElement.clientHeight - 172) + "px";
            e = document.getElementById("SResultRepeater");
            if(e)e.style.height = (document.documentElement.clientHeight - 172) + "px";
            
            //e.style.wdith = (document.documentElement.clientWidth - 30) + "px";
            <%}%>
            e = document.getElementById("subtaskpanel");
            if(e) e.style.height = (document.documentElement.clientHeight - 80) + "px";

            e = document.getElementById("maintbl");
            e.style.height = (document.documentElement.clientHeight - 20) + "px";


            //e = document.getElementById("filediv");
            //e.style.height = (document.documentElement.clientHeight - 22) + "px";
            //e = document.getElementById("foldercontentdiv");
            //e.style.height = (document.documentElement.clientHeight - 22) + "px";




            try {
                var x = document.getElementsByClassName("fileoutbox");
                if (!x)
                    return;
                if (x.length == 0)
                    return;
                var hh = 0;

                for (var i = 0; i < x.length; ++i) {
                    var w = x[i].offsetWidth-30;

                    var h = Math.floor(w * 198 / 240) - 20;
                    if (h < 110)
                        h = 110;
                    if (hh == 0)
                        hh = h;
                    else {
                        h = hh;
                    }
                    x[i].style.height = (h+20) + "px";

                    var ee = document.getElementById(x[i].id + "_n");
                    //ee.style.height = h + "px";


                    ee1 = document.getElementById(x[i].id + "_img");
                    if(ee1){
                        var index = ee1.src.indexOf("&vv=1");
                        if(index != -1){
                            //videodownload.dn causes a 404 error
                            var vurl = ee1.src.substring(0, index).replace("videodownload.dn", "download.dn");
                            ee1.src = vurl;
                            //removed on 6/5/2018-This causes the video to play back as a small icon that cannot be resized. In addition, since the poster attribute is not specified for the video tag, Firefox on Android simply displays a white screen on both the preview and the icon itself.
                            var vdiv = document.getElementById(x[i].id + "_ico");
                            vdiv.innerHTML = "<video><source src='"+vurl+"' type='video/mp4'>Your browser doesn't video tag.</video>";
                            vdiv.style.verticalAlign= "top";
                            ee1 = document.getElementById(x[i].id + "_tt");
                            ee1.style.display = "none";
                        }
                    }



                }


            } catch (e) {
                alert(e);
            }

            try {
                AdjustFileBox();
            } catch (e) {

            }
        }
        function onpressenter() {
            var chCode = ('charCode' in event) ? event.charCode : event.keyCode;
            if (chCode == 13) {
                alert("oneter")
                var r = document.getElementById("MainContent_Button2");
                r.click();
            }

        }

        var devicedbname = "<%=str_endpoint.Text%>";

	   function HideLeftMenu(){
           var e = document.getElementById("leftmenutd");
		   e.style.display = "none";
		   e = document.getElementById("DefaultContent");
		   e.style.display = "block";
	   }
        function OnDeviceBackup()
	   {
            var bc = document.getElementById("menuBarTable");
            if(bc){
                bc.style.display = "none";
            }

			<% if (IsMobile()) { %>
			HideLeftMenu();
			<% } %>
			clearClipboardIfChangingSection(_dashboardPages.deviceBackups);
			parent._loadedInFolderAlready = true;
			if(isTrue(_m_guestMode)) return;
            setCurrentPage(_dashboardPages.deviceBackups);

			<% if (IsMobile()) { %>
			try {
				parent.SetPTitle(Explorer_device_backups);
			} catch (eee) {}
			<% } %>

            $("#myq_tr,#mfav_tr,#mf_tr,#ms_tr,#db_tr").each(function(){ $(this).removeClass("lightbgcolor");});
            $("#db_tr").each(function(){ $(this).addClass("lightbgcolor");});

            /*
            var e1 = document.getElementById("mt_tr");
            if(e1) e1.className = "";
            e1 = document.getElementById("mfav_tr");
            if(e1) e1.className = "";
            e1 = document.getElementById("mf_tr");
            if(e1) e1.className = "";
            e1 = document.getElementById("myq_tr");
            if(e1) e1.className = "";
            e1 = document.getElementById("ms_tr");
            if(e1) e1.className = "";
            e1 = document.getElementById("db_tr");
            if(e1) e1.className = "lightbgcolor";
            e1 = document.getElementById("mfav_tr");
            alert(e1.className)
            */

            var e = document.getElementById("DefaultMode");
            e.innerHTML = "<%=str_endpoint.Text%>";
            e.onclick = function(){
                ListFolder("<%=m_DeviceBackRoot%>");
            }
            ListFolder("<%=m_DeviceBackRoot%>");
        }
        function OnStorageDetails(){
            if(parent.OnUsage) parent.OnUsage();
        }
        function OnAllMyFiles()
        {
			clearClipboardIfChangingSection(_dashboardPages.myFiles);
            setCurrentPage(_dashboardPages.myFiles);
            var e1 = document.getElementById("mt_tr");
            if(e1)
                e1.className = "";
            e1 = document.getElementById("mfav_tr");
            if(e1)
                e1.className = "";
            e1 = document.getElementById("db_tr");
            if(e1)
                e1.className = "";
            e1 = document.getElementById("myq_tr");
            if(e1)
                e1.className = "";
            e1 = document.getElementById("ms_tr");
            if(e1)
                e1.className = "";
            e1 = document.getElementById("mf_tr");
            if(e1)
                e1.className = "lightbgcolor";

            var e = document.getElementById("DefaultMode");
            e.innerHTML = "<%=str_allmyf.Text%>";
            e.onclick = function(){
                ListFolder("/");
            }

			//the following is a handler for the windows client command to open the file browser on a specific folder
			ForceNavigateToInitialFolder(false);
        }

        <% if (!Page.IsPostBack) { %>
            if(!<%=m_guestMode.ToString().ToLower() %> && _m_showAllMyFilesFirst) OnAllMyFiles();
        <% } %>

        function OnCloseTask() {

            var e = document.getElementById("filediv");
            if (e.style.display != "none") {
                e = document.getElementById("MainContent_HideGoHome");
                e.click();
            } else {
                ListFolder(gCurrentFolder);
            }
        }

        function SetupUploadPanel() {
            var ie8 = false;

            try {
                var bs = detectBrowser();

                if (bs[0].indexOf("MSIE") != -1 && (bs[1].indexOf("8") == 0 || bs[1].indexOf("9") == 0)) {
                    ie8 = true;
                } else {
                }
            } catch (e) {

            }



            if (!ie8 && FileReader !== undefined && FileReader !== null) {
            } else {
                var e = document.getElementById("basic_upload");
                e.style.display = "";

                e = document.getElementById("adv_upload");
                e.style.display = "none";
            }


            try {
                if (FileReader !== undefined && FileReader !== null) {
                    var e = document.getElementById("hint");
                    e.style.display = "";
                } else {

                }
            } catch (e) {
                dd = false;
            }
        }

        <% if (IsMobile()){ %>
        gIsMobile = true;
       gModeText = "<%=ModeText.Text%>";
        try {
            parent.SetPTitle("<%=ModeText.Text%>");
        } catch (eee) {

        }
        //OnAllMyFiles();
        <% }%>

        Ext.onReady(function () {
            try{
                if (parent.ShowClassicBrowser)
                    parent.ShowClassicBrowser();
            } catch (ee) {

            }

            gRandom = <%=mNodeId%>;

            CreateFileMap();

               <% if (m_NoContent){ %>
                OnAllMyFiles();
               <% }%>
            AdjustSizeSub();

            Ext.EventManager.onWindowResize(function () {
                AdjustSizeSub();
            });

            if(parent.gBackgroundColor){
                try{
                    document.getElementById("MainContentDiv").style.backgroundColor = parent.gBackgroundColor;
                }catch(eee){

                }
                try{
                    document.getElementById("maindiv").style.backgroundColor = parent.gBackgroundColor;
                }catch(eee){

                }
            }else{
                document.getElementById("MainContentDiv").style.backgroundColor = "#f8f8f8";
            }
            SetupUploadPanel();   
            try {
                GetCurrentRecFilePage();
            } catch (ex) {}    
            try {
                resetRecentNavButtons();
                if(getCurrentPage()==_dashboardPages.recentFiles){          
                    if (_currRecFilPage > 1) {
                        document.getElementById("recentPrevButton").style.display = "block"; 
                    }
                    if (isTrue(_hasMoreRecentItemsNextPage)) {
                        document.getElementById("recentNextButton").style.display = "block";
                    }  
                }
            } catch (ex) {} 
           });
        function resetRecentNavButtons() {
            try {
                document.getElementById("recentPrevButton").style.display = "none"; 
                document.getElementById("recentNextButton").style.display = "none"; 
            } catch (ex) {}    
        }
        function AddNewTeamFolderExFD() {
            <% if (SessionIsAdmin) { %>
                parent.OpenMainWindow("/management/SelectStoragePage.aspx?i=0&c=1&vdid=<%=SessionDomainId%>",parent.t_AddNewTeamFoleWizard);
            <% } else { %>
                parent.OpenMainWindow("/portal/AddPubPage.aspx",parent.t_AddNewTeamFoleWizard);
            <% } %>
        }    
        function CancelContextAction(evt) {
            evt.preventDefault();
            evt.stopPropagation();
            return false;
        } 
    </script>

<div id="vMenuActions" class="vMenu lvTblMenu">
    <div id="vMenuActionSorting" class="lvTblMenu">
	    <div id="vMenuActionsSortAsc" class="vMenuRow vMenuActionSelected lvTblMenu" onclick="SetSort('Asc')"><i class="gladinet-icons vGridLeft lvTblMenu">&#xE5;</i><div class="vGridLeft iconLbl lvTblMenu"><asp:Localize runat="server" meta:resourcekey="str_SorAsc">Sort Ascending</asp:Localize></div></div>
	    <div id="vMenuActionsSortDesc" class="vMenuRow lvTblMenu" onclick="SetSort('Desc')"><i class="gladinet-icons vGridLeft lvTblMenu">&#xE6;</i><div class="vGridLeft iconLbl lvTblMenu"><asp:Localize runat="server" meta:resourcekey="str_SorDes">Sort Descending</asp:Localize></div></div>
    </div>
	<div id="vMenuColumns" class="vMenuRow lvSubMenu"><div class="vGridLeft lvSubMenu" onclick="onToggleTableSubMenu()"><i class="gladinet-icons vGridLeft lvTblMenu">&#xDB;</i><div class="vGridLeft iconLbl lvTblMenu"><asp:Localize runat="server" meta:resourcekey="str_VieCol">View Columns</asp:Localize></div></div><div id="vColumnsMenuArrow" class="vGridRight vGrid20 vHidden vMenuArrow lvTblMenu" onclick="onToggleTableSubMenu()"><i class="gladinet-icons lvTblMenu">&#xDD;</i></div></div>
</div>
<div id="vMenuActionsSubMenu" class="vMenu lvTblMenu">
	<div class="vMenuRow lvTblMenu"><input id="chkShowVersion" type="checkbox" checked="checked" class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowVersion',true)" /><span class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowVersion',false)" ><asp:Localize runat="server" meta:resourcekey="str_Ver">Version</asp:Localize></span></div>
	<div class="vMenuRow lvTblMenu"><input id="chkShowSize" type="checkbox" checked="checked" class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowSize',true)" /><span class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowSize',false)" ><asp:Localize runat="server" meta:resourcekey="str_Siz">Size</asp:Localize></span></div>
	<div class="vMenuRow lvTblMenu"><input id="chkShowType" type="checkbox" checked="checked" class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowType',true)" /><span class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowType',false)" ><asp:Localize runat="server" meta:resourcekey="str_Typ">Type</asp:Localize></span></div>
	<div class="vMenuRow lvTblMenu"><input id="chkShowDate" type="checkbox" checked="checked" class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowDate',true)"/><span class="lvTblMenu" onclick="onToggleListViewColumnCheck('chkShowDate',false)"><asp:Localize runat="server" meta:resourcekey="str_LasMod">Last Modified</asp:Localize></span></div>
</div>
<div id="waitPopup">
    <div id="waitContainer">
        <i id="waitBigCog" class="gladinet-icons spin">g</i><i id="waitBigCogInv" class="gladinet-icons spin">&#x101;</i>
        <i id="waitSmallCog" class="gladinet-icons spin">g</i><i id="waitSmallCogInv" class="gladinet-icons spin">&#x101;</i>

    </div>
</div>
<div id="myProgressModel" class="modal fade" role="dialog">
    <div class="modal-dialog modal-vertical-centered">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <span style="color:#808080;font-size: 24px;" class="fa fa-road"></span>&nbsp;&nbsp;
                <span style="color:#808080;font-size: 24px;" id="ProgressTitle"></span>
            </div>
            <div class="modal-body"  style="height:200px;">
                <div id="CurrentFname"></div>
               <div class="myProgressAction"></div> <div class="myProgCntr"><div class="myProgBar"></div></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:100px;" onclick="cancelTask();" id="btnProgressModelCancel"></button>
            </div>
        </div>
    </div>
</div>
<div id="dragImg" class="gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor">&#x111;</div>
<div id="cmenu" class="contextMenu" oncontextmenu="CancelContextAction(event);"></div>
<div id="toast" style="display:none;"></div>
<div id="viewChoicesMenu">
    <div onclick="msSelectView(event,'largeicon');" class="choice icoLg">
        <span class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor vViewMenuIcon iconsize_large">&#xA4;</span><span class="viewChoicesMenuLnk" id="switchToLgIcoView"><asp:Localize runat="server" meta:resourcekey="str_LarIcoVie">Large Icon View</asp:Localize></span>
    </div>
    <div onclick="msSelectView(event,'mediumicon');" class="choice icoMd">
        <span class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor vViewMenuIcon iconsize_medium">&#x119;</span><span class="viewChoicesMenuLnk" id="switchToMdIcoView"><asp:Localize runat="server" meta:resourcekey="str_MedIcoVie">Medium Icon View</asp:Localize></span>
    </div>
    <div onclick="msSelectView(event,'smallicon');" class="choice icoSm">
        <span class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor vViewMenuIcon iconsize_small">&#x11A;</span><span class="viewChoicesMenuLnk" id="switchToSmIcoView"><asp:Localize runat="server" meta:resourcekey="str_SmaIcoVie">Small Icon View</asp:Localize></span>
    </div>
    <div onclick="msSelectView(event,'detail');" class="choice ls">
        <span class="highlighted gladinet-icons md-dark hand center toolbtn btniconcolor vViewMenuIcon iconsize_large">&#xBA;</span><span class="viewChoicesMenuLnk" id="switchToLstView"><asp:Localize runat="server" meta:resourcekey="str_DetLisVie">Detailed List View</asp:Localize></span>
    </div>
</div>
<div id="viewSubChoicesMenu">
    <div onclick="msSetDensity(event,'dense');" class="choice dense">
        <span id="icoHighDensity" class="gladinet-icons md-dark hand center toolbtn btniconcolor  ">&#x146;</span>
    </div>
    <div onclick="msSetDensity(event,'normal');" class="choice normal">
        <span id="icoNormalDensity"class="gladinet-icons md-dark hand center toolbtn btniconcolor  ">&#xBA;</span>
    </div>
    <div onclick="msSetDensity(event,'loose');" class="choice low">
        <span id="icoLowDensity"class="gladinet-icons md-dark hand center toolbtn btniconcolor  ">&#x147;</span>
    </div>
</div>

<div id="colResizerCursor"></div>
<iframe id="iframeForPopups" src="about:blank" style="width:1px;height:1px;display:none;" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-presentation allow-same-origin allow-scripts allow-top-navigation allow-downloads"></iframe>
<div id="treeDiv" onmouseout="hideTree();" onmouseover="stopHideTree();"></div>
</asp:Content>
