﻿<%@ Page Title="File Browser" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="FileBrowser.aspx.cs" Inherits="GladinetPayFlow.FileBrowser"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript" src="/portal/webui_strings.aspx"></script>
    <script type="text/javascript" src="/portal/filebrowser.js"></script>
    <style type="text/css">
         .fileoutboxex {
            height: 100px;            
        }
        .toolnavbtn div{
            overflow-x:hidden;white-space:nowrap;
        }
        .cmenu{
            padding:15px;
            background-color:#FFF;
            position:absolute;border-radius: 3px;font-weight: 100;
            border:1px solid #f0f0f0;white-space: nowrap;
        }
        .foldrNameBox {
            width: calc(100% - 70px);
            overflow-x: hidden;
            white-space: nowrap;
        }
        #listview_download,td.downloadButtonTd {
            text-align: center !important;
        }
        #divPubLnkExp {display:block;padding-left:10px;margin-top:10px;font-size:18px;float:right;font-weight:100;}
        .disSel {-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:flex;align-items: center;height: 60px;padding: 0px 10px 0px 10px;}
        .disSel span{margin-top:-2px;}
        </style>
    <script type="text/javascript">
        var gRootFolder = "";
        var gCurrentFolder;
        var gFolderBeforeSearch = "";
        var gSearchFolderGUID = "4A1ADDAD-93CF-4F43-A7F3-D1036A522665";
        var gSearchFilter = "";
        var gViewOnly = false;
        var gSawSafariWarningAlready = false;

        function getThumbImageUrl(data) {
            return getThumbImageUrlEx(gCurrentFolder, data, 560);
        }

        var Base64 = {

            // private property
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

            // public method for encoding
            encode: function (input) {
                var output = "";
                var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
                var i = 0;

                input = Base64._utf8_encode(input);

                while (i < input.length) {

                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);

                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;

                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    } else if (isNaN(chr3)) {
                        enc4 = 64;
                    }

                    output = output +
                this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
                this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

                }

                return output;
            },

            // public method for decoding
            decode: function (input) {
                var output = "";
                var chr1, chr2, chr3;
                var enc1, enc2, enc3, enc4;
                var i = 0;

                input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

                while (i < input.length) {

                    enc1 = this._keyStr.indexOf(input.charAt(i++));
                    enc2 = this._keyStr.indexOf(input.charAt(i++));
                    enc3 = this._keyStr.indexOf(input.charAt(i++));
                    enc4 = this._keyStr.indexOf(input.charAt(i++));

                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;

                    output = output + String.fromCharCode(chr1);

                    if (enc3 != 64) {
                        output = output + String.fromCharCode(chr2);
                    }
                    if (enc4 != 64) {
                        output = output + String.fromCharCode(chr3);
                    }

                }

                output = Base64._utf8_decode(output);

                return output;

            },

            // private method for UTF-8 encoding
            _utf8_encode: function (string) {
                string = string.replace(/\r\n/g, "\n");
                var utftext = "";

                for (var n = 0; n < string.length; n++) {

                    var c = string.charCodeAt(n);

                    if (c < 128) {
                        utftext += String.fromCharCode(c);
                    }
                    else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                    else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }

                }

                return utftext;
            },

            // private method for UTF-8 decoding
            _utf8_decode: function (utftext) {
                var string = "";
                var i = 0;
                var c = c1 = c2 = 0;

                while (i < utftext.length) {

                    c = utftext.charCodeAt(i);

                    if (c < 128) {
                        string += String.fromCharCode(c);
                        i++;
                    }
                    else if ((c > 191) && (c < 224)) {
                        c2 = utftext.charCodeAt(i + 1);
                        string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                        i += 2;
                    }
                    else {
                        c2 = utftext.charCodeAt(i + 1);
                        c3 = utftext.charCodeAt(i + 2);
                        string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                        i += 3;
                    }

                }

                return string;
            }

        }

         function OnDownloadError() {
             var e = document.getElementById("downloadframe");
             var err = "";
             try {

                 if (e.contentWindow.location.toString().toLowerCase().indexOf("/storage/") != -1) {
                     err = e.contentWindow.document.body.innerHTML;
                     var ind = err.indexOf("$!$");
                     if (ind == -1)
                         err = "";
                     else {
                         err = err.substring(ind + 3);

                         ind = err.indexOf("$!$");
                         if (ind != -1) {
                             err = " : " + err.substring(0, ind);
                         } else {
                             err = "";
                         }
                     }
                     alert("Failed to download" + err);
                 }

             } catch (ee) {

             }

         }
         function OpenMiniSearch() {
             $('#MiniSearchModal').modal({ backdrop: 'static', keyboard: false });
             $('#MiniSearchModal').on('shown.bs.modal', function () {
                 $('#txtMiniSearch').trigger('focus');
             })
             $('#txtMiniSearch')[0].onkeydown = function (evt) {
                var evt2 = evt || window.event;
                var keyCode = evt2.keyCode || evt2.which;
                if (keyCode == 13) {
                    //enter
                    evt.preventDefault();
                    evt.stopPropagation();
                    OnMiniSearchSubmit();
                }
                if (keyCode == 27) {
                    //escape
                    evt.preventDefault();
                    evt.stopPropagation();
                    $('#MiniSearchModal').modal('hide');
                }
            }
         }
         function OnMiniSearchSubmit() {
             var txtSearch = document.getElementById("txtMiniSearch");
             if (txtSearch) {
                 if (txtSearch.value.trim() != "") {
                     gSearchFilter = txtSearch.value.trim();
                     gFolderBeforeSearch = gCurrentFolder;
                     SetCurrentFolder(gCurrentFolder, true);
                     $('#MiniSearchModal').modal('hide');
                 }
             }
         }
         function RemoveIllegalCharsFromObj(obj) {
             obj.value = RemoveIllegalChars(obj.value);
         }
         function RemoveIllegalChars(str) {
             return str.replace(/%/g, "").replace(/[_\^"'/\\]/g, "");
         }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocSrc" meta:resourcekey="str_src" Visible="false">Search</asp:Localize>
    <% if (IsMobile())
        { %>
    <div id="menuitems" style="float: right; position: absolute; bottom: 10px; right: 10px; z-index: 9999; background: transparent;">
        <div style="border-radius: 50%; width: 60px; height: 60px; box-shadow: 3px 3px 3px rgba(0,0,0,0.95); cursor: pointer; align-content: center; padding-top: 10px; display: none; padding-left: 9px; z-index: 106" class=" floatbtn" onclick="GoUp();" id="goupbtn">

            <i class="gladinet-icons  hand center " style="display: inline-block; margin-top: 10px; margin-left: 8px; font-size: 32px; color: white;">&#0166;</i>
        </div>
        <div style="height: 5px"></div>
        <div style="border-radius: 50%; width: 60px; height: 60px; box-shadow: 3px 3px 3px rgba(0,0,0,0.95); cursor: pointer; align-content: center; padding-top: 10px; padding-left: 9px;" class=" floatbtn" onclick="RefreshCurrentFolder();">

            <i class="gladinet-icons  hand center " style="display: inline-block; margin-top: 10px; margin-left: 4px; font-size: 32px; color: white;">&#0181;</i>
        </div>
         <div style="border-radius: 50%; width: 60px; height: 60px; box-shadow: 3px 3px 3px rgba(0,0,0,0.95); cursor: pointer; align-content: center; padding-top: 10px; padding-left: 9px; display:none;" class=" floatbtn"  id="lvbtn"  onclick="OnListView();">

            <i class="gladinet-icons  hand center " style="display: inline-block; margin-top: 10px; margin-left: 4px; font-size: 32px; color: white;">&#0186;</i>
        </div>
        <div style="border-radius: 50%; width: 60px; height: 60px; box-shadow: 3px 3px 3px rgba(0,0,0,0.95); cursor: pointer; align-content: center; padding-top: 10px; padding-left: 9px;" class=" floatbtn" id="ivbtn" onclick="OnIconView();">

            <i class="gladinet-icons  hand center " style="display: inline-block; margin-top: 10px; margin-left: 4px; font-size: 32px; color: white;">&#0164;</i>
        </div>
    </div>
    <% }
        else
        { %>

    <div class="meubardrop navbar navbar-default" role="navigation" style="border: 0px;">
        <div class="container-fluid trbordercolor" style="border-bottom: 0px solid #f0f0f0; padding-bottom: 10px;">
            <div class="navbar-left">
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px; display: none;" onclick="GoUp();" id="goupbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;">&#0166;</i>

            </button>
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px; " onclick="OnIconView();" id="ivbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;">&#0164;</i>

            </button>
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;display: none;" id="lvbtn" onclick="OnListView();">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;">&#0186;</i>

            </button>
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;" onclick="RefreshCurrentFolder();">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;">&#0181;</i>

            </button>
            <%if (!DisableShareDownload)
                { %>
            <button type="button" class="btn navbar-btn navbar-left toolbtn downloadFolder" style="padding: 2px; margin-left: 5px;" onclick="DownloadCurrentFolder();" title="<%=str_downloadfolder.Text %>" id="downfbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 10px;font-size:34px;" title="<%=str_downloadfolder.Text %>">&#x14F;</i>
                <asp:Localize meta:resourcekey="str_downloadfolder" ID="str_downloadfolder" runat="server" Visible="False">Download current folder</asp:Localize>
            </button>
               
                <button type="button" class="btn navbar-btn navbar-left toolbtn downloadSelFiles" style="padding: 2px; margin-left: 5px; display:none;" onclick="DownloadSelectedFiles();" title="<%=str_downloadfiles.Text %>" id="downfiles">
                    <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;font-size:30px;" title="<%=str_downloadfiles.Text %>">&#x150;</i>
                    <asp:Localize meta:resourcekey="str_downloadfiles" ID="str_downloadfiles" runat="server" Visible="False">Download selected files</asp:Localize>
                
            </button>
            <% } %>
            
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;" onclick="OpenMiniSearch();">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=LocSrc.Text %>">&#xA7;</i>
            </button>
            
                <div id="divPubLnkExp"></div>
                </div>
        </div>
    </div>
    <% } %>
    
    <div id="breadcrums" style="width: 100%;margin-top:20px;margin-left:60px;"></div>
    <div style="width: 100%; align-content: left; margin: 0; 
       <% if (!IsMobile()) { %>
            padding: 20px; 
            background-color: white;
                             <% } %>
            margin-top: 20px; -webkit-overflow-scrolling: touch; overflow: auto; padding-top: 0px;" align="left" id="maindiv">
        <div style="width: 100%; display: none;
       <% if (IsMobile()) { %>
            padding:20px; 
            background-color: #f8f8f8;
                             <% } %>;padding-bottom:200px;

            " id="iconview_div">
            <div style="color: #868686; font-weight: 100; display: none;"><asp:Localize runat="server" meta:resourcekey="str_Fol">Folders:</asp:Localize></div>

            <div class="row" id="FolderList" style="overflow: auto;">
            </div>
            <div style="color: #868686; font-weight: 100; padding-top: 30px; display: none;"><asp:Localize runat="server" meta:resourcekey="str_Fil">Files:</asp:Localize></div>
            <div class="row mt-5" id="FileList" style="overflow: auto; padding-top: 30px; ">
            </div>
        </div>
        <div style="width: 100%;padding-left:20px;padding-right:20px;" id="listview_div">
            <table style="width:100%;" border="0">
                   
                
                <tr style="display:none;">
                    <td style="padding:0 40px 0 20px;">
                         <table width="100%" style="font-size: 12px; font-weight: 100; color: #808080;" border="0">
                            <tbody id="listview_headers">
                                <% if (!IsMobile()) { %><tr style="border-bottom:1px solid #808080;">
                                    
                    <td id="listview_chk" style="width:75px;">&nbsp;</td>
                                    <td id="listview_chk1" style="width:35px;">&nbsp;</td>
                    <td id="listview_name" style="font-size: 12px; font-weight: 400!important; color: #202020!important;"><asp:Localize runat="server" meta:resourcekey="str_Nam">Name</asp:Localize></td>
                    <td id="listview_date" style="font-size: 12px; font-weight: 400; color: #202020;width:228px;"><asp:Localize runat="server" meta:resourcekey="str_LasMod">Last Modified</asp:Localize></td>
                    <td id="listview_size" style="font-size: 12px; font-weight: 400; color: #202020;text-align:left;width:100px;"><asp:Localize runat="server" meta:resourcekey="str_Siz">Size</asp:Localize></td>
                    <td id="listview_download" style="font-size: 12px; font-weight: 400; color: #202020;text-align:left;width:100px;"><asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize></td>
                                </tr>
                                <tr>
                                <td colspan="6" height="12px">&nbsp;</td>
                                </tr><% } %>
                            </tbody>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td 
                        <% if (!IsMobile()) { %>
                        style="padding-top: 15px;"
                        <% } %>
                        >
                        <div style="background-color: white; overflow: auto; width: 100%;padding:20px;" id="listviewtd" 
                            <% if (!IsMobile()) { %>
                            
                            <% } %>
                            >
                        <table width="100%" style="font-size: 12px; font-weight: 100; color: #808080;margin-bottom:200px;" border="0">
                            <tbody id="listcontent">
                          
                                </tbody>
                        </table>
                            </div>
                    </td>
                </tr>
            </table>
        </div>

        <div style="display: none; width: 1px; height: 1px">
            <iframe id='downloadframe' style="display: none;" onload="OnDownloadError();"></iframe>
        </div>

    </div>

    <div id="MiniSearchModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">

          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_srcTxt" runat="server">Search For:</asp:Localize></p>
              <input type="text" ID="txtMiniSearch" class="form-control" onkeyup="RemoveIllegalCharsFromObj(this)" />
          </div>

          <div class="modal-footer" style="font-size: 16px;">
              <asp:LinkButton ID="btnMiniSearchSubmit" CssClass="btn btn-primary gladbtn" runat="server" OnClientClick="OnMiniSearchSubmit();return false;"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_src" runat="server">Search</asp:Localize></span></asp:LinkButton>
            <button type="button" id="btnMiniSearchClose" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
      </div>
    </div>

    <div id="ConfirmSafariDownloadModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
              <asp:Localize meta:resourcekey="str_warning" runat="server">Warning</asp:Localize>
          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
            <p><asp:Localize meta:resourcekey="str_safariDownloadWarning" runat="server">The Safari browser automatically extracts and excludes "unsafe" files when you download zip archives. In order to prevent missing files, please go to your Safari preferences, General, and uncheck the setting to "Open 'safe' files after downloading". Press the download button when ready.</asp:Localize></p>
            <input type="hidden" id="safariDownloadParams" value="" />
          </div>
          <div class="modal-footer" style="font-size: 16px;">
              <input type="button" ID="btnConfirmSafariDownload" class="btn btn-primary gladbtn" value="<asp:Localize meta:resourcekey="str_download" runat="server">Download</asp:Localize>" />
            <button type="button" id="btnSafariDownloadClose" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>
        </div>
      </div>
    </div>

    <script type="text/javascript">
        var _gMouseX = 0;
        var _gMouseY = 0;
        var gRandom = 0;
        var _disableFileDownloads = false;
        var _disableFolderDownloads = false;
        var _GLAD_PERM_LIST = 0x0040;
        var _GLAD_PERM_READ = 0x0008;
        function isTrue(prop) {
            if (prop) {
                if ((prop == true || (prop + "").toLowerCase() == "true")) return true;
            }
            return false;
        }
        function checkDownloadRights(){
            try {
                if (parent) {
                    var parentIsPublicLinkPage = false;
                    try {
                        parentIsPublicLinkPage = (parent.location.href.toLowerCase().indexOf("/portal/rawwebapppage.aspx") > -1);
                    } catch (ex2) { }
                    if (parentIsPublicLinkPage) {
                        if (isTrue(parent.gViewOnly)) {
                            gViewOnly = true;
                            _disableFileDownloads = true;
                            _disableFolderDownloads = true;
                        } else {
                            if(isTrue(parent.DisableFolderDownload)){
                                _disableFolderDownloads = true;
                            }
                        }
                    } else {
                        if (isTrue(parent.DisableDownload)) {
                            _disableFileDownloads = true;
                            _disableFolderDownloads = true;
                        } else {
                            if (isTrue(parent.DisableFolderDownload)) {
                                _disableFolderDownloads = true;
                            }
                        }
                    }
                    var downloadButtonFromToolbar = $("#downfbtn");
                    var downloadColumnHeader = $("#listview_download");
                    if (_disableFolderDownloads && _disableFileDownloads) {
                        downloadColumnHeader.hide();
                    } else {
                        downloadColumnHeader.show();
                    }
                    if (_disableFolderDownloads) {
                        $(".downloadFolder,.filerow input[type=checkbox]").each(function () { $(this).hide() });
                    } else {
                        $(".downloadFolder,.filerow input[type=checkbox]").each(function () { $(this).show() });
                    }
                    if (_disableFolderDownloads) {
                        downloadButtonFromToolbar.hide();
                    } else {
                        downloadButtonFromToolbar.show();
                    }
                }
            } catch (ex) { }
        }
        function GoUp() {

            if (gSearchFilter != "") {
                gSearchFilter = "";
                if (gFolderBeforeSearch == "") {
                    gFolderBeforeSearch = gRootFolder;
                }
                gCurrentFolder = gFolderBeforeSearch;
                RefreshCurrentFolder();
                return;
            }
            var decodedGCurrentFolder = gCurrentFolder;
            var decodedGRootFolder = gRootFolder;
            try {
                decodedGCurrentFolder = decodeURIComponent(gCurrentFolder);
            } catch (ex) {
                console.log("GoUp:ex1:" + ex);
            }
            try {
                decodedGRootFolder = decodeURIComponent(gRootFolder);
            } catch (ex) {
                console.log("GoUp:ex2:" + ex);
            }
            if (decodedGCurrentFolder == decodedGRootFolder) {
                return;
            }

            var li = decodedGCurrentFolder.lastIndexOf('/');
            if (li < 0) {
                SetCurrentFolder(gRootFolder, true);
            } else {
                var previousFolder = decodedGCurrentFolder.substring(0, li);
                if (previousFolder.indexOf(gRootFolder) == -1) {
                    previousFolder = gRootFolder;
                }
                SetCurrentFolder(previousFolder, true);
            }
        }

        function AdjustSize() {

            checkDownloadRights();
            var e = document.getElementById("maindiv");
             <%if (IsMobile())
        { %>
            e.style.height = (document.documentElement.clientHeight - 10) + "px";
            //e.style.wdith = (document.documentElement.clientWidth - 5) + "px";
             <%}
        else
        {%>
            e.style.height = (document.documentElement.clientHeight - 90) + "px";
            //e.style.wdith = (document.documentElement.clientWidth - 30) + "px";
            e = document.getElementById("listviewtd");
            e.style.height = (document.documentElement.clientHeight - 150) + "px";
                <%}%>

            try {
                var x = document.getElementsByClassName("fileoutboxex");
                if (!x)
                    return;
                
                if (x.length == 0)
                    return;
                var hh = 0;

                for (var i = 0; i < x.length; ++i) {
                    var w = x[i].offsetWidth - 30;

                    var h = Math.floor(w * 198 / 240) - 20;
                    if (h < 110)
                        h = 110;
                    if (hh == 0)
                        hh = h;
                    else {
                        h = hh;
                    }
                    x[i].style.height = (h+ 30) + "px";
                    
                   


                }

            } catch (e) {
                alert(e);
            }
        }


        function AddFile(node, fileList) {

            ++gRandom;
            var cid = gRandom;

            var fileoutbox = document.createElement("div");
            fileoutbox.id = "node_" + gRandom;
            <% if (!IsMobile()){ %>
            fileoutbox.className = "col-xs-6 col-sm-6 col-md-3 col-lg-1 fileoutboxex";
            <% }        else        {%>
            fileoutbox.className = "col-xs-6 col-sm-6 col-md-3 col-lg-2 fileoutbox";
             <% }%>
            var fileBox = document.createElement("div");
            fileBox.className = "filebox";
            if (IsNullOrEmpty(node.AliasLocation)) {
                gCurrentFolder = tryDecodeURIComponent(gCurrentFolder);
                if (gCurrentFolder == '') {
                    fileoutbox.alias = node.Key;
                }
                else {
                    fileoutbox.alias = gCurrentFolder + "/" + node.Key;
                }
            } else {
                fileoutbox.alias = node.AliasLocation;
            }
            fileoutbox.PermObj = GetPermissionsFromInt(node.Perm);

            fileoutbox.appendChild(fileBox);

            var filenode = document.createElement("div");
             <% if (!IsMobile()){ %>
            filenode.className = "filenode  iconobj boxbordercolor";
             <% }        else        {%>
            filenode.className = "filenode  trbordercolor";
             <% }%>
            
            if (IsNullOrEmpty(node.AliasLocation)) {
                filenode.title = node.Key + "\n" + node.LastModified + "\n" + FormatFileSize(node.Size) + "\n" + node.LastUpdateUserName;
            } else {
                filenode.title = node.AliasLocation + "\n" + node.LastModified + "\n" + FormatFileSize(node.Size) + "\n" + node.LastUpdateUserName;
            }
            <% if (IsMobile()){ %>         
            if (!_disableFileDownloads) {    
                 var downloadIcon = document.createElement("span");
                downloadIcon.innerHTML = "Å";   
                downloadIcon.style = "float:right;margin-top:-10px;position:relative;z-index:999999;";
                 downloadIcon.title = "<asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize>";
                 downloadIcon.className = "gladinet-icons md-dark hand center btniconcolor disSel";
                 downloadIcon.onclick = function () {   
                    DownloadItemIconView(fileoutbox.id, false);
                 }       
                 fileoutbox.appendChild(downloadIcon);
            }
            <% } %>
            filenode.ondblclick = function () {
                var canPreview = !isTrue(parent._PrevDisabled);
                if (canPreview) {
                    if (!fileoutbox.PermObj.canRead) {
                        //override if more restrictive
                        canPreview = false;
                    }
                }
                if (canPreview) {
                    if (IsNullOrEmpty(node.AliasLocation)) {
                        if (gCurrentFolder == '') {
                            OnItemClickedEditWithApp(node.Key);
                        }
                        else {
                            OnItemClickedEditWithApp(gCurrentFolder + "/" + node.Key);
                        }
                    } else {
                        OnItemClickedEditWithApp(node.AliasLocation);
                    }
                } else {
                    alert(ExplorerGrid3_528_Access_denied);
                }
            }
            filenode.oncontextmenu = function (event) {
                event.preventDefault();
                event.stopPropagation();
                ToggleContextMenu(fileoutbox.id, false);
            }
            var icodiv = document.createElement("div");
            icodiv.className = "icodiv";
            filenode.appendChild(icodiv);
            icodiv.id = cid + "_ico";

            var fiurl = getImageUrl(node);
            var imgi = document.createElement("img");
            imgi.src = fiurl;

             <% if (IsMobile())
        { %>
            filenode.style.backgroundImage = "url(" + fiurl + ")";
            filenode.style.backgroundRepeat = "no-repeat";
            filenode.style.backgroundPosition = "center";
             <% }%>
            imgi.className = 'icoimg';
            icodiv.appendChild(imgi);

            var imgurl = getThumbImageUrl(node);

            if (imgurl && imgurl != '') {
                var imgd = document.createElement("img");
                imgd.src = imgurl;
                imgd.className = "thumbimg";
                imgd.id = cid + "_img";
                imgd.style.display = "none";

                imgd.onload = function () {

                    var e = document.getElementById(cid + "_img");
                    e.style.display = "";

                    if (e.src.indexOf('view.dn') == -1) {
                        e = document.getElementById(cid + "_tt");
                        e.style.display = "none";
                    }

                    var e = document.getElementById(cid + "_ico");
                    e.style.display = "none";
                }
                filenode.appendChild(imgd);
            }


            var titlediv = document.createElement("div");
            titlediv.className = "titlediv btniconcolor";
            titlediv.id = cid + "_tt";

            filenode.appendChild(titlediv);
            titlediv.innerHTML = "<span class='titletxt' style='vertical-align: middle; font-size:14px!important;'>" + GetShortString(node.Key, 26) + "</span>";

            fileBox.appendChild(filenode);
            fileList.appendChild(fileoutbox);

        }

        function AddFolder(node, folderList) {
            ++gRandom;

            var folderbox = document.createElement("div");

            folderbox.id = "node_"+gRandom;
            folderbox.className = "col-xs-12 col-sm-12 col-md-3 col-lg-2 folderbox";

            var folderNode = document.createElement("div");

             <% if (!IsMobile())        { %>
             folderNode.className = "folderNode iconobj disSel";
             <% }
        else
        {%>
             folderNode.className = "folderNode disSel";
             <% }%>
             var iconBox = document.createElement("span");
             iconBox.className = "gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor";
             iconBox.innerHTML = getFolderIcon(node);
             folderNode.appendChild(iconBox);

             var nameBox = document.createElement("span");
             nameBox.innerHTML = GetShortString(node.Key, 26);
             nameBox.className = "foldrNameBox disSel";
             gCurrentFolder = tryDecodeURIComponent(gCurrentFolder);
             if (gCurrentFolder == "") {
                 folderbox.alias = node.Key;
             } else {
                 folderbox.alias = gCurrentFolder + "/" + node.Key;
             }
            folderNode.appendChild(nameBox);

            <% if (IsMobile()) { %>              
            if (!_disableFileDownloads) {    
                 var downloadIcon = document.createElement("span");
                 downloadIcon.innerHTML = "Å";                         
                 downloadIcon.title = "<asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize>";
                 downloadIcon.className = "gladinet-icons md-dark hand center btniconcolor disSel";
                downloadIcon.onclick = function () {
                    DownloadItemIconView(folderbox.id, true);
                 }       
                 folderNode.appendChild(downloadIcon);
            }
            <% } %> 
             folderbox.appendChild(folderNode);
            folderList.appendChild(folderbox);

             iconBox.onclick = function () {
                 if (gCurrentFolder == "")
                     SetCurrentFolder(node.Key, true);
                 else
                     SetCurrentFolder(gCurrentFolder + "/" + node.Key, true);
             }
             nameBox.onclick = function () {
                 if (gCurrentFolder == "")
                     SetCurrentFolder(node.Key, true);
                 else
                     SetCurrentFolder(gCurrentFolder + "/" + node.Key, true);
             }
             folderNode.oncontextmenu = function (event) {
                 event.preventDefault();
                 event.stopPropagation();
                 ToggleContextMenu(folderbox.id, true);
             }

        }
        function GetPermissionsFromInt(chdPermInt) {
            var canList = false;
            var canRead = false;
            if ((chdPermInt & _GLAD_PERM_LIST)) canList = true;
            if ((chdPermInt & _GLAD_PERM_READ)) canRead = true;
            return { "canList": canList, "canRead": canRead}
        }
        function IsAppleSafariBrowser() {
            var agent = navigator.userAgent;
            return (agent.indexOf("Macintosh") != -1) && (agent.indexOf("AppleWebKit") != -1) && (agent.indexOf("Safari") != -1);
        }
        function tryDecodeURIComponent(str) {
            //decodeURIComponent expects things like %20 but will fail if it finds % by itself. Example: "Special % Char"
            if (str == null) return "";
            var decodedStr = str;
            try{
                decodedStr = decodeURIComponent(str);
            } catch (ex) {
                console.log("tryDecodeURIComponent:ex:" + ex);
            }
            return decodedStr;
        }
        function DownloadItemIconView(id, isFolder) {
            closeAllCMenus();
            var url = ""; 
            var alias = tryDecodeURIComponent($("#" + id)[0].alias);
            if (isFolder) {
                url = "/storage/zip.dn?f=" + gEncodeUri(alias);
            } else {
                url = "/storage/u.svc/download.dn?f=" + gEncodeUri(alias);
            }
            if (IsAppleSafariBrowser() && isFolder && !gSawSafariWarningAlready) {
                $("#btnConfirmSafariDownload").click(function () {
                    ConfirmedSafariDownload(id);
                });
                $('#ConfirmSafariDownloadModal').modal({ backdrop: 'static', keyboard: false });
            } else {
                $("#downloadframe").prop("src", url);
            }
        }
        function ConfirmedSafariDownload(id) {
            $('#ConfirmSafariDownloadModal').modal('hide');
            gSawSafariWarningAlready = true;
            closeAllCMenus();
            var alias = tryDecodeURIComponent($("#" + id)[0].alias);
            var url = "/storage/zip.dn?f=" + gEncodeUri(alias);
            $("#downloadframe").prop("src", url);
        }
        function closeAllCMenus() {
            $(".cmenu").each(function () {
                $(this).remove();
            });
        }
        function ToggleContextMenu(id, isFolder) {
            closeAllCMenus();
            if ((isFolder && _disableFolderDownloads) || (!isFolder && _disableFileDownloads)) {
                return;
            }
            var maxW = $(window).width();
            var menuCode = "";
            if ((_gMouseX + 120) >= maxW) {
                menuCode = '<div id="cmenu_' + id + '" class="cmenu boxbordercolor" style="left:auto;top:' + _gMouseY + 'px;right:0px;"><span class="gladinet-icons md-dark hand center btniconcolor" onclick="DownloadItemIconView(\'' + id + '\',' + isFolder.toString().toLowerCase() + ')" title="<asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize>">Å</span> <span class="btniconcolor" style="font-weight:100 !important;cursor:pointer;" onclick="DownloadItemIconView(\'' + id + '\',' + isFolder.toString().toLowerCase() + ')"><asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize></span></div>'
            } else {
                menuCode = '<div id="cmenu_' + id + '" class="cmenu boxbordercolor" style="left:' + _gMouseX + 'px;top:' + _gMouseY + 'px;right:auto;"><span class="gladinet-icons md-dark hand center btniconcolor" onclick="DownloadItemIconView(\'' + id + '\',' + isFolder.toString().toLowerCase() + ')" title="<asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize>">Å</span> <span class="btniconcolor" style="font-weight:100 !important;cursor:pointer;" onclick="DownloadItemIconView(\'' + id + '\',' + isFolder.toString().toLowerCase() + ')"><asp:Localize runat="server" meta:resourcekey="str_Dow">Download</asp:Localize></span></div>'
            }
            $("body").append(menuCode);
                
        }
        function getFileIcon(node) {
            var name = node.Key.toLowerCase();
            
            if (-1 != name.indexOf(".pdf"))
                return "y";
            if (-1 != name.indexOf(".ppt") || -1 != name.indexOf(".pptx"))
                return "p";
            if (-1 != name.indexOf(".doc") || -1 != name.indexOf(".docx"))
                return "w";
            if (-1 != name.indexOf(".xls") || -1 != name.indexOf(".xlsx"))
                return "x";

            return "z";
        }
        function DownloadItem(rowID, isFolder) {
            var url = "";
            var alias = tryDecodeURIComponent($("#" + rowID)[0].AliasLocation);
            if (isFolder) {
                url = "/storage/zip.dn?f=" + gEncodeUri(alias);
            } else {
                url = "/storage/u.svc/download.dn?f=" + gEncodeUri(alias);
            }
            if (IsAppleSafariBrowser() && isFolder && !gSawSafariWarningAlready) {
                $("#btnConfirmSafariDownload").click(function () {
                    ConfirmedSafariDownloadItem(rowID);
                });
                $('#ConfirmSafariDownloadModal').modal({ backdrop: 'static', keyboard: false });
            } else {
                $("#downloadframe").prop("src", url);
            }
        }
        function ConfirmedSafariDownloadItem(rowID) {
            $('#ConfirmSafariDownloadModal').modal('hide');
            gSawSafariWarningAlready = true;
            var alias = tryDecodeURIComponent($("#" + rowID)[0].AliasLocation);
            var url = "/storage/zip.dn?f=" + gEncodeUri(alias);
            $("#downloadframe").prop("src", url);
        }
        function IsNullOrEmpty(str) {
            if (!str) {
                return true;
            }
            if (str == null) {
                return true;
            }
            if (str == "") {
                return true;
            }
            return false;
        }
        function getFileExtension(filename) {
            if (filename == null) {
                return "";
            }
            if (filename.indexOf(".") > -1) {
                var tmparr = filename.split(".");
                return tmparr[tmparr.length - 1].toLowerCase();
            }
            return "";
        }
        function EditFileWithApp(al, editingAppId) {
            var altpath = tryDecodeURIComponent(al);
            var uri = "/management/builtinapps/fileoperator.aspx?f=" + gEncodeUri(altpath) + "&a=" + editingAppId + "&ro=1";
            var win = window.open(uri, Math.random());
            try{
                win.location;//prevents getting blocked in Chrome
            }catch(ex){}
        }

        function IsOfficeExt(ext) {
            switch (ext) {
                case "doc":
                case "docx":
                case "odt":
                case "ppt":
                case "pptx":
                case "ppsx":
                //case "pdf":
                case "rtf":
                case "xml":
                case "eml":
                case "msg":
                case "xls":
                case "xlsx":
                    return true;
            }
            return false;
        }
        function OnItemClickedEditWithApp(al) {
            al = tryDecodeURIComponent(al);
            //for public links and unprotected external shares, all previews are read-only
            if (isTrue(parent.gIsServo) && isTrue(parent.gOpenOfficeFileUsingO365Web)) {
                var ext = getFileExtension(al);
                if (IsOfficeExt(ext)) {
                    //unless TF with setting to force MS Office
                    EditFileWithApp(al, "019ff07b-7838-4718-b519-1fa93fbb054a");
                    return;
                }
            }
            parent.ShowPreviewPanel(gEncodeUri(al));
        }
        function isTrue(prop) {
            //this to ensure that a JSON property exists and is either true or "true"
            if (prop) {
                if ((prop == true || (prop + "").toLowerCase() == "true")) return true;
            }
            return false;
        }
        function AddListViewItem(node, itemList) {

            ++gRandom;
            var cid = gRandom;

            var filetr = document.createElement("tr");            
            filetr.style.height = "48px";
            filetr.style.borderBottom = "1px solid #d8d8d8";
            filetr.className = "filerow";
            filetr.id = "row_" + cid;
            if (IsNullOrEmpty(node.AliasLocation)) {
                filetr.AliasLocation = node.Key;
                if (gCurrentFolder != "") filetr.AliasLocation = gCurrentFolder + "/" + node.Key;
            } else {
                filetr.AliasLocation = node.AliasLocation;
            }
            filetr.PermObj = GetPermissionsFromInt(node.Perm);
            <% if (!IsMobile()) { %>
            var seltd = document.createElement("td");
            filetr.appendChild(seltd);
            seltd.style.width = "30px";
            seltd.style.paddingLeft = "6px";
            
            if (!node.IsFolder) {
                var size = "";
                try{
                    size = node.Size;
                } catch (ex) { size = "0"; }

                seltd.innerHTML = '<input  type="checkbox" onchange="OnSelChanged();" name="tt_' + node.Key.replace("\"", "&quot;") + '"  value="1" data-size="' + size + '" data-fullpath="' + node.AliasLocation.replace("\"", "&quot;") + '" >';
            }
            <% }%>

            var icontd = document.createElement("td");
            filetr.appendChild(icontd);
            icontd.style.width = "45px";
            icontd.style.paddingLeft = "6px";
            if (node.IsFolder) {
                var iconBox = document.createElement("span");
                iconBox.className = "gladinet-icons md-dark hand center  btniconcolor";
                iconBox.innerHTML = getFolderIcon(node);
                icontd.appendChild(iconBox);
            } else {
                var iconBox = document.createElement("span");
                iconBox.className = "gladinet-icons md-dark hand center  btniconcolor";
                iconBox.innerHTML = getFileIcon(node);
                icontd.appendChild(iconBox);
            }
            var nametd = document.createElement("td");
            filetr.appendChild(nametd);
            nametd.className = "toolnavbtn";
            
            <% if (!IsMobile()) { %>
            var max = parseInt(window.innerWidth - 40 - 40 - 30 - 128 - 100 - 100 - 40) + "px"

            if (IsNullOrEmpty(node.AliasLocation)) {
                nametd.innerHTML = "<div style=\"max-width:" + max + "\" title=\"" + node.Key.replace("\"", "&quot;") + "\">" + node.Key + "</div>";
            } else {
                nametd.innerHTML = "<div style=\"max-width:" + max + "\" title=\"" + node.AliasLocation.replace("\"", "&quot;") + "\">" + node.Key + "</div>";
            }


            var lmtd = document.createElement("td");
            lmtd.innerHTML = node.LastModified;
            filetr.appendChild(lmtd);
            

            var sizetd = document.createElement("td");
            sizetd.innerHTML = (node.IsFolder) ? "&nbsp;" : FormatFileSize(node.Size);
            filetr.appendChild(sizetd);
            sizetd.style.width = "100px";
            <% }else {%>
            nametd.vAlign = "middle";
            nametd.style.paddingTop = "12px";
            nametd.innerHTML = "<span style='font-size:16px; color:#404040;'>"+GetShortString(node.Key, 26) + "</span><p style='font-size:smaller'>" + node.LastModified + "&nbsp&nbsp&nbsp" + FormatFileSize(node.Size)+"</p>";
            <% }%>

            var optionstd = document.createElement("td");
            optionstd.style.width = "100px";

            if ((node.IsFolder && !_disableFolderDownloads) || (!node.IsFolder && !_disableFileDownloads)) {
                optionstd.className = "downloadButtonTd";
                optionstd.innerHTML = '<span class="gladinet-icons md-dark hand center btniconcolor" onclick="DownloadItem(\'row_' + cid + '\',' + node.IsFolder + ')" title="' + ExplorerGrid_1006_Download.replace("\"", "&quot;") + '">&#xC5;</span>';
            } else {
                optionstd.innerHTML = '&nbsp;';
            }
            filetr.appendChild(optionstd);
            if (node.IsFolder) {
                nametd.onclick = function () {
                    if (gCurrentFolder == "")
                        SetCurrentFolder(node.Key, true);
                    else
                        SetCurrentFolder(gCurrentFolder + "/" + node.Key, true);
                }
            } else {


                nametd.onclick = function () {
                    var canPreview = !isTrue(parent._PrevDisabled);
                    if (canPreview) {
                        if (!filetr.PermObj.canRead) {
                            //override if more restrictive
                            canPreview = false;
                        }
                    }
                    if (canPreview) {
                        var fullpath = "";
                        if (IsNullOrEmpty(node.AliasLocation)) {

                            if (gCurrentFolder == '') {
                                fullpath = node.Key;
                            }
                            else {
                                fullpath = gCurrentFolder + "/" + node.Key;
                            }
                        } else {
                            fullpath = node.AliasLocation;
                        }
                        OnItemClickedEditWithApp(fullpath);
                    } else {
                        alert(ExplorerGrid3_528_Access_denied);
                    }
                }
                nametd.ondblclick = function () {
                    var canPreview = !isTrue(parent._PrevDisabled);
                    if (canPreview) {
                        if (!filetr.PermObj.canRead) {
                            //override if more restrictive
                            canPreview = false;
                        }
                    }
                    if (canPreview) {
                        if (IsNullOrEmpty(node.AliasLocation)) {
                            if (gCurrentFolder == '') {
                                OnItemClickedEditWithApp(node.Key);
                            }
                            else {
                                OnItemClickedEditWithApp(gCurrentFolder + "/" + node.Key);
                            }
                        } else {
                            OnItemClickedEditWithApp(node.AliasLocation);
                        }
                    } else {
                        alert(ExplorerGrid3_528_Access_denied);
                    }
                }
            }
            itemList.appendChild(filetr);

        }
        var first = false;
        function SetDirContent(x, isFirstCall) {
             var folderList = document.getElementById("FolderList");
             var fileList = document.getElementById("FileList");
             var ee = document.getElementById("listview_headers");
             var listviewlist = document.getElementById("listcontent");
             if (true === isFirstCall) {
                 folderList.innerHTML = "";
                 fileList.innerHTML = "";
                 listviewlist.innerHTML = ee.innerHTML;
             }

             if (!first) {                 
                 first = true;
                 //if (x.Contents.length < 15)
                   //  OnIconView();
             }
             for (var i = 0; i < x.Contents.length; ++i) {
                 var node = x.Contents[i];

                 if (node.Key == "41ED6C26-D5F8-424F-A311-BB4FF88140E5")
                     continue;
                 if (node.Key == "43811DCD-8C5A-4EF9-B903-2EEA9CE88487")
                     continue;
                 if (node.IsFolder) {
                     AddFolder(node, folderList);
                 } else {
                     AddFile(node, fileList);
                 }
                 
             }

             for (var i = 0; i < x.Contents.length; ++i) {
                 var node = x.Contents[i];

                 if (node.Key == "41ED6C26-D5F8-424F-A311-BB4FF88140E5")
                     continue;
                 if (node.Key == "43811DCD-8C5A-4EF9-B903-2EEA9CE88487")
                     continue;
                 if (node.IsFolder) {
                     AddListViewItem(node, listviewlist);
                 } 
                 
             }
             
             for (var i = 0; i < x.Contents.length; ++i) {
                 var node = x.Contents[i];

                 if (node.Key == "41ED6C26-D5F8-424F-A311-BB4FF88140E5")
                     continue;
                 if (node.Key == "43811DCD-8C5A-4EF9-B903-2EEA9CE88487")
                     continue;
                 if (!node.IsFolder) {
                     AddListViewItem(node, listviewlist);
                 }

             }

             if (!isNullOrEmpty(x.Marker)) {
                 //keep calling recursively until all pages have been retrieved
                 SetCurrentFolder(gCurrentFolder, false, x.Marker);
             }


         }
        function isNullOrEmpty(str) {
            if (str == null) return true;
            if (str == "") return true;
            if (typeof str == "undefined") return true;
            return false;
        }
         function RefreshCurrentFolder() {
             if (gSearchFilter != "") {
                 OnMiniSearchSubmit();
             } else {
                 SetCurrentFolder(gCurrentFolder, true);
             }
         }

         function DownloadCurrentFolder() {
             if (IsAppleSafariBrowser() && !gSawSafariWarningAlready) {
                 $("#btnConfirmSafariDownload").click(function () {
                     gSawSafariWarningAlready = true;
                     DownloadCurrentFolder();
                 });
                 $('#ConfirmSafariDownloadModal').modal({ backdrop: 'static', keyboard: false });
             } else {
                 $('#ConfirmSafariDownloadModal').modal('hide');
                 clearIframeDoc();
                 var uri = "/storage/u.svc/zip.dn?f=" + gEncodeUri(tryDecodeURIComponent(gCurrentFolder));
                 var e = document.getElementById("downloadframe");
                 e.src = uri;
                 checkIframeLoadedWithError();
             }
         }
		function clearIframeDoc() {
			var iframe = document.getElementById('downloadframe');
			var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
			try{
				iframeDoc.write("");
			}catch(ex){
				console.log("clearIframeDoc: " + ex);
			}
		}
		function checkIframeLoadedWithError() {
			var iframe = document.getElementById('downloadframe');
			var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
			if (iframeDoc.readyState  == 'complete' ) {
				try{
					console.log(iframeDoc.documentElement.innerText)
					displayFrameError(iframeDoc.documentElement.innerText);
				}catch(ex){}
				return;
			} 
			window.setTimeout(checkIframeLoadedWithError, 300);
		}
		function displayFrameError(html){
			if(html) alert(html.replace(/\$!\$/g,""));
		}
		function DownloadSelectedFiles() {
		    if (IsAppleSafariBrowser() && !gSawSafariWarningAlready) {
		        $("#btnConfirmSafariDownload").click(function () {
		            $('#ConfirmSafariDownloadModal').modal('hide');
		            gSawSafariWarningAlready = true;
		            DownloadSelectedFiles();
		        });
		        $('#ConfirmSafariDownloadModal').modal({ backdrop: 'static', keyboard: false });
		        return;
		    }
             var files = document.getElementsByTagName("input");
            var SelectedFileList = "";
            if (gSearchFilter == null || gSearchFilter == "") {
                if (gCurrentFolder) SelectedFileList = tryDecodeURIComponent(gCurrentFolder);
                if (SelectedFileList == "") SelectedFileList = "/";
            }
             for (var i = 0; i < files.length; ++i) {
                 if (files[i].type == "checkbox") {
                     if (files[i].checked && StringStartsWith(files[i].name,"tt_")) {
                         if (SelectedFileList != "" || gSearchFilter.length > 0)
                             SelectedFileList += "\n";
                         var size = "0";
                         try {
                             size = files[i].dataset.size;
                         } catch (ex) {
                             size = "0";
                         }
                         if (gSearchFilter.length > 0) {
                            SelectedFileList += tryDecodeURIComponent(files[i].dataset.fullpath) + "\t0\t" + size;
                         } else {
                            SelectedFileList += tryDecodeURIComponent(files[i].name.substring(3)) + "\t0\t" + size;
                         }
                     }

                 }
             }
             Ext.Ajax.request({
                 url: "/storage/multiuploadinit.up",
                 success: function (response) {
                     if (response.responseText.indexOf("[*]") != -1) {
                         alert(response.responseText.substring(3));
                         return;
                     }
                     var uri = "/storage/multi.dn?f=" + response.responseText;
                     var e = document.getElementById("downloadframe");
                     e.src = uri;
                 },
                 failure: function () {
                     console.log("/storage/multiuploadinit.up - FAILED")
                 },
                 scope: this,
                 method: 'POST',
                 headers: {
                     'x-glad-token': getLoginSessionToken2(),
                     'Content-Type': 'application/x-www-form-urlencoded'
                 },
                 params: {
                     list: Base64.encode(SelectedFileList)
                 }
             });
         }
         
         function StringStartsWith(s, s1){
             var index = s.indexOf(s1);
             if(index == 0)
                 return true;
             return false;
         }
         function OnSelChanged() {
             try{
                 
             
                 var e = document.getElementById("downfiles");
                 e.style.display = "none";

                 var files = document.getElementsByTagName("input");

                 for (var i = 0; i < files.length; ++i) {
                     if (files[i].type == "checkbox") {
                         if (files[i].checked && StringStartsWith(files[i].name, "tt_")) {
                             e.style.display = "";
                             return;
                         }
                     
                     }
                 }
             } catch (ee) {

             }
         }

         function OnIconView() {

             document.getElementById("breadcrums").style.marginLeft="10px";
             
             var e = document.getElementById("iconview_div");
             e.style.display = "";

             e = document.getElementById("listview_div");
             e.style.display = "none";

              
             //document.getElementById("MainContentDiv").style.backgroundColor = "#f8f8f8";
             
             try{
                 e = document.getElementById("lvbtn");
                 e.style.display = "";

                 e = document.getElementById("ivbtn");
                 e.style.display = "none";
             } catch (e) {

             }

             AdjustSize();

         }
         function OnListView() {
             document.getElementById("breadcrums").style.marginLeft = "60px";

             var e = document.getElementById("iconview_div");
             e.style.display = "none";

             e = document.getElementById("listview_div");
             e.style.display = "";

             try{
                 e = document.getElementById("lvbtn");
                 e.style.display = "none";

                 e = document.getElementById("ivbtn");
                 e.style.display = "";
             } catch (e) {

             }
             
         }
         function TryHideLoading() {
             try {
                 HideLoading();
             } catch (ex) { }
         }
         function SetCurrentFolder(fo, isFirstCall, optionalMarker) {
             try {
                 fo = tryDecodeURIComponent(fo);
             } catch (ex) {
                 console.log("SetCurrentFolder:ex:" + ex);
             }

             var fetchNotSupported = (typeof window.fetch === "undefined");

             try {
                 ShowLoading();
             } catch (ex) { }

             if (fetchNotSupported) {
                 SetCurrentFolderExt(fo, isFirstCall, optionalMarker);
             }
             else
             {
                 var hdrs = {
                     'x-glad-altpath': encodeURIComponent(fo),
                     'x-glad-token': getLoginSessionToken2(), // todo: make sure it is good token
                     'x-glad-tzoffset': getTzOffset(),
                     'x-glad-langid': getLangId(),
                     'x-glad-snapshotid': getSnapshotId()
                 }
                 if (gSearchFilter != "") {
                     var currFld = "";
                     if (!HasIllegalSearchChars(gRootFolder)) {
                         currFld = gRootFolder;
                     }
                     if (!HasIllegalSearchChars(gFolderBeforeSearch)) {
                         currFld = gFolderBeforeSearch;
                     }
                     hdrs = {
                         'x-glad-altpath': gSearchFolderGUID,
                         'x-glad-token': getLoginSessionToken2(), // todo: make sure it is good token
                         'x-glad-tzoffset': getTzOffset(),
                         'x-glad-langid': getLangId(),
                         'x-glad-snapshotid': getSnapshotId(),
                         'x-glad-root': currFld,
                         'x-glad-filter': gSearchFilter + "^FullPath"
                     }
                 }

                 if (!isNullOrEmpty(optionalMarker)) {
                     hdrs['key-marker'] = optionalMarker;
                 }

                 fetch('/namespace/n.svc/jsondir/', {
                     method: 'GET',
                     headers: hdrs
                 }).then(
                    function (response) {
                        if (response.status !== 200) {
                            TryHideLoading();
                            alert("Failed to send request. Error " + response.status);
                            return;
                        }
                        response.json().then(function (x) {
                            if (x.Success) {
                                gCurrentFolder = fo;
                                SetDirContent(x, isFirstCall);
                                SetBreadCrums(fo);
                                var e = document.getElementById('goupbtn');

                                var isSearchMode = (gSearchFilter != "");

                                if (fo == gRootFolder && !isSearchMode) {
                                    e.style.display = "none";
                                } else {
                                    e.style.display = "";
                                }
                                try {
                                    if (x.Items != null && x.Items != undefined && x.FolderSize != null && x.FolderSize != undefined) {
                                        var s = x.Items + ExplorerDetail_Status_Text + FormatFileSize(x.FolderSize);
                                        if (parent.SetStatusText) {
                                            parent.SetStatusText(s);

                                        }
                                    }
                                } catch (ep11) {}

                                try {
                                    AdjustSize();
                                } catch (ep22) {}
                            } else {
                                alert("Failed to list dir:" + x.Reason);
                            }
                            TryHideLoading();
                        });
                    }
                  ).catch(function (err) {
                      TryHideLoading();
                      alert("Failed to send request. " + err);
                  });

             }
         }

         function SetCurrentFolderExt(fo, isFirstCall, optionalMarker) {
             //legacy function that uses Ext Ajax

             Ext.Ajax.defaultHeaders = {
                 'Content-Type': "application/xml; charset=utf-8"
             };

             var received = function (response) {


                 TryHideLoading();


                 x = Ext.decode(response.responseText); // TODO: can we use json reader?
                 if (x !== null && x !== undefined) {

                     if (x.Success) {


                         gCurrentFolder = fo;
                         SetDirContent(x, isFirstCall);
                         SetBreadCrums(fo);
                         var e = document.getElementById('goupbtn');

                         var isSearchMode = (gSearchFilter != "");

                         if (fo == gRootFolder && !isSearchMode) {
                             e.style.display = "none";
                         } else {
                             e.style.display = "";
                         }

                         try {
                             if (x.Items != null && x.Items != undefined && x.FolderSize != null && x.FolderSize != undefined) {
                                 var s = x.Items + ExplorerDetail_Status_Text + FormatFileSize(x.FolderSize);
                                 if (parent.SetStatusText) {
                                     parent.SetStatusText(s);

                                 }
                             }
                         } catch (ep11) {
                         }

                         try{
                             AdjustSize();
                         } catch (ep22) {

                         }
                     } else {
                         alert("Failed to list dir:" + x.Reason);
                     }
                 } else {
                     alert("Failed to list dir");
                 }


             };

             try {
                 ShowLoading();
             } catch (ee1) {

             }

             var hdrs = {
                'x-glad-altpath': encodeURIComponent(fo),
                'x-glad-token': getLoginSessionToken2(), // todo: make sure it is good token
                'x-glad-tzoffset': getTzOffset(),
                'x-glad-langid': getLangId(),
                'x-glad-snapshotid': getSnapshotId()
             }

             if (gSearchFilter != "") {
                 
                 var currFld = "";
                 if (!HasIllegalSearchChars(gRootFolder)) {
                     currFld = gRootFolder;
                 }
                 if (!HasIllegalSearchChars(gFolderBeforeSearch))
                 {
                     currFld = gFolderBeforeSearch;
                 }
                hdrs = {
                'x-glad-altpath': gSearchFolderGUID,
                'x-glad-token': getLoginSessionToken2(), // todo: make sure it is good token
                'x-glad-tzoffset': getTzOffset(),
                'x-glad-langid': getLangId(),
                'x-glad-snapshotid': getSnapshotId(),
                'x-glad-root': currFld,
                'x-glad-filter': gSearchFilter + "^FullPath"
                }
             }

             if (!isNullOrEmpty(optionalMarker)) {
                 hdrs['key-marker'] = optionalMarker;
             }

             Ext.Ajax.request({
                 url: '/namespace/n.svc/jsondir/', // + 'newcdir', //todo refactor to a file
                 success: received,
                 scope: this,
                 failure: function () {

                     alert("Failed to send request");
                     TryHideLoading();

                 },
                 method: 'GET',
                 headers: hdrs

             });

         }

         function HasIllegalSearchChars(str) {
             if (str.indexOf("%") > -1 || str.indexOf("^") > -1) {
                 return true;
             }
             return false;
        }



         Ext.onReady(function () {
                   
            var ple = document.getElementById("divPubLnkExp");
             if (ple) {
                ple.innerHTML = "";
                if (top.gPubLnkExp) {
                    if (top.gPubLnkExp.length > 0) {
                        var txt = "<asp:Localize runat="server" meta:resourcekey="str_lnkSetToExpOn">Link set to expire on $DATE$</asp:Localize>";
                        ple.innerHTML = txt.replace("$DATE$", top.gPubLnkExp)
                    }
                }
             }


             if (parent.gRootFolder) {
                 gRootFolder = parent.gRootFolder;
                 gCurrentFolder = gRootFolder;
             }

             <%if (NeedsParentRoot) { %>
             if (top == self) {
                 window.location = "/portal/loginpage.aspx";
                 return;
             }

             if (!parent.gRootFolder) {
                 window.location = "/portal/loginpage.aspx";
                 return;
             }
             if (gRootFolder == "" || gRootFolder == "/") {
                 window.location = "/portal/loginpage.aspx";
                 return;
             }
             <%}%>



        CreateFileMap();
        SetCurrentFolder(gRootFolder, true);
        AdjustSize();
        document.body.onresize = AdjustSize;
             <% if (!IsMobile())        { %>
             //document.getElementById("MainContentDiv").style.backgroundColor = "#f8f8f8";
             <% }%>
             
         });
        document.body.onmousemove = function (event) {
            _gMouseX = event.pageX;
            _gMouseY = event.pageY;
        }
        document.body.oncontextmenu = function (event) {
            event.preventDefault();
            event.stopPropagation();
            closeAllCMenus();
        }
        document.body.onclick = function (event) {
            closeAllCMenus();
        }

        function SetBreadCrums(folder) {
            document.getElementById("breadcrums").innerHTML = "";
            var path = "";

            if (gCurrentFolder == "" || gCurrentFolder == "/") return;

            var sp0 = document.createElement("span");
            sp0.className = "toolnavbtn sectextcolor breadcrumbFolder";
            sp0.style = "font-weight: 100; font-size:14px; cursor: pointer;";
            var start = 0;
            //console.log("gRootFolder:" + gRootFolder)
            var res = [];

            if (gRootFolder != "") {
                //external share case
                //only display the last folder in the root path (otherwise the root will be the full path to the root)
                if (folder.indexOf(gRootFolder) == 0) {
                    folder = folder.substring(gRootFolder.length - 1);
                }
                res = folder.split("/");
                var gRootFolderArr = gRootFolder.split("/");
                var lastFolderOfRoot = gRootFolder;
                if (gRootFolderArr.length > 1) {
                    lastFolderOfRoot = gRootFolderArr[gRootFolderArr.length - 1];
                }
                start = 1;
                sp0.innerHTML = lastFolderOfRoot;
                sp0.alias = "";
            } else {
                //shared folder case
                res = folder.split("/");
                var lastFolder = res[res.length - 1];
                var breadcrumCounter = 0;
                //console.log("folder:" + folder)
                //console.log("lastFolder:" + lastFolder)
                sp0.innerHTML = "Root";
                sp0.alias = "";
            }
            sp0.onclick = function () {
                GoToBreadcrum(this);
            }
            document.getElementById("breadcrums").appendChild(sp0);

            for (var i = start; i < res.length; ++i) {
                var p = res[i];
                if (p == "") continue;
                var sp = document.createElement("span");
                sp.className = " ";
                breadcrumCounter++;
                sp.innerHTML = "&nbsp;&nbsp;&gt;&nbsp;&nbsp;";
                sp.style = "  font-weight: 100; cursor: pointer;";
                document.getElementById("breadcrums").appendChild(sp);
                sp = document.createElement("span");
                if (i == (res.length - 1)) {
                    sp.className = "toolnavbtn sectextcolor breadcrumbFolder lastBreadcrum";
                }
                else {
                    sp.className = "toolnavbtn sectextcolor breadcrumbFolder";
                }
                sp.style = " font-weight: 100; font-size:14px; cursor: pointer;";
                if (p == "69A884C0-9F3B-4736-AF57-CCA7C3CDC1B8") {
                    //peersharefolder
                    sp.innerHTML = ExplorerDetail4_6067_2_Shares;
                }
                else if (p.indexOf("g_trashbin") > -1) {
                    sp.innerHTML = ExplorerDetail4_6067_2_TrashCan;//Trash Can
                }
                else
                {
                    sp.innerHTML = p;
                    if (i < res.length - 1) {
                        if (path != "") {
                            path = path + "/" + p;
                        } else {
                            path = p;
                        }
                        sp.alias = path;
                        sp.onclick = function () {
                            GoToBreadcrum(this);
                        }
                    }
                }
                document.getElementById("breadcrums").appendChild(sp);
            }

        }
        function GoToBreadcrum(obj)
        {
            var dest = gRootFolder;
            if (obj.alias != "") {
                dest = dest + "/" + obj.alias;
            }
            SetCurrentFolder(dest, true);
        }
    </script>
</asp:Content>
