﻿<%@ Page Title="" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true"
    CodeBehind="DownloadPage.aspx.cs" Inherits="GladinetPayFlow.DownloadPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .appheader
        {
            background-color: #808080;
            background-image: -webkit-gradient(linear, 50% 0%, 50% 100%, color-stop(0%, #808080), color-stop(100%, #606060));
            background-image: -webkit-linear-gradient(top, #808080, #606060);
            background-image: -moz-linear-gradient(top, #808080, #606060);
            background-image: -o-linear-gradient(top, #808080, #606060);
            background-image: linear-gradient(top, #808080, #606060);
            border-bottom: 1px solid #555555;
            height: 32px;
            color: White;
            font-weight: normal;
            font-size: 16px;
            text-align:center;
        }
                
        html , #Form1, .main
        {
            overflow: auto;
        } 
        body 
        {
            height: auto;
            overflow: auto;
        }
        .svgImg{width:100%;}
        .mobileStoreCell{width:160px;text-align: center;margin:0px auto 20px auto;}
        .mobileStoreCell a{font-size:15px !important;line-height:15px;}
        ::-webkit-scrollbar {width: auto !important;}
        .fullContainer {width:100%;padding-top:20px;padding-left:20px;padding-right:20px;}
        .inlineItem {display:inline-block;position:relative;top:15px;margin-right:5px;margin-bottom:20px;}
        .idea_flex{white-space:nowrap;padding-left:40px;padding-top:13px;font-size:12px;line-height:normal;}
        #MainContent_IOSPanel,#MainContent_AndroidPanel,#MainContent_WindowsPhome,#MainContent_WindowsStoreApp{margin-left:auto;margin-right:auto;}
        .inlineItem a{font-size:15px;}
        #macLinks{text-align:left;padding:0px 10px 20px 100px;}
        @media (max-width: 1160px) {
           #macLinks{padding:10px 10px 20px 50px;}
        }
        @media (max-width: 470px) {
           .idea_flex{white-space:normal;padding-top:5px;font-size:11px;}
        }
        @media (max-width: 991px) {
           #macLinks{text-align:center;padding:10px 10px 20px 10px;}
        }
        @media (max-width: 640px){
           #divWinLogos{
             background-image:url(/portal/images/windows-logo-sm.jpg);width:131px;height:299px;margin:0px auto 0px auto;
           }
           #divWinSvrLogos{
             background-image:url(/portal/images/winsvr-logo-sm.jpg);width:131px;height:299px;margin:0px auto 0px auto;
           }
           #divMacLogos{
             background-image:url(/portal/images/macosx-logo-sm.jpg);width:131px;height:205px;margin:0px auto 0px auto;
           }
           .mobileStoreCell{width:200px;}
           #bottomSpacer{height:250px;clear:both;width:100%;}
        }
        @media (min-width: 641px) and (max-width: 800px){
           #divWinLogos{
             background-image:url(/portal/images/windows-logo-md.jpg);width:349px;height:96px;margin:0px auto 0px auto;
           }
           #divWinSvrLogos{
             background-image:url(/portal/images/winsvr-logo-md.jpg);width:349px;height:96px;margin:0px auto 0px auto;
           }
           #divMacLogos{
             background-image:url(/portal/images/macosx-logo-md.jpg);width:227px;height:96px;margin:0px auto 0px auto;
           }
           .mobileStoreCell{width:200px;}
           #bottomSpacer{height:250px;clear:both;width:100%;}
        }
        @media (min-width: 801px){
           #divWinLogos{
             background-image:url(/portal/images/windows-logo.jpg);width:468px;height:96px;margin:0px auto 10px auto;
           }
           #divWinSvrLogos{
             background-image:url(/portal/images/winsvr-logo.jpg);width:468px;height:96px;margin:0px auto 10px auto;
           }
           #divMacLogos{
             background-image:url(/portal/images/macosx-logo.jpg);width:304px;height:96px;margin:0px auto 10px auto;
           }
           .mobileStoreCell{width:160px;}
           #bottomSpacer{height:120px;clear:both;width:100%;}
        }
    </style>
<script type="text/javascript">
    function isAppleDesktop() {
        var isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;
        var isMacLike = navigator.platform.match(/(Mac|iPhone|iPod|iPad)/i) ? true : false;
        return (isMac && isMacLike);
    }
    function downloadInIFrame(url) {
        //downloads in iframe to prevent electron from leaving a blank window opened
        $("#downloadframe").prop("src", url);
    }
    var oldOnload = window.onload;
    window.onload = function () {
        if (oldOnload) oldOnload();
        var isFramed = (top.location.href!=location.href);
        if(isFramed){
            var parentIsComponentMode = (top.location.href.indexOf("?lu=1")>=1 || top.location.href.indexOf("&lu=1")>=1);
            if(parentIsComponentMode){
                document.getElementById("cmBackButton").style.display = "block";
            }
        }
        if (isAppleDesktop()) {
        try{
            $("html, body").scrollTop($('#<%=PanelMac.ClientID%>').offset().top - 30);
        }catch(ex){}
        }
        <%if (IsMobile()){%>
        try{
            $("html, body").scrollTop($('#<%=MobilePanel.ClientID%>').offset().top - 30);
        }catch(ex){}
        <%}%>
    }
</script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div id="cmBackButton" onclick="parent.closeCancelActiveWin();return false;" style="margin-top: 10px; margin-left: 40px; line-height: 40px; cursor: pointer; display: none;">
        <div class="gladinet-icons" style="font-size: 14px; margin-right: 10px; display: block; margin-top: 17px; float: left;">&#x10A;</div>
        <div style="display: inline-block;">
            <asp:Localize meta:resourcekey="str_bak" runat="server" Text="Back"></asp:Localize></div>
    </div>

    <asp:Panel ID="PanelDesc" runat="server" meta:resourcekey="PanelDescResource1">
        <div class="fullContainer">
            <p>
                <img src="images/btn_download.gif" style="float: left; display: none;" />
                <asp:Localize meta:resourcekey="string1" runat="server" Text="The browser-based file explorer provides most of the basic functionality. For a richer, native experience, you can download native clients."></asp:Localize>
            </p>
        </div>
    </asp:Panel>

    <asp:Panel ID="WindowsClientPanel" runat="server" meta:resourcekey="WindowsClientPanelResource1">
        <div class="appheader">
            <%: m_ProductName %>
            <asp:Localize meta:resourcekey="string2" runat="server" Text="Desktop Client (Windows)"></asp:Localize>
        </div>
        <div class="fullContainer">
            <p>
                <asp:Localize meta:resourcekey="string3" runat="server" Text="Installs on a ( Windows XP, Vista, 7, 8, 8.1, 10, 11) x86/x64 PC, access your storage account as a local drive, sync file across multiple machines."></asp:Localize>
            </p>
            <div class="row">
                <div class="col-12 col-lg-7">
                    <div id="divWinLogos"></div>
                </div>
                <div class="col-12 col-lg-5 linkColor" style="text-align:center;padding-top:10px;padding-bottom:20px;" onclick="downloadInIFrame(&quot;<%=m_WinLink%>&quot;);">
                    <div class="inlineItem">
                    <i class="gladinet-icons">&#xC5;</i>
                    </div>
                    <div class="inlineItem">
                    <span>
                    Window Client Installer <%=mWinVersion %></span>
                    </div>
                </div>
            </div>
        </div>
    </asp:Panel>

    <asp:Panel ID="ServerAgentPanel" runat="server" meta:resourcekey="ServerAgentPanelResource1">
        <div class="appheader">
            <%: m_ProductName %>
            <asp:Localize meta:resourcekey="string6" runat="server" Text="Server Agent"></asp:Localize>
        </div>
        <div class="fullContainer">
            <p>
                <asp:Localize meta:resourcekey="string7" runat="server" Text="Runs as a windows service. Operates with your storage account as a cloud file server or used as proxy agent to migrate your existing file server or active directory users."></asp:Localize>
            </p>
            <% if (IsPersonalAccount)
                { %>
            <h2>
                <asp:Localize meta:resourcekey="string8" runat="server" Text="Not available for personal account"></asp:Localize></h2>
            <% }
            else
            { %>
            <div class="row">
                <div class="col-12 col-lg-7">
                    <div id="divWinSvrLogos"></div>
                </div>
                <div class="col-12 col-lg-5 linkColor" style="text-align:center;padding-top:10px;padding-bottom:20px;" onclick="downloadInIFrame(&quot;<%=m_WinSvrLink%>&quot;);">
                    <div class="inlineItem">
                    <i class="gladinet-icons">&#xC5;</i>
                    </div>
                    <div class="inlineItem">
                    <span>
                    Server Agent Installer <%=mWinSvrVersion %></span>
                    </div>
                </div>
            </div>

            <% } %>
        </div>
    </asp:Panel>

    <asp:Panel ID="SvrWinPanel" runat="server" meta:resourcekey="SvrWinPanelResource1"></asp:Panel>
    <asp:Panel ID="WindowsClientHelp" runat="server" meta:resourcekey="WindowsClientHelpResource1">
        <div class="fullContainer idea_flex">
            <asp:Localize ID="Localize1" meta:resourcekey="string11" runat="server" Text="Please do not install Windows Client and Server Agent on the same machine."></asp:Localize>
        </div>
    </asp:Panel>

    <asp:Panel ID="PanelMac" runat="server" meta:resourcekey="PanelMacResource1">

        <asp:Panel ID="MacClientPanel" runat="server" meta:resourcekey="MacClientPanelResource1">
            <div class="appheader">
                <%:m_ProductName%>
                <asp:Localize meta:resourcekey="string12" runat="server" Text="Desktop Client (Mac OS X)"></asp:Localize>
            </div>
            <div class="fullContainer">
                <p>
                    <asp:Localize meta:resourcekey="string13" runat="server" Text="Installs on Mac OS X, access your storage account as a local drive (mounted volume in Finder)."></asp:Localize>
                </p>
            <div class="row">
                <div class="col-12 col-lg-7">
                        <div id="divMacLogos"></div>
                    </div>
                <div class="col-12 col-lg-5" id="macLinks">
                        <div style="margin-top:-10px;">
                            <div class="inlineItem linkColor" style="white-space:nowrap;" onclick="downloadInIFrame(&quot;<%=m_MacLink%>&quot;);">
                            <i class="gladinet-icons">&#xC5;</i><span style="font-size:15px;">
                                <asp:Localize meta:resourcekey="string14" runat="server" Text="Installer Package (MacOS 10.9/10.10/10.11/10.12)"></asp:Localize></span>
                            </div>
                        </div>
                        <div style="margin-top:5px;">
                            <div class="inlineItem linkColor" style="white-space:nowrap;" onclick="downloadInIFrame(&quot;<%=m_MacLink9%>&quot;);">
                            <i class="gladinet-icons">&#xC5;</i><span style="font-size:15px;">
                                <asp:Localize meta:resourcekey="string15" runat="server" Text="Installer Package (MacOS 10.13 and above)"></asp:Localize></span>
                            </div>
                        </div>
                        <div style="display: none">
                            <a target="_blank" href="docs/V4/Gladinet-Cloud-Mac-Client-Release-History.html">
                                <asp:Localize meta:resourcekey="string16" runat="server" Text="Release History"></asp:Localize></a>
                        </div>
                    </div>
                </div>
            </div>
        </asp:Panel>

    </asp:Panel>

    <asp:Panel ID="MobilePanel" runat="server" meta:resourcekey="MobilePanelResource1">
        <div class="appheader">
            <%:m_ProductName%>
            <asp:Localize meta:resourcekey="string17" runat="server" Text="Mobile"></asp:Localize>
        </div>
        <div class="fullContainer">
            <div class="row">
                <asp:Panel ID="IOSPanel" runat="server" meta:resourcekey="IOSPanelResource1">
                        <div class="mobileStoreCell">
                            <img src="images/ios_appstore.svg" class="svgImg" />
                            <br />
                            <a target="_blank" href="<%=m_IOSLink%>">
                                <asp:Localize meta:resourcekey="string18" runat="server" Text="View in Apple App Store"></asp:Localize>
                            </a>
                        </div>
                </asp:Panel>
                <asp:Panel ID="AndroidPanel" runat="server" meta:resourcekey="AndroidPanelResource1">
                        <div class="mobileStoreCell">
                            <img src="images/android_appstore.svg" class="svgImg" />
                            <br />
                            <a target="_blank" href="<%=m_AndroidLink%>">
                                <asp:Localize meta:resourcekey="string19" runat="server" Text="Available in &quot;Google Play&quot; Market Store. Android OS 4.4+"></asp:Localize>
                            </a>
                        </div>
                </asp:Panel>
                <asp:Panel ID="WindowsPhome" runat="server" meta:resourcekey="WindowsPhomeResource1">

                        <div class="mobileStoreCell">

                            <img src="images/wphone_appstore.svg" class="svgImg" />
                            <br />
                            <a target="_blank" href="<%=m_WindowsPhoneLink%>">
                                <asp:Localize meta:resourcekey="string20" runat="server"
                                    Text="Available in &quot;Windows Phone&quot; Store. Windows Phone 8+"></asp:Localize>
                            </a>
                        </div>
                </asp:Panel>

                <asp:Panel ID="WindowsStoreApp" runat="server" meta:resourcekey="WindowsPhomeResource1">
                        <div class="mobileStoreCell">
                            <img src="images/wrt_appstore.svg" class="svgImg" />
                            <br />
                            <a target="_blank" href="<%=m_WindowsStoreLink%>">
                                <asp:Localize meta:resourcekey="string21" runat="server"
                                    Text="Available in Windows Store. Windows 8+ (Windows RT, Surface)"></asp:Localize>
                            </a>
                        </div>
                </asp:Panel>
            </div>
        </div>
    </asp:Panel>

    <div style="clear:both;width:100%;height:1px;"></div>
    <asp:Panel ID="ClosePanel" runat="server" meta:resourcekey="ClosePanelResource1">
        <div style="clear: both; text-align: right; width: 100%;">
            <asp:Localize ID="asp_string1" meta:resourcekey="asp_string1" runat="server" Visible="False" Text="Close Window"></asp:Localize>
            <input id="MainContent_ButtonCloseWin" type="submit" class="btn btn-primary" onclick="parent.closeCancelActiveWin(); return false;" value='<%=asp_string1.Text %>' />
        </div>
    </asp:Panel>
    <div id="bottomSpacer"></div>

    <iframe id='downloadframe' style="display: none;"></iframe>
</asp:Content>
