﻿<%@ Page Title="File Search" Language="C#" MasterPageFile="~/WebAppPanelNoExt.master"
    AutoEventWireup="true" CodeBehind="ClientFileSearch.aspx.cs" Inherits="GladinetPayFlow.ClientFileSearch"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <script type="text/javascript">
        
        function gEncodeUri(str) {

            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }


        function closeCancelActiveWin() {
            ActiveWin.close();
        }
        function OnThumbImageLoad(cid) {
            var thumb = document.getElementById(cid + "_img");
            var ico = document.getElementById(cid + "_ico");
            if (thumb.src.indexOf("/portal/images/s.gif") > -1) {
                thumb.style.display = "none";
                ico.style.display = "";
            } else {
                thumb.style.display = "";
                ico.style.display = "none";
            }
        }

        function OnOpenFile(aliasID) {   
            try{
                var aliasObj = document.getElementById(aliasID);
                f = aliasObj.innerText;
                if (window.ClientShellHandler) {
                    window.ClientShellHandler.OpenFile(f);
                    return;
                }
            } catch (e) {
            }
            document.title = "file:" + f;
            window.location = "fileex:" + f;
            
        }
        function OnOpenFolder(aliasID) {     
            try {
                var aliasObj = document.getElementById(aliasID);
                f = aliasObj.innerText;
                if (window.ClientShellHandler) {
                    window.ClientShellHandler.OpenFolder(f);
                    return;
                }
            } catch (e) {  
            }
            document.title = "folder:" + f;
            window.location = "folder:" + f;
        }
        function showMenuArrow(id){
            $("#"+id).show();
        }
        function hideMenuArrow(id) {
            $("#"+id).hide();
        }
        var _sortCol = "name";
        function onToggleTableMenu(evt, id) {
            evt.preventDefault();
            evt.stopPropagation();
            switch (id) {
                case "vSizeMenuArrow":
                    _sortCol = "size";
                    break;
                case "vDateMenuArrow":
                    _sortCol = "date";
                    break;
                default:
                    _sortCol = "name";
                    break;
            }
            var arrowPos = $("#" + id).position();
            if ($("#vMenuActions").is(":visible")) {
                $("#vMenuActions").hide();
            } else {
                $("#vMenuActions").css({ "top": parseInt(arrowPos.top) + "px", "left": parseInt(arrowPos.left - $("#vMenuActions").width()) + "px" });
                $("#vMenuActions").show();
            }
        }
        function closeMenu() {
            $("#vMenuActions").hide();
        }
        function SetSort(AsdOrDesc) {
            var i = 0;
            var keepRunning = true;
            var sortRow = false;
            if (AsdOrDesc == "Asc") {
                $("#vMenuActionsSortAsc").addClass("vMenuActionSelected");
                $("#vMenuActionsSortDesc").removeClass("vMenuActionSelected");
            } else {
                $("#vMenuActionsSortAsc").removeClass("vMenuActionSelected");
                $("#vMenuActionsSortDesc").addClass("vMenuActionSelected");
            }               
            while (keepRunning) {
                keepRunning = false;
                var rows = $(".x-grid-tr");
                for (i = 0; i < (rows.length - 1); i++) {
                    sortRow = false;
                    var thisRow = $("#" + rows[i].id);
                    var nextRow = $("#" + rows[i+1].id);
                    var thisValue = thisRow.find("." + _sortCol + "Col").text().toLowerCase();
                    var nextValue = nextRow.find("." + _sortCol + "Col").text().toLowerCase();
                    if (AsdOrDesc == "Asc") {
                        if (thisValue > nextValue) {
                            sortRow = true;
                            break;
                        }
                    } else {
                        if (thisValue < nextValue) {
                            sortRow = true;
                            break;
                        }
                    }               
                }
                if (sortRow) {
                    $(rows[i]).before($(rows[i + 1]));
                    keepRunning = true;
                }
            }
        }
    </script>
    <style type="text/css">
    #vMenuActions{display:none;position:absolute;color:#666;top:0;left:0;border:1px solid #d8d8d8;background-color:#FFF;padding:0;z-index:3000;}
    .vMenuActionSelected{background-color:#CCE4F7;}    
    .vMenuRow{display:block;min-height:30px;width:100%;padding:5px;white-space:nowrap !important;}
    .vMenuRow i,.vMenuRow input{margin:0 0 0 7px;}
    .vMenuRow .gladinet-icons{padding-right:10px;margin-top:5px;float:left;}
    #vMenuActionsSubMenu .vMenuRow span{padding:10px;}
    .vGridLeft {float:left;}
    .vMenu div {display:block;white-space:nowrap;cursor:pointer;}
    .vMenuArrow{display:none;width:20px;margin-top:0px;text-align:right}
    .vMenuArrow .gladinet-icons{font-size:14px;line-height:14px;cursor:pointer;margin-right:10px;}
    .popover{max-width:50%;}
    .popover-body {font-size: 18px;font-weight: 100;padding: 30px;}
    .popover-header {font-size: 18px;font-weight: 100;padding:20px;}
    <% if (DarkMode==1) { %> 
     #MainContentDiv,td,div { background-color: #000000 !important;}  
     #resdiv{scrollbar-color:#DFDFDF #646464 !important;}             
     #resdiv:default{scrollbar-color:#DFDFDF #646464 !important;}                     
     #resdiv::-webkit-scrollbar-thumb {color:#DFDFDF !important;background-color:#DFDFDF !important;}  
     #resdiv::-webkit-scrollbar-track {color:#646464 !important;background-color:#646464 !important;} 
    <% } %>
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div class="wrapper" style="background-color: white; width:100%; overflow:hidden;" onclick="closeMenu()">
    <table width="100%"  id="topdiv">
        <tr>
            <td align="center" style="padding:10px; padding-top:40px;">
                <table style="width:100%; max-width:800px">
                    <tr>
                        <td>
                            <asp:Panel ID="Panel1" runat="server" DefaultButton="SearchFiles">
                                    <div style="padding-left: 0px;" class="trbordercolor">
                                        <table style="width:75%;margin-left:auto;margin-right:auto;">
                                             <%if (SResultRepeater.Items.Count <= 0)            { %>
                                            <tr>
                                               <td colspan="2" style="padding-right:20px; padding-top:40px;padding-left:0px;padding-bottom:40px; font-size:22px; font-weight:100;color: #565656;text-align:center;">
                                                   <asp:Localize runat="server" meta:resourcekey="str_PleEntTheSeaFilAndCliSea">Please enter the search filter, and click 'Search'</asp:Localize></td>
                                            </tr>
                                            <%} %>
                                            <tr>
                                                <td height="45px" style="padding-right: 10px;" align="right">
                                                    <asp:TextBox ID="SearchText" CssClass="form-control" runat="server" style="font-size:22px;padding-left:10px !important;"></asp:TextBox>
                                                </td>
                                                <td height="45px" width="60px" align="left">
                                                    <asp:LinkButton ID="SearchFiles" runat="server" OnClick="SearchFiles_Click" OnClientClick="Wait('...');" ToolTip="Search" meta:resourcekey="str_src">
                                                <span class="gladinet-icons md-dark hand center toolbtn  btniconcolor" style="font-size: 22px; margin-top: -3px; margin-left: -6px;">&#xA7;</span>
                                                    </asp:LinkButton>

                                                <div id="SearchHelp" class="gladinet-icons md-dark hand center toolbtn  btniconcolor" 
                                                    style="font-size: 22px; margin-top: -3px; margin-left:10px;" 
                                                    title="<asp:Localize meta:resourcekey="str_srcHlp" runat="server">Search Help</asp:Localize>"
                                                    data-toggle="popover" data-html="true">?</div>

                                                    <div id="popoverBody" style="display:none;">                                                        
                                                        <asp:Localize meta:resourcekey="asp_string4" runat="server">To perform a single character wildcard search use the "?" symbol.</asp:Localize>
                                                        <br /><br />              
                                                        <asp:Localize meta:resourcekey="asp_string5" runat="server">To perform a multiple character wildcard search use the "*" symbol.</asp:Localize>
                                                        <br /><br />              
                                                        <asp:Localize meta:resourcekey="asp_string6" runat="server">The single character wildcard search looks for terms that match a single character.</asp:Localize><br /><br />
                                                        <div style="margin-left:30px;">
                                                            <asp:Localize meta:resourcekey="asp_string6b" runat="server">For example: to search for "text" or "test" you can use the search term: te?t</asp:Localize> 
                                                        </div>
                                                        <br />              
                                                        <asp:Localize meta:resourcekey="asp_string7" runat="server">Multiple character wildcard searches looks for 0 or more characters.</asp:Localize> 
                                                        <br /><br />
                                                        <div style="margin-left:30px;">
                                                            <asp:Localize meta:resourcekey="asp_string7b" runat="server">For example: to search for test, tests, or tester, you can use the search term: test*</asp:Localize>                                                     
                                                        </div>
                                                        <br />
                                                        <i><asp:Localize meta:resourcekey="str_headstart" runat="server">Note: The search might take a long time if you use the * or ? symbols as the first characters of a search.</asp:Localize></i>                
                                                    </div>

                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </asp:Panel>
                        </td>

                    </tr>
                </table>
            </td>
        </tr>
    </table>
        <% if (Page.IsPostBack || !string.IsNullOrEmpty(SearchText.Text)) { %>
        <%if (SResultRepeater.Items.Count > 0)            { %>
        <div style="padding:60px;width:100%; overflow:auto;" id="resdiv">

            <table width="100%" >
                
                <tr style="border-bottom:1px solid #f0f0f0;">
                    <td style="width:50px;"></td>
                    <td style="padding:3px; color:#565656; font-weight:400;font-size:18px !important;"><asp:Localize runat="server" meta:resourcekey="str_FilNam">File Name</asp:Localize></td><td style="width:22px;"></td>
                    <td style="padding:3px; color:#565656; font-weight:400;font-size:18px !important;width:80px;"><asp:Localize runat="server" meta:resourcekey="str_Siz">Size</asp:Localize></td><td style="width:22px;"></td>
                    <td style="padding:3px; color:#565656; font-weight:400;font-size:18px !important;width:80px;"><asp:Localize runat="server" meta:resourcekey="str_LasMod">Last Modified</asp:Localize></td><td style="width:22px;"></td>
                    <td style="width:50px;"></td>
                </tr>
            
            <asp:Repeater ID="SResultRepeater" runat="server">
                <ItemTemplate>
                    <tr id="rpt_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>" style="border-bottom:1px solid #f0f0f0; padding:5px; " class="x-grid-tr">
                        <td width="48px" style="padding:3px;" valign="middle">
                            <div id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_alias" style="display:none;"><%#DataBinder.Eval(Container.DataItem, "AliasLocation")%></div>
                            <div id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_ico" style="padding-top:8px;">
                                    <span class="gladinet-icons   btniconcolor" id="rpt_ico_<%#DataBinder.Eval(Container.DataItem, "NodeId")%>" style="font-size:32px !important;"><%#DataBinder.Eval(Container.DataItem, "TypeImgUrl")%></span>
                                </div>
                                
                            <img  style="display: none; width:32px; border-radius:3px;"  src="<%#DataBinder.Eval(Container.DataItem, "PreviewImgUrl")%>" id="<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_img" onload="OnThumbImageLoad('<%#DataBinder.Eval(Container.DataItem, "NodeId")%>')"/>
                        </td>
                        <td style="cursor:pointer;" title="Click to open:   <%#DataBinder.Eval(Container.DataItem, "DescTitle")%>" colspan="2">
                          <span class='titletxt nameCol' onclick='OnOpenFile("<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_alias");' style='vertical-align: middle; color:#404040; font-weight:100;font-size:14px !important;'  > <%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                        </td>
                        <td width="80px" style="padding:3px;" colspan="2">
                            <span class='titletxt sizeCol' style='vertical-align: middle; color:#565656; font-weight:100;font-size:14px !important;'> <%#DataBinder.Eval(Container.DataItem, "EDTTag")%></span>
                        </td>
                        <td width="164px" style="padding:3px;" colspan="2">
                            <span class='titletxt dateCol' style='vertical-align: middle; color:#565656; font-weight:100;font-size:14px !important;'> <%#DataBinder.Eval(Container.DataItem, "LastModified")%></span>
                        </td>
                        <td width="64px">
                            <span class="gladinet-icons   btniconcolor" style="font-size:24px !important; cursor:pointer;" title="Open containing folder" onclick='OnOpenFolder("<%#DataBinder.Eval(Container.DataItem, "NodeId")%>_alias");'>#</span>
                        </td>
                    </tr>
                    
                    
                </ItemTemplate>
                
            </asp:Repeater>
                </table>
        </div>
        <%}else { %>
        <div style="padding-top:80px;font-size:24px; font-weight:100; color:#565656">
            <table style="width:100%;">
                <tr>
                    <td style="text-align:center;font-size:24px; font-weight:100; color:#565656"><asp:Localize runat="server" meta:resourcekey="str_NoRes">No results were found</asp:Localize></td>
                </tr>
            </table>
            
        </div>
        <%} %>

        <%}else { %>
        <%} %>
   </div>
    
   
    
 
    
    <script type="text/javascript">
        function OnPageLoad() {
            $(function () {
                $('[data-toggle="popover"]').popover({
                    content: document.getElementById("popoverBody").innerHTML
                });
            })

            var e = document.getElementById("resdiv");
            if (!e) {
                var e2 = document.getElementById("MainContent_SearchText");
                e2.focus();
                return;
            }
            var e1 = document.getElementById("topdiv");
            
            e.style.height = (document.documentElement.clientHeight - e1.offsetHeight - 5) + "px";
        }
    </script>
</asp:Content>
