﻿<%@ Page Title="Browse Tree" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BrowseTreePage.aspx.cs" Inherits="GladinetPayFlow.BrowseTreePage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td
        {
            font-size: 12px;
            font-family: sans-serif,Verdana;
            font-weight: 100;
        }
        
        b
        {
            font-weight: 300;
        }
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">

        function Toggle(name) {
            var d = document.getElementById(name);
            if (d.style.display == 'none')
                d.style.display = 'block';
            else
                d.style.display = 'none';
        }

        function TogglePubUser() {
            var d = document.getElementById("pubusers");
            var t = document.getElementById("pubusersc");
            if (d.style.display == 'none') {
                d.style.display = 'block';
                t.style.height = "300px";
            } else {
                t.style.height = "10px";
                d.style.display = 'none';
            }
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var SelItem = null;
        var cursel = "";

        function gEncodeUri(str) {

            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function onfolderselect(obj, key) {
            obj.style.backgroundColor = "#CBE1FC";
            if (SelItem) {
                SelItem.select = 0;
                SelItem.style.backgroundColor = "WHITE";
            }
            obj.select = 1;
            SelItem = obj;
            cursel = key;

            var o = document.getElementById("MainContent_CurSel");
            o.value = "/" + key;

        }

        function onparent(obj, key) {
            var uri = "BrowseTreePage.aspx?vdid=<%=SessionDomainId%>&path=";

            uri += gEncodeUri(key);
            
            Wait("<asp:Localize meta:resourcekey="js_string1" runat="server">Please wait ...</asp:Localize>");
            window.location = uri;
        }
        function removeLeadingSlash(str){
            if(!str) return "";
            return str.replace(/^\/+/g,"");
        }
        function onfolderdblclick(obj, key) {
            try{
                if(obj.dataset.key){
                    var curSelObj = document.getElementById("MainContent_CurSel");
                    var clickedOnFolder = "";
                    if(curSelObj) clickedOnFolder = curSelObj.value;
                    var clickedOnItem = clickedOnFolder + "/" + obj.dataset.key;
                    if(parent._clippedItem){
                        if(parent._clippedItem.indexOf("\t")){
                            var key_isFld = parent._clippedItem.split("\t");
                            if(key_isFld.length==3){
                                selKey = key_isFld[0];
                                var isFld = (key_isFld[2]=="1");
                                if(isFld) {
                                    if(removeLeadingSlash(selKey).toLowerCase() == removeLeadingSlash(clickedOnItem).toLowerCase()){
                                        alert("<asp:Localize meta:resourcekey="str_mveToIsfMsg" runat="server">Sorry. You cannot move a folder inside of itself.</asp:Localize>")
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }catch(ex){
                console.log("Failed destination folder check");
            }
            var uri = "BrowseTreePage.aspx?vdid=<%=SessionDomainId%>&path=" ;
            var p = XSSDecode("<%=XSSUrlEncode(CurParent) %>")+key;
            
            uri += gEncodeUri(p);
            Wait("<asp:Localize meta:resourcekey="js_string1" runat="server">Please wait ...</asp:Localize>");
            window.location = uri;
        }

        function onfolderout(obj) {

            if (obj.select == 1)
                obj.style.backgroundColor = "#CBE1FC";
            else
                obj.style.backgroundColor = "WHITE";
        }

        function OnNewFolder(parent) {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'block';
            d.style.left = (document.body.offsetWidth - 450) / 2 + "px";

            d = document.getElementById("MainContent_CurrentParentFolder");

            d.value = parent;

        }

        function OnCancelNewFolder() {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'none';
            d.style.left = (document.body.offsetWidth - 600) / 2 + "px";
        }

        function onOk() {
            var o = document.getElementById("MainContent_CurSel");
            if (o.value.indexOf('"') != -1 && o.value.indexOf('<') != -1 && o.value.indexOf('>') != -1) {
                alert("bad name");
                o.value  = "";
                return;
            }
            cursel = o.value.substring(1);
            
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder(cursel);
            else
                parent.parent.SetSelectedFolder(cursel);
        }

        function onRoot() {
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder("");
            else
                parent.parent.SetSelectedFolder("");
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div id="errmsgdiv">
        <b>
            <asp:Label ID="Label1" runat="server" Style="color: Red;" meta:resourcekey="Label1Resource1"></asp:Label></b>
    </div>
    <table width="100%" height="100%" align="center" cellpadding="0" cellspacing="0" 
        style="background-color: WHITE;">
        <tr style="background-color: wite;">
            <% if (!string.IsNullOrEmpty(CurParent) && CurParent.Length > 1)
               {%>
            <td width="120px" height="20px" style="border-bottom: 1px solid #d0d0d0;">
                <table>
                    <tr>
                        <td width="18px">
                            <img height="16px" src="images/up32.png" />
                        </td>
                        <td>
                            <a href="#" style="font-size: 12px;" onclick="onparent(this, Ext.util.Format.htmlDecode('<%:PrevParent%>'));return false;">
                                <asp:Localize meta:resourcekey="asp_string3" runat="server">Parent Folder</asp:Localize></a>
                        </td>
                    </tr>
                </table>
            </td>
            <%} %>
            <td align="left" style="border-bottom: 1px solid #d0d0d0; padding: 5px; height:20px;">
                <table>
                    <tr>
                       
                        <td>
                            <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                              { %>
                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                            <%} %>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tree_container">
            <td colspan="2" height="140px" valign="top" style="border-bottom: 1px solid #d0d0d0;overflow: auto" >
                <div style="width: 100%;overflow: auto;" id="maintree">
                    
                
                <%if (!EmptyFolder)
                  { %>
                
                    <asp:Repeater ID="FolderList" runat="server">
                        <ItemTemplate>
                            <table width="95%" onmousedown="return false;" onselectstart="return false;" style="cursor: hand;
                                mozuserselect: none;" cellspacing="0" cellpadding="2px" onmouseover="this.style.backgroundColor='#f0f0f0';"
                                onmouseout="onfolderout(this)" ondblclick='onfolderselect(this,Ext.util.Format.htmlDecode("<%# Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString()) %>"))'
                                onclick='onfolderdblclick(this, Ext.util.Format.htmlDecode("<%# Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString().Replace("'","%27")) %>"))' data-key="<%# Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString().Replace("\"","&quot;")) %>">
                                <tr style="padding-top: 5px;">
                                    <td width="30px" style="background-color: White; cursor: pointer;padding-left:5px">
                                         <span class="fa fa-folder" style="font-size: 18px; color:#a0a0a0;background-color:white;" aria-hidden="true"></span>
                                    </td>
                                    <td style=" padding: 5px;padding-left: 10px;font-size: 16px;color:#404040;background-color:white; font-weight: 100; cursor:pointer; " class="toolnavbtn">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Key").ToString())%>
                                    </td>
                                </tr>
                            </table>
                        </ItemTemplate>
                    </asp:Repeater>
                    
                <%}
                  else
                  {%>
                <div class='idea_flex'>
                    <asp:Localize meta:resourcekey="asp_string5" runat="server">No subfolder found.</asp:Localize>
                </div>
                <%}%>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding: 4px;">
                <table width="100%">
                    <tr>
                        <td width="100px">
                            <asp:Localize meta:resourcekey="asp_string6" runat="server">Folder Name:</asp:Localize>
                        </td>
                        <td>
                            <asp:TextBox ID="CurSel" runat="server" Width="95%" meta:resourcekey="CurSelResource1" CssClass="form-control"></asp:TextBox>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding: 5px; padding-top: 10px; ">
                <table width="100%">
                    <tr>
                        <td style="padding-right: 10px" align="left">
                            <button type="button" class="btn btn-default " data-toggle="modal" data-target="#NewFolderCtrl"> <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>&nbsp;&nbsp;<asp:Localize ID="Localize3" meta:resourcekey="asp_string4" runat="server">New Folder</asp:Localize></button>
                            <div class='idea_flex' style="display: none">
                                <asp:Localize meta:resourcekey="asp_string7" runat="server">Double click to browse into</asp:Localize><br />
                                <asp:Localize meta:resourcekey="asp_string8" runat="server">Click to select</asp:Localize></div>
                        </td>
                        <td align="right">
                            <asp:Button ID="OkBtn" Font-Size="12pt" CssClass="btn btn-primary gladbtn" Width="80px" runat="server"
                                Text="Ok" Style="padding: 2px;" OnClientClick="onOk();return false;" CausesValidation="False"
                                meta:resourcekey="OkBtnResource1" />
                            <asp:Button ID="CancelBTn" Font-Size="12pt" CssClass="btn btn-default" Width="80px" runat="server"
                                Text="Cancel" Style="padding: 2px;" OnClick="CancelBTn_Click" CausesValidation="False"
                                meta:resourcekey="CancelBTnResource1" />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <div style="height: 30px; display: none;">
        <asp:HiddenField ID="CurrentParentFolder" runat="server" />
    </div>
    
        <div id="NewFolderCtrl" class="modal fade" role="dialog">
            <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server">Create New Folder</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <table width="100%" height="100%" align="center" style="background-color: WHITE;
                        padding: 10px;">
                        <tr>
                            <td class="InputLabel">
                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string2" runat="server">New Folder Name</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="NewFolderName" runat="server" Width="95%" class="InputText" meta:resourcekey="NewFolderNameResource1" CssClass="form-control"></asp:TextBox>
                                <div style="color: #D00000">
                                    <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="NewFolderName"
                                        ErrorMessage="Folder name is required!" Display="Dynamic" CssClass="errmsg" meta:resourcekey="reqNameResource1" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" style="display: none">
                                <table width="100%" align="center">
                                    <tr>
                                        <td align="left">
                                        </td>
                                        <td align="right" colspan="2" style="border-top: 0px solid #d0d0d0; padding-top: 15px;">
                                            &nbsp;&nbsp;&nbsp;&nbsp;
                                            <asp:Button ID="CancelChange" runat="server" Text="Cancel" CssClass="btn btn-default"
                                                OnClientClick="OnCancelNewFolder()" Width="120px" meta:resourcekey="CancelChangeResource1" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
      </div>
      <div class="modal-footer">
          <asp:Button ID="CreateButtonNow" runat="server" Text="Apply Change" 
                                                CssClass="btn btn-primary" OnClick="CreateButtonNow_Click" Width="140px" meta:resourcekey="CreateButtonNowResource1" />
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_Clo">Close</asp:Localize></button>
      </div>
    </div>

  </div>
        
        
    </div>
    
     <script type="text/javascript">
         function AdjustSize() {
             var e = document.getElementById("maintree");
             e.style.height = (document.documentElement.offsetHeight - 148) + "px";

         }

         AdjustSize();
         document.body.onresize = AdjustSize;
         
    </script>
</asp:Content>
