﻿<%@ Page Title="Reset Password" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="AD2Native.aspx.cs" Inherits="GladinetPayFlow.AD2Native" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
 <script type="text/javascript">
     
     var Base64 = {

         // private property
         _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

         // public method for encoding
         encode: function (input) {
             var output = "";
             var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
             var i = 0;

             input = Base64._utf8_encode(input);

             while (i < input.length) {

                 chr1 = input.charCodeAt(i++);
                 chr2 = input.charCodeAt(i++);
                 chr3 = input.charCodeAt(i++);

                 enc1 = chr1 >> 2;
                 enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                 enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                 enc4 = chr3 & 63;

                 if (isNaN(chr2)) {
                     enc3 = enc4 = 64;
                 } else if (isNaN(chr3)) {
                     enc4 = 64;
                 }

                 output = output +
        this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
        this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

             }

             return output;
         },

         // public method for decoding
         decode: function (input) {
             var output = "";
             var chr1, chr2, chr3;
             var enc1, enc2, enc3, enc4;
             var i = 0;

             input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

             while (i < input.length) {

                 enc1 = this._keyStr.indexOf(input.charAt(i++));
                 enc2 = this._keyStr.indexOf(input.charAt(i++));
                 enc3 = this._keyStr.indexOf(input.charAt(i++));
                 enc4 = this._keyStr.indexOf(input.charAt(i++));

                 chr1 = (enc1 << 2) | (enc2 >> 4);
                 chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                 chr3 = ((enc3 & 3) << 6) | enc4;

                 output = output + String.fromCharCode(chr1);

                 if (enc3 != 64) {
                     output = output + String.fromCharCode(chr2);
                 }
                 if (enc4 != 64) {
                     output = output + String.fromCharCode(chr3);
                 }

             }

             output = Base64._utf8_decode(output);

             return output;

         },

         // private method for UTF-8 encoding
         _utf8_encode: function (string) {
             string = string.replace(/\r\n/g, "\n");
             var utftext = "";

             for (var n = 0; n < string.length; n++) {

                 var c = string.charCodeAt(n);

                 if (c < 128) {
                     utftext += String.fromCharCode(c);
                 }
                 else if ((c > 127) && (c < 2048)) {
                     utftext += String.fromCharCode((c >> 6) | 192);
                     utftext += String.fromCharCode((c & 63) | 128);
                 }
                 else {
                     utftext += String.fromCharCode((c >> 12) | 224);
                     utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                     utftext += String.fromCharCode((c & 63) | 128);
                 }

             }

             return utftext;
         },

         // private method for UTF-8 decoding
         _utf8_decode: function (utftext) {
             var string = "";
             var i = 0;
             var c = c1 = c2 = 0;

             while (i < utftext.length) {

                 c = utftext.charCodeAt(i);

                 if (c < 128) {
                     string += String.fromCharCode(c);
                     i++;
                 }
                 else if ((c > 191) && (c < 224)) {
                     c2 = utftext.charCodeAt(i + 1);
                     string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                     i += 2;
                 }
                 else {
                     c2 = utftext.charCodeAt(i + 1);
                     c3 = utftext.charCodeAt(i + 2);
                     string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                     i += 3;
                 }

             }

             return string;
         }

     }

     function BeforeSubmit() {
         var e = document.getElementById("MainContent_txtPassword1");
         e.value = "!0!0!" + Base64.encode(e.value);
         e = document.getElementById("MainContent_txtPassword2");
         e.value = "!0!0!" + Base64.encode(e.value);
         Wait('One minute...');
     }

     function CloseWin() {
     <% if (!string.IsNullOrEmpty(GoToFildBrowser.Value)){ %>
         window.location = "/portal/loginpage.aspx";
         return;
     <% } %>

         try {
             parent.closeCancelActiveWin();
         } catch (e) {

         }

         try {
             if (parent.activewin)
                 parent.activewin.close();
         } catch (e1) {

         }         
     }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocSysIntErrDecFai" meta:resourcekey="str_sysIntErrDecFai" Visible="false">system internal error: decode failed.</asp:Localize>
<asp:Localize runat="server" ID="LocAccDen" meta:resourcekey="str_accDen" Visible="false">Access Denied</asp:Localize>
<asp:Localize runat="server" ID="LocFai" meta:resourcekey="str_fai" Visible="false">Failed:</asp:Localize>
<asp:Localize runat="server" ID="LocFaiSetUsePas" meta:resourcekey="str_faiSetUsePas" Visible="false">Failed to set user password:</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToCon" meta:resourcekey="str_faiToCon" Visible="false">Failed to convert:</asp:Localize>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
             
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
         {
             height: 100%;
         }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
          
    </style>
    <div class="wrapper">
        <table width="100%" align="center" style="padding: 0px;">
            <tr>
                <td colspan="2" class=" x-panel-header-light x-panel-header-text-container-light"
                    style="height: 48px; border-top: 0; border-left: 0; border-right: 0; padding-left: 16px;
                    vertical-align: middle; text-align: left; font-size: 16px;">
                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string4" runat="server" 
                        Text="User"></asp:Localize>
                    :
                    <asp:Label ID="LabelEmail" runat="server" meta:resourcekey="LabelEmailResource1"></asp:Label>
                </td>
            </tr>
        </table>
        <table width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="padding-left: 16px;
            padding-right: 16px;">
            <tr>
                <td style="padding-top: 20px;">
                    <div style="background-color: white; : 0px solid white; padding: 16px; padding-top:2px;">
                        <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                           { %>
                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <%} %>
                        <% if (!string.IsNullOrEmpty(GoToFildBrowser.Value))
                           { %>
                        <span style="color: #008000">
                            <asp:Localize meta:resourcekey="asp_string1" runat="server" 
                            Text="You must change your password to continue"></asp:Localize></span>
                        <%} %>
                        <br />
                        <br />
                        <br />
                        <table width="96%" align="center">
                            <tr>
                                <td valign="top">
                                    <asp:Localize meta:resourcekey="asp_string2" runat="server" Text="Password :"></asp:Localize>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtPassword1" runat="server" Width="362px" TextMode="Password" CssClass="form-control" 
                                        meta:resourcekey="txtPassword1Resource1"></asp:TextBox><br />
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Password is required"
                                        ControlToValidate="txtPassword1" ValidationGroup="RPWD" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top">
                                    <asp:Localize meta:resourcekey="asp_string3" runat="server" 
                                        Text="Confirm Password:"></asp:Localize>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtPassword2" runat="server" Width="362px" TextMode="Password" CssClass="form-control" 
                                        meta:resourcekey="txtPassword2Resource1"></asp:TextBox><br />
                                    <asp:CompareValidator ID="CompareValidator1" runat="server" ErrorMessage="Passwords are not identical"
                                        ControlToCompare="txtPassword1" ValidationGroup="RPWD" ControlToValidate="txtPassword2"
                                        CssClass="errmsg" meta:resourcekey="CompareValidator1Resource1"></asp:CompareValidator>
                                </td>
                            </tr>
                            
                            <tr>
                                <td colspan="2">
                                    <asp:CheckBox ID="MustResetPwd"  runat="server" 
                                        Text="User must change password at next logon" meta:resourcekey="MustResetPwdResource1"
                                                     />
                                </td>
                            </tr>
                            
                            
                        </table>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 50px; text-align: right; padding-right: 64px;"
            align="right">
            <tr>
               
                <td  align="right" style="padding-right: 10px;">
                    <asp:Button ID="btnSubmit" runat="server" Text="Submit" OnClientClick="BeforeSubmit();" CssClass="btn btn-primary"
                        CausesValidation="False" OnClick="btnSubmit_Click" Width="128px" meta:resourcekey="btnSubmitResource1" />
                    <asp:Button ID="CancelChange" runat="server" Text="Cancel" CssClass="btn btn-default"
                        OnClientClick="CloseWin();return false;" Width="128px" meta:resourcekey="CancelChangeResource1" />
                </td>
            </tr>
        </table>
    </div>
    <asp:HiddenField ID="GoToFildBrowser" runat="server" />
</asp:Content>
