﻿<%@ Page Title="Gladinet Cloud - Worker Nodes" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="WorkerNodesMgr.aspx.cs" Inherits="GladinetPayFlow.WorkerNodesMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">

        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .actioncol{
        margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        /*<<<<<LOCALIZE GRID CONTROLS*/
        .x-component.x-hmenu-sort-asc .x-menu-item-text {
            display: none;
        }
        .x-component.x-hmenu-sort-desc .x-menu-item-text {
            display: none;
        }
        .x-component.x-cols-icon .x-menu-item-text {
            display: none;
        }
        .x-component.x-hmenu-sort-asc:after {
            content: "<%=LocSrtAsc.Text%>";
        }
        .x-component.x-hmenu-sort-desc:after {
            content: "<%=LocSrtDsc.Text%>";
        }
        .x-component.x-cols-icon:after {
            content: "<%=LocCol.Text%>";
        }
        /*>>>>>LOCALIZE GRID CONTROLS*/
        </style>
    <script type="text/javascript">

        function OpenQuickWindow(u, t)
        {
            var e = document.getElementById("ShortTitle");
            e.innerHTML = "&nbsp;&nbsp;";

            e = document.getElementById("ShortWindow");
            e.src = u;
            e = document.getElementById("ShortBody");

            if (document.documentElement.clientHeight < 750)
                e.style.height = "500px";
            else
                e.style.height = "600px";

            

            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }
        function CloseQuickWindow(u, t)
        {
            try{
                var e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

            }catch(ee){

            }
            try{
                $('#ShortWindowModal').modal('hide');
                
            }catch(e){

            }

        }
        function closeCancelActiveWin()
        {
            CloseQuickWindow();
        }

       

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');

            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;


        }        
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
       // parent.setActivePanel("PubMgr");

        function Unpublish( name) {
            var h = "StorageMgr.aspx?op=delete&id=" + gEncodeUri(name);
            if (confirm("<asp:Localize meta:resourcekey="js_cfmDel1" runat="server">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?"))
                window.location = h;
        }


        
       
        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {
            

            window.location = "/management/WorkerNodesMgr.aspx";
            
        }

       

       
        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }



        function EditWorkerNode(name) {
            var uri = 'WorkerNode.aspx?f=' + gEncodeUri(name);

            OpenQuickWindow(uri, "<asp:Localize meta:resourcekey="js_string1" runat="server">Edit Worker Node</asp:Localize>");
        }

        function DeleteWorkerNode(name) {
            if (!confirm("<asp:Localize meta:resourcekey="js_string2" runat="server">Do you really want to delete: </asp:Localize>" + name + "?"))
            return;
            var h = "WorkerNodesMgr.aspx?op=delete&id=" + gEncodeUri(name);
            window.location = h;
        }
        

        function EditCloudMonitor(name) {
            var uri = "CloudMonitor.aspx?f=" + gEncodeUri(name);
            OpenQuickWindow(uri, "<asp:Localize meta:resourcekey="str_edtCldMonStg" runat="server">Edit Cloud Monitor Settings</asp:Localize>");
        }

        function AddNewWorkerNode() {
            
            var uri = "WorkerNode.aspx";
            OpenQuickWindow(uri, "<asp:Localize meta:resourcekey="js_string3" runat="server">Add New Worker Node</asp:Localize>");
        }
        
        function ReturnLast() {
          <% if (GetLastSubPage(PageReturnUrl) != "") { %>
             parent.window.location = "<%=GetLastSubPage(PageReturnUrl) %>";
          <% } else { %>
            window.location = "<%=PageReturnUrl %>";
          <% } %>
    }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
  <asp:Localize runat="server" ID="LocScnNTnt" meta:resourcekey="str_scnNTnt" Visible="false">Scanning: $1 of $2 Tenant(s);</asp:Localize>
  <asp:Localize runat="server" ID="LocIdl" meta:resourcekey="str_idl" Visible="false">Idle</asp:Localize>
  <asp:Localize runat="server" ID="LocIdlLstCptTme" meta:resourcekey="str_idlLstCptTme" Visible="false">Idle, Last Completed Time:</asp:Localize>
  <asp:Localize runat="server" ID="LocSrtAsc" meta:resourcekey="str_srtAsc" Visible="false">Sort Ascending</asp:Localize>
  <asp:Localize runat="server" ID="LocSrtDsc" meta:resourcekey="str_srtDsc" Visible="false">Sort Descending</asp:Localize>
  <asp:Localize runat="server" ID="LocCol" meta:resourcekey="str_col" Visible="false">Columns</asp:Localize>

  <div class="meubardrop navbar navbar-default " role="navigation" style=" border-bottom: 1px solid #c0c0c0; box-shadow: 0px 3px 3px white !important">
   
          
          <div class="container-fluid">
              <table width="100%">
                  <tr>
                      <td valign="middle">
                          <table>
                              <tr>
                                    <td>
                            <button type="button" class="btn btn-primary navbar-right smallbtn gladbtn" data-toggle="modal" data-target="#myModal" title="<%=AdvancedSettings.Text %>"><span class="fa fa-cog" aria-hidden="true" style="font-size: 14px;">
                                                                            </span>
                                                                        <asp:Localize meta:resourcekey="str_advanced" ID="AdvancedSettings" runat="server" Visible="False">Advanced Settings</asp:Localize>
                                                                            </button>
                      </td>
                      <td>
                            <div  class="btn btn-primary navbar-btn navbar-right gladbtn" style="margin-right:16px;" onclick="AddNewWorkerNode();return false;" title="<%=AttachLocalStorageLbl.Text %>">  
                <span class="fa fa-plus" aria-hidden="true"></span>
               <asp:Label ID="AttachLocalStorageLbl" runat="server" visible="false"
                                 OnClientClick="AddNewWorkerNode();return false;" 
                                meta:resourcekey="AttachLocalStorageResource1" Text="Add New Worker Node"
                            ></asp:Label></div>
                      </td>
                              </tr>
                          </table>
                      </td>
                    
                      <td valign="middle">
                           <p class="navbar-text">
                  <asp:Label ID="PubFolderCount" runat="server" 
                                meta:resourcekey="PubFolderCountResource1" CssClass="badge hollowbadge"></asp:Label>
            </p>
                      </td>
                      <td valign="middle">
                          <div id="errmsgdiv" class="navbar-text">
                                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                                    meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
                      </td>
                      <td align="right" valign="middle">
      <% if (!IsChildUi){ %>
           <div class="navbar-right sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer;" onclick="ReturnLast();">&times;</div>
                  
                                                                    
                  <% } %>

                      </td>
                  </tr>
              </table>
              </div>
          
            
        
     
  
         
         </div>

    <table id="grid-table" width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="background-color: white; margin-top: 22px;<% if (IsChildUi){ %>margin-top: 13px;<% } %>">
        <tr>
            <td colspan="5" style="padding-top: 3px" align="right">
                
                            <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right:8px; color:#808080; display:none;">  
               
                   <asp:LinkButton ID="AllPubs" runat="server" 
                                onclick="AllPubs_Click"  
                            ><span class="fa fa-refresh" aria-hidden="true" style="color:#808080;"></span></asp:LinkButton>
                            </div>
            </td>
        </tr>
        <tr><td colspan="5" style="padding: 3px 0px 20px 40px">
            <span style="font-weight:100; color:#808080">Database: <asp:Literal ID="ltlDBInfo" runat="server" /> - Log Database: <asp:Literal ID="ltlLogDBInfo" runat="server" /></span>
            </td>
        </tr>
        <tr>
            <td colspan="5" style="padding-top: 3px" id="grid-example">
            </td>
        </tr>
    </table>
    <div id="ShortWindowModal" class="modal fade" role="dialog" >
            <div class="modal-dialog  " style="max-width:850px!important; width: 850px!important; padding:0px!important;">

                <!-- Modal content-->
                <div class="modal-content" style="padding:0px!important;">
                    <div class="modal-header" >
                        
                        <button type="button" class="close" onclick="CloseQuickWindow();">&times;</button>
                        <h4 class="modal-title" style="color: #808080; " id="ShortTitle"></h4>
                    </div>
                    <div class="modal-body" style="height: 600px;padding-top:0px;padding:0px!important;" id="ShortBody">
                         <iframe id='ShortWindow' width="100%"  style="padding:0px;" src="/portal/WaitWin.htm"
        frameborder="0" border="0" height="100%"></iframe>
                    </div>
                </div>

            </div>
        </div>
    
                
     <div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content" style="width:800px;">
      <div class="modal-header">
                  <h4 class="modal-title">
<asp:Localize id="LocAdvStg" meta:resourcekey="str_advStg" runat="server">Advanced Settings</asp:Localize></h4>

        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
      <table id="farm-setting" width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="background-color: white; padding: 2px;">
        <tr>
            <td colspan="5" style="padding-top: 3px; background-color:white">
                <asp:CheckBox ID="ForceSSL" runat="server" Text="Always force SSL on Login" AutoPostBack="True" OnCheckedChanged="ForceSSL_CheckedChanged"
                    meta:resourcekey="ForceSSLResource1" />
            </td>
        </tr>
        <tr>
            <td colspan="5" style="padding-top: 3px; background-color: white;">
                <asp:CheckBox ID="ForceClientSSL" runat="server" Text="Always force SSL for Native Clients" AutoPostBack="True" OnCheckedChanged="ForceClientSSL_CheckedChanged"
                    meta:resourcekey="ForceClientSSLResource1" />
            </td>
        </tr>
          <tr>
            <td colspan="5" style="padding-top: 3px; background-color: white;">
                <asp:CheckBox ID="NoIncomeDNS" runat="server" Text="Do not follow incoming request DNS" AutoPostBack="True" OnCheckedChanged="NoIncomeDNS_CheckedChanged"
                    meta:resourcekey="NoIncomeDNSResource1" />
            </td>
        </tr>
        <asp:Panel ID="LBPanel" runat="server" meta:resourcekey="LBPanelResource2">
            <tr>
                <td colspan="5" style="padding-top: 3px; background-color: white;">
                    <asp:CheckBox ID="DisableDefaultLB" runat="server" AutoPostBack="True" Text="Disable worker-node load balancing."
                        OnCheckedChanged="DisableDefaultLB_CheckedChanged" meta:resourcekey="DisableDefaultLBResource2" />
                    <p style="color:#808080; font-weight:100;">
                    <asp:Localize  meta:resourcekey="DisableDefaultLBResource1" runat="server" Text="You may have already taken care of the load balancing at a different level (such as the DNS level), so you don't need worker-node load balancing anymore. All the user interactions will stay at the same incoming worker-node."></asp:Localize>
                        </p>
                </td>
            </tr>
            <tr>
                <td colspan="5" style="padding-top: 3px; background-color: white; padding-left: 32px;">
                    <asp:Panel ID="LBModePanel" runat="server" meta:resourcekey="LBModePanelResource1">
                        <asp:RadioButton ID="RadioButton1" Checked="True" runat="server" Text="Per-tenant loadbalance" GroupName="LB" AutoPostBack="True"
                            OnCheckedChanged="RadioButton1_CheckedChanged" meta:resourcekey="RadioButton1Resource1" />:
                        <p style="color:#808080; font-weight:100;">
                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string3" runat="server" Text="Always load balance all users belonging to the same tenant to the same node. This works best if you have many tenants."></asp:Localize></p><br />
                        <asp:RadioButton ID="RadioButton2" runat="server" Text="Per-user loadbalance" GroupName="LB" AutoPostBack="True" OnCheckedChanged="RadioButton2_CheckedChanged"
                            meta:resourcekey="RadioButton2Resource1" />:
                        <p style="color:#808080; font-weight:100;">
                        <asp:Localize ID="Localize2" meta:resourcekey="asp_string4" runat="server" Text="Load balance users to different nodes regardless whether they belong to the same tenant or not. This works best if you few large tenants."></asp:Localize>
                            </p>
                    </asp:Panel>
                </td>
            </tr>
        </asp:Panel>
    </table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
      </div>
    </div>

  </div>
  </div>
    <input type="hidden" id="current_share" name="current_share" />
    <div style="display: none;">
    <asp:Button ID="ApplyLocalizedStrings" runat="server" Text="Button" 
         onclick="ApplyLocalizedStrings_Click" />
         </div>
<script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "NodeName")%>','<%#DataBinder.Eval(Container.DataItem, "DisableMMC")%>','<%#DataBinder.Eval(Container.DataItem, "Version")%>',
       '<%#DataBinder.Eval(Container.DataItem, "ScanStatus")%>']
        </ItemTemplate>
    </asp:Repeater>      
    ];
    try{
        //localize myData statuses
        myData.map(function(aRow){
            var statusValue = "Idle"; //aRow[4];
            if(statusValue.indexOf("Scanning:")>-1)
            {
                aRow[4] = statusValue.replace(/Scanning:([0-9]+) of ([0-9]+) Tenant\(s\);/i,"<%=LocScnNTnt.Text%>");
            }
            else if(statusValue.indexOf("Idle")>-1)
            {
                aRow[4] = statusValue.replace("Idle","<%=LocIdl.Text%>");
            }
            else if(statusValue.indexOf("Idle, Last Completed Time:")>-1)
            {
                aRow[4] = statusValue.replace("Idle, Last Completed Time:","<%=LocIdlLstCptTme.Text%>");
            }
        });
    }catch(ex){
        console.log("myData.map:",ex);
    }
    </script>
  <script type="text/javascript">
      var grid;
      function AdjustGridTable() {
          isMobileBrowserOrNarrow();
          var h = 400;

          try {

              var myTable = Ext.get('grid-table');
              var tableY = myTable.getY();

              var mySetting = Ext.get('farm-setting');
              var settingH = mySetting.getHeight();

              h = document.body.offsetHeight - tableY - 6 - settingH;
              //var ee = document.getElementById('tinfo');
              //ee.style.height = h + "px";
              if (h < 108) {
                  h = 108;
              }

          } catch (err) {
          }
          grid.setWidth(document.documentElement.clientWidth - 4);
          grid.setHeight(h-200  );
          grid.doComponentLayout();
      }

      Ext.require([
    'Ext.grid.*',
    'Ext.data.*',
    'Ext.util.*',
    'Ext.state.*'
]);
      Ext.onReady(function () {

          Ext.QuickTips.init();


          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
            { name: 'index' },
           { name: 'nodename' },
           { name: 'nommc' },
           { name: 'ver' },
           { name: 'status' }
        ],
              data: myData
          });


          var d = document.getElementById("grid-example");
          var h = 400;

          /*try {
              h = d.offsetHeight - 10;  // in IE8, this is very narrow like = 1
              h1 = document.body.offsetHeight;
              if (h1 > 300) {
                  h1 = h1 - 36; // paddings , margins, whatever
              }
              if (h < 50) {
                  // this shall only happen for IE8
                  gridY = Ext.get("grid-example").getY();
                  h = h1 - gridY;
                  if (h < 218) {
                      h = 218;
                  }
              }
          } catch (err) {
          }*/

          grid = Ext.create('Ext.grid.Panel', {
              store: store,
              border: 1,
              stripeRows: true,
              columnLines: false,
              minHeight: 108,
              height: h-100,
              columns: [
            {
                text: '',
                width: 50,
                sortable: false,
                dataIndex: 'index',
                getClass: function (v, meta, rec) {
                    return 'x-col-hdide';
                }
            },
            {
                text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="str_ndeNme" runat="server">Node Name</asp:Localize></span>",
                flex: 1,
                sortable: true,
                dataIndex: 'nodename',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<span style='font-weight:100; color:#808080'>" + value + "</span>";
                }

            },
            {
                text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="str_vrs" runat="server">Version</asp:Localize></span>",
                flex: 1,
                sortable: true,
                dataIndex: 'ver',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<span style='font-weight:100; color:#808080'>" + value + "</span>";
                }

            },
            {
                text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="str_sts" runat="server">Status</asp:Localize></span>",
                flex: 1,
                sortable: true,
                dataIndex: 'status',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<span style='font-weight:100; color:#808080'>" + value + "</span>";
                }

            },
            {
      text: "<span style='font-weight:100; color:#565656'><asp:Localize meta:resourcekey="str_mgtUI" runat="server">Management UI</asp:Localize></span>",
                flex: 1,
                sortable: true,
                dataIndex: 'nommc',
                renderer: function (value, metaData, record, rowIndex) {
                    if( value == "True" )
                        return "<span style='font-weight:100; color:#808080'><asp:Localize meta:resourcekey="str_no" runat="server">No</asp:Localize></span>";
                        return "<span style='font-weight:100; color:#808080'><asp:Localize meta:resourcekey="str_yes" runat="server">Yes</asp:Localize></span>";
                }

                }, {


                sortable: false,
                width:150,
                renderer: function (value, metaData, record, rowIndex) {
                                
                    var rec = grid.getStore().getAt(rowIndex);
                    var d = rec.data;
                    var ndeNme = d.nodename;
                    var editBtn = "", settingsBtn = "", syncBtn = "", unpublishBtn = "";
                    var editTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize>\"";
                    var settingsTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_edtCms" runat="server">Edit Cloud Monitor Settings</asp:Localize>\"";
                    var syncTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_apyLocChg" runat="server">Apply localization change</asp:Localize>\"";
                    var unpublishTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_ups" runat="server">Unpublish</asp:Localize>\"";
                    
                    editBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"EditWorkerNode('"+ndeNme+"')\" "+editTTip+">/</i>";
                    settingsBtn = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"EditCloudMonitor('"+ndeNme+"')\" "+settingsTTip+">g</i>";
                    syncBtn = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"if(confirm(&quot;<asp:Localize meta:resourcekey="str_cfmApyChg" runat="server">It may take a long time to apply the changes. Continue?</asp:Localize>&quot;)) {Wait(&quot;<asp:Localize meta:resourcekey="str_apy" runat="server">Applying...</asp:Localize>&quot;);document.getElementById('ctl00_MainContent_ApplyLocalizedStrings').click();}\" "+syncTTip+">µ</i>";
                    unpublishTTip = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"DeleteWorkerNode('"+ndeNme+"')\" "+unpublishTTip+">n</i></div>";
                    
                    return editBtn+settingsBtn+syncBtn+unpublishTTip;
                }


                
            }
        ],
              renderTo: 'grid-example'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      <%if(m_ShowSettings){%>
      $('#myModal').modal({ backdrop: 'static', keyboard: false });
      <%}%>
      });
  </script>
</asp:Content>
