﻿<%@ Page Title="Gladinet Cloud - Web Nodes" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="WebNodesMgr.aspx.cs" Inherits="GladinetPayFlow.WebNodesMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .actioncol{
        margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        </style>
    <script type="text/javascript">



        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');

            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;


        }        
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");

        function Unpublish( name) {
            var h = "StorageMgr.aspx?op=delete&id=" + gEncodeUri(name);

            if (confirm("<asp:Localize meta:resourcekey="js_string4" runat="server">Confirm you want to delete (</asp:Localize>" + unescape(name) + ")?"))
                window.location = h;
        }


        
       
        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = "/management/WebNodesMgr.aspx";
            
        }

        function closeCancelActiveWin() {
            ActiveWin.close();
            
        }

       
        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }


        function OpenHtmlWindow(id, title, Html) {

            ActiveWin = new Ext.Window({
                id: id,
                title: title,
                width: 560,
                height: 485,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                constrain: true,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:white;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();

        }

        function EditWorkerNode(name) {
            var uri = "<iframe id='edit_node' src='WebNode.aspx?f=" + gEncodeUri(name) + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";

            OpenHtmlWindow("edit_node", "<asp:Localize meta:resourcekey="js_string1" runat="server">Edit Web Node</asp:Localize>", uri);
        }

        function DeleteWorkerNode(name) {
            if (!confirm("<asp:Localize meta:resourcekey="js_string2" runat="server">Do you really want to delete:</asp:Localize> " + name + "?"))
            return;
            var h = "WebNodesMgr.aspx?op=delete&id=" + gEncodeUri(name);
            window.location = h;
        }
        function OpenHtmlWindowShort(id, title, Html, w, h) {

            ActiveWin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: h,
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();

        }
        function AddNewWorkerNode() {
            
            var uri = "<iframe id='add_local' src='WebNode.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0; border:0'></iframe>";
            OpenHtmlWindow("add_node", "<asp:Localize meta:resourcekey="js_string3" runat="server">Add New Web Node</asp:Localize>", uri);
        }


    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default " role="navigation" style="box-shadow:0px 0px 0px white;">
        <div class="container-fluid" style="background-color: white;">
            <p class="navbar-text">
                <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge"></asp:Label>
            </p>
            <div id="errmsgdiv" class="navbar-text">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
            <div class="navbar-right">
            <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;" title="<%=AllPubs.Text %>">
                <span class="fa fa-refresh" aria-hidden="true"></span>
                <asp:LinkButton ID="AllPubs" runat="server" OnClick="AllPubs_Click" meta:resourcekey="AllPubsResource1" visible="false">Refresh</asp:LinkButton>
            </div>
            <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 16px;" onclick="AddNewWorkerNode();return false;" title="<%=AttachLocalStorageLbl.Text %>">
                <span class="fa fa-plus" aria-hidden="true"></span>
                <asp:Label ID="AttachLocalStorageLbl" runat="server" OnClientClick="AddNewWorkerNode();return false;" Visible="false" meta:resourcekey="AttachLocalStorageResource1">Add New Web Node</asp:Label>
            </div>
                </div>
        </div>
    </nav>
  
    <table id="grid-table" width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="padding: 2px; background-color: white;margin-top: 13px;">
        <tr>
            <td colspan="5" style="padding-top: 1px; padding-bottom: 6px;" id="grid-example"></td>
        </tr>
    </table>
    <table id="farm-setting" width="100%" align="center" border="0" cellspacing="0" cellpadding="0" style="padding: 2px; background-color: white;">
        <tr>
            <td colspan="5" class='idea_flex' style="height: 40px; padding-top: 3px; vertical-align: middle;">
                <asp:Localize meta:resourcekey="asp_string1" runat="server">If a node is already registered as a worker node, do NOT add it again as a web node. 
                                When you have a single-server-all-in-one deployment, add the node as worker node, instead of a web node. 
                                Only register dedicated web node here in a multi-node deployment.</asp:Localize>
            </td>
        </tr>
    </table>
    <input type="hidden" id="current_share" name="current_share" />

<script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     ['<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#DataBinder.Eval(Container.DataItem, "NodeName")%>','<%#DataBinder.Eval(Container.DataItem, "Version")%>']
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">
      var grid;
      function AdjustGridTable() {
          isMobileBrowserOrNarrow();
          var h = 400;

          try {

              var myTable = Ext.get('grid-table');
              var tableY = myTable.getY();

              var mySetting = Ext.get('farm-setting');
              var settingH = mySetting.getHeight();

              h = document.body.offsetHeight - tableY - 8 - settingH;
              //var ee = document.getElementById('tinfo');
              //ee.style.height = h + "px";
              if (h < 108) {
                  h = 108;
              }

          } catch (err) {
          }
          grid.setWidth(document.documentElement.clientWidth - 4);
          grid.setHeight(h);
          grid.doComponentLayout();
      }

      Ext.require([
    'Ext.grid.*',
    'Ext.data.*',
    'Ext.util.*',
    'Ext.state.*'
]);
      Ext.onReady(function () {

          Ext.QuickTips.init();


          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
            { name: 'index' },
           { name: 'nodename' },
           { name: 'ver' },
        ],
              data: myData
          });

          var d = document.getElementById("grid-example");
          var h = 400;

         /* try {
              h = d.offsetHeight - 10;  // in IE8, this is very narrow like = 1
              h1 = document.body.offsetHeight;
              if (h1 > 300) {
                  h1 = h1 - 36; // paddings , margins, whatever
              }
              if (h < 50) {
                  // this shall only happen for IE8
                  gridY = Ext.get("grid-example").getY();
                  h = h1 - gridY;
                  if (h < 218) {
                      h = 218;
                  }
              }
          } catch (err) {
          }*/

          grid = Ext.create('Ext.grid.Panel', {              
              store: store,
              border:1,
              stripeRows: true,
              columnLines: true,
              minHeight: 108,
              height: h-40,
              columns: [
            {
                text: '',
                width: 50,
                sortable: false,
                dataIndex: 'index',
                getClass: function (v, meta, rec) {
                    return 'x-col-hdide';
                }
            },
            {
                text: "<asp:Localize meta:resourcekey="str_ndeNme" runat="server">Node Name</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'nodename',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<b>" + value + "</b>";
                }

            }, {
                text: "<asp:Localize meta:resourcekey="str_vsn" runat="server">Version</asp:Localize>",
                flex: 1,
                sortable: true,
                dataIndex: 'ver',
                renderer: function (value, metaData, record, rowIndex) {
                    return "<b>" + value + "</b>";
                }

            }, {
                sortable: false,
                width:100,
                renderer: function (value, metaData, record, rowIndex) {
                                
                    var rec = grid.getStore().getAt(rowIndex);
                    var d = rec.data;
                    var ndeNme = d.nodename;
                    var editBtn = "", unpublishBtn = "";
                    var editTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_edt" runat="server">Edit</asp:Localize>\"";
                    
                    var unpublishTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_uph" runat="server">Unpublish</asp:Localize>\"";
                    
                    editBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"EditWorkerNode('"+ndeNme+"')\" "+editTTip+">/</i>";
                    unpublishTTip = "<i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"DeleteWorkerNode('"+ndeNme+"')\" "+unpublishTTip+">n</i></div>";
                    
                    return editBtn+unpublishTTip;
                }
            }
        ],
              renderTo: 'grid-example'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      });
  </script>
</asp:Content>
