﻿<%@ Page Title="User Storage Distribution" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="UserStorageStat.aspx.cs" Inherits="GladinetPayFlow.UserStorageStat"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<%@ Register Assembly="System.Web.DataVisualization, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.UI.DataVisualization.Charting" TagPrefix="asp" %>
<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .style1
        {
            width: 153px;
        }
        
        .newusericon
        {
            background-image: url(images/upgradeuser.png);
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);




        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("sw") == -1)
                window.location.href = window.location.href + "?sw=" + (e.offsetWidth - 60) + "&sh=" + (e.offsetHeight - 70);
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }

        function ConfirmSync() {
            if (confirm("<asp:Localize meta:resourcekey="str_confirme1" runat="server">It may take a long time to process for accounts that have significant storage usage , continue?</asp:Localize>")) {
                

            Wait("<asp:Localize meta:resourcekey="str_scan1" runat="server">Scanning...</asp:Localize>");
            return true;
        }

        return false;

        }

        function ConfirmOldPurge() {
            if (confirm("<asp:Localize meta:resourcekey="str_confirm2" runat="server">Please confirm you want to purge old versions and only keep the most recent copy of each file. The time it takes may vary based on storage consumption.</asp:Localize>")) {


                Wait("<asp:Localize meta:resourcekey="str_purging" runat="server">Purging...</asp:Localize>");
                return true;
            }

            return false;

        }
        function ConfirmPurge() {
            if (confirm("<asp:Localize meta:resourcekey="str_delconfirm" runat="server">Do you really want to purge the deleted files, It may take a long time to process for accounts that have significant storage usage , continue?</asp:Localize>")) {


                Wait("<asp:Localize meta:resourcekey="str_purging" runat="server">Purging...</asp:Localize>");
            return true;
        }

        return false;

        }

        function ConfirmPurgeChunk() {
            if (confirm("<asp:Localize meta:resourcekey="str_confirm3" runat="server">Do you really want to purge the chunks that are created when upload large file in chunk mode, It may take a long time to process for accounts that have significant storage usage , continue?</asp:Localize>")) {


                Wait("<asp:Localize meta:resourcekey="str_purging" runat="server">Purging...</asp:Localize>");
                return true;
            }

            return false;

        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize id="LocUsd" meta:resourcekey="str_used" runat="server" Visible="false">used</asp:Localize>
<asp:Localize id="LocScnWasScs" meta:resourcekey="str_scnWasScs" runat="server" Visible="false">Scan was successful</asp:Localize>
<asp:Localize ID="LocOf" meta:resourcekey="str_of" runat="server" Visible="false">of</asp:Localize>

    <%if(!NoStatsPanel.Visible) { %>
    <div id="ImgContainer" style="padding: 0px; background-color: white;">
        <table width="100%" style="background-color: white">
            <tr>
                <td  style="color:#565656; border-bottom: 0px solid #c0c0c0; padding: 0px; font-size: 18px; font-weight: 100;" align="left" colspan="2">
                    <div style="padding: 10px;width: 100%; border-bottom: 1px solid #c0c0c0; font-size: 18px; font-weight: 100;<% if (!IsChildUi){ %>box-shadow: 0px 3px 3px #cccccc !important<% } %>">
                    <asp:Localize meta:resourcekey="str_usd" runat="server" 
                        Text="User Storage Distribution"></asp:Localize>
                <asp:Label ID="StorageQuota" runat="server" meta:resourcekey="UserCountResource1" CssClass="badge hollowbadge"></asp:Label>
                        <asp:Localize meta:resourcekey="str_storageq" ID="str_storageq" runat="server" Visible="False">Storage Quota (GB):</asp:Localize>
                        <asp:Localize meta:resourcekey="str_unlimited" ID="str_unlimited" runat="server" Visible="False">Unlimited</asp:Localize>
                        </div>
                </td>
            </tr>
            <tr>
                
                <td style="padding-top: 5px;padding: 10px;">
                    <table width="100%">
                        <asp:Repeater ID="FileSizeRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px;">
                                    <td style="border-bottom: 1px solid #e0e0e0; color: #565656; font-weight: 100;">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                    </td>
                                    <td style="border-bottom: 1px solid #e0e0e0; color: #565656; font-weight: 100;">
                                        <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                    </td>
                                    
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
                </td>
                <td style="padding-top: 5px;width:200px;">
                    <asp:Chart ID="SizeChart" runat="server" BorderlineColor="Red" Height="205px" Width="200px"
                        BorderDashStyle="Solid" BackSecondaryColor="White" 
                        BorderWidth="0px" BackColor="255, 255, 255" BorderColor="#1A3B69" 
                        meta:resourcekey="SizeChartResource1">
                        <Series>
                            <asp:Series ChartType="Pie" Name="Series1" BorderColor="180, 26, 59, 105">
                            </asp:Series>
                        </Series>
                        <ChartAreas>
                            <asp:ChartArea Name="ChartArea1" BorderColor="white" BorderDashStyle="Solid"
                                BackSecondaryColor="White" BackColor="White" ShadowColor="Transparent"
                                BackGradientStyle="TopBottom">
                                <Area3DStyle Rotation="10" Perspective="10" Inclination="15" IsRightAngleAxes="False"
                                    WallWidth="0" IsClustered="False"></Area3DStyle>
                                <AxisY LineColor="64, 64, 64, 64">
                                    <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                    <MajorGrid LineColor="64, 64, 64, 64" />
                                </AxisY>
                                <AxisX LineColor="64, 64, 64, 64">
                                    <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                    <MajorGrid LineColor="64, 64, 64, 64" />
                                </AxisX>
                            </asp:ChartArea>
                        </ChartAreas>
                    </asp:Chart>
                </td>
            </tr>
            <tr>
            <td colspan=2>
                                                    <div id="errmsgdiv">
                                                        <b>
                                                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                                    </div>
                <asp:Localize meta:resourcekey="str_rfile" ID="Str_Rfile" runat="server" Visible="False">Non-Versioned Files</asp:Localize>
                <asp:Localize meta:resourcekey="str_hv" ID="Str_HV" runat="server" Visible="False">Current Versions</asp:Localize>
                <asp:Localize meta:resourcekey="str_oldv" ID="Str_OV" runat="server" Visible="False">Previous Versions</asp:Localize>
                <asp:Localize meta:resourcekey="str_trash" ID="Str_Trash" runat="server" Visible="False">Trash Can</asp:Localize>
                <asp:Localize meta:resourcekey="str_delv" ID="Str_DelV" runat="server" Visible="False">Files Marked for Deletion</asp:Localize>
                <asp:Localize meta:resourcekey="str_succ" ID="Str_Succ" runat="server" Visible="False">Scan was successful</asp:Localize>     
                <asp:Localize meta:resourcekey="cs_lgeFilCnk" ID="Str_LgeFilCnk" runat="server" Visible="False">Large File Chunks (for efficient, reliable transmission)</asp:Localize>
                <asp:CheckBox ID="DomainLevel" Visible="False" runat="server" />
            </td>
            </tr>
            <tr>
            <td colspan=2 align=right style="padding-top:20px; padding-right:10px; border-top:0px solid #f0f0f0;">
                <div style="position:absolute; bottom:20px; right:10px">
                <asp:LinkButton ID="ForceRefresh" runat="server" onclick="ForceRefresh_Click" 
                    OnClientClick="return ConfirmSync();"  CssClass="btn btn-primary gladbtn btn-small"
                    ><asp:Localize meta:resourcekey="force_refresh_r" runat="server">Force Refresh</asp:Localize></asp:LinkButton>
                <% if (m_CanEdit)
                   { %>
                   &nbsp;&nbsp;&nbsp;<asp:LinkButton ID="LinkButton3" runat="server" CssClass="btn btn-primary gladbtn"
                    onclick="PurgeOldVer_Click" OnClientClick="return ConfirmOldPurge();"  
                    ><asp:Localize meta:resourcekey="purge_old_ver_r" runat="server">Purge Old Version</asp:Localize></asp:LinkButton>
                &nbsp;&nbsp;&nbsp;<asp:LinkButton ID="LinkButton1" runat="server" CssClass="btn btn-primary gladbtn"
                    onclick="PurgeTrashCan_Click" OnClientClick="return ConfirmPurge();" 
                    ><asp:Localize meta:resourcekey="purge_trash_r" runat="server">Purge Trash Can</asp:Localize></asp:LinkButton>&nbsp;&nbsp;&nbsp;<asp:LinkButton 
                    ID="LinkButton2" runat="server"  OnClientClick="return ConfirmPurgeChunk();" 
                    onclick="LinkButton2_Click" CssClass="btn btn-primary gladbtn"
                    Text="Purge File Chunks"></asp:LinkButton>
                    <% } %>
                    </div>
            </td>
            </tr>
        </table>
    </div>
    <%}%>
<asp:Panel runat="server" ID="NoStatsPanel" Visible="false">
    <table style="width:100%;">
        <tr>
            <td align="center" style="padding-top:60px;">
                <div style="font-size:18px; color:#404040; font-weight:100; padding:10px;"><asp:Localize meta:resourcekey="str_theIsNoStoStaInf" runat="server">There is no storage statistics info.</asp:Localize></div>
    <asp:LinkButton ID="LinkButton4" runat="server" onclick="ForceRefresh_Click" 
                    OnClientClick="return ConfirmSync();"  CssClass="btn btn-primary gladbtn btn-small"
                    ><asp:Localize meta:resourcekey="force_refresh_r" runat="server">Force Refresh</asp:Localize></asp:LinkButton>
            </td>
        </tr>
    </table>
    
</asp:Panel>
    <asp:HiddenField ID="UserGuid" runat="server" />
    <div style="display:none"></div>
    <%if (!this.IsPostBack)
      {%>
    <script language="javascript" type="text/javascript">
        var rowURL = window.location.href;
        var e = document.getElementById("ImgContainer");

    </script>
    <%}%>
</asp:Content>
