﻿<%@ Page Title="Gladinet Cloud - Published Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="UserShareMgrPage.aspx.cs" Inherits="GladinetPayFlow.UserShareMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .actiontbl{
        display: table;
        }
        .actioncol{
        display: table-cell;margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        
        
        .securityicon
        {
            background-image: url(images/security2.png);
        }
        .groupicon
        {
            background-image: url(images/group.png);
        }
        

    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("PubMgr");




        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }



        var ActiveWin;
        function OnEdit(ShareId, isDir) {
            var uri = "<iframe id='openwin' src=\"/management/editsharepage.aspx?isfld=";
            uri += isDir;
            uri += "&path=/";
            uri += encodeURIComponent(ShareId.replace("%27", "'"));
            uri += "&email=" + encodeURIComponent("<%=UserEmail %>") + "&editmode=1";
            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
            var maxed = false;
            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="str_sendshare" runat="server" visible="false">Create link and send</asp:Localize>",
                width: 820,
                height: 640,
                plain: true,
                modal: true,
                maximizable: true,
                maximized: maxed,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                },
                listeners: {
                    beforeclose: function (win) {
                        try {
                            //try to refresh the page once the popup is closed
                            $("#<%=AllUsers.ClientID%>")[0].click();
                        } catch (ex) { }
                        return true;
                    }
                }
            });
            ActiveWin.show();

        }



        function ViewShare(oid, id) {
            id = gEncodeUri(unescape(id));
            var uri = "<iframe id='openwin' src=\"/management/ViewSharePage.aspx?u=";
            uri += oid;
            uri += "&location=" + id;
            uri += "&vdid=<%=SessionDomainId %>";

            uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            ActiveWin = new Ext.Window({
                id: 'pubs_win',
                title: 'View Share',
                width: 720,
                height: maxh(540),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                bodyPadding: 5,
                resizable: false,
                html: uri,
                defaults: {
                    border: false
                }
            });
            ActiveWin.show();
        }

        function UnpublishUrl(id) {
            id = gEncodeUri(unescape(id));
            var h = "TenantShareMgrPage.aspx?from=usersharepage&op=delpub&id=" + id+"&oid=1&vdid=<%=SessionDomainId %>";
           
            gConfirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Are you sure you want to delete?</asp:Localize>", "", function (btn1) {

                if (btn1 != 'ok')
                    return;
                Wait("<asp:Localize meta:resourcekey="js_string8" runat="server">Deleting...</asp:Localize>");
                window.location = h;
            });
        }

        function Unpublish(oid, id, isDir) {
            //id = gEncodeUri(unescape(id));
            gConfirm("<asp:Localize meta:resourcekey="js_string7" runat="server">Are you sure you want to delete?</asp:Localize>", "", function (btn1) {

                if (btn1 != 'ok')
                    return;

                var uri = "<iframe id='openwin' src=\"/management/editsharepage.aspx?isfld=";
                uri += isDir;
                uri += "&path=/";
                uri += encodeURIComponent(id);
                uri += "&email="+encodeURIComponent("<%=UserEmail %>")+"&oid="+oid+"&deletemode=1";
                uri += "\" scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";
                ActiveWin = new Ext.Window({
                    id: 'pubs_win',
                    title: "",
                    width: 820,
                    height: 640,
                    plain: true,
                    modal: true,
                    maximizable: true,
                    maximized: false,
                    constrainHeader: true,
                    bodyPadding: 5,
                    resizable: false,
                    html: uri,
                    defaults: {
                        border: false
                    },
                    listeners:{
                        beforeclose: function (win) {
                            try {
                                //try to refresh the page once the popup is closed
                                $("#<%=AllUsers.ClientID%>")[0].click();
                            } catch (ex) { }
                        return true;
                    }
                }
                });
                ActiveWin.show();
            });      
        }

        //parent.HelpSrc = "PubMgrHelp.htm";


        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function OnClickTeam() {
            window.location = "/portal/PubMgrPage.aspx";
        }

        function OnClickStorage() {
            window.location = "/management/StorageMgr.aspx";
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
   <nav class="navbar navbar-default " role="navigation">
       <div class="container-fluid">
           <p class="navbar-text">
               <asp:Label ID="PubFolderCount" runat="server" meta:resourcekey="PubFolderCountResource1" CssClass="badge"></asp:Label>
           </p>

           <p class="navbar-text">
               <b>
                   <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
           </p>
           <div class="navbar-form navbar-right">
               <table border="0" style="margin-top: -15px;">
                   <tr>
                      
                       <td>
               <asp:LinkButton ID="AllUsers" runat="server"  CssClass="btn btn-default nbtn"
                    OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1" 
                   Text="Refresh"></asp:LinkButton>               
               <asp:TextBox ID="Contains" runat="server" Width="228px" CssClass="form-control dark" Visible="false" meta:resourcekey="ContainsResource1"></asp:TextBox>
               <asp:Button ID="Serach" runat="server" Text="Search"  OnClick="Serach_Click" CssClass="btn btn-default nbtn" meta:resourcekey="SerachResource1" visible="false"/>
                           
                       </td>
                        <td>
                            <asp:LinkButton ID="ExportShares" runat="server"  Text="Export Shares" CssClass="btn btn-default" Visible="false"
                                            OnClick="ExportShare_Click" 
                    meta:resourcekey="ExportSharesResource1"></asp:LinkButton>      
                       </td>
                   </tr>
               </table>
           </div>
       </div>
    </nav>
    <table width="100%" style="padding: 2px; background-color: white; margin-top: -13px" cellspacing="0" cellpadding="0" id="grid-table">
        <tr style="background-color: #f0f0f0; display: none;">
            <td valign="top" style="height: 32px; padding: 2px; border: 0px solid #c0c0c0; border-bottom: 3px solid #e0e0e0;">
                <table width="96%" cellspacing="0" cellpadding="0" style="height: 32px;">
                    <tr>
                        <td align="left" style="height: 32px">
                        </td>
                        <td>
                            <div id="errmsgdiv">
                            </div>
                        </td>
                        <td align="right">
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding:0px;padding-top: 0px; border-bottom: 0px solid #c0c0c0; border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0;"
                id="grid-example">
            </td>
        </tr>
        <tr>
            <td  style="height: 40px; vertical-align: middle; display: none;">
                <div class='idea_flex'>
                <asp:Localize ID="Localize4" meta:resourcekey="as_string5" runat="server" 
                        Text="Securely send links of files and folders to share with people."></asp:Localize>
                </div>
            </td>
        </tr>
    </table>
    <input type="hidden" id="current_share" name="current_share" />
    <asp:HiddenField ID="UserID" runat="server" />
    <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "PathLocation").ToString().Replace("'","%27")%>',
       '<%#DataBinder.Eval(Container.DataItem,"OwnerEmail") %>',
       '<%#DataBinder.Eval(Container.DataItem, "OwnerUid").ToString().Replace("'","%27")%>', 
       '<%#DataBinder.Eval(Container.DataItem,"IsDir") %>',     
       '<%#DataBinder.Eval(Container.DataItem, "ShareName").ToString().Replace("'","%27")%>' , 
       '<%#DataBinder.Eval(Container.DataItem, "Memo").ToString().Replace("'","%27")%>'
       ]
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
        var grid;
function AdjustGridTable () {
           
        var h = 400;
          
        try {

            var myTable = Ext.get('grid-table');
           
            var tableY = myTable.getY();
           
            h = document.body.offsetHeight-tableY-68;
           
              var ee = document.getElementById('tinfo');
              ee.style.height = h + "px";

          } catch (err) {
          }
              grid.setWidth(document.documentElement.clientWidth - 8);
              grid.setHeight(h);
              grid.doComponentLayout();

          var e = document.getElementById("grid-example");
          e.style.height = h + "px";

      }

        Ext.onReady(function () {

            Ext.QuickTips.init();


            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                  { name: 'index' },
                  { name: 'path' },
                  { name: 'ownername' },
                  { name: 'oid' },
                  { name: 'isdir' },
                  { name: 'sharename' }
              ],
                data: myData
            });

            var d = document.getElementById("grid-example");
            var h = 370;
            //if (d.offsetHeight > h)
            h = d.offsetHeight - 10;

            grid = Ext.create('Ext.grid.Panel', {                
                frame: false,
                border: false,
                store: store,
                stripeRows: true,
                columnLines: false,
                minHeight: 218,
                height: h,
                columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string2" runat="server">Shared Object Path</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'path',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string3" runat="server">Owner Name</asp:Localize>",
                        width: 220,
                        sortable: true,
                        dataIndex: 'ownername',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }

                  }, 
                        
                        
                        
                        
                       {
                            sortable: false,
                            width:120,
                            renderer: function (value, metaData, record, rowIndex) {
                                var rec = grid.getStore().getAt(rowIndex);
                                var d = rec.data;
                                var sid = "<%=SessionUserId %>"
                                var addUsrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string4" runat="server">Edit Share</asp:Localize>\"";
                                var shrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string5" runat="server">View Share</asp:Localize>\""; 
                                var trashTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string6" runat="server">Delete Share</asp:Localize>\""; 
                                //==================================================================
                                var addUsrBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"OnEdit(&quot;"+unescape(d.path)+"&quot;,&quot;"+d.isdir+"&quot;)\" "+addUsrTTip+">&#x10B;</i></div>";
                                if (sid != d.oid) addUsrBtn = "";
                                //==================================================================
                                var shrBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"ViewShare(&quot;"+d.oid+"&quot;,&quot;"+unescape(d.path)+"&quot;)\" "+shrTTip+">k</i></div>";
                                if (sid == d.oid) shrBtn = "";
                                //==================================================================   
                                var trashBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"Unpublish(&quot;"+d.oid+"&quot;,&quot;"+unescape(d.path)+"&quot;,&quot;"+d.isdir+"&quot;)\" "+trashTTip+">n</i></div>";
                              
                                //==================================================================
                                return "<div class=\"actiontbl\">"+addUsrBtn+shrBtn+trashBtn+"</div>";
                            }
                        }



        ],
                renderTo: 'grid-example'
            });
              AdjustGridTable ();
             //Ext.EventManager.onWindowResize(grid.doLayout, grid);
             Ext.EventManager.onWindowResize(AdjustGridTable);

        });
    </script>
</asp:Content>
