﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="UserDeviceMgrPage.aspx.cs" Inherits="GladinetPayFlow.UserDeviceMgrPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

    
    function closeCancelActiveWin()
    {
       activewin.close();
    }

    function closeActiveWin() {
        window.location =  "/management/UserDeviceMgrPage.aspx";
    }

    function OnWipeDevice(id, name) {
        var ng = document.getElementById("ctl00_MainContent_DeviceId");
        var btn = document.getElementById("ctl00_MainContent_WipeDevice");

        if (confirm("Do you really want to wipe the device (" + unescape(name) + ")?")) {
            Wait('wiping...');
            ng.value = id;
            btn.click();            
        }
    }
   
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <table width="99%" height="100%" valign="top" class="checkout3" style="background-color: white; margin-top: 0px; padding-bottom: 48px;"
        align="center">
        <tr>
            <td style="vertical-align:top;">
                <table width="96%" align="center" valign="top">
                    <tr>
                        <td height="2px">
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <table width="90%" align="center" border="0" cellspacing="0" cellpadding="0">
                                <tr>
                                    <td>
                                        <div id="errmsgdiv">
                                            <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <table width="96%" align="center">
                    <tr>
                        <td colspan="3" valign="bottom">
                            <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 availiable guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                        </td>
                        <td height="32px" colspan="3" valign="bottom" style="padding-bottom: 4px" align="right">
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                            <div id="grid-example">
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="6">
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

  <asp:HiddenField ID="DeviceId" runat="server" />
  <div style="display:none;">
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />

        </div>
  <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"InstanceId") %>',
           '<%#DataBinder.Eval(Container.DataItem,"InstanceName") %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' },
                  { name: 'value' }
              ],
              data: myData
          });



          var grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Devices</asp:Localize>",
              border: true,
              columnLines: true, 
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string1" runat="server">Device Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'value',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  }, {
                      xtype: 'actioncolumn',
                      width: 40,
                      hideable: false,
                      items:
                      [
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string2" runat="server">Delete User</asp:Localize>",
                        width: 30,
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            OnWipeDevice(d.name, d.value);                            
                        },
                        getClass: function (v, meta, rec) {
                        <%if(!m_CanDelete){ %>
                            return 'x-col-hdide';
                        <%} %>
                           
                        }
                    }
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });
  </script>
    <asp:HiddenField ID="HiddenUserGuid" runat="server" />
</asp:Content>
