﻿<%@ Page Title="Gladinet Cloud - Upgrade" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="UpgradePlanPage.aspx.cs" Inherits="GladinetPayFlow.UpgradePlanPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        html, #Form1, .main
        {
            overflow: hidden;
        }
        body
        {
            overflow: hidden;
        }
        
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function OnCancelUpgrade() {
            parent.closeCancelActiveWin();
        }
        function ShowExpCal() {
            var d = document.getElementById("ExpTimeDiv");

            var d1 = document.getElementById("toggle");
            d1.src = "images/expand.png";
            //d.style.left = "306px";
            //d.style.top = "110px";
            d.style.display = "block";

        }

        function HideExpCal() {
            var d = document.getElementById("ExpTimeDiv");
            d.style.display = "none";
            var d1 = document.getElementById("toggle");

            d1.src = "images/collapse.gif";
        }

        function ToggelExpCal() {
            var d = document.getElementById("ExpTimeDiv");
            if (d.style.display == "block")
                HideExpCal();
            else
                ShowExpCal();

        }
        function StartEditName() {
            var d = document.getElementById("name_display");
            var c = document.getElementById("name_change");

            d.style.display = "none";
            c.style.display = "";
        }

        function StopEditName() {
            var d = document.getElementById("name_display");
            var c = document.getElementById("name_change");

            d.style.display = "";
            c.style.display = "none";
        }

        function StartEditEmail() {
            var d = document.getElementById("email_display");
            var c = document.getElementById("email_change");

            d.style.display = "none";
            c.style.display = "";
        }

        function StopEditEmail() {
            var d = document.getElementById("email_display");
            var c = document.getElementById("email_change");

            d.style.display = "";
            c.style.display = "none";
        }

    </script>
    <script type="text/javascript">


        Ext.onReady(function () {
            Ext.define('GroupAccordion', {
                extend: 'Ext.panel.Panel',
                alias: 'widget.tenantgroup',

                requires: [
                    'Ext.layout.container.Accordion',
                    'Ext.grid.*'
                ],
                xtype: 'layout-accordion',

                border: false,
                //title: 'Edit Tenant Plan Information',
                layout: 'accordion',
                renderTo: 'allgroup',
                //fill:true,
                height: document.documentElement.clientHeight - 3,
                defaults: {
                    bodyPadding: 2
                },
                fbar: {
                    xtype: 'panel',
                    contentEl: 'buttonspanel'
                },

                initComponent: function () {
                    Ext.apply(this, {
                        items: [{
                                title: '<asp:Localize meta:resourcekey="str_cstr1" runat="server">Part I - Basic Information</asp:Localize>',
                                contentEl: 'basicinfo',
                                autoScroll: true
                            },
                            {
                                title: '<asp:Localize meta:resourcekey="str_ctr2" runat="server">Part II - Advanced Information</asp:Localize>',
                                contentEl: 'advinfo',
                                autoScroll: true
                            }
                            ,
                            {
                                title: '<asp:Localize meta:resourcekey="str_cstr3" runat="server">Part III - Tenant Administrator Information</asp:Localize>',
                                contentEl: 'admininfo',
                                autoScroll: true
                            }
                            ]
                    });
                    this.callParent();
                }
            });

            var panel = Ext.create('widget.tenantgroup');

            Ext.EventManager.onWindowResize(function (w, h) {
                panel.setHeight(document.documentElement.clientHeight - 3);
                panel.doComponentLayout();
            });
        });
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div id="errmsgdiv">
        <b>
            <asp:Label ID="ErrorMessage" runat="server" Style="color: Red;" meta:resourcekey="ErrorMessageResource1"></asp:Label></b>
    </div>
    <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #c0c0c0;">
        <tr>
            <td width="100%" style="text-align: left">
                <div id='allgroup' style="overflow: auto; width: 100%; margin: 0; padding: 0;">
                </div>
            </td>
        </tr>
    </table>
    <table id="basicinfo" width="99%" style="background-color: white; margin-top: 8px;"
        align="center">
        <tr>
            <td width="440" style="border: 1px solid #d0d0d0; padding: 10px; border-top: 1px solid #C0C0C0;"
                class="tabpanel">
                <table width="100%" cellpadding="0" cellspacing="0">
                    <tr>
                        <td style="border-bottom: 1px solid #d0d0d0; padding-bottom: 5px;">
                            <b>
                                <asp:Localize ID="Localize2" meta:resourcekey="UpgradePlanPage_Org" 
                                runat="server" Text="Organization:"></asp:Localize></b>
                        </td>
                        <td style="border-bottom: 1px solid #d0d0d0; padding-bottom: 5px;">
                            <asp:TextBox ID="Orgnization" runat="server" Width="321px" 
                                CssClass="x-form-field x-form-text" meta:resourcekey="OrgnizationResource1"></asp:TextBox>
                        </td>
                    </tr>
                                        <% if (!IsTennatOwner)
                       { %>

                    <tr>
                        <td colspan="2" style="padding-top: 10px;padding-bottom: 10px; border-bottom: 0px solid #d0d0d0; border-top: 0px solid #d0d0d0">
                            <table width="100%" cellpadding=0 cellspacing=0>
                                <tr>
                                    <td width="180px" style="padding-top: 10px; border-bottom: 1px solid #d0d0d0; border-top: 0px solid #d0d0d0">
                                        <asp:CheckBox ID="NeverExpired" runat="server" Text="Tenant Never Expire" AutoPostBack="True"
                                            Font-Bold="True" OnCheckedChanged="NeverExpired_CheckedChanged" 
                                            meta:resourcekey="NeverExpiredResource1" />
                                    </td>
                                    <asp:Panel ID="ExpirePanel" runat="server" meta:resourcekey="ExpirePanelResource1">
                                        <td width="100px" style="padding-top: 10px; border-bottom: 1px solid #d0d0d0; border-top: 0px solid #d0d0d0">
                                            <asp:Localize ID="Localize1" meta:resourcekey="asp_string5" runat="server" 
                                                Text="Expiration Time:"></asp:Localize>
                                        </td>
                                        <td onclick='ToggelExpCal()' style="padding-top: 10px; border-bottom: 1px solid #d0d0d0;
                                            border-top: 0px solid #d0d0d0">
                                            <div style="border: 1px solid GRAY; padding:0px;padding-left: 5px; width: 130px; background-color: White;">
                                                <table>
                                                    <tr>
                                                        <td>
                                                            <asp:Label ID="ExpireHours" runat="server" Text="Label" Width="100px" meta:resourcekey="ExpireHoursResource1"></asp:Label>
                                                        </td>
                                                        <td width="24px" style="vertical-align: middle; padding-top: 5px;" aligh="center">
                                                            <img id="toggle" src="images/collapse.gif" />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="2">
                                                            <div id="ExpTimeDiv" style="display: none; position: absolute; background-color: White;">
                                                                <asp:Calendar ID="CalExpTime" runat="server" ShowGridLines="True" Width="232px" OnSelectionChanged="CalExpTime_SelectionChanged"
                                                                    NextMonthText="Next" OnVisibleMonthChanged="OnMonthChange" PrevMonthText="Prev"
                                                                    meta:resourcekey="CalExpTimeResource1"></asp:Calendar>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </td>
                                    </asp:Panel>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <b>
                                <asp:Localize meta:resourcekey="asp_string1" runat="server" 
                                Text="User Plan:"></asp:Localize></b>
                        </td>
                    </tr>
                    <tr>
                        <td width="120px">
                            <asp:Label ID="Label1" runat="server" Text="New user plan:" meta:resourcekey="Label1Resource1"></asp:Label>
                        </td>
                        <td style="padding-bottom: 10px; padding-top: 10px;" align="left">
                            <b>
                                <asp:Label ID="MinimalUser" runat="server" Text="3" meta:resourcekey="MinimalUserResource1"></asp:Label>
                                + </b>
                            <asp:TextBox ID="UserCount" runat="server" MaxLength="5" Width="81px" meta:resourcekey="UserCountResource1"
                                CssClass="x-form-field x-form-text"></asp:TextBox>
                        </td>
                    </tr>
                    <% } %>
                    <%if (m_ShowStorageUpgare)
                      { %>
                    <tr>
                        <td colspan="2" style="padding-top: 10px; border-top: 1px solid #f0f0f0">
                            <b>
                                <asp:Localize meta:resourcekey="asp_string2" runat="server" 
                                Text="Storage Plan:"></asp:Localize></b>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-top: 3px; border-top: 1px solid #f0f0f0">
                            <asp:Panel ID="UnlimitedPanel" runat="server" meta:resourcekey="UnlimitedPanelResource1">
                                <table width="100%">
                                    <tr>
                                        <td style="padding-top: 3px; border-top: 0px solid #f0f0f0">
                                            <asp:CheckBox ID="Unlimited" runat="server" Text="Unlimited Storage" AutoPostBack="True"
                                                OnCheckedChanged="Unlimited_CheckedChanged" meta:resourcekey="UnlimitedResource1" />
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                            <asp:Panel ID="LimitedPanel" runat="server" meta:resourcekey="LimitedPanelResource1">
                                <table width="100%">
                                    <tr>
                                        <td width="120px">
                                            <asp:Label ID="Label2" runat="server" Text="New storage plan:" meta:resourcekey="Label2Resource1"></asp:Label>
                                        </td>
                                        <td style="padding-bottom: 10px; padding-top: 10px;" align="left">
                                            <b>
                                                <asp:Label ID="MiniStorage" runat="server" Text="3" meta:resourcekey="MiniStorageResource1"></asp:Label>GB
                                                + </b>
                                            <asp:TextBox ID="StorageSpace" runat="server" MaxLength="6" Width="81px" meta:resourcekey="StorageSpaceResource1"
                                                CssClass="x-form-field x-form-text"></asp:TextBox>
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <%} %>
                    <%if (m_SpeedControl)
                      {%>
                    <tr>
                        <td colspan="2" style="padding-top: 10px; padding-bottom: 10px; border-top: 1px solid #f0f0f0">
                            <b>
                                <asp:Localize meta:resourcekey="asp_string3" runat="server" 
                                Text="Bandwidth Control (KBytes/Sec, 0-Unlimited):"></asp:Localize></b>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" style="padding-top: 1px; border-top: 0px solid #f0f0f0">
                            <b>
                                <asp:Localize meta:resourcekey="asp_string4" runat="server" Text="Upload:"></asp:Localize></b>
                            <asp:TextBox ID="UploadSpeed" Width="60px" runat="server" meta:resourcekey="UploadSpeedResource1"
                                CssClass="x-form-field x-form-text"></asp:TextBox>
                            &nbsp;&nbsp; <b><asp:Localize runat="server" meta:resourcekey="str_Dow">Download:</asp:Localize></b><asp:TextBox ID="DownloadSpeed" Width="60px" runat="server"
                                meta:resourcekey="DownloadSpeedResource1" CssClass="x-form-field x-form-text"></asp:TextBox>
                        </td>
                    </tr>
                    <%}%>
                </table>
            </td>
        </tr>
    </table>
    <table id="advinfo" width="99%" style="background-color: white; margin-top: 8px;"
        align="center">
        <tr>
            <td class="aa" valign="top" style="padding-bottom: 10px; padding-top: 15px">
                <h3>
                    <asp:Localize meta:resourcekey="asp_string6" runat="server" 
                        Text="Tenant Administrative Control:"></asp:Localize></h3>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Localize meta:resourcekey="asp_string7" runat="server" Text="There are certain features you can expose to tenant administrators, such as setup
                        LDAP for Active Directory or mount extra external storage services. Check the following
                        features that you would like to expose to tenant administrator."></asp:Localize>
            </td>
        </tr>
        <tr>
            <td style="padding-top: 5px; border: 1px solid #d0d0d0">
                <table width="100%">
                    <tr>
                        <td>
                            <asp:CheckBox ID="AttachExternalStorage" Checked="True" runat="server" Text="Allow tenant attach external cloud storage"
                                meta:resourcekey="AttachExternalStorageResource1" />
                        </td>
                        <td>
                            <asp:CheckBox ID="EditLDAPSetting" Checked="True" runat="server" Text="Allow tenant edit LDAP setting"
                                meta:resourcekey="EditLDAPSettingResource1" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:CheckBox ID="ViewGroupPolicy" Checked="True" runat="server" Text="View and edit group policy"
                                meta:resourcekey="ViewGroupPolicyResource1" />
                        </td>
                        <td>
                            <asp:CheckBox ID="EditAdminInfo" Checked="True" runat="server" Text="Edit tenant administrator info"
                                meta:resourcekey="EditAdminInfoResource1" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:CheckBox ID="EditBranding" Checked="True" runat="server" Text="Allow tenant edit branding setting"
                                meta:resourcekey="EditBrandingResource1" />
                        </td>
                        <td>
                            <asp:CheckBox ID="HideMigration" Checked="True" runat="server" 
                                Text="Hide migration option" meta:resourcekey="HideMigrationResource1"
                                 />
                        </td>

                    </tr>
                    <tr>
                        <td>
                            <asp:CheckBox ID="SupportGuestUser" Checked="True" runat="server" Text="Allow creating guest user"
                                meta:resourcekey="SupportGuestUserResource1" />
                        </td>
                        <td>
                            <asp:CheckBox ID="ForceVersioning" runat="server" Visible="False" Text="Force all folder(except root) to be versioned"
                                meta:resourcekey="ForceVersioningResource1" />
                        </td>


                    </tr>
                    <tr>
                    <td colspan=2>
                                <asp:CheckBox ID="AllowAutoUpgarde" runat="server" 
                                    Text="Allow tenant to increase user plan automatically" meta:resourcekey="AllowAutoUpgardeResource1" 
                                    />
                            </td>
                            </tr>
                    <tr>
                    <td colspan=2>
                    
                                <asp:CheckBox ID="ShowDare"  runat="server" 
                                    Text="Show Data-At-Rest Encryption configuration page (Requires empty storage container)" meta:resourcekey="ShowDareResource1" />
                    
                    </td>
                    </tr>
                    
                    <tr>
                    <td colspan=2>
                    
                                <asp:CheckBox ID="MultiDomain"  runat="server" 
                                    Text="Multi AD Domain Support" meta:resourcekey="MultiDomainResource1"  />
                    
                    </td>
                    </tr>
                    
                <asp:Panel ID="ZoneListPanel" runat="server" Visible="False" 
                        meta:resourcekey="ZoneListPanelResource1">
                     
                    <tr>
                        <td class="aa" valign="top" style="padding-bottom: 10px; padding-top: 15px">
                            <h2>
                                <asp:Localize ID="Localize3"  runat="server" 
                                    Text="Assigned Zone:" meta:resourcekey="Localize3Resource1"></asp:Localize></h2>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:DropDownList ID="AssignedZoneList" runat="server"  CssClass="browser-default custom-select secsubbordercolor"
                                meta:resourcekey="AssignedZoneListResource1">
                            </asp:DropDownList>  
                        </td>
                    </tr>
                    </asp:Panel>
                </table>
            </td>
        </tr>
        <tr>
            <td height="15px">
                &nbsp;
            </td>
        </tr>
        <tr>
            <td>
                <table width="100%" style="display: none">
                    <tr>
                        <td width="250">
                        </td>
                        <td align="right" style="border-bottom: #d0d0d0; border-bottom-width: 1px; border-bottom-style: solid;
                            color: #009000; padding-right: 10px; font-style: italic; outline: #e0e0e0 dotted thin;">
                            <span style="color: Gray;"><asp:Localize runat="server" meta:resourcekey="str_TotNbs">Total:&nbsp;</asp:Localize></span><asp:Label ID="PriceInfo" runat="server"
                                meta:resourcekey="PriceInfoResource1"></asp:Label>
                        </td>
                        <td width="10px">
                            &nbsp;
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    
    <table id="admininfo" width="99%" style="background-color: white; margin-top: 8px;"
        align="center">
        <tr>
            <td class="aa" valign="top" style="padding-bottom: 10px; padding-top: 15px">
                <h3><asp:Localize runat="server" meta:resourcekey="str_TenAdmInf">Tenant Administrator Info:</asp:Localize></h3>
            </td>
        </tr>
        
        <tr>
            <td style="padding-top: 5px; border: 0px solid #d0d0d0">
                <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                <div id="name_display" class="checkout3" style="padding: 10px; background-color: white;
                    width: 90%;" align="center">
                    <table width="90%" align="center">
                        <tr>
                            <td width="2%">
                                &nbsp;
                            </td>
                            <td class="InputLabel">
                                <%:FirstName.Text%>&nbsp;<%:LastName.Text%>&nbsp;
                            </td>
                            <td align="right">
                                <a href="javascript:;" onclick="StartEditName();return false;" style="color: #008000">
                                    <asp:Localize meta:resourcekey="str_cstr4" runat="server" Text="Edit"></asp:Localize></a>
                            </td>
                        </tr>
                    </table>
                </div>
                <div id="name_change" class="checkout3" style="padding: 10px; background-color: white;
                    display: none; width: 90%" align="center">
                    <table width="90%" align="center">
                        <tr>
                            <td width="2%">
                                &nbsp;
                            </td>
                            <td class="InputLabel" width="50%">
                                First Name
                                <asp:RequiredFieldValidator runat="server" ID="RequiredFieldValidator11" ControlToValidate="FirstName"
                                    ErrorMessage="User name is required!" Display="Dynamic" CssClass="errmsg" ValidationGroup="AddNewUser"
                                    meta:resourcekey="RequiredFieldValidator11Resource1" />
                            </td>
                            <td class="InputLabel" width="50%">
                                Last Name
                                <asp:RequiredFieldValidator runat="server" ID="RequiredFieldValidator12" ControlToValidate="LastName"
                                    ErrorMessage="User name is required!" Display="Dynamic" CssClass="errmsg" ValidationGroup="AddNewUser"
                                    meta:resourcekey="RequiredFieldValidator12Resource1" />
                            </td>
                            <td>
                            </td>
                        </tr>
                        <tr>
                            <td width="2%">
                                &nbsp;
                            </td>
                            <td>
                                <asp:TextBox ID="FirstName" runat="server" Width="95%" class="InputText" CssClass="x-form-field x-form-text"
                                    meta:resourcekey="FirstNameResource1"></asp:TextBox>
                                <div style="color: #D00000">
                                </div>
                            </td>
                            <td>
                                <asp:TextBox ID="LastName" runat="server" Width="95%" class="InputText" CssClass="x-form-field x-form-text"
                                    meta:resourcekey="LastNameResource1"></asp:TextBox>
                                <div style="color: #D00000">
                                </div>
                            </td>
                            <td>
                                <asp:Button ID="UpdateName" runat="server" Text="Update" Width="108px" OnClick="UpdateName_Click"
                                    meta:resourcekey="UpdateNameResource1" CssClass="btnaction" />
                                <asp:Button ID="Button1" runat="server" Text="Cancel" Width="108px" OnClientClick="StopEditName();return false"
                                    meta:resourcekey="Button1Resource1" CssClass="btnaction" />
                            </td>
                        </tr>
                    </table>
                </div>
                <br />
                <div id="email_display" class="checkout3" style="padding: 10px; background-color: white;
                    width: 90%" align="center">
                    <table width="90%" align="center">
                        <tr>
                            <td width="2%">
                                &nbsp;
                            </td>
                            <td class="InputLabel">
                                <%:Email.Text%>
                            </td>
                            <td align="right">
                                <table>
                                    <tr>
                                        <td>
                                            <a href="javascript:;" onclick="StartEditEmail();return false;" style="color: #008000">
                                                <asp:Localize ID="Localize7" meta:resourcekey="asp_string15" runat="server" 
                                                Text="Edit"></asp:Localize></a>
                                        </td>
                                        <td>
                                       
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </div>
                <div id="email_change" class="checkout3" style="padding: 10px; background-color: white;
                    display: none; width: 90%;" align="center">
                    <table width="90%" align="center">
                        <tr>
                            <td width="2%">
                                &nbsp;
                            </td>
                            <td class="InputLabel" width="50%"><asp:Localize runat="server" meta:resourcekey="str_NbsLogUseNam">&nbsp;Email (Login User Name)</asp:Localize></td>
                            <td class="InputLabel" width="50%"><asp:Localize runat="server" meta:resourcekey="str_ConEma">Confirm Email</asp:Localize></td>
                        </tr>
                        <tr>
                            <td width="2%">
                                &nbsp;
                            </td>
                            <td>
                                <asp:TextBox ID="Email" runat="server" Width="95%" class="InputText" CssClass="x-form-field x-form-text"
                                    meta:resourcekey="EmailResource1"></asp:TextBox>
                                <div style="color: #D00000">
                                    <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="Email"
                                        ErrorMessage="New email  is required!" Display="Dynamic" ValidationGroup="UpdateEmailGroup"
                                        meta:resourcekey="reqNameResource1" />
                                </div>
                            </td>
                            <td>
                                <asp:TextBox ID="Email1" runat="server" Width="95%" class="InputText" CssClass="x-form-field x-form-text"
                                    meta:resourcekey="Email1Resource1"></asp:TextBox>
                                <div style="color: #D00000">
                                    <asp:RequiredFieldValidator runat="server" ID="RequiredFieldValidator2" ControlToValidate="Email1"
                                        ErrorMessage="Re-enter the new email!" Display="Dynamic" ValidationGroup="UpdateEmailGroup"
                                        meta:resourcekey="RequiredFieldValidator2Resource1" />
                                </div>
                            </td>
                            <td rowspan=3>
                                <asp:Button ID="UpdateEmail" runat="server" Text="Update" Width="98px" OnClick="UpdateEmail_Click"
                                    meta:resourcekey="UpdateEmailResource1" CssClass="btnaction" />
                                <asp:Button ID="Button2" runat="server" Text="Cancel" Width="98px" OnClientClick="StopEditEmail();return false"
                                    meta:resourcekey="Button2Resource1" CssClass="btnaction" />
                            </td>
                        </tr>
                        
                    </table>
                </div>
            </td>
        </tr>
        <tr>
            <td height="15px">
                &nbsp;
            </td>
        </tr>
        <tr>
            <td>
                <table width="100%" style="display: none">
                    <tr>
                        <td width="250">
                        </td>
                        <td align="right" style="border-bottom: #d0d0d0; border-bottom-width: 1px; border-bottom-style: solid;
                            color: #009000; padding-right: 10px; font-style: italic; outline: #e0e0e0 dotted thin;">
                            <span style="color: Gray;"><asp:Localize runat="server" meta:resourcekey="str_TotNbs">Total:&nbsp;</asp:Localize></span><asp:Label ID="Label3" runat="server"
                                meta:resourcekey="PriceInfoResource1"></asp:Label>
                        </td>
                        <td width="10px">
                            &nbsp;
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;
        border-bottom: 0; vertical-align: middle;" id="buttonspanel">
        <table width="100%" style="height: 64px; text-align: right; "
            align="right">
            <tr>
                <td colspan="2" align="right" style="padding-right: 15px;">
                    <div style="display: none" id='blueloader'>
                        <img alt='loading ...' src="images/blueloader.gif" width="160" height="20" /></div>
                    <asp:Button ID="UpgradeNow" runat="server" Text="Apply Change" CssClass="btn btn-primary gladbtn"
                        OnClick="UpgradeNow_Click" Width="168px" OnClientClick="Wait('Applying Settings');"
                        meta:resourcekey="UpgradeNowResource1" />
                </td>
                                    <% if (string.IsNullOrEmpty(CloseMode.Value) || CloseMode.Value != "1")
                       { %>

                <td align="right" style="padding-right: 15px;">
                    <asp:Button ID="CancelChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                        OnClientClick="OnCancelUpgrade();return false;" Width="168px" meta:resourcekey="CancelChangeResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                </td>
                                        <% } %>

            </tr>
        </table>
    </div>
    <asp:HiddenField ID="AdminUserId" runat="server" />
    <asp:HiddenField ID="OldUserPlan" runat="server" />
    <asp:HiddenField ID="OldStoragePlan" runat="server" />
    
     <asp:HiddenField ID="FSessionId" runat="server" />
     <asp:HiddenField ID="CloseMode" runat="server" />

    <%if (m_ShowCal)
      { %>
    <script type="text/javascript">
        ShowExpCal();
    </script>
    <%} %>
</asp:Content>
