﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantGuestUserMgrPage.aspx.cs" Inherits="GladinetPayFlow.TenantGuestUserMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        body , html
        {
            overflow: hidden;
        }
        
        .securityicon
        {
            background-image: url(/portal/images/security2.png);
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function onHelp() {
            var d = document.getElementById("help_text");
            activewin = new Ext.Window({
                id: 'quota_win',
                title: "<asp:Localize meta:resourcekey="str_whtIsGstUsr" runat="server">What is a guest user?</asp:Localize>",
                width: 680,
                height: 540,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: d.innerHTML,
                defaults: {
                    border: false
                }
            });
            activewin.show();
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
       // parent.setActivePanel("UserMgr");

        function onDelUser(name,userid, domainid) {
            if (confirm("<asp:Localize meta:resourcekey="str_cfmDel" runat="server">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?")) {
               
                Wait("<asp:Localize meta:resourcekey="str_del" runat="server">Deleting</asp:Localize>");
                var btn = document.getElementById("ctl00_MainContent_DeleteUser");
                var uid = document.getElementById("ctl00_MainContent_UserGuid");
                var did = document.getElementById("ctl00_MainContent_UserDomainId");
                uid.value = userid;
                did.value = domainid;
                btn.click();
            }

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/GuestUserMgrPage.aspx";
        }

        function ResetPassword(t) {

            var uri = "/portal/ResetUserPassword.aspx?t=";

            uri += t;

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Reset Password</asp:Localize>",
                width: 650,
                height: 460,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true, 
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }]
            });
            activewin.show();
        }
        function OnAddUser() {

            activewin = new Ext.Window({
                id: 'On_Add_User',
                title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Create New User</asp:Localize>",
                width: 680,
                height: maxh(576),
                plain: true,
                modal: true,
                maximizable: true,
                resizable: false,
                maximized: false,
                shadow: 'drop',
                shadowOffset: 20,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='AddGuestUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }
        function OnLDAPAddUser() {
            var closeAction = new Ext.Action({
                text: "<asp:Localize meta:resourcekey="js_string4" runat="server">Close</asp:Localize>",
                width: 108
            });

            activewin = new Ext.Window({
                id: 'On_Ads_AddUser',
                title: "<asp:Localize meta:resourcekey="js_string5" runat="server">Add Active Directory User(s)</asp:Localize>",
                width: 680,
                height: 650,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                },
                buttons: [closeAction],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            closeAction.setHandler(function () { activewin.close(); });

            activewin.show();



        }
        

        function OnManageAdmin() {
            if (parent.OnManageAdmin)
                parent.OnManageAdmin();
            else
                parent.parent.OnManageAdmin();
        }
        function OnEditGroup(t, f, l, e) {

            parent.OnEditGroup(t, f, l, e);

        }

        function OnChangeName(t, f, l) {

            var uri = "EditUserPage.aspx?uid=";

            uri += t;
            uri += "&firstname=";
            uri += f;
            uri += "&lastname=";
            uri += l;



            activewin = new Ext.Window({
                id: 'resetuname_win',
                title: "<asp:Localize meta:resourcekey="js_string9" runat="server">Change User Name</asp:Localize>",
                width: 550,
                height: 250,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true, 
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }
        function OnChangeEmail(t) {

            var uri = "ChangeEmailPage.aspx?uid=";

            uri += t;



            activewin = new Ext.Window({
                id: 'resetacct_win',
                title: "<asp:Localize meta:resourcekey="js_string10" runat="server">Change Email</asp:Localize>",
                width: 550,
                height: 310,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true, 
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }

        function OnClickUser() {
            window.location = "/portal/UserMgrPage.aspx";
        }
        function OnClickGroup() {
            window.location = "/portal/GroupMgrPage.aspx";
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
   
   <div class="meubardrop navbar navbar-default" role="navigation">
      <div class="container-fluid">
          <p class="navbar-text">
                            <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1" CssClass="badge"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
              
          </p>
          
               <div id="errmsgdiv" class="navbar-text">
                                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                            </div>
          
          <div class="navbar-form navbar-right" >
              <table>
                  <tr>
                      <td>
                          <asp:LinkButton ID="AllUsers" runat="server" Font-Size="Larger" cssclass="btn btn-default "
                                OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1">All Guest Users</asp:LinkButton>
                      </td>
                      <td>
                            <asp:TextBox ID="Contains" runat="server" Width="228px" CssClass="form-control dark"
                                meta:resourcekey="ContainsResource1"></asp:TextBox>
                      </td>
                      <td>
                            <asp:Button ID="Button1" OnClick="FileterUsers_Click" runat="server" Text="Search" CssClass="btn btn-default nbtn" 
                                 meta:resourcekey="Button1Resource2" />
                      </td>
                  </tr>
              </table>
           
                          
                          
                          
                                </div>
      </div>
      </div>
    <table width="100%" style=" padding: 2px; background-color: white; margin-top: 20px;" cellspacing="0" cellpadding="0" border="0" id="grid-table">
                   
                   
                    <tr>
                        <td id="grid-example" >
                        </td>
                    </tr>
                </table>
    <div id="help_text" style="display: none; position: absolute;">
        <table>
            <tr>
                <td style="background-color: white; border: 1px solid #c0c0c0;" class="checkout3"
                    valign="top">
                    <table width="96%" align="center" style="height: 100%">
                        <tr>
                            <td colspan="6" height="100px">
                                <div width="90%" style="padding: 10px;">
                                    <div class='idea_flex' style="height: auto;">
                                        <asp:Localize  meta:resourcekey="asp_string2" runat="server">Guest User</asp:Localize>
                                        <ul>
                                            <li><b>
                                                <asp:Localize  meta:resourcekey="asp_string3" runat="server">What is a guest user?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize  meta:resourcekey="asp_string4" runat="server">A guest user is a user who you can invite to collaborate on a shared folder and assign full-control permission.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize  meta:resourcekey="asp_string5" runat="server">What can a guest user do?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize  meta:resourcekey="asp_string6" runat="server">A guest user can use all the access clients, such as the web browser, desktop client, and mobile application to collaborate on the shared folder.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize  meta:resourcekey="asp_string7" runat="server">What limitations does a guest user have?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize  meta:resourcekey="asp_string8" runat="server">Guest users only get to see the shared folders that are assigned to them. Guest users don't have a home directory and have less functionality compared to  regular users. However, they can have full control of the shared folders when permissions are given.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize  meta:resourcekey="asp_string9" runat="server">Charge</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string10" runat="server">Your account includes a quota of guest users. When the quota is exceeded, guest users will be charged a fraction of the regular user costs.</asp:Localize>
                                                    (<%= user.GladinetCloud.IsInstalledApp()? "50%":"67%" %>)
                                                </p>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        
    </div>
    <div style="display: none;">
    <asp:Button ID="DeleteUser" runat="server" Text="Button" 
        onclick="DeleteUser_Click" />
        <asp:HiddenField ID="UserGuid" runat="server" />
        <asp:HiddenField ID="UserDomainId" runat="server" />
        </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
         '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString().Replace("'","%27"))%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString().Replace("'","%27"))%>',
          '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString().Replace("'","%27")) %>', 
           '','<%#DataBinder.Eval(Container.DataItem,"IsAdmin") %>',
           '<%#DataBinder.Eval(Container.DataItem,"UserGuid") %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"FirstName").ToString().Replace("'","%27")) %>','<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LastName").ToString().Replace("'","%27")) %>','<%#DataBinder.Eval(Container.DataItem,"LastVisit").ToString().Replace("'","%27") %>',
           '<%#DataBinder.Eval(Container.DataItem,"DomainId") %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"ProductType").ToString().Replace("'","%27")) %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"EncId").ToString().Replace("'","%27")) %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">
    var grid;
        function AdjustGridTable() {
            isMobileBrowserOrNarrow();
            var h = 400;

            try {

                var myTable = Ext.get('grid-table');
                var tableY = myTable.getY();

                //var mySetting = Ext.get('farm-setting');
                var settingH = 0; // mySetting.getHeight();

                h = document.body.offsetHeight - tableY - 8 - settingH;
                //var ee = document.getElementById('tinfo');
                //ee.style.height = h + "px";
                if (h < 108) {
                    h = 108;
                }

                grid.setWidth(document.documentElement.clientWidth - 4);
                grid.setHeight(h);
                grid.doComponentLayout();

            } catch (err) {
            }


        }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'fullname' },
                  { name: 'email' },           
                  { name: 'action' },
                  { name: 'isadmin' },
                  {name: 'userguid'},
                  {name: 'firstname'},
                  {name: 'lastname'},
                  {name: 'lastvisit', sortType: 'asDate'},
                  {name: 'domainid'},
                  {name: 'orgnization'},
                  {name: 'encid'}
              ],
              data: myData
          });


          var d = document.getElementById("grid-example");
          var h = 400;
          //if( d.offsetHeight > h)
            h = d.offsetHeight-100;
          
             grid = Ext.create('Ext.grid.Panel', {
              frame: false,
              border:1,
              store: store,
              stripeRows: true,
              columnLines: false,
              minHeight : 218,
              height:h, 
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string12" runat="server">Full Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'fullname',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-weight:100; color:#565656'>" + unescape(value) + "</span>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string13" runat="server">Email</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'email',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-weight:100; color:#565656'>" + unescape(value) + "</span>";
                      }

                  },
                    {
                      text: "<asp:Localize meta:resourcekey="js_string17" runat="server">Organization</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'orgnization',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-weight:100; color:#565656'>" + unescape(value) + "</span>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string14" runat="server">Last Login</asp:Localize>",
                      width: 175,
                      sortable: true,
                      dataIndex: 'lastvisit'
                  }, {
                      xtype: 'actioncolumn',
                      width: 120,
                      hideable: false,
                      items:
                      [
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string15" runat="server">Delete User</asp:Localize>",
                        width: 30,
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            onDelUser(d.email,d.userguid, d.domainid);                            
                        },
                        getClass: function (v, meta, rec) {
                            var d = rec.data;
                            <%if(!m_CanDelete){ %>
                             return 'x-col-hdide';
                            <%} %>
                            if (d.isadmin == 'True')
                                return 'x-col-hdide';
                        }
                          },
                    
                          {
                              icon: '/portal/images/changepassword.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string16" runat="server">Edit</asp:Localize>",
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            ResetPassword(d.encid);
                        }
                        ,
                        getClass: function (v, meta, rec) {
                            var d = rec.data;

                            <%if(!m_CanDelete){ %>
                             return 'x-col-hdide';
                            <%} %>


                            if (d.isadmin == 'True')
                                return 'x-col-hdide';
                        }
                    }
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

         Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      });
    </script>
</asp:Content>
