﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="StorageStat.aspx.cs" Inherits="GladinetPayFlow.StorageStat"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>


<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    
    
    <style type="text/css">
         td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        #SizeChart  [hidden],#SizeChart template {
            display: block !important;
        }


        #FileTypeChart  [hidden],#FileTypeChart template {
            display: block !important;
        }

        
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        
        .style1
        {
            width: 153px;
        }
        
        .newusericon
        {
            background-image: url(images/upgradeuser.png);
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);




        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("sw") == -1)
                window.location.href = window.location.href + "?sw=" + (e.offsetWidth - 60) + "&sh=" + (e.offsetHeight - 70);
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }
      
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    
<asp:Localize ID="LocTotFil" meta:resourcekey="str_totFil" runat="server" Visible="false">Total Files</asp:Localize>
<asp:Localize ID="LocTotFld" meta:resourcekey="str_totFld" runat="server" Visible="false">Total Folders</asp:Localize>
<asp:Localize ID="LocTotFilSze" meta:resourcekey="str_totFilSze" runat="server" Visible="false">Total File Size</asp:Localize>
<asp:Localize ID="LocAvgFilSze" meta:resourcekey="str_avgFilSze" runat="server" Visible="false">Average File Size</asp:Localize>
<asp:Localize ID="LocTntCnt" meta:resourcekey="str_tntCnt" runat="server" Visible="false">Tenants Count</asp:Localize>
<asp:Localize ID="LocFilPerTnt" meta:resourcekey="str_filPerTnt" runat="server" Visible="false">Files per Tenant</asp:Localize>
<asp:Localize ID="LocFldPerTnt" meta:resourcekey="str_fldPerTnt" runat="server" Visible="false">Folders per Tenant</asp:Localize>
<asp:Localize ID="LocSpcUsdPerTnt" meta:resourcekey="str_spcUsdPerTnt" runat="server" Visible="false">Space used per Tenant</asp:Localize>
    <div style="width: 100%; padding: 5px; border-bottom: 1px solid #cccccc ;" class="meubardrop1">
                <table style="width: 100%" border="0">
                    <tr>
                        <td>
                            <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize meta:resourcekey="str_stoSta" runat="server">Storage Statistics</asp:Localize></span>
                        </td>
                        <td height="48px"></td>
                        <td  style=" height: 48px" valign="middle">
                            <span class="alert-info" style="padding:3px; border-radius:3px;"><asp:Localize meta:resourcekey="str_notRelTmeRpt" runat="server">This is NOT a real time report. The information is provided from the background scan process.</asp:Localize></span>
                            <div id="errmsgdiv" class="navbar-text">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
                        </td>
                        <td align="right" style="display:none;width: 40px; padding-right: 10px; height: 48px;">
                            <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;" title="<%=LinkButton2.Text %>">
                <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" onclick="__doPostBack('LinkButton2', '')">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px; display:none;"><asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" OnClick="LinkButton1_Click" meta:resourcekey="LinkButton2Resource1" ForeColor="#565656"></asp:LinkButton></div>
            </div>
                        </td>
                    </tr>
                 
                </table>
            </div>
    
    <div style="width:100%; overflow:auto" id="rowcontainer">
    <div class="row " style="width:100%;align-content: center; margin-top:20px; padding:15px;" align="center">
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer " style="padding-bottom:10px; height:340px; overflow:auto;" >
            <table width="100%" style="background-color: white; height:330px;" class="table-striped viewcard">
                        <tr> 
                            <td style="padding: 10px; border-bottom: 1px solid #f0f0f0;font-weight: 400 !important;" class="boxbordercolor secsubcolor" colspan="3" height="64px">
                                <asp:Localize meta:resourcekey="str_ovlSts" runat="server">Overall Statistics</asp:Localize>
                            </td>
                        </tr>
                        <asp:Repeater ID="OverallRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px;">
                                    <td style="padding-left: 10px;" align="left" valign="top">
                                        &nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "Note")%>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                
                    </table>
        </div>
               
            <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer"  style="padding-bottom:10px;height:340px; overflow:auto;">
                    <table width="100%" style="background-color: white; height:330px;" class="table-striped viewcard">
                        <tr>
                            <td style="padding: 10px; border-bottom: 1px solid #f0f0f0;font-weight: 400 !important;" class="boxbordercolor secsubcolor" align="center" colspan="3" height="64px">
                                <asp:Localize meta:resourcekey="str_teamWhoUsdMstStr" runat="server">Tenants with the Most Storage Usage</asp:Localize>
                            </td>
                        </tr>
                        <asp:Repeater ID="TenantsRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px; ">
                                    <td style="padding-left: 10px;" align="left">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Orgnization").ToString())%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "UsedString")%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "QuotaString")%>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
        </div>
        
                <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer"  style="padding-bottom:10px;height:320px; overflow:auto;">
                    <table width="100%" style="background-color: white; height:310px;" class="table-striped viewcard">
                        <tr>
                            <td style="padding: 10px; border-bottom: 1px solid #f0f0f0;font-weight: 400 !important;" class="boxbordercolor secsubcolor" align="center" colspan="3" height="64px">
                                <asp:Localize meta:resourcekey="str_usrWhoUsdMstStr" runat="server">Users with the Most Storage Usage</asp:Localize>
                            </td>
                        </tr>
                        <asp:Repeater ID="TopUserRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px; ">
                                    <td style="padding-left: 10px;" align="left">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "UsedStr")%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "QuotaStr")%>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer"  style="padding-bottom:10px;height:320px; overflow:auto;" >
            <table width="100%" style="background-color: white; height:310px;" class="viewcard">
                        <tr>
                            <td style="padding: 10px; border-bottom: 1px solid #f0f0f0;font-weight: 400 !important;" class="boxbordercolor secsubcolor" align="center" colspan="3" height="64px">
                                <asp:Localize meta:resourcekey="str_filTpeDtr" runat="server">File Type Distribution</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                        <td>
                        <table width=100% class="table-striped">
                            <asp:Repeater ID="FileTypeRepeater" runat="server">
                            <ItemTemplate>
                                <tr style="padding-top: 5px;">
                                    <td  style="padding-left: 10px;" align="left">
                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                    </td>
                                    <td >
                                        <%#DataBinder.Eval(Container.DataItem, "Note")%>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
                        
                        </td>
                        <td width="200px" id="FileTypeChart"></td>

                        </tr>
                       </table>
        </div>
     <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer"  style="padding-bottom:10px;height:320px; overflow:auto;">
                 <table width="100%" style="background-color: white; height:310px;" class="viewcard">
                        <tr>
                            <td style="padding: 10px; border-bottom: 1px solid #f0f0f0;font-weight: 400 !important;" class="boxbordercolor secsubcolor" align="center" colspan="2" height="64px">
                                <asp:Localize meta:resourcekey="str_szeDtr" runat="server">File Size Distribution</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td >
                                <table width="100%" class="table-striped">
                                    <asp:Repeater ID="FileSizeRepeater" runat="server">
                                        <ItemTemplate>
                                            <tr style="padding-top: 5px;">
                                                <td style="padding-left: 10px;" align="left">
                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Name").ToString())%>
                                                </td>
                                                <td >
                                                    <%#DataBinder.Eval(Container.DataItem, "Value")%>
                                                </td>
                                                <td >
                                                    <%#DataBinder.Eval(Container.DataItem, "Note")%>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </table>
                            </td>
                            <td width="200px" id="SizeChart"></td>
                        </tr>
                    </table>
        </div>

    </div>
    
    </div>
    
    <script type="text/javascript">

        Ext.require('Ext.chart.*');

        
        function DrawChart(rid, fields, data, min, max, xtitle, ytitle, xfield, yfield, charttype) {
            
            var browserStore = new Ext.data.JsonStore({
                fields: fields,
                data: data
            });

            var colors = ['rgb(47, 162, 223)'];

            Ext.chart.theme.Browser = Ext.extend(Ext.chart.theme.Base, {
                constructor: function (config) {
                    Ext.chart.theme.Base.prototype.constructor.call(this, Ext.apply({
                        colors: colors
                    }, config));
                }
            });
        
            var chart = new Ext.chart.Chart({
                renderTo: rid,
                width: '100%',
                height: '100%',
              
                store: browserStore,
                legend: {
                    position: 'right'
                },
                axes: [{
                    type: 'Numeric',
                    position: 'left',
                   
                    title: ytitle,
                    grid: true,
                    minimum: min,
                    maximum: max
                }, {
                    type: 'Category',
                    position: 'bottom',
                    grid: true,
                    fields: [xfield],
                    title: xtitle,
                    label: {
                        renderer: function (v) {
                            return v;
                        }
                    }
                }],
                series: [{
                    type: charttype,
                    axis: 'left',
                    highlight: true,
                    xField: xfield,
                    yField: yfield
                }]
            });
        }


        function DrawPieChart(rid, fields, data,   xfield, yfield) {
            
            var browserStore = new Ext.data.JsonStore({
                fields: fields,
                data: data
            });

            var colors = ['rgb(47, 162, 223)'];

            Ext.chart.theme.Browser = Ext.extend(Ext.chart.theme.Base, {
                constructor: function (config) {
                    Ext.chart.theme.Base.prototype.constructor.call(this, Ext.apply({
                        colors: colors
                    }, config));
                }
            });
        chart = new Ext.chart.Chart({
        renderTo: rid,
                width: '200px',
                height: '200px',
        animate: true,
        store: browserStore,
        
        shadow: true,
        legend: {
            position: 'right'
        },
        insetPadding: 25,
        theme: 'Base:gradients',
        series: [{
            type: 'pie',
            field: yfield,
            showInLegend: false,
            highlight: {
              segment: {
                margin: 20
              }
            },
            label: {
                field: xfield,
                display: 'rotate',
                contrast: true,
                font: '10px "Lucida Grande", "Lucida Sans Unicode", Verdana, Arial, Helvetica, sans-serif'
            },
            animate: true
        }]
    });
            
        }

        var SizeDistData = [
          <asp:Repeater ID="SizeDistRepeater" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            stype:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
            Distribution:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
            ];


        var TypeDistData = [
          <asp:Repeater ID="TypeDistRepeater" runat="server" >
            <ItemTemplate>         
            <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
            stype:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
            Distribution:<%#DataBinder.Eval(Container.DataItem,"Value") %>
            }
            </ItemTemplate>
        </asp:Repeater>      
            ];

            function adjust(){
                
                var e = document.getElementById("rowcontainer");
                e.style.height = (document.documentElement.offsetHeight -72)+"px";
                
            }
            Ext.onReady(function () {
                adjust();
             DrawPieChart('SizeChart', ['stype', 'Distribution'], SizeDistData,  'stype', 'Distribution');
             DrawPieChart('FileTypeChart', ['stype', 'Distribution'], TypeDistData,  'stype', 'Distribution');

         });
      
      </script>



    
</asp:Content>
