﻿<%@ Page Title="Gladinet Cloud - Setup Google Storage Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="Wasabi.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.Wasabi"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm, .tabpanel, .storagepanel, #Form2, div.textbox, .storagetd
        {
            height: 100%;
        }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
            overflow: auto;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }     
        #<%=TxtSubFolder.ClientID %>::placeholder{color:lightgray;opacity:1;}
        #<%=TxtSubFolder.ClientID %>:-ms-input-placeholder{color:lightgray;}
        #<%=TxtSubFolder.ClientID %>::-ms-input-placeholder{color:lightgray;}
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocMisAccPoi" meta:resourcekey="str_misAccPoi" Visible="false">Missing Access Point</asp:Localize>
<asp:Localize runat="server" ID="LocCrtNewBkt" meta:resourcekey="str_crtNewBkt" Visible="false">Create New Bucket</asp:Localize>
    <div class="wrapper">
        <table width="100%">
            <tr> <td align="center" style="padding-top:30px;">
        <table width="100%" align="center" style="background: WHITE; padding: 15px; max-width:800px;" cellspacing="0"
            id="input_panel">
            <tr>
                <td>
                    <table width="100%">
                        <tr>
                            <td "80px">
                                <img src="../images/wasabi.svg" height="32px" />
                            </td>
                            </tr><tr>
                            <td>
                                <h2>
                                    <asp:Localize meta:resourcekey="asp_string1" runat="server">Wasabi Account Information</asp:Localize></h2>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; vertical-align: top;">
                    <b>
                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                    <table width="100%" align="center">
                        <%if (FirstStage)
                          { %>
                        <tr >
                            <td height="15px" style="color: #565656; font-weight: 100;font-size:16px;"><asp:Localize runat="server" meta:resourcekey="str_WasLoc">Wasabi Locale</asp:Localize></td>
                        </tr>
                        <tr >
                            <td height="15px">
                                <asp:DropDownList ID="TextBoxAccessPoint" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList>
                                
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td style="height:40px">&nbsp;</td>
                        </tr>
                        <tr>
                            <td height="15px" style="color: #565656; font-weight: 100;font-size:14px;">
                                
                                <asp:Localize meta:resourcekey="asp_string3" runat="server">Access Key ID</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="TxtAccessKey" runat="server" Width="100%" meta:resourcekey="TxtAccessKeyResource1" CssClass="form-control"></asp:TextBox><br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key Required"
                                    ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td style="color: #565656; font-weight: 100;font-size:14px;">
                                <asp:Localize meta:resourcekey="asp_string4" runat="server">Secret Access Key</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td height="15px">
                                <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" meta:resourcekey="TxtSecretKeyResource1" CssClass="form-control"></asp:TextBox>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                    ErrorMessage="Secret Key Required" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:CheckBox ID="EnableInplaceVersion" runat="server" Checked="True"
                                                        Text="Enable Inplace Versioning" meta:resourcekey="EnableInplaceVersionResource1" 
                                                        /> 
                            </td>
                        </tr>
                        <tr style="display:none;">
                            <td>
                                <asp:CheckBox ID="NoBucketLB" runat="server" Checked="true" Text="This service does not support Bucket DNS" meta:resourcekey="asp_bktDnsNotSpt" />
                            </td>
                        </tr>
                        <%}
                          else
                          { %>
                        <tr>
                            <td>
                                <asp:Panel ID="PanelPickBucket" runat="server" meta:resourcekey="PanelPickBucketResource1">
                                    <table width="100%" border="0">
                                        <tr>
                                            <td style="color: #565656; font-weight: 100;font-size:14px;">
                                                <asp:Localize meta:resourcekey="asp_string5" runat="server">Select a Bucket</asp:Localize>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td height="32">
                                                <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" Width="100%" CssClass="browser-default custom-select secsubbordercolor"
                                                    OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged" meta:resourcekey="DropDownListBucketsResource1">
                                                    <asp:ListItem meta:resourcekey="ListItemResource1">{Test Connection First}</asp:ListItem>
                                                </asp:DropDownList>
                                                &nbsp;
                                                <br />
                                                <asp:Panel ID="PanelCreateBucket" runat="server" meta:resourcekey="PanelCreateBucketResource1">
                                                    <asp:Localize meta:resourcekey="asp_string6" runat="server">New Bucket Name</asp:Localize>
                                                    :<br />
                                                    <asp:TextBox ID="TxtNewBucket" runat="server" Width="100%" meta:resourcekey="TxtNewBucketResource1" CssClass="form-control"></asp:TextBox>
                                                </asp:Panel>
                                                <br />
                                            </td>
                                        </tr>   
                                        <%if (!PanelCreateBucket.Visible){ %>
                                        <tr>
                                            <td style="padding-left:30px;padding-top:0px;padding-bottom:20px;">
                                                <h3 style="color: #565656; font-weight: 100;font-size:14px;line-height: 28px;">
                                                    <asp:Localize meta:resourcekey="str_selSubFol" runat="server">Sub-Folder:</asp:Localize>
                                                </h3>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-left:30px;">
                                                <asp:TextBox ID="TxtSubFolder" runat="server" style="margin-top:-20px;" Width="100%" CssClass="form-control InputText secsubbordercolor" placeholder="folder1/folder2/" /><br />
                                                <p><label style="font-style:italic;line-height:18px;margin-top:-10px;">
                                                    (<asp:Localize meta:resourcekey="str_subFolHlp1" runat="server">Enter a case-sensitive virtual path of an existing folder inside the selected bucket.</asp:Localize><br />
                                                    <asp:Localize meta:resourcekey="str_subFolHlp2" runat="server">Leave it blank if you want to mount the whole bucket.</asp:Localize>)
                                                    </label></p>
                                            </td>
                                        </tr>
                                        <%} %>
                                        <tr>
                                            <td>
                                                <asp:Panel ID="PanelPickFolder" runat="server" meta:resourcekey="PanelPickFolderResource1">
                                                    <asp:Panel ID="PanelFolderDropDown" Visible="false" runat="server" meta:resourcekey="PanelFolderDropDownResource1">
                                                        <table width="100%" border="0">
                                                            <tr>
                                                                <td height="32" style="color: #565656; font-weight: 100;font-size:14px;">
                                                                    <asp:Localize meta:resourcekey="asp_string7" runat="server">Select a Folder (Leave it blank to select the root folder in the bucket)</asp:Localize>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <asp:DropDownList ID="DropDownListFolder" runat="server" Width="100%" meta:resourcekey="DropDownListFolderResource1" CssClass="browser-default custom-select secsubbordercolor">
                                                                    </asp:DropDownList>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </asp:Panel>
                                                </asp:Panel>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>
                            </td>
                        </tr>
                        <%} %>
                       
                    </table>
                </td>
            </tr>
            <tr>
                                        <td align="right">
                                            <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                                            <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                                            <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                                              { %>
                                            
                                                <asp:Button ID="Back1" runat="server"  CssClass="btn" CausesValidation="False" OnClick="Back_Click" meta:resourcekey="BackResource1"></asp:Button>
                                            
                                            <%} %>
                                            &nbsp;&nbsp;
                                                <asp:Button ID="LinkButtonNext1" runat="server"  OnClick="ButtonFinish_Click" CssClass="btn btn-primary gladbtn" meta:resourcekey="LinkButtonNextResource1"></asp:Button>
                                            &nbsp;&nbsp;
                                            <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                                              { %>
                                            
                                                <asp:Button ID="CancelBtn1" runat="server"  CssClass="btn" OnClick="CancelBtn_Click" CausesValidation="False" meta:resourcekey="CancelBtnResource1"></asp:Button>
                                            
                                            <%} 
                                              Back1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                              LinkButtonNext1.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                              CancelBtn1.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                            %>
                                            &nbsp;&nbsp;
                                        </td>
                                    </tr>
        </table>

                </td></tr></table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;display:none;
        border-bottom: 0; vertical-align: middle;">
          <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">

                                    
                                    
                                </table>
    </div>
</asp:Content>
