﻿<%@ Page
    Title="Gladinet Cloud - Setup OneDrive Account"
    Language="C#"
    MasterPageFile="StorageConfig.master"
    AutoEventWireup="true"
    CodeBehind="SharePointOnline.aspx.cs"
    Inherits="GladinetPayFlow.StorageConfig.SharePointOnline"
    Culture="auto"
    meta:resourcekey="PageResource1"
    ViewStateEncryptionMode="Always"
    UICulture="auto" %>
<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        * {
            margin: 0;
        }

        html, body {
            height: 100%;
        }

        .main, #aspnetForm, .tabpanel, .storagepanel, #Form2, div.textbox, .storagetd {
            height: 100%;
        }

        .wrapper {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 10px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
            overflow: auto;
        }

        .footer, .push {
            height: 68px; /* .push must be the same height as .footer */
        }

        .btndlg {
            min-width: 128px;
        }
        #chkUseRootRow label{margin-left: 7px;margin-top: 10px;}
    </style>

    <script type="text/javascript">
        (function (window) {

            var _dialog;
            function SetAuthCode(code) {

                var auth = $get('<%=AuthCode.ClientID%>');
                auth.value = code;
                _dialog.close();

                var refresh = $get('<%=RefreshSitesButton.ClientID%>');
                refresh.click();
            }

            function GetAuthCode() {
                var x = 200;
                var y = 100;

                try {
                    x = screen.width / 2 - 600 / 2;
                    y = screen.height / 2 - 500 / 2;
                } catch (e) {
                }

                var cdir = "<%=AuthorizeUri%>";
                var features = [
                    "location=yes",
                    "menubar=no",
                    "toolbar=no",
                    "width=600",
                    "height=500",
                    "left=" + x + "px",
                    "top=" + y + "px",
                ].join();

                _dialog = window.open(cdir, "_blank", features);
            }

            function SelectSite(element) {
                var refresh = $get('<%=RefreshLibrariesButton.ClientID%>');
                refresh.click();
            }

            function SelectFolder(element) {
                var url = element.getAttribute("data-url");
                var textbox = $get('<%= TextBoxAuthUrl.ClientID %>');
                textbox.value = url;
            }

            window.SetAuthCode = SetAuthCode;
            window.GetAuthCode = GetAuthCode;
            window.SelectFolder = SelectFolder;
            window.SelectSite = SelectSite;

        }(window));
    </script>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">  
<asp:Localize ID="LocTheSpeLibDoeNotExiOrIs" meta:resourcekey="str_theSpeLibDoeNotExiOrIs" runat="server" Visible="False">The specified library does not exist or is not accessible.</asp:Localize>
    <asp:ScriptManager ID="ScriptManager" runat="server"></asp:ScriptManager>
    <asp:Localize runat="server" ID="LocFaiToGetTokForSpeRes" meta:resourcekey="str_faiToGetTokForSpeRes" Visible="false">
        Failed to get token for specified resource
    </asp:Localize>
    <asp:Localize runat="server" ID="LocInvCod" meta:resourcekey="str_invCod" Visible="false">
        Invalid Code
    </asp:Localize>
    <div class="wrapper" style="padding: 10px;">
        <table width="100%">
            <tr>
                <td align="center" style="padding-top: 30px;">
                    <table width="100%" style="max-width: 800px;">
                        <tr>
                            <td align="left">
                                <table width="100%">
                                    <tr>
                                        <td width="80px">
                                            <img src="/webui/image128-gray/sharepoint_128.png" width="80px" />
                                        </td>
                                        <td align="left" style="padding-left: 15px;">
                                            <h3 style="color: #565656; font-weight: 100; font-size: 18px;" class="sectextcolor">
                                                <asp:Localize runat="server" meta:resourcekey="str_MicShaOnlAccCon">
                                                    Microsoft Sharepoint Online Account Configuration
                                                </asp:Localize>
                                            </h3>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>

                        <asp:UpdatePanel ID="LibrariesUpdatePanel" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                                <tr>
                                    <td colspan="3" style="padding-top: 15px">
                                        <h4 style="color: #565656; font-weight: 100!important; font-size: 16px;">
                                            <asp:Localize meta:resourcekey="str_get1" runat="server" Text="Please enter the authorization code" />
                                            (<a href="javascript:;" onclick='GetAuthCode();return false;'><asp:Localize meta:resourcekey="str_get2" runat="server" Text="Get Authorization Code" /></a>):
                                        </h4>
                                        <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                                            { %>
                                        <asp:Label ID="ErrorMsg" runat="server" Style="" CssClass="errmsg"
                                            meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                        <%} %>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <table width="100%">
                                            <tr>
                                                <td>
                                                    <asp:TextBox ID="AuthCode" runat="server" Width="100%" CssClass="form-control" meta:resourcekey="AuthCodeResource1" />
                                                </td>
                                                <td style="width:1%">
                                                    
                                            <asp:Button ID="RefreshSitesButton" runat="server" Text="Authorize" CssClass="btn gladbtn" OnClick="RefreshSitesButton_Click" />
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="padding: 10px; padding-top: 30px; padding-bottom: 30px;">
                                        <div class="alert alert-info">
                                            <asp:Localize meta:resourcekey="str_gethint" runat="server" Text="Click on 'Get Authorization Code' to be directed to the OneDrive login page. After you grant access, please copy-and-paste the authorization code on the input box above if it is not filled-in automatically."></asp:Localize>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="font-weight: 100; color: #565656; font-size: 14px;">
                                        <asp:Panel ID="PanelEndpoint" runat="server">

                                            <div runat="server" id="SitesDiv" visible="false">
                                                <h4 style="color: #565656; font-weight: 100!important; font-size: 16px;">
                                                    <asp:Localize meta:resourcekey="str_shrPntSiteName" runat="server">SharePoint site</asp:Localize>
                                                </h4>
                                                <select
                                                    runat="server"
                                                    id="SitesSelect"
                                                    class="form-control w-100 mb-5"
                                                    DataTextField="Name"
                                                    DataValueField="Value"
                                                    onchange="SelectSite(this);"
                                                    >
                                                </select>
                                            </div>

                                            <h4 style="color: #565656; font-weight: 100!important; font-size: 16px;">
                                                <asp:Localize
                                                    runat="server"
                                                    meta:resourcekey="str_shrPntFolderPath"
                                                    Text="Library Web Address (e.g.: https://mysharepoint.sharepoint.com/sites/mysite/documentLibrary)"
                                                    />
                                            </h4>

                                            <asp:Button ID="RefreshLibrariesButton" runat="server" Style="display: none" OnClick="RefreshLibrariesButton_Click" />
                                            <div class="dropdown">
                                                <div class="input-group">
                                                    <div id="DropdownToggle" runat="server" class="input-group-prepend" data-toggle="dropdown" visible="false">
                                                        <button class="btn dropdown-toggle">Select</button>
                                                    </div>
                                                    <asp:TextBox ID="TextBoxAuthUrl" runat="server" CssClass="form-control"></asp:TextBox>

                                                    <asp:Repeater ID="LibrariesRepeater" runat="server" Visible="false">
                                                        <HeaderTemplate>
                                                            <div class="dropdown-menu w-100 shadow" style="overflow-y: auto; max-height: 25vh">
                                                        </HeaderTemplate>
                                                        <FooterTemplate>
                                                            </div>
                                                        </FooterTemplate>
                                                        <ItemTemplate>
                                                            <a
                                                                class="dropdown-item"
                                                                href="##"
                                                                data-url="<%# Eval("Value") %>"
                                                                onclick="SelectFolder(this);"
                                                                style="max-width: unset">
                                                                <i class="gladinet-icons" style="margin-right: .5rem">f</i>
                                                                <span><%# Eval("Name") %></span>
                                                            </a>
                                                        </ItemTemplate>
                                                    </asp:Repeater>

                                                </div>
                                                <div class="input-group" id="chkUseRootRow">
                                                    <asp:CheckBox ID="chkUseRoot" AutoPostBack="true" OnCheckedChanged="chkUseRoot_CheckedChanged" runat="server" Text="Use Sharepoint Root (if unchecked, it will use the default Shared Documents as the root)" meta:resourcekey="str_useShrPntRot" />
                                                </div>
                                            </div>
                                        </asp:Panel>
                                    </td>
                                </tr>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                        <tr>
                            <td align="right" style="padding-right: 0px;">
                                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
                                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>

                                <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                                    { %>
                                <asp:Button
                                    ID="Back"
                                    runat="server"
                                    Text="Back"
                                    Width="128px"
                                    CssClass="btn btn-default"
                                    CausesValidation="False"
                                    OnClick="Back_Click"
                                    OnClientClick="Wait('<%=LocApyChg.Text%>')"
                                    meta:resourcekey="BackResource1" />
                                <%} %>
                                <asp:Button
                                    ID="LinkButtonNext"
                                    runat="server"
                                    Text="Finish"
                                    Width="128px"
                                    OnClick="ButtonFinish_Click"
                                    OnClientClick="Wait('<%=LocApyChg.Text%>')"
                                    CssClass="btn btn-primary gladbtn"
                                    meta:resourcekey="LinkButtonNextResource1" />
                                <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                                    { %>
                                <asp:Button
                                    ID="CancelBtn"
                                    runat="server"
                                    Text="Cancel"
                                    Width="128px"
                                    CssClass="btn btn-default"
                                    OnClick="CancelBtn_Click"
                                    OnClientClick="Wait('<%=LocPlsWat.Text%>')"
                                    CausesValidation="False"
                                    meta:resourcekey="CancelBtnResource1" />
                                <%} %>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; display: none; border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;" align="right">
        </table>
    </div>
</asp:Content>
