﻿<%@ Page Title="Gladinet Cloud - Setup SharePoint Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="SharePoint.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.SharePoint" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm, .tabpanel, .storagepanel, #Form2, div.textbox, .storagetd
        {
            height: 100%;
        }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
            overflow: auto;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div class="wrapper">
        <table width="100%">            <tr> <td align="center" style="padding-top:30px;">
        <table width="100%" align="center" style="background: WHITE; padding: 15px; max-width:800px;" cellspacing="0"
            id="input_panel">
            <tr>
                <td>
                    <table width="100%">
                        <tr>
                            <td width="80px">
                                <img src="/webui/image128-gray/sharepoint_128.png" width="80px" />
                            </td>
                            <td>
                                <h3 style="font-weight: 100; color: #404040;">
                                    <asp:Localize meta:resourcekey="str_shrPntActInf" runat="server">SharePoint Account Information</asp:Localize></h3>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; padding-top: 20px;vertical-align: top;">
                    <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                       { %>
                    <asp:Label ID="ErrorMsg" runat="server" Style="" CssClass="errmsg"></asp:Label>
                    <%} %>
                    <table width="100%" align="center">
                        <tr>
                            <td>
                                <asp:Panel ID="PanelEndpoint" runat="server">
                                   <h4 style="color: #565656; font-weight:100; "> <asp:Localize meta:resourcekey="str_shrPntSteUrl" runat="server">SharePoint Site URL</asp:Localize> (http://mysharepoint.com or http://mysharepoint.com/mysite)</h4>
                                    <br />
                                    <asp:TextBox ID="TextBoxAuthUrl" runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                                </asp:Panel>
                            </td>
                        </tr>
                        <tr><td style="height:10px;">&nbsp;</td></tr>
                        <tr>
                            <td height="15px">
                                <h4 style="color: #565656; font-weight:100; ">
                                <asp:Localize meta:resourcekey="str_usrNme" runat="server">User Name (Leave blank, if authentication is not needed)</asp:Localize>
                                    </h4>
                            </td>
                        </tr>
                        <tr>
                            <td align="left">
                                <asp:TextBox ID="TxtUsername" runat="server" Width="100%" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                        <tr><td style="height:10px;">&nbsp;</td></tr>
                        <tr>
                            <td>
                                <h4 style="color: #565656; font-weight:100; ">
                                <asp:Localize meta:resourcekey="str_pwd" runat="server">Password</asp:Localize>
                                    </h4>
                            </td>
                        </tr>
                        <tr>
                            <td height="15px" align="left">
                                <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                        <tr><td style="height:10px; ">&nbsp;</td></tr>
                        <%if (SessionIsInstalledApp)
                          { %>
                        <tr>
                            <td>
                                <asp:CheckBox ID="ImpersonationMode" runat="server" Text="Access with login AD user identity" meta:resourcekey="str_acsWthLgnAdUsrIdy" />
                            </td>
                        </tr>
                        <%} %>
                    </table>
                </td>
                </tr>
             <tr>
                <td align="right">
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                    <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                      { %>
                        <asp:Button ID="Back" runat="server" CssClass="btn" CausesValidation="false" OnClick="Back_Click" Text="Back" meta:resourcekey="asp_bck"></asp:Button>
                    <%} %>
                    &nbsp;&nbsp;
                        <asp:Button ID="LinkButtonNext" runat="server" 
                            OnClick="ButtonFinish_Click"  CssClass="btn btn-primary gladbtn" Text="Finish" meta:resourcekey="asp_fns"></asp:Button>
                    &nbsp;&nbsp;
                    <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                      { %>
                        <asp:Button ID="CancelBtn" runat="server" 
                            CssClass="btn" OnClick="CancelBtn_Click" CausesValidation="false" Text="Cancel" meta:resourcekey="asp_cnl"></asp:Button>
                    &nbsp;&nbsp;
                    <%} %>
                    <%
                      Back.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                      LinkButtonNext.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                      CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    %>
                </td>
            </tr>
        </table>
            </td></tr></table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; display:none;
        border-bottom: 0; vertical-align: middle;">
        <table width="100%" style="height: 64px; text-align: right; padding-right: 64px;"
            align="right">
           
        </table>
    </div>
</asp:Content>
