﻿<%@ Page Title="Gladinet Cloud - Setup Azure Blob Account" Language="C#" MasterPageFile="StorageConfig.master"
    AutoEventWireup="true" CodeBehind="AzureFiles.aspx.cs" Inherits="GladinetPayFlow.StorageConfig.AzureFiles" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .x-form-text
        {
        }
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocCon" meta:resourcekey="str_con" Visible="false" runat="server">Continue</asp:Localize>
    <table width="100%" align="center" style="background: WHITE; padding: 15px;" cellspacing="0"
        id="input_panel">
        <tr>
            <td>
                <table width="100%">
                    <tr>
                        <td width="80px">
                            <img src="../images/azure.png" width=80px />
                        </td>
                        <td>
                            <h2><asp:Localize meta:resourcekey="str_azrFil" runat="server">Azure Files Account Information</asp:Localize>
                                </h2>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td style="padding: 10px; vertical-align: top;">
                <% if (!string.IsNullOrEmpty(ErrorMsg.Text))
                   { %>
                <asp:Label ID="ErrorMsg" runat="server" Style="" CssClass="errmsg" 
                    meta:resourcekey="ErrorMsgResource1"></asp:Label>
                <%} %>
                <table width="100%" align="center" >
                    <%if (FirstStage)
                      { %>
                    <tr>
                        <td  style="font-size: 18px; color: #565656; padding-top: 10px; font-weight: 100;">
                         <asp:Localize meta:resourcekey="asp_string2" runat="server">Blob URL</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:TextBox ID="TxtAccessKey" runat="server" Width="100%" 
                                meta:resourcekey="TxtAccessKeyResource1" CssClass="form-control"></asp:TextBox><br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="Access Key is Required"
                                ControlToValidate="TxtAccessKey" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; color: #565656; padding-top: 10px; font-weight: 100;">
                            <asp:Localize meta:resourcekey="str_actNme" runat="server">Account Name</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtAccountName" runat="server" Width="100%" 
                                meta:resourcekey="TxtSecretKeyResource1" CssClass="form-control"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="TxtAccountName"
                                ErrorMessage="Account Name is Required" ForeColor="#CC0000" CssClass="errmsg" meta:resourcekey="asp_actNmeReq" 
                                ></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: 18px; color: #565656; padding-top: 10px; font-weight: 100;">
                            <asp:Localize meta:resourcekey="asp_string3" runat="server">Primary Access Key</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td height="15px">
                            <asp:TextBox ID="TxtSecretKey" runat="server" Width="100%" TextMode="Password" 
                                meta:resourcekey="TxtSecretKeyResource1" CssClass="form-control"></asp:TextBox>
                            <br />
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtSecretKey"
                                ErrorMessage="Secret Key is Required" ForeColor="#CC0000" CssClass="errmsg" 
                                meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <%}
                      else
                      { %>
                    <tr>
                        <td>
                            <asp:Panel ID="PanelPickBucket" runat="server" 
                                meta:resourcekey="PanelPickBucketResource1">
                                <table width="100%" border="0">
                                    <tr>
                                        <td style="font-size: 18px; color: #565656; padding-top: 10px; font-weight: 100;">
                                            <asp:Localize meta:resourcekey="asp_string4" runat="server">Select a Container:</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:DropDownList ID="DropDownListBuckets" runat="server" AutoPostBack="True" 
                                                OnSelectedIndexChanged="DropDownListBuckets_SelectedIndexChanged" 
                                                meta:resourcekey="DropDownListBucketsResource1">
                                                <asp:ListItem meta:resourcekey="ListItemResource1">{Test Connection First}</asp:ListItem>
                                            </asp:DropDownList>
                                            &nbsp;
                                            <br />
                                            <asp:Panel ID="PanelCreateBucket" runat="server" 
                                                meta:resourcekey="PanelCreateBucketResource1">
                                                <div class='idea' style="width: 408px;">
                                                    <asp:Localize meta:resourcekey="asp_string5" runat="server">For SSL, your container name should not contain any periods. In addition, the container name must be all lower case and cannot be $root.</asp:Localize>
                                                    <br />
                                                </div>
                                                <asp:Panel ID="Panel1" runat="server" GroupingText="Create Container" 
                                                    meta:resourcekey="Panel1Resource1">
                                                    <asp:Localize meta:resourcekey="asp_string6" runat="server">New Container Name (all lower case):</asp:Localize>&nbsp;
                                                    <asp:TextBox ID="TxtNewBucket" runat="server" Width="100%" 
                                                        CssClass="form-control" meta:resourcekey="TxtNewBucketResource1"></asp:TextBox>
                                                    <br />
                                                    <table width='100%'>
                                                        <tr>
                                                            <td width="50%">
                                                                &nbsp;
                                                            </td>
                                                            <td width="50%">
                                                                &nbsp;
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </asp:Panel>
                                            </asp:Panel>
                                            <br />
                                        </td>
                                    </tr>
                                </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <%} %>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                    </tr>
                    <tr>
                        <td align="center">
                            <table>
                                <tr>
                                    <td colspan="3" height="20px">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center">
                                        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                                        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                                        <%if (!string.IsNullOrEmpty(StorageConfigBackPage))
                                          { %>
                                        <div class="">
                                            <asp:LinkButton ID="Back" runat="server" Font-Bold="True" Font-Size="16px" 
                                                 CssClass="btn" CausesValidation="False" OnClick="Back_Click" 
                                                meta:resourcekey="BackResource1">Back</asp:LinkButton>
                                        </div>
                                        <%} %>
                                    </td>
                                    <td>
                                        <div class="">
                                            <asp:LinkButton ID="LinkButtonNext" runat="server" Font-Bold="True" Font-Size="16px"
                                                OnClick="ButtonFinish_Click" CssClass="btn btn-primary gladbtn" meta:resourcekey="LinkButtonNextResource1">Finish</asp:LinkButton>
                                        </div>
                                    </td>
                                    <td>
                                        <%if (!string.IsNullOrEmpty(StorageConfigCancelPage))
                                          { %>
                                        <div class="">
                                            <asp:LinkButton ID="CancelBtn" runat="server" Font-Bold="True" Font-Size="16px" CssClass="btn" OnClick="CancelBtn_Click" CausesValidation="False" 
                                                meta:resourcekey="CancelBtnResource1">Cancel</asp:LinkButton>
                                        </div>
                                        <%} 
                                          Back.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          LinkButtonNext.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                                          CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                                        %>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
    </table>
</asp:Content>
