﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="../WebAppPanel.master" ValidateRequest="false" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ServoUpgradeBiz.aspx.cs" Inherits="GladinetPayFlow.ServoUpgradeBiz"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">


    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }

        .pricing-box {
	max-width: 430px;
	margin-left: auto;
	margin-right: auto;
	font-size: 1.0625rem;
	border: 1px solid #e8e8e9;
	border-radius: 0.375rem;
}

.pricing-box-header {
	padding: 20px 15px 0;
	border-top-left-radius: 0.375rem;
	border-top-right-radius: 0.375rem;
}

.pricing-box-label {
	font-weight: 400;
}

.pricing-box-divider {
	border-bottom: 1px solid #e8e8e9;
}

.pricing-box-body {
	padding: 20px 15px;
}

.pricing-box-postfix {
	font-size: .35em;
}

.pricing-box-value {
	font-size: 4.125rem;
	font-weight: 400;
	line-height: 1.2;
	color: #171724;
}

.pricing-box-value-meta {
	color: #56a700;
	font-weight: 400;
}

.pricing-box-list {
	list-style-type: circle;
	padding-left: 0;
    margin-left:30px;
}

.pricing-box-list > li + li {
	margin-top: 9px;
}

.pricing-box-list-icon {
	padding-right: 0.7em;
	font-size: 1.575rem;
	vertical-align: middle;
}

.pricing-box-links {
	text-align: center;
}

.pricing-box-link {
	padding-left: 0.3em;
	font-weight: 400;
	color: #56a700;
}

.pricing-box-link:hover, .pricing-box-link:focus {
	color: #aeaeb2;
}

* + .pricing-box-title {
	margin-top: 6px;
}

* + .pricing-box-divider {
	margin-top: 15px;
}

* + .pricing-box-list {
	margin-top: 15px;
}

* + .pricing-box-btn {
	margin-top: 15px;
}

* + .pricing-box-links {
	margin-top: 15px;
}

.pricing-box-filled {
	background-color: #f7f7f7;
	border: none;
}

[class*='pricing-box-accent-'] {
	border: none;
	box-shadow: 5px 8px 28px rgba(23, 23, 36, 0.1);
}

[class*='pricing-box-accent-'] .pricing-box-title {
	color: inherit;
}

[class*='pricing-box-accent-'] .pricing-box-divider {
	border-color: transparent;
}

.pricing-box-accent-primary .pricing-box-header {
	color: #fff;
	background-color: #f68e2a;
}

.pricing-box-accent-secondary .pricing-box-header {
	color: #fff;
	background-color: #56a700;
}

.pricing-box-accent-success .pricing-box-header {
	color: #fff;
	background-color: #77BA21;
}

.pricing-box-accent-info .pricing-box-header {
	color: #fff;
	background-color: #138CE4;
}

.pricing-box-accent-warning .pricing-box-header {
	color: #fff;
	background-color: #F19711;
}

.pricing-box-accent-danger .pricing-box-header {
	color: #fff;
	background-color: #E72660;
}

.pricing-box-accent-light .pricing-box-header {
	color: #171724;
	background-color: #f7f7f7;
}

.pricing-box-accent-dark .pricing-box-header {
	color: #fff;
	background-color: #171724;
}

@media (min-width: 1600px) {
	.pricing-box-header {
		padding: 32px 40px 0;
	}
	.pricing-box-body {
		padding: 36px 40px 39px;
	}
	.pricing-box-list > li + li {
		margin-top: 18px;
	}
	* + .pricing-box-title {
		margin-top: 12px;
	}
	* + .pricing-box-subtitle {
		margin-top: 8px;
	}
	* + .pricing-box-divider {
		margin-top: 20px;
	}
	* + .pricing-box-list {
		margin-top: 39px;
	}
	* + .pricing-box-btn {
		margin-top: 41px;
	}
	* + .pricing-box-links {
		margin-top: 22px;
	}
	.pricing-box-accent .pricing-box-header {
		padding: 40px 40px 0;
	}
}

.pricing-column {
	max-width: 300px;
	margin-left: auto;
	margin-right: auto;
	padding: 20px 15px;
	font-size: 1.0625rem;
	border: 1px solid #e8e8e9;
}

.pricing-column-label {
	display: inline-block;
	padding: 2px 10px;
	font-size: 0.93188rem;
	font-weight: 500;
	color: #fff;
	background-color: #56a700;
	border-radius: 0.2rem;
}

.pricing-column-divider {
	border-bottom: 2px solid #171724;
}

.pricing-column-value {
	font-size: 2.875rem;
	line-height: 1.2;
	font-weight: 400;
	color: #171724;
}

.pricing-column-postfix {
	font-size: .55em;
}

.pricing-column-value-meta {
	color: #56a700;
	font-weight: 400;
}

.pricing-column-links {
	text-align: center;
}

.pricing-column-link {
	padding-left: 0.3em;
	font-weight: 400;
	color: #56a700;
}

.pricing-column-link:hover, .pricing-column-link:focus {
	color: #aeaeb2;
}

* + .pricing-column-title {
	margin-top: 6px;
}

* + .pricing-column-divider {
	margin-top: 15px;
}

* + .pricing-column-value {
	margin-top: 25px;
}

* + .pricing-column-list {
	margin-top: 15px;
}

* + .pricing-column-btn {
	margin-top: 15px;
}

* + .pricing-column-links {
	margin-top: 15px;
}

.pricing-column-accent {
	position: relative;
	z-index: 1;
	border: none;
	background-color: #fff;
	box-shadow: 5px 8px 28px rgba(23, 23, 36, 0.1);
}

@media (min-width: 992px) {
	.pricing-column {
		margin-left: -1px;
	}
	.pricing-column-accent {
		margin: -40px -1px 0;
		padding-bottom: 70px;
	}
}

        @media (min-width: 1600px) {
            .pricing-column {
                padding: 35px 40px;
            }

            .pricing-column-accent {
                padding: 35px 40px 70px;
            }

            * + .pricing-column-title {
                margin-top: 11px;
            }

            * + .pricing-column-subtitle {
                margin-top: 2px;
            }

            * + .pricing-column-divider {
                margin-top: 14px;
            }

            * + .pricing-column-value {
                margin-top: 35px;
            }

            * + .pricing-column-list {
                margin-top: 26px;
            }

            * + .pricing-column-btn {
                margin-top: 36px;
            }

            * + .pricing-column-links {
                margin-top: 22px;
            }




            .card-img-top {
                display: none;
            }
        }
    </style>
    <script type="text/javascript">

        function ReturnLast() {

              <%if (IsChildUi)
        { %>
            try {
                parent.CloseLeftMain();
            } catch (ex) { }

            <% if (IsServo) { %>
            window.location = "/management/Servo/ServoLicense.aspx";
            <% } %>

            return;
            <%}%>
            window.location = "/management/clustermgrconsole";
        }

    </script>
 
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToUpg" meta:resourcekey="str_faiToUpg" Visible="false">Failed to upgrade</asp:Localize>
<asp:Localize runat="server" ID="LocNotABusEdiLicStr" meta:resourcekey="str_notABusEdiLicStr" Visible="false">Not a business edition licene string</asp:Localize>
<asp:Localize runat="server" ID="LocLicStrIsEmp" meta:resourcekey="str_licStrIsEmp" Visible="false">License string is empty</asp:Localize>
    <asp:Localize ID="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>
    <% if (!IsChildUi)
        { %>
    <div style="width: 100%; padding: 5px;" class="mblue800">
        <table style="width: 100%">
            <tr>
                <td style="height: 64px">
                    <table>
                        <tr>
                            <td valign="middle">
                                <img src="images/fulllogow.png" />
                            </td>
                            <td style="width: 55px; height: 68px!important; color: white !important; font-weight: 800; font-size: 24px; color: white; display: none;" valign="middle"><asp:Localize runat="server" meta:resourcekey="str_tri">Triofox</asp:Localize></td>

                        </tr>

                    </table>
                </td>

                <td style="padding-right: 10px;"></td>
            </tr>
        </table>
    </div>
    <%} %>

    <div style="background-color: white; width: 100%; margin-top: 30px; font-size: 18px; align-content: center; ">







        <asp:Panel ID="DefaultPanel" runat="server">

            <section class="section-lg bg-transparent">
                <div class="container">

                    <div class="plans">


                        <div class="switch-inner">
                            <div class="row row-30 no-gutters">
                                <div class="col-lg-4">
                                    <div class="pricing pricing-box pricing-box-filled">
                                        <div class="pricing-box-header">
											<div class="pricing-box-label"><br></div>
                                            <div class="pricing-box-title h3"><asp:Localize runat="server" meta:resourcekey="str_off">Office</asp:Localize></div>
                                            <div class="pricing-box-subtitle lead">For the Small Office</div>
                                            <p>&nbsp;</p>
                                            <p>&nbsp;</p>
                                            <div class="pricing-box-divider"></div>
                                        </div>
                                        <div class="pricing-box-body">
                                            <div class="pricing-box-value">
                                                $11<span class="pricing-box-postfix">/user/month</span>
                                            </div>
                                            <div class="pricing-box-value-meta">Billed up-front annually</div>
                                            <ul class="pricing-box-list">
                                              <li>Web Based File Manager</li>
                                              <li>Windows Mapped Drive</li>
                                              <li>In-place Version</li>
                                              <li>2-Factor Authentication</li>
                                              <li>File Change Log</li>
                                              <li>Mac Finder Integration</li>
                                              <li>iOS Application</li>
                                              <li>Android Application</li>
                                              <li>File Locking</li>
                                              <li>Standard Support</li>
                                            </ul>

                                            <div class="pricing-box-links"><span></span><a class="pricing-box-link" href="#"></a></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="pricing pricing-box pricing-box-accent-secondary">
                                        <div class="pricing-box-header">
                                            <div class="pricing-box-label"><asp:Localize runat="server" meta:resourcekey="str_mosPop">Most popular</asp:Localize></div>
                                            <div class="pricing-box-title h3"><asp:Localize runat="server" meta:resourcekey="str_bus">Business</asp:Localize></div>
                                            <div class="pricing-box-subtitle lead">For Mature Companies</div>
                                            <div class="pricing-box-subtitle lead">Requiring Higher Security</div>
                                            <p>&nbsp;</p>
                                            <div class="pricing-box-divider"></div>
                                        </div>
                                        <div class="pricing-box-body">
                                            <div class="pricing-box-value">
                                                $15<span class="pricing-box-postfix">/user/month</span>
                                            </div>
                                            <div class="pricing-box-value-meta">Billed up-front annually</div>
                                            <ul class="pricing-box-list">
                                              <li><b>All Office Edition Features Plus</b></li>
                                              <li>Version Control</li>
                                              <li>Ransomware Protection</li>
                                              <li>Audit Trace</li>
                                              <li>SAML Integration</li>
                                              <li>Single Sign-On</li>
                                              <li>Secure Data Room</li>
                                              <li>Retention Policy</li>
                                              <li>Device Approval</li>
                                              <li>Standard Support</li>
                                            </ul>

                                            <div class="pricing-box-links"><span></span><a class="pricing-box-link" href="#"></a></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="pricing pricing-box pricing-box-filled">
                                        <div class="pricing-box-header">
											<div class="pricing-box-label"><br></div>
                                            <div class="pricing-box-title h3"><asp:Localize runat="server" meta:resourcekey="str_ent">Enterprise</asp:Localize></div>
                                            <div class="pricing-box-subtitle lead">For Enterprise Organizations</div>
                                            <div class="pricing-box-subtitle lead">With More Complex</div>
                                            <div class="pricing-box-subtitle lead">Technical Requirements</div>
                                            <div class="pricing-box-divider"></div>
                                        </div>
                                        <div class="pricing-box-body">
                                            
                                            <div class="pricing-box-value">
                                                $22<span class="pricing-box-postfix">/user/month</span>
                                            </div>
                                            <div class="pricing-box-value-meta">Billed up-front annually</div>
                                            <ul class="pricing-box-list">
                                              <li><b>All Business Edition Features Plus</b></li>
                                              <li>Private or Public Cloud Backup</li>
                                              <li>Private or Public Cloud Migration</li>
                                              <li>Compliance Center</li>
                                              <li>Customization</li>
                                              <li>Premium Support</li>
                                            </ul>
                                            <p style="height:135px;">&nbsp;</p>

                                            <div class="pricing-box-links"><span></span><a class="pricing-box-link" href="#"></a></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>



                    </div>
                </div>
            </section>



        </asp:Panel>

        <asp:Panel ID="CloudMigPanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_cloMig">Cloud Migration</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_entEdi">Enterprise Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_witCloMigLocFil">With cloud migration, local file server network shares can be migrated to local private cloud or remote public cloud.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted">
                    <asp:Localize runat="server" meta:resourcekey="str_reqBusEdiMsg">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition. Click</asp:Localize>
                    <asp:LinkButton ID="LinkButton25" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toSeeBusEdiCli">to see full features in business edition, click</asp:Localize>
                    <asp:LinkButton ID="LinkButton26" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toUpgTo">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton27" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>

        <asp:Panel ID="BackupPanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_CloBac">Cloud Backup</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_entEdi">Enterprise Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_witCloBacLocFil">With cloud backup, local file server network shares and folders from remote devices can be backup to local private cloud or remote public cloud.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted">
                    <asp:Localize runat="server" meta:resourcekey="str_reqEntEdiMsg">The feature you requested requires Enterprise Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition. Click</asp:Localize>
                    <asp:LinkButton ID="LinkButton22" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toSeeEntEdiCli">to see full features in enterprise edition, click</asp:Localize>
                    <asp:LinkButton ID="LinkButton23" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toUpgTo">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton24" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>
        <asp:Panel ID="RestorePanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_DisRec">Disaster Recovery</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_witDisRecFilAnd">With disaster recovery, files and folders can be restored from local repository or cloud repository.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted">
                    <asp:Localize runat="server" meta:resourcekey="str_reqBusEdiMsg">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition. Click</asp:Localize>
                    <asp:LinkButton ID="LinkButton19" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toSeeBusEdiCli">to see full features in business edition, click</asp:Localize>
                    <asp:LinkButton ID="LinkButton20" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toUpgTo">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton21" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>

        <asp:Panel ID="ChangeLogPanel" runat="server" Visible="false" CssClass="d-flex r justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_AudTra">Audit Trail</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_witAudTraAndFil">With audit trace and file change logs, you can see the activity recorded in the solution for forensic analysis.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted">
                    <asp:Localize runat="server" meta:resourcekey="str_reqBusEdiMsg">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition. Click</asp:Localize>
                    <asp:LinkButton ID="LinkButton16" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toSeeBusEdiCli">to see full features in business edition, click</asp:Localize>
                    <asp:LinkButton ID="LinkButton17" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toUpgTo">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton18" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>

        <asp:Panel ID="AdvancedSecurity" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_AdvSecCon">Advanced Security Controls</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_witAdvSecConYou">With advanced security controls, you can setup secure data room,  define IP white list, and control other advanced security related aspects of the solutions.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted">
                    <asp:Localize runat="server" meta:resourcekey="str_reqBusEdiMsg">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition. Click</asp:Localize>
                    <asp:LinkButton ID="LinkButton13" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toSeeBusEdiCli">to see full features in business edition, click</asp:Localize>
                    <asp:LinkButton ID="LinkButton14" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toUpgTo">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton15" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>

        <asp:Panel ID="InplaceVersionPanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/protection_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_VerConInPla">Version Control In Place</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text">
                        <asp:Localize runat="server" meta:resourcekey="str_verConMonChaFil">Version control monitors changes to files and maintain revision history for administrators and end users. It enhances user productivity when they can see past revisions easily.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted">
                    <asp:Localize runat="server" meta:resourcekey="str_reqBusEdiMsg">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition. Click</asp:Localize>
                    <asp:LinkButton ID="LinkButton10" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toSeeBusEdiCli">to see full features in business edition, click</asp:Localize>
                    <asp:LinkButton ID="LinkButton11" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_toUpgTo">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton12" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>

        <asp:Panel ID="RansomewarePanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/ransom_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_RanPro">Ransomware Protection</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_turBehAnaComRan">Turn on behavioral analysis to combat ransomware. Devices that are trying to modify files in a wild way will be detected and stopped before the damage becomes widespread.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted"><asp:Localize runat="server" meta:resourcekey="str_feaYouReqReqBus">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition.</asp:Localize>
                    
                   
                    
                    <asp:LinkButton ID="LinkButton3" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_her">Click here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_seeFulFeaBusEdi">to see full features in business edition,</asp:Localize>  
                    <asp:LinkButton ID="UpgradeBiz" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_her">click here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_upg">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton1" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>

        </asp:Panel>

        <asp:Panel ID="MFAPanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_2stVerMFA">2-Step Verification (MFA)</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_wit2StVerYouPro">With 2-Step Verification, you’ll protect your account with both your password and authenticator apps from your phone</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted"><asp:Localize runat="server" meta:resourcekey="str_feaYouReqReqBus">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition.</asp:Localize>

                <asp:LinkButton ID="LinkButton4" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_cliHer">Click here</asp:LinkButton>
                  <asp:Localize runat="server" meta:resourcekey="str_seeFulFeaBusEdi">to see full features in business edition,</asp:Localize> 
                <asp:LinkButton ID="LinkButton6" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_cliHer">click here</asp:LinkButton>
                   <asp:Localize runat="server" meta:resourcekey="str_upg">to upgrade to</asp:Localize>
                <asp:LinkButton ID="LinkButton7" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                   <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize>
                </div>
            </div>


        </asp:Panel>
        <asp:Panel ID="SAMLPanel" runat="server" Visible="false" CssClass="d-flex justify-content-center">
            <div class="card align-self-center" style="max-width: 800px;">
                <img class="card-img-top" src="images/security_header.jpg" alt="Card image cap">
                <div class="card-body">
                    <h5 class="card-title"><asp:Localize runat="server" meta:resourcekey="str_sinSigSAMInt">Single Sign on (SAML Integration)</asp:Localize></h5>
                    <span class="badge badge-secondary"><asp:Localize runat="server" meta:resourcekey="str_busEdi">Business Edition</asp:Localize></span>
                    <p class="card-text"><asp:Localize runat="server" meta:resourcekey="str_sinSigSSOOccWhe">Single Sign-on (SSO) occurs when a user logs in to Azure, Active Directory or other identity service provider and is then signed in here automatically.
                        The user signs in only one time to your existing identity service.</asp:Localize></p>
                    <br />
                    <table width="100%" style="max-width: 800px;" align="center">

                        <tr>
                            <td style="font-size: 14px; font-weight: 100; color: #565656;" align="center"></td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer text-muted"><asp:Localize runat="server" meta:resourcekey="str_feaYouReqReqBus">The feature you requested requires Business Edition subscription. Upgrade now to enjoy the feature and other features can only be found with Business Edition.</asp:Localize>
                    
                   
                    
                    <asp:LinkButton ID="LinkButton5" runat="server" OnClick="Fullfeature_Click" meta:resourcekey="str_cliHer">Click here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_seeFulFeaBusEdi">to see full features in business edition,</asp:Localize>  
                    <asp:LinkButton ID="LinkButton8" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_cliHer">click here</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_upg">to upgrade to</asp:Localize>
                    <asp:LinkButton ID="LinkButton9" runat="server" OnClick="EntEdition_Click" meta:resourcekey="str_entEdi">Enterprise Edition</asp:LinkButton>
                    <asp:Localize runat="server" meta:resourcekey="str_forMorFun">for more functionality!</asp:Localize></div>
            </div>


        </asp:Panel>

        <table width="100%" style="max-width: 800px;" align="center">
            <tr>
                <td style="height: 20px;" ></td>
            </tr>
            <tr>
                <td align="center" style="padding: 10px;">

                    <table>
                        <tr>
                            <td style="padding: 5px; font-size: 18px; font-weight: 100; color: #404040;">
                                <%if (LicenseStringPanel.Visible)
                                    { %>
                                  <asp:Localize runat="server" meta:resourcekey="str_youHavNewLicStr">If you have a new license string, enter below:</asp:Localize>
                                <%}
                                    else
                                    { %>
                                    <asp:Localize runat="server" meta:resourcekey="str_entLicStrBelYou">Enter license string below, if you don't have a license string leave it blank:</asp:Localize>
                                <%} %>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; font-size: 18px; font-weight: 100; color: #404040;">
                                <asp:TextBox ID="LicenseString" runat="server" Width="500px" CssClass="form-control"></asp:TextBox>
                            </td>
                        </tr>
                    </table>
                    <%if(!IsMobile()) { %>
                        <table>
                            <tr>

                                <td style="font-size: 12px; font-weight: 100; color: #565656;" nowrap="nowrap"><asp:Localize runat="server" meta:resourcekey="str_clu">Cluster Id:</asp:Localize></td>
                                <td style="padding: 5px; font-size: 12px; font-weight: 100; color: #565656;" class="sectextcolor">
                                    <asp:Label ID="ClusterId" runat="server"></asp:Label>
                                </td>
                            </tr>
                        </table>
                        <%} %>
                </td>
            </tr>

            <tr>
                <td align="center" style="padding: 10px; font-size: 18px; font-weight: 400; padding-top: 40px;">
                    <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                </td>
            </tr>
            <tr>
                <td style="padding-top: 5px;" align="center">
                    <asp:LinkButton CssClass="btn  btn-primary gladbtn " ID="LinkButton28" runat="server" OnClick="Step1Contine_Click" meta:resourcekey="str_upg1">Upgrade</asp:LinkButton>
                    <asp:LinkButton CssClass="btn btn-default gladbtn " ID="CancelBtn" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Panel ID="LicenseStringPanel" runat="server"></asp:Panel>
                </td>
            </tr>

        </table>





    </div>

    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>

        <asp:HiddenField ID="Feature" runat="server" />


    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>

    <script type="text/javascript">
     
    </script>

</asp:Content>
