﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="../WebAppPanel.master" validateRequest="false" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ServoSecSSO.aspx.cs" Inherits="GladinetPayFlow.ServoSecSSO"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }
        .disabledRow {
            color: lightgray;
        } 
        .enabledRow {
            color: black;
        }
        #<%=SSOName.ClientID%>:disabled {
            background-color: transparent;
            color: lightgray;
        }
    </style>
    <script type="text/javascript">

     

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }

        function ReturnLast() {
            parent.CloseLeftMain();
        }

        function EnableNow() {
            window.location = "ServoSecSSOCfg.aspx?vdid=<%=SessionDomainId%>";
        }

        function EditSettings()
        {
            var e = document.getElementById("summarytable");
            e.style.display = "none";

            e = document.getElementById("settingtable");
            e.style.display = "";
        }

        function StopEditSettings() {
            var e = document.getElementById("summarytable");
            e.style.display = "";

            e = document.getElementById("settingtable");
            e.style.display = "none";
        }

        function MyReturnLast()
            {
                
                window.location = "<%=GetLastSubPage("RootInfo.aspx")%>";
        }

        function copyToClipboard(text) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    showAlertMessge("<asp:Localize meta:resourcekey="str_linCopToCli" runat="server">Link copied to clipboard</asp:Localize>");

                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        showAlertMessge("<asp:Localize meta:resourcekey="str_linCopToCli" runat="server">Link copied to clipboard</asp:Localize>");
                    } catch (ex) {
                        console.warn("<asp:Localize meta:resourcekey="str_copToCliFai" runat="server">Copy to clipboard failed.</asp:Localize>", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }     
        function toggleWelcomeControl(autoCreateCtlRef){

            if(autoCreateCtlRef.checked){
                $("#welcomeEmailLabel").css("color","black");   
                $("#<%=SAMLAutoCreateUserSendWelcomeEmail.ClientID %>").removeAttr("disabled");
            }else{ 
                $("#welcomeEmailLabel").css("color","lightgray");        
                $("#<%=SAMLAutoCreateUserSendWelcomeEmail.ClientID %>").prop("checked", false);
                $("#<%=SAMLAutoCreateUserSendWelcomeEmail.ClientID %>").attr("disabled", true);
            }
        }
    </script>

</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">      
<asp:Localize ID="LocFaiToParIdPMet" meta:resourcekey="str_faiToParIdPMet" runat="server" Visible="False">Failed to parse IdP Metadata:</asp:Localize>
    <asp:Localize ID="LocCon" meta:resourcekey="str_con" runat="server" Visible="False">Configured</asp:Localize>
<asp:Localize runat="server" ID="LocMisIdpMet" meta:resourcekey="str_misIdpMet" Visible="false">Missing IdP Metadata</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaIdpMetDatFedMetDoc" meta:resourcekey="str_faiToLoaIdpMetDatFedMetDoc" Visible="false">Failed to load IdP Meta Data (Federation Metadata Document)</asp:Localize>
<asp:Localize runat="server" ID="LocFulQuaDomNamIsEmp" meta:resourcekey="str_fulQuaDomNamIsEmp" Visible="false">Fully Qualified Domain Name is empty</asp:Localize>
<asp:Localize runat="server" ID="LocDirIdIsEmp" meta:resourcekey="str_dirIdIsEmp" Visible="false">Directory ID is empty</asp:Localize>
    <asp:Localize id="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>
    <div style="width: 100%; padding: 5px;height:60px; border-bottom:1px solid #cccccc;" class="meubardrop1">
        <table style="width: 100%">
            <tr>
                <td height="60px" valign="middle" >
                    <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize runat="server" meta:resourcekey="str_sinSig">Single Sign On</asp:Localize></span>
                </td>
                <td align="right" style="padding-right: 10px;" valign="middle">
                    <div class="sectextcolor" style="width: 40px; font-size: 32px; font-weight: 100; cursor: pointer; padding-top: 5px;" onclick="MyReturnLast();">&times;</div>
                </td>
            </tr>
        </table>
    </div>
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>  
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;   
                <%
                    EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                %>
            </div>
            </nav>
   
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 30px;font-size: 18px; align-content:center;">
        <%if (!SAMLAuthentication.Checked){%>
        <table width="100%"  style="max-width:1400px;" align="center">
            <tr>
                <td style="padding:10px; padding-top:100px; font-size:24px; font-weight:100; color:#404040;" align="center"><asp:Localize runat="server" meta:resourcekey="str_sinSigHasNotBee">Single Sign On has not been enabled.</asp:Localize></td>
            </tr>
            <tr>
                <td style="padding:10px; padding-top:10px; font-size:16px; font-weight:100; color:#404040;" align="center">
                    <asp:Localize meta:resourcekey="str_spmeta" runat="server">Access service provider meta data using the following link:</asp:Localize><br/>
                     <a target="_blank" href="<%=MetaDataUrl.Text %>"><asp:Label ID="MetaDataUrl" runat="server" Text="" ></asp:Label>  </a>
                </td>
            </tr>
                        <tr>
                <td style="padding:10px; padding-top:10px; font-size:16px; font-weight:100; color:#404040;" align="center">
                    <asp:LinkButton CssClass="" ID="EnableNowButton" runat="server" ToolTip="Enable Now" OnClientClick="EnableNow();return false;"><span class="gladrootbtn gladinet-icons" style="font-size:64px!important">&#x15B;</span></asp:LinkButton>
                </td>
                            </tr>

        </table>
        <%}else { %>
     <table width="100%"  style="max-width:1400px;" align="center" id="summarytable">
         <tr>
                <td style="padding:10px; padding-top:100px; font-size:24px; font-weight:100; color:#404040;" align="center">
                    <asp:Localize runat="server" meta:resourcekey="str_sinSigOnEna">Single Sign On is enabled.</asp:Localize><asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton3"  runat="server" ToolTip="Settings" OnClientClick="EditSettings();return false;"><i class="gladinet-icons md-32 md-dark hand center toolbtnb">g</i></asp:LinkButton>
                </td>
            </tr>
         <tr>
                <td style="padding:10px; padding-top:10px; font-size:16px; font-weight:100; color:#404040;" align="center">
                    <asp:Localize meta:resourcekey="str_spmeta" runat="server">Access service provider meta data using the following link:</asp:Localize><br/>
                     <a target="_blank" href="<%=MetaDataUrl.Text %>"><%=MetaDataUrl.Text %>  </a>
                </td>
            </tr>
         <tr>
             <td style="padding:10px; padding-top:10px; font-size:16px; font-weight:100; color:#404040;" align="center">
                 <asp:Label ID="Label1" runat="server" Text="Enable SAML Authentication" Visible="false" meta:resourcekey="str_eblSMLAth"></asp:Label>
                 <asp:Localize meta:resourcekey="str_ssolink" runat="server">Access single sign on functionality using the following link:</asp:Localize>
                     <br /><span style="color:black"><asp:Label ID="LoginPageUrl" runat="server" Text="" ></asp:Label></span>  
                     
                     <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" onclick='copyToClipboard("<%=LoginPageUrl.Text %>")'>&#0192;</i>
                 
             </td>

            </tr>
         
                        <tr>
                <td style="padding:10px; padding-top:10px; font-size:16px; font-weight:100; color:#404040;" align="center">
                    <asp:LinkButton CssClass="" ID="DisableSSO"  runat="server" ToolTip="Disable" OnClick="DisableSSO_Click"><span class="gladinet-icons gladrootbtn" style="font-size:64px!important">&#x15A;</span></asp:LinkButton>
                    <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton1"  runat="server" Visible="false" OnClientClick="EditSettings();return false;" meta:resourcekey="str_set">Settings</asp:LinkButton>
                </td>
                            </tr>

         <tr style="display:none;">
             <td style="padding: 15px;">
                 <asp:CheckBox  ID="SAMLAuthentication" runat="server"  />
             </td>
         </tr>
         </table>
        <table width="100%"  style="max-width:1000px; display:none;" align="center" id="settingtable">
         
            <tr style="border-bottom:1px solid #cccccc; padding-top:30px;">
                <td colspan="2" style="font-size:20px; font-weight:200; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_sinSigSet">Single Sign On Settings</asp:Localize></td>
            </tr>
         <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_samlprovider" runat="server">SSO Provider</asp:Localize>

                </td>
                <td style="padding: 15px;">
                    <asp:DropDownList ID="SSOProviderList" runat="server" CssClass="browser-default custom-select secsubbordercolor" OnSelectedIndexChanged="SSOProviderList_SelectedIndexChanged" AutoPostBack="true"></asp:DropDownList>
                </td>
             
            </tr>

         <%if (SSOProviderList.SelectedIndex == 0) { %>
         <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="azuretenantid" runat="server">Azure AD Directory ID</asp:Localize>

                </td>
                <td style="padding: 15px;">
                     <asp:TextBox   ID="AzureTenantID" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                </td>
             
            </tr>
         <%}else if (SSOProviderList.SelectedIndex == 1) { %>
          <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_fqdn" runat="server">Fully Qualified Domain Name</asp:Localize>

                </td>
                <td style="padding: 15px;">
                     <asp:TextBox   ID="ADFSFQDN" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                </td>
             
            </tr>
         <%}else if (SSOProviderList.SelectedIndex == 2) { %>
         <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpurl" runat="server">IdP End Point URL</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpurlh" runat="server">URL of the Identity Provider that the Service Provider must contact.</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox   ID="SAMLUrl" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSAMLUrl" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            
            <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpemail" runat="server">IdP Email Parameter</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpemailh" runat="server">Email Parameter Name in Identity Provider</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox   ID="SAMLEmail" runat="server" Text="" CssClass="form-control" ></asp:TextBox>
                     <asp:Label ID="LSAMLEmail" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpfname" runat="server">IdP Given Name Parameter</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpfnameh" runat="server">Given Name Parameter Name in Identity Provider</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox   ID="SAMLFirstName" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSAMLFirstName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
                <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpsname" runat="server">IdP Surname Parameter</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idpsnameh" runat="server">SurName Parameter Name in Identity Provider</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox   ID="SAMLLastName" runat="server" Text="" CssClass="form-control" ></asp:TextBox>
                     <asp:Label ID="LSAMLLastName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>            
            <tr style="border-bottom:1px solid #f0f0f0;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_idpm" runat="server">IdP Meta Data</asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_idtPrvMetXml" runat="server">Identity Provider Metadata in XML Format</asp:Localize>
                    </p>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox   ID="SAMLIDPMeta" runat="server" Text="" TextMode="MultiLine"  Height="300px" CssClass="form-control" BorderStyle="Solid" BorderWidth="1" BorderColor="#f0f0f0"></asp:TextBox>
                     <asp:Label ID="LSAMLIDPMeta" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
            <%}%>
        <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" Text="Add SSO link to login page" meta:resourcekey="str_addSsoLnkLgnPag"></asp:Label>
                                    <p class="text-muted" style="font-size: smaller">
                                        <asp:Localize meta:resourcekey="str_llink" runat="server">if this setting is unchecked, the login page will be redirected to the IdP login page directly</asp:Localize>
                                    </p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox  ID="AddSSOLink" runat="server" onclick="toggleDisplayText()" />
             </td>
         </tr>

            
        <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label4" runat="server" Text="Force SAML login for AD users" meta:resourcekey="str_forceSAML"></asp:Label>
                                 
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="ForceSMAL" runat="server" onclick="toggleDisplayText();" />
             </td>
         </tr>

             <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label5" runat="server" Text="Use default browser to host login pages for native clients" meta:resourcekey="str_DefaultBrowser"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="SAMLDefaultBrowser" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr style="border-bottom:1px solid #f0f0f0;" id="displayTextRow">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="str_ssotext" runat="server">Display text for SSO link</asp:Localize>

                </td>
                <td style="padding: 15px;">
                    <asp:TextBox   ID="SSOName" runat="server" Text="" CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LSSOName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                </td>
            </tr>
         <tr>
             <td style="padding: 15px;">
                 <asp:Label ID="Label3" runat="server" Text="Create User when User Doesn't Exist" meta:resourcekey="asp_crtUsrWhnDntExt"></asp:Label>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox  ID="SAMLAutoCreateUser" runat="server" onclick="toggleWelcomeControl(this)" />
             </td>
         </tr>    
         <tr>
             <td style="padding: 5px 15px 15px 50px;" id="welcomeEmailLabel">
                 <asp:Label runat="server" meta:resourcekey="str_senWelEmaUpoCrea" Text="Send Welcome Email Upon Creation"></asp:Label>
             </td>
             <td style="padding: 5px 15px 15px 15px;">
                 <asp:CheckBox  ID="SAMLAutoCreateUserSendWelcomeEmail" runat="server" Checked="true" />
             </td>
         </tr>   
         <tr  style="border-bottom:1px solid #f0f0f0;">
             <td style="padding:0px;" colspan="2">
             </td>
         </tr>

             <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_skpLgnNtf" runat="server">Skip Login for NTFS impersonation</asp:Localize>
                <p class="text-muted" style="font-size: smaller">
                    <asp:Localize meta:resourcekey="str_skpLgnNtfHlp" runat="server">A second login screen is displayed immediately after successful SSO authentication to ensure correct impersonation for NTFS permissions. You can skip the second login if you do not need NTFS impersonation.</asp:Localize>
                </p>

            </td>
            <td style="padding: 15px;">
                 <asp:CheckBox ID="SSOSkipNTFSLogin" runat="server" />
            </td>
        </tr>
            <tr >
                <td colspan="2" align="right" style="padding-top:30px;">
                       <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step1Contine" runat="server" OnClick="ApplylNow_Click" meta:resourcekey="str_app">Apply</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton2" runat="server" OnClientClick="StopEditSettings();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                </td>
                </tr>
        </table>
            <%} %>
    </div>
    <asp:Localize ID="NOTConfig"  meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:CheckBox  ID="ShowSecurityOption" runat="server" Text="Show 'Security' Option."
                                    meta:resourcekey="ShowSecurityOption" /><br />
                                <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string6_1" runat="server" Text="When this setting is checked, you will be able to grant normal user permissions to manage certain parts of the tenant"></asp:Localize></p>
    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>
    <script type="text/javascript">
        
        function toggleDisplayText() {
            if ($("#<%=AddSSOLink.ClientID%>")[0].checked) {
                $("#displayTextRow").removeClass("disabledRow"); 
                $("#displayTextRow").addClass("enabledRow");
                $("#<%=SSOName.ClientID%>").removeAttr("disabled");
            } else {
                $("#displayTextRow").removeClass("enabledRow");
                $("#displayTextRow").addClass("disabledRow");
                $("#<%=SSOName.ClientID%>").attr("disabled", "disabled");

            }     
        }
        
        Ext.onReady(function () {    
            toggleDisplayText();

            <% if (m_ChangeProvider){ %>
            EditSettings();
            <% } %>            

            <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
            gWMsgBox("<%=ErrorMsg.Text%>");
            EditSettings();
            <% } %>   

            toggleWelcomeControl($("#<%=SAMLAutoCreateUser.ClientID %>")[0]);         

            });
        
        </script>
</asp:Content>
