﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ServoLDAPCfgPage.aspx.cs" Inherits="GladinetPayFlow.ServoLDAPCfgPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">
    </script>
    <style type="text/css">
        .badgefont {
            font-size: 15px;
        }

        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        label {
            font-weight: 100 !important;
            font-size: 16px !important;
        }

        .policygroup {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }

        li {
            background-color: transparent;
            font-size: 18px;
            color: #565656 !important;
            font-weight: 100 !important;
            padding-right: 10px !important;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);


        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function EnableNow() {
            window.location = "ServoLDAPEnable.aspx?child=1&vdid=<%=SessionDomainId%>";
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelAddUser() {
            parent.closeCancelActiveWin();
        }

        function SetPage(p) {
            var e = document.getElementById("page_1");
            e.className = "";

            e = document.getElementById("page_2");
            e.className = "";

            e = document.getElementById("page_" + p);
            e.className = "active";

            e = document.getElementById("page_1_div");
            e.style.display = "none";

            e = document.getElementById("page_2_div");
            e.style.display = "none";

            e = document.getElementById("page_"+p+"_div");
            e.style.display = "";

        }

        function AddNewDomain() {
            activewin = new Ext.Window({
                id: 'ldap_win',
                title: "<asp:Localize meta:resourcekey="str_addAdDmn" runat="server">Add AD Domain</asp:Localize>",
                width: 850,
            height: maxh(680),
            plain: true,
            modal: true,
            maximizable: true,
            maximized: false,
            constrainHeader: true,
            constrain: true,
            layout: 'fit',
            bodyPadding: 3,
            html: "<iframe id='openwin' src='/management/LDAPDomainCfgPage.aspx?c=1&r=close&g=<%=SettingId.Value %>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();


            }

            function EditDomain(Svr) {
                activewin = new Ext.Window({
                    id: 'ldap_edit_win',
                    title: "<asp:Localize meta:resourcekey="str_edtDmn" runat="server">Edit Domain</asp:Localize>",
                    width: 850,
                height: maxh(680),
                plain: true,
                modal: true,
                maximizable: true,
                maximized: false,
                constrainHeader: true,
                constrain: true,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='/management/LDAPDomainCfgPage.aspx?c=1&r=close&g=<%=SettingId.Value %>&s=" + Svr + "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();


            }


            function DeleteDomain(svr) {

                var e = document.getElementById("ctl00_MainContent_SvrName");
                e.value = svr;

                e = document.getElementById("ctl00_MainContent_DeleteSvr");
                e.click();

            }

            function MyWait() {
                Wait("<asp:Localize meta:resourcekey="str_verify" runat="server">Verifying Settings...</asp:Localize>");
            }
            function encodePwd() {
                MyWait();
                var dPwdTb = document.getElementById('PasswordDisplay');
                var pwdTb = document.getElementById('<%= Password.ClientID %>');
                pwdTb.value = encodeURIComponent(dPwdTb.value);
                dPwdTb.value = "";
            }
            function MyReturnLast()
            {
                
                window.location = "<%=GetLastSubPage("RootInfo.aspx")%>";
            }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocSetSavSuc" meta:resourcekey="str_setSavSuc" Visible="false" runat="server">Settings saved successfully</asp:Localize>
   <asp:Localize ID="LocSetCanBeVer" meta:resourcekey="str_setCanBeVer" Visible="false" runat="server">Settings cannot be verified:</asp:Localize>
    <div style="width: 100%; padding: 5px;height:60px; border-bottom:1px solid #cccccc;" class="meubardrop1">
        <table style="width: 100%">
            <tr>
                <td height="60px" valign="middle" >
                    <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize runat="server" meta:resourcekey="str_actDir">Active Directory</asp:Localize></span>
                </td>
                <td>
                    <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                        { %>
                    <div class="alert alert-warning  " style="padding-top: 2px;" id='errmsgdiv' role="alert">
                        <a href="javascript:;" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                        <b>
                            <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" ></asp:Label>
                        </b>
                    </div>

                    <%} %>
                </td>
                <td align="right" style="padding-right: 10px;" valign="middle" >
                    <div class="sectextcolor" style="width: 40px; font-size: 32px; font-weight: 100; cursor: pointer; padding-top: 5px;" onclick="MyReturnLast();">&times;</div>
                </td>
            </tr>
        </table>
    </div>

    <div class="wrapper" style="background-color: white; width: 100%; margin-top: 10px; font-size: 16px; padding: 30px;">
        <%if (!UseLDAP.Checked)
            {%>
        <table width="100%" style="max-width: 1400px;" align="center">
            <tr>
                <td style="padding: 10px; padding-top: 100px; font-size: 24px; font-weight: 100; color: #404040;" align="center"><asp:Localize runat="server" meta:resourcekey="str_actDirIntHasNot">Active Directory Integration has not been enabled.</asp:Localize></td>
            </tr>

            <tr>
                <td style="padding: 10px; padding-top: 10px; font-size: 16px; font-weight: 100; color: #404040;" align="center">
                    <asp:LinkButton CssClass="" ID="EnableNowButton" runat="server" ToolTip="Enable Now"  OnClientClick="EnableNow();return false;"><span class="gladinet-icons gladrootbtn" style="font-size:64px!important">&#x15B;</span></asp:LinkButton>
                </td>
            </tr>

        </table>
        <%}
            else
            { %>
        <table width="100%" style="max-width: 1400px;" align="center" id="summarytable">
            <tr>
                <td style="padding: 10px; padding-top: 100px; font-size: 24px; font-weight: 100; color: #404040;" align="center">
                    <asp:Localize runat="server" meta:resourcekey="str_actDirIntEna">Active Directory Integration is enabled.</asp:Localize><asp:LinkButton CssClass="btn btn-primary gladbtn" ID="LinkButton3"  runat="server" ToolTip="Settings" OnClientClick="EditSettings();return false;"><i class="gladinet-icons md-32 md-dark hand center toolbtnb">g</i></asp:LinkButton>
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; padding-top: 10px; font-size: 24px; font-weight: 100; color: #404040;" align="center">
                    <asp:Label ID="LLDAPSvr" runat="server" meta:resourcekey="str_notbranded" CssClass="badge"></asp:Label>
                    <asp:Label ID="LUserName" runat="server" meta:resourcekey="str_notbranded" CssClass="badge"></asp:Label>
                    <asp:Label ID="LDomain" runat="server" meta:resourcekey="str_notbranded" CssClass="badge"></asp:Label>
                </td>
            </tr>



            <tr>
                <td style="padding: 10px; padding-top: 40px; font-size: 16px; font-weight: 100; color: #404040;" align="center">
                    <asp:LinkButton CssClass="" ID="DisableNow" runat="server" ToolTip="Disable" OnClientClick="ConfirmDisable();return false;"><span class="gladinet-icons gladrootbtn" style="font-size:64px!important">&#x15A;</span></asp:LinkButton>
                    <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton1" runat="server" Visible="false" OnClientClick="EditSettings();return false;" meta:resourcekey="str_set">Settings</asp:LinkButton>
                </td>
            </tr>

        </table>
        <%} %>
    </div>

    <table style="width: 100%; max-width: 1400px; font-size: 16px; display: none;" align="center" id="settingtable">
        <tr style="border-bottom: 0px solid #f0f0f0; display: none;" class="filerow">
            <td style="padding: 5px" colspan="2">
                <asp:CheckBox ID="UseLDAP" runat="server" Text="Enable Active Directory Integration"
                    meta:resourcekey="UseLDAPResource1" />
            </td>
        </tr>
        <tr style="border-bottom: 1px solid #f0f0f0" class="filerow">
            <td style="padding: 5px; width: 600px;">
                <asp:Localize meta:resourcekey="asp_string1" runat="server" Text="Domain Controller or LDAP Server Address (myhost:389)"></asp:Localize><asp:RequiredFieldValidator
                    ControlToValidate="LDAPSvr" ID="RequiredFieldValidator1" runat="server" ErrorMessage="Required"
                    Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
            </td>
            <td style="padding: 5px">
                <asp:TextBox ID="LDAPSvr" Width="100%" runat="server" CssClass="form-control"
                    meta:resourcekey="LDAPSvrResource1"></asp:TextBox>


            </td>
        </tr>
        <tr style="border-bottom: 1px solid #f0f0f0" class="filerow">
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string2" runat="server" Text="User name (used to connect to your Active Directory Service)"></asp:Localize>
                <asp:Localize ID="LocReq" meta:resourcekey="str_req" runat="server" Visible="False">Required</asp:Localize>

                <asp:RequiredFieldValidator
                    ControlToValidate="UserName" ID="RequiredFieldValidator2" runat="server" Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                <%
                    RequiredFieldValidator2.ErrorMessage = LocReq.Text;
                %>
            </td>
            <td style="padding: 5px">
                <asp:TextBox ID="UserName" Width="100%" runat="server" CssClass="form-control"
                    meta:resourcekey="UserNameResource1"></asp:TextBox>

            </td>
        </tr>
        <tr style="border-bottom: 1px solid #f0f0f0" class="filerow">
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string3" runat="server" Text="Password:"></asp:Localize><asp:RequiredFieldValidator
                    ControlToValidate="Password" ID="RequiredFieldValidator3" runat="server" Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
                <%
                    RequiredFieldValidator3.ErrorMessage = LocReq.Text;
                %>
            </td>
            <td style="padding: 5px">
                <input type="password" id="PasswordDisplay" style="width:100%" class="form-control" />
                <div style="display:none">
                <asp:TextBox ID="Password" Width="100%" runat="server" TextMode="Password" CssClass="form-control"
                    meta:resourcekey="PasswordResource1"></asp:TextBox>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="2" style="padding-top:30px; border-bottom:1px solid #f0f0f0;">
                <table width="100%">
                    <tr style="display:none;">
                        <td>
                            <table width="100%">
                                <tr>
                                    <td style="padding: 5px; width: 200px;" nowrap="nowrap">
                                        <asp:Localize meta:resourcekey="asp_string4" runat="server" Text="Friendly Domain Name (i.e. mydomain.com, the domain name you see in Active Directory tools)"></asp:Localize>
                                    </td>
                                    <td style="padding: 5px">
                                        <asp:TextBox ID="Domain" Width="100%" runat="server" CssClass="form-control"
                                            meta:resourcekey="DomainResource1"></asp:TextBox>

                                    </td>

                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr >
                        <td style="padding: 5px" colspan="2">
                            <asp:Localize ID="Localize2" meta:resourcekey="asp_string5" runat="server" Text="Only include users and groups from the following Organizational Units (e.g. OU=ou1,OU=ou2.
                    Leave this blank to include all OUs)"></asp:Localize><br />
                            <asp:TextBox ID="ScopeOU" Width="100%" runat="server" CssClass="form-control"
                                meta:resourcekey="ScopeOUResource1"></asp:TextBox>
                            
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 5px; width:50%;">
                            <asp:CheckBox ID="LDAPS" runat="server" Text="Enable LDAPS for secure access" meta:resourcekey="LDAPSResource1" />
                        </td>
                  
                        <td style="padding: 5px">
                            <asp:CheckBox ID="AllowGC" runat="server" Text="Allow Switching to Global Catalog If needed"
                                meta:resourcekey="AllowGCResource1" />
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 5px">
                            <asp:CheckBox ID="RecursiveGroupCheck" runat="server" Text="Disable Nested Groups (Enabling it may slow down your access to cloud)"
                                meta:resourcekey="RecursiveGroupCheck" />
                        </td>
                  
                        <td style="padding: 5px">
                            <asp:CheckBox ID="ForestRoot" runat="server" Text="This is the root of the AD Forest and contains multiple sub-domains"
                                meta:resourcekey="ForestRoot" />(<asp:CheckBox ID="NoDomainIP" runat="server" Text="Discover domain controller IP at runtime"
                                    meta:resourcekey="NoDomainIPResource1" />)
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 5px">
                            <asp:CheckBox ID="NoUserAutoCreation" runat="server" meta:resourcekey="NoUserAutoCreation"
                                Text="Don't allow user auto-creation" />
                        </td>
                  
                        <td style="padding: 5px; padding-bottom: 1px;">
                            <br />
                            <asp:Localize ID="Localize1" meta:resourcekey="asp_string10" runat="server" visible="false" Text="When unchecked, the user home drive space will be allocated from enterprise storage. When checked, existing user home drives will be automatically published from Active Directory."></asp:Localize>
                        </td>
                    </tr>
                    <tr style="display: none">
                        <td style="padding: 5px">
                            <asp:CheckBox ID="sAMAccountNameFirst" runat="server" Text="Authenticate with the user's sAMAccountName first"
                                 meta:resourcekey="sAMAccountNameFirstResource1" />
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
        <tr style="border-bottom: 1px solid #f0f0f0">
            <td colspan="2">
                <table>
                    <tr>
                                    <td style="padding: 5px;" colspan="2">
                                                                    <asp:CheckBox ID="LDAPHomeDrive" Checked="true" runat="server" Text="Publish user's home drive as root folder with name:"
                                Font-Bold="True" meta:resourcekey="LDAPHomeDriveResource1" />
                                     
                                        
                                        
                                    </td>
                               
                                   
                                    <td style="padding: 15px;">
                                        <asp:TextBox ID="RootDriveName" runat="server"  Text="" Width="400px" CssClass="form-control"></asp:TextBox>              
                                        <asp:Label ID="LRootDriveName" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>                                                        
                                    </td>
                                </tr>
                </table>
                        <tr style="display: none;">
                           
                                    <td style="padding: 15px; padding-left: 30px;">
                                        <asp:Localize meta:resourcekey="str_mountastopfolder" runat="server">Mount user's home drive as a top level folder.</asp:Localize>
                                    </td>
                                    <td style="padding: 15px;">
                                        <asp:CheckBox  ID="RootHomeDrive" runat="server" Text=""  />        
                                                                                                                
                                    </td>
                                </tr>
                        <tr style="display: none;">
                            <td colspan="2"></td>
                        </tr>
                        
            </td>
        </tr>
        <tr >
                <td colspan="2" align="right" style="padding-top:30px;">
                       <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step1Contine" runat="server" OnClick="ApplylNow_Click" OnClientClick="encodePwd();" meta:resourcekey="str_app">Apply</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton2" runat="server" OnClientClick="StopEditSettings();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                </td>
                </tr>

    </table>



    <asp:Localize meta:resourcekey="str_notbranded" runat="server" ID="Not_Branded" Visible="False">Not Configured</asp:Localize>
    <asp:HiddenField ID="CancelMode" runat="server" />
    <asp:HiddenField ID="SettingId" runat="server" />
    <asp:HiddenField ID="ReturnPage" runat="server" />
    <asp:HiddenField ID="SvrName" runat="server" />

    <div style="display:none;">
        <asp:Button ID="Button1" runat="server" Text="Button" onclick="Disable_Click"/>
    </div>

    <script type="text/javascript">
        function ConfirmDisable() {
            gConfirm("Are you sure you want to disable?", "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_Button1");
                    Wait("Applying Changes");
                    e.click();
                }
            });
        }
        function ReturnLast() {
            
            parent.CloseLeftMain();
            
        }
        function EditSettings() {
            var e = document.getElementById("summarytable");
            e.style.display = "none";

            e = document.getElementById("settingtable");
            e.style.display = "";
        }

        function StopEditSettings() {
            var e = document.getElementById("summarytable");
            e.style.display = "";

            e = document.getElementById("settingtable");
            e.style.display = "none";
        }
        <%if(mEnableSettings){%>
        EditSettings();
        <%} %>
    </script>
</asp:Content>
